/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.database.vo;

import java.util.List;

public enum PaymentType {
    DTAUS(true),
    DTAZV,
    SEPA,
    CFONB160,
    CFONB320,
    SWIFT,
    MANDATE,
    MT101,
    SEPA_FOREIGN,
    AUSTRIAN_TAX_OFFICE,
    AUSTRIAN_POSTBAR,
    SWISS_ESR(true),
    SWISS_POST_ACCOUNT(true),
    SWISS_IID(true),
    CHEQUE,
    SWISS_DOMESTIC(true);

    private final boolean isObsolete;

    private PaymentType() {
        this(false);
    }

    private PaymentType(boolean isObsolete) {
        this.isObsolete = isObsolete;
    }

    public static List<PaymentType> getNonObsoletePaymentTypes() {
        return List.of(PaymentType.values()).stream().filter(x -> !x.isObsolete).toList();
    }
}

