/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.database.vo;

import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.PaymentType;
import de.businesslogics.banking.database.vo.Scheduler;
import io.ebean.Update;
import io.ebean.bean.EntityBean;
import io.ebean.bean.EntityBeanIntercept;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

@Entity
@Table(name="pmt_transfer_type")
public class PaymentTransferType
implements EntityBean {
    private static String ServiceLevel_SEPA;
    private static String ServiceLevel_URGP;
    @Id
    private Integer id;
    @ManyToOne(optional=false)
    private BankSettings bank;
    private PmtType pmtType;
    @Column(length=50)
    private String orderType;
    @Column(length=50)
    private String btf;
    @Column(length=50)
    private String orderTypeVop;
    @Column(length=50)
    private String btfVop;
    @Column(length=50)
    private String format;
    public static /* synthetic */ String[] _ebean_props;
    protected /* synthetic */ EntityBeanIntercept _ebean_intercept;
    protected transient /* synthetic */ Object _ebean_identity;

    public PaymentTransferType(BankSettings bank, PmtType pmtType, String orderType, String btf) {
        this._ebean_intercept = new EntityBeanIntercept((Object)this);
        this._ebean_set_bank(bank);
        this._ebean_set_pmtType(pmtType);
        this._ebean_set_orderType(orderType);
        this._ebean_set_btf(btf);
    }

    public PaymentTransferType(BankSettings bank, PmtType pmtType, String orderType, String btf, String orderTypeVop, String btfVop) {
        this._ebean_intercept = new EntityBeanIntercept((Object)this);
        this._ebean_set_bank(bank);
        this._ebean_set_pmtType(pmtType);
        this._ebean_set_orderType(orderType);
        this._ebean_set_btf(btf);
        this._ebean_set_orderTypeVop(orderTypeVop);
        this._ebean_set_btfVop(btfVop);
    }

    public PmtType getPmtType() {
        return this._ebean_get_pmtType();
    }

    public void setPmtType(PmtType pmtType) {
        this._ebean_set_pmtType(pmtType);
    }

    public String getOrderType() {
        return this._ebean_get_orderType();
    }

    public void setOrderType(String orderType) {
        this._ebean_set_orderType(orderType);
    }

    public String getBtf() {
        return this._ebean_get_btf();
    }

    public void setBtf(String btf) {
        this._ebean_set_btf(btf);
    }

    public String getOrderTypeVop() {
        return this._ebean_get_orderTypeVop();
    }

    public void setOrderTypeVop(String orderTypeVop) {
        this._ebean_set_orderTypeVop(orderTypeVop);
    }

    public String getBtfVop() {
        return this._ebean_get_btfVop();
    }

    public void setBtfVop(String btfVop) {
        this._ebean_set_btfVop(btfVop);
    }

    public Scheme getScheme() {
        if (this._ebean_get_format() != null) {
            return Scheme.valueOf(this._ebean_get_format());
        }
        return null;
    }

    public void setScheme(Scheme scheme) {
        if (scheme != null) {
            this._ebean_set_format(scheme.name());
        } else {
            this._ebean_set_format(null);
        }
    }

    public void save() {
        DB.save(this);
    }

    public void update() {
        DB.update(this);
    }

    public void delete() {
        DB.delete(this);
    }

    public static int deleteAll(BankSettings bank) {
        Update<Scheduler> delete = DB.createUpdate(Scheduler.class, "DELETE FROM pmt_transfer_type WHERE bank_id=:bank");
        delete.setParameter("bank", (Object)bank.getBankId());
        return delete.execute();
    }

    public static PaymentTransferType findByBankAndPmtType(BankSettings bank, PmtType pmtType) {
        List paymentTransferTypes = DB.find(PaymentTransferType.class).where().eq("bank", (Object)bank).eq("pmtType", (Object)pmtType).findList();
        if (paymentTransferTypes != null && paymentTransferTypes.size() > 0) {
            return (PaymentTransferType)paymentTransferTypes.get(0);
        }
        return null;
    }

    private static List<PaymentTransferType> findByBank(BankSettings bank) {
        return DB.find(PaymentTransferType.class).where().eq("bank", (Object)bank).findList();
    }

    public static Map<PmtType, PaymentTransferType> findMapByBank(BankSettings bank) {
        HashMap<PmtType, PaymentTransferType> map = new HashMap<PmtType, PaymentTransferType>();
        List<PaymentTransferType> paymentTransferTypes = PaymentTransferType.findByBank(bank);
        if (paymentTransferTypes != null && paymentTransferTypes.size() > 0) {
            for (PaymentTransferType paymentTransferType : paymentTransferTypes) {
                map.put(paymentTransferType.getPmtType(), paymentTransferType);
            }
        }
        return map;
    }

    public static Scheme findSchemeByBankAndPmtType(BankSettings bank, PmtType pmtType) {
        List paymentTransferTypes = DB.find(PaymentTransferType.class).where().eq("bank", (Object)bank).eq("pmtType", (Object)pmtType).findList();
        if (paymentTransferTypes != null && paymentTransferTypes.size() > 0) {
            return ((PaymentTransferType)paymentTransferTypes.get(0)).getScheme();
        }
        return null;
    }

    static {
        _ebean_props = new String[]{"id", "bank", "pmtType", "orderType", "btf", "orderTypeVop", "btfVop", "format"};
        ServiceLevel_SEPA = "SEPA";
        ServiceLevel_URGP = "URGP";
    }

    public /* synthetic */ PaymentTransferType() {
        this._ebean_intercept = new EntityBeanIntercept((Object)this);
    }

    public /* synthetic */ String[] _ebean_getPropertyNames() {
        return _ebean_props;
    }

    public /* synthetic */ String _ebean_getPropertyName(int pos) {
        return _ebean_props[pos];
    }

    public /* synthetic */ EntityBeanIntercept _ebean_getIntercept() {
        return this._ebean_intercept;
    }

    public /* synthetic */ EntityBeanIntercept _ebean_intercept() {
        if (this._ebean_intercept == null) {
            this._ebean_intercept = new EntityBeanIntercept((Object)this);
        }
        return this._ebean_intercept;
    }

    protected /* synthetic */ Integer _ebean_get_id() {
        this._ebean_intercept.preGetId();
        return this.id;
    }

    protected /* synthetic */ void _ebean_set_id(Integer newValue) {
        this._ebean_intercept.preSetter(false, 0, (Object)this.id, (Object)newValue);
        this.id = newValue;
    }

    protected /* synthetic */ Integer _ebean_getni_id() {
        return this.id;
    }

    protected /* synthetic */ void _ebean_setni_id(Integer _newValue) {
        this.id = _newValue;
        this._ebean_intercept.setLoadedProperty(0);
    }

    protected /* synthetic */ BankSettings _ebean_get_bank() {
        this._ebean_intercept.preGetter(1);
        return this.bank;
    }

    protected /* synthetic */ void _ebean_set_bank(BankSettings newValue) {
        this._ebean_intercept.preSetter(true, 1, (Object)this._ebean_get_bank(), (Object)newValue);
        this.bank = newValue;
    }

    protected /* synthetic */ BankSettings _ebean_getni_bank() {
        return this.bank;
    }

    protected /* synthetic */ void _ebean_setni_bank(BankSettings _newValue) {
        this.bank = _newValue;
        this._ebean_intercept.setLoadedProperty(1);
    }

    protected /* synthetic */ PmtType _ebean_get_pmtType() {
        this._ebean_intercept.preGetter(2);
        return this.pmtType;
    }

    protected /* synthetic */ void _ebean_set_pmtType(PmtType newValue) {
        this._ebean_intercept.preSetter(true, 2, (Object)this._ebean_get_pmtType(), (Object)newValue);
        this.pmtType = newValue;
    }

    protected /* synthetic */ PmtType _ebean_getni_pmtType() {
        return this.pmtType;
    }

    protected /* synthetic */ void _ebean_setni_pmtType(PmtType _newValue) {
        this.pmtType = _newValue;
        this._ebean_intercept.setLoadedProperty(2);
    }

    protected /* synthetic */ String _ebean_get_orderType() {
        this._ebean_intercept.preGetter(3);
        return this.orderType;
    }

    protected /* synthetic */ void _ebean_set_orderType(String newValue) {
        this._ebean_intercept.preSetter(true, 3, (Object)this._ebean_get_orderType(), (Object)newValue);
        this.orderType = newValue;
    }

    protected /* synthetic */ String _ebean_getni_orderType() {
        return this.orderType;
    }

    protected /* synthetic */ void _ebean_setni_orderType(String _newValue) {
        this.orderType = _newValue;
        this._ebean_intercept.setLoadedProperty(3);
    }

    protected /* synthetic */ String _ebean_get_btf() {
        this._ebean_intercept.preGetter(4);
        return this.btf;
    }

    protected /* synthetic */ void _ebean_set_btf(String newValue) {
        this._ebean_intercept.preSetter(true, 4, (Object)this._ebean_get_btf(), (Object)newValue);
        this.btf = newValue;
    }

    protected /* synthetic */ String _ebean_getni_btf() {
        return this.btf;
    }

    protected /* synthetic */ void _ebean_setni_btf(String _newValue) {
        this.btf = _newValue;
        this._ebean_intercept.setLoadedProperty(4);
    }

    protected /* synthetic */ String _ebean_get_orderTypeVop() {
        this._ebean_intercept.preGetter(5);
        return this.orderTypeVop;
    }

    protected /* synthetic */ void _ebean_set_orderTypeVop(String newValue) {
        this._ebean_intercept.preSetter(true, 5, (Object)this._ebean_get_orderTypeVop(), (Object)newValue);
        this.orderTypeVop = newValue;
    }

    protected /* synthetic */ String _ebean_getni_orderTypeVop() {
        return this.orderTypeVop;
    }

    protected /* synthetic */ void _ebean_setni_orderTypeVop(String _newValue) {
        this.orderTypeVop = _newValue;
        this._ebean_intercept.setLoadedProperty(5);
    }

    protected /* synthetic */ String _ebean_get_btfVop() {
        this._ebean_intercept.preGetter(6);
        return this.btfVop;
    }

    protected /* synthetic */ void _ebean_set_btfVop(String newValue) {
        this._ebean_intercept.preSetter(true, 6, (Object)this._ebean_get_btfVop(), (Object)newValue);
        this.btfVop = newValue;
    }

    protected /* synthetic */ String _ebean_getni_btfVop() {
        return this.btfVop;
    }

    protected /* synthetic */ void _ebean_setni_btfVop(String _newValue) {
        this.btfVop = _newValue;
        this._ebean_intercept.setLoadedProperty(6);
    }

    protected /* synthetic */ String _ebean_get_format() {
        this._ebean_intercept.preGetter(7);
        return this.format;
    }

    protected /* synthetic */ void _ebean_set_format(String newValue) {
        this._ebean_intercept.preSetter(true, 7, (Object)this._ebean_get_format(), (Object)newValue);
        this.format = newValue;
    }

    protected /* synthetic */ String _ebean_getni_format() {
        return this.format;
    }

    protected /* synthetic */ void _ebean_setni_format(String _newValue) {
        this.format = _newValue;
        this._ebean_intercept.setLoadedProperty(7);
    }

    public /* synthetic */ Object _ebean_getField(int index) {
        switch (index) {
            case 0: {
                return this.id;
            }
            case 1: {
                return this.bank;
            }
            case 2: {
                return this.pmtType;
            }
            case 3: {
                return this.orderType;
            }
            case 4: {
                return this.btf;
            }
            case 5: {
                return this.orderTypeVop;
            }
            case 6: {
                return this.btfVop;
            }
            case 7: {
                return this.format;
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    public /* synthetic */ Object _ebean_getFieldIntercept(int index) {
        switch (index) {
            case 0: {
                return this._ebean_get_id();
            }
            case 1: {
                return this._ebean_get_bank();
            }
            case 2: {
                return this._ebean_get_pmtType();
            }
            case 3: {
                return this._ebean_get_orderType();
            }
            case 4: {
                return this._ebean_get_btf();
            }
            case 5: {
                return this._ebean_get_orderTypeVop();
            }
            case 6: {
                return this._ebean_get_btfVop();
            }
            case 7: {
                return this._ebean_get_format();
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    public /* synthetic */ void _ebean_setField(int index, Object o) {
        switch (index) {
            case 0: {
                this._ebean_setni_id((Integer)o);
                return;
            }
            case 1: {
                this._ebean_setni_bank((BankSettings)o);
                return;
            }
            case 2: {
                this._ebean_setni_pmtType((PmtType)((Object)o));
                return;
            }
            case 3: {
                this._ebean_setni_orderType((String)o);
                return;
            }
            case 4: {
                this._ebean_setni_btf((String)o);
                return;
            }
            case 5: {
                this._ebean_setni_orderTypeVop((String)o);
                return;
            }
            case 6: {
                this._ebean_setni_btfVop((String)o);
                return;
            }
            case 7: {
                this._ebean_setni_format((String)o);
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    public /* synthetic */ void _ebean_setFieldIntercept(int index, Object o) {
        switch (index) {
            case 0: {
                this._ebean_set_id((Integer)o);
                return;
            }
            case 1: {
                this._ebean_set_bank((BankSettings)o);
                return;
            }
            case 2: {
                this._ebean_set_pmtType((PmtType)((Object)o));
                return;
            }
            case 3: {
                this._ebean_set_orderType((String)o);
                return;
            }
            case 4: {
                this._ebean_set_btf((String)o);
                return;
            }
            case 5: {
                this._ebean_set_orderTypeVop((String)o);
                return;
            }
            case 6: {
                this._ebean_set_btfVop((String)o);
                return;
            }
            case 7: {
                this._ebean_set_format((String)o);
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private /* synthetic */ Object _ebean_getIdentity() {
        PaymentTransferType paymentTransferType = this;
        synchronized (paymentTransferType) {
            if (this._ebean_identity != null) {
                return this._ebean_identity;
            }
            Object tmpId = this._ebean_getField(0);
            this._ebean_identity = tmpId != null ? tmpId : new Object();
            return this._ebean_identity;
        }
    }

    public /* synthetic */ boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        return this._ebean_getIdentity().equals(((PaymentTransferType)obj)._ebean_getIdentity());
    }

    public /* synthetic */ int hashCode() {
        return this._ebean_getIdentity().hashCode();
    }

    public /* synthetic */ void _ebean_setEmbeddedLoaded() {
    }

    public /* synthetic */ boolean _ebean_isEmbeddedNewOrDirty() {
        return false;
    }

    public /* synthetic */ Object _ebean_newInstance() {
        return new PaymentTransferType();
    }

    public static enum PmtType {
        SEPA_TRANSFER("CCT", FormatType.pain001, PaymentType.SEPA, true, ServiceLevel_SEPA, false, true),
        SEPA_URGENT_TRANSFER("CCU", FormatType.pain001, PaymentType.SEPA, ServiceLevel_URGP),
        SEPA_INSTANT_TRANSFER("CIP", FormatType.pain001, PaymentType.SEPA, true, ServiceLevel_SEPA, false, true),
        SEPA_FOREIGN_CURRENCY_TRANSFER("XCT", FormatType.pain001, PaymentType.SEPA),
        SEPA_NON_SEPA_COUNTRY_TRANSFER("CCT", FormatType.pain001, PaymentType.SEPA, true, null, false, true),
        SEPA_FOREIGN_TRANSFER("AXZ", FormatType.pain001, PaymentType.SEPA_FOREIGN),
        SEPA_VIRTUAL_ACCOUNT_TRANSFER("XXC", FormatType.pain001, PaymentType.SEPA),
        SEPA_CORE_DIRECT_DEBIT("CDD", FormatType.pain008, PaymentType.MANDATE, ServiceLevel_SEPA),
        SEPA_COR1_DIRECT_DEBIT("CD1", FormatType.pain008, PaymentType.MANDATE, false),
        SEPA_B2B_DIRECT_DEBIT("CDB", FormatType.pain008, PaymentType.MANDATE, ServiceLevel_SEPA),
        DTAZV_TRANSFER("AZV", FormatType.dtazv, PaymentType.DTAZV),
        MT101_TRANSFER("RFT", FormatType.mt101, PaymentType.MT101),
        SWISS_ESR_TRANSFER("XE2", FormatType.pain001, PaymentType.SWISS_ESR),
        AUSTRIAN_TAX_PAYMENT("CCT", FormatType.pain001, PaymentType.AUSTRIAN_TAX_OFFICE, true, ServiceLevel_SEPA, false, true),
        AUSTRIAN_POSTBAR_PAYMENT("CCT", FormatType.pain001, PaymentType.AUSTRIAN_POSTBAR, true, ServiceLevel_SEPA, false, true),
        SWISS_SEPA_CORE_DIRECT_DEBIT("XE3", FormatType.pain008, PaymentType.MANDATE),
        SWISS_SEPA_B2B_DIRECT_DEBIT("XE4", FormatType.pain008, PaymentType.MANDATE),
        C55_CALLBACK("C55", FormatType.camt055, null, false, null, true),
        BBK_HBV_FOREIGN_TRANSFER_EUR("XDT", FormatType.bbk, PaymentType.SWIFT),
        BBK_HBV_FOREIGN_TRANSFER_NON_EUR("XWT", FormatType.bbk, PaymentType.SWIFT),
        BBK_HBV_TARGET2_TRANSFER("XTG", FormatType.bbk, PaymentType.SWIFT, false),
        BBK_HBV_DOMESTIC_SWIFT_TRANSFER("XG2", FormatType.bbk, PaymentType.SWIFT),
        BBK_HBV_DOMESTIC_DTA_TRANSFER("XG1", FormatType.bbk, PaymentType.DTAUS, false),
        BBK_EMZ_DTA_TRANSFER("XGK", FormatType.bbk, PaymentType.DTAUS, false),
        BBK_EMZ_DTA_DIRECT_DEBIT("XLK", FormatType.bbk, PaymentType.DTAUS, false),
        BBK_EMZ_STEP2_TRANSFER("XGS", FormatType.bbk, PaymentType.SWIFT, false),
        BBK_EMZ_PACKED_DTA_TRANSFER("XCG", FormatType.bbk, PaymentType.DTAUS, false),
        BBK_EMZ_PACKED_DTA_DIRECT_DEBIT("XCL", FormatType.bbk, PaymentType.DTAUS, false),
        BBK_EMZ_PACKED_STEP2_TRANSFER("XCS", FormatType.bbk, PaymentType.SWIFT, false),
        CFONB320_TRANSFER("pain.xxx.cfonb320.xct", FormatType.cfonb320, PaymentType.CFONB320),
        CFONB160_TRANSFER("pain.xxx.cfonb160.dct", FormatType.cfonb160, PaymentType.CFONB160),
        CFONB160_URGENT_TRANSFER("pain.xxx.cfonb160.ict", FormatType.cfonb160, PaymentType.CFONB160),
        CFONB160_DIRECT_DEBIT("pain.xxx.cfonb160.ddd", FormatType.cfonb160, PaymentType.CFONB160),
        CFONB160_URGENT_DIRECT_DEBIT("pain.xxx.cfonb160.dda", FormatType.cfonb160, PaymentType.CFONB160),
        CFONB160_BILL_OF_EXCHANGE("pain.xxx.cfonb160.dco", FormatType.cfonb160, PaymentType.CFONB160),
        SWISS_ES1_TRANSFER("XE2", FormatType.pain001, PaymentType.SWISS_POST_ACCOUNT),
        SWISS_ES2_TRANSFER("XE2", FormatType.pain001, PaymentType.SWISS_IID),
        SWISS_QR_TRANSFER("XE2", FormatType.pain001, PaymentType.SEPA),
        SWISS_DOMESTIC_TRANSFER_3("XE2", FormatType.pain001, PaymentType.SEPA),
        SWISS_DOMESTIC_TRANSFER_4("XE2", FormatType.pain001, PaymentType.SEPA),
        SWISS_SEPA_TRANSFER("XE2", FormatType.pain001, PaymentType.SEPA),
        SWISS_FOREIGN_TRANSFER("XE2", FormatType.pain001, PaymentType.SEPA_FOREIGN),
        SEPA_CONFIDENTAL_TRANSFER("CCT", FormatType.pain001, PaymentType.SEPA, true, ServiceLevel_SEPA, false, true),
        SEPA_URGENT_CONFIDENTAL_TRANSFER("CCU", FormatType.pain001, PaymentType.SEPA, ServiceLevel_URGP),
        AUSTRIAN_FOREIGN("ATX", FormatType.pain001, PaymentType.SEPA_FOREIGN),
        SEPA_FOREIGN_CHEQUE("AXZ", FormatType.pain001, PaymentType.CHEQUE),
        AUSTRIAN_FOREIGN_SEPA_CHEQUE("ATX", FormatType.pain001, PaymentType.CHEQUE),
        C55_SDD_CALLBACK("C55", FormatType.camt055, null, false, null, true),
        AUSTRIAN_URGENT_TAX_PAYMENT("CCU", FormatType.pain001, PaymentType.AUSTRIAN_TAX_OFFICE, ServiceLevel_URGP),
        SEPA_URGENT_FOREIGN_TRANSFER("AXZ", FormatType.pain001, PaymentType.SEPA_FOREIGN);

        private final String handlerKey;
        private final FormatType formatType;
        private final PaymentType recipientPaymentType;
        private final boolean supportsImport;
        private final String serviceLevel;
        private final boolean isCallbackType;
        private final boolean supportsVop;

        private PmtType(String handlerKey, FormatType formatType, PaymentType recipientPaymentType) {
            this(handlerKey, formatType, recipientPaymentType, true, null);
        }

        private PmtType(String handlerKey, FormatType formatType, PaymentType recipientPaymentType, String serviceLevel) {
            this(handlerKey, formatType, recipientPaymentType, true, serviceLevel);
        }

        private PmtType(String handlerKey, FormatType formatType, PaymentType recipientPaymentType, boolean supportsImport) {
            this(handlerKey, formatType, recipientPaymentType, supportsImport, null);
        }

        private PmtType(String handlerKey, FormatType formatType, PaymentType recipientPaymentType, boolean supportsImport, String serviceLevel) {
            this(handlerKey, formatType, recipientPaymentType, supportsImport, null, false);
        }

        private PmtType(String handlerKey, FormatType formatType, PaymentType recipientPaymentType, boolean supportsImport, String serviceLevel, boolean isCallbackType) {
            this(handlerKey, formatType, recipientPaymentType, supportsImport, serviceLevel, isCallbackType, false);
        }

        private PmtType(String handlerKey, FormatType formatType, PaymentType recipientPaymentType, boolean supportsImport, String serviceLevel, boolean isCallbackType, boolean supportsVop) {
            this.handlerKey = handlerKey;
            this.formatType = formatType;
            this.recipientPaymentType = recipientPaymentType;
            this.supportsImport = supportsImport;
            this.serviceLevel = serviceLevel;
            this.isCallbackType = isCallbackType;
            this.supportsVop = supportsVop;
        }

        public PaymentType getRecipientPaymentType() {
            return this.recipientPaymentType;
        }

        public String getHandlerKey() {
            return this.handlerKey;
        }

        public FormatType getFormatType() {
            return this.formatType;
        }

        public boolean supportsImport() {
            return this.supportsImport;
        }

        public String getServiceLevel() {
            return this.serviceLevel;
        }

        public boolean isCallbackType() {
            return this.isCallbackType;
        }

        public boolean supportsVop() {
            return this.supportsVop;
        }
    }

    public static enum Scheme {
        pain00100102,
        pain00100103,
        pain00100108,
        pain00100109,
        pain00100103dk,
        pain00100202dk,
        pain00100203dk,
        pain00100303dk,
        pain00100103ch,
        pain00800101,
        pain00800102,
        pain00800108,
        pain00800102dk,
        pain00800201dk,
        pain00800202dk,
        pain00800302dk,
        pain00800102ch,
        NONE;

    }

    public static enum FormatType {
        pain001,
        pain008,
        dtazv,
        mt101,
        camt055,
        cfonb160,
        cfonb320,
        bbk;

    }
}

