/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.database.vo;

import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.Account;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.BankUser;
import de.businesslogics.banking.database.vo.EbeanHelper;
import de.businesslogics.banking.database.vo.OrderType;
import de.businesslogics.banking.database.vo.PaymentFolder;
import de.businesslogics.banking.database.vo.PaymentRecipient;
import de.businesslogics.banking.database.vo.PaymentTransferType;
import de.businesslogics.banking.database.vo.PaymentType;
import de.businesslogics.banking.database.vo.Tenant;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.iban.IbanUtil;
import de.businesslogics.validation.RegularExpressions;
import io.ebean.Expr;
import io.ebean.Expression;
import io.ebean.Query;
import io.ebean.SqlQuery;
import io.ebean.SqlRow;
import io.ebean.Update;
import io.ebean.annotation.Index;
import io.ebean.bean.EntityBean;
import io.ebean.bean.EntityBeanIntercept;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

@Entity
@Table(name="pmt_template")
public class PaymentTemplate
implements EntityBean {
    @Id
    private Integer id;
    @ManyToOne(optional=false)
    private BankSettings bank;
    @Column(length=80)
    private String name;
    @ManyToOne
    private Account account;
    private PaymentTransferType.PmtType pmtType;
    @Column(length=3)
    @Index(name="ix_pmt_template_order_type")
    private String orderType;
    @Column(length=50)
    @Index(name="ix_pmt_template_file_type")
    private String fileType;
    @Column(name="is_credit")
    private Boolean credit;
    @Column(name="is_urgent")
    private Boolean urgent;
    @Column(length=70)
    private String originator;
    @Column(length=70)
    private String recipient;
    @Column(precision=38, scale=3)
    private BigDecimal amount;
    @Column(length=3)
    private String amountCurrency;
    @Lob
    private byte[] paymentData;
    @ManyToOne
    private PaymentFolder folder;
    @Column(length=150)
    private String genericPurpose;
    private Boolean salaryPayment;
    public static /* synthetic */ String[] _ebean_props;
    protected /* synthetic */ EntityBeanIntercept _ebean_intercept;
    protected transient /* synthetic */ Object _ebean_identity;

    public PaymentTemplate() {
        this._ebean_intercept = new EntityBeanIntercept((Object)this);
    }

    public static List<String> getTemplateNames(User user, boolean onlyPaymentsWithPermission, boolean excludeSalaries) {
        ArrayList<String> result = new ArrayList<String>();
        PaymentTemplate.getDefaultQuery(user, onlyPaymentsWithPermission, excludeSalaries).findEach(bean -> result.add(bean.getName()));
        return result;
    }

    public static int countByAccount(Account account) {
        return DB.find(PaymentTemplate.class).where().eq("account", (Object)account).findCount();
    }

    public static int deleteAll(Account account) {
        Update<PaymentTemplate> delete = DB.createUpdate(PaymentTemplate.class, "DELETE FROM PaymentTemplate WHERE account=:account");
        delete.setParameter("account", (Object)account.getId());
        return delete.execute();
    }

    public static PaymentTemplate findTemplateByName(String name) {
        if (name == null) {
            return null;
        }
        return (PaymentTemplate)DB.find(PaymentTemplate.class).where().eq("name", (Object)name).setMaxRows(1).findOne();
    }

    public static PaymentTemplate findTemplateByNameAndTenant(String name, Tenant tenant) {
        if (name == null) {
            return null;
        }
        if (tenant == null) {
            return PaymentTemplate.findTemplateByName(name);
        }
        return (PaymentTemplate)DB.find(PaymentTemplate.class).where().eq("name", (Object)name).eq("bank.tenant", (Object)tenant).setMaxRows(1).findOne();
    }

    public static Query<PaymentTemplate> getDefaultQuery(User user, boolean onlyPaymentsWithPermission, boolean excludeSalaries) {
        return PaymentTemplate.getDefaultQuery(user, null, onlyPaymentsWithPermission, excludeSalaries);
    }

    public static int getTotalPaymentsTemplateCount(PaymentFolder folder) {
        return DB.find(PaymentTemplate.class).where().eq("folder", (Object)folder).where().findCount();
    }

    public static int getPaymentTemplatesCount(User user, PaymentFolder folder, boolean onlyPaymentsWithPermission, boolean excludeSalaries) {
        return PaymentTemplate.getDefaultQuery(user, folder, onlyPaymentsWithPermission, excludeSalaries).findCount();
    }

    public static Query<PaymentTemplate> getDefaultQuery(User user, PaymentFolder folder, boolean onlyPaymentsWithPermission, boolean excludeSalaries) {
        Query query = DB.find(PaymentTemplate.class).orderBy("name");
        if (folder != null && folder.getId() != null) {
            query.where().eq("folder", (Object)folder);
        } else if (((Object)PaymentFolder.NULL_FOLDER).equals(folder)) {
            query.where().isNull("folder");
        }
        if (excludeSalaries) {
            query.where().or(Expr.isNull((String)"salaryPayment"), Expr.eq((String)"salaryPayment", (Object)false));
        }
        ArrayList<BankSettings> banksList = new ArrayList<BankSettings>();
        for (BankUser bankUser : BankUser.findBanksForUser(user)) {
            banksList.add(bankUser.getBank());
        }
        if (onlyPaymentsWithPermission) {
            Expression orderTypeFilter = OrderType.buildExpressionForOrderTypePermissions(user, "bank", "orderType", "fileType", "account");
            if (orderTypeFilter == null) {
                return query.where(Expr.isNull((String)"bank"));
            }
            Expression accountFilter = Account.buildExpressionForAccountPermissions(user, "account");
            if (accountFilter == null) {
                return query.where(Expr.isNull((String)"bank"));
            }
            Expression manualAccounts = Account.buildExpressionForManualAccountPermissions(user, "account");
            query.where().or(manualAccounts, Expr.and((Expression)orderTypeFilter, (Expression)accountFilter));
        } else {
            if (banksList.size() == 0) {
                return query.where(Expr.isNull((String)"bank"));
            }
            if (banksList.size() == 1) {
                query.where().eq("bank", banksList.get(0));
            } else {
                query.where().in("bank", banksList);
            }
        }
        return query;
    }

    public static int deleteAll(BankSettings bank) {
        Update<PaymentTemplate> delete = DB.createUpdate(PaymentTemplate.class, "DELETE FROM PaymentTemplate WHERE bank=:bank");
        delete.setParameter("bank", (Object)bank.getBankId());
        return delete.execute();
    }

    public static int updateFileTypeAndOrderType(BankSettings bank, PaymentTransferType.PmtType pmtType, String fileType, String orderType) {
        Update<PaymentTemplate> update = DB.createUpdate(PaymentTemplate.class, "UPDATE PaymentTemplate SET fileType =:p1, orderType =:p2 WHERE pmtType =:p3 AND bank =:p4");
        update.setParameter("p1", (Object)fileType);
        update.setParameter("p2", (Object)orderType);
        update.setParameter("p3", (Object)pmtType);
        update.setParameter("p4", (Object)bank.getBankId());
        return update.execute();
    }

    public static String getRecipientWithAccountNumber(PaymentTemplate payment, boolean showRecipientWithAccountNumber, boolean useMandates) {
        return PaymentTemplate.getRecipientWithAccountNumber(payment.getRecipient(), payment.isCredit(), payment.getAccount(), showRecipientWithAccountNumber, useMandates);
    }

    public static String getRecipientWithAccountNumber(String recipientName, boolean isCredit, Account originatorAccount, boolean showRecipientWithAccountNumber, boolean useMandates) {
        if (showRecipientWithAccountNumber) {
            String accNumber;
            int n;
            List<PaymentRecipient> paymentRecipients;
            Tenant tenant = originatorAccount.getBank().getTenant();
            ArrayList<PaymentType> paymentTypes = new ArrayList<PaymentType>();
            paymentTypes.add(PaymentType.MANDATE);
            if (isCredit || !useMandates) {
                paymentTypes.add(PaymentType.SEPA);
            }
            if ((paymentRecipients = PaymentRecipient.findRecipientByName(paymentTypes, recipientName, tenant)) != null && (n = paymentRecipients.size()) == 1 && (accNumber = paymentRecipients.get(0).getAccountNumber()) != null) {
                return recipientName + " (" + IbanUtil.formatIfIBAN(accNumber) + ")";
            }
        }
        return recipientName;
    }

    public static void delete(Collection<PaymentTemplate> paymentTemplates) {
        DB.deleteAll(paymentTemplates);
    }

    public static int removeFolderReferences(PaymentFolder folder) {
        Update<PaymentTemplate> update = DB.createUpdate(PaymentTemplate.class, "UPDATE PaymentTemplate SET folder = null WHERE folder=:folder");
        update.setParameter("folder", (Object)folder.getId());
        return update.execute();
    }

    public static int getNumberOfPaymentTemplates(BankSettings bank) {
        return DB.find(PaymentTemplate.class).where().eq("bank", (Object)bank).findCount();
    }

    public static int countByCurrency(User user, String currency, boolean onlyPaymentsWithPermission, boolean excludeSalaries) {
        return PaymentTemplate.getDefaultQuery(user, onlyPaymentsWithPermission, excludeSalaries).where(Expr.eq((String)"amountCurrency", (Object)currency)).findCount();
    }

    public static int countByCurrency(User user, PaymentFolder folder, String currency, boolean onlyPaymentsWithPermission, boolean excludeSalaries) {
        return PaymentTemplate.getDefaultQuery(user, folder, onlyPaymentsWithPermission, excludeSalaries).where(Expr.eq((String)"amountCurrency", (Object)currency)).findCount();
    }

    public static BigDecimal sumAmount(User user, String currency, boolean onlyPaymentsWithPermission, boolean excludeSalaries) {
        return PaymentTemplate.sumAmount(user, null, currency, onlyPaymentsWithPermission, excludeSalaries);
    }

    public static BigDecimal sumAmount(User user, PaymentFolder folder, String currency, boolean onlyPaymentsWithPermission, boolean excludeSalaries) {
        SqlRow row;
        StringBuilder queryBuilder = new StringBuilder("select sum(amount) as total_amount from pmt_template where amount_currency = '").append(currency).append('\'');
        if (folder != null && folder.getId() != null) {
            queryBuilder.append(" and folder_id = ").append(folder.getId());
        } else if (((Object)PaymentFolder.NULL_FOLDER).equals(folder)) {
            queryBuilder.append(" and folder_id is null");
        }
        if (excludeSalaries) {
            queryBuilder.append(" and salary_payment = :param1");
        }
        if (onlyPaymentsWithPermission) {
            String whereClause = OrderType.buildRawExpressionForOrderTypePermissions(user, "bank_id", "order_type", "file_type", "account_id");
            if (whereClause == null) {
                return BigDecimal.ZERO;
            }
            queryBuilder.append(" and (").append(whereClause).append(')');
            whereClause = Account.buildRawExpressionForAccountPermission(user, "bank_id", "account_id");
            if (whereClause == null) {
                return BigDecimal.ZERO;
            }
            queryBuilder.append(" and ").append(whereClause);
        } else {
            List<BankUser> bankUsers = BankUser.findBanksForUser(user);
            if (bankUsers.size() != 0) {
                if (bankUsers.size() == 1) {
                    queryBuilder.append(" and bank_id = ").append(bankUsers.get(0).getBank().getBankId());
                } else {
                    queryBuilder.append(" and bank_id in (");
                    for (int i = 0; i < bankUsers.size(); ++i) {
                        if (i > 0) {
                            queryBuilder.append(", ");
                        }
                        queryBuilder.append(bankUsers.get(i).getBank().getBankId());
                    }
                    queryBuilder.append(')');
                }
            }
        }
        SqlQuery query = DB.createSqlQuery(queryBuilder.toString());
        if (excludeSalaries) {
            query.setParameter("param1", (Object)Boolean.FALSE);
        }
        if ((row = query.findOne()) == null) {
            return null;
        }
        return row.getBigDecimal("total_amount");
    }

    public static void deleteByFolder(User user, PaymentFolder folder, boolean onlyPaymentsWithPermission, boolean excludeSalaries) {
        Query<PaymentTemplate> query = PaymentTemplate.getDefaultQuery(user, folder, onlyPaymentsWithPermission, excludeSalaries);
        ArrayList idsToDelete = new ArrayList();
        query.findEach(bean -> idsToDelete.add(bean.getId()));
        EbeanHelper.deleteById(PaymentTemplate.class, idsToDelete);
    }

    public Integer getId() {
        return this._ebean_get_id();
    }

    public void setId(Integer id) {
        this._ebean_set_id(id);
    }

    public BankSettings getBank() {
        return this._ebean_get_bank();
    }

    public void setBank(BankSettings bank) {
        this._ebean_set_bank(bank);
    }

    public String getName() {
        return this._ebean_get_name();
    }

    public void setName(String name) {
        this._ebean_set_name(name);
    }

    public String getUniqueName(List<Tenant> tenants) {
        Tenant tenant;
        if (DB.find(PaymentTemplate.class).where().eq("name", (Object)this.getName()).in("bank.tenant", tenants).findCount() > 1 && (tenant = this.getBank().getTenant()) != null) {
            return this.getName() + " (" + tenant.getName() + ")";
        }
        return this.getName();
    }

    public Account getAccount() {
        return this._ebean_get_account();
    }

    public void setAccount(Account account) {
        this._ebean_set_account(account);
    }

    public PaymentTransferType.PmtType getPmtType() {
        return this._ebean_get_pmtType();
    }

    public void setPmtType(PaymentTransferType.PmtType pmtType) {
        this._ebean_set_pmtType(pmtType);
    }

    public String getOrderType() {
        return this._ebean_get_orderType();
    }

    public void setOrderType(String orderType) {
        this._ebean_set_orderType(orderType);
    }

    public String getFileType() {
        if (this._ebean_get_fileType() == null || !RegularExpressions.BTF_SERVICE_PATTERN.matches(this._ebean_get_fileType())) {
            return this._ebean_get_fileType();
        }
        return null;
    }

    public String getFileTypeOrBTF() {
        return this._ebean_get_fileType();
    }

    public String getBTF() {
        if (this._ebean_get_fileType() != null && RegularExpressions.BTF_SERVICE_PATTERN.matches(this._ebean_get_fileType())) {
            return this._ebean_get_fileType();
        }
        return null;
    }

    public String getOrderTypeOrBtf() {
        try {
            int h00Version = Integer.parseInt(this._ebean_get_account().getBank().getProtocolVersion().substring(3, 4));
            if (h00Version >= 5) {
                return this.getBTF();
            }
            return this._ebean_get_orderType();
        }
        catch (NullPointerException | NumberFormatException e) {
            return this._ebean_get_orderType();
        }
    }

    public void setFileType(String fileType) {
        this._ebean_set_fileType(fileType);
    }

    public String getOrderTypeOrFileType() {
        if (this.getFileType() != null && !RegularExpressions.BTF_SERVICE_PATTERN.matches(this.getFileType())) {
            return this.getFileType();
        }
        return this.getOrderType();
    }

    public boolean isCredit() {
        if (this._ebean_get_credit() == null) {
            return false;
        }
        return this._ebean_get_credit();
    }

    public void setCredit(boolean isCredit) {
        this._ebean_set_credit(isCredit);
    }

    public boolean isUrgent() {
        if (this._ebean_get_urgent() == null) {
            return false;
        }
        return this._ebean_get_urgent();
    }

    public void setUrgent(boolean isUrgent) {
        this._ebean_set_urgent(isUrgent);
    }

    public String getOriginator() {
        return this._ebean_get_originator();
    }

    public void setOriginator(String originator) {
        this._ebean_set_originator(originator);
    }

    public String getRecipient() {
        return this._ebean_get_recipient();
    }

    public void setRecipient(String recipient) {
        this._ebean_set_recipient(recipient);
    }

    public BigDecimal getAmount() {
        return this._ebean_get_amount();
    }

    public void setAmount(BigDecimal amount) {
        this._ebean_set_amount(amount);
    }

    public String getAmountCurrency() {
        return this._ebean_get_amountCurrency();
    }

    public void setAmountCurrency(String amountCurrency) {
        this._ebean_set_amountCurrency(amountCurrency);
    }

    public byte[] getPaymentData() {
        return this._ebean_get_paymentData();
    }

    public PaymentFolder getFolder() {
        return this._ebean_get_folder();
    }

    public void setFolder(PaymentFolder folder) {
        this._ebean_set_folder(folder);
    }

    public void setPaymentData(byte[] paymentData) {
        this._ebean_set_paymentData(paymentData);
    }

    public String getGenericPurpose() {
        return this._ebean_get_genericPurpose();
    }

    public void setGenericPurpose(String genericPurpose) {
        this._ebean_set_genericPurpose(genericPurpose);
    }

    public void save() {
        if (this.getId() == null) {
            DB.save(this);
        } else {
            DB.update(this);
        }
    }

    public void delete() {
        if (this._ebean_get_id() == null) {
            return;
        }
        DB.delete(this);
    }

    public Boolean getSalaryPayment() {
        return this._ebean_get_salaryPayment();
    }

    public void setSalaryPayment(Boolean salaryPayment) {
        this._ebean_set_salaryPayment(salaryPayment);
    }

    static {
        _ebean_props = new String[]{"id", "bank", "name", "account", "pmtType", "orderType", "fileType", "credit", "urgent", "originator", "recipient", "amount", "amountCurrency", "paymentData", "folder", "genericPurpose", "salaryPayment"};
    }

    public /* synthetic */ String[] _ebean_getPropertyNames() {
        return _ebean_props;
    }

    public /* synthetic */ String _ebean_getPropertyName(int pos) {
        return _ebean_props[pos];
    }

    public /* synthetic */ EntityBeanIntercept _ebean_getIntercept() {
        return this._ebean_intercept;
    }

    public /* synthetic */ EntityBeanIntercept _ebean_intercept() {
        if (this._ebean_intercept == null) {
            this._ebean_intercept = new EntityBeanIntercept((Object)this);
        }
        return this._ebean_intercept;
    }

    protected /* synthetic */ Integer _ebean_get_id() {
        this._ebean_intercept.preGetId();
        return this.id;
    }

    protected /* synthetic */ void _ebean_set_id(Integer newValue) {
        this._ebean_intercept.preSetter(false, 0, (Object)this.id, (Object)newValue);
        this.id = newValue;
    }

    protected /* synthetic */ Integer _ebean_getni_id() {
        return this.id;
    }

    protected /* synthetic */ void _ebean_setni_id(Integer _newValue) {
        this.id = _newValue;
        this._ebean_intercept.setLoadedProperty(0);
    }

    protected /* synthetic */ BankSettings _ebean_get_bank() {
        this._ebean_intercept.preGetter(1);
        return this.bank;
    }

    protected /* synthetic */ void _ebean_set_bank(BankSettings newValue) {
        this._ebean_intercept.preSetter(true, 1, (Object)this._ebean_get_bank(), (Object)newValue);
        this.bank = newValue;
    }

    protected /* synthetic */ BankSettings _ebean_getni_bank() {
        return this.bank;
    }

    protected /* synthetic */ void _ebean_setni_bank(BankSettings _newValue) {
        this.bank = _newValue;
        this._ebean_intercept.setLoadedProperty(1);
    }

    protected /* synthetic */ String _ebean_get_name() {
        this._ebean_intercept.preGetter(2);
        return this.name;
    }

    protected /* synthetic */ void _ebean_set_name(String newValue) {
        this._ebean_intercept.preSetter(true, 2, (Object)this._ebean_get_name(), (Object)newValue);
        this.name = newValue;
    }

    protected /* synthetic */ String _ebean_getni_name() {
        return this.name;
    }

    protected /* synthetic */ void _ebean_setni_name(String _newValue) {
        this.name = _newValue;
        this._ebean_intercept.setLoadedProperty(2);
    }

    protected /* synthetic */ Account _ebean_get_account() {
        this._ebean_intercept.preGetter(3);
        return this.account;
    }

    protected /* synthetic */ void _ebean_set_account(Account newValue) {
        this._ebean_intercept.preSetter(true, 3, (Object)this._ebean_get_account(), (Object)newValue);
        this.account = newValue;
    }

    protected /* synthetic */ Account _ebean_getni_account() {
        return this.account;
    }

    protected /* synthetic */ void _ebean_setni_account(Account _newValue) {
        this.account = _newValue;
        this._ebean_intercept.setLoadedProperty(3);
    }

    protected /* synthetic */ PaymentTransferType.PmtType _ebean_get_pmtType() {
        this._ebean_intercept.preGetter(4);
        return this.pmtType;
    }

    protected /* synthetic */ void _ebean_set_pmtType(PaymentTransferType.PmtType newValue) {
        this._ebean_intercept.preSetter(true, 4, (Object)this._ebean_get_pmtType(), (Object)newValue);
        this.pmtType = newValue;
    }

    protected /* synthetic */ PaymentTransferType.PmtType _ebean_getni_pmtType() {
        return this.pmtType;
    }

    protected /* synthetic */ void _ebean_setni_pmtType(PaymentTransferType.PmtType _newValue) {
        this.pmtType = _newValue;
        this._ebean_intercept.setLoadedProperty(4);
    }

    protected /* synthetic */ String _ebean_get_orderType() {
        this._ebean_intercept.preGetter(5);
        return this.orderType;
    }

    protected /* synthetic */ void _ebean_set_orderType(String newValue) {
        this._ebean_intercept.preSetter(true, 5, (Object)this._ebean_get_orderType(), (Object)newValue);
        this.orderType = newValue;
    }

    protected /* synthetic */ String _ebean_getni_orderType() {
        return this.orderType;
    }

    protected /* synthetic */ void _ebean_setni_orderType(String _newValue) {
        this.orderType = _newValue;
        this._ebean_intercept.setLoadedProperty(5);
    }

    protected /* synthetic */ String _ebean_get_fileType() {
        this._ebean_intercept.preGetter(6);
        return this.fileType;
    }

    protected /* synthetic */ void _ebean_set_fileType(String newValue) {
        this._ebean_intercept.preSetter(true, 6, (Object)this._ebean_get_fileType(), (Object)newValue);
        this.fileType = newValue;
    }

    protected /* synthetic */ String _ebean_getni_fileType() {
        return this.fileType;
    }

    protected /* synthetic */ void _ebean_setni_fileType(String _newValue) {
        this.fileType = _newValue;
        this._ebean_intercept.setLoadedProperty(6);
    }

    protected /* synthetic */ Boolean _ebean_get_credit() {
        this._ebean_intercept.preGetter(7);
        return this.credit;
    }

    protected /* synthetic */ void _ebean_set_credit(Boolean newValue) {
        this._ebean_intercept.preSetter(true, 7, (Object)this._ebean_get_credit(), (Object)newValue);
        this.credit = newValue;
    }

    protected /* synthetic */ Boolean _ebean_getni_credit() {
        return this.credit;
    }

    protected /* synthetic */ void _ebean_setni_credit(Boolean _newValue) {
        this.credit = _newValue;
        this._ebean_intercept.setLoadedProperty(7);
    }

    protected /* synthetic */ Boolean _ebean_get_urgent() {
        this._ebean_intercept.preGetter(8);
        return this.urgent;
    }

    protected /* synthetic */ void _ebean_set_urgent(Boolean newValue) {
        this._ebean_intercept.preSetter(true, 8, (Object)this._ebean_get_urgent(), (Object)newValue);
        this.urgent = newValue;
    }

    protected /* synthetic */ Boolean _ebean_getni_urgent() {
        return this.urgent;
    }

    protected /* synthetic */ void _ebean_setni_urgent(Boolean _newValue) {
        this.urgent = _newValue;
        this._ebean_intercept.setLoadedProperty(8);
    }

    protected /* synthetic */ String _ebean_get_originator() {
        this._ebean_intercept.preGetter(9);
        return this.originator;
    }

    protected /* synthetic */ void _ebean_set_originator(String newValue) {
        this._ebean_intercept.preSetter(true, 9, (Object)this._ebean_get_originator(), (Object)newValue);
        this.originator = newValue;
    }

    protected /* synthetic */ String _ebean_getni_originator() {
        return this.originator;
    }

    protected /* synthetic */ void _ebean_setni_originator(String _newValue) {
        this.originator = _newValue;
        this._ebean_intercept.setLoadedProperty(9);
    }

    protected /* synthetic */ String _ebean_get_recipient() {
        this._ebean_intercept.preGetter(10);
        return this.recipient;
    }

    protected /* synthetic */ void _ebean_set_recipient(String newValue) {
        this._ebean_intercept.preSetter(true, 10, (Object)this._ebean_get_recipient(), (Object)newValue);
        this.recipient = newValue;
    }

    protected /* synthetic */ String _ebean_getni_recipient() {
        return this.recipient;
    }

    protected /* synthetic */ void _ebean_setni_recipient(String _newValue) {
        this.recipient = _newValue;
        this._ebean_intercept.setLoadedProperty(10);
    }

    protected /* synthetic */ BigDecimal _ebean_get_amount() {
        this._ebean_intercept.preGetter(11);
        return this.amount;
    }

    protected /* synthetic */ void _ebean_set_amount(BigDecimal newValue) {
        this._ebean_intercept.preSetter(true, 11, (Object)this._ebean_get_amount(), (Object)newValue);
        this.amount = newValue;
    }

    protected /* synthetic */ BigDecimal _ebean_getni_amount() {
        return this.amount;
    }

    protected /* synthetic */ void _ebean_setni_amount(BigDecimal _newValue) {
        this.amount = _newValue;
        this._ebean_intercept.setLoadedProperty(11);
    }

    protected /* synthetic */ String _ebean_get_amountCurrency() {
        this._ebean_intercept.preGetter(12);
        return this.amountCurrency;
    }

    protected /* synthetic */ void _ebean_set_amountCurrency(String newValue) {
        this._ebean_intercept.preSetter(true, 12, (Object)this._ebean_get_amountCurrency(), (Object)newValue);
        this.amountCurrency = newValue;
    }

    protected /* synthetic */ String _ebean_getni_amountCurrency() {
        return this.amountCurrency;
    }

    protected /* synthetic */ void _ebean_setni_amountCurrency(String _newValue) {
        this.amountCurrency = _newValue;
        this._ebean_intercept.setLoadedProperty(12);
    }

    protected /* synthetic */ byte[] _ebean_get_paymentData() {
        this._ebean_intercept.preGetter(13);
        return this.paymentData;
    }

    protected /* synthetic */ void _ebean_set_paymentData(byte[] newValue) {
        this._ebean_intercept.preSetter(true, 13, this._ebean_get_paymentData(), newValue);
        this.paymentData = newValue;
    }

    protected /* synthetic */ byte[] _ebean_getni_paymentData() {
        return this.paymentData;
    }

    protected /* synthetic */ void _ebean_setni_paymentData(byte[] _newValue) {
        this.paymentData = _newValue;
        this._ebean_intercept.setLoadedProperty(13);
    }

    protected /* synthetic */ PaymentFolder _ebean_get_folder() {
        this._ebean_intercept.preGetter(14);
        return this.folder;
    }

    protected /* synthetic */ void _ebean_set_folder(PaymentFolder newValue) {
        this._ebean_intercept.preSetter(true, 14, (Object)this._ebean_get_folder(), (Object)newValue);
        this.folder = newValue;
    }

    protected /* synthetic */ PaymentFolder _ebean_getni_folder() {
        return this.folder;
    }

    protected /* synthetic */ void _ebean_setni_folder(PaymentFolder _newValue) {
        this.folder = _newValue;
        this._ebean_intercept.setLoadedProperty(14);
    }

    protected /* synthetic */ String _ebean_get_genericPurpose() {
        this._ebean_intercept.preGetter(15);
        return this.genericPurpose;
    }

    protected /* synthetic */ void _ebean_set_genericPurpose(String newValue) {
        this._ebean_intercept.preSetter(true, 15, (Object)this._ebean_get_genericPurpose(), (Object)newValue);
        this.genericPurpose = newValue;
    }

    protected /* synthetic */ String _ebean_getni_genericPurpose() {
        return this.genericPurpose;
    }

    protected /* synthetic */ void _ebean_setni_genericPurpose(String _newValue) {
        this.genericPurpose = _newValue;
        this._ebean_intercept.setLoadedProperty(15);
    }

    protected /* synthetic */ Boolean _ebean_get_salaryPayment() {
        this._ebean_intercept.preGetter(16);
        return this.salaryPayment;
    }

    protected /* synthetic */ void _ebean_set_salaryPayment(Boolean newValue) {
        this._ebean_intercept.preSetter(true, 16, (Object)this._ebean_get_salaryPayment(), (Object)newValue);
        this.salaryPayment = newValue;
    }

    protected /* synthetic */ Boolean _ebean_getni_salaryPayment() {
        return this.salaryPayment;
    }

    protected /* synthetic */ void _ebean_setni_salaryPayment(Boolean _newValue) {
        this.salaryPayment = _newValue;
        this._ebean_intercept.setLoadedProperty(16);
    }

    public /* synthetic */ Object _ebean_getField(int index) {
        switch (index) {
            case 0: {
                return this.id;
            }
            case 1: {
                return this.bank;
            }
            case 2: {
                return this.name;
            }
            case 3: {
                return this.account;
            }
            case 4: {
                return this.pmtType;
            }
            case 5: {
                return this.orderType;
            }
            case 6: {
                return this.fileType;
            }
            case 7: {
                return this.credit;
            }
            case 8: {
                return this.urgent;
            }
            case 9: {
                return this.originator;
            }
            case 10: {
                return this.recipient;
            }
            case 11: {
                return this.amount;
            }
            case 12: {
                return this.amountCurrency;
            }
            case 13: {
                return this.paymentData;
            }
            case 14: {
                return this.folder;
            }
            case 15: {
                return this.genericPurpose;
            }
            case 16: {
                return this.salaryPayment;
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    public /* synthetic */ Object _ebean_getFieldIntercept(int index) {
        switch (index) {
            case 0: {
                return this._ebean_get_id();
            }
            case 1: {
                return this._ebean_get_bank();
            }
            case 2: {
                return this._ebean_get_name();
            }
            case 3: {
                return this._ebean_get_account();
            }
            case 4: {
                return this._ebean_get_pmtType();
            }
            case 5: {
                return this._ebean_get_orderType();
            }
            case 6: {
                return this._ebean_get_fileType();
            }
            case 7: {
                return this._ebean_get_credit();
            }
            case 8: {
                return this._ebean_get_urgent();
            }
            case 9: {
                return this._ebean_get_originator();
            }
            case 10: {
                return this._ebean_get_recipient();
            }
            case 11: {
                return this._ebean_get_amount();
            }
            case 12: {
                return this._ebean_get_amountCurrency();
            }
            case 13: {
                return this._ebean_get_paymentData();
            }
            case 14: {
                return this._ebean_get_folder();
            }
            case 15: {
                return this._ebean_get_genericPurpose();
            }
            case 16: {
                return this._ebean_get_salaryPayment();
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    public /* synthetic */ void _ebean_setField(int index, Object o) {
        switch (index) {
            case 0: {
                this._ebean_setni_id((Integer)o);
                return;
            }
            case 1: {
                this._ebean_setni_bank((BankSettings)o);
                return;
            }
            case 2: {
                this._ebean_setni_name((String)o);
                return;
            }
            case 3: {
                this._ebean_setni_account((Account)o);
                return;
            }
            case 4: {
                this._ebean_setni_pmtType((PaymentTransferType.PmtType)((Object)o));
                return;
            }
            case 5: {
                this._ebean_setni_orderType((String)o);
                return;
            }
            case 6: {
                this._ebean_setni_fileType((String)o);
                return;
            }
            case 7: {
                this._ebean_setni_credit((Boolean)o);
                return;
            }
            case 8: {
                this._ebean_setni_urgent((Boolean)o);
                return;
            }
            case 9: {
                this._ebean_setni_originator((String)o);
                return;
            }
            case 10: {
                this._ebean_setni_recipient((String)o);
                return;
            }
            case 11: {
                this._ebean_setni_amount((BigDecimal)o);
                return;
            }
            case 12: {
                this._ebean_setni_amountCurrency((String)o);
                return;
            }
            case 13: {
                this._ebean_setni_paymentData((byte[])o);
                return;
            }
            case 14: {
                this._ebean_setni_folder((PaymentFolder)o);
                return;
            }
            case 15: {
                this._ebean_setni_genericPurpose((String)o);
                return;
            }
            case 16: {
                this._ebean_setni_salaryPayment((Boolean)o);
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    public /* synthetic */ void _ebean_setFieldIntercept(int index, Object o) {
        switch (index) {
            case 0: {
                this._ebean_set_id((Integer)o);
                return;
            }
            case 1: {
                this._ebean_set_bank((BankSettings)o);
                return;
            }
            case 2: {
                this._ebean_set_name((String)o);
                return;
            }
            case 3: {
                this._ebean_set_account((Account)o);
                return;
            }
            case 4: {
                this._ebean_set_pmtType((PaymentTransferType.PmtType)((Object)o));
                return;
            }
            case 5: {
                this._ebean_set_orderType((String)o);
                return;
            }
            case 6: {
                this._ebean_set_fileType((String)o);
                return;
            }
            case 7: {
                this._ebean_set_credit((Boolean)o);
                return;
            }
            case 8: {
                this._ebean_set_urgent((Boolean)o);
                return;
            }
            case 9: {
                this._ebean_set_originator((String)o);
                return;
            }
            case 10: {
                this._ebean_set_recipient((String)o);
                return;
            }
            case 11: {
                this._ebean_set_amount((BigDecimal)o);
                return;
            }
            case 12: {
                this._ebean_set_amountCurrency((String)o);
                return;
            }
            case 13: {
                this._ebean_set_paymentData((byte[])o);
                return;
            }
            case 14: {
                this._ebean_set_folder((PaymentFolder)o);
                return;
            }
            case 15: {
                this._ebean_set_genericPurpose((String)o);
                return;
            }
            case 16: {
                this._ebean_set_salaryPayment((Boolean)o);
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private /* synthetic */ Object _ebean_getIdentity() {
        PaymentTemplate paymentTemplate = this;
        synchronized (paymentTemplate) {
            if (this._ebean_identity != null) {
                return this._ebean_identity;
            }
            Object tmpId = this._ebean_getField(0);
            this._ebean_identity = tmpId != null ? tmpId : new Object();
            return this._ebean_identity;
        }
    }

    public /* synthetic */ boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        return this._ebean_getIdentity().equals(((PaymentTemplate)obj)._ebean_getIdentity());
    }

    public /* synthetic */ int hashCode() {
        return this._ebean_getIdentity().hashCode();
    }

    public /* synthetic */ void _ebean_setEmbeddedLoaded() {
    }

    public /* synthetic */ boolean _ebean_isEmbeddedNewOrDirty() {
        return false;
    }

    public /* synthetic */ Object _ebean_newInstance() {
        return new PaymentTemplate();
    }
}

