/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.database.vo;

import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.FilterComparator;
import de.businesslogics.banking.database.vo.PaymentType;
import de.businesslogics.banking.database.vo.User;
import io.ebean.Expr;
import io.ebean.Expression;
import io.ebean.bean.EntityBean;
import io.ebean.bean.EntityBeanIntercept;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.OneToOne;
import javax.persistence.Table;

@Entity
@Table(name="recip_filter")
public class PaymentRecipientFilter
implements EntityBean {
    public static final String NO_VOP_RESULT = "NONE";
    @Id
    private Integer id;
    @OneToOne(optional=false)
    private User user;
    private PaymentType paymentType;
    @Column(name="payment_type_comp")
    private FilterComparator.PaymentType paymentTypeComparator;
    @Column(length=4)
    private String vopResult;
    @Column(name="vop_result_comp")
    private FilterComparator.PaymentType vopResultComparator;
    private String text;
    @Column(name="text_comp")
    private FilterComparator.Text textComparator;
    private java.sql.Date fromLastUsage;
    private java.sql.Date toLastUsage;
    @Column(name="last_usage_comp")
    private FilterComparator.Date lastUsageCompator;
    public static /* synthetic */ String[] _ebean_props;
    protected /* synthetic */ EntityBeanIntercept _ebean_intercept;
    protected transient /* synthetic */ Object _ebean_identity;

    private PaymentRecipientFilter(User user) {
        this._ebean_intercept = new EntityBeanIntercept((Object)this);
        this._ebean_set_paymentTypeComparator(FilterComparator.PaymentType.EQUAL);
        this._ebean_set_vopResultComparator(FilterComparator.PaymentType.EQUAL);
        this._ebean_set_user(user);
    }

    public static PaymentRecipientFilter getFilter(User user) {
        PaymentRecipientFilter f = (PaymentRecipientFilter)DB.find(PaymentRecipientFilter.class).where().eq("user", (Object)user).findOne();
        if (f == null) {
            f = new PaymentRecipientFilter(user);
        }
        return f;
    }

    public static void deleteByUser(User user) {
        PaymentRecipientFilter toDelete = PaymentRecipientFilter.getFilter(user);
        if (toDelete.id != null) {
            DB.delete(toDelete);
        }
    }

    public PaymentType getPaymentType() {
        return this._ebean_get_paymentType();
    }

    public void setPaymentType(PaymentType paymentType) {
        this._ebean_set_paymentType(paymentType);
    }

    public FilterComparator.PaymentType getPaymentTypeComparator() {
        return this._ebean_get_paymentTypeComparator();
    }

    public void setPaymentTypeComparator(FilterComparator.PaymentType paymentTypeComparator) {
        this._ebean_set_paymentTypeComparator(paymentTypeComparator);
    }

    public void setPaymentTypeComparator(int paymentTypeComparatorIndex) {
        if (paymentTypeComparatorIndex >= 0 && paymentTypeComparatorIndex < FilterComparator.PaymentType.values().length) {
            this.setPaymentTypeComparator(FilterComparator.PaymentType.values()[paymentTypeComparatorIndex]);
        } else {
            this.setPaymentTypeComparator(null);
        }
    }

    public String getVopResult() {
        return this._ebean_get_vopResult();
    }

    public void setVopResult(String vopResult) {
        this._ebean_set_vopResult(vopResult);
    }

    public FilterComparator.PaymentType getVopResultComparator() {
        return this._ebean_get_vopResultComparator();
    }

    public void setVopResultComparator(FilterComparator.PaymentType vopResultComparator) {
        this._ebean_set_vopResultComparator(vopResultComparator);
    }

    public void setVopResultComparator(int vopResultComparatorIndex) {
        if (vopResultComparatorIndex >= 0 && vopResultComparatorIndex < FilterComparator.PaymentType.values().length) {
            this.setVopResultComparator(FilterComparator.PaymentType.values()[vopResultComparatorIndex]);
        } else {
            this.setVopResultComparator(null);
        }
    }

    public String getText() {
        return this._ebean_get_text();
    }

    public void setText(String text) {
        if (text != null && text.trim().length() > 0) {
            this._ebean_set_text(text.trim());
        } else {
            this._ebean_set_text(null);
        }
    }

    public FilterComparator.Text getTextComparator() {
        return this._ebean_get_textComparator();
    }

    public void setTextComparator(FilterComparator.Text textComparator) {
        this._ebean_set_textComparator(textComparator);
    }

    public int getTextComparatorId() {
        if (this._ebean_get_textComparator() != null) {
            return this._ebean_get_textComparator().ordinal();
        }
        return 0;
    }

    public void setTextComparator(int textComparatorId) {
        if (textComparatorId >= 0 && textComparatorId < FilterComparator.Text.values().length) {
            this._ebean_set_textComparator(FilterComparator.Text.values()[textComparatorId]);
        } else {
            this._ebean_set_textComparator(null);
        }
    }

    public java.sql.Date getFromLastUsage() {
        return this._ebean_get_fromLastUsage();
    }

    public void setFromLastUsage(java.sql.Date fromLastUsage) {
        if (fromLastUsage == null) {
            this._ebean_set_fromLastUsage(null);
        } else {
            this._ebean_set_fromLastUsage(this.getDateAtTimeZero(fromLastUsage));
        }
    }

    private java.sql.Date getDateAtTimeZero(java.sql.Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(14, 0);
        cal.set(13, 0);
        cal.set(12, 0);
        cal.set(11, 0);
        return new java.sql.Date(cal.getTimeInMillis());
    }

    public java.sql.Date getToLastUsage() {
        return this._ebean_get_toLastUsage();
    }

    public void setToLastUsage(java.sql.Date toLastUsage) {
        if (toLastUsage == null) {
            this._ebean_set_toLastUsage(null);
        } else {
            this._ebean_set_toLastUsage(this.getDateAtTimeZero(toLastUsage));
        }
    }

    public FilterComparator.Date getLastUsageCompator() {
        return this._ebean_get_lastUsageCompator();
    }

    public void setLastUsageCompator(FilterComparator.Date lastUsageCompator) {
        this._ebean_set_lastUsageCompator(lastUsageCompator);
    }

    public void setLastUsageCompator(int lastUsageCompatorId) {
        if (lastUsageCompatorId >= 0 && lastUsageCompatorId < FilterComparator.Date.values().length) {
            this._ebean_set_lastUsageCompator(FilterComparator.Date.values()[lastUsageCompatorId]);
        } else {
            this._ebean_set_lastUsageCompator(null);
        }
    }

    public int getLastUsageCompatorId() {
        if (this._ebean_get_lastUsageCompator() != null) {
            return this._ebean_get_lastUsageCompator().ordinal();
        }
        return -1;
    }

    public void save() {
        if (this._ebean_get_id() == null) {
            DB.save(this);
        } else {
            DB.update(this);
        }
    }

    public void reset() {
        this._ebean_set_paymentType(null);
        this._ebean_set_paymentTypeComparator(null);
        this._ebean_set_vopResult(null);
        this._ebean_set_vopResultComparator(null);
        this._ebean_set_text(null);
        this._ebean_set_textComparator(null);
        this._ebean_set_fromLastUsage(null);
        this._ebean_set_toLastUsage(null);
        this._ebean_set_lastUsageCompator(null);
        this.save();
    }

    public Expression getExpression() {
        Expression toReturn = this.getPaymentTypeExpression();
        toReturn = this.addExpression(toReturn, this.getVopResultExpression());
        toReturn = this.addExpression(toReturn, this.getTextExpression());
        toReturn = this.addExpression(toReturn, this.getLastUsageExpression());
        return toReturn;
    }

    private Expression addExpression(Expression expression, Expression toAdd) {
        if (toAdd != null) {
            expression = expression == null ? toAdd : Expr.and((Expression)expression, (Expression)toAdd);
        }
        return expression;
    }

    private Expression getPaymentTypeExpression() {
        if (this._ebean_get_paymentType() != null) {
            if (FilterComparator.PaymentType.UNEQUAL.equals((Object)this._ebean_get_paymentTypeComparator())) {
                return Expr.ne((String)"paymentType", (Object)((Object)this._ebean_get_paymentType()));
            }
            return Expr.eq((String)"paymentType", (Object)((Object)this._ebean_get_paymentType()));
        }
        return null;
    }

    private Expression getVopResultExpression() {
        if (this._ebean_get_vopResult() != null) {
            if (NO_VOP_RESULT.equals(this._ebean_get_vopResult())) {
                if (FilterComparator.PaymentType.EQUAL.equals((Object)this._ebean_get_vopResultComparator())) {
                    return Expr.or((Expression)Expr.eq((String)"vopResult", (Object)""), (Expression)Expr.eq((String)"vopResult", null));
                }
                return Expr.and((Expression)Expr.ne((String)"vopResult", (Object)""), (Expression)Expr.ne((String)"vopResult", null));
            }
            if (FilterComparator.PaymentType.UNEQUAL.equals((Object)this._ebean_get_vopResultComparator())) {
                return Expr.or((Expression)Expr.ne((String)"vopResult", (Object)this._ebean_get_vopResult()), (Expression)Expr.or((Expression)Expr.eq((String)"vopResult", (Object)""), (Expression)Expr.eq((String)"vopResult", null)));
            }
            return Expr.eq((String)"vopResult", (Object)this._ebean_get_vopResult());
        }
        return null;
    }

    private Expression getTextExpression() {
        if (this._ebean_get_text() != null) {
            Expression sepaMandateId;
            Expression purpose;
            Expression bankName;
            Expression bankCode;
            Expression accountNumber;
            Expression name;
            Expression displayName;
            Object filter = "%" + this._ebean_get_text() + "%";
            if (this._ebean_get_textComparator() == FilterComparator.Text.STARTS_WITH || this._ebean_get_textComparator() == FilterComparator.Text.ENDS_WITH) {
                filter = this._ebean_get_text();
            }
            if (this._ebean_get_textComparator() == FilterComparator.Text.STARTS_WITH) {
                displayName = Expr.and((Expression)Expr.isNotNull((String)"displayName"), (Expression)Expr.istartsWith((String)"displayName", (String)filter));
                name = Expr.and((Expression)Expr.isNotNull((String)"name"), (Expression)Expr.istartsWith((String)"name", (String)filter));
                accountNumber = Expr.and((Expression)Expr.isNotNull((String)"accountNumber"), (Expression)Expr.istartsWith((String)"accountNumber", (String)filter));
                bankCode = Expr.and((Expression)Expr.isNotNull((String)"bankCode"), (Expression)Expr.istartsWith((String)"bankCode", (String)filter));
                bankName = Expr.and((Expression)Expr.isNotNull((String)"bankName"), (Expression)Expr.istartsWith((String)"bankName", (String)filter));
                purpose = Expr.and((Expression)Expr.isNotNull((String)"purpose"), (Expression)Expr.istartsWith((String)"purpose", (String)filter));
                sepaMandateId = Expr.and((Expression)Expr.isNotNull((String)"sepaMandateId"), (Expression)Expr.istartsWith((String)"sepaMandateId", (String)filter));
            } else if (this._ebean_get_textComparator() == FilterComparator.Text.ENDS_WITH) {
                displayName = Expr.and((Expression)Expr.isNotNull((String)"displayName"), (Expression)Expr.iendsWith((String)"displayName", (String)filter));
                name = Expr.and((Expression)Expr.isNotNull((String)"name"), (Expression)Expr.iendsWith((String)"name", (String)filter));
                accountNumber = Expr.and((Expression)Expr.isNotNull((String)"accountNumber"), (Expression)Expr.iendsWith((String)"accountNumber", (String)filter));
                bankCode = Expr.and((Expression)Expr.isNotNull((String)"bankCode"), (Expression)Expr.iendsWith((String)"bankCode", (String)filter));
                bankName = Expr.and((Expression)Expr.isNotNull((String)"bankName"), (Expression)Expr.iendsWith((String)"bankName", (String)filter));
                purpose = Expr.and((Expression)Expr.isNotNull((String)"purpose"), (Expression)Expr.iendsWith((String)"purpose", (String)filter));
                sepaMandateId = Expr.and((Expression)Expr.isNotNull((String)"sepaMandateId"), (Expression)Expr.iendsWith((String)"sepaMandateId", (String)filter));
            } else {
                displayName = Expr.ilike((String)"displayName", (String)filter);
                name = Expr.ilike((String)"name", (String)filter);
                accountNumber = Expr.ilike((String)"accountNumber", (String)filter);
                bankCode = Expr.ilike((String)"bankCode", (String)filter);
                bankName = Expr.ilike((String)"bankName", (String)filter);
                purpose = Expr.ilike((String)"purpose", (String)filter);
                sepaMandateId = Expr.ilike((String)"sepaMandateId", (String)filter);
            }
            Expression text = null;
            if (this._ebean_get_textComparator() == FilterComparator.Text.CONTAINS_NOT) {
                text = this.getNotExpression(displayName, "displayName");
                text = Expr.and((Expression)text, (Expression)this.getNotExpression(name, "name"));
                text = Expr.and((Expression)text, (Expression)this.getNotExpression(accountNumber, "accountNumber"));
                text = Expr.and((Expression)text, (Expression)this.getNotExpression(bankCode, "bankCode"));
                text = Expr.and((Expression)text, (Expression)this.getNotExpression(bankName, "bankName"));
                text = Expr.and((Expression)text, (Expression)this.getNotExpression(purpose, "purpose"));
                text = Expr.and((Expression)text, (Expression)this.getNotExpression(sepaMandateId, "sepaMandateId"));
            } else {
                text = displayName;
                text = Expr.or((Expression)text, (Expression)name);
                text = Expr.or((Expression)text, (Expression)accountNumber);
                text = Expr.or((Expression)text, (Expression)bankCode);
                text = Expr.or((Expression)text, (Expression)bankName);
                text = Expr.or((Expression)text, (Expression)purpose);
                text = Expr.or((Expression)text, (Expression)sepaMandateId);
            }
            return text;
        }
        return null;
    }

    private Expression getNotExpression(Expression expression, String fieldName) {
        return Expr.or((Expression)Expr.not((Expression)expression), (Expression)Expr.or((Expression)Expr.eq((String)fieldName, (Object)""), (Expression)Expr.eq((String)fieldName, null)));
    }

    private Expression getLastUsageExpression() {
        if (this._ebean_get_lastUsageCompator() == FilterComparator.Date.EQUAL && this._ebean_get_fromLastUsage() != null) {
            return Expr.between((String)"lastUsage", (Object)this._ebean_get_fromLastUsage(), (Object)this.getLatestAtDay(this._ebean_get_fromLastUsage()));
        }
        if (this._ebean_get_lastUsageCompator() == FilterComparator.Date.GREATER && this._ebean_get_fromLastUsage() != null) {
            return Expr.gt((String)"lastUsage", (Object)this._ebean_get_fromLastUsage());
        }
        if (this._ebean_get_lastUsageCompator() == FilterComparator.Date.BETWEEN && this._ebean_get_fromLastUsage() != null && this._ebean_get_toLastUsage() == null) {
            return Expr.ge((String)"lastUsage", (Object)this._ebean_get_fromLastUsage());
        }
        if (this._ebean_get_lastUsageCompator() == FilterComparator.Date.LESS && this._ebean_get_fromLastUsage() != null) {
            return Expr.lt((String)"lastUsage", (Object)this._ebean_get_fromLastUsage());
        }
        if (this._ebean_get_lastUsageCompator() == FilterComparator.Date.BETWEEN && this._ebean_get_fromLastUsage() == null && this._ebean_get_toLastUsage() != null) {
            return Expr.le((String)"lastUsage", (Object)this.getLatestAtDay(this._ebean_get_toLastUsage()));
        }
        if (this._ebean_get_lastUsageCompator() == FilterComparator.Date.BETWEEN && this._ebean_get_fromLastUsage() != null && this._ebean_get_toLastUsage() != null) {
            return Expr.between((String)"lastUsage", (Object)this._ebean_get_fromLastUsage(), (Object)this.getLatestAtDay(this._ebean_get_toLastUsage()));
        }
        return null;
    }

    private Timestamp getLatestAtDay(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(14, 999);
        cal.set(13, 59);
        cal.set(12, 59);
        cal.set(11, 23);
        return new Timestamp(cal.getTimeInMillis());
    }

    static {
        _ebean_props = new String[]{"id", "user", "paymentType", "paymentTypeComparator", "vopResult", "vopResultComparator", "text", "textComparator", "fromLastUsage", "toLastUsage", "lastUsageCompator"};
    }

    public /* synthetic */ PaymentRecipientFilter() {
        this._ebean_intercept = new EntityBeanIntercept((Object)this);
    }

    public /* synthetic */ String[] _ebean_getPropertyNames() {
        return _ebean_props;
    }

    public /* synthetic */ String _ebean_getPropertyName(int pos) {
        return _ebean_props[pos];
    }

    public /* synthetic */ EntityBeanIntercept _ebean_getIntercept() {
        return this._ebean_intercept;
    }

    public /* synthetic */ EntityBeanIntercept _ebean_intercept() {
        if (this._ebean_intercept == null) {
            this._ebean_intercept = new EntityBeanIntercept((Object)this);
        }
        return this._ebean_intercept;
    }

    protected /* synthetic */ Integer _ebean_get_id() {
        this._ebean_intercept.preGetId();
        return this.id;
    }

    protected /* synthetic */ void _ebean_set_id(Integer newValue) {
        this._ebean_intercept.preSetter(false, 0, (Object)this.id, (Object)newValue);
        this.id = newValue;
    }

    protected /* synthetic */ Integer _ebean_getni_id() {
        return this.id;
    }

    protected /* synthetic */ void _ebean_setni_id(Integer _newValue) {
        this.id = _newValue;
        this._ebean_intercept.setLoadedProperty(0);
    }

    protected /* synthetic */ User _ebean_get_user() {
        this._ebean_intercept.preGetter(1);
        return this.user;
    }

    protected /* synthetic */ void _ebean_set_user(User newValue) {
        this._ebean_intercept.preSetter(true, 1, (Object)this._ebean_get_user(), (Object)newValue);
        this.user = newValue;
    }

    protected /* synthetic */ User _ebean_getni_user() {
        return this.user;
    }

    protected /* synthetic */ void _ebean_setni_user(User _newValue) {
        this.user = _newValue;
        this._ebean_intercept.setLoadedProperty(1);
    }

    protected /* synthetic */ PaymentType _ebean_get_paymentType() {
        this._ebean_intercept.preGetter(2);
        return this.paymentType;
    }

    protected /* synthetic */ void _ebean_set_paymentType(PaymentType newValue) {
        this._ebean_intercept.preSetter(true, 2, (Object)this._ebean_get_paymentType(), (Object)newValue);
        this.paymentType = newValue;
    }

    protected /* synthetic */ PaymentType _ebean_getni_paymentType() {
        return this.paymentType;
    }

    protected /* synthetic */ void _ebean_setni_paymentType(PaymentType _newValue) {
        this.paymentType = _newValue;
        this._ebean_intercept.setLoadedProperty(2);
    }

    protected /* synthetic */ FilterComparator.PaymentType _ebean_get_paymentTypeComparator() {
        this._ebean_intercept.preGetter(3);
        return this.paymentTypeComparator;
    }

    protected /* synthetic */ void _ebean_set_paymentTypeComparator(FilterComparator.PaymentType newValue) {
        this._ebean_intercept.preSetter(true, 3, (Object)this._ebean_get_paymentTypeComparator(), (Object)newValue);
        this.paymentTypeComparator = newValue;
    }

    protected /* synthetic */ FilterComparator.PaymentType _ebean_getni_paymentTypeComparator() {
        return this.paymentTypeComparator;
    }

    protected /* synthetic */ void _ebean_setni_paymentTypeComparator(FilterComparator.PaymentType _newValue) {
        this.paymentTypeComparator = _newValue;
        this._ebean_intercept.setLoadedProperty(3);
    }

    protected /* synthetic */ String _ebean_get_vopResult() {
        this._ebean_intercept.preGetter(4);
        return this.vopResult;
    }

    protected /* synthetic */ void _ebean_set_vopResult(String newValue) {
        this._ebean_intercept.preSetter(true, 4, (Object)this._ebean_get_vopResult(), (Object)newValue);
        this.vopResult = newValue;
    }

    protected /* synthetic */ String _ebean_getni_vopResult() {
        return this.vopResult;
    }

    protected /* synthetic */ void _ebean_setni_vopResult(String _newValue) {
        this.vopResult = _newValue;
        this._ebean_intercept.setLoadedProperty(4);
    }

    protected /* synthetic */ FilterComparator.PaymentType _ebean_get_vopResultComparator() {
        this._ebean_intercept.preGetter(5);
        return this.vopResultComparator;
    }

    protected /* synthetic */ void _ebean_set_vopResultComparator(FilterComparator.PaymentType newValue) {
        this._ebean_intercept.preSetter(true, 5, (Object)this._ebean_get_vopResultComparator(), (Object)newValue);
        this.vopResultComparator = newValue;
    }

    protected /* synthetic */ FilterComparator.PaymentType _ebean_getni_vopResultComparator() {
        return this.vopResultComparator;
    }

    protected /* synthetic */ void _ebean_setni_vopResultComparator(FilterComparator.PaymentType _newValue) {
        this.vopResultComparator = _newValue;
        this._ebean_intercept.setLoadedProperty(5);
    }

    protected /* synthetic */ String _ebean_get_text() {
        this._ebean_intercept.preGetter(6);
        return this.text;
    }

    protected /* synthetic */ void _ebean_set_text(String newValue) {
        this._ebean_intercept.preSetter(true, 6, (Object)this._ebean_get_text(), (Object)newValue);
        this.text = newValue;
    }

    protected /* synthetic */ String _ebean_getni_text() {
        return this.text;
    }

    protected /* synthetic */ void _ebean_setni_text(String _newValue) {
        this.text = _newValue;
        this._ebean_intercept.setLoadedProperty(6);
    }

    protected /* synthetic */ FilterComparator.Text _ebean_get_textComparator() {
        this._ebean_intercept.preGetter(7);
        return this.textComparator;
    }

    protected /* synthetic */ void _ebean_set_textComparator(FilterComparator.Text newValue) {
        this._ebean_intercept.preSetter(true, 7, (Object)this._ebean_get_textComparator(), (Object)newValue);
        this.textComparator = newValue;
    }

    protected /* synthetic */ FilterComparator.Text _ebean_getni_textComparator() {
        return this.textComparator;
    }

    protected /* synthetic */ void _ebean_setni_textComparator(FilterComparator.Text _newValue) {
        this.textComparator = _newValue;
        this._ebean_intercept.setLoadedProperty(7);
    }

    protected /* synthetic */ java.sql.Date _ebean_get_fromLastUsage() {
        this._ebean_intercept.preGetter(8);
        return this.fromLastUsage;
    }

    protected /* synthetic */ void _ebean_set_fromLastUsage(java.sql.Date newValue) {
        this._ebean_intercept.preSetter(true, 8, (Object)this._ebean_get_fromLastUsage(), (Object)newValue);
        this.fromLastUsage = newValue;
    }

    protected /* synthetic */ java.sql.Date _ebean_getni_fromLastUsage() {
        return this.fromLastUsage;
    }

    protected /* synthetic */ void _ebean_setni_fromLastUsage(java.sql.Date _newValue) {
        this.fromLastUsage = _newValue;
        this._ebean_intercept.setLoadedProperty(8);
    }

    protected /* synthetic */ java.sql.Date _ebean_get_toLastUsage() {
        this._ebean_intercept.preGetter(9);
        return this.toLastUsage;
    }

    protected /* synthetic */ void _ebean_set_toLastUsage(java.sql.Date newValue) {
        this._ebean_intercept.preSetter(true, 9, (Object)this._ebean_get_toLastUsage(), (Object)newValue);
        this.toLastUsage = newValue;
    }

    protected /* synthetic */ java.sql.Date _ebean_getni_toLastUsage() {
        return this.toLastUsage;
    }

    protected /* synthetic */ void _ebean_setni_toLastUsage(java.sql.Date _newValue) {
        this.toLastUsage = _newValue;
        this._ebean_intercept.setLoadedProperty(9);
    }

    protected /* synthetic */ FilterComparator.Date _ebean_get_lastUsageCompator() {
        this._ebean_intercept.preGetter(10);
        return this.lastUsageCompator;
    }

    protected /* synthetic */ void _ebean_set_lastUsageCompator(FilterComparator.Date newValue) {
        this._ebean_intercept.preSetter(true, 10, (Object)this._ebean_get_lastUsageCompator(), (Object)newValue);
        this.lastUsageCompator = newValue;
    }

    protected /* synthetic */ FilterComparator.Date _ebean_getni_lastUsageCompator() {
        return this.lastUsageCompator;
    }

    protected /* synthetic */ void _ebean_setni_lastUsageCompator(FilterComparator.Date _newValue) {
        this.lastUsageCompator = _newValue;
        this._ebean_intercept.setLoadedProperty(10);
    }

    public /* synthetic */ Object _ebean_getField(int index) {
        switch (index) {
            case 0: {
                return this.id;
            }
            case 1: {
                return this.user;
            }
            case 2: {
                return this.paymentType;
            }
            case 3: {
                return this.paymentTypeComparator;
            }
            case 4: {
                return this.vopResult;
            }
            case 5: {
                return this.vopResultComparator;
            }
            case 6: {
                return this.text;
            }
            case 7: {
                return this.textComparator;
            }
            case 8: {
                return this.fromLastUsage;
            }
            case 9: {
                return this.toLastUsage;
            }
            case 10: {
                return this.lastUsageCompator;
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    public /* synthetic */ Object _ebean_getFieldIntercept(int index) {
        switch (index) {
            case 0: {
                return this._ebean_get_id();
            }
            case 1: {
                return this._ebean_get_user();
            }
            case 2: {
                return this._ebean_get_paymentType();
            }
            case 3: {
                return this._ebean_get_paymentTypeComparator();
            }
            case 4: {
                return this._ebean_get_vopResult();
            }
            case 5: {
                return this._ebean_get_vopResultComparator();
            }
            case 6: {
                return this._ebean_get_text();
            }
            case 7: {
                return this._ebean_get_textComparator();
            }
            case 8: {
                return this._ebean_get_fromLastUsage();
            }
            case 9: {
                return this._ebean_get_toLastUsage();
            }
            case 10: {
                return this._ebean_get_lastUsageCompator();
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    public /* synthetic */ void _ebean_setField(int index, Object o) {
        switch (index) {
            case 0: {
                this._ebean_setni_id((Integer)o);
                return;
            }
            case 1: {
                this._ebean_setni_user((User)o);
                return;
            }
            case 2: {
                this._ebean_setni_paymentType((PaymentType)((Object)o));
                return;
            }
            case 3: {
                this._ebean_setni_paymentTypeComparator((FilterComparator.PaymentType)((Object)o));
                return;
            }
            case 4: {
                this._ebean_setni_vopResult((String)o);
                return;
            }
            case 5: {
                this._ebean_setni_vopResultComparator((FilterComparator.PaymentType)((Object)o));
                return;
            }
            case 6: {
                this._ebean_setni_text((String)o);
                return;
            }
            case 7: {
                this._ebean_setni_textComparator((FilterComparator.Text)((Object)o));
                return;
            }
            case 8: {
                this._ebean_setni_fromLastUsage((java.sql.Date)o);
                return;
            }
            case 9: {
                this._ebean_setni_toLastUsage((java.sql.Date)o);
                return;
            }
            case 10: {
                this._ebean_setni_lastUsageCompator((FilterComparator.Date)((Object)o));
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    public /* synthetic */ void _ebean_setFieldIntercept(int index, Object o) {
        switch (index) {
            case 0: {
                this._ebean_set_id((Integer)o);
                return;
            }
            case 1: {
                this._ebean_set_user((User)o);
                return;
            }
            case 2: {
                this._ebean_set_paymentType((PaymentType)((Object)o));
                return;
            }
            case 3: {
                this._ebean_set_paymentTypeComparator((FilterComparator.PaymentType)((Object)o));
                return;
            }
            case 4: {
                this._ebean_set_vopResult((String)o);
                return;
            }
            case 5: {
                this._ebean_set_vopResultComparator((FilterComparator.PaymentType)((Object)o));
                return;
            }
            case 6: {
                this._ebean_set_text((String)o);
                return;
            }
            case 7: {
                this._ebean_set_textComparator((FilterComparator.Text)((Object)o));
                return;
            }
            case 8: {
                this._ebean_set_fromLastUsage((java.sql.Date)o);
                return;
            }
            case 9: {
                this._ebean_set_toLastUsage((java.sql.Date)o);
                return;
            }
            case 10: {
                this._ebean_set_lastUsageCompator((FilterComparator.Date)((Object)o));
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private /* synthetic */ Object _ebean_getIdentity() {
        PaymentRecipientFilter paymentRecipientFilter = this;
        synchronized (paymentRecipientFilter) {
            if (this._ebean_identity != null) {
                return this._ebean_identity;
            }
            Object tmpId = this._ebean_getField(0);
            this._ebean_identity = tmpId != null ? tmpId : new Object();
            return this._ebean_identity;
        }
    }

    public /* synthetic */ boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        return this._ebean_getIdentity().equals(((PaymentRecipientFilter)obj)._ebean_getIdentity());
    }

    public /* synthetic */ int hashCode() {
        return this._ebean_getIdentity().hashCode();
    }

    public /* synthetic */ void _ebean_setEmbeddedLoaded() {
    }

    public /* synthetic */ boolean _ebean_isEmbeddedNewOrDirty() {
        return false;
    }

    public /* synthetic */ Object _ebean_newInstance() {
        return new PaymentRecipientFilter();
    }
}

