/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.database.vo;

import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.HistoryLog;
import de.businesslogics.banking.database.vo.PaymentType;
import de.businesslogics.banking.database.vo.Tenant;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.iban.IbanUtil;
import io.ebean.Expr;
import io.ebean.Expression;
import io.ebean.ExpressionList;
import io.ebean.Query;
import io.ebean.Update;
import io.ebean.annotation.Index;
import io.ebean.annotation.Indices;
import io.ebean.bean.EntityBean;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

@Entity
@Table(name="pmt_recipient")
@Indices(value={@Index(name="ix_pmt_recipient_display_name", columnNames={"payment_type", "display_name"}), @Index(name="ix_pmt_recipient_name", columnNames={"payment_type", "name"})})
public class PaymentRecipient
extends HistoryLog
implements EntityBean {
    @Column(nullable=false)
    private PaymentType paymentType;
    @ManyToOne(optional=false)
    private Tenant tenant;
    @Column(length=128)
    private String displayName;
    @Column(length=70)
    private String name;
    @Column(length=40)
    private String accountNumber;
    @Column(length=34)
    private String bankCode;
    @Column(length=128)
    private String bankName;
    @Column(length=400)
    private String purpose;
    @Column(length=35)
    private String reference;
    @Column(length=35)
    private String sepaMandateId;
    @Lob
    @Basic(fetch=FetchType.EAGER)
    private String recipientInfo;
    @Column(length=70)
    private String vopName;
    @Column(length=4)
    private String vopResult;
    @Column(length=4)
    private String vopReason;
    @Column(length=210)
    private String vopAdditionalInfo;
    private Timestamp vopDate;
    private Timestamp lastUsage;
    public static /* synthetic */ String[] _ebean_props;

    public PaymentRecipient reload() {
        if (this._ebean_get_businessId() != null) {
            ExpressionList expr = DB.find(PaymentRecipient.class).where();
            expr.eq("businessId", (Object)this._ebean_get_businessId());
            expr.ne("version", (Object)HistoryLog.Version.HISTORIC);
            expr.setMaxRows(1);
            List recipients = expr.findList();
            if (recipients.size() > 0) {
                return (PaymentRecipient)recipients.get(0);
            }
        } else if (this.getId() != null) {
            ExpressionList expr = DB.find(PaymentRecipient.class).where();
            expr.eq("id", (Object)this.getId());
            expr.ne("version", (Object)HistoryLog.Version.HISTORIC);
            expr.setMaxRows(1);
            List recipients = expr.findList();
            if (recipients.size() > 0) {
                return (PaymentRecipient)recipients.get(0);
            }
        }
        return null;
    }

    public PaymentRecipient findOriginalRecipient() {
        if (this.getId() != null) {
            return DB.find(PaymentRecipient.class, this.getId());
        }
        return null;
    }

    @Override
    public HistoryLog findOriginalEntry() {
        return this.findOriginalRecipient();
    }

    @Override
    public void confirm(User user, Integer id, Integer businessId) {
        Update<PaymentRecipient> update = DB.createUpdate(PaymentRecipient.class, "UPDATE PaymentRecipient SET confirmedUser = :param1, confirmed = :param2, version = :param3, businessId = :param4 WHERE id = :param5");
        update.set("param1", (Object)user.getId());
        update.set("param2", (Object)new Timestamp(System.currentTimeMillis()));
        update.set("param3", (Object)HistoryLog.Version.CURRENT);
        update.set("param4", (Object)(businessId != null ? businessId : id));
        update.set("param5", (Object)id);
        update.execute();
    }

    @Override
    public void discard(User user, Integer id, Integer businessId) {
        Update<PaymentRecipient> update = DB.createUpdate(PaymentRecipient.class, "UPDATE PaymentRecipient SET confirmedUser = :param1, confirmed = :param2, version = :param3, deleted = :param4, businessId = :param5 WHERE id = :param6");
        update.set("param1", (Object)user.getId());
        update.set("param2", (Object)new Timestamp(System.currentTimeMillis()));
        update.set("param3", (Object)HistoryLog.Version.HISTORIC);
        update.set("param4", (Object)true);
        update.set("param5", (Object)(businessId != null ? businessId : id));
        update.set("param6", (Object)id);
        update.execute();
    }

    public PaymentRecipient findHistoricRecipient() {
        if (this._ebean_get_businessId() != null) {
            ExpressionList expr = DB.find(PaymentRecipient.class).where();
            expr.eq("businessId", (Object)this._ebean_get_businessId());
            expr.eq("version", (Object)HistoryLog.Version.HISTORIC);
            expr.eq("deleted", (Object)false);
            expr.orderBy().desc("created");
            expr.setMaxRows(1);
            List recipients = expr.findList();
            if (recipients.size() > 0) {
                return (PaymentRecipient)recipients.get(0);
            }
        }
        return null;
    }

    @Override
    public HistoryLog findHistoricEntry() {
        return this.findHistoricRecipient();
    }

    public Query<PaymentRecipient> findHistoricEntries() {
        ExpressionList expr = this._ebean_get_businessId() != null ? DB.find(PaymentRecipient.class).where().eq("businessId", (Object)this._ebean_get_businessId()) : DB.find(PaymentRecipient.class).where().eq("id", (Object)this.getId());
        expr.orderBy().desc("created");
        return expr.query();
    }

    public static void lockRecipient(User user, PaymentRecipient recipient) {
        Update<PaymentRecipient> update = DB.createUpdate(PaymentRecipient.class, "UPDATE PaymentRecipient SET lockingUser = :userId WHERE id = :recipientId");
        update.set("userId", (Object)user.getId());
        update.set("recipientId", (Object)recipient.getId());
        update.execute();
    }

    public static void unlockRecipient(PaymentRecipient recipient) {
        Update<PaymentRecipient> update = DB.createUpdate(PaymentRecipient.class, "UPDATE PaymentRecipient SET lockingUser = NULL WHERE id = :recipientId");
        update.set("recipientId", (Object)recipient.getId());
        update.execute();
    }

    public static int unlockRecipients() {
        Update<PaymentRecipient> update = DB.createUpdate(PaymentRecipient.class, "UPDATE PaymentRecipient SET lockingUser = NULL WHERE lockingUser IS NOT NULL");
        return update.execute();
    }

    public static Query<PaymentRecipient> findRecipients(User user) {
        return PaymentRecipient.findRecipientQuery(null, null, user.getTenants(), false, true);
    }

    public static Query<PaymentRecipient> findRecipients(User user, List<PaymentType> paymentTypes) {
        return PaymentRecipient.findRecipientQuery(null, paymentTypes, user.getTenants(), false, true);
    }

    public static PaymentRecipient findById(int id, User user) {
        return (PaymentRecipient)PaymentRecipient.findRecipientQuery(Collections.singletonList(id), null, user.getTenants(), false, true).findOne();
    }

    public static PaymentRecipient findByIdAndTenants(int id, Collection<Tenant> admissibleTenants) {
        return (PaymentRecipient)PaymentRecipient.findRecipientQuery(Collections.singletonList(id), null, admissibleTenants, false, true).findOne();
    }

    public static List<PaymentRecipient> findByIds(Collection<Integer> ids, User user) {
        return PaymentRecipient.findRecipientQuery(ids, null, user.getTenants(), false, true).findList();
    }

    public static List<PaymentRecipient> findRecipientsForPaymentType(PaymentType paymentType, List<Tenant> tenants) {
        return PaymentRecipient.findRecipientQuery(null, Collections.singletonList(paymentType), tenants, true, false).findList();
    }

    public static List<PaymentRecipient> findRecipientsForPaymentTypes(Collection<PaymentType> paymentTypes, List<Tenant> tenants) {
        return PaymentRecipient.findRecipientQuery(null, paymentTypes, tenants, true, false).findList();
    }

    public static int countRecipientsForPaymentType(PaymentType paymentType, List<Tenant> tenants) {
        return PaymentRecipient.findRecipientQuery(null, Collections.singletonList(paymentType), tenants, true, false).findCount();
    }

    public static int countRecipientsForPaymentTypes(Collection<PaymentType> paymentTypes, List<Tenant> tenants) {
        return PaymentRecipient.findRecipientQuery(null, paymentTypes, tenants, true, false).findCount();
    }

    public static PaymentRecipient findRecipientByDisplayName(PaymentType paymentType, String displayName, Tenant tenant) {
        return (PaymentRecipient)PaymentRecipient.findRecipientQuery(null, Collections.singletonList(paymentType), Collections.singletonList(tenant), true, false).where().eq("displayName", (Object)displayName).setMaxRows(1).findOne();
    }

    public static PaymentRecipient findNonHistoricRecipientByDisplayName(PaymentType paymentType, String displayName, Tenant tenant) {
        return (PaymentRecipient)PaymentRecipient.findRecipientQuery(null, Collections.singletonList(paymentType), Collections.singletonList(tenant), false, true).where().eq("displayName", (Object)displayName).setMaxRows(1).findOne();
    }

    public static PaymentRecipient findRecipientByDisplayName(Collection<PaymentType> paymentTypes, String displayName, Tenant tenant) {
        return (PaymentRecipient)PaymentRecipient.findRecipientQuery(null, paymentTypes, Collections.singletonList(tenant), true, false).where().eq("displayName", (Object)displayName).setMaxRows(1).findOne();
    }

    public static List<PaymentRecipient> findRecipientByName(PaymentType paymentType, String name, Tenant tenant) {
        return PaymentRecipient.findRecipientQuery(null, Collections.singletonList(paymentType), Collections.singletonList(tenant), true, false).where().eq("name", (Object)name).findList();
    }

    public static List<PaymentRecipient> findRecipientByName(Collection<PaymentType> paymentTypes, String name, Tenant tenant) {
        return PaymentRecipient.findRecipientQuery(null, paymentTypes, Collections.singletonList(tenant), true, false).where().eq("name", (Object)name).findList();
    }

    public static PaymentRecipient findSepaRecipientWithNewestVopResult(String name, String iban, Tenant tenant) {
        ExpressionList result = DB.find(PaymentRecipient.class).where().eq("tenant", (Object)tenant);
        result = result.eq("paymentType", (Object)PaymentType.SEPA);
        result = result.eq("version", (Object)HistoryLog.Version.CURRENT);
        result = result.ne("vopDate", null);
        result = result.eq("name", (Object)name);
        result = result.eq("accountNumber", (Object)iban.replace(" ", ""));
        return (PaymentRecipient)result.orderBy("vopDate desc, id desc").query().setMaxRows(1).findOne();
    }

    public static PaymentRecipient findRecipientByAccountInfo(PaymentType paymentType, String name, String accountNumber, String bankCode, Tenant tenant) {
        return PaymentRecipient.findRecipientByAccountInfo(Collections.singletonList(paymentType), name, accountNumber, bankCode, Collections.singletonList(tenant));
    }

    public static PaymentRecipient findRecipientByAccountInfo(List<PaymentType> paymentTypes, String name, String accountNumber, String bankCode, List<Tenant> tenants) {
        ExpressionList expr = PaymentRecipient.findRecipientQuery(null, paymentTypes, tenants, true, false).where().eq("accountNumber", (Object)accountNumber);
        if (bankCode != null && bankCode.length() > 0) {
            expr.eq("bankCode", (Object)bankCode);
        }
        if (name != null && name.length() > 0) {
            expr.ieq("name", name);
        }
        return (PaymentRecipient)expr.setMaxRows(1).findOne();
    }

    public static List<PaymentRecipient> findRecipientsWithDifferentVopName(User user) {
        List recipients = PaymentRecipient.findRecipientQuery(null, null, user.getTenants(), false, true).where().ne("vopName", null).findList();
        recipients.removeIf(r -> r.name.equals(r.getVopName()));
        return recipients;
    }

    public static PaymentRecipient findSEPAMandateByAccountAndMandateId(String name, String accountNumber, String bankCode, String sepaMandateId, Tenant tenant) {
        ExpressionList expr = PaymentRecipient.findRecipientQuery(null, Collections.singletonList(PaymentType.MANDATE), Collections.singletonList(tenant), true, false).where().ieq("name", name).eq("accountNumber", (Object)accountNumber);
        if (bankCode != null && bankCode.length() > 0) {
            expr.eq("bankCode", (Object)bankCode);
        }
        expr.eq("sepaMandateId", (Object)sepaMandateId);
        return (PaymentRecipient)expr.setMaxRows(1).findOne();
    }

    public static List<PaymentRecipient> findRecipientsByNameOrAccountNumberLike(Collection<PaymentType> paymentTypes, String nameOrAccountNumber, List<Tenant> tenants) {
        if (nameOrAccountNumber == null || nameOrAccountNumber.length() == 0) {
            return PaymentRecipient.findRecipientQuery(null, paymentTypes, tenants, true, false).setMaxRows(50).orderBy("displayName").findList();
        }
        Expression e1 = Expr.ilike((String)"displayName", (String)("%" + nameOrAccountNumber + "%"));
        Expression e2 = Expr.ilike((String)"accountNumber", (String)("%" + nameOrAccountNumber + "%"));
        return PaymentRecipient.findRecipientQuery(null, paymentTypes, tenants, true, false).where().or(e1, e2).setMaxRows(50).orderBy("displayName").findList();
    }

    public static List<PaymentRecipient> findSepaMandateLike(String content, List<Tenant> tenants) {
        content = "%" + (String)content + "%";
        return PaymentRecipient.findRecipientQuery(null, Collections.singletonList(PaymentType.MANDATE), tenants, true, false).where().disjunction().ilike("displayName", (String)content).ilike("name", (String)content).ilike("accountNumber", (String)content).ilike("bankCode", (String)content).endJunction().setMaxRows(50).findList();
    }

    public static PaymentRecipient findNonHistoricSepaMandateByMandateId(String sepaMandateId, Tenant tenant) {
        return (PaymentRecipient)PaymentRecipient.findRecipientQuery(null, Collections.singletonList(PaymentType.MANDATE), Collections.singletonList(tenant), false, true).where().eq("sepaMandateId", (Object)sepaMandateId).setMaxRows(1).findOne();
    }

    public static PaymentRecipient findSepaMandateByMandateId(String sepaMandateId, Tenant tenant) {
        return PaymentRecipient.findBySepaMandateId(PaymentType.MANDATE, sepaMandateId, tenant);
    }

    @Deprecated
    public static PaymentRecipient findSepaRecipientByMandateId(String sepaMandateId, Tenant tenant) {
        return PaymentRecipient.findBySepaMandateId(PaymentType.SEPA, sepaMandateId, tenant);
    }

    private static PaymentRecipient findBySepaMandateId(PaymentType paymentType, String sepaMandateId, Tenant tenant) {
        return (PaymentRecipient)PaymentRecipient.findRecipientQuery(null, Collections.singletonList(paymentType), Collections.singletonList(tenant), true, false).where().eq("sepaMandateId", (Object)sepaMandateId).setMaxRows(1).findOne();
    }

    private static Query<PaymentRecipient> findRecipientQuery(Collection<Integer> ids, Collection<PaymentType> paymentTypes, Collection<Tenant> tenants, boolean current, boolean nonHistoric) {
        ExpressionList result = DB.find(PaymentRecipient.class).where().in("tenant", tenants);
        if (ids != null) {
            result = result.in("id", ids);
        }
        if (paymentTypes != null) {
            result = result.in("paymentType", paymentTypes);
        }
        if (current) {
            result = result.eq("version", (Object)HistoryLog.Version.CURRENT);
        }
        if (nonHistoric) {
            result = result.ne("version", (Object)HistoryLog.Version.HISTORIC);
        }
        return result.orderBy("displayName asc, id asc").query();
    }

    public PaymentType getPaymentType() {
        return this._ebean_get_paymentType();
    }

    public void setPaymentType(PaymentType paymentType) {
        this._ebean_set_paymentType(paymentType);
    }

    public Tenant getTenant() {
        return this._ebean_get_tenant();
    }

    public void setTenant(Tenant tenant) {
        this._ebean_set_tenant(tenant);
    }

    public String getDisplayName() {
        return this._ebean_get_displayName();
    }

    public void setDisplayName(String displayName) {
        this._ebean_set_displayName(displayName);
    }

    public String getName() {
        return this._ebean_get_name();
    }

    public void setName(String name) {
        this._ebean_set_name(name);
    }

    public String getAccountNumber() {
        return this._ebean_get_accountNumber();
    }

    public void setAccountNumber(String accountNumber) {
        this._ebean_set_accountNumber(accountNumber);
    }

    public String getBankCode() {
        return this._ebean_get_bankCode();
    }

    public void setBankCode(String bankCode) {
        this._ebean_set_bankCode(bankCode);
    }

    public String getBankName() {
        return this._ebean_get_bankName();
    }

    public void setBankName(String bankName) {
        this._ebean_set_bankName(bankName);
    }

    public String getPurpose() {
        return this._ebean_get_purpose();
    }

    public void setPurpose(String purpose) {
        this._ebean_set_purpose(purpose);
    }

    public String getReference() {
        return this._ebean_get_reference();
    }

    public void setReference(String reference) {
        this._ebean_set_reference(reference);
    }

    public String getSepaMandateId() {
        return this._ebean_get_sepaMandateId();
    }

    public void setSepaMandateId(String sepaMandateId) {
        this._ebean_set_sepaMandateId(sepaMandateId);
    }

    public String getRecipientInfo() {
        return this._ebean_get_recipientInfo();
    }

    public void setRecipientInfo(String recipientInfo) {
        this._ebean_set_recipientInfo(recipientInfo);
    }

    public String getVopName() {
        return this._ebean_get_vopName();
    }

    public void setVopName(String vopName) {
        this._ebean_set_vopName(vopName);
    }

    public String getVopResult() {
        return this._ebean_get_vopResult();
    }

    public void setVopResult(String vopResult) {
        this._ebean_set_vopResult(vopResult);
    }

    public String getVopReason() {
        return this._ebean_get_vopReason();
    }

    public void setVopReason(String vopReason) {
        this._ebean_set_vopReason(vopReason);
    }

    public String getVopAdditionalInfo() {
        return this._ebean_get_vopAdditionalInfo();
    }

    public void setVopAdditionalInfo(String vopAdditionalInfo) {
        this._ebean_set_vopAdditionalInfo(vopAdditionalInfo);
    }

    public Timestamp getVopDate() {
        return this._ebean_get_vopDate();
    }

    public void setVopDate(Timestamp vopDate) {
        this._ebean_set_vopDate(vopDate);
    }

    public Timestamp getLastUsage() {
        return this._ebean_get_lastUsage();
    }

    public void setLastUsage(Timestamp lastUsage) {
        this._ebean_set_lastUsage(lastUsage);
    }

    public String getDisplayNameWithAccountNumber() {
        if (this._ebean_get_accountNumber() != null && this._ebean_get_accountNumber().length() > 0) {
            return this._ebean_get_displayName() + " (" + IbanUtil.formatIfIBAN(this._ebean_get_accountNumber()) + ")";
        }
        return this._ebean_get_displayName();
    }

    public static Expression getFilterExpression(String searchString) {
        if (searchString == null || searchString.length() == 0) {
            return null;
        }
        String like = "%" + searchString + "%";
        Expression expression = Expr.ilike((String)"displayName", (String)like);
        expression = Expr.or((Expression)expression, (Expression)Expr.ilike((String)"name", (String)like));
        expression = Expr.or((Expression)expression, (Expression)Expr.like((String)"accountNumber", (String)like));
        expression = Expr.or((Expression)expression, (Expression)Expr.like((String)"bankCode", (String)like));
        expression = Expr.or((Expression)expression, (Expression)Expr.ilike((String)"bankName", (String)like));
        expression = Expr.or((Expression)expression, (Expression)Expr.like((String)"purpose", (String)like));
        expression = Expr.or((Expression)expression, (Expression)Expr.like((String)"sepaMandateId", (String)like));
        return expression;
    }

    static {
        _ebean_props = new String[]{"id", "businessId", "createdUser", "created", "confirmedUser", "confirmed", "version", "lockingUser", "deleted", "hasFourEyesChange", "paymentType", "tenant", "displayName", "name", "accountNumber", "bankCode", "bankName", "purpose", "reference", "sepaMandateId", "recipientInfo", "vopName", "vopResult", "vopReason", "vopAdditionalInfo", "vopDate", "lastUsage"};
    }

    @Override
    public /* synthetic */ String[] _ebean_getPropertyNames() {
        return _ebean_props;
    }

    @Override
    public /* synthetic */ String _ebean_getPropertyName(int pos) {
        return _ebean_props[pos];
    }

    protected /* synthetic */ PaymentType _ebean_get_paymentType() {
        this._ebean_intercept.preGetter(10);
        return this.paymentType;
    }

    protected /* synthetic */ void _ebean_set_paymentType(PaymentType newValue) {
        this._ebean_intercept.preSetter(true, 10, (Object)this._ebean_get_paymentType(), (Object)newValue);
        this.paymentType = newValue;
    }

    protected /* synthetic */ PaymentType _ebean_getni_paymentType() {
        return this.paymentType;
    }

    protected /* synthetic */ void _ebean_setni_paymentType(PaymentType _newValue) {
        this.paymentType = _newValue;
        this._ebean_intercept.setLoadedProperty(10);
    }

    protected /* synthetic */ Tenant _ebean_get_tenant() {
        this._ebean_intercept.preGetter(11);
        return this.tenant;
    }

    protected /* synthetic */ void _ebean_set_tenant(Tenant newValue) {
        this._ebean_intercept.preSetter(true, 11, (Object)this._ebean_get_tenant(), (Object)newValue);
        this.tenant = newValue;
    }

    protected /* synthetic */ Tenant _ebean_getni_tenant() {
        return this.tenant;
    }

    protected /* synthetic */ void _ebean_setni_tenant(Tenant _newValue) {
        this.tenant = _newValue;
        this._ebean_intercept.setLoadedProperty(11);
    }

    protected /* synthetic */ String _ebean_get_displayName() {
        this._ebean_intercept.preGetter(12);
        return this.displayName;
    }

    protected /* synthetic */ void _ebean_set_displayName(String newValue) {
        this._ebean_intercept.preSetter(true, 12, (Object)this._ebean_get_displayName(), (Object)newValue);
        this.displayName = newValue;
    }

    protected /* synthetic */ String _ebean_getni_displayName() {
        return this.displayName;
    }

    protected /* synthetic */ void _ebean_setni_displayName(String _newValue) {
        this.displayName = _newValue;
        this._ebean_intercept.setLoadedProperty(12);
    }

    protected /* synthetic */ String _ebean_get_name() {
        this._ebean_intercept.preGetter(13);
        return this.name;
    }

    protected /* synthetic */ void _ebean_set_name(String newValue) {
        this._ebean_intercept.preSetter(true, 13, (Object)this._ebean_get_name(), (Object)newValue);
        this.name = newValue;
    }

    protected /* synthetic */ String _ebean_getni_name() {
        return this.name;
    }

    protected /* synthetic */ void _ebean_setni_name(String _newValue) {
        this.name = _newValue;
        this._ebean_intercept.setLoadedProperty(13);
    }

    protected /* synthetic */ String _ebean_get_accountNumber() {
        this._ebean_intercept.preGetter(14);
        return this.accountNumber;
    }

    protected /* synthetic */ void _ebean_set_accountNumber(String newValue) {
        this._ebean_intercept.preSetter(true, 14, (Object)this._ebean_get_accountNumber(), (Object)newValue);
        this.accountNumber = newValue;
    }

    protected /* synthetic */ String _ebean_getni_accountNumber() {
        return this.accountNumber;
    }

    protected /* synthetic */ void _ebean_setni_accountNumber(String _newValue) {
        this.accountNumber = _newValue;
        this._ebean_intercept.setLoadedProperty(14);
    }

    protected /* synthetic */ String _ebean_get_bankCode() {
        this._ebean_intercept.preGetter(15);
        return this.bankCode;
    }

    protected /* synthetic */ void _ebean_set_bankCode(String newValue) {
        this._ebean_intercept.preSetter(true, 15, (Object)this._ebean_get_bankCode(), (Object)newValue);
        this.bankCode = newValue;
    }

    protected /* synthetic */ String _ebean_getni_bankCode() {
        return this.bankCode;
    }

    protected /* synthetic */ void _ebean_setni_bankCode(String _newValue) {
        this.bankCode = _newValue;
        this._ebean_intercept.setLoadedProperty(15);
    }

    protected /* synthetic */ String _ebean_get_bankName() {
        this._ebean_intercept.preGetter(16);
        return this.bankName;
    }

    protected /* synthetic */ void _ebean_set_bankName(String newValue) {
        this._ebean_intercept.preSetter(true, 16, (Object)this._ebean_get_bankName(), (Object)newValue);
        this.bankName = newValue;
    }

    protected /* synthetic */ String _ebean_getni_bankName() {
        return this.bankName;
    }

    protected /* synthetic */ void _ebean_setni_bankName(String _newValue) {
        this.bankName = _newValue;
        this._ebean_intercept.setLoadedProperty(16);
    }

    protected /* synthetic */ String _ebean_get_purpose() {
        this._ebean_intercept.preGetter(17);
        return this.purpose;
    }

    protected /* synthetic */ void _ebean_set_purpose(String newValue) {
        this._ebean_intercept.preSetter(true, 17, (Object)this._ebean_get_purpose(), (Object)newValue);
        this.purpose = newValue;
    }

    protected /* synthetic */ String _ebean_getni_purpose() {
        return this.purpose;
    }

    protected /* synthetic */ void _ebean_setni_purpose(String _newValue) {
        this.purpose = _newValue;
        this._ebean_intercept.setLoadedProperty(17);
    }

    protected /* synthetic */ String _ebean_get_reference() {
        this._ebean_intercept.preGetter(18);
        return this.reference;
    }

    protected /* synthetic */ void _ebean_set_reference(String newValue) {
        this._ebean_intercept.preSetter(true, 18, (Object)this._ebean_get_reference(), (Object)newValue);
        this.reference = newValue;
    }

    protected /* synthetic */ String _ebean_getni_reference() {
        return this.reference;
    }

    protected /* synthetic */ void _ebean_setni_reference(String _newValue) {
        this.reference = _newValue;
        this._ebean_intercept.setLoadedProperty(18);
    }

    protected /* synthetic */ String _ebean_get_sepaMandateId() {
        this._ebean_intercept.preGetter(19);
        return this.sepaMandateId;
    }

    protected /* synthetic */ void _ebean_set_sepaMandateId(String newValue) {
        this._ebean_intercept.preSetter(true, 19, (Object)this._ebean_get_sepaMandateId(), (Object)newValue);
        this.sepaMandateId = newValue;
    }

    protected /* synthetic */ String _ebean_getni_sepaMandateId() {
        return this.sepaMandateId;
    }

    protected /* synthetic */ void _ebean_setni_sepaMandateId(String _newValue) {
        this.sepaMandateId = _newValue;
        this._ebean_intercept.setLoadedProperty(19);
    }

    protected /* synthetic */ String _ebean_get_recipientInfo() {
        this._ebean_intercept.preGetter(20);
        return this.recipientInfo;
    }

    protected /* synthetic */ void _ebean_set_recipientInfo(String newValue) {
        this._ebean_intercept.preSetter(true, 20, (Object)this._ebean_get_recipientInfo(), (Object)newValue);
        this.recipientInfo = newValue;
    }

    protected /* synthetic */ String _ebean_getni_recipientInfo() {
        return this.recipientInfo;
    }

    protected /* synthetic */ void _ebean_setni_recipientInfo(String _newValue) {
        this.recipientInfo = _newValue;
        this._ebean_intercept.setLoadedProperty(20);
    }

    protected /* synthetic */ String _ebean_get_vopName() {
        this._ebean_intercept.preGetter(21);
        return this.vopName;
    }

    protected /* synthetic */ void _ebean_set_vopName(String newValue) {
        this._ebean_intercept.preSetter(true, 21, (Object)this._ebean_get_vopName(), (Object)newValue);
        this.vopName = newValue;
    }

    protected /* synthetic */ String _ebean_getni_vopName() {
        return this.vopName;
    }

    protected /* synthetic */ void _ebean_setni_vopName(String _newValue) {
        this.vopName = _newValue;
        this._ebean_intercept.setLoadedProperty(21);
    }

    protected /* synthetic */ String _ebean_get_vopResult() {
        this._ebean_intercept.preGetter(22);
        return this.vopResult;
    }

    protected /* synthetic */ void _ebean_set_vopResult(String newValue) {
        this._ebean_intercept.preSetter(true, 22, (Object)this._ebean_get_vopResult(), (Object)newValue);
        this.vopResult = newValue;
    }

    protected /* synthetic */ String _ebean_getni_vopResult() {
        return this.vopResult;
    }

    protected /* synthetic */ void _ebean_setni_vopResult(String _newValue) {
        this.vopResult = _newValue;
        this._ebean_intercept.setLoadedProperty(22);
    }

    protected /* synthetic */ String _ebean_get_vopReason() {
        this._ebean_intercept.preGetter(23);
        return this.vopReason;
    }

    protected /* synthetic */ void _ebean_set_vopReason(String newValue) {
        this._ebean_intercept.preSetter(true, 23, (Object)this._ebean_get_vopReason(), (Object)newValue);
        this.vopReason = newValue;
    }

    protected /* synthetic */ String _ebean_getni_vopReason() {
        return this.vopReason;
    }

    protected /* synthetic */ void _ebean_setni_vopReason(String _newValue) {
        this.vopReason = _newValue;
        this._ebean_intercept.setLoadedProperty(23);
    }

    protected /* synthetic */ String _ebean_get_vopAdditionalInfo() {
        this._ebean_intercept.preGetter(24);
        return this.vopAdditionalInfo;
    }

    protected /* synthetic */ void _ebean_set_vopAdditionalInfo(String newValue) {
        this._ebean_intercept.preSetter(true, 24, (Object)this._ebean_get_vopAdditionalInfo(), (Object)newValue);
        this.vopAdditionalInfo = newValue;
    }

    protected /* synthetic */ String _ebean_getni_vopAdditionalInfo() {
        return this.vopAdditionalInfo;
    }

    protected /* synthetic */ void _ebean_setni_vopAdditionalInfo(String _newValue) {
        this.vopAdditionalInfo = _newValue;
        this._ebean_intercept.setLoadedProperty(24);
    }

    protected /* synthetic */ Timestamp _ebean_get_vopDate() {
        this._ebean_intercept.preGetter(25);
        return this.vopDate;
    }

    protected /* synthetic */ void _ebean_set_vopDate(Timestamp newValue) {
        this._ebean_intercept.preSetter(true, 25, (Object)this._ebean_get_vopDate(), (Object)newValue);
        this.vopDate = newValue;
    }

    protected /* synthetic */ Timestamp _ebean_getni_vopDate() {
        return this.vopDate;
    }

    protected /* synthetic */ void _ebean_setni_vopDate(Timestamp _newValue) {
        this.vopDate = _newValue;
        this._ebean_intercept.setLoadedProperty(25);
    }

    protected /* synthetic */ Timestamp _ebean_get_lastUsage() {
        this._ebean_intercept.preGetter(26);
        return this.lastUsage;
    }

    protected /* synthetic */ void _ebean_set_lastUsage(Timestamp newValue) {
        this._ebean_intercept.preSetter(true, 26, (Object)this._ebean_get_lastUsage(), (Object)newValue);
        this.lastUsage = newValue;
    }

    protected /* synthetic */ Timestamp _ebean_getni_lastUsage() {
        return this.lastUsage;
    }

    protected /* synthetic */ void _ebean_setni_lastUsage(Timestamp _newValue) {
        this.lastUsage = _newValue;
        this._ebean_intercept.setLoadedProperty(26);
    }

    @Override
    public /* synthetic */ Object _ebean_getField(int index) {
        switch (index) {
            case 0: {
                return this._ebean_getni_id();
            }
            case 1: {
                return this._ebean_getni_businessId();
            }
            case 2: {
                return this._ebean_getni_createdUser();
            }
            case 3: {
                return this._ebean_getni_created();
            }
            case 4: {
                return this._ebean_getni_confirmedUser();
            }
            case 5: {
                return this._ebean_getni_confirmed();
            }
            case 6: {
                return this._ebean_getni_version();
            }
            case 7: {
                return this._ebean_getni_lockingUser();
            }
            case 8: {
                return this._ebean_getni_deleted();
            }
            case 9: {
                return this._ebean_getni_hasFourEyesChange();
            }
            case 10: {
                return this.paymentType;
            }
            case 11: {
                return this.tenant;
            }
            case 12: {
                return this.displayName;
            }
            case 13: {
                return this.name;
            }
            case 14: {
                return this.accountNumber;
            }
            case 15: {
                return this.bankCode;
            }
            case 16: {
                return this.bankName;
            }
            case 17: {
                return this.purpose;
            }
            case 18: {
                return this.reference;
            }
            case 19: {
                return this.sepaMandateId;
            }
            case 20: {
                return this.recipientInfo;
            }
            case 21: {
                return this.vopName;
            }
            case 22: {
                return this.vopResult;
            }
            case 23: {
                return this.vopReason;
            }
            case 24: {
                return this.vopAdditionalInfo;
            }
            case 25: {
                return this.vopDate;
            }
            case 26: {
                return this.lastUsage;
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    @Override
    public /* synthetic */ Object _ebean_getFieldIntercept(int index) {
        switch (index) {
            case 0: {
                return this._ebean_get_id();
            }
            case 1: {
                return this._ebean_get_businessId();
            }
            case 2: {
                return this._ebean_get_createdUser();
            }
            case 3: {
                return this._ebean_get_created();
            }
            case 4: {
                return this._ebean_get_confirmedUser();
            }
            case 5: {
                return this._ebean_get_confirmed();
            }
            case 6: {
                return this._ebean_get_version();
            }
            case 7: {
                return this._ebean_get_lockingUser();
            }
            case 8: {
                return this._ebean_get_deleted();
            }
            case 9: {
                return this._ebean_get_hasFourEyesChange();
            }
            case 10: {
                return this._ebean_get_paymentType();
            }
            case 11: {
                return this._ebean_get_tenant();
            }
            case 12: {
                return this._ebean_get_displayName();
            }
            case 13: {
                return this._ebean_get_name();
            }
            case 14: {
                return this._ebean_get_accountNumber();
            }
            case 15: {
                return this._ebean_get_bankCode();
            }
            case 16: {
                return this._ebean_get_bankName();
            }
            case 17: {
                return this._ebean_get_purpose();
            }
            case 18: {
                return this._ebean_get_reference();
            }
            case 19: {
                return this._ebean_get_sepaMandateId();
            }
            case 20: {
                return this._ebean_get_recipientInfo();
            }
            case 21: {
                return this._ebean_get_vopName();
            }
            case 22: {
                return this._ebean_get_vopResult();
            }
            case 23: {
                return this._ebean_get_vopReason();
            }
            case 24: {
                return this._ebean_get_vopAdditionalInfo();
            }
            case 25: {
                return this._ebean_get_vopDate();
            }
            case 26: {
                return this._ebean_get_lastUsage();
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    @Override
    public /* synthetic */ void _ebean_setField(int index, Object o) {
        switch (index) {
            case 0: {
                this._ebean_setni_id((Integer)o);
                return;
            }
            case 1: {
                this._ebean_setni_businessId((Integer)o);
                return;
            }
            case 2: {
                this._ebean_setni_createdUser((User)o);
                return;
            }
            case 3: {
                this._ebean_setni_created((Date)o);
                return;
            }
            case 4: {
                this._ebean_setni_confirmedUser((User)o);
                return;
            }
            case 5: {
                this._ebean_setni_confirmed((Date)o);
                return;
            }
            case 6: {
                this._ebean_setni_version((HistoryLog.Version)((Object)o));
                return;
            }
            case 7: {
                this._ebean_setni_lockingUser((User)o);
                return;
            }
            case 8: {
                this._ebean_setni_deleted((Boolean)o);
                return;
            }
            case 9: {
                this._ebean_setni_hasFourEyesChange((Boolean)o);
                return;
            }
            case 10: {
                this._ebean_setni_paymentType((PaymentType)((Object)o));
                return;
            }
            case 11: {
                this._ebean_setni_tenant((Tenant)o);
                return;
            }
            case 12: {
                this._ebean_setni_displayName((String)o);
                return;
            }
            case 13: {
                this._ebean_setni_name((String)o);
                return;
            }
            case 14: {
                this._ebean_setni_accountNumber((String)o);
                return;
            }
            case 15: {
                this._ebean_setni_bankCode((String)o);
                return;
            }
            case 16: {
                this._ebean_setni_bankName((String)o);
                return;
            }
            case 17: {
                this._ebean_setni_purpose((String)o);
                return;
            }
            case 18: {
                this._ebean_setni_reference((String)o);
                return;
            }
            case 19: {
                this._ebean_setni_sepaMandateId((String)o);
                return;
            }
            case 20: {
                this._ebean_setni_recipientInfo((String)o);
                return;
            }
            case 21: {
                this._ebean_setni_vopName((String)o);
                return;
            }
            case 22: {
                this._ebean_setni_vopResult((String)o);
                return;
            }
            case 23: {
                this._ebean_setni_vopReason((String)o);
                return;
            }
            case 24: {
                this._ebean_setni_vopAdditionalInfo((String)o);
                return;
            }
            case 25: {
                this._ebean_setni_vopDate((Timestamp)o);
                return;
            }
            case 26: {
                this._ebean_setni_lastUsage((Timestamp)o);
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    @Override
    public /* synthetic */ void _ebean_setFieldIntercept(int index, Object o) {
        switch (index) {
            case 0: {
                this._ebean_set_id((Integer)o);
                return;
            }
            case 1: {
                this._ebean_set_businessId((Integer)o);
                return;
            }
            case 2: {
                this._ebean_set_createdUser((User)o);
                return;
            }
            case 3: {
                this._ebean_set_created((Date)o);
                return;
            }
            case 4: {
                this._ebean_set_confirmedUser((User)o);
                return;
            }
            case 5: {
                this._ebean_set_confirmed((Date)o);
                return;
            }
            case 6: {
                this._ebean_set_version((HistoryLog.Version)((Object)o));
                return;
            }
            case 7: {
                this._ebean_set_lockingUser((User)o);
                return;
            }
            case 8: {
                this._ebean_set_deleted((Boolean)o);
                return;
            }
            case 9: {
                this._ebean_set_hasFourEyesChange((Boolean)o);
                return;
            }
            case 10: {
                this._ebean_set_paymentType((PaymentType)((Object)o));
                return;
            }
            case 11: {
                this._ebean_set_tenant((Tenant)o);
                return;
            }
            case 12: {
                this._ebean_set_displayName((String)o);
                return;
            }
            case 13: {
                this._ebean_set_name((String)o);
                return;
            }
            case 14: {
                this._ebean_set_accountNumber((String)o);
                return;
            }
            case 15: {
                this._ebean_set_bankCode((String)o);
                return;
            }
            case 16: {
                this._ebean_set_bankName((String)o);
                return;
            }
            case 17: {
                this._ebean_set_purpose((String)o);
                return;
            }
            case 18: {
                this._ebean_set_reference((String)o);
                return;
            }
            case 19: {
                this._ebean_set_sepaMandateId((String)o);
                return;
            }
            case 20: {
                this._ebean_set_recipientInfo((String)o);
                return;
            }
            case 21: {
                this._ebean_set_vopName((String)o);
                return;
            }
            case 22: {
                this._ebean_set_vopResult((String)o);
                return;
            }
            case 23: {
                this._ebean_set_vopReason((String)o);
                return;
            }
            case 24: {
                this._ebean_set_vopAdditionalInfo((String)o);
                return;
            }
            case 25: {
                this._ebean_set_vopDate((Timestamp)o);
                return;
            }
            case 26: {
                this._ebean_set_lastUsage((Timestamp)o);
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    @Override
    public /* synthetic */ void _ebean_setEmbeddedLoaded() {
    }

    @Override
    public /* synthetic */ boolean _ebean_isEmbeddedNewOrDirty() {
        return false;
    }

    @Override
    public /* synthetic */ Object _ebean_newInstance() {
        return new PaymentRecipient();
    }
}

