/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.database.vo;

import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.Account;
import de.businesslogics.banking.database.vo.PaymentType;
import de.businesslogics.banking.database.vo.Tenant;
import de.businesslogics.banking.database.vo.User;
import io.ebean.ExpressionList;
import io.ebean.Query;
import io.ebean.Update;
import io.ebean.bean.EntityBean;
import io.ebean.bean.EntityBeanIntercept;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

@Entity
@Table(name="pmt_originator")
public class PaymentOriginator
implements EntityBean {
    @Id
    private Integer id;
    private String name;
    @ManyToOne(optional=false)
    private Tenant tenant;
    @ManyToOne
    private Account defaultAccount;
    @Column(nullable=false)
    private PaymentType paymentType;
    @Lob
    private String originatorInfo;
    public static /* synthetic */ String[] _ebean_props;
    protected /* synthetic */ EntityBeanIntercept _ebean_intercept;
    protected transient /* synthetic */ Object _ebean_identity;

    public PaymentOriginator() {
        this._ebean_intercept = new EntityBeanIntercept((Object)this);
    }

    public static PaymentOriginator findById(int id, User user) {
        return (PaymentOriginator)PaymentOriginator.findOriginatorQuery(Collections.singletonList(id), null, user.getTenants()).findOne();
    }

    public static List<PaymentOriginator> findByIdList(List<Integer> ids, User user) {
        return PaymentOriginator.findOriginatorQuery(ids, null, user.getTenants()).findList();
    }

    public static PaymentOriginator findOriginatorByName(PaymentType paymentType, String name, Tenant tenant) {
        return (PaymentOriginator)PaymentOriginator.findOriginatorQuery(null, Collections.singletonList(paymentType), Collections.singletonList(tenant)).where().eq("name", (Object)name).setMaxRows(1).findOne();
    }

    public static List<PaymentOriginator> findOriginatorsForPaymentType(PaymentType paymentType, List<Tenant> tenants) {
        return PaymentOriginator.findOriginatorQuery(null, Collections.singletonList(paymentType), tenants).findList();
    }

    public static List<PaymentOriginator> findOriginatorsForPaymentTypes(List<PaymentType> paymentTypes, List<Tenant> tenants) {
        return PaymentOriginator.findOriginatorQuery(null, paymentTypes, tenants).findList();
    }

    public static List<PaymentOriginator> findSEPAOriginators(List<Tenant> tenants) {
        HashSet<PaymentType> paymentTypes = new HashSet<PaymentType>();
        paymentTypes.add(PaymentType.SEPA);
        paymentTypes.add(PaymentType.MANDATE);
        return PaymentOriginator.findOriginatorQuery(null, paymentTypes, tenants).findList();
    }

    public static Query<PaymentOriginator> findQueryforUser(User user) {
        return PaymentOriginator.findOriginatorQuery(null, null, user.getTenants()).orderBy("name asc, paymentType asc");
    }

    private static Query<PaymentOriginator> findOriginatorQuery(Collection<Integer> ids, Collection<PaymentType> paymentTypes, Collection<Tenant> tenants) {
        ExpressionList result = DB.find(PaymentOriginator.class).where().in("tenant", tenants);
        if (ids != null) {
            result = result.in("id", ids);
        }
        if (paymentTypes != null) {
            result = result.in("paymentType", paymentTypes);
        }
        return result.orderBy("name asc, id asc").query();
    }

    public Integer getId() {
        return this._ebean_get_id();
    }

    public void setId(Integer id) {
        this._ebean_set_id(id);
    }

    public String getName() {
        return this._ebean_get_name();
    }

    public void setName(String name) {
        this._ebean_set_name(name);
    }

    public Tenant getTenant() {
        return this._ebean_get_tenant();
    }

    public void setTenant(Tenant tenant) {
        this._ebean_set_tenant(tenant);
    }

    public PaymentType getPaymentType() {
        return this._ebean_get_paymentType();
    }

    public void setPaymentType(PaymentType paymentType) {
        this._ebean_set_paymentType(paymentType);
    }

    public void setDefaultAccount(Account a) {
        this._ebean_set_defaultAccount(a);
    }

    public Account getDefaultAccount() {
        return this._ebean_get_defaultAccount();
    }

    public String getOriginatorInfo() {
        return this._ebean_get_originatorInfo();
    }

    public void setOriginatorInfo(String originatorInfo) {
        this._ebean_set_originatorInfo(originatorInfo);
    }

    public void save() {
        if (this.getId() == null) {
            DB.save(this);
        } else {
            DB.update(this);
        }
    }

    public void delete() {
        if (this._ebean_get_id() == null) {
            return;
        }
        PaymentOriginator originator = (PaymentOriginator)DB.find(PaymentOriginator.class).where().in("id", new Object[]{this._ebean_get_id()}).query().findOne();
        if (originator._ebean_get_paymentType() == PaymentType.DTAZV) {
            Account.removeDefaultDtazvOriginator(originator);
        } else if (originator._ebean_get_paymentType() == PaymentType.MT101) {
            Account.removeDefaultMt101Originator(originator);
        } else {
            Account.removeDefaultSepaOriginator(originator);
        }
        DB.delete(this);
    }

    public static void removeDefaultAccount(Account account) {
        Update<PaymentOriginator> update = DB.createUpdate(PaymentOriginator.class, "UPDATE pmt_originator SET defaultAccount=null WHERE defaultAccount=:account");
        update.setParameter("account", (Object)account.getId());
        update.execute();
    }

    public static void delete(Collection<PaymentOriginator> paymentOriginators) {
        for (PaymentOriginator originator : paymentOriginators) {
            if (originator.paymentType == PaymentType.DTAZV) {
                Account.removeDefaultDtazvOriginator(originator);
                continue;
            }
            if (originator.paymentType == PaymentType.MT101) {
                Account.removeDefaultMt101Originator(originator);
                continue;
            }
            Account.removeDefaultSepaOriginator(originator);
        }
        DB.deleteAll(paymentOriginators);
    }

    static {
        _ebean_props = new String[]{"id", "name", "tenant", "defaultAccount", "paymentType", "originatorInfo"};
    }

    public /* synthetic */ String[] _ebean_getPropertyNames() {
        return _ebean_props;
    }

    public /* synthetic */ String _ebean_getPropertyName(int pos) {
        return _ebean_props[pos];
    }

    public /* synthetic */ EntityBeanIntercept _ebean_getIntercept() {
        return this._ebean_intercept;
    }

    public /* synthetic */ EntityBeanIntercept _ebean_intercept() {
        if (this._ebean_intercept == null) {
            this._ebean_intercept = new EntityBeanIntercept((Object)this);
        }
        return this._ebean_intercept;
    }

    protected /* synthetic */ Integer _ebean_get_id() {
        this._ebean_intercept.preGetId();
        return this.id;
    }

    protected /* synthetic */ void _ebean_set_id(Integer newValue) {
        this._ebean_intercept.preSetter(false, 0, (Object)this.id, (Object)newValue);
        this.id = newValue;
    }

    protected /* synthetic */ Integer _ebean_getni_id() {
        return this.id;
    }

    protected /* synthetic */ void _ebean_setni_id(Integer _newValue) {
        this.id = _newValue;
        this._ebean_intercept.setLoadedProperty(0);
    }

    protected /* synthetic */ String _ebean_get_name() {
        this._ebean_intercept.preGetter(1);
        return this.name;
    }

    protected /* synthetic */ void _ebean_set_name(String newValue) {
        this._ebean_intercept.preSetter(true, 1, (Object)this._ebean_get_name(), (Object)newValue);
        this.name = newValue;
    }

    protected /* synthetic */ String _ebean_getni_name() {
        return this.name;
    }

    protected /* synthetic */ void _ebean_setni_name(String _newValue) {
        this.name = _newValue;
        this._ebean_intercept.setLoadedProperty(1);
    }

    protected /* synthetic */ Tenant _ebean_get_tenant() {
        this._ebean_intercept.preGetter(2);
        return this.tenant;
    }

    protected /* synthetic */ void _ebean_set_tenant(Tenant newValue) {
        this._ebean_intercept.preSetter(true, 2, (Object)this._ebean_get_tenant(), (Object)newValue);
        this.tenant = newValue;
    }

    protected /* synthetic */ Tenant _ebean_getni_tenant() {
        return this.tenant;
    }

    protected /* synthetic */ void _ebean_setni_tenant(Tenant _newValue) {
        this.tenant = _newValue;
        this._ebean_intercept.setLoadedProperty(2);
    }

    protected /* synthetic */ Account _ebean_get_defaultAccount() {
        this._ebean_intercept.preGetter(3);
        return this.defaultAccount;
    }

    protected /* synthetic */ void _ebean_set_defaultAccount(Account newValue) {
        this._ebean_intercept.preSetter(true, 3, (Object)this._ebean_get_defaultAccount(), (Object)newValue);
        this.defaultAccount = newValue;
    }

    protected /* synthetic */ Account _ebean_getni_defaultAccount() {
        return this.defaultAccount;
    }

    protected /* synthetic */ void _ebean_setni_defaultAccount(Account _newValue) {
        this.defaultAccount = _newValue;
        this._ebean_intercept.setLoadedProperty(3);
    }

    protected /* synthetic */ PaymentType _ebean_get_paymentType() {
        this._ebean_intercept.preGetter(4);
        return this.paymentType;
    }

    protected /* synthetic */ void _ebean_set_paymentType(PaymentType newValue) {
        this._ebean_intercept.preSetter(true, 4, (Object)this._ebean_get_paymentType(), (Object)newValue);
        this.paymentType = newValue;
    }

    protected /* synthetic */ PaymentType _ebean_getni_paymentType() {
        return this.paymentType;
    }

    protected /* synthetic */ void _ebean_setni_paymentType(PaymentType _newValue) {
        this.paymentType = _newValue;
        this._ebean_intercept.setLoadedProperty(4);
    }

    protected /* synthetic */ String _ebean_get_originatorInfo() {
        this._ebean_intercept.preGetter(5);
        return this.originatorInfo;
    }

    protected /* synthetic */ void _ebean_set_originatorInfo(String newValue) {
        this._ebean_intercept.preSetter(true, 5, (Object)this._ebean_get_originatorInfo(), (Object)newValue);
        this.originatorInfo = newValue;
    }

    protected /* synthetic */ String _ebean_getni_originatorInfo() {
        return this.originatorInfo;
    }

    protected /* synthetic */ void _ebean_setni_originatorInfo(String _newValue) {
        this.originatorInfo = _newValue;
        this._ebean_intercept.setLoadedProperty(5);
    }

    public /* synthetic */ Object _ebean_getField(int index) {
        switch (index) {
            case 0: {
                return this.id;
            }
            case 1: {
                return this.name;
            }
            case 2: {
                return this.tenant;
            }
            case 3: {
                return this.defaultAccount;
            }
            case 4: {
                return this.paymentType;
            }
            case 5: {
                return this.originatorInfo;
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    public /* synthetic */ Object _ebean_getFieldIntercept(int index) {
        switch (index) {
            case 0: {
                return this._ebean_get_id();
            }
            case 1: {
                return this._ebean_get_name();
            }
            case 2: {
                return this._ebean_get_tenant();
            }
            case 3: {
                return this._ebean_get_defaultAccount();
            }
            case 4: {
                return this._ebean_get_paymentType();
            }
            case 5: {
                return this._ebean_get_originatorInfo();
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    public /* synthetic */ void _ebean_setField(int index, Object o) {
        switch (index) {
            case 0: {
                this._ebean_setni_id((Integer)o);
                return;
            }
            case 1: {
                this._ebean_setni_name((String)o);
                return;
            }
            case 2: {
                this._ebean_setni_tenant((Tenant)o);
                return;
            }
            case 3: {
                this._ebean_setni_defaultAccount((Account)o);
                return;
            }
            case 4: {
                this._ebean_setni_paymentType((PaymentType)((Object)o));
                return;
            }
            case 5: {
                this._ebean_setni_originatorInfo((String)o);
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    public /* synthetic */ void _ebean_setFieldIntercept(int index, Object o) {
        switch (index) {
            case 0: {
                this._ebean_set_id((Integer)o);
                return;
            }
            case 1: {
                this._ebean_set_name((String)o);
                return;
            }
            case 2: {
                this._ebean_set_tenant((Tenant)o);
                return;
            }
            case 3: {
                this._ebean_set_defaultAccount((Account)o);
                return;
            }
            case 4: {
                this._ebean_set_paymentType((PaymentType)((Object)o));
                return;
            }
            case 5: {
                this._ebean_set_originatorInfo((String)o);
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private /* synthetic */ Object _ebean_getIdentity() {
        PaymentOriginator paymentOriginator = this;
        synchronized (paymentOriginator) {
            if (this._ebean_identity != null) {
                return this._ebean_identity;
            }
            Object tmpId = this._ebean_getField(0);
            this._ebean_identity = tmpId != null ? tmpId : new Object();
            return this._ebean_identity;
        }
    }

    public /* synthetic */ boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        return this._ebean_getIdentity().equals(((PaymentOriginator)obj)._ebean_getIdentity());
    }

    public /* synthetic */ int hashCode() {
        return this._ebean_getIdentity().hashCode();
    }

    public /* synthetic */ void _ebean_setEmbeddedLoaded() {
    }

    public /* synthetic */ boolean _ebean_isEmbeddedNewOrDirty() {
        return false;
    }

    public /* synthetic */ Object _ebean_newInstance() {
        return new PaymentOriginator();
    }
}

