/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.database.vo;

import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.OpenPayment;
import de.businesslogics.banking.database.vo.PeriodicPayment;
import de.businesslogics.banking.database.vo.Tenant;
import de.businesslogics.banking.database.vo.User;
import io.ebean.Expr;
import io.ebean.Expression;
import io.ebean.Query;
import io.ebean.Transaction;
import io.ebean.bean.EntityBean;
import io.ebean.bean.EntityBeanIntercept;
import io.ebean.common.BeanList;
import java.util.List;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;

@Entity
@Table(name="pmt_folder")
public class PaymentFolder
implements EntityBean {
    public static PaymentFolder NULL_FOLDER;
    @Id
    private Integer id;
    private String name;
    @ManyToOne(optional=false)
    private Tenant tenant;
    @OneToMany(mappedBy="folder", fetch=FetchType.LAZY)
    private List<OpenPayment> payments;
    public static /* synthetic */ String[] _ebean_props;
    protected /* synthetic */ EntityBeanIntercept _ebean_intercept;
    protected transient /* synthetic */ Object _ebean_identity;

    public PaymentFolder() {
        this._ebean_intercept = new EntityBeanIntercept((Object)this);
    }

    public static List<PaymentFolder> findAll(User user) {
        return PaymentFolder.findAllQuery(user).findList();
    }

    public static PaymentFolder findById(Integer id, User user) {
        if (id == null) {
            return null;
        }
        return (PaymentFolder)PaymentFolder.findAllQuery(user).where().eq("id", (Object)id).findOne();
    }

    public static boolean hasFolders(User user) {
        return PaymentFolder.findAllQuery(user).findCount() > 0;
    }

    private static Query<PaymentFolder> findAllQuery(User user) {
        Expression filter1 = Expr.in((String)"tenant", user.getVisibleTenants());
        Expression filter2 = Expr.in((String)"payments.bank.tenant", user.getVisibleTenants());
        return DB.find(PaymentFolder.class).where().disjunction().add(filter1).add(filter2).order("name").query();
    }

    public static PaymentFolder findByName(String name, Tenant tenant) {
        return (PaymentFolder)DB.find(PaymentFolder.class).where().eq("tenant", (Object)tenant).eq("name", (Object)name).findOne();
    }

    public static PaymentFolder findByNameOrCreateNew(String name, Tenant tenant) {
        PaymentFolder folder = null;
        if (name != null && name.trim().length() > 0 && !name.equals(NULL_FOLDER.getName()) && (folder = (PaymentFolder)DB.find(PaymentFolder.class).where().eq("tenant", (Object)tenant).eq("name", (Object)name).findOne()) == null) {
            folder = new PaymentFolder();
            folder.setName(name);
            folder.setTenant(tenant);
            DB.save(folder);
        }
        return folder;
    }

    public static NameError nameIsValid(PaymentFolder f, String name, Tenant tenant) {
        if (name != null && name.trim().length() > 0) {
            PaymentFolder exist = PaymentFolder.findByName(name.trim(), tenant);
            if (exist != null && !((Object)exist).equals(f)) {
                return NameError.EXISTS;
            }
            return NameError.NONE;
        }
        return NameError.EMPTY;
    }

    public static void deleteFolder(PaymentFolder f, boolean deleteOpen, boolean deletePeriodic, boolean deleteTemplate) {
        try (Transaction t = DB.beginTransaction();){
            if (deleteOpen) {
                DB.sqlUpdate("DELETE FROM pmt_open WHERE folder_id=:folderId").setParameter("folderId", (Object)f.getId()).execute();
            } else {
                DB.sqlUpdate("UPDATE pmt_open set folder_id=null WHERE folder_id=:folderId").setParameter("folderId", (Object)f.getId()).execute();
            }
            if (deletePeriodic) {
                DB.sqlUpdate("DELETE FROM pmt_periodic WHERE folder_id=:folderId").setParameter("folderId", (Object)f.getId()).execute();
            } else {
                DB.sqlUpdate("UPDATE pmt_periodic set folder_id=null WHERE folder_id=:folderId").setParameter("folderId", (Object)f.getId()).execute();
            }
            if (deleteTemplate) {
                DB.sqlUpdate("DELETE FROM pmt_template WHERE folder_id=:folderId").setParameter("folderId", (Object)f.getId()).execute();
            } else {
                DB.sqlUpdate("UPDATE pmt_template set folder_id=null WHERE folder_id=:folderId").setParameter("folderId", (Object)f.getId()).execute();
            }
            DB.delete(f);
            t.commit();
        }
    }

    public static void deletePaymentsInFolder(PaymentFolder f, boolean deleteOpen, boolean deletePeriodic, boolean deleteTemplate) {
        try (Transaction t = DB.beginTransaction();){
            if (deleteOpen) {
                DB.sqlUpdate("DELETE FROM pmt_open WHERE folder_id=:folderId").setParameter("folderId", (Object)f.getId()).execute();
            }
            if (deletePeriodic) {
                DB.sqlUpdate("DELETE FROM pmt_periodic WHERE folder_id=:folderId").setParameter("folderId", (Object)f.getId()).execute();
            }
            if (deleteTemplate) {
                DB.sqlUpdate("DELETE FROM pmt_template WHERE folder_id=:folderId").setParameter("folderId", (Object)f.getId()).execute();
            }
            t.commit();
        }
    }

    public static void changeHistoricPaymentsInFolder(PaymentFolder f) {
        OpenPayment.changeHistoricPaymentsInFolder(f);
        PeriodicPayment.changeHistoricPaymentsInFolder(f);
    }

    public Integer getId() {
        return this._ebean_get_id();
    }

    public void setId(Integer id) {
        this._ebean_set_id(id);
    }

    public String getName() {
        return this._ebean_get_name();
    }

    public void setName(String name) {
        this._ebean_set_name(name);
    }

    public Tenant getTenant() {
        return this._ebean_get_tenant();
    }

    public void setTenant(Tenant tenant) {
        this._ebean_set_tenant(tenant);
    }

    static {
        _ebean_props = new String[]{"id", "name", "tenant", "payments"};
        NULL_FOLDER = new PaymentFolder();
    }

    public /* synthetic */ String[] _ebean_getPropertyNames() {
        return _ebean_props;
    }

    public /* synthetic */ String _ebean_getPropertyName(int pos) {
        return _ebean_props[pos];
    }

    public /* synthetic */ EntityBeanIntercept _ebean_getIntercept() {
        return this._ebean_intercept;
    }

    public /* synthetic */ EntityBeanIntercept _ebean_intercept() {
        if (this._ebean_intercept == null) {
            this._ebean_intercept = new EntityBeanIntercept((Object)this);
        }
        return this._ebean_intercept;
    }

    protected /* synthetic */ Integer _ebean_get_id() {
        this._ebean_intercept.preGetId();
        return this.id;
    }

    protected /* synthetic */ void _ebean_set_id(Integer newValue) {
        this._ebean_intercept.preSetter(false, 0, (Object)this.id, (Object)newValue);
        this.id = newValue;
    }

    protected /* synthetic */ Integer _ebean_getni_id() {
        return this.id;
    }

    protected /* synthetic */ void _ebean_setni_id(Integer _newValue) {
        this.id = _newValue;
        this._ebean_intercept.setLoadedProperty(0);
    }

    protected /* synthetic */ String _ebean_get_name() {
        this._ebean_intercept.preGetter(1);
        return this.name;
    }

    protected /* synthetic */ void _ebean_set_name(String newValue) {
        this._ebean_intercept.preSetter(true, 1, (Object)this._ebean_get_name(), (Object)newValue);
        this.name = newValue;
    }

    protected /* synthetic */ String _ebean_getni_name() {
        return this.name;
    }

    protected /* synthetic */ void _ebean_setni_name(String _newValue) {
        this.name = _newValue;
        this._ebean_intercept.setLoadedProperty(1);
    }

    protected /* synthetic */ Tenant _ebean_get_tenant() {
        this._ebean_intercept.preGetter(2);
        return this.tenant;
    }

    protected /* synthetic */ void _ebean_set_tenant(Tenant newValue) {
        this._ebean_intercept.preSetter(true, 2, (Object)this._ebean_get_tenant(), (Object)newValue);
        this.tenant = newValue;
    }

    protected /* synthetic */ Tenant _ebean_getni_tenant() {
        return this.tenant;
    }

    protected /* synthetic */ void _ebean_setni_tenant(Tenant _newValue) {
        this.tenant = _newValue;
        this._ebean_intercept.setLoadedProperty(2);
    }

    protected /* synthetic */ List _ebean_get_payments() {
        this._ebean_intercept.preGetter(3);
        if (this.payments == null) {
            this.payments = new BeanList();
            this._ebean_intercept.initialisedMany(3);
        }
        return this.payments;
    }

    protected /* synthetic */ void _ebean_set_payments(List newValue) {
        this._ebean_intercept.preSetterMany(false, 3, this.payments, (Object)newValue);
        this.payments = newValue;
    }

    protected /* synthetic */ List _ebean_getni_payments() {
        return this.payments;
    }

    protected /* synthetic */ void _ebean_setni_payments(List _newValue) {
        this.payments = _newValue;
        this._ebean_intercept.setLoadedProperty(3);
    }

    public /* synthetic */ Object _ebean_getField(int index) {
        switch (index) {
            case 0: {
                return this.id;
            }
            case 1: {
                return this.name;
            }
            case 2: {
                return this.tenant;
            }
            case 3: {
                return this.payments;
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    public /* synthetic */ Object _ebean_getFieldIntercept(int index) {
        switch (index) {
            case 0: {
                return this._ebean_get_id();
            }
            case 1: {
                return this._ebean_get_name();
            }
            case 2: {
                return this._ebean_get_tenant();
            }
            case 3: {
                return this._ebean_get_payments();
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    public /* synthetic */ void _ebean_setField(int index, Object o) {
        switch (index) {
            case 0: {
                this._ebean_setni_id((Integer)o);
                return;
            }
            case 1: {
                this._ebean_setni_name((String)o);
                return;
            }
            case 2: {
                this._ebean_setni_tenant((Tenant)o);
                return;
            }
            case 3: {
                this._ebean_setni_payments((List)o);
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    public /* synthetic */ void _ebean_setFieldIntercept(int index, Object o) {
        switch (index) {
            case 0: {
                this._ebean_set_id((Integer)o);
                return;
            }
            case 1: {
                this._ebean_set_name((String)o);
                return;
            }
            case 2: {
                this._ebean_set_tenant((Tenant)o);
                return;
            }
            case 3: {
                this._ebean_set_payments((List)o);
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private /* synthetic */ Object _ebean_getIdentity() {
        PaymentFolder paymentFolder = this;
        synchronized (paymentFolder) {
            if (this._ebean_identity != null) {
                return this._ebean_identity;
            }
            Object tmpId = this._ebean_getField(0);
            this._ebean_identity = tmpId != null ? tmpId : new Object();
            return this._ebean_identity;
        }
    }

    public /* synthetic */ boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        return this._ebean_getIdentity().equals(((PaymentFolder)obj)._ebean_getIdentity());
    }

    public /* synthetic */ int hashCode() {
        return this._ebean_getIdentity().hashCode();
    }

    public /* synthetic */ void _ebean_setEmbeddedLoaded() {
    }

    public /* synthetic */ boolean _ebean_isEmbeddedNewOrDirty() {
        return false;
    }

    public /* synthetic */ Object _ebean_newInstance() {
        return new PaymentFolder();
    }

    public static enum NameError {
        EXISTS,
        EMPTY,
        NONE;

    }
}

