/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.database.vo;

import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.FilterComparator;
import de.businesslogics.banking.database.vo.PaymentTransferType;
import de.businesslogics.banking.database.vo.Send;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.persistence.DBType;
import io.ebean.Expr;
import io.ebean.Expression;
import io.ebean.bean.EntityBean;
import io.ebean.bean.EntityBeanIntercept;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.Calendar;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.OneToOne;
import javax.persistence.Table;

@Entity
@Table(name="pmt_filter")
public class PaymentFilter
implements EntityBean {
    @Id
    private Integer id;
    @OneToOne(optional=false)
    private User user;
    @Column(name="pmt_open_active")
    private Boolean openPaymentsFilterActive;
    @Column(name="pmt_signed_active")
    private Boolean signedPaymentsFilterActive;
    @Column(name="pmt_template_active")
    private Boolean paymentsTemplateFilterActive;
    @Column(name="pmt_periodic_active")
    private Boolean periodicPaymentsFilterActive;
    private PaymentTransferType.PmtType pmtType;
    @Column(name="pmt_type_comp")
    private FilterComparator.PaymentType pmtTypeComparator;
    private Integer accountId;
    private Integer filterUserId;
    private String text;
    @Column(name="text_comp")
    private FilterComparator.Text textComparator;
    @Column(precision=38, scale=3)
    private BigDecimal amountFrom;
    @Column(precision=38, scale=3)
    private BigDecimal amountTo;
    @Column(name="amount_comp")
    private FilterComparator.Amount amountComparator;
    @Column(name="from_exec_date")
    private Date fromExecutionDate;
    @Column(name="to_exec_date")
    private Date toExecutionDate;
    @Column(name="exec_date_comp")
    private FilterComparator.Date executionDateCompator;
    private State state;
    public static /* synthetic */ String[] _ebean_props;
    protected /* synthetic */ EntityBeanIntercept _ebean_intercept;
    protected transient /* synthetic */ Object _ebean_identity;

    private PaymentFilter(User user) {
        this._ebean_intercept = new EntityBeanIntercept((Object)this);
        this._ebean_set_pmtTypeComparator(FilterComparator.PaymentType.EQUAL);
        this._ebean_set_user(user);
    }

    public static PaymentFilter getFilter(User user) {
        PaymentFilter f = (PaymentFilter)DB.find(PaymentFilter.class).where().eq("user", (Object)user).findOne();
        if (f == null) {
            f = new PaymentFilter(user);
        }
        return f;
    }

    public static void deleteByUser(User user) {
        PaymentFilter toDelete = PaymentFilter.getFilter(user);
        if (toDelete.id != null) {
            DB.delete(toDelete);
        }
    }

    public User getUser() {
        return this._ebean_get_user();
    }

    public boolean isPaymentsTemplateFilterActive() {
        return this._ebean_get_paymentsTemplateFilterActive() != null && this._ebean_get_paymentsTemplateFilterActive() != false;
    }

    public void setPaymentsTemplateFilterActive(Boolean paymentsTemplateFilterActive) {
        this._ebean_set_paymentsTemplateFilterActive(paymentsTemplateFilterActive);
    }

    public boolean isPeriodicPaymentsFilterActive() {
        return this._ebean_get_periodicPaymentsFilterActive() != null && this._ebean_get_periodicPaymentsFilterActive() != false;
    }

    public void setPeriodicPaymentsFilterActive(Boolean periodicPaymentsFilterActive) {
        this._ebean_set_periodicPaymentsFilterActive(periodicPaymentsFilterActive);
    }

    public boolean isOpenPaymentsFilterActive() {
        return this._ebean_get_openPaymentsFilterActive() != null && this._ebean_get_openPaymentsFilterActive() != false;
    }

    public void setOpenPaymentsFilterActive(Boolean openPaymentsFilterActive) {
        this._ebean_set_openPaymentsFilterActive(openPaymentsFilterActive);
    }

    public boolean isSignedPaymentsFilterActive() {
        return this._ebean_get_signedPaymentsFilterActive() != null && this._ebean_get_signedPaymentsFilterActive() != false;
    }

    public void setSignedPaymentsFilterActive(boolean signedPaymentsFilterActive) {
        this._ebean_set_signedPaymentsFilterActive(signedPaymentsFilterActive);
    }

    public PaymentTransferType.PmtType getPmtType() {
        return this._ebean_get_pmtType();
    }

    public void setPmtType(PaymentTransferType.PmtType pmtType) {
        this._ebean_set_pmtType(pmtType);
    }

    public FilterComparator.PaymentType getPmtTypeComparator() {
        return this._ebean_get_pmtTypeComparator();
    }

    public void setPmtTypeComparator(FilterComparator.PaymentType pmtTypeComparator) {
        this._ebean_set_pmtTypeComparator(pmtTypeComparator);
    }

    public void setPmtTypeComparator(int pmtTypeComparatorIndex) {
        if (pmtTypeComparatorIndex >= 0 && pmtTypeComparatorIndex < FilterComparator.PaymentType.values().length) {
            this.setPmtTypeComparator(FilterComparator.PaymentType.values()[pmtTypeComparatorIndex]);
        } else {
            this.setPmtTypeComparator(null);
        }
    }

    public Integer getAccountId() {
        return this._ebean_get_accountId();
    }

    public void setAccountId(Integer accountId) {
        this._ebean_set_accountId(accountId);
    }

    public Integer getFilterUserId() {
        return this._ebean_get_filterUserId();
    }

    public void setFilterUserId(Integer filterUserId) {
        this._ebean_set_filterUserId(filterUserId);
    }

    public String getText() {
        return this._ebean_get_text();
    }

    public void setText(String text) {
        if (text != null && text.trim().length() > 0) {
            this._ebean_set_text(text.trim());
        } else {
            this._ebean_set_text(null);
        }
    }

    public FilterComparator.Text getTextComparator() {
        return this._ebean_get_textComparator();
    }

    public void setTextComparator(FilterComparator.Text textComparator) {
        this._ebean_set_textComparator(textComparator);
    }

    public BigDecimal getAmountFrom() {
        return this._ebean_get_amountFrom();
    }

    public void setAmountFrom(BigDecimal amountFrom) {
        this._ebean_set_amountFrom(amountFrom);
    }

    public BigDecimal getAmountTo() {
        return this._ebean_get_amountTo();
    }

    public void setAmountTo(BigDecimal amountTo) {
        this._ebean_set_amountTo(amountTo);
    }

    public FilterComparator.Amount getAmountComparator() {
        return this._ebean_get_amountComparator();
    }

    public void setAmountComparator(FilterComparator.Amount amountComparator) {
        this._ebean_set_amountComparator(amountComparator);
    }

    public Date getFromExecutionDate() {
        return this._ebean_get_fromExecutionDate();
    }

    public void setFromExecutionDate(Date fromExecutionDate) {
        if (fromExecutionDate == null) {
            this._ebean_set_fromExecutionDate(null);
        } else {
            this._ebean_set_fromExecutionDate(this.getDateAtTimeZero(fromExecutionDate));
        }
    }

    private Date getDateAtTimeZero(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(14, 0);
        cal.set(13, 0);
        cal.set(12, 0);
        cal.set(11, 0);
        return new Date(cal.getTimeInMillis());
    }

    public Date getToExecutionDate() {
        return this._ebean_get_toExecutionDate();
    }

    public void setToExecutionDate(Date toExecutionDate) {
        if (toExecutionDate == null) {
            this._ebean_set_toExecutionDate(null);
        } else {
            this._ebean_set_toExecutionDate(this.getDateAtTimeZero(toExecutionDate));
        }
    }

    public FilterComparator.Date getExecutionDateCompator() {
        return this._ebean_get_executionDateCompator();
    }

    public void setExecutionDateCompator(FilterComparator.Date executionDateCompator) {
        this._ebean_set_executionDateCompator(executionDateCompator);
    }

    public void setExecutionDateCompator(int executionDateCompatorId) {
        if (executionDateCompatorId >= 0 && executionDateCompatorId < FilterComparator.Date.values().length) {
            this._ebean_set_executionDateCompator(FilterComparator.Date.values()[executionDateCompatorId]);
        } else {
            this._ebean_set_executionDateCompator(null);
        }
    }

    public int getExecutionDateCompatorId() {
        if (this._ebean_get_executionDateCompator() != null) {
            return this._ebean_get_executionDateCompator().ordinal();
        }
        return -1;
    }

    public void save() {
        if (this._ebean_get_id() == null) {
            DB.save(this);
        } else {
            DB.update(this);
        }
    }

    public void reset() {
        this._ebean_set_openPaymentsFilterActive(false);
        this._ebean_set_signedPaymentsFilterActive(false);
        this._ebean_set_periodicPaymentsFilterActive(false);
        this._ebean_set_paymentsTemplateFilterActive(false);
        this._ebean_set_accountId(null);
        this._ebean_set_filterUserId(null);
        this._ebean_set_text(null);
        this._ebean_set_textComparator(null);
        this._ebean_set_amountFrom(null);
        this._ebean_set_amountTo(null);
        this._ebean_set_amountComparator(null);
        this._ebean_set_fromExecutionDate(null);
        this._ebean_set_toExecutionDate(null);
        this._ebean_set_executionDateCompator(null);
        this._ebean_set_state(null);
        this.save();
    }

    public int getTextComparatorId() {
        if (this._ebean_get_textComparator() != null) {
            return this._ebean_get_textComparator().ordinal();
        }
        return 0;
    }

    public void setTextComparator(int textComparatorId) {
        if (textComparatorId >= 0 && textComparatorId < FilterComparator.Text.values().length) {
            this._ebean_set_textComparator(FilterComparator.Text.values()[textComparatorId]);
        } else {
            this._ebean_set_textComparator(null);
        }
    }

    public int getAmountComparatorId() {
        if (this._ebean_get_amountComparator() != null) {
            return this._ebean_get_amountComparator().ordinal();
        }
        return 0;
    }

    public void setAmountComparator(int amountComparatorId) {
        if (amountComparatorId >= 0 && amountComparatorId < FilterComparator.Amount.values().length) {
            this._ebean_set_amountComparator(FilterComparator.Amount.values()[amountComparatorId]);
        } else {
            this._ebean_set_amountComparator(null);
        }
    }

    public Expression getSignedExpression(boolean displayFullSalaries) {
        return this.getExpression(true, displayFullSalaries, false, false);
    }

    public Expression getOpenExpression() {
        return this.getExpression(false, false, false, false);
    }

    public Expression getPeriodicExpression() {
        return this.getExpression(false, false, true, false);
    }

    public Expression getTemplateExpression() {
        return this.getExpression(false, false, false, true);
    }

    public State getState() {
        return this._ebean_get_state();
    }

    public void setState(State state) {
        this._ebean_set_state(state);
    }

    private Expression getExpression(boolean signed, boolean displayFullSalaries, boolean periodic, boolean template) {
        boolean open = !signed && !periodic && !template;
        Expression account = this._ebean_get_accountId() != null ? Expr.eq((String)"account.id", (Object)this._ebean_get_accountId()) : null;
        Expression filterUser = (open || periodic) && this._ebean_get_filterUserId() != null ? Expr.eq((String)"createdUser.id", (Object)this._ebean_get_filterUserId()) : null;
        Expression pmtTypeExpression = this._ebean_get_pmtType() != null ? (FilterComparator.PaymentType.UNEQUAL.equals((Object)this._ebean_get_pmtTypeComparator()) ? Expr.ne((String)"pmtType", (Object)((Object)this._ebean_get_pmtType())) : Expr.eq((String)"pmtType", (Object)((Object)this._ebean_get_pmtType()))) : null;
        Expression amount = null;
        if (this._ebean_get_amountComparator() != null && (this._ebean_get_amountFrom() != null || this._ebean_get_amountComparator() == FilterComparator.Amount.BETWEEN && this._ebean_get_amountTo() != null)) {
            switch (this._ebean_get_amountComparator()) {
                case EQUAL: {
                    amount = Expr.eq((String)"amount", (Object)this._ebean_get_amountFrom());
                    break;
                }
                case GREATER: {
                    amount = Expr.gt((String)"amount", (Object)this._ebean_get_amountFrom());
                    break;
                }
                case LESS: {
                    amount = Expr.lt((String)"amount", (Object)this._ebean_get_amountFrom());
                    break;
                }
                case BETWEEN: {
                    if (this._ebean_get_amountFrom() != null && this._ebean_get_amountTo() != null) {
                        if (this._ebean_get_amountFrom().compareTo(this._ebean_get_amountTo()) < 0) {
                            amount = Expr.between((String)"amount", (Object)this._ebean_get_amountFrom(), (Object)this._ebean_get_amountTo());
                            break;
                        }
                        amount = Expr.between((String)"amount", (Object)this._ebean_get_amountTo(), (Object)this._ebean_get_amountFrom());
                        break;
                    }
                    if (this._ebean_get_amountFrom() != null) {
                        amount = Expr.ge((String)"amount", (Object)this._ebean_get_amountFrom());
                        break;
                    }
                    amount = Expr.le((String)"amount", (Object)this._ebean_get_amountTo());
                    break;
                }
            }
            if (signed && amount != null && !displayFullSalaries) {
                amount = Expr.and((Expression)amount, (Expression)Expr.eq((String)"salaryPayment", (Object)false));
            }
        }
        Expression text = null;
        if (this._ebean_get_text() != null) {
            Expression recipient;
            boolean isMSSQL = DBType.MSSQL.equals((Object)BankSettings.DATABASE_TYPE);
            boolean isOracle = DBType.ORACLE.equals((Object)BankSettings.DATABASE_TYPE);
            boolean isPSQL = DBType.PSQL.equals((Object)BankSettings.DATABASE_TYPE);
            boolean includePaymentData = !isMSSQL && !isOracle && !isPSQL;
            Object filter = "%" + this._ebean_get_text() + "%";
            if (this._ebean_get_textComparator() == FilterComparator.Text.STARTS_WITH || this._ebean_get_textComparator() == FilterComparator.Text.ENDS_WITH) {
                filter = this._ebean_get_text();
            }
            Expression purpose = null;
            Expression reference = null;
            Expression paymentData = null;
            if (this._ebean_get_textComparator() == FilterComparator.Text.STARTS_WITH) {
                if (!template) {
                    purpose = Expr.and((Expression)Expr.isNotNull((String)"purpose"), (Expression)Expr.istartsWith((String)"purpose", (String)filter));
                }
                recipient = Expr.and((Expression)Expr.isNotNull((String)"recipient"), (Expression)Expr.istartsWith((String)"recipient", (String)filter));
                if (signed) {
                    reference = Expr.and((Expression)Expr.isNotNull((String)"reference"), (Expression)Expr.istartsWith((String)"reference", (String)filter));
                }
                if (includePaymentData) {
                    paymentData = Expr.and((Expression)Expr.isNotNull((String)"paymentData"), (Expression)Expr.istartsWith((String)"paymentData", (String)filter));
                }
            } else if (this._ebean_get_textComparator() == FilterComparator.Text.ENDS_WITH) {
                if (!template) {
                    purpose = Expr.and((Expression)Expr.isNotNull((String)"purpose"), (Expression)Expr.iendsWith((String)"purpose", (String)filter));
                }
                recipient = Expr.and((Expression)Expr.isNotNull((String)"recipient"), (Expression)Expr.iendsWith((String)"recipient", (String)filter));
                if (signed) {
                    reference = Expr.and((Expression)Expr.isNotNull((String)"reference"), (Expression)Expr.iendsWith((String)"reference", (String)filter));
                }
                if (includePaymentData) {
                    paymentData = Expr.and((Expression)Expr.isNotNull((String)"paymentData"), (Expression)Expr.iendsWith((String)"paymentData", (String)filter));
                }
            } else {
                if (!template) {
                    purpose = Expr.ilike((String)"purpose", (String)filter);
                }
                recipient = Expr.ilike((String)"recipient", (String)filter);
                if (signed) {
                    reference = Expr.ilike((String)"reference", (String)filter);
                }
                if (includePaymentData) {
                    paymentData = Expr.like((String)"paymentData", (String)filter);
                }
            }
            if (this._ebean_get_textComparator() == FilterComparator.Text.CONTAINS_NOT) {
                Expression recipientContainsNot;
                text = recipientContainsNot = Expr.or((Expression)Expr.not((Expression)recipient), (Expression)Expr.or((Expression)Expr.eq((String)"recipient", (Object)""), (Expression)Expr.eq((String)"recipient", null)));
                if (!template && purpose != null) {
                    Expression purposeContainsNot = Expr.or((Expression)Expr.not((Expression)purpose), (Expression)Expr.or((Expression)Expr.eq((String)"purpose", (Object)""), (Expression)Expr.eq((String)"purpose", null)));
                    text = Expr.and((Expression)text, (Expression)purposeContainsNot);
                }
                if (reference != null) {
                    Expression referenceContainsNot = Expr.or((Expression)Expr.not((Expression)reference), (Expression)Expr.or((Expression)Expr.eq((String)"reference", (Object)""), (Expression)Expr.eq((String)"reference", null)));
                    text = Expr.and((Expression)text, (Expression)referenceContainsNot);
                }
                if (includePaymentData && paymentData != null) {
                    Expression paymentDataContainsNot = Expr.or((Expression)Expr.not((Expression)paymentData), (Expression)Expr.or((Expression)Expr.eq((String)"paymentData", (Object)""), (Expression)Expr.eq((String)"paymentData", null)));
                    text = Expr.and((Expression)text, (Expression)paymentDataContainsNot);
                }
            } else {
                text = recipient;
                if (!template && purpose != null) {
                    text = Expr.or((Expression)text, (Expression)purpose);
                }
                if (reference != null) {
                    text = Expr.or((Expression)text, (Expression)reference);
                }
                if (includePaymentData && paymentData != null) {
                    text = Expr.or((Expression)text, (Expression)paymentData);
                }
            }
        }
        Expression executionDate = null;
        if (!template && !periodic) {
            if (this._ebean_get_executionDateCompator() == FilterComparator.Date.EQUAL && this._ebean_get_fromExecutionDate() != null) {
                executionDate = Expr.between((String)"executionDate", (Object)this._ebean_get_fromExecutionDate(), (Object)this.getLatestAtDay(this._ebean_get_fromExecutionDate()));
            } else if (this._ebean_get_executionDateCompator() == FilterComparator.Date.GREATER && this._ebean_get_fromExecutionDate() != null) {
                executionDate = Expr.gt((String)"executionDate", (Object)this._ebean_get_fromExecutionDate());
            } else if (this._ebean_get_executionDateCompator() == FilterComparator.Date.BETWEEN && this._ebean_get_fromExecutionDate() != null && this._ebean_get_toExecutionDate() == null) {
                executionDate = Expr.ge((String)"executionDate", (Object)this._ebean_get_fromExecutionDate());
            } else if (this._ebean_get_executionDateCompator() == FilterComparator.Date.LESS && this._ebean_get_fromExecutionDate() != null) {
                executionDate = Expr.lt((String)"executionDate", (Object)this._ebean_get_fromExecutionDate());
            } else if (this._ebean_get_executionDateCompator() == FilterComparator.Date.BETWEEN && this._ebean_get_fromExecutionDate() == null && this._ebean_get_toExecutionDate() != null) {
                executionDate = Expr.le((String)"executionDate", (Object)this.getLatestAtDay(this._ebean_get_toExecutionDate()));
            } else if (this._ebean_get_executionDateCompator() == FilterComparator.Date.BETWEEN && this._ebean_get_fromExecutionDate() != null && this._ebean_get_toExecutionDate() != null) {
                executionDate = Expr.between((String)"executionDate", (Object)this._ebean_get_fromExecutionDate(), (Object)this.getLatestAtDay(this._ebean_get_toExecutionDate()));
            }
        }
        Expression stateFilter = null;
        if (signed) {
            stateFilter = this.getSignedPaymentStateExpression(this._ebean_get_state());
        }
        Expression toReturn = account;
        if (filterUser != null) {
            toReturn = toReturn == null ? filterUser : Expr.and((Expression)toReturn, (Expression)filterUser);
        }
        if (pmtTypeExpression != null) {
            toReturn = toReturn == null ? pmtTypeExpression : Expr.and((Expression)toReturn, (Expression)pmtTypeExpression);
        }
        if (amount != null) {
            toReturn = toReturn == null ? amount : Expr.and((Expression)toReturn, (Expression)amount);
        }
        if (text != null) {
            toReturn = toReturn == null ? text : Expr.and((Expression)toReturn, text);
        }
        if (executionDate != null) {
            toReturn = toReturn == null ? executionDate : Expr.and((Expression)toReturn, (Expression)executionDate);
        }
        if (stateFilter != null) {
            toReturn = toReturn == null ? stateFilter : Expr.and((Expression)toReturn, (Expression)stateFilter);
        }
        return toReturn;
    }

    private Expression getSignedPaymentStateExpression(State state) {
        if (state != null) {
            switch (state.ordinal()) {
                case 0: {
                    return Expr.in((String)"send.state", (Object[])new Send.State[]{Send.State.SENT, Send.State.CONFIRMED});
                }
                case 3: {
                    return Expr.in((String)"send.state", (Object[])new Send.State[]{Send.State.FINISHED_ERROR, Send.State.NOT_CONFIRMED});
                }
                case 2: {
                    Expression noExtendedState = Expr.and((Expression)Expr.isNull((String)"sts"), (Expression)Expr.isNull((String)"cnclSts"));
                    return Expr.and((Expression)Expr.eq((String)"send.state", (Object)((Object)Send.State.FINISHED_OK)), (Expression)noExtendedState);
                }
                case 1: {
                    return Expr.in((String)"send.state", (Object[])new Send.State[]{Send.State.WAITING_IN_DS, Send.State.SIGNATURE_STILL_MISSING});
                }
                case 4: {
                    return Expr.or((Expression)Expr.eq((String)"send.state", (Object)((Object)Send.State.CANCELED)), (Expression)Expr.eq((String)"cnclSts", (Object)"CNCL"));
                }
                case 6: {
                    Expression notCancelled = Expr.or((Expression)Expr.isNull((String)"cnclSts"), (Expression)Expr.ne((String)"cnclSts", (Object)"CNCL"));
                    return Expr.and((Expression)notCancelled, (Expression)this.getBookedExpression());
                }
                case 7: {
                    return Expr.or((Expression)Expr.and((Expression)Expr.isNotNull((String)"sts"), (Expression)Expr.not((Expression)this.getBookedExpression())), (Expression)Expr.isNotNull((String)"vopSts"));
                }
                case 5: {
                    return Expr.eq((String)"sts", (Object)"RJCT");
                }
                case 8: {
                    Object[] finalStates = new String[]{"CNCL", "RJCR"};
                    Expression nonFinalState = Expr.or((Expression)Expr.isNull((String)"cnclSts"), (Expression)Expr.not((Expression)Expr.in((String)"cnclSts", (Object[])finalStates)));
                    return Expr.and((Expression)Expr.isNotNull((String)"callback"), (Expression)nonFinalState);
                }
            }
        }
        return null;
    }

    private Expression getBookedExpression() {
        return Expr.or((Expression)Expr.and((Expression)Expr.eq((String)"pmtType", (Object)((Object)PaymentTransferType.PmtType.SEPA_INSTANT_TRANSFER)), (Expression)Expr.eq((String)"sts", (Object)"ACCP")), (Expression)Expr.and((Expression)Expr.ne((String)"pmtType", (Object)((Object)PaymentTransferType.PmtType.SEPA_INSTANT_TRANSFER)), (Expression)Expr.eq((String)"sts", (Object)"ACSC")));
    }

    private Timestamp getLatestAtDay(java.util.Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(14, 999);
        cal.set(13, 59);
        cal.set(12, 59);
        cal.set(11, 23);
        return new Timestamp(cal.getTimeInMillis());
    }

    static {
        _ebean_props = new String[]{"id", "user", "openPaymentsFilterActive", "signedPaymentsFilterActive", "paymentsTemplateFilterActive", "periodicPaymentsFilterActive", "pmtType", "pmtTypeComparator", "accountId", "filterUserId", "text", "textComparator", "amountFrom", "amountTo", "amountComparator", "fromExecutionDate", "toExecutionDate", "executionDateCompator", "state"};
    }

    public /* synthetic */ PaymentFilter() {
        this._ebean_intercept = new EntityBeanIntercept((Object)this);
    }

    public /* synthetic */ String[] _ebean_getPropertyNames() {
        return _ebean_props;
    }

    public /* synthetic */ String _ebean_getPropertyName(int pos) {
        return _ebean_props[pos];
    }

    public /* synthetic */ EntityBeanIntercept _ebean_getIntercept() {
        return this._ebean_intercept;
    }

    public /* synthetic */ EntityBeanIntercept _ebean_intercept() {
        if (this._ebean_intercept == null) {
            this._ebean_intercept = new EntityBeanIntercept((Object)this);
        }
        return this._ebean_intercept;
    }

    protected /* synthetic */ Integer _ebean_get_id() {
        this._ebean_intercept.preGetId();
        return this.id;
    }

    protected /* synthetic */ void _ebean_set_id(Integer newValue) {
        this._ebean_intercept.preSetter(false, 0, (Object)this.id, (Object)newValue);
        this.id = newValue;
    }

    protected /* synthetic */ Integer _ebean_getni_id() {
        return this.id;
    }

    protected /* synthetic */ void _ebean_setni_id(Integer _newValue) {
        this.id = _newValue;
        this._ebean_intercept.setLoadedProperty(0);
    }

    protected /* synthetic */ User _ebean_get_user() {
        this._ebean_intercept.preGetter(1);
        return this.user;
    }

    protected /* synthetic */ void _ebean_set_user(User newValue) {
        this._ebean_intercept.preSetter(true, 1, (Object)this._ebean_get_user(), (Object)newValue);
        this.user = newValue;
    }

    protected /* synthetic */ User _ebean_getni_user() {
        return this.user;
    }

    protected /* synthetic */ void _ebean_setni_user(User _newValue) {
        this.user = _newValue;
        this._ebean_intercept.setLoadedProperty(1);
    }

    protected /* synthetic */ Boolean _ebean_get_openPaymentsFilterActive() {
        this._ebean_intercept.preGetter(2);
        return this.openPaymentsFilterActive;
    }

    protected /* synthetic */ void _ebean_set_openPaymentsFilterActive(Boolean newValue) {
        this._ebean_intercept.preSetter(true, 2, (Object)this._ebean_get_openPaymentsFilterActive(), (Object)newValue);
        this.openPaymentsFilterActive = newValue;
    }

    protected /* synthetic */ Boolean _ebean_getni_openPaymentsFilterActive() {
        return this.openPaymentsFilterActive;
    }

    protected /* synthetic */ void _ebean_setni_openPaymentsFilterActive(Boolean _newValue) {
        this.openPaymentsFilterActive = _newValue;
        this._ebean_intercept.setLoadedProperty(2);
    }

    protected /* synthetic */ Boolean _ebean_get_signedPaymentsFilterActive() {
        this._ebean_intercept.preGetter(3);
        return this.signedPaymentsFilterActive;
    }

    protected /* synthetic */ void _ebean_set_signedPaymentsFilterActive(Boolean newValue) {
        this._ebean_intercept.preSetter(true, 3, (Object)this._ebean_get_signedPaymentsFilterActive(), (Object)newValue);
        this.signedPaymentsFilterActive = newValue;
    }

    protected /* synthetic */ Boolean _ebean_getni_signedPaymentsFilterActive() {
        return this.signedPaymentsFilterActive;
    }

    protected /* synthetic */ void _ebean_setni_signedPaymentsFilterActive(Boolean _newValue) {
        this.signedPaymentsFilterActive = _newValue;
        this._ebean_intercept.setLoadedProperty(3);
    }

    protected /* synthetic */ Boolean _ebean_get_paymentsTemplateFilterActive() {
        this._ebean_intercept.preGetter(4);
        return this.paymentsTemplateFilterActive;
    }

    protected /* synthetic */ void _ebean_set_paymentsTemplateFilterActive(Boolean newValue) {
        this._ebean_intercept.preSetter(true, 4, (Object)this._ebean_get_paymentsTemplateFilterActive(), (Object)newValue);
        this.paymentsTemplateFilterActive = newValue;
    }

    protected /* synthetic */ Boolean _ebean_getni_paymentsTemplateFilterActive() {
        return this.paymentsTemplateFilterActive;
    }

    protected /* synthetic */ void _ebean_setni_paymentsTemplateFilterActive(Boolean _newValue) {
        this.paymentsTemplateFilterActive = _newValue;
        this._ebean_intercept.setLoadedProperty(4);
    }

    protected /* synthetic */ Boolean _ebean_get_periodicPaymentsFilterActive() {
        this._ebean_intercept.preGetter(5);
        return this.periodicPaymentsFilterActive;
    }

    protected /* synthetic */ void _ebean_set_periodicPaymentsFilterActive(Boolean newValue) {
        this._ebean_intercept.preSetter(true, 5, (Object)this._ebean_get_periodicPaymentsFilterActive(), (Object)newValue);
        this.periodicPaymentsFilterActive = newValue;
    }

    protected /* synthetic */ Boolean _ebean_getni_periodicPaymentsFilterActive() {
        return this.periodicPaymentsFilterActive;
    }

    protected /* synthetic */ void _ebean_setni_periodicPaymentsFilterActive(Boolean _newValue) {
        this.periodicPaymentsFilterActive = _newValue;
        this._ebean_intercept.setLoadedProperty(5);
    }

    protected /* synthetic */ PaymentTransferType.PmtType _ebean_get_pmtType() {
        this._ebean_intercept.preGetter(6);
        return this.pmtType;
    }

    protected /* synthetic */ void _ebean_set_pmtType(PaymentTransferType.PmtType newValue) {
        this._ebean_intercept.preSetter(true, 6, (Object)this._ebean_get_pmtType(), (Object)newValue);
        this.pmtType = newValue;
    }

    protected /* synthetic */ PaymentTransferType.PmtType _ebean_getni_pmtType() {
        return this.pmtType;
    }

    protected /* synthetic */ void _ebean_setni_pmtType(PaymentTransferType.PmtType _newValue) {
        this.pmtType = _newValue;
        this._ebean_intercept.setLoadedProperty(6);
    }

    protected /* synthetic */ FilterComparator.PaymentType _ebean_get_pmtTypeComparator() {
        this._ebean_intercept.preGetter(7);
        return this.pmtTypeComparator;
    }

    protected /* synthetic */ void _ebean_set_pmtTypeComparator(FilterComparator.PaymentType newValue) {
        this._ebean_intercept.preSetter(true, 7, (Object)this._ebean_get_pmtTypeComparator(), (Object)newValue);
        this.pmtTypeComparator = newValue;
    }

    protected /* synthetic */ FilterComparator.PaymentType _ebean_getni_pmtTypeComparator() {
        return this.pmtTypeComparator;
    }

    protected /* synthetic */ void _ebean_setni_pmtTypeComparator(FilterComparator.PaymentType _newValue) {
        this.pmtTypeComparator = _newValue;
        this._ebean_intercept.setLoadedProperty(7);
    }

    protected /* synthetic */ Integer _ebean_get_accountId() {
        this._ebean_intercept.preGetter(8);
        return this.accountId;
    }

    protected /* synthetic */ void _ebean_set_accountId(Integer newValue) {
        this._ebean_intercept.preSetter(true, 8, (Object)this._ebean_get_accountId(), (Object)newValue);
        this.accountId = newValue;
    }

    protected /* synthetic */ Integer _ebean_getni_accountId() {
        return this.accountId;
    }

    protected /* synthetic */ void _ebean_setni_accountId(Integer _newValue) {
        this.accountId = _newValue;
        this._ebean_intercept.setLoadedProperty(8);
    }

    protected /* synthetic */ Integer _ebean_get_filterUserId() {
        this._ebean_intercept.preGetter(9);
        return this.filterUserId;
    }

    protected /* synthetic */ void _ebean_set_filterUserId(Integer newValue) {
        this._ebean_intercept.preSetter(true, 9, (Object)this._ebean_get_filterUserId(), (Object)newValue);
        this.filterUserId = newValue;
    }

    protected /* synthetic */ Integer _ebean_getni_filterUserId() {
        return this.filterUserId;
    }

    protected /* synthetic */ void _ebean_setni_filterUserId(Integer _newValue) {
        this.filterUserId = _newValue;
        this._ebean_intercept.setLoadedProperty(9);
    }

    protected /* synthetic */ String _ebean_get_text() {
        this._ebean_intercept.preGetter(10);
        return this.text;
    }

    protected /* synthetic */ void _ebean_set_text(String newValue) {
        this._ebean_intercept.preSetter(true, 10, (Object)this._ebean_get_text(), (Object)newValue);
        this.text = newValue;
    }

    protected /* synthetic */ String _ebean_getni_text() {
        return this.text;
    }

    protected /* synthetic */ void _ebean_setni_text(String _newValue) {
        this.text = _newValue;
        this._ebean_intercept.setLoadedProperty(10);
    }

    protected /* synthetic */ FilterComparator.Text _ebean_get_textComparator() {
        this._ebean_intercept.preGetter(11);
        return this.textComparator;
    }

    protected /* synthetic */ void _ebean_set_textComparator(FilterComparator.Text newValue) {
        this._ebean_intercept.preSetter(true, 11, (Object)this._ebean_get_textComparator(), (Object)newValue);
        this.textComparator = newValue;
    }

    protected /* synthetic */ FilterComparator.Text _ebean_getni_textComparator() {
        return this.textComparator;
    }

    protected /* synthetic */ void _ebean_setni_textComparator(FilterComparator.Text _newValue) {
        this.textComparator = _newValue;
        this._ebean_intercept.setLoadedProperty(11);
    }

    protected /* synthetic */ BigDecimal _ebean_get_amountFrom() {
        this._ebean_intercept.preGetter(12);
        return this.amountFrom;
    }

    protected /* synthetic */ void _ebean_set_amountFrom(BigDecimal newValue) {
        this._ebean_intercept.preSetter(true, 12, (Object)this._ebean_get_amountFrom(), (Object)newValue);
        this.amountFrom = newValue;
    }

    protected /* synthetic */ BigDecimal _ebean_getni_amountFrom() {
        return this.amountFrom;
    }

    protected /* synthetic */ void _ebean_setni_amountFrom(BigDecimal _newValue) {
        this.amountFrom = _newValue;
        this._ebean_intercept.setLoadedProperty(12);
    }

    protected /* synthetic */ BigDecimal _ebean_get_amountTo() {
        this._ebean_intercept.preGetter(13);
        return this.amountTo;
    }

    protected /* synthetic */ void _ebean_set_amountTo(BigDecimal newValue) {
        this._ebean_intercept.preSetter(true, 13, (Object)this._ebean_get_amountTo(), (Object)newValue);
        this.amountTo = newValue;
    }

    protected /* synthetic */ BigDecimal _ebean_getni_amountTo() {
        return this.amountTo;
    }

    protected /* synthetic */ void _ebean_setni_amountTo(BigDecimal _newValue) {
        this.amountTo = _newValue;
        this._ebean_intercept.setLoadedProperty(13);
    }

    protected /* synthetic */ FilterComparator.Amount _ebean_get_amountComparator() {
        this._ebean_intercept.preGetter(14);
        return this.amountComparator;
    }

    protected /* synthetic */ void _ebean_set_amountComparator(FilterComparator.Amount newValue) {
        this._ebean_intercept.preSetter(true, 14, (Object)this._ebean_get_amountComparator(), (Object)newValue);
        this.amountComparator = newValue;
    }

    protected /* synthetic */ FilterComparator.Amount _ebean_getni_amountComparator() {
        return this.amountComparator;
    }

    protected /* synthetic */ void _ebean_setni_amountComparator(FilterComparator.Amount _newValue) {
        this.amountComparator = _newValue;
        this._ebean_intercept.setLoadedProperty(14);
    }

    protected /* synthetic */ Date _ebean_get_fromExecutionDate() {
        this._ebean_intercept.preGetter(15);
        return this.fromExecutionDate;
    }

    protected /* synthetic */ void _ebean_set_fromExecutionDate(Date newValue) {
        this._ebean_intercept.preSetter(true, 15, (Object)this._ebean_get_fromExecutionDate(), (Object)newValue);
        this.fromExecutionDate = newValue;
    }

    protected /* synthetic */ Date _ebean_getni_fromExecutionDate() {
        return this.fromExecutionDate;
    }

    protected /* synthetic */ void _ebean_setni_fromExecutionDate(Date _newValue) {
        this.fromExecutionDate = _newValue;
        this._ebean_intercept.setLoadedProperty(15);
    }

    protected /* synthetic */ Date _ebean_get_toExecutionDate() {
        this._ebean_intercept.preGetter(16);
        return this.toExecutionDate;
    }

    protected /* synthetic */ void _ebean_set_toExecutionDate(Date newValue) {
        this._ebean_intercept.preSetter(true, 16, (Object)this._ebean_get_toExecutionDate(), (Object)newValue);
        this.toExecutionDate = newValue;
    }

    protected /* synthetic */ Date _ebean_getni_toExecutionDate() {
        return this.toExecutionDate;
    }

    protected /* synthetic */ void _ebean_setni_toExecutionDate(Date _newValue) {
        this.toExecutionDate = _newValue;
        this._ebean_intercept.setLoadedProperty(16);
    }

    protected /* synthetic */ FilterComparator.Date _ebean_get_executionDateCompator() {
        this._ebean_intercept.preGetter(17);
        return this.executionDateCompator;
    }

    protected /* synthetic */ void _ebean_set_executionDateCompator(FilterComparator.Date newValue) {
        this._ebean_intercept.preSetter(true, 17, (Object)this._ebean_get_executionDateCompator(), (Object)newValue);
        this.executionDateCompator = newValue;
    }

    protected /* synthetic */ FilterComparator.Date _ebean_getni_executionDateCompator() {
        return this.executionDateCompator;
    }

    protected /* synthetic */ void _ebean_setni_executionDateCompator(FilterComparator.Date _newValue) {
        this.executionDateCompator = _newValue;
        this._ebean_intercept.setLoadedProperty(17);
    }

    protected /* synthetic */ State _ebean_get_state() {
        this._ebean_intercept.preGetter(18);
        return this.state;
    }

    protected /* synthetic */ void _ebean_set_state(State newValue) {
        this._ebean_intercept.preSetter(true, 18, (Object)this._ebean_get_state(), (Object)newValue);
        this.state = newValue;
    }

    protected /* synthetic */ State _ebean_getni_state() {
        return this.state;
    }

    protected /* synthetic */ void _ebean_setni_state(State _newValue) {
        this.state = _newValue;
        this._ebean_intercept.setLoadedProperty(18);
    }

    public /* synthetic */ Object _ebean_getField(int index) {
        switch (index) {
            case 0: {
                return this.id;
            }
            case 1: {
                return this.user;
            }
            case 2: {
                return this.openPaymentsFilterActive;
            }
            case 3: {
                return this.signedPaymentsFilterActive;
            }
            case 4: {
                return this.paymentsTemplateFilterActive;
            }
            case 5: {
                return this.periodicPaymentsFilterActive;
            }
            case 6: {
                return this.pmtType;
            }
            case 7: {
                return this.pmtTypeComparator;
            }
            case 8: {
                return this.accountId;
            }
            case 9: {
                return this.filterUserId;
            }
            case 10: {
                return this.text;
            }
            case 11: {
                return this.textComparator;
            }
            case 12: {
                return this.amountFrom;
            }
            case 13: {
                return this.amountTo;
            }
            case 14: {
                return this.amountComparator;
            }
            case 15: {
                return this.fromExecutionDate;
            }
            case 16: {
                return this.toExecutionDate;
            }
            case 17: {
                return this.executionDateCompator;
            }
            case 18: {
                return this.state;
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    public /* synthetic */ Object _ebean_getFieldIntercept(int index) {
        switch (index) {
            case 0: {
                return this._ebean_get_id();
            }
            case 1: {
                return this._ebean_get_user();
            }
            case 2: {
                return this._ebean_get_openPaymentsFilterActive();
            }
            case 3: {
                return this._ebean_get_signedPaymentsFilterActive();
            }
            case 4: {
                return this._ebean_get_paymentsTemplateFilterActive();
            }
            case 5: {
                return this._ebean_get_periodicPaymentsFilterActive();
            }
            case 6: {
                return this._ebean_get_pmtType();
            }
            case 7: {
                return this._ebean_get_pmtTypeComparator();
            }
            case 8: {
                return this._ebean_get_accountId();
            }
            case 9: {
                return this._ebean_get_filterUserId();
            }
            case 10: {
                return this._ebean_get_text();
            }
            case 11: {
                return this._ebean_get_textComparator();
            }
            case 12: {
                return this._ebean_get_amountFrom();
            }
            case 13: {
                return this._ebean_get_amountTo();
            }
            case 14: {
                return this._ebean_get_amountComparator();
            }
            case 15: {
                return this._ebean_get_fromExecutionDate();
            }
            case 16: {
                return this._ebean_get_toExecutionDate();
            }
            case 17: {
                return this._ebean_get_executionDateCompator();
            }
            case 18: {
                return this._ebean_get_state();
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    public /* synthetic */ void _ebean_setField(int index, Object o) {
        switch (index) {
            case 0: {
                this._ebean_setni_id((Integer)o);
                return;
            }
            case 1: {
                this._ebean_setni_user((User)o);
                return;
            }
            case 2: {
                this._ebean_setni_openPaymentsFilterActive((Boolean)o);
                return;
            }
            case 3: {
                this._ebean_setni_signedPaymentsFilterActive((Boolean)o);
                return;
            }
            case 4: {
                this._ebean_setni_paymentsTemplateFilterActive((Boolean)o);
                return;
            }
            case 5: {
                this._ebean_setni_periodicPaymentsFilterActive((Boolean)o);
                return;
            }
            case 6: {
                this._ebean_setni_pmtType((PaymentTransferType.PmtType)((Object)o));
                return;
            }
            case 7: {
                this._ebean_setni_pmtTypeComparator((FilterComparator.PaymentType)((Object)o));
                return;
            }
            case 8: {
                this._ebean_setni_accountId((Integer)o);
                return;
            }
            case 9: {
                this._ebean_setni_filterUserId((Integer)o);
                return;
            }
            case 10: {
                this._ebean_setni_text((String)o);
                return;
            }
            case 11: {
                this._ebean_setni_textComparator((FilterComparator.Text)((Object)o));
                return;
            }
            case 12: {
                this._ebean_setni_amountFrom((BigDecimal)o);
                return;
            }
            case 13: {
                this._ebean_setni_amountTo((BigDecimal)o);
                return;
            }
            case 14: {
                this._ebean_setni_amountComparator((FilterComparator.Amount)((Object)o));
                return;
            }
            case 15: {
                this._ebean_setni_fromExecutionDate((Date)o);
                return;
            }
            case 16: {
                this._ebean_setni_toExecutionDate((Date)o);
                return;
            }
            case 17: {
                this._ebean_setni_executionDateCompator((FilterComparator.Date)((Object)o));
                return;
            }
            case 18: {
                this._ebean_setni_state((State)((Object)o));
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    public /* synthetic */ void _ebean_setFieldIntercept(int index, Object o) {
        switch (index) {
            case 0: {
                this._ebean_set_id((Integer)o);
                return;
            }
            case 1: {
                this._ebean_set_user((User)o);
                return;
            }
            case 2: {
                this._ebean_set_openPaymentsFilterActive((Boolean)o);
                return;
            }
            case 3: {
                this._ebean_set_signedPaymentsFilterActive((Boolean)o);
                return;
            }
            case 4: {
                this._ebean_set_paymentsTemplateFilterActive((Boolean)o);
                return;
            }
            case 5: {
                this._ebean_set_periodicPaymentsFilterActive((Boolean)o);
                return;
            }
            case 6: {
                this._ebean_set_pmtType((PaymentTransferType.PmtType)((Object)o));
                return;
            }
            case 7: {
                this._ebean_set_pmtTypeComparator((FilterComparator.PaymentType)((Object)o));
                return;
            }
            case 8: {
                this._ebean_set_accountId((Integer)o);
                return;
            }
            case 9: {
                this._ebean_set_filterUserId((Integer)o);
                return;
            }
            case 10: {
                this._ebean_set_text((String)o);
                return;
            }
            case 11: {
                this._ebean_set_textComparator((FilterComparator.Text)((Object)o));
                return;
            }
            case 12: {
                this._ebean_set_amountFrom((BigDecimal)o);
                return;
            }
            case 13: {
                this._ebean_set_amountTo((BigDecimal)o);
                return;
            }
            case 14: {
                this._ebean_set_amountComparator((FilterComparator.Amount)((Object)o));
                return;
            }
            case 15: {
                this._ebean_set_fromExecutionDate((Date)o);
                return;
            }
            case 16: {
                this._ebean_set_toExecutionDate((Date)o);
                return;
            }
            case 17: {
                this._ebean_set_executionDateCompator((FilterComparator.Date)((Object)o));
                return;
            }
            case 18: {
                this._ebean_set_state((State)((Object)o));
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private /* synthetic */ Object _ebean_getIdentity() {
        PaymentFilter paymentFilter = this;
        synchronized (paymentFilter) {
            if (this._ebean_identity != null) {
                return this._ebean_identity;
            }
            Object tmpId = this._ebean_getField(0);
            this._ebean_identity = tmpId != null ? tmpId : new Object();
            return this._ebean_identity;
        }
    }

    public /* synthetic */ boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        return this._ebean_getIdentity().equals(((PaymentFilter)obj)._ebean_getIdentity());
    }

    public /* synthetic */ int hashCode() {
        return this._ebean_getIdentity().hashCode();
    }

    public /* synthetic */ void _ebean_setEmbeddedLoaded() {
    }

    public /* synthetic */ boolean _ebean_isEmbeddedNewOrDirty() {
        return false;
    }

    public /* synthetic */ Object _ebean_newInstance() {
        return new PaymentFilter();
    }

    public static enum State {
        SENT,
        WAITING_IN_DS,
        FINISHED_OK,
        FINISHED_ERROR,
        CANCELED,
        RJCT,
        ACSC_ACCP,
        WITH_MESSAGES,
        CALLBACK_STARTED;

    }
}

