/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.database.vo;

import de.businesslogics.banking.database.api.DB;
import io.ebean.bean.EntityBean;
import io.ebean.bean.EntityBeanIntercept;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Timestamp;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;

@Entity
@Table(name="pmt_xchgrate")
public class PaymentExchangeRate
implements EntityBean {
    @Id
    private Integer id;
    @Column(length=3, unique=true, nullable=false)
    private String currencyCode;
    @Column(nullable=false, precision=38, scale=10)
    private BigDecimal exchangeRate;
    private Timestamp rateTime;
    public static /* synthetic */ String[] _ebean_props;
    protected /* synthetic */ EntityBeanIntercept _ebean_intercept;
    protected transient /* synthetic */ Object _ebean_identity;

    public PaymentExchangeRate() {
        this._ebean_intercept = new EntityBeanIntercept((Object)this);
    }

    public static PaymentExchangeRate findExchangeRate(String currencyCode) {
        if (currencyCode != null && currencyCode.length() != 3) {
            return null;
        }
        PaymentExchangeRate result = (PaymentExchangeRate)DB.find(PaymentExchangeRate.class).where().eq("currencyCode", (Object)currencyCode).findOne();
        if (result == null) {
            result = new PaymentExchangeRate();
            result.setCurrencyCode(currencyCode);
        }
        return result;
    }

    public BigDecimal convertToEURO(BigDecimal in) {
        if (in == null || this.getExchangeRate() == null) {
            return null;
        }
        return in.divide(this.getExchangeRate(), 2, RoundingMode.HALF_UP);
    }

    public BigDecimal convertFromEURO(BigDecimal in) {
        if (in == null || this.getExchangeRate() == null) {
            return null;
        }
        return in.multiply(this.getExchangeRate()).setScale(2, RoundingMode.HALF_UP);
    }

    public static Timestamp getLatestExchangeRateDate() {
        PaymentExchangeRate exchangeRate = (PaymentExchangeRate)DB.find(PaymentExchangeRate.class).order().desc("rateTime").setMaxRows(1).findOne();
        if (exchangeRate == null) {
            return null;
        }
        return exchangeRate.getRateTime();
    }

    public Integer getId() {
        return this._ebean_get_id();
    }

    public void setId(Integer id) {
        this._ebean_set_id(id);
    }

    public String getCurrencyCode() {
        return this._ebean_get_currencyCode();
    }

    public void setCurrencyCode(String currencyCode) {
        this._ebean_set_currencyCode(currencyCode);
    }

    public BigDecimal getExchangeRate() {
        return this._ebean_get_exchangeRate();
    }

    public void setExchangeRate(BigDecimal exchangeRate) {
        this._ebean_set_exchangeRate(exchangeRate);
    }

    public Timestamp getRateTime() {
        return this._ebean_get_rateTime();
    }

    public void setRateTime(Timestamp rateTime) {
        this._ebean_set_rateTime(rateTime);
    }

    public void save() {
        if (this._ebean_get_id() == null) {
            DB.save(this);
        } else {
            DB.update(this);
        }
    }

    static {
        _ebean_props = new String[]{"id", "currencyCode", "exchangeRate", "rateTime"};
    }

    public /* synthetic */ String[] _ebean_getPropertyNames() {
        return _ebean_props;
    }

    public /* synthetic */ String _ebean_getPropertyName(int pos) {
        return _ebean_props[pos];
    }

    public /* synthetic */ EntityBeanIntercept _ebean_getIntercept() {
        return this._ebean_intercept;
    }

    public /* synthetic */ EntityBeanIntercept _ebean_intercept() {
        if (this._ebean_intercept == null) {
            this._ebean_intercept = new EntityBeanIntercept((Object)this);
        }
        return this._ebean_intercept;
    }

    protected /* synthetic */ Integer _ebean_get_id() {
        this._ebean_intercept.preGetId();
        return this.id;
    }

    protected /* synthetic */ void _ebean_set_id(Integer newValue) {
        this._ebean_intercept.preSetter(false, 0, (Object)this.id, (Object)newValue);
        this.id = newValue;
    }

    protected /* synthetic */ Integer _ebean_getni_id() {
        return this.id;
    }

    protected /* synthetic */ void _ebean_setni_id(Integer _newValue) {
        this.id = _newValue;
        this._ebean_intercept.setLoadedProperty(0);
    }

    protected /* synthetic */ String _ebean_get_currencyCode() {
        this._ebean_intercept.preGetter(1);
        return this.currencyCode;
    }

    protected /* synthetic */ void _ebean_set_currencyCode(String newValue) {
        this._ebean_intercept.preSetter(true, 1, (Object)this._ebean_get_currencyCode(), (Object)newValue);
        this.currencyCode = newValue;
    }

    protected /* synthetic */ String _ebean_getni_currencyCode() {
        return this.currencyCode;
    }

    protected /* synthetic */ void _ebean_setni_currencyCode(String _newValue) {
        this.currencyCode = _newValue;
        this._ebean_intercept.setLoadedProperty(1);
    }

    protected /* synthetic */ BigDecimal _ebean_get_exchangeRate() {
        this._ebean_intercept.preGetter(2);
        return this.exchangeRate;
    }

    protected /* synthetic */ void _ebean_set_exchangeRate(BigDecimal newValue) {
        this._ebean_intercept.preSetter(true, 2, (Object)this._ebean_get_exchangeRate(), (Object)newValue);
        this.exchangeRate = newValue;
    }

    protected /* synthetic */ BigDecimal _ebean_getni_exchangeRate() {
        return this.exchangeRate;
    }

    protected /* synthetic */ void _ebean_setni_exchangeRate(BigDecimal _newValue) {
        this.exchangeRate = _newValue;
        this._ebean_intercept.setLoadedProperty(2);
    }

    protected /* synthetic */ Timestamp _ebean_get_rateTime() {
        this._ebean_intercept.preGetter(3);
        return this.rateTime;
    }

    protected /* synthetic */ void _ebean_set_rateTime(Timestamp newValue) {
        this._ebean_intercept.preSetter(true, 3, (Object)this._ebean_get_rateTime(), (Object)newValue);
        this.rateTime = newValue;
    }

    protected /* synthetic */ Timestamp _ebean_getni_rateTime() {
        return this.rateTime;
    }

    protected /* synthetic */ void _ebean_setni_rateTime(Timestamp _newValue) {
        this.rateTime = _newValue;
        this._ebean_intercept.setLoadedProperty(3);
    }

    public /* synthetic */ Object _ebean_getField(int index) {
        switch (index) {
            case 0: {
                return this.id;
            }
            case 1: {
                return this.currencyCode;
            }
            case 2: {
                return this.exchangeRate;
            }
            case 3: {
                return this.rateTime;
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    public /* synthetic */ Object _ebean_getFieldIntercept(int index) {
        switch (index) {
            case 0: {
                return this._ebean_get_id();
            }
            case 1: {
                return this._ebean_get_currencyCode();
            }
            case 2: {
                return this._ebean_get_exchangeRate();
            }
            case 3: {
                return this._ebean_get_rateTime();
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    public /* synthetic */ void _ebean_setField(int index, Object o) {
        switch (index) {
            case 0: {
                this._ebean_setni_id((Integer)o);
                return;
            }
            case 1: {
                this._ebean_setni_currencyCode((String)o);
                return;
            }
            case 2: {
                this._ebean_setni_exchangeRate((BigDecimal)o);
                return;
            }
            case 3: {
                this._ebean_setni_rateTime((Timestamp)o);
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    public /* synthetic */ void _ebean_setFieldIntercept(int index, Object o) {
        switch (index) {
            case 0: {
                this._ebean_set_id((Integer)o);
                return;
            }
            case 1: {
                this._ebean_set_currencyCode((String)o);
                return;
            }
            case 2: {
                this._ebean_set_exchangeRate((BigDecimal)o);
                return;
            }
            case 3: {
                this._ebean_set_rateTime((Timestamp)o);
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private /* synthetic */ Object _ebean_getIdentity() {
        PaymentExchangeRate paymentExchangeRate = this;
        synchronized (paymentExchangeRate) {
            if (this._ebean_identity != null) {
                return this._ebean_identity;
            }
            Object tmpId = this._ebean_getField(0);
            this._ebean_identity = tmpId != null ? tmpId : new Object();
            return this._ebean_identity;
        }
    }

    public /* synthetic */ boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        return this._ebean_getIdentity().equals(((PaymentExchangeRate)obj)._ebean_getIdentity());
    }

    public /* synthetic */ int hashCode() {
        return this._ebean_getIdentity().hashCode();
    }

    public /* synthetic */ void _ebean_setEmbeddedLoaded() {
    }

    public /* synthetic */ boolean _ebean_isEmbeddedNewOrDirty() {
        return false;
    }

    public /* synthetic */ Object _ebean_newInstance() {
        return new PaymentExchangeRate();
    }
}

