/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.database.vo;

import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.Account;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.BankUser;
import de.businesslogics.banking.database.vo.BankUserHtdInfo;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.banking.database.vo.UserPermission;
import io.ebean.Expr;
import io.ebean.Expression;
import io.ebean.ExpressionList;
import io.ebean.Query;
import io.ebean.Update;
import io.ebean.bean.EntityBean;
import io.ebean.bean.EntityBeanIntercept;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.ManyToOne;

@Entity
public class OrderType
implements EntityBean {
    private static final Set<String> IGNORE_SEND_ORDER_TYPES;
    @Id
    private Integer id;
    @ManyToOne
    private BankSettings bank;
    @Column(nullable=false)
    private TransferType transferType;
    @Column(length=3)
    private String orderType;
    @Column(length=50)
    private String fileFormat;
    @Column(length=8)
    private String orderFormat;
    private Integer numSigRequired;
    private String description;
    public static /* synthetic */ String[] _ebean_props;
    protected /* synthetic */ EntityBeanIntercept _ebean_intercept;
    protected transient /* synthetic */ Object _ebean_identity;

    public OrderType() {
        this._ebean_intercept = new EntityBeanIntercept((Object)this);
    }

    public static int deleteAll(BankSettings bank) {
        Update<OrderType> delete = DB.createUpdate(OrderType.class, "DELETE FROM OrderType WHERE bank=:bank");
        delete.setParameter("bank", (Object)bank.getBankId());
        return delete.execute();
    }

    public static OrderType findOrderType(BankSettings bank, TransferType transferType, String orderType, String fileFormat) {
        List<OrderType> orderTypes = OrderType.findOrderTypes(bank, transferType, orderType, fileFormat);
        if (orderTypes.size() > 0) {
            return orderTypes.get(0);
        }
        return null;
    }

    private static List<OrderType> findOrderTypes(BankSettings bank, TransferType transferType, String orderType, String fileFormat) {
        ExpressionList expressionList = DB.find(OrderType.class).where().eq("bank.bankId", (Object)bank.getBankId()).eq("orderType", (Object)orderType).eq("transferType", (Object)transferType);
        expressionList = fileFormat == null ? expressionList.isNull("fileFormat") : expressionList.eq("fileFormat", (Object)fileFormat);
        return expressionList.findList();
    }

    public static Query<OrderType> findByBank(BankSettings bank) {
        return DB.find(OrderType.class).where().eq("bank", (Object)bank).order("orderType,fileFormat").query();
    }

    public static List<OrderType> findFetchOrderTypesForBank(BankSettings bank) {
        return DB.find(OrderType.class).where().eq("bank", (Object)bank).eq("transferType", (Object)TransferType.FETCH).order("orderType,fileFormat").findList();
    }

    public static List<OrderType> findSendOrderTypesForBank(BankSettings bank) {
        return DB.find(OrderType.class).where().eq("bank", (Object)bank).eq("transferType", (Object)TransferType.SEND).order("orderType,fileFormat").findList();
    }

    public static Expression buildExpressionForOrderTypePermissions(User user, String bankField, String orderTypeField, String fileTypeField, String accountField) {
        Expression result = null;
        for (BankUser bankUser : BankUser.findBanksForUser(user)) {
            HashMap<MyOrderTypes, HashSet> map;
            HashSet<String> orderTypes = new HashSet<String>();
            HashSet<String> fileFormats = new HashSet<String>();
            HashMap<Account, SortedSet> accountFileFormats = new HashMap<Account, SortedSet>();
            HashMap<Account, SortedSet> accountOrderTypes = new HashMap<Account, SortedSet>();
            for (UserPermission permission : UserPermission.findSendPermissionsForBankUser(bankUser).findList()) {
                if (permission.getOrderType() == null) continue;
                if (permission.getOrderType().getFileFormat() != null) {
                    if (permission.getAccountPermission() != null && accountField != null) {
                        accountFileFormats.computeIfAbsent(permission.getAccountPermission().getAccount(), s -> new TreeSet()).add(permission.getOrderType().getFileFormat());
                        continue;
                    }
                    fileFormats.add(permission.getOrderType().getFileFormat());
                    continue;
                }
                String tmp = permission.getOrderType().getOrderType();
                if (IGNORE_SEND_ORDER_TYPES.contains(tmp)) continue;
                if (permission.getAccountPermission() != null && accountField != null) {
                    accountOrderTypes.computeIfAbsent(permission.getAccountPermission().getAccount(), s -> new TreeSet()).add(tmp);
                    continue;
                }
                orderTypes.add(tmp);
            }
            if (orderTypes.isEmpty() && fileFormats.isEmpty() && accountOrderTypes.isEmpty() && accountFileFormats.isEmpty() && BankUserHtdInfo.findForBankUser(bankUser) != null) continue;
            Expression currentExpression = Expr.eq((String)bankField, (Object)bankUser.getBank());
            Expression orderFileTypeExpression = null;
            if (!fileFormats.isEmpty() && fileFormats.size() <= 1000) {
                orderFileTypeExpression = Expr.in((String)fileTypeField, fileFormats);
            }
            if (!orderTypes.isEmpty() && orderTypes.size() <= 1000) {
                orderFileTypeExpression = orderFileTypeExpression == null ? Expr.in((String)orderTypeField, orderTypes) : Expr.or((Expression)orderFileTypeExpression, (Expression)Expr.in((String)orderTypeField, orderTypes));
            }
            if (!accountOrderTypes.isEmpty() && accountOrderTypes.size() <= 1000) {
                map = new HashMap<MyOrderTypes, HashSet>();
                for (Object key : accountOrderTypes.keySet()) {
                    map.computeIfAbsent(new MyOrderTypes((SortedSet)accountOrderTypes.get(key)), myOrderTypes -> new HashSet()).add(key);
                }
                for (Object key : map.keySet()) {
                    if (orderFileTypeExpression == null) {
                        orderFileTypeExpression = Expr.and((Expression)Expr.in((String)orderTypeField, ((MyOrderTypes)key).orderTypes), (Expression)Expr.in((String)accountField, (Collection)((Collection)map.get(key))));
                        continue;
                    }
                    orderFileTypeExpression = Expr.or((Expression)orderFileTypeExpression, (Expression)Expr.and((Expression)Expr.in((String)orderTypeField, ((MyOrderTypes)key).orderTypes), (Expression)Expr.in((String)accountField, (Collection)((Collection)map.get(key)))));
                }
            }
            if (!accountFileFormats.isEmpty() && accountFileFormats.size() <= 1000) {
                map = new HashMap();
                for (Object key : accountFileFormats.keySet()) {
                    map.computeIfAbsent(new MyOrderTypes((SortedSet)accountFileFormats.get(key)), myOrderTypes -> new HashSet()).add(key);
                }
                for (Object key : map.keySet()) {
                    if (orderFileTypeExpression == null) {
                        orderFileTypeExpression = Expr.and((Expression)Expr.in((String)fileTypeField, ((MyOrderTypes)key).orderTypes), (Expression)Expr.in((String)accountField, (Collection)((Collection)map.get(key))));
                        continue;
                    }
                    orderFileTypeExpression = Expr.or((Expression)orderFileTypeExpression, (Expression)Expr.and((Expression)Expr.in((String)fileTypeField, ((MyOrderTypes)key).orderTypes), (Expression)Expr.in((String)accountField, (Collection)((Collection)map.get(key)))));
                }
            }
            if (orderFileTypeExpression != null) {
                currentExpression = Expr.and((Expression)currentExpression, (Expression)orderFileTypeExpression);
            }
            if (result == null) {
                result = currentExpression;
                continue;
            }
            result = Expr.or((Expression)result, (Expression)currentExpression);
        }
        return result;
    }

    public static String buildRawExpressionForOrderTypePermissions(User user, String bankColumn, String orderTypeColumn, String fileTypeColumn, String accountColumn) {
        HashMap<Integer, SortedSet> accountOrderTypes = new HashMap<Integer, SortedSet>();
        HashMap<Integer, SortedSet> accountFileFormats = new HashMap<Integer, SortedSet>();
        StringBuilder resultBuilder = new StringBuilder();
        int numberOfExpressions = 0;
        for (BankUser bankUser : BankUser.findBanksForUser(user)) {
            boolean added;
            boolean first;
            HashMap<MyOrderTypes, HashSet> map;
            boolean columnAdded;
            HashSet<String> orderTypes = new HashSet<String>();
            HashSet<String> fileFormats = new HashSet<String>();
            for (UserPermission permission : UserPermission.findSendPermissionsForBankUser(bankUser).findList()) {
                if (permission.getOrderType() == null) continue;
                if (permission.getOrderType().getFileFormat() != null) {
                    if (permission.getAccountPermission() != null && accountColumn != null) {
                        accountFileFormats.computeIfAbsent(permission.getAccountPermission().getAccount().getId(), s -> new TreeSet()).add(permission.getOrderType().getFileFormat());
                        continue;
                    }
                    fileFormats.add(permission.getOrderType().getFileFormat());
                    continue;
                }
                String tmp = permission.getOrderType().getOrderType();
                if (IGNORE_SEND_ORDER_TYPES.contains(tmp)) continue;
                if (permission.getAccountPermission() != null && accountColumn != null) {
                    accountOrderTypes.computeIfAbsent(permission.getAccountPermission().getAccount().getId(), s -> new TreeSet()).add(tmp);
                    continue;
                }
                orderTypes.add(tmp);
            }
            if (orderTypes.isEmpty() && fileFormats.isEmpty() && accountOrderTypes.isEmpty() && accountFileFormats.isEmpty() && BankUserHtdInfo.findForBankUser(bankUser) != null) continue;
            StringBuilder currentExpressionBuilder = new StringBuilder(bankColumn).append('=').append(bankUser.getBank().getBankId());
            StringBuilder orderFileTypeExpressionBuilder = new StringBuilder();
            int numberOfOrderFileTypeExpressions = 0;
            if (!fileFormats.isEmpty() && fileFormats.size() <= 1000) {
                orderFileTypeExpressionBuilder.append(fileTypeColumn);
                if (fileFormats.size() == 1) {
                    orderFileTypeExpressionBuilder.append(" = ");
                } else {
                    orderFileTypeExpressionBuilder.append(" in (");
                }
                columnAdded = false;
                for (String fileFormat : fileFormats) {
                    if (columnAdded) {
                        orderFileTypeExpressionBuilder.append(", ");
                    }
                    orderFileTypeExpressionBuilder.append('\'').append(fileFormat).append('\'');
                    columnAdded = true;
                }
                if (fileFormats.size() > 1) {
                    orderFileTypeExpressionBuilder.append(')');
                }
                ++numberOfOrderFileTypeExpressions;
            }
            if (!orderTypes.isEmpty() && orderTypes.size() <= 1000) {
                if (numberOfOrderFileTypeExpressions > 0) {
                    orderFileTypeExpressionBuilder.append(" or ");
                }
                orderFileTypeExpressionBuilder.append(orderTypeColumn);
                if (orderTypes.size() == 1) {
                    orderFileTypeExpressionBuilder.append(" = ");
                } else {
                    orderFileTypeExpressionBuilder.append(" in (");
                }
                columnAdded = false;
                for (String orderType : orderTypes) {
                    if (columnAdded) {
                        orderFileTypeExpressionBuilder.append(", ");
                    }
                    orderFileTypeExpressionBuilder.append('\'').append(orderType).append('\'');
                    columnAdded = true;
                }
                if (orderTypes.size() > 1) {
                    orderFileTypeExpressionBuilder.append(')');
                }
                ++numberOfOrderFileTypeExpressions;
            }
            if (!accountOrderTypes.isEmpty() && accountOrderTypes.size() <= 1000) {
                map = new HashMap<MyOrderTypes, HashSet>();
                for (Integer i : accountOrderTypes.keySet()) {
                    map.computeIfAbsent(new MyOrderTypes((SortedSet)accountOrderTypes.get(i)), myOrderTypes -> new HashSet()).add(i);
                }
                for (MyOrderTypes key : map.keySet()) {
                    if (numberOfOrderFileTypeExpressions > 0) {
                        orderFileTypeExpressionBuilder.append(" or ");
                    }
                    orderFileTypeExpressionBuilder.append('(');
                    orderFileTypeExpressionBuilder.append(orderTypeColumn);
                    orderFileTypeExpressionBuilder.append(" in ('");
                    first = true;
                    for (String string : key.orderTypes) {
                        if (first) {
                            orderFileTypeExpressionBuilder.append(string);
                            orderFileTypeExpressionBuilder.append("'");
                            first = false;
                            continue;
                        }
                        orderFileTypeExpressionBuilder.append(",'");
                        orderFileTypeExpressionBuilder.append(string);
                        orderFileTypeExpressionBuilder.append("'");
                    }
                    orderFileTypeExpressionBuilder.append(") and ");
                    orderFileTypeExpressionBuilder.append(accountColumn);
                    orderFileTypeExpressionBuilder.append(" in (");
                    added = false;
                    for (Integer i : (HashSet)map.get(key)) {
                        if (added) {
                            orderFileTypeExpressionBuilder.append(',');
                        } else {
                            added = true;
                        }
                        orderFileTypeExpressionBuilder.append(i);
                    }
                    orderFileTypeExpressionBuilder.append("))");
                    ++numberOfOrderFileTypeExpressions;
                }
            }
            if (!accountFileFormats.isEmpty() && accountFileFormats.size() <= 1000) {
                map = new HashMap();
                for (Integer i : accountFileFormats.keySet()) {
                    map.computeIfAbsent(new MyOrderTypes((SortedSet)accountFileFormats.get(i)), myOrderTypes -> new HashSet()).add(i);
                }
                for (MyOrderTypes key : map.keySet()) {
                    if (numberOfOrderFileTypeExpressions > 0) {
                        orderFileTypeExpressionBuilder.append(" or ");
                    }
                    orderFileTypeExpressionBuilder.append('(');
                    orderFileTypeExpressionBuilder.append(fileTypeColumn);
                    orderFileTypeExpressionBuilder.append(" in ('");
                    first = true;
                    for (String string : key.orderTypes) {
                        if (first) {
                            orderFileTypeExpressionBuilder.append(string);
                            orderFileTypeExpressionBuilder.append("'");
                            first = false;
                            continue;
                        }
                        orderFileTypeExpressionBuilder.append(",'");
                        orderFileTypeExpressionBuilder.append(string);
                        orderFileTypeExpressionBuilder.append("'");
                    }
                    orderFileTypeExpressionBuilder.append(") and ");
                    orderFileTypeExpressionBuilder.append(accountColumn);
                    orderFileTypeExpressionBuilder.append(" in (");
                    added = false;
                    for (Integer i : (HashSet)map.get(key)) {
                        if (added) {
                            orderFileTypeExpressionBuilder.append(',');
                        } else {
                            added = true;
                        }
                        orderFileTypeExpressionBuilder.append(i);
                    }
                    orderFileTypeExpressionBuilder.append("))");
                    ++numberOfOrderFileTypeExpressions;
                }
            }
            if (numberOfOrderFileTypeExpressions == 1) {
                currentExpressionBuilder.append(" and ").append((CharSequence)orderFileTypeExpressionBuilder);
            } else if (numberOfOrderFileTypeExpressions > 1) {
                currentExpressionBuilder.append(" and ").append('(').append((CharSequence)orderFileTypeExpressionBuilder).append(')');
            }
            if (numberOfExpressions == 0) {
                resultBuilder.append((CharSequence)currentExpressionBuilder);
            } else if (numberOfExpressions == 1) {
                resultBuilder.insert(0, '(').append(") or (").append((CharSequence)currentExpressionBuilder).append(')');
            } else {
                resultBuilder.append(" or (").append((CharSequence)currentExpressionBuilder).append(')');
            }
            ++numberOfExpressions;
        }
        if (resultBuilder.length() > 0) {
            return resultBuilder.toString();
        }
        return null;
    }

    public Integer getId() {
        return this._ebean_get_id();
    }

    public void setId(Integer id) {
        this._ebean_set_id(id);
    }

    public BankSettings getBank() {
        return this._ebean_get_bank();
    }

    public void setBank(BankSettings bank) {
        this._ebean_set_bank(bank);
    }

    public TransferType getTransferType() {
        return this._ebean_get_transferType();
    }

    public void setTransferType(TransferType transferType) {
        this._ebean_set_transferType(transferType);
    }

    public String getOrderType() {
        return this._ebean_get_orderType();
    }

    public void setOrderType(String orderType) {
        this._ebean_set_orderType(orderType);
    }

    public String getFileFormat() {
        return this._ebean_get_fileFormat();
    }

    public void setFileFormat(String fileFormat) {
        this._ebean_set_fileFormat(fileFormat);
    }

    public boolean hasFileFormat() {
        return this._ebean_get_fileFormat() != null && this._ebean_get_fileFormat().trim().length() > 0;
    }

    public String getGeneralizedOrderType() {
        if (this.hasFileFormat()) {
            return this._ebean_get_fileFormat().trim();
        }
        return this._ebean_get_orderType();
    }

    public String getOrderFormat() {
        return this._ebean_get_orderFormat();
    }

    public void setOrderFormat(String orderFormat) {
        this._ebean_set_orderFormat(orderFormat);
    }

    public Integer getNumSigRequired() {
        return this._ebean_get_numSigRequired();
    }

    public void setNumSigRequired(Integer numSigRequired) {
        this._ebean_set_numSigRequired(numSigRequired);
    }

    public String getDescription() {
        return this._ebean_get_description();
    }

    public void setDescription(String description) {
        this._ebean_set_description(description);
    }

    public void save() {
        if (this.getId() == null) {
            DB.save(this);
        } else {
            DB.update(this);
        }
    }

    static {
        _ebean_props = new String[]{"id", "bank", "transferType", "orderType", "fileFormat", "orderFormat", "numSigRequired", "description"};
        IGNORE_SEND_ORDER_TYPES = new HashSet<String>();
        IGNORE_SEND_ORDER_TYPES.add("H3K");
        IGNORE_SEND_ORDER_TYPES.add("HCA");
        IGNORE_SEND_ORDER_TYPES.add("HCS");
        IGNORE_SEND_ORDER_TYPES.add("HIA");
        IGNORE_SEND_ORDER_TYPES.add("HSA");
        IGNORE_SEND_ORDER_TYPES.add("HVE");
        IGNORE_SEND_ORDER_TYPES.add("HVS");
        IGNORE_SEND_ORDER_TYPES.add("INI");
        IGNORE_SEND_ORDER_TYPES.add("PUB");
        IGNORE_SEND_ORDER_TYPES.add("PWA");
        IGNORE_SEND_ORDER_TYPES.add("SPR");
    }

    public /* synthetic */ String[] _ebean_getPropertyNames() {
        return _ebean_props;
    }

    public /* synthetic */ String _ebean_getPropertyName(int pos) {
        return _ebean_props[pos];
    }

    public /* synthetic */ EntityBeanIntercept _ebean_getIntercept() {
        return this._ebean_intercept;
    }

    public /* synthetic */ EntityBeanIntercept _ebean_intercept() {
        if (this._ebean_intercept == null) {
            this._ebean_intercept = new EntityBeanIntercept((Object)this);
        }
        return this._ebean_intercept;
    }

    protected /* synthetic */ Integer _ebean_get_id() {
        this._ebean_intercept.preGetId();
        return this.id;
    }

    protected /* synthetic */ void _ebean_set_id(Integer newValue) {
        this._ebean_intercept.preSetter(false, 0, (Object)this.id, (Object)newValue);
        this.id = newValue;
    }

    protected /* synthetic */ Integer _ebean_getni_id() {
        return this.id;
    }

    protected /* synthetic */ void _ebean_setni_id(Integer _newValue) {
        this.id = _newValue;
        this._ebean_intercept.setLoadedProperty(0);
    }

    protected /* synthetic */ BankSettings _ebean_get_bank() {
        this._ebean_intercept.preGetter(1);
        return this.bank;
    }

    protected /* synthetic */ void _ebean_set_bank(BankSettings newValue) {
        this._ebean_intercept.preSetter(true, 1, (Object)this._ebean_get_bank(), (Object)newValue);
        this.bank = newValue;
    }

    protected /* synthetic */ BankSettings _ebean_getni_bank() {
        return this.bank;
    }

    protected /* synthetic */ void _ebean_setni_bank(BankSettings _newValue) {
        this.bank = _newValue;
        this._ebean_intercept.setLoadedProperty(1);
    }

    protected /* synthetic */ TransferType _ebean_get_transferType() {
        this._ebean_intercept.preGetter(2);
        return this.transferType;
    }

    protected /* synthetic */ void _ebean_set_transferType(TransferType newValue) {
        this._ebean_intercept.preSetter(true, 2, (Object)this._ebean_get_transferType(), (Object)newValue);
        this.transferType = newValue;
    }

    protected /* synthetic */ TransferType _ebean_getni_transferType() {
        return this.transferType;
    }

    protected /* synthetic */ void _ebean_setni_transferType(TransferType _newValue) {
        this.transferType = _newValue;
        this._ebean_intercept.setLoadedProperty(2);
    }

    protected /* synthetic */ String _ebean_get_orderType() {
        this._ebean_intercept.preGetter(3);
        return this.orderType;
    }

    protected /* synthetic */ void _ebean_set_orderType(String newValue) {
        this._ebean_intercept.preSetter(true, 3, (Object)this._ebean_get_orderType(), (Object)newValue);
        this.orderType = newValue;
    }

    protected /* synthetic */ String _ebean_getni_orderType() {
        return this.orderType;
    }

    protected /* synthetic */ void _ebean_setni_orderType(String _newValue) {
        this.orderType = _newValue;
        this._ebean_intercept.setLoadedProperty(3);
    }

    protected /* synthetic */ String _ebean_get_fileFormat() {
        this._ebean_intercept.preGetter(4);
        return this.fileFormat;
    }

    protected /* synthetic */ void _ebean_set_fileFormat(String newValue) {
        this._ebean_intercept.preSetter(true, 4, (Object)this._ebean_get_fileFormat(), (Object)newValue);
        this.fileFormat = newValue;
    }

    protected /* synthetic */ String _ebean_getni_fileFormat() {
        return this.fileFormat;
    }

    protected /* synthetic */ void _ebean_setni_fileFormat(String _newValue) {
        this.fileFormat = _newValue;
        this._ebean_intercept.setLoadedProperty(4);
    }

    protected /* synthetic */ String _ebean_get_orderFormat() {
        this._ebean_intercept.preGetter(5);
        return this.orderFormat;
    }

    protected /* synthetic */ void _ebean_set_orderFormat(String newValue) {
        this._ebean_intercept.preSetter(true, 5, (Object)this._ebean_get_orderFormat(), (Object)newValue);
        this.orderFormat = newValue;
    }

    protected /* synthetic */ String _ebean_getni_orderFormat() {
        return this.orderFormat;
    }

    protected /* synthetic */ void _ebean_setni_orderFormat(String _newValue) {
        this.orderFormat = _newValue;
        this._ebean_intercept.setLoadedProperty(5);
    }

    protected /* synthetic */ Integer _ebean_get_numSigRequired() {
        this._ebean_intercept.preGetter(6);
        return this.numSigRequired;
    }

    protected /* synthetic */ void _ebean_set_numSigRequired(Integer newValue) {
        this._ebean_intercept.preSetter(true, 6, (Object)this._ebean_get_numSigRequired(), (Object)newValue);
        this.numSigRequired = newValue;
    }

    protected /* synthetic */ Integer _ebean_getni_numSigRequired() {
        return this.numSigRequired;
    }

    protected /* synthetic */ void _ebean_setni_numSigRequired(Integer _newValue) {
        this.numSigRequired = _newValue;
        this._ebean_intercept.setLoadedProperty(6);
    }

    protected /* synthetic */ String _ebean_get_description() {
        this._ebean_intercept.preGetter(7);
        return this.description;
    }

    protected /* synthetic */ void _ebean_set_description(String newValue) {
        this._ebean_intercept.preSetter(true, 7, (Object)this._ebean_get_description(), (Object)newValue);
        this.description = newValue;
    }

    protected /* synthetic */ String _ebean_getni_description() {
        return this.description;
    }

    protected /* synthetic */ void _ebean_setni_description(String _newValue) {
        this.description = _newValue;
        this._ebean_intercept.setLoadedProperty(7);
    }

    public /* synthetic */ Object _ebean_getField(int index) {
        switch (index) {
            case 0: {
                return this.id;
            }
            case 1: {
                return this.bank;
            }
            case 2: {
                return this.transferType;
            }
            case 3: {
                return this.orderType;
            }
            case 4: {
                return this.fileFormat;
            }
            case 5: {
                return this.orderFormat;
            }
            case 6: {
                return this.numSigRequired;
            }
            case 7: {
                return this.description;
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    public /* synthetic */ Object _ebean_getFieldIntercept(int index) {
        switch (index) {
            case 0: {
                return this._ebean_get_id();
            }
            case 1: {
                return this._ebean_get_bank();
            }
            case 2: {
                return this._ebean_get_transferType();
            }
            case 3: {
                return this._ebean_get_orderType();
            }
            case 4: {
                return this._ebean_get_fileFormat();
            }
            case 5: {
                return this._ebean_get_orderFormat();
            }
            case 6: {
                return this._ebean_get_numSigRequired();
            }
            case 7: {
                return this._ebean_get_description();
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    public /* synthetic */ void _ebean_setField(int index, Object o) {
        switch (index) {
            case 0: {
                this._ebean_setni_id((Integer)o);
                return;
            }
            case 1: {
                this._ebean_setni_bank((BankSettings)o);
                return;
            }
            case 2: {
                this._ebean_setni_transferType((TransferType)((Object)o));
                return;
            }
            case 3: {
                this._ebean_setni_orderType((String)o);
                return;
            }
            case 4: {
                this._ebean_setni_fileFormat((String)o);
                return;
            }
            case 5: {
                this._ebean_setni_orderFormat((String)o);
                return;
            }
            case 6: {
                this._ebean_setni_numSigRequired((Integer)o);
                return;
            }
            case 7: {
                this._ebean_setni_description((String)o);
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    public /* synthetic */ void _ebean_setFieldIntercept(int index, Object o) {
        switch (index) {
            case 0: {
                this._ebean_set_id((Integer)o);
                return;
            }
            case 1: {
                this._ebean_set_bank((BankSettings)o);
                return;
            }
            case 2: {
                this._ebean_set_transferType((TransferType)((Object)o));
                return;
            }
            case 3: {
                this._ebean_set_orderType((String)o);
                return;
            }
            case 4: {
                this._ebean_set_fileFormat((String)o);
                return;
            }
            case 5: {
                this._ebean_set_orderFormat((String)o);
                return;
            }
            case 6: {
                this._ebean_set_numSigRequired((Integer)o);
                return;
            }
            case 7: {
                this._ebean_set_description((String)o);
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private /* synthetic */ Object _ebean_getIdentity() {
        OrderType orderType = this;
        synchronized (orderType) {
            if (this._ebean_identity != null) {
                return this._ebean_identity;
            }
            Object tmpId = this._ebean_getField(0);
            this._ebean_identity = tmpId != null ? tmpId : new Object();
            return this._ebean_identity;
        }
    }

    public /* synthetic */ boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        return this._ebean_getIdentity().equals(((OrderType)obj)._ebean_getIdentity());
    }

    public /* synthetic */ int hashCode() {
        return this._ebean_getIdentity().hashCode();
    }

    public /* synthetic */ void _ebean_setEmbeddedLoaded() {
    }

    public /* synthetic */ boolean _ebean_isEmbeddedNewOrDirty() {
        return false;
    }

    public /* synthetic */ Object _ebean_newInstance() {
        return new OrderType();
    }

    public static enum TransferType {
        SEND,
        FETCH;

    }

    private static class MyOrderTypes {
        SortedSet<String> orderTypes;
        String key;

        public MyOrderTypes(SortedSet<String> list) {
            this.orderTypes = list;
            StringBuilder b = new StringBuilder();
            for (String k : list) {
                if (b.length() > 0) {
                    b.append(",");
                }
                b.append(k);
            }
            this.key = b.toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MyOrderTypes that = (MyOrderTypes)o;
            return this.key.equals(that.key);
        }

        public int hashCode() {
            return Objects.hash(this.key);
        }
    }
}

