/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.database.vo;

import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.Notification;
import de.businesslogics.banking.database.vo.NotificationPmtInf;
import de.businesslogics.banking.database.vo.Send;
import de.businesslogics.banking.database.vo.SignedPayment;
import io.ebean.annotation.Index;
import io.ebean.bean.EntityBean;
import io.ebean.bean.EntityBeanIntercept;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.List;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;

@Entity
@Index(name="ix_notification_trx_status_recipient_account", columnNames={"tx_sts", "recipient", "recipient_account_number"})
public class NotificationTrx
implements EntityBean {
    @Id
    private Integer id;
    @ManyToOne
    private Notification notification;
    @ManyToOne
    private NotificationPmtInf pmtInf;
    @ManyToOne
    private Send send;
    @ManyToOne
    private SignedPayment signedPayment;
    private String orgnlInstrId;
    private String orgnlEndToEndId;
    @Column(length=4)
    private String txSts;
    @Column(length=70)
    private String originator;
    @Column(length=40)
    private String originatorAccountNumber;
    @Column(length=34)
    private String originatorBankCode;
    @Column(length=70)
    private String recipient;
    @Column(length=40)
    private String recipientAccountNumber;
    @Column(length=34)
    private String recipientBankCode;
    @Column(precision=38, scale=3)
    private BigDecimal amount;
    @Column(length=3)
    private String amountCurrency;
    @Column(length=140)
    private String purpose;
    private Timestamp executionDate;
    @Lob
    @Basic(fetch=FetchType.EAGER)
    private String statusReasonInfo;
    @Column(length=35)
    private String creditorId;
    @Column(length=35)
    private String mandateId;
    private Date mandateSignDate;
    public static /* synthetic */ String[] _ebean_props;
    protected /* synthetic */ EntityBeanIntercept _ebean_intercept;
    protected transient /* synthetic */ Object _ebean_identity;

    public NotificationTrx() {
        this._ebean_intercept = new EntityBeanIntercept((Object)this);
    }

    public Notification getNotification() {
        return this._ebean_get_notification();
    }

    public void setNotification(Notification notification) {
        this._ebean_set_notification(notification);
    }

    public NotificationPmtInf getPmtInf() {
        return this._ebean_get_pmtInf();
    }

    public void setPmtInf(NotificationPmtInf pmtInf) {
        this._ebean_set_pmtInf(pmtInf);
    }

    public Send getSend() {
        return this._ebean_get_send();
    }

    public void setSend(Send send) {
        this._ebean_set_send(send);
    }

    public SignedPayment getSignedPayment() {
        return this._ebean_get_signedPayment();
    }

    public void setSignedPayment(SignedPayment signedPayment) {
        this._ebean_set_signedPayment(signedPayment);
    }

    public String getOrgnlInstrId() {
        return this._ebean_get_orgnlInstrId();
    }

    public void setOrgnlInstrId(String orgnlInstrId) {
        this._ebean_set_orgnlInstrId(orgnlInstrId);
    }

    public String getOrgnlEndToEndId() {
        return this._ebean_get_orgnlEndToEndId();
    }

    public void setOrgnlEndToEndId(String orgnlEndToEndId) {
        this._ebean_set_orgnlEndToEndId(orgnlEndToEndId);
    }

    public String getTxSts() {
        return this._ebean_get_txSts();
    }

    public void setTxSts(String txSts) {
        this._ebean_set_txSts(txSts);
    }

    public String getOriginator() {
        return this._ebean_get_originator();
    }

    public void setOriginator(String originator) {
        this._ebean_set_originator(originator);
    }

    public String getOriginatorAccountNumber() {
        return this._ebean_get_originatorAccountNumber();
    }

    public void setOriginatorAccountNumber(String originatorAccountNumber) {
        this._ebean_set_originatorAccountNumber(originatorAccountNumber);
    }

    public String getOriginatorBankCode() {
        return this._ebean_get_originatorBankCode();
    }

    public void setOriginatorBankCode(String originatorBankCode) {
        this._ebean_set_originatorBankCode(originatorBankCode);
    }

    public String getRecipient() {
        if ((this._ebean_get_recipient() == null || this._ebean_get_recipient().isEmpty()) && this._ebean_get_signedPayment() != null) {
            return this._ebean_get_signedPayment().getRecipient();
        }
        return this._ebean_get_recipient();
    }

    public void setRecipient(String recipient) {
        this._ebean_set_recipient(recipient);
    }

    public String getRecipientAccountNumber() {
        return this._ebean_get_recipientAccountNumber();
    }

    public void setRecipientAccountNumber(String recipientAccountNumber) {
        this._ebean_set_recipientAccountNumber(recipientAccountNumber);
    }

    public String getRecipientBankCode() {
        return this._ebean_get_recipientBankCode();
    }

    public void setRecipientBankCode(String recipientBankCode) {
        this._ebean_set_recipientBankCode(recipientBankCode);
    }

    public BigDecimal getAmount() {
        if (this._ebean_get_amount() == null && this._ebean_get_signedPayment() != null) {
            return this._ebean_get_signedPayment().getAmount();
        }
        return this._ebean_get_amount();
    }

    public void setAmount(BigDecimal amount) {
        this._ebean_set_amount(amount);
    }

    public String getAmountCurrency() {
        if ((this._ebean_get_amountCurrency() == null || this._ebean_get_amountCurrency().isEmpty()) && this._ebean_get_signedPayment() != null) {
            return this._ebean_get_signedPayment().getAmountCurrency();
        }
        return this._ebean_get_amountCurrency();
    }

    public void setAmountCurrency(String amountCurrency) {
        this._ebean_set_amountCurrency(amountCurrency);
    }

    public String getPurpose() {
        if ((this._ebean_get_purpose() == null || this._ebean_get_purpose().isEmpty()) && this._ebean_get_signedPayment() != null) {
            return this._ebean_get_signedPayment().getPurpose();
        }
        return this._ebean_get_purpose();
    }

    public void setPurpose(String purpose) {
        this._ebean_set_purpose(purpose);
    }

    public Timestamp getExecutionDate() {
        return this._ebean_get_executionDate();
    }

    public void setExecutionDate(Timestamp executionDate) {
        this._ebean_set_executionDate(executionDate);
    }

    public String getStatusReasonInfo() {
        return this._ebean_get_statusReasonInfo();
    }

    public void setStatusReasonInfo(String statusReasonInfo) {
        this._ebean_set_statusReasonInfo(statusReasonInfo);
    }

    public String getCreditorId() {
        return this._ebean_get_creditorId();
    }

    public void setCreditorId(String creditorId) {
        this._ebean_set_creditorId(creditorId);
    }

    public String getMandateId() {
        return this._ebean_get_mandateId();
    }

    public void setMandateId(String mandateId) {
        this._ebean_set_mandateId(mandateId);
    }

    public Date getMandateSignDate() {
        return this._ebean_get_mandateSignDate();
    }

    public void setMandateSignDate(Date mandateSignDate) {
        this._ebean_set_mandateSignDate(mandateSignDate);
    }

    public Integer getId() {
        return this._ebean_get_id();
    }

    public static List<NotificationTrx> find(NotificationPmtInf notificationPmtInf) {
        return DB.find(NotificationTrx.class).where().eq("pmtInf", (Object)notificationPmtInf).findList();
    }

    public static List<NotificationTrx> find(Notification notification) {
        return DB.find(NotificationTrx.class).where().eq("notification", (Object)notification).findList();
    }

    public static int findCountByNotification(Notification notification) {
        return DB.find(NotificationTrx.class).where().eq("notification", (Object)notification).findCount();
    }

    public static int findCountByNotification(Notification notification, String txSts) {
        if (txSts != null) {
            return DB.find(NotificationTrx.class).where().eq("notification", (Object)notification).eq("txSts", (Object)txSts).findCount();
        }
        return NotificationTrx.findCountByNotification(notification);
    }

    public static int findCountByNotifications(List<Notification> notifications) {
        return DB.find(NotificationTrx.class).where().in("notification", notifications).findCount();
    }

    public static int findCountByNotifications(List<Notification> notifications, String txSts) {
        if (txSts != null) {
            return DB.find(NotificationTrx.class).where().in("notification", notifications).eq("txSts", (Object)txSts).findCount();
        }
        return NotificationTrx.findCountByNotifications(notifications);
    }

    public static List<NotificationTrx> findVopNotifications(String iban, String name, Set<String> states) {
        return DB.find(NotificationTrx.class).where().eq("recipientAccountNumber", (Object)iban).eq("recipient", (Object)name).in("txSts", states).findList();
    }

    public static List<NotificationTrx> findVopNotifications(String iban, String name, String state) {
        return DB.find(NotificationTrx.class).where().eq("recipientAccountNumber", (Object)iban).eq("recipient", (Object)name).eq("txSts", (Object)state).findList();
    }

    static {
        _ebean_props = new String[]{"id", "notification", "pmtInf", "send", "signedPayment", "orgnlInstrId", "orgnlEndToEndId", "txSts", "originator", "originatorAccountNumber", "originatorBankCode", "recipient", "recipientAccountNumber", "recipientBankCode", "amount", "amountCurrency", "purpose", "executionDate", "statusReasonInfo", "creditorId", "mandateId", "mandateSignDate"};
    }

    public /* synthetic */ String[] _ebean_getPropertyNames() {
        return _ebean_props;
    }

    public /* synthetic */ String _ebean_getPropertyName(int pos) {
        return _ebean_props[pos];
    }

    public /* synthetic */ EntityBeanIntercept _ebean_getIntercept() {
        return this._ebean_intercept;
    }

    public /* synthetic */ EntityBeanIntercept _ebean_intercept() {
        if (this._ebean_intercept == null) {
            this._ebean_intercept = new EntityBeanIntercept((Object)this);
        }
        return this._ebean_intercept;
    }

    protected /* synthetic */ Integer _ebean_get_id() {
        this._ebean_intercept.preGetId();
        return this.id;
    }

    protected /* synthetic */ void _ebean_set_id(Integer newValue) {
        this._ebean_intercept.preSetter(false, 0, (Object)this.id, (Object)newValue);
        this.id = newValue;
    }

    protected /* synthetic */ Integer _ebean_getni_id() {
        return this.id;
    }

    protected /* synthetic */ void _ebean_setni_id(Integer _newValue) {
        this.id = _newValue;
        this._ebean_intercept.setLoadedProperty(0);
    }

    protected /* synthetic */ Notification _ebean_get_notification() {
        this._ebean_intercept.preGetter(1);
        return this.notification;
    }

    protected /* synthetic */ void _ebean_set_notification(Notification newValue) {
        this._ebean_intercept.preSetter(true, 1, (Object)this._ebean_get_notification(), (Object)newValue);
        this.notification = newValue;
    }

    protected /* synthetic */ Notification _ebean_getni_notification() {
        return this.notification;
    }

    protected /* synthetic */ void _ebean_setni_notification(Notification _newValue) {
        this.notification = _newValue;
        this._ebean_intercept.setLoadedProperty(1);
    }

    protected /* synthetic */ NotificationPmtInf _ebean_get_pmtInf() {
        this._ebean_intercept.preGetter(2);
        return this.pmtInf;
    }

    protected /* synthetic */ void _ebean_set_pmtInf(NotificationPmtInf newValue) {
        this._ebean_intercept.preSetter(true, 2, (Object)this._ebean_get_pmtInf(), (Object)newValue);
        this.pmtInf = newValue;
    }

    protected /* synthetic */ NotificationPmtInf _ebean_getni_pmtInf() {
        return this.pmtInf;
    }

    protected /* synthetic */ void _ebean_setni_pmtInf(NotificationPmtInf _newValue) {
        this.pmtInf = _newValue;
        this._ebean_intercept.setLoadedProperty(2);
    }

    protected /* synthetic */ Send _ebean_get_send() {
        this._ebean_intercept.preGetter(3);
        return this.send;
    }

    protected /* synthetic */ void _ebean_set_send(Send newValue) {
        this._ebean_intercept.preSetter(true, 3, (Object)this._ebean_get_send(), (Object)newValue);
        this.send = newValue;
    }

    protected /* synthetic */ Send _ebean_getni_send() {
        return this.send;
    }

    protected /* synthetic */ void _ebean_setni_send(Send _newValue) {
        this.send = _newValue;
        this._ebean_intercept.setLoadedProperty(3);
    }

    protected /* synthetic */ SignedPayment _ebean_get_signedPayment() {
        this._ebean_intercept.preGetter(4);
        return this.signedPayment;
    }

    protected /* synthetic */ void _ebean_set_signedPayment(SignedPayment newValue) {
        this._ebean_intercept.preSetter(true, 4, (Object)this._ebean_get_signedPayment(), (Object)newValue);
        this.signedPayment = newValue;
    }

    protected /* synthetic */ SignedPayment _ebean_getni_signedPayment() {
        return this.signedPayment;
    }

    protected /* synthetic */ void _ebean_setni_signedPayment(SignedPayment _newValue) {
        this.signedPayment = _newValue;
        this._ebean_intercept.setLoadedProperty(4);
    }

    protected /* synthetic */ String _ebean_get_orgnlInstrId() {
        this._ebean_intercept.preGetter(5);
        return this.orgnlInstrId;
    }

    protected /* synthetic */ void _ebean_set_orgnlInstrId(String newValue) {
        this._ebean_intercept.preSetter(true, 5, (Object)this._ebean_get_orgnlInstrId(), (Object)newValue);
        this.orgnlInstrId = newValue;
    }

    protected /* synthetic */ String _ebean_getni_orgnlInstrId() {
        return this.orgnlInstrId;
    }

    protected /* synthetic */ void _ebean_setni_orgnlInstrId(String _newValue) {
        this.orgnlInstrId = _newValue;
        this._ebean_intercept.setLoadedProperty(5);
    }

    protected /* synthetic */ String _ebean_get_orgnlEndToEndId() {
        this._ebean_intercept.preGetter(6);
        return this.orgnlEndToEndId;
    }

    protected /* synthetic */ void _ebean_set_orgnlEndToEndId(String newValue) {
        this._ebean_intercept.preSetter(true, 6, (Object)this._ebean_get_orgnlEndToEndId(), (Object)newValue);
        this.orgnlEndToEndId = newValue;
    }

    protected /* synthetic */ String _ebean_getni_orgnlEndToEndId() {
        return this.orgnlEndToEndId;
    }

    protected /* synthetic */ void _ebean_setni_orgnlEndToEndId(String _newValue) {
        this.orgnlEndToEndId = _newValue;
        this._ebean_intercept.setLoadedProperty(6);
    }

    protected /* synthetic */ String _ebean_get_txSts() {
        this._ebean_intercept.preGetter(7);
        return this.txSts;
    }

    protected /* synthetic */ void _ebean_set_txSts(String newValue) {
        this._ebean_intercept.preSetter(true, 7, (Object)this._ebean_get_txSts(), (Object)newValue);
        this.txSts = newValue;
    }

    protected /* synthetic */ String _ebean_getni_txSts() {
        return this.txSts;
    }

    protected /* synthetic */ void _ebean_setni_txSts(String _newValue) {
        this.txSts = _newValue;
        this._ebean_intercept.setLoadedProperty(7);
    }

    protected /* synthetic */ String _ebean_get_originator() {
        this._ebean_intercept.preGetter(8);
        return this.originator;
    }

    protected /* synthetic */ void _ebean_set_originator(String newValue) {
        this._ebean_intercept.preSetter(true, 8, (Object)this._ebean_get_originator(), (Object)newValue);
        this.originator = newValue;
    }

    protected /* synthetic */ String _ebean_getni_originator() {
        return this.originator;
    }

    protected /* synthetic */ void _ebean_setni_originator(String _newValue) {
        this.originator = _newValue;
        this._ebean_intercept.setLoadedProperty(8);
    }

    protected /* synthetic */ String _ebean_get_originatorAccountNumber() {
        this._ebean_intercept.preGetter(9);
        return this.originatorAccountNumber;
    }

    protected /* synthetic */ void _ebean_set_originatorAccountNumber(String newValue) {
        this._ebean_intercept.preSetter(true, 9, (Object)this._ebean_get_originatorAccountNumber(), (Object)newValue);
        this.originatorAccountNumber = newValue;
    }

    protected /* synthetic */ String _ebean_getni_originatorAccountNumber() {
        return this.originatorAccountNumber;
    }

    protected /* synthetic */ void _ebean_setni_originatorAccountNumber(String _newValue) {
        this.originatorAccountNumber = _newValue;
        this._ebean_intercept.setLoadedProperty(9);
    }

    protected /* synthetic */ String _ebean_get_originatorBankCode() {
        this._ebean_intercept.preGetter(10);
        return this.originatorBankCode;
    }

    protected /* synthetic */ void _ebean_set_originatorBankCode(String newValue) {
        this._ebean_intercept.preSetter(true, 10, (Object)this._ebean_get_originatorBankCode(), (Object)newValue);
        this.originatorBankCode = newValue;
    }

    protected /* synthetic */ String _ebean_getni_originatorBankCode() {
        return this.originatorBankCode;
    }

    protected /* synthetic */ void _ebean_setni_originatorBankCode(String _newValue) {
        this.originatorBankCode = _newValue;
        this._ebean_intercept.setLoadedProperty(10);
    }

    protected /* synthetic */ String _ebean_get_recipient() {
        this._ebean_intercept.preGetter(11);
        return this.recipient;
    }

    protected /* synthetic */ void _ebean_set_recipient(String newValue) {
        this._ebean_intercept.preSetter(true, 11, (Object)this._ebean_get_recipient(), (Object)newValue);
        this.recipient = newValue;
    }

    protected /* synthetic */ String _ebean_getni_recipient() {
        return this.recipient;
    }

    protected /* synthetic */ void _ebean_setni_recipient(String _newValue) {
        this.recipient = _newValue;
        this._ebean_intercept.setLoadedProperty(11);
    }

    protected /* synthetic */ String _ebean_get_recipientAccountNumber() {
        this._ebean_intercept.preGetter(12);
        return this.recipientAccountNumber;
    }

    protected /* synthetic */ void _ebean_set_recipientAccountNumber(String newValue) {
        this._ebean_intercept.preSetter(true, 12, (Object)this._ebean_get_recipientAccountNumber(), (Object)newValue);
        this.recipientAccountNumber = newValue;
    }

    protected /* synthetic */ String _ebean_getni_recipientAccountNumber() {
        return this.recipientAccountNumber;
    }

    protected /* synthetic */ void _ebean_setni_recipientAccountNumber(String _newValue) {
        this.recipientAccountNumber = _newValue;
        this._ebean_intercept.setLoadedProperty(12);
    }

    protected /* synthetic */ String _ebean_get_recipientBankCode() {
        this._ebean_intercept.preGetter(13);
        return this.recipientBankCode;
    }

    protected /* synthetic */ void _ebean_set_recipientBankCode(String newValue) {
        this._ebean_intercept.preSetter(true, 13, (Object)this._ebean_get_recipientBankCode(), (Object)newValue);
        this.recipientBankCode = newValue;
    }

    protected /* synthetic */ String _ebean_getni_recipientBankCode() {
        return this.recipientBankCode;
    }

    protected /* synthetic */ void _ebean_setni_recipientBankCode(String _newValue) {
        this.recipientBankCode = _newValue;
        this._ebean_intercept.setLoadedProperty(13);
    }

    protected /* synthetic */ BigDecimal _ebean_get_amount() {
        this._ebean_intercept.preGetter(14);
        return this.amount;
    }

    protected /* synthetic */ void _ebean_set_amount(BigDecimal newValue) {
        this._ebean_intercept.preSetter(true, 14, (Object)this._ebean_get_amount(), (Object)newValue);
        this.amount = newValue;
    }

    protected /* synthetic */ BigDecimal _ebean_getni_amount() {
        return this.amount;
    }

    protected /* synthetic */ void _ebean_setni_amount(BigDecimal _newValue) {
        this.amount = _newValue;
        this._ebean_intercept.setLoadedProperty(14);
    }

    protected /* synthetic */ String _ebean_get_amountCurrency() {
        this._ebean_intercept.preGetter(15);
        return this.amountCurrency;
    }

    protected /* synthetic */ void _ebean_set_amountCurrency(String newValue) {
        this._ebean_intercept.preSetter(true, 15, (Object)this._ebean_get_amountCurrency(), (Object)newValue);
        this.amountCurrency = newValue;
    }

    protected /* synthetic */ String _ebean_getni_amountCurrency() {
        return this.amountCurrency;
    }

    protected /* synthetic */ void _ebean_setni_amountCurrency(String _newValue) {
        this.amountCurrency = _newValue;
        this._ebean_intercept.setLoadedProperty(15);
    }

    protected /* synthetic */ String _ebean_get_purpose() {
        this._ebean_intercept.preGetter(16);
        return this.purpose;
    }

    protected /* synthetic */ void _ebean_set_purpose(String newValue) {
        this._ebean_intercept.preSetter(true, 16, (Object)this._ebean_get_purpose(), (Object)newValue);
        this.purpose = newValue;
    }

    protected /* synthetic */ String _ebean_getni_purpose() {
        return this.purpose;
    }

    protected /* synthetic */ void _ebean_setni_purpose(String _newValue) {
        this.purpose = _newValue;
        this._ebean_intercept.setLoadedProperty(16);
    }

    protected /* synthetic */ Timestamp _ebean_get_executionDate() {
        this._ebean_intercept.preGetter(17);
        return this.executionDate;
    }

    protected /* synthetic */ void _ebean_set_executionDate(Timestamp newValue) {
        this._ebean_intercept.preSetter(true, 17, (Object)this._ebean_get_executionDate(), (Object)newValue);
        this.executionDate = newValue;
    }

    protected /* synthetic */ Timestamp _ebean_getni_executionDate() {
        return this.executionDate;
    }

    protected /* synthetic */ void _ebean_setni_executionDate(Timestamp _newValue) {
        this.executionDate = _newValue;
        this._ebean_intercept.setLoadedProperty(17);
    }

    protected /* synthetic */ String _ebean_get_statusReasonInfo() {
        this._ebean_intercept.preGetter(18);
        return this.statusReasonInfo;
    }

    protected /* synthetic */ void _ebean_set_statusReasonInfo(String newValue) {
        this._ebean_intercept.preSetter(true, 18, (Object)this._ebean_get_statusReasonInfo(), (Object)newValue);
        this.statusReasonInfo = newValue;
    }

    protected /* synthetic */ String _ebean_getni_statusReasonInfo() {
        return this.statusReasonInfo;
    }

    protected /* synthetic */ void _ebean_setni_statusReasonInfo(String _newValue) {
        this.statusReasonInfo = _newValue;
        this._ebean_intercept.setLoadedProperty(18);
    }

    protected /* synthetic */ String _ebean_get_creditorId() {
        this._ebean_intercept.preGetter(19);
        return this.creditorId;
    }

    protected /* synthetic */ void _ebean_set_creditorId(String newValue) {
        this._ebean_intercept.preSetter(true, 19, (Object)this._ebean_get_creditorId(), (Object)newValue);
        this.creditorId = newValue;
    }

    protected /* synthetic */ String _ebean_getni_creditorId() {
        return this.creditorId;
    }

    protected /* synthetic */ void _ebean_setni_creditorId(String _newValue) {
        this.creditorId = _newValue;
        this._ebean_intercept.setLoadedProperty(19);
    }

    protected /* synthetic */ String _ebean_get_mandateId() {
        this._ebean_intercept.preGetter(20);
        return this.mandateId;
    }

    protected /* synthetic */ void _ebean_set_mandateId(String newValue) {
        this._ebean_intercept.preSetter(true, 20, (Object)this._ebean_get_mandateId(), (Object)newValue);
        this.mandateId = newValue;
    }

    protected /* synthetic */ String _ebean_getni_mandateId() {
        return this.mandateId;
    }

    protected /* synthetic */ void _ebean_setni_mandateId(String _newValue) {
        this.mandateId = _newValue;
        this._ebean_intercept.setLoadedProperty(20);
    }

    protected /* synthetic */ Date _ebean_get_mandateSignDate() {
        this._ebean_intercept.preGetter(21);
        return this.mandateSignDate;
    }

    protected /* synthetic */ void _ebean_set_mandateSignDate(Date newValue) {
        this._ebean_intercept.preSetter(true, 21, (Object)this._ebean_get_mandateSignDate(), (Object)newValue);
        this.mandateSignDate = newValue;
    }

    protected /* synthetic */ Date _ebean_getni_mandateSignDate() {
        return this.mandateSignDate;
    }

    protected /* synthetic */ void _ebean_setni_mandateSignDate(Date _newValue) {
        this.mandateSignDate = _newValue;
        this._ebean_intercept.setLoadedProperty(21);
    }

    public /* synthetic */ Object _ebean_getField(int index) {
        switch (index) {
            case 0: {
                return this.id;
            }
            case 1: {
                return this.notification;
            }
            case 2: {
                return this.pmtInf;
            }
            case 3: {
                return this.send;
            }
            case 4: {
                return this.signedPayment;
            }
            case 5: {
                return this.orgnlInstrId;
            }
            case 6: {
                return this.orgnlEndToEndId;
            }
            case 7: {
                return this.txSts;
            }
            case 8: {
                return this.originator;
            }
            case 9: {
                return this.originatorAccountNumber;
            }
            case 10: {
                return this.originatorBankCode;
            }
            case 11: {
                return this.recipient;
            }
            case 12: {
                return this.recipientAccountNumber;
            }
            case 13: {
                return this.recipientBankCode;
            }
            case 14: {
                return this.amount;
            }
            case 15: {
                return this.amountCurrency;
            }
            case 16: {
                return this.purpose;
            }
            case 17: {
                return this.executionDate;
            }
            case 18: {
                return this.statusReasonInfo;
            }
            case 19: {
                return this.creditorId;
            }
            case 20: {
                return this.mandateId;
            }
            case 21: {
                return this.mandateSignDate;
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    public /* synthetic */ Object _ebean_getFieldIntercept(int index) {
        switch (index) {
            case 0: {
                return this._ebean_get_id();
            }
            case 1: {
                return this._ebean_get_notification();
            }
            case 2: {
                return this._ebean_get_pmtInf();
            }
            case 3: {
                return this._ebean_get_send();
            }
            case 4: {
                return this._ebean_get_signedPayment();
            }
            case 5: {
                return this._ebean_get_orgnlInstrId();
            }
            case 6: {
                return this._ebean_get_orgnlEndToEndId();
            }
            case 7: {
                return this._ebean_get_txSts();
            }
            case 8: {
                return this._ebean_get_originator();
            }
            case 9: {
                return this._ebean_get_originatorAccountNumber();
            }
            case 10: {
                return this._ebean_get_originatorBankCode();
            }
            case 11: {
                return this._ebean_get_recipient();
            }
            case 12: {
                return this._ebean_get_recipientAccountNumber();
            }
            case 13: {
                return this._ebean_get_recipientBankCode();
            }
            case 14: {
                return this._ebean_get_amount();
            }
            case 15: {
                return this._ebean_get_amountCurrency();
            }
            case 16: {
                return this._ebean_get_purpose();
            }
            case 17: {
                return this._ebean_get_executionDate();
            }
            case 18: {
                return this._ebean_get_statusReasonInfo();
            }
            case 19: {
                return this._ebean_get_creditorId();
            }
            case 20: {
                return this._ebean_get_mandateId();
            }
            case 21: {
                return this._ebean_get_mandateSignDate();
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    public /* synthetic */ void _ebean_setField(int index, Object o) {
        switch (index) {
            case 0: {
                this._ebean_setni_id((Integer)o);
                return;
            }
            case 1: {
                this._ebean_setni_notification((Notification)o);
                return;
            }
            case 2: {
                this._ebean_setni_pmtInf((NotificationPmtInf)o);
                return;
            }
            case 3: {
                this._ebean_setni_send((Send)o);
                return;
            }
            case 4: {
                this._ebean_setni_signedPayment((SignedPayment)o);
                return;
            }
            case 5: {
                this._ebean_setni_orgnlInstrId((String)o);
                return;
            }
            case 6: {
                this._ebean_setni_orgnlEndToEndId((String)o);
                return;
            }
            case 7: {
                this._ebean_setni_txSts((String)o);
                return;
            }
            case 8: {
                this._ebean_setni_originator((String)o);
                return;
            }
            case 9: {
                this._ebean_setni_originatorAccountNumber((String)o);
                return;
            }
            case 10: {
                this._ebean_setni_originatorBankCode((String)o);
                return;
            }
            case 11: {
                this._ebean_setni_recipient((String)o);
                return;
            }
            case 12: {
                this._ebean_setni_recipientAccountNumber((String)o);
                return;
            }
            case 13: {
                this._ebean_setni_recipientBankCode((String)o);
                return;
            }
            case 14: {
                this._ebean_setni_amount((BigDecimal)o);
                return;
            }
            case 15: {
                this._ebean_setni_amountCurrency((String)o);
                return;
            }
            case 16: {
                this._ebean_setni_purpose((String)o);
                return;
            }
            case 17: {
                this._ebean_setni_executionDate((Timestamp)o);
                return;
            }
            case 18: {
                this._ebean_setni_statusReasonInfo((String)o);
                return;
            }
            case 19: {
                this._ebean_setni_creditorId((String)o);
                return;
            }
            case 20: {
                this._ebean_setni_mandateId((String)o);
                return;
            }
            case 21: {
                this._ebean_setni_mandateSignDate((Date)o);
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    public /* synthetic */ void _ebean_setFieldIntercept(int index, Object o) {
        switch (index) {
            case 0: {
                this._ebean_set_id((Integer)o);
                return;
            }
            case 1: {
                this._ebean_set_notification((Notification)o);
                return;
            }
            case 2: {
                this._ebean_set_pmtInf((NotificationPmtInf)o);
                return;
            }
            case 3: {
                this._ebean_set_send((Send)o);
                return;
            }
            case 4: {
                this._ebean_set_signedPayment((SignedPayment)o);
                return;
            }
            case 5: {
                this._ebean_set_orgnlInstrId((String)o);
                return;
            }
            case 6: {
                this._ebean_set_orgnlEndToEndId((String)o);
                return;
            }
            case 7: {
                this._ebean_set_txSts((String)o);
                return;
            }
            case 8: {
                this._ebean_set_originator((String)o);
                return;
            }
            case 9: {
                this._ebean_set_originatorAccountNumber((String)o);
                return;
            }
            case 10: {
                this._ebean_set_originatorBankCode((String)o);
                return;
            }
            case 11: {
                this._ebean_set_recipient((String)o);
                return;
            }
            case 12: {
                this._ebean_set_recipientAccountNumber((String)o);
                return;
            }
            case 13: {
                this._ebean_set_recipientBankCode((String)o);
                return;
            }
            case 14: {
                this._ebean_set_amount((BigDecimal)o);
                return;
            }
            case 15: {
                this._ebean_set_amountCurrency((String)o);
                return;
            }
            case 16: {
                this._ebean_set_purpose((String)o);
                return;
            }
            case 17: {
                this._ebean_set_executionDate((Timestamp)o);
                return;
            }
            case 18: {
                this._ebean_set_statusReasonInfo((String)o);
                return;
            }
            case 19: {
                this._ebean_set_creditorId((String)o);
                return;
            }
            case 20: {
                this._ebean_set_mandateId((String)o);
                return;
            }
            case 21: {
                this._ebean_set_mandateSignDate((Date)o);
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private /* synthetic */ Object _ebean_getIdentity() {
        NotificationTrx notificationTrx = this;
        synchronized (notificationTrx) {
            if (this._ebean_identity != null) {
                return this._ebean_identity;
            }
            Object tmpId = this._ebean_getField(0);
            this._ebean_identity = tmpId != null ? tmpId : new Object();
            return this._ebean_identity;
        }
    }

    public /* synthetic */ boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        return this._ebean_getIdentity().equals(((NotificationTrx)obj)._ebean_getIdentity());
    }

    public /* synthetic */ int hashCode() {
        return this._ebean_getIdentity().hashCode();
    }

    public /* synthetic */ void _ebean_setEmbeddedLoaded() {
    }

    public /* synthetic */ boolean _ebean_isEmbeddedNewOrDirty() {
        return false;
    }

    public /* synthetic */ Object _ebean_newInstance() {
        return new NotificationTrx();
    }
}

