/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.database.vo;

import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.BaseFilterWithOrderTypeBank;
import de.businesslogics.banking.database.vo.FilterComparator;
import de.businesslogics.banking.database.vo.User;
import io.ebean.Expression;
import io.ebean.Update;
import io.ebean.bean.EntityBean;
import java.sql.Date;
import javax.persistence.Entity;
import javax.persistence.Table;

@Entity
@Table(name="nf_filter")
public class NotificationFilter
extends BaseFilterWithOrderTypeBank
implements EntityBean {
    private static final long serialVersionUID = 1L;
    private boolean notificationActive;
    public static /* synthetic */ String[] _ebean_props;

    public static NotificationFilter getFilter(User user) {
        NotificationFilter f = (NotificationFilter)DB.find(NotificationFilter.class).where().eq("user", (Object)user).findOne();
        if (f == null) {
            return new NotificationFilter(user);
        }
        return f;
    }

    public static int deleteByUser(User user) {
        NotificationFilter notificationFilter = (NotificationFilter)DB.find(NotificationFilter.class).where().eq("user", (Object)user).findOne();
        if (notificationFilter != null) {
            DB.delete(notificationFilter);
            return 1;
        }
        return 0;
    }

    public static int deleteByBank(BankSettings bank) {
        Update<NotificationFilter> delete = DB.createUpdate(NotificationFilter.class, "UPDATE NotificationFilter SET bank=NULL WHERE bank=:bank");
        delete.setParameter("bank", (Object)bank.getBankId());
        return delete.execute();
    }

    private NotificationFilter(User user) {
        super(user);
    }

    public final boolean isEmpty() {
        return this.isDateFilterEmpty() && this.getBank() == null && this.getOrderType() == null;
    }

    public boolean isNotificationActive() {
        return this._ebean_get_notificationActive();
    }

    public void setNotificationActive(boolean notificationActive) {
        this._ebean_set_notificationActive(notificationActive);
    }

    public Expression getExpression() {
        Expression orderTypeExpression;
        Expression toReturn = this.getDateExpression("fetched");
        Expression bankExpression = this.getBankExpression("bank");
        if (bankExpression != null) {
            toReturn = this.addFilter(toReturn, bankExpression);
        }
        if ((orderTypeExpression = this.getOrderTypeExpression("orderType", "fileType")) != null) {
            toReturn = this.addFilter(toReturn, orderTypeExpression);
        }
        return toReturn;
    }

    static {
        _ebean_props = new String[]{"id", "user", "fromDate", "toDate", "dateComparator", "orderType", "orderTypeComparator", "bank", "bankComparator", "notificationActive"};
    }

    public /* synthetic */ NotificationFilter() {
    }

    @Override
    public /* synthetic */ String[] _ebean_getPropertyNames() {
        return _ebean_props;
    }

    @Override
    public /* synthetic */ String _ebean_getPropertyName(int pos) {
        return _ebean_props[pos];
    }

    protected /* synthetic */ boolean _ebean_get_notificationActive() {
        this._ebean_intercept.preGetter(9);
        return this.notificationActive;
    }

    protected /* synthetic */ void _ebean_set_notificationActive(boolean newValue) {
        this._ebean_intercept.preSetter(true, 9, this._ebean_get_notificationActive(), newValue);
        this.notificationActive = newValue;
    }

    protected /* synthetic */ boolean _ebean_getni_notificationActive() {
        return this.notificationActive;
    }

    protected /* synthetic */ void _ebean_setni_notificationActive(boolean _newValue) {
        this.notificationActive = _newValue;
        this._ebean_intercept.setLoadedProperty(9);
    }

    @Override
    public /* synthetic */ Object _ebean_getField(int index) {
        switch (index) {
            case 0: {
                return this._ebean_getni_id();
            }
            case 1: {
                return this._ebean_getni_user();
            }
            case 2: {
                return this._ebean_getni_fromDate();
            }
            case 3: {
                return this._ebean_getni_toDate();
            }
            case 4: {
                return this._ebean_getni_dateComparator();
            }
            case 5: {
                return this._ebean_getni_orderType();
            }
            case 6: {
                return this._ebean_getni_orderTypeComparator();
            }
            case 7: {
                return this._ebean_getni_bank();
            }
            case 8: {
                return this._ebean_getni_bankComparator();
            }
            case 9: {
                return this.notificationActive;
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    @Override
    public /* synthetic */ Object _ebean_getFieldIntercept(int index) {
        switch (index) {
            case 0: {
                return this._ebean_get_id();
            }
            case 1: {
                return this._ebean_get_user();
            }
            case 2: {
                return this._ebean_get_fromDate();
            }
            case 3: {
                return this._ebean_get_toDate();
            }
            case 4: {
                return this._ebean_get_dateComparator();
            }
            case 5: {
                return this._ebean_get_orderType();
            }
            case 6: {
                return this._ebean_get_orderTypeComparator();
            }
            case 7: {
                return this._ebean_get_bank();
            }
            case 8: {
                return this._ebean_get_bankComparator();
            }
            case 9: {
                return this._ebean_get_notificationActive();
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    @Override
    public /* synthetic */ void _ebean_setField(int index, Object o) {
        switch (index) {
            case 0: {
                this._ebean_setni_id((Integer)o);
                return;
            }
            case 1: {
                this._ebean_setni_user((User)o);
                return;
            }
            case 2: {
                this._ebean_setni_fromDate((Date)o);
                return;
            }
            case 3: {
                this._ebean_setni_toDate((Date)o);
                return;
            }
            case 4: {
                this._ebean_setni_dateComparator((FilterComparator.Date)((Object)o));
                return;
            }
            case 5: {
                this._ebean_setni_orderType((String)o);
                return;
            }
            case 6: {
                this._ebean_setni_orderTypeComparator((FilterComparator.Text)((Object)o));
                return;
            }
            case 7: {
                this._ebean_setni_bank((BankSettings)o);
                return;
            }
            case 8: {
                this._ebean_setni_bankComparator((FilterComparator.Bank)((Object)o));
                return;
            }
            case 9: {
                this._ebean_setni_notificationActive((Boolean)o);
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    @Override
    public /* synthetic */ void _ebean_setFieldIntercept(int index, Object o) {
        switch (index) {
            case 0: {
                this._ebean_set_id((Integer)o);
                return;
            }
            case 1: {
                this._ebean_set_user((User)o);
                return;
            }
            case 2: {
                this._ebean_set_fromDate((Date)o);
                return;
            }
            case 3: {
                this._ebean_set_toDate((Date)o);
                return;
            }
            case 4: {
                this._ebean_set_dateComparator((FilterComparator.Date)((Object)o));
                return;
            }
            case 5: {
                this._ebean_set_orderType((String)o);
                return;
            }
            case 6: {
                this._ebean_set_orderTypeComparator((FilterComparator.Text)((Object)o));
                return;
            }
            case 7: {
                this._ebean_set_bank((BankSettings)o);
                return;
            }
            case 8: {
                this._ebean_set_bankComparator((FilterComparator.Bank)((Object)o));
                return;
            }
            case 9: {
                this._ebean_set_notificationActive((Boolean)o);
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    @Override
    public /* synthetic */ void _ebean_setEmbeddedLoaded() {
    }

    @Override
    public /* synthetic */ boolean _ebean_isEmbeddedNewOrDirty() {
        return false;
    }

    @Override
    public /* synthetic */ Object _ebean_newInstance() {
        return new NotificationFilter();
    }
}

