/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.database.vo;

import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.NotificationPmtInf;
import de.businesslogics.banking.database.vo.NotificationTrx;
import de.businesslogics.banking.database.vo.PaymentTransferType;
import de.businesslogics.banking.database.vo.Send;
import de.businesslogics.banking.database.vo.SignedPayment;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.banking.database.vo.WorkspaceFile;
import de.businesslogics.util.StringUtils;
import io.ebean.Expr;
import io.ebean.Expression;
import io.ebean.Query;
import io.ebean.SqlUpdate;
import io.ebean.bean.EntityBean;
import io.ebean.bean.EntityBeanIntercept;
import io.ebean.common.BeanList;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;

@Entity
public class Notification
implements EntityBean {
    private static final Type[] protocolTypes;
    @Id
    private Integer id;
    @ManyToOne
    @Column(nullable=false)
    private BankSettings bank;
    @Column(nullable=false)
    private Timestamp fetched;
    @Column(nullable=false)
    private Type type;
    @ManyToOne
    private WorkspaceFile file;
    private String fileType;
    @Column(length=3)
    private String orderType;
    @ManyToOne
    private Send send;
    private String orderInfo;
    @Column(length=35)
    private String orgnlMsgId;
    private String orgnlMsgNmId;
    private Integer orgnlNbOfTxs;
    @Column(precision=38, scale=3)
    private BigDecimal orgnlCtrlSum;
    @Column(length=4)
    private String grpSts;
    private Integer nbOfRjct;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="notification")
    private List<NotificationPmtInf> paymentInformations;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="notification")
    private List<NotificationTrx> transactions;
    public static /* synthetic */ String[] _ebean_props;
    protected /* synthetic */ EntityBeanIntercept _ebean_intercept;
    protected transient /* synthetic */ Object _ebean_identity;

    public Notification() {
        this._ebean_intercept = new EntityBeanIntercept((Object)this);
    }

    public static Query<Notification> getNotificationQuery(User user) {
        return DB.find(Notification.class).where(Expr.in((String)"bank", BankSettings.findBanksForUser(user))).order("fetched DESC");
    }

    public static Query<Notification> getNotificationQuery(Send send) {
        return DB.find(Notification.class).where().eq("send", (Object)send).order("fetched DESC").query();
    }

    public static List<Notification> getNotifications(Send send) {
        return DB.find(Notification.class).where().eq("send", (Object)send).order("fetched DESC").findList();
    }

    public static int getNotificationCount(Send send) {
        return Notification.getNotificationQuery(send).findCount();
    }

    public static Query<Notification> getVopNotificationQuery(Send send) {
        return DB.find(Notification.class).where().eq("send", (Object)send).eq("type", (Object)Type.Pain002Vop).order("fetched DESC").query();
    }

    public static List<Notification> getVopNotifications(Send send) {
        return DB.find(Notification.class).where().eq("send", (Object)send).eq("type", (Object)Type.Pain002Vop).order("fetched DESC").findList();
    }

    public static int getVopNotificationCount(Send send) {
        return Notification.getVopNotificationQuery(send).findCount();
    }

    public static Query<Notification> getNonVopNotificationQuery(Send send) {
        return DB.find(Notification.class).where().eq("send", (Object)send).ne("type", (Object)Type.Pain002Vop).order("fetched DESC").query();
    }

    public static List<Notification> getNonVopNotifications(Send send) {
        return DB.find(Notification.class).where().eq("send", (Object)send).ne("type", (Object)Type.Pain002Vop).order("fetched DESC").findList();
    }

    public static int getNonVopNotificationCount(Send send) {
        return Notification.getNonVopNotificationQuery(send).findCount();
    }

    private static Type getPain002NotificationType(PaymentTransferType.PmtType pmtType) {
        if (pmtType == null) {
            return null;
        }
        if (PaymentTransferType.FormatType.pain008.equals((Object)pmtType.getFormatType())) {
            return Type.Pain002Debit;
        }
        if (PaymentTransferType.FormatType.pain001.equals((Object)pmtType.getFormatType())) {
            if (PaymentTransferType.PmtType.SEPA_INSTANT_TRANSFER.equals((Object)pmtType)) {
                return Type.Pain002Inst;
            }
            return Type.Pain002Credit;
        }
        return null;
    }

    public static Notification findNewestSEPANotification(Send send) {
        return (Notification)Notification.getSEPANonVopNotificationQuery(send).setMaxRows(1).findOne();
    }

    public static List<Notification> getSEPANotifications(Send send) {
        return Notification.getSEPANotificationQuery(send).findList();
    }

    public static List<Notification> getSEPANonVopNotifications(Send send) {
        return Notification.getSEPANonVopNotificationQuery(send).findList();
    }

    public static List<Notification> getSEPAVopNotifications(Send send) {
        return Notification.getSEPAVopNotificationQuery(send).findList();
    }

    public static Query<Notification> getSEPANotificationQuery(Send send) {
        Expression expr = Expr.not((Expression)Expr.in((String)"type", (Object[])protocolTypes));
        return DB.find(Notification.class).where().eq("send", (Object)send).add(expr).order("fetched DESC").query();
    }

    public static Query<Notification> getSEPANonVopNotificationQuery(Send send) {
        Expression expr = Expr.and((Expression)Expr.not((Expression)Expr.in((String)"type", (Object[])protocolTypes)), (Expression)Expr.ne((String)"type", (Object)((Object)Type.Pain002Vop)));
        return DB.find(Notification.class).where().eq("send", (Object)send).add(expr).order("fetched DESC").query();
    }

    public static Query<Notification> getSEPAVopNotificationQuery(Send send) {
        Expression expr = Expr.eq((String)"type", (Object)((Object)Type.Pain002Vop));
        return DB.find(Notification.class).where().eq("send", (Object)send).add(expr).order("fetched DESC").query();
    }

    public static List<Notification> findNonAssignedCamt029Notifications(Timestamp from) {
        return DB.find(Notification.class).where().isNull("send").eq("type", (Object)Type.Camt029).ge("fetched", (Object)from).order("fetched DESC").findList();
    }

    public static Notification findNewestCamt029Notification(SignedPayment signedPayment) {
        return (Notification)DB.find(Notification.class).where().eq("type", (Object)Type.Camt029).eq("transactions.signedPayment", (Object)signedPayment).orderBy("fetched DESC").setMaxRows(1).findOne();
    }

    public static List<Notification> findPain002Notifications(Send send, boolean descending) {
        Type pain002Type = Notification.getPain002NotificationType(send.getPmtType());
        if (pain002Type != null) {
            if (descending) {
                return DB.find(Notification.class).where().eq("type", (Object)pain002Type).eq("send", (Object)send).orderBy("fetched DESC").findList();
            }
            return DB.find(Notification.class).where().eq("send", (Object)send).eq("type", (Object)pain002Type).order("fetched ASC").findList();
        }
        return null;
    }

    public static List<Notification> findPain002VopNotifications(Send send, boolean descending) {
        if (descending) {
            return DB.find(Notification.class).where().eq("type", (Object)Type.Pain002Vop).eq("send", (Object)send).orderBy("fetched DESC").findList();
        }
        return DB.find(Notification.class).where().eq("send", (Object)send).eq("type", (Object)Type.Pain002Vop).order("fetched ASC").findList();
    }

    public static Notification findNewestPain002Notification(SignedPayment signedPayment) {
        Type pain002Type = Notification.getPain002NotificationType(signedPayment.getPmtType());
        return Notification.findNewestPain002Notification(signedPayment, pain002Type);
    }

    public static Notification findNewestPain002VopNotification(SignedPayment signedPayment) {
        return Notification.findNewestPain002Notification(signedPayment, Type.Pain002Vop);
    }

    private static Notification findNewestPain002Notification(SignedPayment signedPayment, Type pain002Type) {
        if (pain002Type != null) {
            Notification newestTrxNotification = Notification.findNewestTrxNotification(pain002Type, signedPayment);
            Notification newestPmtInfNotification = Notification.findNewestPmtInfNotification(pain002Type, signedPayment.getSend(), signedPayment.getPmtInfId());
            Notification newestGrpNotification = Notification.findNewestGroupNotification(pain002Type, signedPayment.getSend());
            Notification newestNotification = null;
            if (newestTrxNotification != null) {
                newestNotification = newestTrxNotification;
            }
            if (newestPmtInfNotification != null && (newestNotification == null || newestPmtInfNotification.getFetched().after(newestNotification.getFetched()))) {
                newestNotification = newestPmtInfNotification;
            }
            if (newestGrpNotification != null && (newestNotification == null || newestGrpNotification.getFetched().after(newestNotification.getFetched()))) {
                newestNotification = newestGrpNotification;
            }
            return newestNotification;
        }
        return null;
    }

    private static Notification findNewestTrxNotification(Type pain002Type, SignedPayment signedPayment) {
        return (Notification)DB.find(Notification.class).where().eq("type", (Object)pain002Type).eq("transactions.signedPayment", (Object)signedPayment).orderBy("fetched DESC").setMaxRows(1).findOne();
    }

    private static Notification findNewestPmtInfNotification(Type pain002Type, Send send, String pmtInfId) {
        NotificationPmtInf pmtInf = NotificationPmtInf.findNewestWithoutTrx(pain002Type, send, pmtInfId);
        if (pmtInf != null) {
            return pmtInf.getNotification();
        }
        return null;
    }

    private static Notification findNewestGroupNotification(Type pain002Type, Send send) {
        List notifications = DB.find(Notification.class).where().eq("send", (Object)send).eq("type", (Object)pain002Type).orderBy("fetched DESC").findList();
        if (notifications.size() > 0) {
            for (Notification notification : notifications) {
                List<NotificationPmtInf> pmtInfs = NotificationPmtInf.find(notification);
                List<NotificationTrx> trxs = NotificationTrx.find(notification);
                if (pmtInfs.size() != 0 || trxs.size() != 0) continue;
                return notification;
            }
        }
        return null;
    }

    public static List<Notification> getNotifications(SignedPayment signedPayment) {
        String endToEndId = StringUtils.checkNullAndTrim(signedPayment.getReference());
        if (endToEndId.length() > 0) {
            return DB.find(Notification.class).where().eq("send", (Object)signedPayment.getSend()).eq("transactions.orgnlEndToEndId", (Object)endToEndId).findList();
        }
        return null;
    }

    public static int getNotificationCount(SignedPayment signedPayment) {
        String endToEndId = StringUtils.checkNullAndTrim(signedPayment.getReference());
        if (endToEndId.length() > 0) {
            return DB.find(Notification.class).where().eq("send", (Object)signedPayment.getSend()).eq("transactions.orgnlEndToEndId", (Object)endToEndId).findCount();
        }
        return 0;
    }

    public static List<Notification> getVopNotifications(SignedPayment signedPayment) {
        String endToEndId = StringUtils.checkNullAndTrim(signedPayment.getReference());
        if (endToEndId.length() > 0) {
            return DB.find(Notification.class).where().eq("send", (Object)signedPayment.getSend()).eq("transactions.orgnlEndToEndId", (Object)endToEndId).eq("type", (Object)Type.Pain002Vop).findList();
        }
        return null;
    }

    public static int getVopNotificationCount(SignedPayment signedPayment) {
        String endToEndId = StringUtils.checkNullAndTrim(signedPayment.getReference());
        if (endToEndId.length() > 0) {
            return DB.find(Notification.class).where().eq("send", (Object)signedPayment.getSend()).eq("transactions.orgnlEndToEndId", (Object)endToEndId).eq("type", (Object)Type.Pain002Vop).findCount();
        }
        return 0;
    }

    public static List<Notification> getNonVopNotifications(SignedPayment signedPayment) {
        String endToEndId = StringUtils.checkNullAndTrim(signedPayment.getReference());
        if (endToEndId.length() > 0) {
            return DB.find(Notification.class).where().eq("send", (Object)signedPayment.getSend()).eq("transactions.orgnlEndToEndId", (Object)endToEndId).ne("type", (Object)Type.Pain002Vop).findList();
        }
        return null;
    }

    public static int getNonVopNotificationCount(SignedPayment signedPayment) {
        String endToEndId = StringUtils.checkNullAndTrim(signedPayment.getReference());
        if (endToEndId.length() > 0) {
            return DB.find(Notification.class).where().eq("send", (Object)signedPayment.getSend()).eq("transactions.orgnlEndToEndId", (Object)endToEndId).ne("type", (Object)Type.Pain002Vop).findCount();
        }
        return 0;
    }

    public static boolean exists(BankSettings bank, String hash) {
        return DB.find(Notification.class).where().and(Expr.eq((String)"file.md5Hash", (Object)hash), Expr.eq((String)"bank", (Object)bank)).findCount() != 0;
    }

    public static int countByBank(BankSettings bank) {
        return DB.find(Notification.class).where().eq("bank", (Object)bank).findCount();
    }

    public static int deleteByBank(BankSettings bank) {
        SqlUpdate delete = DB.sqlUpdate("DELETE FROM notification_trx WHERE notification_id in (SELECT id from notification where bank_id=:id)");
        delete.setParameter("id", (Object)bank.getBankId());
        delete.execute();
        delete = DB.sqlUpdate("DELETE FROM notification_pmt_inf WHERE notification_id in (SELECT id from notification where bank_id=:id)");
        delete.setParameter("id", (Object)bank.getBankId());
        delete.execute();
        delete = DB.sqlUpdate("DELETE FROM notification WHERE bank_id=:id");
        delete.setParameter("id", (Object)bank.getBankId());
        return delete.execute();
    }

    public Integer getId() {
        return this._ebean_get_id();
    }

    public void setId(Integer id) {
        this._ebean_set_id(id);
    }

    public BankSettings getBank() {
        return this._ebean_get_bank();
    }

    public void setBank(BankSettings bank) {
        this._ebean_set_bank(bank);
    }

    public Timestamp getFetched() {
        return this._ebean_get_fetched();
    }

    public void setFetched(Timestamp fetched) {
        this._ebean_set_fetched(fetched);
    }

    public Type getType() {
        return this._ebean_get_type();
    }

    public void setType(Type type) {
        this._ebean_set_type(type);
    }

    public WorkspaceFile getFile() {
        return this._ebean_get_file();
    }

    public void setFile(WorkspaceFile file) {
        this._ebean_set_file(file);
    }

    public Long getSize() {
        if (this.getFile() == null) {
            return null;
        }
        return this.getFile().getSize();
    }

    public String getFileType() {
        return this._ebean_get_fileType();
    }

    public void setFileType(String fileType) {
        this._ebean_set_fileType(fileType);
    }

    public String getOrderType() {
        return this._ebean_get_orderType();
    }

    public void setOrderType(String orderType) {
        this._ebean_set_orderType(orderType);
    }

    public String getFetchType() {
        if (this._ebean_get_fileType() != null) {
            return this._ebean_get_fileType();
        }
        return this._ebean_get_orderType();
    }

    public void save() {
        if (this._ebean_get_id() == null) {
            DB.save(this);
        } else {
            DB.update(this);
        }
    }

    public void delete() {
        if (this._ebean_get_id() == null) {
            return;
        }
        SqlUpdate delete = DB.sqlUpdate("DELETE FROM notification_trx WHERE notification_id=:id");
        delete.setParameter("id", (Object)this._ebean_get_id());
        delete.execute();
        delete = DB.sqlUpdate("DELETE FROM notification_pmt_inf WHERE notification_id=:id");
        delete.setParameter("id", (Object)this._ebean_get_id());
        delete.execute();
        DB.delete(this);
    }

    public Send getSend() {
        return this._ebean_get_send();
    }

    public void setSend(Send send) {
        this._ebean_set_send(send);
    }

    public String getOrgnlMsgId() {
        return this._ebean_get_orgnlMsgId();
    }

    public void setOrgnlMsgId(String orgnlMsgId) {
        this._ebean_set_orgnlMsgId(orgnlMsgId);
    }

    public String getOrgnlMsgNmId() {
        return this._ebean_get_orgnlMsgNmId();
    }

    public void setOrgnlMsgNmId(String orgnlMsgNmId) {
        this._ebean_set_orgnlMsgNmId(orgnlMsgNmId);
    }

    public Integer getOrgnlNbOfTxs() {
        return this._ebean_get_orgnlNbOfTxs();
    }

    public void setOrgnlNbOfTxs(Integer orgnlNbOfTxs) {
        this._ebean_set_orgnlNbOfTxs(orgnlNbOfTxs);
    }

    public BigDecimal getOrgnlCtrlSum() {
        return this._ebean_get_orgnlCtrlSum();
    }

    public void setOrgnlCtrlSum(BigDecimal orgnlCtrlSum) {
        this._ebean_set_orgnlCtrlSum(orgnlCtrlSum);
    }

    public String getGrpSts() {
        return this._ebean_get_grpSts();
    }

    public void setGrpSts(String grpSts) {
        this._ebean_set_grpSts(grpSts);
    }

    public boolean isAdditionalInfoFromHAC() {
        return Type.HAC.equals((Object)this.getType()) && this.getOrderInfo().startsWith("HAC.");
    }

    public boolean isAdditionalInfoFromPTK() {
        return Type.PTK.equals((Object)this.getType()) && this.getOrderInfo().startsWith("PTK.");
    }

    public boolean isErrorNotificationFromHAC() {
        return Type.HAC.equals((Object)this.getType()) && this.getOrderInfo().startsWith("SEND.");
    }

    public boolean isErrorNotificationFromPTK() {
        return Type.PTK.equals((Object)this.getType()) && this.getOrderInfo().startsWith("SEND.");
    }

    public String getOrderInfo() {
        return this._ebean_get_orderInfo();
    }

    public void setOrderInfo(String orderInfo) {
        this._ebean_set_orderInfo(orderInfo);
    }

    public boolean isProtocolType() {
        switch (this._ebean_get_type().ordinal()) {
            case 1: 
            case 2: {
                return true;
            }
        }
        return false;
    }

    public Integer getNbOfRjct() {
        return this._ebean_get_nbOfRjct();
    }

    public void setNbOfRjct(Integer nbOfRjct) {
        this._ebean_set_nbOfRjct(nbOfRjct);
    }

    static {
        _ebean_props = new String[]{"id", "bank", "fetched", "type", "file", "fileType", "orderType", "send", "orderInfo", "orgnlMsgId", "orgnlMsgNmId", "orgnlNbOfTxs", "orgnlCtrlSum", "grpSts", "nbOfRjct", "paymentInformations", "transactions"};
        protocolTypes = new Type[]{Type.PTK, Type.HAC};
    }

    public /* synthetic */ String[] _ebean_getPropertyNames() {
        return _ebean_props;
    }

    public /* synthetic */ String _ebean_getPropertyName(int pos) {
        return _ebean_props[pos];
    }

    public /* synthetic */ EntityBeanIntercept _ebean_getIntercept() {
        return this._ebean_intercept;
    }

    public /* synthetic */ EntityBeanIntercept _ebean_intercept() {
        if (this._ebean_intercept == null) {
            this._ebean_intercept = new EntityBeanIntercept((Object)this);
        }
        return this._ebean_intercept;
    }

    protected /* synthetic */ Integer _ebean_get_id() {
        this._ebean_intercept.preGetId();
        return this.id;
    }

    protected /* synthetic */ void _ebean_set_id(Integer newValue) {
        this._ebean_intercept.preSetter(false, 0, (Object)this.id, (Object)newValue);
        this.id = newValue;
    }

    protected /* synthetic */ Integer _ebean_getni_id() {
        return this.id;
    }

    protected /* synthetic */ void _ebean_setni_id(Integer _newValue) {
        this.id = _newValue;
        this._ebean_intercept.setLoadedProperty(0);
    }

    protected /* synthetic */ BankSettings _ebean_get_bank() {
        this._ebean_intercept.preGetter(1);
        return this.bank;
    }

    protected /* synthetic */ void _ebean_set_bank(BankSettings newValue) {
        this._ebean_intercept.preSetter(true, 1, (Object)this._ebean_get_bank(), (Object)newValue);
        this.bank = newValue;
    }

    protected /* synthetic */ BankSettings _ebean_getni_bank() {
        return this.bank;
    }

    protected /* synthetic */ void _ebean_setni_bank(BankSettings _newValue) {
        this.bank = _newValue;
        this._ebean_intercept.setLoadedProperty(1);
    }

    protected /* synthetic */ Timestamp _ebean_get_fetched() {
        this._ebean_intercept.preGetter(2);
        return this.fetched;
    }

    protected /* synthetic */ void _ebean_set_fetched(Timestamp newValue) {
        this._ebean_intercept.preSetter(true, 2, (Object)this._ebean_get_fetched(), (Object)newValue);
        this.fetched = newValue;
    }

    protected /* synthetic */ Timestamp _ebean_getni_fetched() {
        return this.fetched;
    }

    protected /* synthetic */ void _ebean_setni_fetched(Timestamp _newValue) {
        this.fetched = _newValue;
        this._ebean_intercept.setLoadedProperty(2);
    }

    protected /* synthetic */ Type _ebean_get_type() {
        this._ebean_intercept.preGetter(3);
        return this.type;
    }

    protected /* synthetic */ void _ebean_set_type(Type newValue) {
        this._ebean_intercept.preSetter(true, 3, (Object)this._ebean_get_type(), (Object)newValue);
        this.type = newValue;
    }

    protected /* synthetic */ Type _ebean_getni_type() {
        return this.type;
    }

    protected /* synthetic */ void _ebean_setni_type(Type _newValue) {
        this.type = _newValue;
        this._ebean_intercept.setLoadedProperty(3);
    }

    protected /* synthetic */ WorkspaceFile _ebean_get_file() {
        this._ebean_intercept.preGetter(4);
        return this.file;
    }

    protected /* synthetic */ void _ebean_set_file(WorkspaceFile newValue) {
        this._ebean_intercept.preSetter(true, 4, (Object)this._ebean_get_file(), (Object)newValue);
        this.file = newValue;
    }

    protected /* synthetic */ WorkspaceFile _ebean_getni_file() {
        return this.file;
    }

    protected /* synthetic */ void _ebean_setni_file(WorkspaceFile _newValue) {
        this.file = _newValue;
        this._ebean_intercept.setLoadedProperty(4);
    }

    protected /* synthetic */ String _ebean_get_fileType() {
        this._ebean_intercept.preGetter(5);
        return this.fileType;
    }

    protected /* synthetic */ void _ebean_set_fileType(String newValue) {
        this._ebean_intercept.preSetter(true, 5, (Object)this._ebean_get_fileType(), (Object)newValue);
        this.fileType = newValue;
    }

    protected /* synthetic */ String _ebean_getni_fileType() {
        return this.fileType;
    }

    protected /* synthetic */ void _ebean_setni_fileType(String _newValue) {
        this.fileType = _newValue;
        this._ebean_intercept.setLoadedProperty(5);
    }

    protected /* synthetic */ String _ebean_get_orderType() {
        this._ebean_intercept.preGetter(6);
        return this.orderType;
    }

    protected /* synthetic */ void _ebean_set_orderType(String newValue) {
        this._ebean_intercept.preSetter(true, 6, (Object)this._ebean_get_orderType(), (Object)newValue);
        this.orderType = newValue;
    }

    protected /* synthetic */ String _ebean_getni_orderType() {
        return this.orderType;
    }

    protected /* synthetic */ void _ebean_setni_orderType(String _newValue) {
        this.orderType = _newValue;
        this._ebean_intercept.setLoadedProperty(6);
    }

    protected /* synthetic */ Send _ebean_get_send() {
        this._ebean_intercept.preGetter(7);
        return this.send;
    }

    protected /* synthetic */ void _ebean_set_send(Send newValue) {
        this._ebean_intercept.preSetter(true, 7, (Object)this._ebean_get_send(), (Object)newValue);
        this.send = newValue;
    }

    protected /* synthetic */ Send _ebean_getni_send() {
        return this.send;
    }

    protected /* synthetic */ void _ebean_setni_send(Send _newValue) {
        this.send = _newValue;
        this._ebean_intercept.setLoadedProperty(7);
    }

    protected /* synthetic */ String _ebean_get_orderInfo() {
        this._ebean_intercept.preGetter(8);
        return this.orderInfo;
    }

    protected /* synthetic */ void _ebean_set_orderInfo(String newValue) {
        this._ebean_intercept.preSetter(true, 8, (Object)this._ebean_get_orderInfo(), (Object)newValue);
        this.orderInfo = newValue;
    }

    protected /* synthetic */ String _ebean_getni_orderInfo() {
        return this.orderInfo;
    }

    protected /* synthetic */ void _ebean_setni_orderInfo(String _newValue) {
        this.orderInfo = _newValue;
        this._ebean_intercept.setLoadedProperty(8);
    }

    protected /* synthetic */ String _ebean_get_orgnlMsgId() {
        this._ebean_intercept.preGetter(9);
        return this.orgnlMsgId;
    }

    protected /* synthetic */ void _ebean_set_orgnlMsgId(String newValue) {
        this._ebean_intercept.preSetter(true, 9, (Object)this._ebean_get_orgnlMsgId(), (Object)newValue);
        this.orgnlMsgId = newValue;
    }

    protected /* synthetic */ String _ebean_getni_orgnlMsgId() {
        return this.orgnlMsgId;
    }

    protected /* synthetic */ void _ebean_setni_orgnlMsgId(String _newValue) {
        this.orgnlMsgId = _newValue;
        this._ebean_intercept.setLoadedProperty(9);
    }

    protected /* synthetic */ String _ebean_get_orgnlMsgNmId() {
        this._ebean_intercept.preGetter(10);
        return this.orgnlMsgNmId;
    }

    protected /* synthetic */ void _ebean_set_orgnlMsgNmId(String newValue) {
        this._ebean_intercept.preSetter(true, 10, (Object)this._ebean_get_orgnlMsgNmId(), (Object)newValue);
        this.orgnlMsgNmId = newValue;
    }

    protected /* synthetic */ String _ebean_getni_orgnlMsgNmId() {
        return this.orgnlMsgNmId;
    }

    protected /* synthetic */ void _ebean_setni_orgnlMsgNmId(String _newValue) {
        this.orgnlMsgNmId = _newValue;
        this._ebean_intercept.setLoadedProperty(10);
    }

    protected /* synthetic */ Integer _ebean_get_orgnlNbOfTxs() {
        this._ebean_intercept.preGetter(11);
        return this.orgnlNbOfTxs;
    }

    protected /* synthetic */ void _ebean_set_orgnlNbOfTxs(Integer newValue) {
        this._ebean_intercept.preSetter(true, 11, (Object)this._ebean_get_orgnlNbOfTxs(), (Object)newValue);
        this.orgnlNbOfTxs = newValue;
    }

    protected /* synthetic */ Integer _ebean_getni_orgnlNbOfTxs() {
        return this.orgnlNbOfTxs;
    }

    protected /* synthetic */ void _ebean_setni_orgnlNbOfTxs(Integer _newValue) {
        this.orgnlNbOfTxs = _newValue;
        this._ebean_intercept.setLoadedProperty(11);
    }

    protected /* synthetic */ BigDecimal _ebean_get_orgnlCtrlSum() {
        this._ebean_intercept.preGetter(12);
        return this.orgnlCtrlSum;
    }

    protected /* synthetic */ void _ebean_set_orgnlCtrlSum(BigDecimal newValue) {
        this._ebean_intercept.preSetter(true, 12, (Object)this._ebean_get_orgnlCtrlSum(), (Object)newValue);
        this.orgnlCtrlSum = newValue;
    }

    protected /* synthetic */ BigDecimal _ebean_getni_orgnlCtrlSum() {
        return this.orgnlCtrlSum;
    }

    protected /* synthetic */ void _ebean_setni_orgnlCtrlSum(BigDecimal _newValue) {
        this.orgnlCtrlSum = _newValue;
        this._ebean_intercept.setLoadedProperty(12);
    }

    protected /* synthetic */ String _ebean_get_grpSts() {
        this._ebean_intercept.preGetter(13);
        return this.grpSts;
    }

    protected /* synthetic */ void _ebean_set_grpSts(String newValue) {
        this._ebean_intercept.preSetter(true, 13, (Object)this._ebean_get_grpSts(), (Object)newValue);
        this.grpSts = newValue;
    }

    protected /* synthetic */ String _ebean_getni_grpSts() {
        return this.grpSts;
    }

    protected /* synthetic */ void _ebean_setni_grpSts(String _newValue) {
        this.grpSts = _newValue;
        this._ebean_intercept.setLoadedProperty(13);
    }

    protected /* synthetic */ Integer _ebean_get_nbOfRjct() {
        this._ebean_intercept.preGetter(14);
        return this.nbOfRjct;
    }

    protected /* synthetic */ void _ebean_set_nbOfRjct(Integer newValue) {
        this._ebean_intercept.preSetter(true, 14, (Object)this._ebean_get_nbOfRjct(), (Object)newValue);
        this.nbOfRjct = newValue;
    }

    protected /* synthetic */ Integer _ebean_getni_nbOfRjct() {
        return this.nbOfRjct;
    }

    protected /* synthetic */ void _ebean_setni_nbOfRjct(Integer _newValue) {
        this.nbOfRjct = _newValue;
        this._ebean_intercept.setLoadedProperty(14);
    }

    protected /* synthetic */ List _ebean_get_paymentInformations() {
        this._ebean_intercept.preGetter(15);
        if (this.paymentInformations == null) {
            this.paymentInformations = new BeanList();
            this._ebean_intercept.initialisedMany(15);
        }
        return this.paymentInformations;
    }

    protected /* synthetic */ void _ebean_set_paymentInformations(List newValue) {
        this._ebean_intercept.preSetterMany(false, 15, this.paymentInformations, (Object)newValue);
        this.paymentInformations = newValue;
    }

    protected /* synthetic */ List _ebean_getni_paymentInformations() {
        return this.paymentInformations;
    }

    protected /* synthetic */ void _ebean_setni_paymentInformations(List _newValue) {
        this.paymentInformations = _newValue;
        this._ebean_intercept.setLoadedProperty(15);
    }

    protected /* synthetic */ List _ebean_get_transactions() {
        this._ebean_intercept.preGetter(16);
        if (this.transactions == null) {
            this.transactions = new BeanList();
            this._ebean_intercept.initialisedMany(16);
        }
        return this.transactions;
    }

    protected /* synthetic */ void _ebean_set_transactions(List newValue) {
        this._ebean_intercept.preSetterMany(false, 16, this.transactions, (Object)newValue);
        this.transactions = newValue;
    }

    protected /* synthetic */ List _ebean_getni_transactions() {
        return this.transactions;
    }

    protected /* synthetic */ void _ebean_setni_transactions(List _newValue) {
        this.transactions = _newValue;
        this._ebean_intercept.setLoadedProperty(16);
    }

    public /* synthetic */ Object _ebean_getField(int index) {
        switch (index) {
            case 0: {
                return this.id;
            }
            case 1: {
                return this.bank;
            }
            case 2: {
                return this.fetched;
            }
            case 3: {
                return this.type;
            }
            case 4: {
                return this.file;
            }
            case 5: {
                return this.fileType;
            }
            case 6: {
                return this.orderType;
            }
            case 7: {
                return this.send;
            }
            case 8: {
                return this.orderInfo;
            }
            case 9: {
                return this.orgnlMsgId;
            }
            case 10: {
                return this.orgnlMsgNmId;
            }
            case 11: {
                return this.orgnlNbOfTxs;
            }
            case 12: {
                return this.orgnlCtrlSum;
            }
            case 13: {
                return this.grpSts;
            }
            case 14: {
                return this.nbOfRjct;
            }
            case 15: {
                return this.paymentInformations;
            }
            case 16: {
                return this.transactions;
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    public /* synthetic */ Object _ebean_getFieldIntercept(int index) {
        switch (index) {
            case 0: {
                return this._ebean_get_id();
            }
            case 1: {
                return this._ebean_get_bank();
            }
            case 2: {
                return this._ebean_get_fetched();
            }
            case 3: {
                return this._ebean_get_type();
            }
            case 4: {
                return this._ebean_get_file();
            }
            case 5: {
                return this._ebean_get_fileType();
            }
            case 6: {
                return this._ebean_get_orderType();
            }
            case 7: {
                return this._ebean_get_send();
            }
            case 8: {
                return this._ebean_get_orderInfo();
            }
            case 9: {
                return this._ebean_get_orgnlMsgId();
            }
            case 10: {
                return this._ebean_get_orgnlMsgNmId();
            }
            case 11: {
                return this._ebean_get_orgnlNbOfTxs();
            }
            case 12: {
                return this._ebean_get_orgnlCtrlSum();
            }
            case 13: {
                return this._ebean_get_grpSts();
            }
            case 14: {
                return this._ebean_get_nbOfRjct();
            }
            case 15: {
                return this._ebean_get_paymentInformations();
            }
            case 16: {
                return this._ebean_get_transactions();
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    public /* synthetic */ void _ebean_setField(int index, Object o) {
        switch (index) {
            case 0: {
                this._ebean_setni_id((Integer)o);
                return;
            }
            case 1: {
                this._ebean_setni_bank((BankSettings)o);
                return;
            }
            case 2: {
                this._ebean_setni_fetched((Timestamp)o);
                return;
            }
            case 3: {
                this._ebean_setni_type((Type)((Object)o));
                return;
            }
            case 4: {
                this._ebean_setni_file((WorkspaceFile)o);
                return;
            }
            case 5: {
                this._ebean_setni_fileType((String)o);
                return;
            }
            case 6: {
                this._ebean_setni_orderType((String)o);
                return;
            }
            case 7: {
                this._ebean_setni_send((Send)o);
                return;
            }
            case 8: {
                this._ebean_setni_orderInfo((String)o);
                return;
            }
            case 9: {
                this._ebean_setni_orgnlMsgId((String)o);
                return;
            }
            case 10: {
                this._ebean_setni_orgnlMsgNmId((String)o);
                return;
            }
            case 11: {
                this._ebean_setni_orgnlNbOfTxs((Integer)o);
                return;
            }
            case 12: {
                this._ebean_setni_orgnlCtrlSum((BigDecimal)o);
                return;
            }
            case 13: {
                this._ebean_setni_grpSts((String)o);
                return;
            }
            case 14: {
                this._ebean_setni_nbOfRjct((Integer)o);
                return;
            }
            case 15: {
                this._ebean_setni_paymentInformations((List)o);
                return;
            }
            case 16: {
                this._ebean_setni_transactions((List)o);
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    public /* synthetic */ void _ebean_setFieldIntercept(int index, Object o) {
        switch (index) {
            case 0: {
                this._ebean_set_id((Integer)o);
                return;
            }
            case 1: {
                this._ebean_set_bank((BankSettings)o);
                return;
            }
            case 2: {
                this._ebean_set_fetched((Timestamp)o);
                return;
            }
            case 3: {
                this._ebean_set_type((Type)((Object)o));
                return;
            }
            case 4: {
                this._ebean_set_file((WorkspaceFile)o);
                return;
            }
            case 5: {
                this._ebean_set_fileType((String)o);
                return;
            }
            case 6: {
                this._ebean_set_orderType((String)o);
                return;
            }
            case 7: {
                this._ebean_set_send((Send)o);
                return;
            }
            case 8: {
                this._ebean_set_orderInfo((String)o);
                return;
            }
            case 9: {
                this._ebean_set_orgnlMsgId((String)o);
                return;
            }
            case 10: {
                this._ebean_set_orgnlMsgNmId((String)o);
                return;
            }
            case 11: {
                this._ebean_set_orgnlNbOfTxs((Integer)o);
                return;
            }
            case 12: {
                this._ebean_set_orgnlCtrlSum((BigDecimal)o);
                return;
            }
            case 13: {
                this._ebean_set_grpSts((String)o);
                return;
            }
            case 14: {
                this._ebean_set_nbOfRjct((Integer)o);
                return;
            }
            case 15: {
                this._ebean_set_paymentInformations((List)o);
                return;
            }
            case 16: {
                this._ebean_set_transactions((List)o);
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private /* synthetic */ Object _ebean_getIdentity() {
        Notification notification = this;
        synchronized (notification) {
            if (this._ebean_identity != null) {
                return this._ebean_identity;
            }
            Object tmpId = this._ebean_getField(0);
            this._ebean_identity = tmpId != null ? tmpId : new Object();
            return this._ebean_identity;
        }
    }

    public /* synthetic */ boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        return this._ebean_getIdentity().equals(((Notification)obj)._ebean_getIdentity());
    }

    public /* synthetic */ int hashCode() {
        return this._ebean_getIdentity().hashCode();
    }

    public /* synthetic */ void _ebean_setEmbeddedLoaded() {
    }

    public /* synthetic */ boolean _ebean_isEmbeddedNewOrDirty() {
        return false;
    }

    public /* synthetic */ Object _ebean_newInstance() {
        return new Notification();
    }

    public static enum Type {
        UNKNOWN("UNKNOWN"),
        PTK("PTK"),
        HAC("HAC"),
        M3("YM3"),
        M6("YM6"),
        M7("YM7"),
        M8("YM8"),
        M9("YM9"),
        Camt029("C29"),
        Pain002Credit("CRZ", true),
        Pain002Debit("CDZ", true),
        Pain002Inst("CIZ", true),
        Pain002Foreign("AXS", true),
        Pain002Vop("VPZ", true);

        private final String handlerKey;
        private final boolean isPain002Notification;

        private Type(String handlerKey) {
            this(handlerKey, false);
        }

        private Type(String handlerKey, boolean isPain002Notification) {
            this.handlerKey = handlerKey;
            this.isPain002Notification = isPain002Notification;
        }

        public String getHandlerKey() {
            return this.handlerKey;
        }

        public boolean isPain002Notification() {
            return this.isPain002Notification;
        }
    }
}

