/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.database.vo;

import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.User;
import io.ebean.Transaction;
import io.ebean.Update;
import io.ebean.bean.EntityBean;
import io.ebean.bean.EntityBeanIntercept;
import java.sql.Timestamp;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.ManyToOne;

@Entity
public class LoginSession
implements EntityBean {
    public static boolean ALLOW_MULTIPLE_LOGIN;
    @Id
    @Column(name="id", nullable=false)
    private Integer id;
    @ManyToOne(optional=false)
    @Column(nullable=false)
    private User user;
    @Column(nullable=false)
    private boolean active;
    @Column(nullable=false)
    private Timestamp sessionActivity;
    public static /* synthetic */ String[] _ebean_props;
    protected /* synthetic */ EntityBeanIntercept _ebean_intercept;
    protected transient /* synthetic */ Object _ebean_identity;

    public LoginSession() {
        this._ebean_intercept = new EntityBeanIntercept((Object)this);
        this._ebean_set_active(true);
    }

    public static LoginSession createSession(User user) {
        List openSessions = DB.find(LoginSession.class).where().eq("active", (Object)true).eq("user", (Object)user).findList();
        try (Transaction t = DB.beginTransaction();){
            if (!ALLOW_MULTIPLE_LOGIN) {
                for (LoginSession session : openSessions) {
                    session.setActive(false);
                    DB.update(session);
                }
            }
            LoginSession loginSession = new LoginSession();
            loginSession.user = user;
            loginSession.sessionActivity = new Timestamp(System.currentTimeMillis());
            DB.save(loginSession);
            t.commit();
            LoginSession loginSession2 = loginSession;
            return loginSession2;
        }
    }

    public static boolean updateSession(long id, long timeout) {
        LoginSession loginSession = (LoginSession)DB.find(LoginSession.class).where().eq("active", (Object)true).eq("id", (Object)id).ge("sessionActivity", (Object)new Timestamp(System.currentTimeMillis() - timeout)).findOne();
        if (loginSession == null) {
            return false;
        }
        loginSession.setSessionActivity(new Timestamp(System.currentTimeMillis()));
        DB.update(loginSession);
        return true;
    }

    public static void impersonateUser(long id, User impersonate) {
        LoginSession loginSession = (LoginSession)DB.find(LoginSession.class).where().eq("active", (Object)true).eq("id", (Object)id).findOne();
        loginSession.setUser(impersonate);
        DB.update(loginSession);
    }

    public static void closeSession(long id) {
        LoginSession loginSession = DB.find(LoginSession.class, id);
        if (loginSession != null) {
            loginSession.setActive(false);
            DB.update(loginSession);
        }
    }

    public static int closeSessionByUserId(long userId) {
        Update<LoginSession> update = DB.createUpdate(LoginSession.class, "UPDATE LoginSession set active=:false WHERE user_id=:user");
        update.setParameter("false", (Object)false);
        update.setParameter("user", (Object)userId);
        return update.execute();
    }

    public static int deleteByUser(User user) {
        Update<LoginSession> delete = DB.createUpdate(LoginSession.class, "DELETE FROM LoginSession WHERE user_id=:user");
        delete.setParameter("user", (Object)user.getId());
        return delete.execute();
    }

    public Integer getId() {
        return this._ebean_get_id();
    }

    public User getUser() {
        return this._ebean_get_user();
    }

    public void setUser(User user) {
        this._ebean_set_user(user);
    }

    public boolean isActive() {
        return this._ebean_get_active();
    }

    public void setActive(boolean active) {
        this._ebean_set_active(active);
    }

    public Timestamp getSessionActivity() {
        return this._ebean_get_sessionActivity();
    }

    public void setSessionActivity(Timestamp sessionActivity) {
        this._ebean_set_sessionActivity(sessionActivity);
    }

    static {
        _ebean_props = new String[]{"id", "user", "active", "sessionActivity"};
        ALLOW_MULTIPLE_LOGIN = false;
    }

    public /* synthetic */ String[] _ebean_getPropertyNames() {
        return _ebean_props;
    }

    public /* synthetic */ String _ebean_getPropertyName(int pos) {
        return _ebean_props[pos];
    }

    public /* synthetic */ EntityBeanIntercept _ebean_getIntercept() {
        return this._ebean_intercept;
    }

    public /* synthetic */ EntityBeanIntercept _ebean_intercept() {
        if (this._ebean_intercept == null) {
            this._ebean_intercept = new EntityBeanIntercept((Object)this);
        }
        return this._ebean_intercept;
    }

    protected /* synthetic */ Integer _ebean_get_id() {
        this._ebean_intercept.preGetId();
        return this.id;
    }

    protected /* synthetic */ void _ebean_set_id(Integer newValue) {
        this._ebean_intercept.preSetter(false, 0, (Object)this.id, (Object)newValue);
        this.id = newValue;
    }

    protected /* synthetic */ Integer _ebean_getni_id() {
        return this.id;
    }

    protected /* synthetic */ void _ebean_setni_id(Integer _newValue) {
        this.id = _newValue;
        this._ebean_intercept.setLoadedProperty(0);
    }

    protected /* synthetic */ User _ebean_get_user() {
        this._ebean_intercept.preGetter(1);
        return this.user;
    }

    protected /* synthetic */ void _ebean_set_user(User newValue) {
        this._ebean_intercept.preSetter(true, 1, (Object)this._ebean_get_user(), (Object)newValue);
        this.user = newValue;
    }

    protected /* synthetic */ User _ebean_getni_user() {
        return this.user;
    }

    protected /* synthetic */ void _ebean_setni_user(User _newValue) {
        this.user = _newValue;
        this._ebean_intercept.setLoadedProperty(1);
    }

    protected /* synthetic */ boolean _ebean_get_active() {
        this._ebean_intercept.preGetter(2);
        return this.active;
    }

    protected /* synthetic */ void _ebean_set_active(boolean newValue) {
        this._ebean_intercept.preSetter(true, 2, this._ebean_get_active(), newValue);
        this.active = newValue;
    }

    protected /* synthetic */ boolean _ebean_getni_active() {
        return this.active;
    }

    protected /* synthetic */ void _ebean_setni_active(boolean _newValue) {
        this.active = _newValue;
        this._ebean_intercept.setLoadedProperty(2);
    }

    protected /* synthetic */ Timestamp _ebean_get_sessionActivity() {
        this._ebean_intercept.preGetter(3);
        return this.sessionActivity;
    }

    protected /* synthetic */ void _ebean_set_sessionActivity(Timestamp newValue) {
        this._ebean_intercept.preSetter(true, 3, (Object)this._ebean_get_sessionActivity(), (Object)newValue);
        this.sessionActivity = newValue;
    }

    protected /* synthetic */ Timestamp _ebean_getni_sessionActivity() {
        return this.sessionActivity;
    }

    protected /* synthetic */ void _ebean_setni_sessionActivity(Timestamp _newValue) {
        this.sessionActivity = _newValue;
        this._ebean_intercept.setLoadedProperty(3);
    }

    public /* synthetic */ Object _ebean_getField(int index) {
        switch (index) {
            case 0: {
                return this.id;
            }
            case 1: {
                return this.user;
            }
            case 2: {
                return this.active;
            }
            case 3: {
                return this.sessionActivity;
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    public /* synthetic */ Object _ebean_getFieldIntercept(int index) {
        switch (index) {
            case 0: {
                return this._ebean_get_id();
            }
            case 1: {
                return this._ebean_get_user();
            }
            case 2: {
                return this._ebean_get_active();
            }
            case 3: {
                return this._ebean_get_sessionActivity();
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    public /* synthetic */ void _ebean_setField(int index, Object o) {
        switch (index) {
            case 0: {
                this._ebean_setni_id((Integer)o);
                return;
            }
            case 1: {
                this._ebean_setni_user((User)o);
                return;
            }
            case 2: {
                this._ebean_setni_active((Boolean)o);
                return;
            }
            case 3: {
                this._ebean_setni_sessionActivity((Timestamp)o);
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    public /* synthetic */ void _ebean_setFieldIntercept(int index, Object o) {
        switch (index) {
            case 0: {
                this._ebean_set_id((Integer)o);
                return;
            }
            case 1: {
                this._ebean_set_user((User)o);
                return;
            }
            case 2: {
                this._ebean_set_active((Boolean)o);
                return;
            }
            case 3: {
                this._ebean_set_sessionActivity((Timestamp)o);
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private /* synthetic */ Object _ebean_getIdentity() {
        LoginSession loginSession = this;
        synchronized (loginSession) {
            if (this._ebean_identity != null) {
                return this._ebean_identity;
            }
            Object tmpId = this._ebean_getField(0);
            this._ebean_identity = tmpId != null ? tmpId : new Object();
            return this._ebean_identity;
        }
    }

    public /* synthetic */ boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        return this._ebean_getIdentity().equals(((LoginSession)obj)._ebean_getIdentity());
    }

    public /* synthetic */ int hashCode() {
        return this._ebean_getIdentity().hashCode();
    }

    public /* synthetic */ void _ebean_setEmbeddedLoaded() {
    }

    public /* synthetic */ boolean _ebean_isEmbeddedNewOrDirty() {
        return false;
    }

    public /* synthetic */ Object _ebean_newInstance() {
        return new LoginSession();
    }
}

