/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.database.vo;

import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.FilterComparator;
import de.businesslogics.banking.database.vo.User;
import io.ebean.Expr;
import io.ebean.Expression;
import io.ebean.bean.EntityBean;
import io.ebean.bean.EntityBeanIntercept;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.OneToOne;
import javax.persistence.Table;

@Entity
@Table(name="log_filter")
public class LogFilter
implements EntityBean {
    @Id
    private Integer id;
    @OneToOne(optional=false)
    private User user;
    private Boolean active;
    private String type;
    private Integer accountId;
    private Integer filterUserId;
    @Column(name="from_date")
    private java.sql.Date fromDate;
    @Column(name="to_date")
    private java.sql.Date toDate;
    @Column(name="date_comp")
    private FilterComparator.Date dateCompator;
    public static /* synthetic */ String[] _ebean_props;
    protected /* synthetic */ EntityBeanIntercept _ebean_intercept;
    protected transient /* synthetic */ Object _ebean_identity;

    private LogFilter(User user) {
        this._ebean_intercept = new EntityBeanIntercept((Object)this);
        this._ebean_set_user(user);
    }

    public static LogFilter getFilter(User user) {
        LogFilter f = (LogFilter)DB.find(LogFilter.class).where().eq("user", (Object)user).findOne();
        if (f == null) {
            f = new LogFilter(user);
        }
        return f;
    }

    public static void deleteByUser(User user) {
        LogFilter toDelete = LogFilter.getFilter(user);
        if (toDelete.id != null) {
            DB.delete(toDelete);
        }
    }

    public User getUser() {
        return this._ebean_get_user();
    }

    public boolean isActive() {
        return this._ebean_get_active() != null && this._ebean_get_active() != false;
    }

    public void setActive(Boolean active) {
        this._ebean_set_active(active);
    }

    public String getType() {
        return this._ebean_get_type();
    }

    public void setType(String type) {
        this._ebean_set_type(type);
    }

    public Integer getAccountId() {
        return this._ebean_get_accountId();
    }

    public void setAccountId(Integer accountId) {
        this._ebean_set_accountId(accountId);
    }

    public Integer getFilterUserId() {
        return this._ebean_get_filterUserId();
    }

    public void setFilterUserId(Integer filterUserId) {
        this._ebean_set_filterUserId(filterUserId);
    }

    public java.sql.Date getFromDate() {
        return this._ebean_get_fromDate();
    }

    public void setFromDate(java.sql.Date fromDate) {
        if (fromDate == null) {
            this._ebean_set_fromDate(null);
        } else {
            this._ebean_set_fromDate(this.getDateAtTimeZero(fromDate));
        }
    }

    private java.sql.Date getDateAtTimeZero(java.sql.Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(14, 0);
        cal.set(13, 0);
        cal.set(12, 0);
        cal.set(11, 0);
        return new java.sql.Date(cal.getTimeInMillis());
    }

    public java.sql.Date getToDate() {
        return this._ebean_get_toDate();
    }

    public void setToDate(java.sql.Date toDate) {
        if (toDate == null) {
            this._ebean_set_toDate(null);
        } else {
            this._ebean_set_toDate(this.getDateAtTimeZero(toDate));
        }
    }

    public FilterComparator.Date getDateCompator() {
        return this._ebean_get_dateCompator();
    }

    public void setDateCompator(FilterComparator.Date dateCompator) {
        this._ebean_set_dateCompator(dateCompator);
    }

    public void setDateCompator(int dateCompatorId) {
        if (dateCompatorId >= 0 && dateCompatorId < FilterComparator.Date.values().length) {
            this._ebean_set_dateCompator(FilterComparator.Date.values()[dateCompatorId]);
        } else {
            this._ebean_set_dateCompator(null);
        }
    }

    public int getDateCompatorId() {
        if (this._ebean_get_dateCompator() != null) {
            return this._ebean_get_dateCompator().ordinal();
        }
        return -1;
    }

    public void save() {
        if (this._ebean_get_id() == null) {
            DB.save(this);
        } else {
            DB.update(this);
        }
    }

    public void reset() {
        this._ebean_set_active(false);
        this._ebean_set_type(null);
        this._ebean_set_accountId(null);
        this._ebean_set_filterUserId(null);
        this._ebean_set_fromDate(null);
        this._ebean_set_toDate(null);
        this._ebean_set_dateCompator(null);
        this.save();
    }

    public Expression getExpression() {
        Expression typeExpr = this._ebean_get_type() != null && !this._ebean_get_type().isEmpty() ? Expr.eq((String)"messageName", (Object)this._ebean_get_type()) : null;
        Expression accountExpr = this._ebean_get_accountId() != null ? Expr.eq((String)"account.id", (Object)this._ebean_get_accountId()) : null;
        Expression filterUserExpr = this._ebean_get_filterUserId() != null ? Expr.eq((String)"actor.id", (Object)this._ebean_get_filterUserId()) : null;
        Expression dateExpr = null;
        if (this._ebean_get_dateCompator() == FilterComparator.Date.EQUAL && this._ebean_get_fromDate() != null) {
            dateExpr = Expr.between((String)"logTime", (Object)this.getEarliestAtDay(this._ebean_get_fromDate()), (Object)this.getLatestAtDay(this._ebean_get_fromDate()));
        } else if (this._ebean_get_dateCompator() == FilterComparator.Date.GREATER && this._ebean_get_fromDate() != null) {
            dateExpr = Expr.gt((String)"logTime", (Object)this.getLatestAtDay(this._ebean_get_fromDate() != null ? this._ebean_get_fromDate() : this._ebean_get_toDate()));
        } else if (this._ebean_get_dateCompator() == FilterComparator.Date.BETWEEN && this._ebean_get_fromDate() != null && this._ebean_get_toDate() == null) {
            dateExpr = Expr.ge((String)"logTime", (Object)this.getEarliestAtDay(this._ebean_get_fromDate() != null ? this._ebean_get_fromDate() : this._ebean_get_toDate()));
        } else if (this._ebean_get_dateCompator() == FilterComparator.Date.LESS && this._ebean_get_fromDate() != null) {
            dateExpr = Expr.lt((String)"logTime", (Object)this.getEarliestAtDay(this._ebean_get_fromDate() != null ? this._ebean_get_fromDate() : this._ebean_get_toDate()));
        } else if (this._ebean_get_dateCompator() == FilterComparator.Date.BETWEEN && this._ebean_get_fromDate() == null && this._ebean_get_toDate() != null) {
            dateExpr = Expr.le((String)"logTime", (Object)this.getLatestAtDay(this._ebean_get_fromDate() != null ? this._ebean_get_fromDate() : this._ebean_get_toDate()));
        } else if (this._ebean_get_dateCompator() == FilterComparator.Date.BETWEEN && this._ebean_get_fromDate() != null && this._ebean_get_toDate() != null) {
            dateExpr = Expr.between((String)"logTime", (Object)this.getEarliestAtDay(this._ebean_get_fromDate()), (Object)this.getLatestAtDay(this._ebean_get_toDate()));
        }
        Expression toReturn = typeExpr;
        if (accountExpr != null) {
            toReturn = toReturn == null ? accountExpr : Expr.and((Expression)toReturn, (Expression)accountExpr);
        }
        if (filterUserExpr != null) {
            toReturn = toReturn == null ? filterUserExpr : Expr.and((Expression)toReturn, (Expression)filterUserExpr);
        }
        if (dateExpr != null) {
            toReturn = toReturn == null ? dateExpr : Expr.and((Expression)toReturn, (Expression)dateExpr);
        }
        return toReturn;
    }

    private Timestamp getEarliestAtDay(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(14, 0);
        cal.set(13, 0);
        cal.set(12, 0);
        cal.set(11, 0);
        return new Timestamp(cal.getTimeInMillis());
    }

    private Timestamp getLatestAtDay(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(14, 999);
        cal.set(13, 59);
        cal.set(12, 59);
        cal.set(11, 23);
        return new Timestamp(cal.getTimeInMillis());
    }

    static {
        _ebean_props = new String[]{"id", "user", "active", "type", "accountId", "filterUserId", "fromDate", "toDate", "dateCompator"};
    }

    public /* synthetic */ LogFilter() {
        this._ebean_intercept = new EntityBeanIntercept((Object)this);
    }

    public /* synthetic */ String[] _ebean_getPropertyNames() {
        return _ebean_props;
    }

    public /* synthetic */ String _ebean_getPropertyName(int pos) {
        return _ebean_props[pos];
    }

    public /* synthetic */ EntityBeanIntercept _ebean_getIntercept() {
        return this._ebean_intercept;
    }

    public /* synthetic */ EntityBeanIntercept _ebean_intercept() {
        if (this._ebean_intercept == null) {
            this._ebean_intercept = new EntityBeanIntercept((Object)this);
        }
        return this._ebean_intercept;
    }

    protected /* synthetic */ Integer _ebean_get_id() {
        this._ebean_intercept.preGetId();
        return this.id;
    }

    protected /* synthetic */ void _ebean_set_id(Integer newValue) {
        this._ebean_intercept.preSetter(false, 0, (Object)this.id, (Object)newValue);
        this.id = newValue;
    }

    protected /* synthetic */ Integer _ebean_getni_id() {
        return this.id;
    }

    protected /* synthetic */ void _ebean_setni_id(Integer _newValue) {
        this.id = _newValue;
        this._ebean_intercept.setLoadedProperty(0);
    }

    protected /* synthetic */ User _ebean_get_user() {
        this._ebean_intercept.preGetter(1);
        return this.user;
    }

    protected /* synthetic */ void _ebean_set_user(User newValue) {
        this._ebean_intercept.preSetter(true, 1, (Object)this._ebean_get_user(), (Object)newValue);
        this.user = newValue;
    }

    protected /* synthetic */ User _ebean_getni_user() {
        return this.user;
    }

    protected /* synthetic */ void _ebean_setni_user(User _newValue) {
        this.user = _newValue;
        this._ebean_intercept.setLoadedProperty(1);
    }

    protected /* synthetic */ Boolean _ebean_get_active() {
        this._ebean_intercept.preGetter(2);
        return this.active;
    }

    protected /* synthetic */ void _ebean_set_active(Boolean newValue) {
        this._ebean_intercept.preSetter(true, 2, (Object)this._ebean_get_active(), (Object)newValue);
        this.active = newValue;
    }

    protected /* synthetic */ Boolean _ebean_getni_active() {
        return this.active;
    }

    protected /* synthetic */ void _ebean_setni_active(Boolean _newValue) {
        this.active = _newValue;
        this._ebean_intercept.setLoadedProperty(2);
    }

    protected /* synthetic */ String _ebean_get_type() {
        this._ebean_intercept.preGetter(3);
        return this.type;
    }

    protected /* synthetic */ void _ebean_set_type(String newValue) {
        this._ebean_intercept.preSetter(true, 3, (Object)this._ebean_get_type(), (Object)newValue);
        this.type = newValue;
    }

    protected /* synthetic */ String _ebean_getni_type() {
        return this.type;
    }

    protected /* synthetic */ void _ebean_setni_type(String _newValue) {
        this.type = _newValue;
        this._ebean_intercept.setLoadedProperty(3);
    }

    protected /* synthetic */ Integer _ebean_get_accountId() {
        this._ebean_intercept.preGetter(4);
        return this.accountId;
    }

    protected /* synthetic */ void _ebean_set_accountId(Integer newValue) {
        this._ebean_intercept.preSetter(true, 4, (Object)this._ebean_get_accountId(), (Object)newValue);
        this.accountId = newValue;
    }

    protected /* synthetic */ Integer _ebean_getni_accountId() {
        return this.accountId;
    }

    protected /* synthetic */ void _ebean_setni_accountId(Integer _newValue) {
        this.accountId = _newValue;
        this._ebean_intercept.setLoadedProperty(4);
    }

    protected /* synthetic */ Integer _ebean_get_filterUserId() {
        this._ebean_intercept.preGetter(5);
        return this.filterUserId;
    }

    protected /* synthetic */ void _ebean_set_filterUserId(Integer newValue) {
        this._ebean_intercept.preSetter(true, 5, (Object)this._ebean_get_filterUserId(), (Object)newValue);
        this.filterUserId = newValue;
    }

    protected /* synthetic */ Integer _ebean_getni_filterUserId() {
        return this.filterUserId;
    }

    protected /* synthetic */ void _ebean_setni_filterUserId(Integer _newValue) {
        this.filterUserId = _newValue;
        this._ebean_intercept.setLoadedProperty(5);
    }

    protected /* synthetic */ java.sql.Date _ebean_get_fromDate() {
        this._ebean_intercept.preGetter(6);
        return this.fromDate;
    }

    protected /* synthetic */ void _ebean_set_fromDate(java.sql.Date newValue) {
        this._ebean_intercept.preSetter(true, 6, (Object)this._ebean_get_fromDate(), (Object)newValue);
        this.fromDate = newValue;
    }

    protected /* synthetic */ java.sql.Date _ebean_getni_fromDate() {
        return this.fromDate;
    }

    protected /* synthetic */ void _ebean_setni_fromDate(java.sql.Date _newValue) {
        this.fromDate = _newValue;
        this._ebean_intercept.setLoadedProperty(6);
    }

    protected /* synthetic */ java.sql.Date _ebean_get_toDate() {
        this._ebean_intercept.preGetter(7);
        return this.toDate;
    }

    protected /* synthetic */ void _ebean_set_toDate(java.sql.Date newValue) {
        this._ebean_intercept.preSetter(true, 7, (Object)this._ebean_get_toDate(), (Object)newValue);
        this.toDate = newValue;
    }

    protected /* synthetic */ java.sql.Date _ebean_getni_toDate() {
        return this.toDate;
    }

    protected /* synthetic */ void _ebean_setni_toDate(java.sql.Date _newValue) {
        this.toDate = _newValue;
        this._ebean_intercept.setLoadedProperty(7);
    }

    protected /* synthetic */ FilterComparator.Date _ebean_get_dateCompator() {
        this._ebean_intercept.preGetter(8);
        return this.dateCompator;
    }

    protected /* synthetic */ void _ebean_set_dateCompator(FilterComparator.Date newValue) {
        this._ebean_intercept.preSetter(true, 8, (Object)this._ebean_get_dateCompator(), (Object)newValue);
        this.dateCompator = newValue;
    }

    protected /* synthetic */ FilterComparator.Date _ebean_getni_dateCompator() {
        return this.dateCompator;
    }

    protected /* synthetic */ void _ebean_setni_dateCompator(FilterComparator.Date _newValue) {
        this.dateCompator = _newValue;
        this._ebean_intercept.setLoadedProperty(8);
    }

    public /* synthetic */ Object _ebean_getField(int index) {
        switch (index) {
            case 0: {
                return this.id;
            }
            case 1: {
                return this.user;
            }
            case 2: {
                return this.active;
            }
            case 3: {
                return this.type;
            }
            case 4: {
                return this.accountId;
            }
            case 5: {
                return this.filterUserId;
            }
            case 6: {
                return this.fromDate;
            }
            case 7: {
                return this.toDate;
            }
            case 8: {
                return this.dateCompator;
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    public /* synthetic */ Object _ebean_getFieldIntercept(int index) {
        switch (index) {
            case 0: {
                return this._ebean_get_id();
            }
            case 1: {
                return this._ebean_get_user();
            }
            case 2: {
                return this._ebean_get_active();
            }
            case 3: {
                return this._ebean_get_type();
            }
            case 4: {
                return this._ebean_get_accountId();
            }
            case 5: {
                return this._ebean_get_filterUserId();
            }
            case 6: {
                return this._ebean_get_fromDate();
            }
            case 7: {
                return this._ebean_get_toDate();
            }
            case 8: {
                return this._ebean_get_dateCompator();
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    public /* synthetic */ void _ebean_setField(int index, Object o) {
        switch (index) {
            case 0: {
                this._ebean_setni_id((Integer)o);
                return;
            }
            case 1: {
                this._ebean_setni_user((User)o);
                return;
            }
            case 2: {
                this._ebean_setni_active((Boolean)o);
                return;
            }
            case 3: {
                this._ebean_setni_type((String)o);
                return;
            }
            case 4: {
                this._ebean_setni_accountId((Integer)o);
                return;
            }
            case 5: {
                this._ebean_setni_filterUserId((Integer)o);
                return;
            }
            case 6: {
                this._ebean_setni_fromDate((java.sql.Date)o);
                return;
            }
            case 7: {
                this._ebean_setni_toDate((java.sql.Date)o);
                return;
            }
            case 8: {
                this._ebean_setni_dateCompator((FilterComparator.Date)((Object)o));
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    public /* synthetic */ void _ebean_setFieldIntercept(int index, Object o) {
        switch (index) {
            case 0: {
                this._ebean_set_id((Integer)o);
                return;
            }
            case 1: {
                this._ebean_set_user((User)o);
                return;
            }
            case 2: {
                this._ebean_set_active((Boolean)o);
                return;
            }
            case 3: {
                this._ebean_set_type((String)o);
                return;
            }
            case 4: {
                this._ebean_set_accountId((Integer)o);
                return;
            }
            case 5: {
                this._ebean_set_filterUserId((Integer)o);
                return;
            }
            case 6: {
                this._ebean_set_fromDate((java.sql.Date)o);
                return;
            }
            case 7: {
                this._ebean_set_toDate((java.sql.Date)o);
                return;
            }
            case 8: {
                this._ebean_set_dateCompator((FilterComparator.Date)((Object)o));
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private /* synthetic */ Object _ebean_getIdentity() {
        LogFilter logFilter = this;
        synchronized (logFilter) {
            if (this._ebean_identity != null) {
                return this._ebean_identity;
            }
            Object tmpId = this._ebean_getField(0);
            this._ebean_identity = tmpId != null ? tmpId : new Object();
            return this._ebean_identity;
        }
    }

    public /* synthetic */ boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        return this._ebean_getIdentity().equals(((LogFilter)obj)._ebean_getIdentity());
    }

    public /* synthetic */ int hashCode() {
        return this._ebean_getIdentity().hashCode();
    }

    public /* synthetic */ void _ebean_setEmbeddedLoaded() {
    }

    public /* synthetic */ boolean _ebean_isEmbeddedNewOrDirty() {
        return false;
    }

    public /* synthetic */ Object _ebean_newInstance() {
        return new LogFilter();
    }
}

