/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.database.vo;

import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.User;
import io.ebean.bean.EntityBean;
import io.ebean.bean.EntityBeanIntercept;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import javax.persistence.Basic;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.MappedSuperclass;
import javax.persistence.Transient;

@MappedSuperclass
public abstract class HistoryLog
implements EntityBean {
    protected static final Date MIGRATION_DATE;
    @Id
    private Integer id;
    protected Integer businessId;
    @ManyToOne(optional=false)
    protected User createdUser;
    @Basic(optional=false)
    protected Date created;
    @ManyToOne
    protected User confirmedUser;
    protected Date confirmed;
    @Basic(optional=false)
    protected Version version;
    @ManyToOne
    protected User lockingUser;
    protected boolean deleted;
    @Transient
    private boolean hasFourEyesChange;
    public static /* synthetic */ String[] _ebean_props;
    protected /* synthetic */ EntityBeanIntercept _ebean_intercept;
    protected transient /* synthetic */ Object _ebean_identity;

    public HistoryLog() {
        this._ebean_intercept = new EntityBeanIntercept((Object)this);
        this._ebean_set_version(Version.CURRENT);
        this._ebean_set_deleted(false);
        this.hasFourEyesChange = false;
    }

    public void setHasFourEyesChange(boolean hasFourEyesChange) {
        this.hasFourEyesChange = hasFourEyesChange;
    }

    public Integer getId() {
        return this._ebean_get_id();
    }

    public void setId(Integer id) {
        this._ebean_set_id(id);
    }

    public void setBusinessId(Integer businessId) {
        this._ebean_set_businessId(businessId);
    }

    public void setCreated(Date created) {
        this._ebean_set_created(created);
    }

    public void setConfirmed(Date confirmed) {
        this._ebean_set_confirmed(confirmed);
    }

    public void setVersion(Version version) {
        this._ebean_set_version(version);
    }

    public User getCreator() {
        if (this._ebean_get_created().after(MIGRATION_DATE)) {
            return this._ebean_get_createdUser();
        }
        return null;
    }

    public User getCreatedUser() {
        return this._ebean_get_createdUser();
    }

    public void setCreatedUser(User createdUser) {
        this._ebean_set_createdUser(createdUser);
    }

    public User getConfirmedUser() {
        return this._ebean_get_confirmedUser();
    }

    public void setConfirmedUser(User confirmedUser) {
        this._ebean_set_confirmedUser(confirmedUser);
    }

    public Integer getBusinessId() {
        return this._ebean_get_businessId();
    }

    public Date getCreated() {
        return this._ebean_get_created();
    }

    public Date getConfirmed() {
        return this._ebean_get_confirmed();
    }

    public Version getVersion() {
        return this._ebean_get_version();
    }

    public boolean isCurrent() {
        return Version.CURRENT.equals((Object)this._ebean_get_version());
    }

    public boolean isInProcess() {
        return Version.EDITPROCESS.equals((Object)this._ebean_get_version());
    }

    public boolean isInProcessByOtherUser(User user) {
        if (this.isInProcess() && this._ebean_get_createdUser() != null) {
            return !((Object)this._ebean_get_createdUser()).equals(user);
        }
        return false;
    }

    public void save(User user, boolean useFourEyes) {
        if (this.getId() == null) {
            this.setCreatedUser(user);
            this.setCreated(new Timestamp(System.currentTimeMillis()));
            this.setVersion(useFourEyes ? Version.EDITPROCESS : Version.CURRENT);
            DB.save(this);
        } else if (Version.EDITPROCESS.equals((Object)this._ebean_get_version())) {
            if (((Object)user).equals(this.getCreatedUser())) {
                DB.update(this);
            } else {
                this.confirm(user, this._ebean_get_id(), this._ebean_get_businessId());
            }
        } else if (Version.CURRENT.equals((Object)this._ebean_get_version())) {
            if (this.hasFourEyesChange) {
                this.copyOriginalEntry();
                this.setCreatedUser(user);
                this.setCreated(new Timestamp(System.currentTimeMillis()));
                this.setConfirmedUser(null);
                this.setConfirmed(null);
            }
            if (this._ebean_get_businessId() == null) {
                this._ebean_set_businessId(this._ebean_get_id());
            }
            if (useFourEyes && this.hasFourEyesChange) {
                this.setVersion(Version.EDITPROCESS);
            } else {
                this.setVersion(Version.CURRENT);
            }
            DB.update(this);
        }
    }

    public void delete(User user) {
        if (this._ebean_get_id() == null) {
            return;
        }
        this.copyOriginalEntry();
        Timestamp deletionTime = new Timestamp(System.currentTimeMillis());
        this.setCreatedUser(user);
        this.setCreated(deletionTime);
        this.setConfirmedUser(user);
        this.setConfirmed(deletionTime);
        this.setDeleted(true);
        this.setVersion(Version.HISTORIC);
        DB.update(this);
    }

    private void copyOriginalEntry() {
        HistoryLog original = this.findOriginalEntry();
        if (original != null) {
            original._ebean_set_id(null);
            original._ebean_set_version(Version.HISTORIC);
            original._ebean_set_businessId(this._ebean_get_businessId() != null ? this._ebean_get_businessId() : this._ebean_get_id());
            original._ebean_set_lockingUser(null);
            DB.insert(original);
        }
    }

    public void discard(User user) {
        if (this._ebean_get_id() == null) {
            return;
        }
        HistoryLog latestHistoric = this.findHistoricEntry();
        if (latestHistoric != null) {
            latestHistoric.setVersion(Version.CURRENT);
            DB.update(latestHistoric);
        }
        this.discard(user, this._ebean_get_id(), this._ebean_get_businessId());
    }

    public abstract void confirm(User var1, Integer var2, Integer var3);

    public abstract void discard(User var1, Integer var2, Integer var3);

    public abstract HistoryLog findOriginalEntry();

    public abstract HistoryLog findHistoricEntry();

    public User getLockingUser() {
        return this._ebean_get_lockingUser();
    }

    public void setLockingUser(User lockingUser) {
        this._ebean_set_lockingUser(lockingUser);
    }

    public boolean isDeleted() {
        return this._ebean_get_deleted();
    }

    public void setDeleted(boolean deleted) {
        this._ebean_set_deleted(deleted);
    }

    static {
        _ebean_props = new String[]{"id", "businessId", "createdUser", "created", "confirmedUser", "confirmed", "version", "lockingUser", "deleted", "hasFourEyesChange"};
        Calendar cal = Calendar.getInstance();
        cal.clear();
        cal.set(1, 1999);
        cal.set(2, 0);
        cal.set(5, 1);
        MIGRATION_DATE = cal.getTime();
    }

    public /* synthetic */ String[] _ebean_getPropertyNames() {
        return _ebean_props;
    }

    public /* synthetic */ String _ebean_getPropertyName(int pos) {
        return _ebean_props[pos];
    }

    public /* synthetic */ EntityBeanIntercept _ebean_getIntercept() {
        return this._ebean_intercept;
    }

    public /* synthetic */ EntityBeanIntercept _ebean_intercept() {
        if (this._ebean_intercept == null) {
            this._ebean_intercept = new EntityBeanIntercept((Object)this);
        }
        return this._ebean_intercept;
    }

    protected /* synthetic */ Integer _ebean_get_id() {
        this._ebean_intercept.preGetId();
        return this.id;
    }

    protected /* synthetic */ void _ebean_set_id(Integer newValue) {
        this._ebean_intercept.preSetter(false, 0, (Object)this.id, (Object)newValue);
        this.id = newValue;
    }

    protected /* synthetic */ Integer _ebean_getni_id() {
        return this.id;
    }

    protected /* synthetic */ void _ebean_setni_id(Integer _newValue) {
        this.id = _newValue;
        this._ebean_intercept.setLoadedProperty(0);
    }

    protected /* synthetic */ Integer _ebean_get_businessId() {
        this._ebean_intercept.preGetter(1);
        return this.businessId;
    }

    protected /* synthetic */ void _ebean_set_businessId(Integer newValue) {
        this._ebean_intercept.preSetter(true, 1, (Object)this._ebean_get_businessId(), (Object)newValue);
        this.businessId = newValue;
    }

    protected /* synthetic */ Integer _ebean_getni_businessId() {
        return this.businessId;
    }

    protected /* synthetic */ void _ebean_setni_businessId(Integer _newValue) {
        this.businessId = _newValue;
        this._ebean_intercept.setLoadedProperty(1);
    }

    protected /* synthetic */ User _ebean_get_createdUser() {
        this._ebean_intercept.preGetter(2);
        return this.createdUser;
    }

    protected /* synthetic */ void _ebean_set_createdUser(User newValue) {
        this._ebean_intercept.preSetter(true, 2, (Object)this._ebean_get_createdUser(), (Object)newValue);
        this.createdUser = newValue;
    }

    protected /* synthetic */ User _ebean_getni_createdUser() {
        return this.createdUser;
    }

    protected /* synthetic */ void _ebean_setni_createdUser(User _newValue) {
        this.createdUser = _newValue;
        this._ebean_intercept.setLoadedProperty(2);
    }

    protected /* synthetic */ Date _ebean_get_created() {
        this._ebean_intercept.preGetter(3);
        return this.created;
    }

    protected /* synthetic */ void _ebean_set_created(Date newValue) {
        this._ebean_intercept.preSetter(true, 3, (Object)this._ebean_get_created(), (Object)newValue);
        this.created = newValue;
    }

    protected /* synthetic */ Date _ebean_getni_created() {
        return this.created;
    }

    protected /* synthetic */ void _ebean_setni_created(Date _newValue) {
        this.created = _newValue;
        this._ebean_intercept.setLoadedProperty(3);
    }

    protected /* synthetic */ User _ebean_get_confirmedUser() {
        this._ebean_intercept.preGetter(4);
        return this.confirmedUser;
    }

    protected /* synthetic */ void _ebean_set_confirmedUser(User newValue) {
        this._ebean_intercept.preSetter(true, 4, (Object)this._ebean_get_confirmedUser(), (Object)newValue);
        this.confirmedUser = newValue;
    }

    protected /* synthetic */ User _ebean_getni_confirmedUser() {
        return this.confirmedUser;
    }

    protected /* synthetic */ void _ebean_setni_confirmedUser(User _newValue) {
        this.confirmedUser = _newValue;
        this._ebean_intercept.setLoadedProperty(4);
    }

    protected /* synthetic */ Date _ebean_get_confirmed() {
        this._ebean_intercept.preGetter(5);
        return this.confirmed;
    }

    protected /* synthetic */ void _ebean_set_confirmed(Date newValue) {
        this._ebean_intercept.preSetter(true, 5, (Object)this._ebean_get_confirmed(), (Object)newValue);
        this.confirmed = newValue;
    }

    protected /* synthetic */ Date _ebean_getni_confirmed() {
        return this.confirmed;
    }

    protected /* synthetic */ void _ebean_setni_confirmed(Date _newValue) {
        this.confirmed = _newValue;
        this._ebean_intercept.setLoadedProperty(5);
    }

    protected /* synthetic */ Version _ebean_get_version() {
        this._ebean_intercept.preGetter(6);
        return this.version;
    }

    protected /* synthetic */ void _ebean_set_version(Version newValue) {
        this._ebean_intercept.preSetter(true, 6, (Object)this._ebean_get_version(), (Object)newValue);
        this.version = newValue;
    }

    protected /* synthetic */ Version _ebean_getni_version() {
        return this.version;
    }

    protected /* synthetic */ void _ebean_setni_version(Version _newValue) {
        this.version = _newValue;
        this._ebean_intercept.setLoadedProperty(6);
    }

    protected /* synthetic */ User _ebean_get_lockingUser() {
        this._ebean_intercept.preGetter(7);
        return this.lockingUser;
    }

    protected /* synthetic */ void _ebean_set_lockingUser(User newValue) {
        this._ebean_intercept.preSetter(true, 7, (Object)this._ebean_get_lockingUser(), (Object)newValue);
        this.lockingUser = newValue;
    }

    protected /* synthetic */ User _ebean_getni_lockingUser() {
        return this.lockingUser;
    }

    protected /* synthetic */ void _ebean_setni_lockingUser(User _newValue) {
        this.lockingUser = _newValue;
        this._ebean_intercept.setLoadedProperty(7);
    }

    protected /* synthetic */ boolean _ebean_get_deleted() {
        this._ebean_intercept.preGetter(8);
        return this.deleted;
    }

    protected /* synthetic */ void _ebean_set_deleted(boolean newValue) {
        this._ebean_intercept.preSetter(true, 8, this._ebean_get_deleted(), newValue);
        this.deleted = newValue;
    }

    protected /* synthetic */ boolean _ebean_getni_deleted() {
        return this.deleted;
    }

    protected /* synthetic */ void _ebean_setni_deleted(boolean _newValue) {
        this.deleted = _newValue;
        this._ebean_intercept.setLoadedProperty(8);
    }

    protected /* synthetic */ boolean _ebean_get_hasFourEyesChange() {
        return this.hasFourEyesChange;
    }

    protected /* synthetic */ void _ebean_set_hasFourEyesChange(boolean newValue) {
        this._ebean_intercept.preSetter(false, 9, this._ebean_get_hasFourEyesChange(), newValue);
        this.hasFourEyesChange = newValue;
    }

    protected /* synthetic */ boolean _ebean_getni_hasFourEyesChange() {
        return this.hasFourEyesChange;
    }

    protected /* synthetic */ void _ebean_setni_hasFourEyesChange(boolean _newValue) {
        this.hasFourEyesChange = _newValue;
        this._ebean_intercept.setLoadedProperty(9);
    }

    public /* synthetic */ Object _ebean_getField(int index) {
        switch (index) {
            case 0: {
                return this.id;
            }
            case 1: {
                return this.businessId;
            }
            case 2: {
                return this.createdUser;
            }
            case 3: {
                return this.created;
            }
            case 4: {
                return this.confirmedUser;
            }
            case 5: {
                return this.confirmed;
            }
            case 6: {
                return this.version;
            }
            case 7: {
                return this.lockingUser;
            }
            case 8: {
                return this.deleted;
            }
            case 9: {
                return this.hasFourEyesChange;
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    public /* synthetic */ Object _ebean_getFieldIntercept(int index) {
        switch (index) {
            case 0: {
                return this._ebean_get_id();
            }
            case 1: {
                return this._ebean_get_businessId();
            }
            case 2: {
                return this._ebean_get_createdUser();
            }
            case 3: {
                return this._ebean_get_created();
            }
            case 4: {
                return this._ebean_get_confirmedUser();
            }
            case 5: {
                return this._ebean_get_confirmed();
            }
            case 6: {
                return this._ebean_get_version();
            }
            case 7: {
                return this._ebean_get_lockingUser();
            }
            case 8: {
                return this._ebean_get_deleted();
            }
            case 9: {
                return this._ebean_get_hasFourEyesChange();
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    public /* synthetic */ void _ebean_setField(int index, Object o) {
        switch (index) {
            case 0: {
                this._ebean_setni_id((Integer)o);
                return;
            }
            case 1: {
                this._ebean_setni_businessId((Integer)o);
                return;
            }
            case 2: {
                this._ebean_setni_createdUser((User)o);
                return;
            }
            case 3: {
                this._ebean_setni_created((Date)o);
                return;
            }
            case 4: {
                this._ebean_setni_confirmedUser((User)o);
                return;
            }
            case 5: {
                this._ebean_setni_confirmed((Date)o);
                return;
            }
            case 6: {
                this._ebean_setni_version((Version)((Object)o));
                return;
            }
            case 7: {
                this._ebean_setni_lockingUser((User)o);
                return;
            }
            case 8: {
                this._ebean_setni_deleted((Boolean)o);
                return;
            }
            case 9: {
                this._ebean_setni_hasFourEyesChange((Boolean)o);
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    public /* synthetic */ void _ebean_setFieldIntercept(int index, Object o) {
        switch (index) {
            case 0: {
                this._ebean_set_id((Integer)o);
                return;
            }
            case 1: {
                this._ebean_set_businessId((Integer)o);
                return;
            }
            case 2: {
                this._ebean_set_createdUser((User)o);
                return;
            }
            case 3: {
                this._ebean_set_created((Date)o);
                return;
            }
            case 4: {
                this._ebean_set_confirmedUser((User)o);
                return;
            }
            case 5: {
                this._ebean_set_confirmed((Date)o);
                return;
            }
            case 6: {
                this._ebean_set_version((Version)((Object)o));
                return;
            }
            case 7: {
                this._ebean_set_lockingUser((User)o);
                return;
            }
            case 8: {
                this._ebean_set_deleted((Boolean)o);
                return;
            }
            case 9: {
                this._ebean_set_hasFourEyesChange((Boolean)o);
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private /* synthetic */ Object _ebean_getIdentity() {
        HistoryLog historyLog = this;
        synchronized (historyLog) {
            if (this._ebean_identity != null) {
                return this._ebean_identity;
            }
            Object tmpId = this._ebean_getField(0);
            this._ebean_identity = tmpId != null ? tmpId : new Object();
            return this._ebean_identity;
        }
    }

    public /* synthetic */ boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        return this._ebean_getIdentity().equals(((HistoryLog)obj)._ebean_getIdentity());
    }

    public /* synthetic */ int hashCode() {
        return this._ebean_getIdentity().hashCode();
    }

    public /* synthetic */ void _ebean_setEmbeddedLoaded() {
    }

    public /* synthetic */ boolean _ebean_isEmbeddedNewOrDirty() {
        return false;
    }

    public /* synthetic */ Object _ebean_newInstance() {
        return new HistoryLog();
    }

    public static enum Version {
        HISTORIC,
        CURRENT,
        EDITPROCESS;

    }
}

