/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.database.vo;

import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.BankSettings;
import io.ebean.ExpressionList;
import io.ebean.Query;
import io.ebean.Update;
import io.ebean.bean.EntityBean;
import io.ebean.bean.EntityBeanIntercept;
import java.sql.Timestamp;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;

@Entity
public class HacEntry
implements EntityBean {
    @Id
    private Integer id;
    @ManyToOne
    private BankSettings bank;
    @Column(nullable=false)
    private Timestamp hacTime;
    @Column(name="axn")
    private Integer action;
    @Column(length=35)
    private String customerId;
    @Column(length=35)
    private String userId;
    @Column(length=4)
    private String reason;
    @Column(length=4)
    private String orderNumber;
    @Column(length=3)
    private String orderType;
    private String fileType;
    @Lob
    private String additionalInformation;
    public static /* synthetic */ String[] _ebean_props;
    protected /* synthetic */ EntityBeanIntercept _ebean_intercept;
    protected transient /* synthetic */ Object _ebean_identity;

    public HacEntry() {
        this._ebean_intercept = new EntityBeanIntercept((Object)this);
    }

    public static boolean exists(BankSettings bank, Timestamp hacTime, Integer action, String orderType, String orderId, String fileType, String customerId, String userId) {
        ExpressionList expr = DB.find(HacEntry.class).where().eq("bank", (Object)bank).eq("hacTime", (Object)hacTime).eq("action", (Object)action);
        if (orderType != null) {
            expr.eq("orderType", (Object)orderType);
        } else {
            expr.isNull("orderType");
        }
        if (orderId != null) {
            expr.eq("orderNumber", (Object)orderId);
        } else {
            expr.isNull("orderNumber");
        }
        if (fileType != null) {
            expr.eq("fileType", (Object)fileType);
        } else {
            expr.isNull("fileType");
        }
        if (customerId != null) {
            expr.eq("customerId", (Object)customerId);
        } else {
            expr.isNull("customerId");
        }
        if (userId != null) {
            expr.eq("userId", (Object)userId);
        } else {
            expr.isNull("userId");
        }
        int count = expr.findCount();
        return count != 0;
    }

    @Deprecated
    public static Query<HacEntry> queryByFileType(BankSettings bank, String fileType, String orderNumber, Timestamp oldestTime) {
        return DB.find(HacEntry.class).where().eq("bank", (Object)bank).eq("fileType", (Object)fileType).eq("orderNumber", (Object)orderNumber).ge("hacTime", (Object)oldestTime).order("hacTime ASC, id ASC").query();
    }

    public static Query<HacEntry> queryByFileType(BankSettings bank, String customerId, String fileType, String orderNumber, Timestamp oldestTime, Timestamp newestTime) {
        return DB.find(HacEntry.class).where().eq("bank", (Object)bank).eq("customerId", (Object)customerId).eq("fileType", (Object)fileType).eq("orderNumber", (Object)orderNumber).ge("hacTime", (Object)oldestTime).le("hacTime", (Object)newestTime).order("hacTime ASC, id ASC").query();
    }

    public static Query<HacEntry> queryByFileTypeAndAction(BankSettings bank, String customerId, String fileType, Integer action, String orderNumber, Timestamp oldestTime, Timestamp newestTime) {
        return DB.find(HacEntry.class).where().eq("bank", (Object)bank).eq("customerId", (Object)customerId).eq("fileType", (Object)fileType).eq("axn", (Object)action).eq("orderNumber", (Object)orderNumber).ge("hacTime", (Object)oldestTime).le("hacTime", (Object)newestTime).order("hacTime ASC, id ASC").query();
    }

    public static Query<HacEntry> queryByBank(BankSettings bank) {
        return DB.find(HacEntry.class).where().eq("bank", (Object)bank).order("hacTime DESC, id DESC").query();
    }

    @Deprecated
    public static int countByFileType(BankSettings bank, String fileType, String orderNumber, Timestamp oldestTime) {
        return DB.find(HacEntry.class).where().eq("bank", (Object)bank).eq("fileType", (Object)fileType).eq("orderNumber", (Object)orderNumber).ge("hacTime", (Object)oldestTime).findCount();
    }

    public static int countByFileType(BankSettings bank, String fileType, String orderNumber, Timestamp oldestTime, Timestamp newestTime) {
        return DB.find(HacEntry.class).where().eq("bank", (Object)bank).eq("fileType", (Object)fileType).eq("orderNumber", (Object)orderNumber).ge("hacTime", (Object)oldestTime).le("hacTime", (Object)newestTime).findCount();
    }

    @Deprecated
    public static Query<HacEntry> queryByOrderType(BankSettings bank, String orderType, String orderNumber, Timestamp oldestTime) {
        return DB.find(HacEntry.class).where().eq("bank", (Object)bank).eq("orderType", (Object)orderType).eq("orderNumber", (Object)orderNumber).ge("hacTime", (Object)oldestTime).order("hacTime ASC, id ASC").query();
    }

    public static Query<HacEntry> queryByOrderType(BankSettings bank, String customerId, String orderType, String orderNumber, Timestamp oldestTime, Timestamp newestTime) {
        return DB.find(HacEntry.class).where().eq("bank", (Object)bank).eq("customerId", (Object)customerId).eq("orderType", (Object)orderType).eq("orderNumber", (Object)orderNumber).ge("hacTime", (Object)oldestTime).le("hacTime", (Object)newestTime).order("hacTime ASC, id ASC").query();
    }

    public static Query<HacEntry> queryByOrderTypeAndAction(BankSettings bank, String customerId, String orderType, Integer action, String orderNumber, Timestamp oldestTime, Timestamp newestTime) {
        return DB.find(HacEntry.class).where().eq("bank", (Object)bank).eq("customerId", (Object)customerId).eq("orderType", (Object)orderType).eq("axn", (Object)action).eq("orderNumber", (Object)orderNumber).ge("hacTime", (Object)oldestTime).le("hacTime", (Object)newestTime).order("hacTime ASC, id ASC").query();
    }

    @Deprecated
    public static int countByOrderType(BankSettings bank, String orderType, String orderNumber, Timestamp oldestTime) {
        return DB.find(HacEntry.class).where().eq("bank", (Object)bank).eq("orderType", (Object)orderType).eq("orderNumber", (Object)orderNumber).ge("hacTime", (Object)oldestTime).findCount();
    }

    public static int countByOrderType(BankSettings bank, String orderType, String orderNumber, Timestamp oldestTime, Timestamp newestTime) {
        return DB.find(HacEntry.class).where().eq("bank", (Object)bank).eq("orderType", (Object)orderType).eq("orderNumber", (Object)orderNumber).ge("hacTime", (Object)oldestTime).le("hacTime", (Object)newestTime).findCount();
    }

    public static int deleteAll(BankSettings bank) {
        Update<HacEntry> delete = DB.createUpdate(HacEntry.class, "DELETE FROM HacEntry WHERE bank=:bank");
        delete.setParameter("bank", (Object)bank.getBankId());
        return delete.execute();
    }

    public static List<HacEntry> findByActionNoOrderNumber(BankSettings bank, int action) {
        return DB.find(HacEntry.class).where().eq("bank", (Object)bank).eq("axn", (Object)action).isNull("orderNumber").findList();
    }

    @Deprecated
    public static List<HacEntry> findByAction(BankSettings bank, String orderType, String orderNumber, String fileType, Timestamp oldestTime, Integer ... actions) {
        ExpressionList expr = DB.find(HacEntry.class).where().eq("bank", (Object)bank).eq("orderType", (Object)orderType).eq("orderNumber", (Object)orderNumber).ge("hacTime", (Object)oldestTime).isNotNull("additionalInformation").in("action", (Object[])actions);
        if (fileType != null) {
            expr.eq("fileType", (Object)fileType);
        }
        return expr.orderBy("hacTime DESC").findList();
    }

    @Deprecated
    public static List<HacEntry> findByAction(BankSettings bank, String orderType, String orderNumber, String fileType, Timestamp oldestTime, Timestamp newestTime, Integer ... actions) {
        ExpressionList expr = DB.find(HacEntry.class).where().eq("bank", (Object)bank).eq("orderType", (Object)orderType).eq("orderNumber", (Object)orderNumber).ge("hacTime", (Object)oldestTime).le("hacTime", (Object)newestTime).isNotNull("additionalInformation").in("action", (Object[])actions);
        if (fileType != null) {
            expr.eq("fileType", (Object)fileType);
        }
        return expr.orderBy("hacTime DESC").findList();
    }

    public static List<HacEntry> findEntriesWithAdditionalInfoByOrderType(BankSettings bank, String orderType, String orderNumber, Timestamp oldestTime, Timestamp newestTime, Integer ... actions) {
        ExpressionList expr = DB.find(HacEntry.class).where().eq("bank", (Object)bank).eq("customerId", (Object)bank.getCustomerId()).eq("orderType", (Object)orderType).eq("orderNumber", (Object)orderNumber).ge("hacTime", (Object)oldestTime).le("hacTime", (Object)newestTime).isNotNull("additionalInformation").in("action", (Object[])actions);
        return expr.orderBy("hacTime DESC").findList();
    }

    public static List<HacEntry> findEntriesWithAdditionalInfoByFileType(BankSettings bank, String fileType, String orderNumber, Timestamp oldestTime, Timestamp newestTime, Integer ... actions) {
        ExpressionList expr = DB.find(HacEntry.class).where().eq("bank", (Object)bank).eq("customerId", (Object)bank.getCustomerId()).eq("fileType", (Object)fileType).eq("orderNumber", (Object)orderNumber).ge("hacTime", (Object)oldestTime).le("hacTime", (Object)newestTime).isNotNull("additionalInformation").in("action", (Object[])actions);
        return expr.orderBy("hacTime DESC").findList();
    }

    public static int findOlderThan(Timestamp older) {
        return DB.find(HacEntry.class).where().lt("hacTime", (Object)older).findCount();
    }

    public static int deleteOlderThan(Timestamp older) {
        Update<HacEntry> update = DB.createUpdate(HacEntry.class, "DELETE FROM HacEntry WHERE hacTime < :older");
        update.set("older", (Object)older);
        return update.execute();
    }

    public static int deleteByTimeAndAction(BankSettings bank, Timestamp timestamp, int action) {
        Update<HacEntry> delete = DB.createUpdate(HacEntry.class, "DELETE FROM HacEntry WHERE bank=:param1 AND hacTime=:param2 AND axn=:param3");
        delete.set("param1", (Object)bank.getBankId());
        delete.set("param2", (Object)timestamp);
        delete.set("param3", (Object)action);
        return delete.execute();
    }

    public static HacEntry findById(int id) {
        return (HacEntry)DB.find(HacEntry.class).where().eq("id", (Object)id).findOne();
    }

    public Integer getId() {
        return this._ebean_get_id();
    }

    public void setId(Integer id) {
        this._ebean_set_id(id);
    }

    public Timestamp getHacTime() {
        return this._ebean_get_hacTime();
    }

    public void setHacTime(Timestamp hacTime) {
        this._ebean_set_hacTime(hacTime);
    }

    public Integer getAction() {
        return this._ebean_get_action();
    }

    public void setAction(Integer action) {
        this._ebean_set_action(action);
    }

    public String getCustomerId() {
        return this._ebean_get_customerId();
    }

    public void setCustomerId(String customerId) {
        this._ebean_set_customerId(customerId);
    }

    public String getUserId() {
        return this._ebean_get_userId();
    }

    public void setUserId(String userId) {
        this._ebean_set_userId(userId);
    }

    public String getReason() {
        return this._ebean_get_reason();
    }

    public void setReason(String reason) {
        this._ebean_set_reason(reason);
    }

    public BankSettings getBank() {
        return this._ebean_get_bank();
    }

    public void setBank(BankSettings bank) {
        this._ebean_set_bank(bank);
    }

    public String getOrderNumber() {
        return this._ebean_get_orderNumber();
    }

    public void setOrderNumber(String orderNumber) {
        this._ebean_set_orderNumber(orderNumber);
    }

    public String getOrderType() {
        return this._ebean_get_orderType();
    }

    public void setOrderType(String orderType) {
        this._ebean_set_orderType(orderType);
    }

    public String getFileType() {
        return this._ebean_get_fileType();
    }

    public String getGeneralizedOrderType() {
        if (this._ebean_get_fileType() != null) {
            return this._ebean_get_fileType();
        }
        return this._ebean_get_orderType();
    }

    public void setFileType(String fileType) {
        this._ebean_set_fileType(fileType);
    }

    public String getUserRepresentation() {
        String userID = this.getUserId();
        if (userID == null || userID.length() == 0) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        result.append(this.getCustomerId());
        if (result.length() > 0) {
            result.append(" / ");
        }
        result.append(userID);
        return result.toString();
    }

    public String getAdditionalInformation() {
        return this._ebean_get_additionalInformation();
    }

    public void setAdditionalInformation(String additionalInformation) {
        this._ebean_set_additionalInformation(additionalInformation);
    }

    public void save() {
        if (this.getId() == null) {
            DB.save(this);
        } else {
            DB.update(this);
        }
    }

    public void delete() {
        DB.delete(this);
    }

    static {
        _ebean_props = new String[]{"id", "bank", "hacTime", "action", "customerId", "userId", "reason", "orderNumber", "orderType", "fileType", "additionalInformation"};
    }

    public /* synthetic */ String[] _ebean_getPropertyNames() {
        return _ebean_props;
    }

    public /* synthetic */ String _ebean_getPropertyName(int pos) {
        return _ebean_props[pos];
    }

    public /* synthetic */ EntityBeanIntercept _ebean_getIntercept() {
        return this._ebean_intercept;
    }

    public /* synthetic */ EntityBeanIntercept _ebean_intercept() {
        if (this._ebean_intercept == null) {
            this._ebean_intercept = new EntityBeanIntercept((Object)this);
        }
        return this._ebean_intercept;
    }

    protected /* synthetic */ Integer _ebean_get_id() {
        this._ebean_intercept.preGetId();
        return this.id;
    }

    protected /* synthetic */ void _ebean_set_id(Integer newValue) {
        this._ebean_intercept.preSetter(false, 0, (Object)this.id, (Object)newValue);
        this.id = newValue;
    }

    protected /* synthetic */ Integer _ebean_getni_id() {
        return this.id;
    }

    protected /* synthetic */ void _ebean_setni_id(Integer _newValue) {
        this.id = _newValue;
        this._ebean_intercept.setLoadedProperty(0);
    }

    protected /* synthetic */ BankSettings _ebean_get_bank() {
        this._ebean_intercept.preGetter(1);
        return this.bank;
    }

    protected /* synthetic */ void _ebean_set_bank(BankSettings newValue) {
        this._ebean_intercept.preSetter(true, 1, (Object)this._ebean_get_bank(), (Object)newValue);
        this.bank = newValue;
    }

    protected /* synthetic */ BankSettings _ebean_getni_bank() {
        return this.bank;
    }

    protected /* synthetic */ void _ebean_setni_bank(BankSettings _newValue) {
        this.bank = _newValue;
        this._ebean_intercept.setLoadedProperty(1);
    }

    protected /* synthetic */ Timestamp _ebean_get_hacTime() {
        this._ebean_intercept.preGetter(2);
        return this.hacTime;
    }

    protected /* synthetic */ void _ebean_set_hacTime(Timestamp newValue) {
        this._ebean_intercept.preSetter(true, 2, (Object)this._ebean_get_hacTime(), (Object)newValue);
        this.hacTime = newValue;
    }

    protected /* synthetic */ Timestamp _ebean_getni_hacTime() {
        return this.hacTime;
    }

    protected /* synthetic */ void _ebean_setni_hacTime(Timestamp _newValue) {
        this.hacTime = _newValue;
        this._ebean_intercept.setLoadedProperty(2);
    }

    protected /* synthetic */ Integer _ebean_get_action() {
        this._ebean_intercept.preGetter(3);
        return this.action;
    }

    protected /* synthetic */ void _ebean_set_action(Integer newValue) {
        this._ebean_intercept.preSetter(true, 3, (Object)this._ebean_get_action(), (Object)newValue);
        this.action = newValue;
    }

    protected /* synthetic */ Integer _ebean_getni_action() {
        return this.action;
    }

    protected /* synthetic */ void _ebean_setni_action(Integer _newValue) {
        this.action = _newValue;
        this._ebean_intercept.setLoadedProperty(3);
    }

    protected /* synthetic */ String _ebean_get_customerId() {
        this._ebean_intercept.preGetter(4);
        return this.customerId;
    }

    protected /* synthetic */ void _ebean_set_customerId(String newValue) {
        this._ebean_intercept.preSetter(true, 4, (Object)this._ebean_get_customerId(), (Object)newValue);
        this.customerId = newValue;
    }

    protected /* synthetic */ String _ebean_getni_customerId() {
        return this.customerId;
    }

    protected /* synthetic */ void _ebean_setni_customerId(String _newValue) {
        this.customerId = _newValue;
        this._ebean_intercept.setLoadedProperty(4);
    }

    protected /* synthetic */ String _ebean_get_userId() {
        this._ebean_intercept.preGetter(5);
        return this.userId;
    }

    protected /* synthetic */ void _ebean_set_userId(String newValue) {
        this._ebean_intercept.preSetter(true, 5, (Object)this._ebean_get_userId(), (Object)newValue);
        this.userId = newValue;
    }

    protected /* synthetic */ String _ebean_getni_userId() {
        return this.userId;
    }

    protected /* synthetic */ void _ebean_setni_userId(String _newValue) {
        this.userId = _newValue;
        this._ebean_intercept.setLoadedProperty(5);
    }

    protected /* synthetic */ String _ebean_get_reason() {
        this._ebean_intercept.preGetter(6);
        return this.reason;
    }

    protected /* synthetic */ void _ebean_set_reason(String newValue) {
        this._ebean_intercept.preSetter(true, 6, (Object)this._ebean_get_reason(), (Object)newValue);
        this.reason = newValue;
    }

    protected /* synthetic */ String _ebean_getni_reason() {
        return this.reason;
    }

    protected /* synthetic */ void _ebean_setni_reason(String _newValue) {
        this.reason = _newValue;
        this._ebean_intercept.setLoadedProperty(6);
    }

    protected /* synthetic */ String _ebean_get_orderNumber() {
        this._ebean_intercept.preGetter(7);
        return this.orderNumber;
    }

    protected /* synthetic */ void _ebean_set_orderNumber(String newValue) {
        this._ebean_intercept.preSetter(true, 7, (Object)this._ebean_get_orderNumber(), (Object)newValue);
        this.orderNumber = newValue;
    }

    protected /* synthetic */ String _ebean_getni_orderNumber() {
        return this.orderNumber;
    }

    protected /* synthetic */ void _ebean_setni_orderNumber(String _newValue) {
        this.orderNumber = _newValue;
        this._ebean_intercept.setLoadedProperty(7);
    }

    protected /* synthetic */ String _ebean_get_orderType() {
        this._ebean_intercept.preGetter(8);
        return this.orderType;
    }

    protected /* synthetic */ void _ebean_set_orderType(String newValue) {
        this._ebean_intercept.preSetter(true, 8, (Object)this._ebean_get_orderType(), (Object)newValue);
        this.orderType = newValue;
    }

    protected /* synthetic */ String _ebean_getni_orderType() {
        return this.orderType;
    }

    protected /* synthetic */ void _ebean_setni_orderType(String _newValue) {
        this.orderType = _newValue;
        this._ebean_intercept.setLoadedProperty(8);
    }

    protected /* synthetic */ String _ebean_get_fileType() {
        this._ebean_intercept.preGetter(9);
        return this.fileType;
    }

    protected /* synthetic */ void _ebean_set_fileType(String newValue) {
        this._ebean_intercept.preSetter(true, 9, (Object)this._ebean_get_fileType(), (Object)newValue);
        this.fileType = newValue;
    }

    protected /* synthetic */ String _ebean_getni_fileType() {
        return this.fileType;
    }

    protected /* synthetic */ void _ebean_setni_fileType(String _newValue) {
        this.fileType = _newValue;
        this._ebean_intercept.setLoadedProperty(9);
    }

    protected /* synthetic */ String _ebean_get_additionalInformation() {
        this._ebean_intercept.preGetter(10);
        return this.additionalInformation;
    }

    protected /* synthetic */ void _ebean_set_additionalInformation(String newValue) {
        this._ebean_intercept.preSetter(true, 10, (Object)this._ebean_get_additionalInformation(), (Object)newValue);
        this.additionalInformation = newValue;
    }

    protected /* synthetic */ String _ebean_getni_additionalInformation() {
        return this.additionalInformation;
    }

    protected /* synthetic */ void _ebean_setni_additionalInformation(String _newValue) {
        this.additionalInformation = _newValue;
        this._ebean_intercept.setLoadedProperty(10);
    }

    public /* synthetic */ Object _ebean_getField(int index) {
        switch (index) {
            case 0: {
                return this.id;
            }
            case 1: {
                return this.bank;
            }
            case 2: {
                return this.hacTime;
            }
            case 3: {
                return this.action;
            }
            case 4: {
                return this.customerId;
            }
            case 5: {
                return this.userId;
            }
            case 6: {
                return this.reason;
            }
            case 7: {
                return this.orderNumber;
            }
            case 8: {
                return this.orderType;
            }
            case 9: {
                return this.fileType;
            }
            case 10: {
                return this.additionalInformation;
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    public /* synthetic */ Object _ebean_getFieldIntercept(int index) {
        switch (index) {
            case 0: {
                return this._ebean_get_id();
            }
            case 1: {
                return this._ebean_get_bank();
            }
            case 2: {
                return this._ebean_get_hacTime();
            }
            case 3: {
                return this._ebean_get_action();
            }
            case 4: {
                return this._ebean_get_customerId();
            }
            case 5: {
                return this._ebean_get_userId();
            }
            case 6: {
                return this._ebean_get_reason();
            }
            case 7: {
                return this._ebean_get_orderNumber();
            }
            case 8: {
                return this._ebean_get_orderType();
            }
            case 9: {
                return this._ebean_get_fileType();
            }
            case 10: {
                return this._ebean_get_additionalInformation();
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    public /* synthetic */ void _ebean_setField(int index, Object o) {
        switch (index) {
            case 0: {
                this._ebean_setni_id((Integer)o);
                return;
            }
            case 1: {
                this._ebean_setni_bank((BankSettings)o);
                return;
            }
            case 2: {
                this._ebean_setni_hacTime((Timestamp)o);
                return;
            }
            case 3: {
                this._ebean_setni_action((Integer)o);
                return;
            }
            case 4: {
                this._ebean_setni_customerId((String)o);
                return;
            }
            case 5: {
                this._ebean_setni_userId((String)o);
                return;
            }
            case 6: {
                this._ebean_setni_reason((String)o);
                return;
            }
            case 7: {
                this._ebean_setni_orderNumber((String)o);
                return;
            }
            case 8: {
                this._ebean_setni_orderType((String)o);
                return;
            }
            case 9: {
                this._ebean_setni_fileType((String)o);
                return;
            }
            case 10: {
                this._ebean_setni_additionalInformation((String)o);
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    public /* synthetic */ void _ebean_setFieldIntercept(int index, Object o) {
        switch (index) {
            case 0: {
                this._ebean_set_id((Integer)o);
                return;
            }
            case 1: {
                this._ebean_set_bank((BankSettings)o);
                return;
            }
            case 2: {
                this._ebean_set_hacTime((Timestamp)o);
                return;
            }
            case 3: {
                this._ebean_set_action((Integer)o);
                return;
            }
            case 4: {
                this._ebean_set_customerId((String)o);
                return;
            }
            case 5: {
                this._ebean_set_userId((String)o);
                return;
            }
            case 6: {
                this._ebean_set_reason((String)o);
                return;
            }
            case 7: {
                this._ebean_set_orderNumber((String)o);
                return;
            }
            case 8: {
                this._ebean_set_orderType((String)o);
                return;
            }
            case 9: {
                this._ebean_set_fileType((String)o);
                return;
            }
            case 10: {
                this._ebean_set_additionalInformation((String)o);
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private /* synthetic */ Object _ebean_getIdentity() {
        HacEntry hacEntry = this;
        synchronized (hacEntry) {
            if (this._ebean_identity != null) {
                return this._ebean_identity;
            }
            Object tmpId = this._ebean_getField(0);
            this._ebean_identity = tmpId != null ? tmpId : new Object();
            return this._ebean_identity;
        }
    }

    public /* synthetic */ boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        return this._ebean_getIdentity().equals(((HacEntry)obj)._ebean_getIdentity());
    }

    public /* synthetic */ int hashCode() {
        return this._ebean_getIdentity().hashCode();
    }

    public /* synthetic */ void _ebean_setEmbeddedLoaded() {
    }

    public /* synthetic */ boolean _ebean_isEmbeddedNewOrDirty() {
        return false;
    }

    public /* synthetic */ Object _ebean_newInstance() {
        return new HacEntry();
    }
}

