/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.database.vo;

import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.BaseFilterWithOrderTypeBank;
import de.businesslogics.banking.database.vo.FilterComparator;
import de.businesslogics.banking.database.vo.User;
import io.ebean.Expr;
import io.ebean.Expression;
import io.ebean.Update;
import io.ebean.bean.EntityBean;
import java.sql.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

@Entity
@Table(name="fe_filter")
public class FetchFilter
extends BaseFilterWithOrderTypeBank
implements EntityBean {
    private static final long serialVersionUID = 1L;
    private boolean fetchActive;
    private String fetcher;
    @Column(name="fetcher_comp")
    private FilterComparator.Text fetcherComparator;
    public static /* synthetic */ String[] _ebean_props;

    public static FetchFilter getFilter(User user) {
        FetchFilter f = (FetchFilter)DB.find(FetchFilter.class).where().eq("user", (Object)user).findOne();
        if (f == null) {
            return new FetchFilter(user);
        }
        return f;
    }

    public static int deleteByUser(User user) {
        FetchFilter fetchFilter = (FetchFilter)DB.find(FetchFilter.class).where().eq("user", (Object)user).findOne();
        if (fetchFilter != null) {
            DB.delete(fetchFilter);
            return 1;
        }
        return 0;
    }

    public static int deleteByBank(BankSettings bank) {
        Update<FetchFilter> delete = DB.createUpdate(FetchFilter.class, "UPDATE FetchFilter SET bank=NULL WHERE bank=:bank");
        delete.setParameter("bank", (Object)bank.getBankId());
        return delete.execute();
    }

    private FetchFilter(User user) {
        super(user);
        this._ebean_set_fetcherComparator(FilterComparator.Text.CONTAINS);
    }

    public final boolean isEmpty() {
        return this.isDateFilterEmpty() && this.getBank() == null && this.getOrderType() == null && this._ebean_get_fetcher() == null;
    }

    public boolean isFetchActive() {
        return this._ebean_get_fetchActive();
    }

    public void setFetchActive(boolean fetchActive) {
        this._ebean_set_fetchActive(fetchActive);
    }

    public String getFetcher() {
        return this._ebean_get_fetcher();
    }

    public void setFetcher(String fetcher) {
        if (fetcher == null || fetcher.length() == 0) {
            this._ebean_set_fetcher(null);
        } else {
            this._ebean_set_fetcher(fetcher);
        }
    }

    public FilterComparator.Text getFetcherComparator() {
        return this._ebean_get_fetcherComparator();
    }

    public void setFetcherComparator(int fetcherComparator) {
        if (fetcherComparator >= 0 && fetcherComparator < FilterComparator.Text.values().length) {
            this.setFetcherComparator(FilterComparator.Text.values()[fetcherComparator]);
        } else {
            this.setFetcherComparator(null);
        }
    }

    public void setFetcherComparator(FilterComparator.Text fetcherComparator) {
        this._ebean_set_fetcherComparator(fetcherComparator);
    }

    private Expression getFetcherExpression() {
        if (this._ebean_get_fetcher() != null) {
            if (this._ebean_get_fetcherComparator() == FilterComparator.Text.STARTS_WITH) {
                return Expr.istartsWith((String)"fetcher", (String)this._ebean_get_fetcher());
            }
            if (this._ebean_get_fetcherComparator() == FilterComparator.Text.ENDS_WITH) {
                return Expr.iendsWith((String)"fetcher", (String)this._ebean_get_fetcher());
            }
            String masked = "%" + this._ebean_get_fetcher() + "%";
            Expression expression = Expr.ilike((String)"fetcher", (String)masked);
            if (this._ebean_get_fetcherComparator() == FilterComparator.Text.CONTAINS_NOT) {
                expression = Expr.not((Expression)expression);
            }
            return expression;
        }
        return null;
    }

    public Expression getExpression() {
        Expression fetcherExpression;
        Expression orderTypeExpression;
        Expression toReturn = this.getDateExpression("fetched");
        Expression bankExpression = this.getBankExpression("bank");
        if (bankExpression != null) {
            toReturn = this.addFilter(toReturn, bankExpression);
        }
        if ((orderTypeExpression = this.getOrderTypeExpression("orderType", "fileType")) != null) {
            toReturn = this.addFilter(toReturn, orderTypeExpression);
        }
        if ((fetcherExpression = this.getFetcherExpression()) != null) {
            toReturn = this.addFilter(toReturn, fetcherExpression);
        }
        return toReturn;
    }

    static {
        _ebean_props = new String[]{"id", "user", "fromDate", "toDate", "dateComparator", "orderType", "orderTypeComparator", "bank", "bankComparator", "fetchActive", "fetcher", "fetcherComparator"};
    }

    public /* synthetic */ FetchFilter() {
    }

    @Override
    public /* synthetic */ String[] _ebean_getPropertyNames() {
        return _ebean_props;
    }

    @Override
    public /* synthetic */ String _ebean_getPropertyName(int pos) {
        return _ebean_props[pos];
    }

    protected /* synthetic */ boolean _ebean_get_fetchActive() {
        this._ebean_intercept.preGetter(9);
        return this.fetchActive;
    }

    protected /* synthetic */ void _ebean_set_fetchActive(boolean newValue) {
        this._ebean_intercept.preSetter(true, 9, this._ebean_get_fetchActive(), newValue);
        this.fetchActive = newValue;
    }

    protected /* synthetic */ boolean _ebean_getni_fetchActive() {
        return this.fetchActive;
    }

    protected /* synthetic */ void _ebean_setni_fetchActive(boolean _newValue) {
        this.fetchActive = _newValue;
        this._ebean_intercept.setLoadedProperty(9);
    }

    protected /* synthetic */ String _ebean_get_fetcher() {
        this._ebean_intercept.preGetter(10);
        return this.fetcher;
    }

    protected /* synthetic */ void _ebean_set_fetcher(String newValue) {
        this._ebean_intercept.preSetter(true, 10, (Object)this._ebean_get_fetcher(), (Object)newValue);
        this.fetcher = newValue;
    }

    protected /* synthetic */ String _ebean_getni_fetcher() {
        return this.fetcher;
    }

    protected /* synthetic */ void _ebean_setni_fetcher(String _newValue) {
        this.fetcher = _newValue;
        this._ebean_intercept.setLoadedProperty(10);
    }

    protected /* synthetic */ FilterComparator.Text _ebean_get_fetcherComparator() {
        this._ebean_intercept.preGetter(11);
        return this.fetcherComparator;
    }

    protected /* synthetic */ void _ebean_set_fetcherComparator(FilterComparator.Text newValue) {
        this._ebean_intercept.preSetter(true, 11, (Object)this._ebean_get_fetcherComparator(), (Object)newValue);
        this.fetcherComparator = newValue;
    }

    protected /* synthetic */ FilterComparator.Text _ebean_getni_fetcherComparator() {
        return this.fetcherComparator;
    }

    protected /* synthetic */ void _ebean_setni_fetcherComparator(FilterComparator.Text _newValue) {
        this.fetcherComparator = _newValue;
        this._ebean_intercept.setLoadedProperty(11);
    }

    @Override
    public /* synthetic */ Object _ebean_getField(int index) {
        switch (index) {
            case 0: {
                return this._ebean_getni_id();
            }
            case 1: {
                return this._ebean_getni_user();
            }
            case 2: {
                return this._ebean_getni_fromDate();
            }
            case 3: {
                return this._ebean_getni_toDate();
            }
            case 4: {
                return this._ebean_getni_dateComparator();
            }
            case 5: {
                return this._ebean_getni_orderType();
            }
            case 6: {
                return this._ebean_getni_orderTypeComparator();
            }
            case 7: {
                return this._ebean_getni_bank();
            }
            case 8: {
                return this._ebean_getni_bankComparator();
            }
            case 9: {
                return this.fetchActive;
            }
            case 10: {
                return this.fetcher;
            }
            case 11: {
                return this.fetcherComparator;
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    @Override
    public /* synthetic */ Object _ebean_getFieldIntercept(int index) {
        switch (index) {
            case 0: {
                return this._ebean_get_id();
            }
            case 1: {
                return this._ebean_get_user();
            }
            case 2: {
                return this._ebean_get_fromDate();
            }
            case 3: {
                return this._ebean_get_toDate();
            }
            case 4: {
                return this._ebean_get_dateComparator();
            }
            case 5: {
                return this._ebean_get_orderType();
            }
            case 6: {
                return this._ebean_get_orderTypeComparator();
            }
            case 7: {
                return this._ebean_get_bank();
            }
            case 8: {
                return this._ebean_get_bankComparator();
            }
            case 9: {
                return this._ebean_get_fetchActive();
            }
            case 10: {
                return this._ebean_get_fetcher();
            }
            case 11: {
                return this._ebean_get_fetcherComparator();
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    @Override
    public /* synthetic */ void _ebean_setField(int index, Object o) {
        switch (index) {
            case 0: {
                this._ebean_setni_id((Integer)o);
                return;
            }
            case 1: {
                this._ebean_setni_user((User)o);
                return;
            }
            case 2: {
                this._ebean_setni_fromDate((Date)o);
                return;
            }
            case 3: {
                this._ebean_setni_toDate((Date)o);
                return;
            }
            case 4: {
                this._ebean_setni_dateComparator((FilterComparator.Date)((Object)o));
                return;
            }
            case 5: {
                this._ebean_setni_orderType((String)o);
                return;
            }
            case 6: {
                this._ebean_setni_orderTypeComparator((FilterComparator.Text)((Object)o));
                return;
            }
            case 7: {
                this._ebean_setni_bank((BankSettings)o);
                return;
            }
            case 8: {
                this._ebean_setni_bankComparator((FilterComparator.Bank)((Object)o));
                return;
            }
            case 9: {
                this._ebean_setni_fetchActive((Boolean)o);
                return;
            }
            case 10: {
                this._ebean_setni_fetcher((String)o);
                return;
            }
            case 11: {
                this._ebean_setni_fetcherComparator((FilterComparator.Text)((Object)o));
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    @Override
    public /* synthetic */ void _ebean_setFieldIntercept(int index, Object o) {
        switch (index) {
            case 0: {
                this._ebean_set_id((Integer)o);
                return;
            }
            case 1: {
                this._ebean_set_user((User)o);
                return;
            }
            case 2: {
                this._ebean_set_fromDate((Date)o);
                return;
            }
            case 3: {
                this._ebean_set_toDate((Date)o);
                return;
            }
            case 4: {
                this._ebean_set_dateComparator((FilterComparator.Date)((Object)o));
                return;
            }
            case 5: {
                this._ebean_set_orderType((String)o);
                return;
            }
            case 6: {
                this._ebean_set_orderTypeComparator((FilterComparator.Text)((Object)o));
                return;
            }
            case 7: {
                this._ebean_set_bank((BankSettings)o);
                return;
            }
            case 8: {
                this._ebean_set_bankComparator((FilterComparator.Bank)((Object)o));
                return;
            }
            case 9: {
                this._ebean_set_fetchActive((Boolean)o);
                return;
            }
            case 10: {
                this._ebean_set_fetcher((String)o);
                return;
            }
            case 11: {
                this._ebean_set_fetcherComparator((FilterComparator.Text)((Object)o));
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    @Override
    public /* synthetic */ void _ebean_setEmbeddedLoaded() {
    }

    @Override
    public /* synthetic */ boolean _ebean_isEmbeddedNewOrDirty() {
        return false;
    }

    @Override
    public /* synthetic */ Object _ebean_newInstance() {
        return new FetchFilter();
    }
}

