/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.database.vo;

import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.BaseFilter;
import de.businesslogics.banking.database.vo.FilterComparator;
import de.businesslogics.banking.database.vo.User;
import io.ebean.Expr;
import io.ebean.Expression;
import io.ebean.bean.EntityBean;
import java.sql.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

@Entity
@Table(name="exportfile_filter")
public class ExportFileFilter
extends BaseFilter
implements EntityBean {
    private static final long serialVersionUID = 1L;
    private boolean exportFileActive;
    @ManyToOne
    private Integer automaticExportId;
    private String fileName;
    @Column(name="file_name_comp", nullable=false)
    private FilterComparator.Text fileNameComparator;
    public static /* synthetic */ String[] _ebean_props;

    public String getFileName() {
        return this._ebean_get_fileName();
    }

    public void setFileName(String fileName) {
        if (fileName == null || fileName.length() == 0) {
            this._ebean_set_fileName(null);
        } else {
            this._ebean_set_fileName(fileName);
        }
    }

    public FilterComparator.Text getFileNameComparator() {
        return this._ebean_get_fileNameComparator();
    }

    public void setFileNameComparator(int fileNameComparator) {
        if (fileNameComparator >= 0 && fileNameComparator < FilterComparator.Text.values().length) {
            this.setFileNameComparator(FilterComparator.Text.values()[fileNameComparator]);
        } else {
            this.setFileNameComparator(null);
        }
    }

    public void setFileNameComparator(FilterComparator.Text fileNameComparator) {
        this._ebean_set_fileNameComparator(fileNameComparator);
    }

    protected Expression getFileNameExpression() {
        String columnName = "workspaceFile.path";
        if (this._ebean_get_fileName() != null) {
            Expression fileNameExpression;
            String masked = "%" + this._ebean_get_fileName() + "%";
            if (this._ebean_get_fileNameComparator() == FilterComparator.Text.STARTS_WITH) {
                fileNameExpression = Expr.istartsWith((String)"workspaceFile.path", (String)this._ebean_get_fileName());
            } else if (this._ebean_get_fileNameComparator() == FilterComparator.Text.ENDS_WITH) {
                fileNameExpression = Expr.iendsWith((String)"workspaceFile.path", (String)masked);
            } else if (this._ebean_get_fileNameComparator() == FilterComparator.Text.CONTAINS_NOT) {
                Expression orderTypeExpr = Expr.and((Expression)Expr.isNotNull((String)"workspaceFile.path"), (Expression)Expr.ilike((String)"workspaceFile.path", (String)masked));
                fileNameExpression = Expr.not((Expression)orderTypeExpr);
            } else {
                fileNameExpression = Expr.ilike((String)"workspaceFile.path", (String)masked);
            }
            return fileNameExpression;
        }
        return null;
    }

    public static ExportFileFilter getFilter(User user) {
        ExportFileFilter f = (ExportFileFilter)DB.find(ExportFileFilter.class).where().eq("user", (Object)user).findOne();
        if (f == null) {
            return new ExportFileFilter(user);
        }
        return f;
    }

    public static int deleteByUser(User user) {
        ExportFileFilter filter = (ExportFileFilter)DB.find(ExportFileFilter.class).where().eq("user", (Object)user).findOne();
        if (filter != null) {
            DB.delete(filter);
            return 1;
        }
        return 0;
    }

    public Integer getAutomaticExportId() {
        return this._ebean_get_automaticExportId();
    }

    public void setAutomaticExportId(Integer automaticExportId) {
        this._ebean_set_automaticExportId(automaticExportId);
    }

    private ExportFileFilter(User user) {
        super(user);
        this._ebean_set_fileNameComparator(FilterComparator.Text.CONTAINS);
    }

    public final boolean isEmpty() {
        return this.isDateFilterEmpty() && (this.getAutomaticExportId() == null || this.getAutomaticExportId() < 1) && this.getFileName() == null;
    }

    public boolean isExportFileActive() {
        return this._ebean_get_exportFileActive();
    }

    public void setExportFileActive(boolean exportFileActive) {
        this._ebean_set_exportFileActive(exportFileActive);
    }

    public Expression getExpression() {
        Expression fileNameExpression;
        Expression toReturn = this.getDateExpression("lastUpdate");
        if (this._ebean_get_automaticExportId() != null && this._ebean_get_automaticExportId() > 0) {
            toReturn = this.addFilter(toReturn, Expr.eq((String)"exports.id", (Object)this._ebean_get_automaticExportId()));
        }
        if ((fileNameExpression = this.getFileNameExpression()) != null) {
            toReturn = this.addFilter(toReturn, fileNameExpression);
        }
        return toReturn;
    }

    static {
        _ebean_props = new String[]{"id", "user", "fromDate", "toDate", "dateComparator", "exportFileActive", "automaticExportId", "fileName", "fileNameComparator"};
    }

    public /* synthetic */ ExportFileFilter() {
    }

    @Override
    public /* synthetic */ String[] _ebean_getPropertyNames() {
        return _ebean_props;
    }

    @Override
    public /* synthetic */ String _ebean_getPropertyName(int pos) {
        return _ebean_props[pos];
    }

    protected /* synthetic */ boolean _ebean_get_exportFileActive() {
        this._ebean_intercept.preGetter(5);
        return this.exportFileActive;
    }

    protected /* synthetic */ void _ebean_set_exportFileActive(boolean newValue) {
        this._ebean_intercept.preSetter(true, 5, this._ebean_get_exportFileActive(), newValue);
        this.exportFileActive = newValue;
    }

    protected /* synthetic */ boolean _ebean_getni_exportFileActive() {
        return this.exportFileActive;
    }

    protected /* synthetic */ void _ebean_setni_exportFileActive(boolean _newValue) {
        this.exportFileActive = _newValue;
        this._ebean_intercept.setLoadedProperty(5);
    }

    protected /* synthetic */ Integer _ebean_get_automaticExportId() {
        this._ebean_intercept.preGetter(6);
        return this.automaticExportId;
    }

    protected /* synthetic */ void _ebean_set_automaticExportId(Integer newValue) {
        this._ebean_intercept.preSetter(true, 6, (Object)this._ebean_get_automaticExportId(), (Object)newValue);
        this.automaticExportId = newValue;
    }

    protected /* synthetic */ Integer _ebean_getni_automaticExportId() {
        return this.automaticExportId;
    }

    protected /* synthetic */ void _ebean_setni_automaticExportId(Integer _newValue) {
        this.automaticExportId = _newValue;
        this._ebean_intercept.setLoadedProperty(6);
    }

    protected /* synthetic */ String _ebean_get_fileName() {
        this._ebean_intercept.preGetter(7);
        return this.fileName;
    }

    protected /* synthetic */ void _ebean_set_fileName(String newValue) {
        this._ebean_intercept.preSetter(true, 7, (Object)this._ebean_get_fileName(), (Object)newValue);
        this.fileName = newValue;
    }

    protected /* synthetic */ String _ebean_getni_fileName() {
        return this.fileName;
    }

    protected /* synthetic */ void _ebean_setni_fileName(String _newValue) {
        this.fileName = _newValue;
        this._ebean_intercept.setLoadedProperty(7);
    }

    protected /* synthetic */ FilterComparator.Text _ebean_get_fileNameComparator() {
        this._ebean_intercept.preGetter(8);
        return this.fileNameComparator;
    }

    protected /* synthetic */ void _ebean_set_fileNameComparator(FilterComparator.Text newValue) {
        this._ebean_intercept.preSetter(true, 8, (Object)this._ebean_get_fileNameComparator(), (Object)newValue);
        this.fileNameComparator = newValue;
    }

    protected /* synthetic */ FilterComparator.Text _ebean_getni_fileNameComparator() {
        return this.fileNameComparator;
    }

    protected /* synthetic */ void _ebean_setni_fileNameComparator(FilterComparator.Text _newValue) {
        this.fileNameComparator = _newValue;
        this._ebean_intercept.setLoadedProperty(8);
    }

    @Override
    public /* synthetic */ Object _ebean_getField(int index) {
        switch (index) {
            case 0: {
                return this._ebean_getni_id();
            }
            case 1: {
                return this._ebean_getni_user();
            }
            case 2: {
                return this._ebean_getni_fromDate();
            }
            case 3: {
                return this._ebean_getni_toDate();
            }
            case 4: {
                return this._ebean_getni_dateComparator();
            }
            case 5: {
                return this.exportFileActive;
            }
            case 6: {
                return this.automaticExportId;
            }
            case 7: {
                return this.fileName;
            }
            case 8: {
                return this.fileNameComparator;
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    @Override
    public /* synthetic */ Object _ebean_getFieldIntercept(int index) {
        switch (index) {
            case 0: {
                return this._ebean_get_id();
            }
            case 1: {
                return this._ebean_get_user();
            }
            case 2: {
                return this._ebean_get_fromDate();
            }
            case 3: {
                return this._ebean_get_toDate();
            }
            case 4: {
                return this._ebean_get_dateComparator();
            }
            case 5: {
                return this._ebean_get_exportFileActive();
            }
            case 6: {
                return this._ebean_get_automaticExportId();
            }
            case 7: {
                return this._ebean_get_fileName();
            }
            case 8: {
                return this._ebean_get_fileNameComparator();
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    @Override
    public /* synthetic */ void _ebean_setField(int index, Object o) {
        switch (index) {
            case 0: {
                this._ebean_setni_id((Integer)o);
                return;
            }
            case 1: {
                this._ebean_setni_user((User)o);
                return;
            }
            case 2: {
                this._ebean_setni_fromDate((Date)o);
                return;
            }
            case 3: {
                this._ebean_setni_toDate((Date)o);
                return;
            }
            case 4: {
                this._ebean_setni_dateComparator((FilterComparator.Date)((Object)o));
                return;
            }
            case 5: {
                this._ebean_setni_exportFileActive((Boolean)o);
                return;
            }
            case 6: {
                this._ebean_setni_automaticExportId((Integer)o);
                return;
            }
            case 7: {
                this._ebean_setni_fileName((String)o);
                return;
            }
            case 8: {
                this._ebean_setni_fileNameComparator((FilterComparator.Text)((Object)o));
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    @Override
    public /* synthetic */ void _ebean_setFieldIntercept(int index, Object o) {
        switch (index) {
            case 0: {
                this._ebean_set_id((Integer)o);
                return;
            }
            case 1: {
                this._ebean_set_user((User)o);
                return;
            }
            case 2: {
                this._ebean_set_fromDate((Date)o);
                return;
            }
            case 3: {
                this._ebean_set_toDate((Date)o);
                return;
            }
            case 4: {
                this._ebean_set_dateComparator((FilterComparator.Date)((Object)o));
                return;
            }
            case 5: {
                this._ebean_set_exportFileActive((Boolean)o);
                return;
            }
            case 6: {
                this._ebean_set_automaticExportId((Integer)o);
                return;
            }
            case 7: {
                this._ebean_set_fileName((String)o);
                return;
            }
            case 8: {
                this._ebean_set_fileNameComparator((FilterComparator.Text)((Object)o));
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    @Override
    public /* synthetic */ void _ebean_setEmbeddedLoaded() {
    }

    @Override
    public /* synthetic */ boolean _ebean_isEmbeddedNewOrDirty() {
        return false;
    }

    @Override
    public /* synthetic */ Object _ebean_newInstance() {
        return new ExportFileFilter();
    }
}

