/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.database.vo;

import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.Account;
import de.businesslogics.banking.database.vo.AutomaticExport;
import de.businesslogics.banking.database.vo.CmPage;
import de.businesslogics.banking.database.vo.CmStatement;
import de.businesslogics.banking.database.vo.Tenant;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.banking.database.vo.WorkspaceFile;
import io.ebean.Expr;
import io.ebean.Expression;
import io.ebean.ExpressionList;
import io.ebean.Query;
import io.ebean.SqlUpdate;
import io.ebean.bean.BeanCollection;
import io.ebean.bean.EntityBean;
import io.ebean.bean.EntityBeanIntercept;
import io.ebean.common.BeanSet;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;

@Entity
public class ExportFile
implements EntityBean {
    @Id
    private Integer id;
    @ManyToOne
    private WorkspaceFile workspaceFile;
    private Timestamp lastUpdate;
    @ManyToMany
    private Set<Account> accounts;
    @ManyToMany
    @JoinTable(name="export_file_aut_export")
    private Set<AutomaticExport> exports;
    public static /* synthetic */ String[] _ebean_props;
    protected /* synthetic */ EntityBeanIntercept _ebean_intercept;
    protected transient /* synthetic */ Object _ebean_identity;

    public ExportFile() {
        this._ebean_intercept = new EntityBeanIntercept((Object)this);
    }

    public static ExportFile findByIdAndUser(int id, User user) {
        return (ExportFile)ExportFile.findQueryByUser(user).where().eq("id", (Object)id).findOne();
    }

    public static Query<ExportFile> findOldFiles(Date older) {
        return DB.find(ExportFile.class).where().lt("lastUpdate", (Object)older).query();
    }

    public static List<ExportFile> findForUser(User user) {
        return ExportFile.findQueryByUser(user).findList();
    }

    public static List<ExportFile> findForExportIdsAndUser(List<Integer> exportIds, User user) {
        return ExportFile.findForExportIdsAndUser(exportIds, user, null);
    }

    public static List<ExportFile> findForExportIdsAndUser(List<Integer> exportIds, User user, Tenant tenant) {
        ExpressionList expr = ExportFile.findQueryByUser(user).where();
        if (exportIds != null && !exportIds.isEmpty()) {
            expr = expr.in("exports.id", exportIds);
        }
        if (tenant != null) {
            expr = expr.in("accounts.bank.tenant", new Object[]{tenant});
        }
        return expr.findList();
    }

    public static Query<ExportFile> findQueryByUser(User user) {
        List userAccounts = Account.findAccountsQuery(user, true).findIds();
        List hiddenIds = ExportFile.findNotInAccountIDs(userAccounts).findIds();
        ExpressionList expr = DB.find(ExportFile.class).where();
        expr = expr.not(Expr.or((Expression)Expr.isNull((String)"accounts"), (Expression)Expr.in((String)"id", (Collection)hiddenIds)));
        return expr.query();
    }

    private static Query<ExportFile> findNotInAccountIDs(List<Object> accountIds) {
        return DB.find(ExportFile.class).where().not(Expr.in((String)"accounts.id", accountIds)).query();
    }

    public static int deleteAssociationsWithAccount(int accountId) {
        SqlUpdate deleteAssociations = DB.sqlUpdate("DELETE FROM export_file_account WHERE account_id = :account_id");
        deleteAssociations.setParameter("account_id", (Object)accountId);
        return deleteAssociations.execute();
    }

    public Integer getId() {
        return this._ebean_get_id();
    }

    public void setId(Integer id) {
        this._ebean_set_id(id);
    }

    public Timestamp getLastUpdate() {
        return this._ebean_get_lastUpdate();
    }

    public void setLastUpdate(Timestamp lastUpdate) {
        this._ebean_set_lastUpdate(lastUpdate);
    }

    public WorkspaceFile getWorkspaceFile() {
        return this._ebean_get_workspaceFile();
    }

    public void setWorkspaceFile(WorkspaceFile workspaceFile) {
        this._ebean_set_workspaceFile(workspaceFile);
    }

    public Set<Account> getAccounts() {
        return this._ebean_get_accounts();
    }

    public Set<AutomaticExport> getExports() {
        return this._ebean_get_exports();
    }

    public void addAccounts(List<CmStatement> statements, List<CmPage> pages) {
        if (this._ebean_get_accounts() == null) {
            this._ebean_set_accounts(new HashSet());
        }
        for (CmStatement statement : statements) {
            this._ebean_get_accounts().add(statement.getAccount());
        }
        for (CmPage page : pages) {
            this._ebean_get_accounts().add(page.getStatement().getAccount());
        }
        DB.save(this);
    }

    public String getTenantName() {
        if (!this._ebean_get_accounts().isEmpty()) {
            Account export = (Account)this._ebean_get_accounts().iterator().next();
            return export.getBank().getTenant().getName();
        }
        return "";
    }

    public void addExport(AutomaticExport export) {
        if (this._ebean_get_exports() == null) {
            this._ebean_set_exports(new HashSet());
        }
        this._ebean_get_exports().add(export);
        DB.save(this);
    }

    public void save() {
        if (this.getId() == null) {
            DB.save(this);
        } else {
            DB.update(this);
        }
    }

    static {
        _ebean_props = new String[]{"id", "workspaceFile", "lastUpdate", "accounts", "exports"};
    }

    public /* synthetic */ String[] _ebean_getPropertyNames() {
        return _ebean_props;
    }

    public /* synthetic */ String _ebean_getPropertyName(int pos) {
        return _ebean_props[pos];
    }

    public /* synthetic */ EntityBeanIntercept _ebean_getIntercept() {
        return this._ebean_intercept;
    }

    public /* synthetic */ EntityBeanIntercept _ebean_intercept() {
        if (this._ebean_intercept == null) {
            this._ebean_intercept = new EntityBeanIntercept((Object)this);
        }
        return this._ebean_intercept;
    }

    protected /* synthetic */ Integer _ebean_get_id() {
        this._ebean_intercept.preGetId();
        return this.id;
    }

    protected /* synthetic */ void _ebean_set_id(Integer newValue) {
        this._ebean_intercept.preSetter(false, 0, (Object)this.id, (Object)newValue);
        this.id = newValue;
    }

    protected /* synthetic */ Integer _ebean_getni_id() {
        return this.id;
    }

    protected /* synthetic */ void _ebean_setni_id(Integer _newValue) {
        this.id = _newValue;
        this._ebean_intercept.setLoadedProperty(0);
    }

    protected /* synthetic */ WorkspaceFile _ebean_get_workspaceFile() {
        this._ebean_intercept.preGetter(1);
        return this.workspaceFile;
    }

    protected /* synthetic */ void _ebean_set_workspaceFile(WorkspaceFile newValue) {
        this._ebean_intercept.preSetter(true, 1, (Object)this._ebean_get_workspaceFile(), (Object)newValue);
        this.workspaceFile = newValue;
    }

    protected /* synthetic */ WorkspaceFile _ebean_getni_workspaceFile() {
        return this.workspaceFile;
    }

    protected /* synthetic */ void _ebean_setni_workspaceFile(WorkspaceFile _newValue) {
        this.workspaceFile = _newValue;
        this._ebean_intercept.setLoadedProperty(1);
    }

    protected /* synthetic */ Timestamp _ebean_get_lastUpdate() {
        this._ebean_intercept.preGetter(2);
        return this.lastUpdate;
    }

    protected /* synthetic */ void _ebean_set_lastUpdate(Timestamp newValue) {
        this._ebean_intercept.preSetter(true, 2, (Object)this._ebean_get_lastUpdate(), (Object)newValue);
        this.lastUpdate = newValue;
    }

    protected /* synthetic */ Timestamp _ebean_getni_lastUpdate() {
        return this.lastUpdate;
    }

    protected /* synthetic */ void _ebean_setni_lastUpdate(Timestamp _newValue) {
        this.lastUpdate = _newValue;
        this._ebean_intercept.setLoadedProperty(2);
    }

    protected /* synthetic */ Set _ebean_get_accounts() {
        this._ebean_intercept.preGetter(3);
        if (this.accounts == null) {
            this.accounts = new BeanSet();
            this._ebean_intercept.initialisedMany(3);
            ((BeanCollection)this.accounts).setModifyListening(BeanCollection.ModifyListenMode.ALL);
        }
        return this.accounts;
    }

    protected /* synthetic */ void _ebean_set_accounts(Set newValue) {
        this._ebean_intercept.preSetterMany(false, 3, this.accounts, (Object)newValue);
        this.accounts = newValue;
    }

    protected /* synthetic */ Set _ebean_getni_accounts() {
        return this.accounts;
    }

    protected /* synthetic */ void _ebean_setni_accounts(Set _newValue) {
        this.accounts = _newValue;
        this._ebean_intercept.setLoadedProperty(3);
    }

    protected /* synthetic */ Set _ebean_get_exports() {
        this._ebean_intercept.preGetter(4);
        if (this.exports == null) {
            this.exports = new BeanSet();
            this._ebean_intercept.initialisedMany(4);
            ((BeanCollection)this.exports).setModifyListening(BeanCollection.ModifyListenMode.ALL);
        }
        return this.exports;
    }

    protected /* synthetic */ void _ebean_set_exports(Set newValue) {
        this._ebean_intercept.preSetterMany(false, 4, this.exports, (Object)newValue);
        this.exports = newValue;
    }

    protected /* synthetic */ Set _ebean_getni_exports() {
        return this.exports;
    }

    protected /* synthetic */ void _ebean_setni_exports(Set _newValue) {
        this.exports = _newValue;
        this._ebean_intercept.setLoadedProperty(4);
    }

    public /* synthetic */ Object _ebean_getField(int index) {
        switch (index) {
            case 0: {
                return this.id;
            }
            case 1: {
                return this.workspaceFile;
            }
            case 2: {
                return this.lastUpdate;
            }
            case 3: {
                return this.accounts;
            }
            case 4: {
                return this.exports;
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    public /* synthetic */ Object _ebean_getFieldIntercept(int index) {
        switch (index) {
            case 0: {
                return this._ebean_get_id();
            }
            case 1: {
                return this._ebean_get_workspaceFile();
            }
            case 2: {
                return this._ebean_get_lastUpdate();
            }
            case 3: {
                return this._ebean_get_accounts();
            }
            case 4: {
                return this._ebean_get_exports();
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    public /* synthetic */ void _ebean_setField(int index, Object o) {
        switch (index) {
            case 0: {
                this._ebean_setni_id((Integer)o);
                return;
            }
            case 1: {
                this._ebean_setni_workspaceFile((WorkspaceFile)o);
                return;
            }
            case 2: {
                this._ebean_setni_lastUpdate((Timestamp)o);
                return;
            }
            case 3: {
                this._ebean_setni_accounts((Set)o);
                return;
            }
            case 4: {
                this._ebean_setni_exports((Set)o);
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    public /* synthetic */ void _ebean_setFieldIntercept(int index, Object o) {
        switch (index) {
            case 0: {
                this._ebean_set_id((Integer)o);
                return;
            }
            case 1: {
                this._ebean_set_workspaceFile((WorkspaceFile)o);
                return;
            }
            case 2: {
                this._ebean_set_lastUpdate((Timestamp)o);
                return;
            }
            case 3: {
                this._ebean_set_accounts((Set)o);
                return;
            }
            case 4: {
                this._ebean_set_exports((Set)o);
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private /* synthetic */ Object _ebean_getIdentity() {
        ExportFile exportFile = this;
        synchronized (exportFile) {
            if (this._ebean_identity != null) {
                return this._ebean_identity;
            }
            Object tmpId = this._ebean_getField(0);
            this._ebean_identity = tmpId != null ? tmpId : new Object();
            return this._ebean_identity;
        }
    }

    public /* synthetic */ boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        return this._ebean_getIdentity().equals(((ExportFile)obj)._ebean_getIdentity());
    }

    public /* synthetic */ int hashCode() {
        return this._ebean_getIdentity().hashCode();
    }

    public /* synthetic */ void _ebean_setEmbeddedLoaded() {
    }

    public /* synthetic */ boolean _ebean_isEmbeddedNewOrDirty() {
        return false;
    }

    public /* synthetic */ Object _ebean_newInstance() {
        return new ExportFile();
    }
}

