/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.database.vo;

import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.Account;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.DsSigningInfo;
import de.businesslogics.banking.database.vo.PaymentTransferType;
import de.businesslogics.banking.database.vo.Send;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.banking.database.vo.WorkspaceFile;
import io.ebean.Query;
import io.ebean.SqlUpdate;
import io.ebean.Update;
import io.ebean.bean.BeanCollection;
import io.ebean.bean.EntityBean;
import io.ebean.bean.EntityBeanIntercept;
import io.ebean.common.BeanList;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;

@Entity
public class DsOrderDetails
implements EntityBean {
    private static final int PROTOCOL_DATE_LIMIT = 28;
    @Id
    private Integer id;
    @ManyToOne
    private BankSettings bank;
    private PaymentTransferType.PmtType pmtType;
    @Column(nullable=false, length=50)
    private String fileType;
    @Column(nullable=false, length=4)
    private String orderId;
    @Column(length=256)
    private String filename;
    @Column(nullable=false)
    private Timestamp submissionDate;
    @Column(length=35, nullable=false)
    private String customerId;
    @Column(length=35)
    private String userId;
    @Column(length=40)
    private String userName;
    private Integer numSigDone;
    private Integer numSigRequired;
    @OneToMany(cascade={CascadeType.ALL})
    @OrderBy(value="signDate")
    private List<DsSigningInfo> signingInfos;
    @Column(precision=38, scale=3)
    private BigDecimal amount;
    @Column(length=3)
    private String amountCurrency;
    private Long datasize;
    @Lob
    private byte[] ticket;
    @ManyToOne
    private WorkspaceFile dataFile;
    private State state;
    @Column(length=4)
    private String errorCode;
    @Column
    private String additionalOrderInfo;
    @Column(name="tp")
    private Type type;
    @ManyToMany(fetch=FetchType.LAZY)
    private List<Account> accounts;
    public static /* synthetic */ String[] _ebean_props;
    protected /* synthetic */ EntityBeanIntercept _ebean_intercept;
    protected transient /* synthetic */ Object _ebean_identity;

    public DsOrderDetails() {
        this._ebean_intercept = new EntityBeanIntercept((Object)this);
    }

    public static List<DsOrderDetails> findByOrder(BankSettings bank, String fileType, String orderId, Timestamp submissionDate, String customerId) {
        Calendar start = Calendar.getInstance();
        start.setTime(submissionDate);
        start.add(5, -28);
        Calendar end = Calendar.getInstance();
        end.setTime(submissionDate);
        end.add(5, 28);
        return DB.find(DsOrderDetails.class).where().eq("bank", (Object)bank).eq("fileType", (Object)fileType).eq("orderId", (Object)orderId).between("submissionDate", (Object)start.getTime(), (Object)end.getTime()).eq("customerId", (Object)customerId).findList();
    }

    public static List<DsOrderDetails> findByAge(Date olderThan, Type type) {
        return DB.find(DsOrderDetails.class).where().eq("type", (Object)type).lt("submissionDate", (Object)olderThan).findList();
    }

    public static int findCountByBank(BankSettings bank) {
        return DB.find(DsOrderDetails.class).where().eq("bank", (Object)bank).findCount();
    }

    public static int findCountByAccount(Account a) {
        return DB.find(DsOrderDetails.class).where().in("accounts", new Object[]{a}).findCount();
    }

    public static DsOrderDetails findBySend(Send s) {
        String orderType = s.getOrderType();
        String orderTypeOrBTF = "BTU".equals(orderType) || "FUL".equals(orderType) ? s.getFileTypeOrBTF() : orderType;
        Calendar start = Calendar.getInstance();
        start.setTime(s.getSent());
        start.add(5, -1);
        Calendar end = Calendar.getInstance();
        end.setTime(s.getSent());
        end.add(5, 30);
        List orderDetailsList = DB.find(DsOrderDetails.class).where().eq("bank", (Object)s.getBank()).eq("fileType", (Object)orderTypeOrBTF).eq("orderId", (Object)s.getOrderNumber()).between("submissionDate", (Object)start.getTime(), (Object)end.getTime()).findList();
        if (orderDetailsList != null && orderDetailsList.size() == 1) {
            return (DsOrderDetails)orderDetailsList.get(0);
        }
        return null;
    }

    public static int deleteByBank(BankSettings bank) {
        Update<DsSigningInfo> deleteInfo = DB.createUpdate(DsSigningInfo.class, "DELETE FROM DsSigningInfo WHERE dsOrderDetails IN (SELECT id FROM ds_order_details WHERE bank_id=:bank)");
        deleteInfo.setParameter("bank", (Object)bank.getBankId());
        deleteInfo.execute();
        SqlUpdate deleteDsOrderDetailsAccount = DB.sqlUpdate("DELETE from ds_order_details_account where ds_order_details_id IN (SELECT id FROM ds_order_details WHERE bank_id=:bank)");
        deleteDsOrderDetailsAccount.setParameter("bank", (Object)bank.getBankId());
        deleteDsOrderDetailsAccount.execute();
        Update<DsOrderDetails> delete = DB.createUpdate(DsOrderDetails.class, "DELETE FROM DsOrderDetails WHERE bank=:bank");
        delete.setParameter("bank", (Object)bank.getBankId());
        return delete.execute();
    }

    public static void delete(DsOrderDetails dsOrderDetails) {
        SqlUpdate deleteDsOrderDetailsAccount = DB.sqlUpdate("DELETE from ds_order_details_account where ds_order_details_id=:id");
        deleteDsOrderDetailsAccount.setParameter("id", (Object)dsOrderDetails.getId());
        deleteDsOrderDetailsAccount.execute();
        dsOrderDetails.delete();
    }

    public static Query<DsOrderDetails> findByTypeAndBanks(Type type, User user) {
        return DB.find(DsOrderDetails.class).where().eq("type", (Object)type).eq("bank.users.user", (Object)user).order("submissionDate DESC").query();
    }

    public static Query<DsOrderDetails> findByBankAndTypeWithOneSignature(BankSettings bank, Type type) {
        return DB.find(DsOrderDetails.class).where().eq("bank", (Object)bank).eq("type", (Object)type).ge("numSigDone", (Object)1).order("submissionDate DESC").query();
    }

    public Integer getId() {
        return this._ebean_get_id();
    }

    public void setId(Integer id) {
        this._ebean_set_id(id);
    }

    public BankSettings getBank() {
        return this._ebean_get_bank();
    }

    public void setBank(BankSettings bank) {
        this._ebean_set_bank(bank);
    }

    public PaymentTransferType.PmtType getPmtType() {
        return this._ebean_get_pmtType();
    }

    public void setPmtType(PaymentTransferType.PmtType pmtType) {
        this._ebean_set_pmtType(pmtType);
    }

    public String getFileType() {
        return this._ebean_get_fileType();
    }

    public void setFileType(String fileType) {
        this._ebean_set_fileType(fileType);
    }

    public String getOrderId() {
        return this._ebean_get_orderId();
    }

    public void setOrderId(String orderId) {
        this._ebean_set_orderId(orderId);
    }

    public String getFilename() {
        return this._ebean_get_filename();
    }

    public void setFilename(String filename) {
        this._ebean_set_filename(filename);
    }

    public Timestamp getSubmissionDate() {
        return this._ebean_get_submissionDate();
    }

    public void setSubmissionDate(Timestamp submissionDate) {
        this._ebean_set_submissionDate(submissionDate);
    }

    public String getCustomerId() {
        return this._ebean_get_customerId();
    }

    public void setCustomerId(String customerId) {
        this._ebean_set_customerId(customerId);
    }

    public String getUserId() {
        return this._ebean_get_userId();
    }

    public void setUserId(String userId) {
        this._ebean_set_userId(userId);
    }

    public String getUserName() {
        return this._ebean_get_userName();
    }

    public void setUserName(String userName) {
        if (userName != null && userName.length() > 40) {
            this._ebean_set_userName(userName.substring(0, 40));
        } else {
            this._ebean_set_userName(userName);
        }
    }

    public Integer getNumSigDone() {
        return this._ebean_get_numSigDone();
    }

    public void setNumSigDone(Integer numSigDone) {
        this._ebean_set_numSigDone(numSigDone);
    }

    public Integer getNumSigRequired() {
        return this._ebean_get_numSigRequired();
    }

    public void setNumSigRequired(Integer numSigRequired) {
        this._ebean_set_numSigRequired(numSigRequired);
    }

    public List<DsSigningInfo> getSigningInfos() {
        return this._ebean_get_signingInfos();
    }

    public void setSigningInfos(List<DsSigningInfo> signingInfos) {
        this._ebean_set_signingInfos(signingInfos);
    }

    public BigDecimal getAmount() {
        return this._ebean_get_amount();
    }

    public void setAmount(BigDecimal amount) {
        this._ebean_set_amount(amount);
    }

    public String getAmountCurrency() {
        return this._ebean_get_amountCurrency();
    }

    public void setAmountCurrency(String amountCurrency) {
        this._ebean_set_amountCurrency(amountCurrency);
    }

    public Long getDatasize() {
        return this._ebean_get_datasize();
    }

    public void setDatasize(Long datasize) {
        this._ebean_set_datasize(datasize);
    }

    public byte[] getTicket() {
        return this._ebean_get_ticket();
    }

    public void setTicket(byte[] ticket) {
        this._ebean_set_ticket(ticket);
    }

    public State getState() {
        return this._ebean_get_state();
    }

    public void setState(State state) {
        this._ebean_set_state(state);
    }

    public Type getType() {
        return this._ebean_get_type();
    }

    public void setType(Type type) {
        this._ebean_set_type(type);
    }

    public String getErrorCode() {
        return this._ebean_get_errorCode();
    }

    public void setErrorCode(String errorCode) {
        this._ebean_set_errorCode(errorCode);
    }

    public String getAdditionalOrderInfo() {
        return this._ebean_get_additionalOrderInfo();
    }

    public void setAdditionalOrderInfo(String additionalOrderInfo) {
        if (additionalOrderInfo != null && additionalOrderInfo.length() > 255) {
            this._ebean_set_additionalOrderInfo(additionalOrderInfo.substring(0, 255));
        } else {
            this._ebean_set_additionalOrderInfo(additionalOrderInfo);
        }
    }

    public void save() {
        if (this.getId() == null) {
            DB.save(this);
        } else {
            DB.update(this);
        }
    }

    public void delete() {
        DB.delete(this);
    }

    public List<Account> getAccounts() {
        return this._ebean_get_accounts();
    }

    public void setAccounts(List<Account> accounts) {
        this._ebean_set_accounts(accounts);
    }

    public WorkspaceFile getDataFile() {
        return this._ebean_get_dataFile();
    }

    public void setDataFile(WorkspaceFile dataFile) {
        this._ebean_set_dataFile(dataFile);
    }

    static {
        _ebean_props = new String[]{"id", "bank", "pmtType", "fileType", "orderId", "filename", "submissionDate", "customerId", "userId", "userName", "numSigDone", "numSigRequired", "signingInfos", "amount", "amountCurrency", "datasize", "ticket", "dataFile", "state", "errorCode", "additionalOrderInfo", "type", "accounts"};
    }

    public /* synthetic */ String[] _ebean_getPropertyNames() {
        return _ebean_props;
    }

    public /* synthetic */ String _ebean_getPropertyName(int pos) {
        return _ebean_props[pos];
    }

    public /* synthetic */ EntityBeanIntercept _ebean_getIntercept() {
        return this._ebean_intercept;
    }

    public /* synthetic */ EntityBeanIntercept _ebean_intercept() {
        if (this._ebean_intercept == null) {
            this._ebean_intercept = new EntityBeanIntercept((Object)this);
        }
        return this._ebean_intercept;
    }

    protected /* synthetic */ Integer _ebean_get_id() {
        this._ebean_intercept.preGetId();
        return this.id;
    }

    protected /* synthetic */ void _ebean_set_id(Integer newValue) {
        this._ebean_intercept.preSetter(false, 0, (Object)this.id, (Object)newValue);
        this.id = newValue;
    }

    protected /* synthetic */ Integer _ebean_getni_id() {
        return this.id;
    }

    protected /* synthetic */ void _ebean_setni_id(Integer _newValue) {
        this.id = _newValue;
        this._ebean_intercept.setLoadedProperty(0);
    }

    protected /* synthetic */ BankSettings _ebean_get_bank() {
        this._ebean_intercept.preGetter(1);
        return this.bank;
    }

    protected /* synthetic */ void _ebean_set_bank(BankSettings newValue) {
        this._ebean_intercept.preSetter(true, 1, (Object)this._ebean_get_bank(), (Object)newValue);
        this.bank = newValue;
    }

    protected /* synthetic */ BankSettings _ebean_getni_bank() {
        return this.bank;
    }

    protected /* synthetic */ void _ebean_setni_bank(BankSettings _newValue) {
        this.bank = _newValue;
        this._ebean_intercept.setLoadedProperty(1);
    }

    protected /* synthetic */ PaymentTransferType.PmtType _ebean_get_pmtType() {
        this._ebean_intercept.preGetter(2);
        return this.pmtType;
    }

    protected /* synthetic */ void _ebean_set_pmtType(PaymentTransferType.PmtType newValue) {
        this._ebean_intercept.preSetter(true, 2, (Object)this._ebean_get_pmtType(), (Object)newValue);
        this.pmtType = newValue;
    }

    protected /* synthetic */ PaymentTransferType.PmtType _ebean_getni_pmtType() {
        return this.pmtType;
    }

    protected /* synthetic */ void _ebean_setni_pmtType(PaymentTransferType.PmtType _newValue) {
        this.pmtType = _newValue;
        this._ebean_intercept.setLoadedProperty(2);
    }

    protected /* synthetic */ String _ebean_get_fileType() {
        this._ebean_intercept.preGetter(3);
        return this.fileType;
    }

    protected /* synthetic */ void _ebean_set_fileType(String newValue) {
        this._ebean_intercept.preSetter(true, 3, (Object)this._ebean_get_fileType(), (Object)newValue);
        this.fileType = newValue;
    }

    protected /* synthetic */ String _ebean_getni_fileType() {
        return this.fileType;
    }

    protected /* synthetic */ void _ebean_setni_fileType(String _newValue) {
        this.fileType = _newValue;
        this._ebean_intercept.setLoadedProperty(3);
    }

    protected /* synthetic */ String _ebean_get_orderId() {
        this._ebean_intercept.preGetter(4);
        return this.orderId;
    }

    protected /* synthetic */ void _ebean_set_orderId(String newValue) {
        this._ebean_intercept.preSetter(true, 4, (Object)this._ebean_get_orderId(), (Object)newValue);
        this.orderId = newValue;
    }

    protected /* synthetic */ String _ebean_getni_orderId() {
        return this.orderId;
    }

    protected /* synthetic */ void _ebean_setni_orderId(String _newValue) {
        this.orderId = _newValue;
        this._ebean_intercept.setLoadedProperty(4);
    }

    protected /* synthetic */ String _ebean_get_filename() {
        this._ebean_intercept.preGetter(5);
        return this.filename;
    }

    protected /* synthetic */ void _ebean_set_filename(String newValue) {
        this._ebean_intercept.preSetter(true, 5, (Object)this._ebean_get_filename(), (Object)newValue);
        this.filename = newValue;
    }

    protected /* synthetic */ String _ebean_getni_filename() {
        return this.filename;
    }

    protected /* synthetic */ void _ebean_setni_filename(String _newValue) {
        this.filename = _newValue;
        this._ebean_intercept.setLoadedProperty(5);
    }

    protected /* synthetic */ Timestamp _ebean_get_submissionDate() {
        this._ebean_intercept.preGetter(6);
        return this.submissionDate;
    }

    protected /* synthetic */ void _ebean_set_submissionDate(Timestamp newValue) {
        this._ebean_intercept.preSetter(true, 6, (Object)this._ebean_get_submissionDate(), (Object)newValue);
        this.submissionDate = newValue;
    }

    protected /* synthetic */ Timestamp _ebean_getni_submissionDate() {
        return this.submissionDate;
    }

    protected /* synthetic */ void _ebean_setni_submissionDate(Timestamp _newValue) {
        this.submissionDate = _newValue;
        this._ebean_intercept.setLoadedProperty(6);
    }

    protected /* synthetic */ String _ebean_get_customerId() {
        this._ebean_intercept.preGetter(7);
        return this.customerId;
    }

    protected /* synthetic */ void _ebean_set_customerId(String newValue) {
        this._ebean_intercept.preSetter(true, 7, (Object)this._ebean_get_customerId(), (Object)newValue);
        this.customerId = newValue;
    }

    protected /* synthetic */ String _ebean_getni_customerId() {
        return this.customerId;
    }

    protected /* synthetic */ void _ebean_setni_customerId(String _newValue) {
        this.customerId = _newValue;
        this._ebean_intercept.setLoadedProperty(7);
    }

    protected /* synthetic */ String _ebean_get_userId() {
        this._ebean_intercept.preGetter(8);
        return this.userId;
    }

    protected /* synthetic */ void _ebean_set_userId(String newValue) {
        this._ebean_intercept.preSetter(true, 8, (Object)this._ebean_get_userId(), (Object)newValue);
        this.userId = newValue;
    }

    protected /* synthetic */ String _ebean_getni_userId() {
        return this.userId;
    }

    protected /* synthetic */ void _ebean_setni_userId(String _newValue) {
        this.userId = _newValue;
        this._ebean_intercept.setLoadedProperty(8);
    }

    protected /* synthetic */ String _ebean_get_userName() {
        this._ebean_intercept.preGetter(9);
        return this.userName;
    }

    protected /* synthetic */ void _ebean_set_userName(String newValue) {
        this._ebean_intercept.preSetter(true, 9, (Object)this._ebean_get_userName(), (Object)newValue);
        this.userName = newValue;
    }

    protected /* synthetic */ String _ebean_getni_userName() {
        return this.userName;
    }

    protected /* synthetic */ void _ebean_setni_userName(String _newValue) {
        this.userName = _newValue;
        this._ebean_intercept.setLoadedProperty(9);
    }

    protected /* synthetic */ Integer _ebean_get_numSigDone() {
        this._ebean_intercept.preGetter(10);
        return this.numSigDone;
    }

    protected /* synthetic */ void _ebean_set_numSigDone(Integer newValue) {
        this._ebean_intercept.preSetter(true, 10, (Object)this._ebean_get_numSigDone(), (Object)newValue);
        this.numSigDone = newValue;
    }

    protected /* synthetic */ Integer _ebean_getni_numSigDone() {
        return this.numSigDone;
    }

    protected /* synthetic */ void _ebean_setni_numSigDone(Integer _newValue) {
        this.numSigDone = _newValue;
        this._ebean_intercept.setLoadedProperty(10);
    }

    protected /* synthetic */ Integer _ebean_get_numSigRequired() {
        this._ebean_intercept.preGetter(11);
        return this.numSigRequired;
    }

    protected /* synthetic */ void _ebean_set_numSigRequired(Integer newValue) {
        this._ebean_intercept.preSetter(true, 11, (Object)this._ebean_get_numSigRequired(), (Object)newValue);
        this.numSigRequired = newValue;
    }

    protected /* synthetic */ Integer _ebean_getni_numSigRequired() {
        return this.numSigRequired;
    }

    protected /* synthetic */ void _ebean_setni_numSigRequired(Integer _newValue) {
        this.numSigRequired = _newValue;
        this._ebean_intercept.setLoadedProperty(11);
    }

    protected /* synthetic */ List _ebean_get_signingInfos() {
        this._ebean_intercept.preGetter(12);
        if (this.signingInfos == null) {
            this.signingInfos = new BeanList();
            this._ebean_intercept.initialisedMany(12);
        }
        return this.signingInfos;
    }

    protected /* synthetic */ void _ebean_set_signingInfos(List newValue) {
        this._ebean_intercept.preSetterMany(false, 12, this.signingInfos, (Object)newValue);
        this.signingInfos = newValue;
    }

    protected /* synthetic */ List _ebean_getni_signingInfos() {
        return this.signingInfos;
    }

    protected /* synthetic */ void _ebean_setni_signingInfos(List _newValue) {
        this.signingInfos = _newValue;
        this._ebean_intercept.setLoadedProperty(12);
    }

    protected /* synthetic */ BigDecimal _ebean_get_amount() {
        this._ebean_intercept.preGetter(13);
        return this.amount;
    }

    protected /* synthetic */ void _ebean_set_amount(BigDecimal newValue) {
        this._ebean_intercept.preSetter(true, 13, (Object)this._ebean_get_amount(), (Object)newValue);
        this.amount = newValue;
    }

    protected /* synthetic */ BigDecimal _ebean_getni_amount() {
        return this.amount;
    }

    protected /* synthetic */ void _ebean_setni_amount(BigDecimal _newValue) {
        this.amount = _newValue;
        this._ebean_intercept.setLoadedProperty(13);
    }

    protected /* synthetic */ String _ebean_get_amountCurrency() {
        this._ebean_intercept.preGetter(14);
        return this.amountCurrency;
    }

    protected /* synthetic */ void _ebean_set_amountCurrency(String newValue) {
        this._ebean_intercept.preSetter(true, 14, (Object)this._ebean_get_amountCurrency(), (Object)newValue);
        this.amountCurrency = newValue;
    }

    protected /* synthetic */ String _ebean_getni_amountCurrency() {
        return this.amountCurrency;
    }

    protected /* synthetic */ void _ebean_setni_amountCurrency(String _newValue) {
        this.amountCurrency = _newValue;
        this._ebean_intercept.setLoadedProperty(14);
    }

    protected /* synthetic */ Long _ebean_get_datasize() {
        this._ebean_intercept.preGetter(15);
        return this.datasize;
    }

    protected /* synthetic */ void _ebean_set_datasize(Long newValue) {
        this._ebean_intercept.preSetter(true, 15, (Object)this._ebean_get_datasize(), (Object)newValue);
        this.datasize = newValue;
    }

    protected /* synthetic */ Long _ebean_getni_datasize() {
        return this.datasize;
    }

    protected /* synthetic */ void _ebean_setni_datasize(Long _newValue) {
        this.datasize = _newValue;
        this._ebean_intercept.setLoadedProperty(15);
    }

    protected /* synthetic */ byte[] _ebean_get_ticket() {
        this._ebean_intercept.preGetter(16);
        return this.ticket;
    }

    protected /* synthetic */ void _ebean_set_ticket(byte[] newValue) {
        this._ebean_intercept.preSetter(true, 16, this._ebean_get_ticket(), newValue);
        this.ticket = newValue;
    }

    protected /* synthetic */ byte[] _ebean_getni_ticket() {
        return this.ticket;
    }

    protected /* synthetic */ void _ebean_setni_ticket(byte[] _newValue) {
        this.ticket = _newValue;
        this._ebean_intercept.setLoadedProperty(16);
    }

    protected /* synthetic */ WorkspaceFile _ebean_get_dataFile() {
        this._ebean_intercept.preGetter(17);
        return this.dataFile;
    }

    protected /* synthetic */ void _ebean_set_dataFile(WorkspaceFile newValue) {
        this._ebean_intercept.preSetter(true, 17, (Object)this._ebean_get_dataFile(), (Object)newValue);
        this.dataFile = newValue;
    }

    protected /* synthetic */ WorkspaceFile _ebean_getni_dataFile() {
        return this.dataFile;
    }

    protected /* synthetic */ void _ebean_setni_dataFile(WorkspaceFile _newValue) {
        this.dataFile = _newValue;
        this._ebean_intercept.setLoadedProperty(17);
    }

    protected /* synthetic */ State _ebean_get_state() {
        this._ebean_intercept.preGetter(18);
        return this.state;
    }

    protected /* synthetic */ void _ebean_set_state(State newValue) {
        this._ebean_intercept.preSetter(true, 18, (Object)this._ebean_get_state(), (Object)newValue);
        this.state = newValue;
    }

    protected /* synthetic */ State _ebean_getni_state() {
        return this.state;
    }

    protected /* synthetic */ void _ebean_setni_state(State _newValue) {
        this.state = _newValue;
        this._ebean_intercept.setLoadedProperty(18);
    }

    protected /* synthetic */ String _ebean_get_errorCode() {
        this._ebean_intercept.preGetter(19);
        return this.errorCode;
    }

    protected /* synthetic */ void _ebean_set_errorCode(String newValue) {
        this._ebean_intercept.preSetter(true, 19, (Object)this._ebean_get_errorCode(), (Object)newValue);
        this.errorCode = newValue;
    }

    protected /* synthetic */ String _ebean_getni_errorCode() {
        return this.errorCode;
    }

    protected /* synthetic */ void _ebean_setni_errorCode(String _newValue) {
        this.errorCode = _newValue;
        this._ebean_intercept.setLoadedProperty(19);
    }

    protected /* synthetic */ String _ebean_get_additionalOrderInfo() {
        this._ebean_intercept.preGetter(20);
        return this.additionalOrderInfo;
    }

    protected /* synthetic */ void _ebean_set_additionalOrderInfo(String newValue) {
        this._ebean_intercept.preSetter(true, 20, (Object)this._ebean_get_additionalOrderInfo(), (Object)newValue);
        this.additionalOrderInfo = newValue;
    }

    protected /* synthetic */ String _ebean_getni_additionalOrderInfo() {
        return this.additionalOrderInfo;
    }

    protected /* synthetic */ void _ebean_setni_additionalOrderInfo(String _newValue) {
        this.additionalOrderInfo = _newValue;
        this._ebean_intercept.setLoadedProperty(20);
    }

    protected /* synthetic */ Type _ebean_get_type() {
        this._ebean_intercept.preGetter(21);
        return this.type;
    }

    protected /* synthetic */ void _ebean_set_type(Type newValue) {
        this._ebean_intercept.preSetter(true, 21, (Object)this._ebean_get_type(), (Object)newValue);
        this.type = newValue;
    }

    protected /* synthetic */ Type _ebean_getni_type() {
        return this.type;
    }

    protected /* synthetic */ void _ebean_setni_type(Type _newValue) {
        this.type = _newValue;
        this._ebean_intercept.setLoadedProperty(21);
    }

    protected /* synthetic */ List _ebean_get_accounts() {
        this._ebean_intercept.preGetter(22);
        if (this.accounts == null) {
            this.accounts = new BeanList();
            this._ebean_intercept.initialisedMany(22);
            ((BeanCollection)this.accounts).setModifyListening(BeanCollection.ModifyListenMode.ALL);
        }
        return this.accounts;
    }

    protected /* synthetic */ void _ebean_set_accounts(List newValue) {
        this._ebean_intercept.preSetterMany(false, 22, this.accounts, (Object)newValue);
        this.accounts = newValue;
    }

    protected /* synthetic */ List _ebean_getni_accounts() {
        return this.accounts;
    }

    protected /* synthetic */ void _ebean_setni_accounts(List _newValue) {
        this.accounts = _newValue;
        this._ebean_intercept.setLoadedProperty(22);
    }

    public /* synthetic */ Object _ebean_getField(int index) {
        switch (index) {
            case 0: {
                return this.id;
            }
            case 1: {
                return this.bank;
            }
            case 2: {
                return this.pmtType;
            }
            case 3: {
                return this.fileType;
            }
            case 4: {
                return this.orderId;
            }
            case 5: {
                return this.filename;
            }
            case 6: {
                return this.submissionDate;
            }
            case 7: {
                return this.customerId;
            }
            case 8: {
                return this.userId;
            }
            case 9: {
                return this.userName;
            }
            case 10: {
                return this.numSigDone;
            }
            case 11: {
                return this.numSigRequired;
            }
            case 12: {
                return this.signingInfos;
            }
            case 13: {
                return this.amount;
            }
            case 14: {
                return this.amountCurrency;
            }
            case 15: {
                return this.datasize;
            }
            case 16: {
                return this.ticket;
            }
            case 17: {
                return this.dataFile;
            }
            case 18: {
                return this.state;
            }
            case 19: {
                return this.errorCode;
            }
            case 20: {
                return this.additionalOrderInfo;
            }
            case 21: {
                return this.type;
            }
            case 22: {
                return this.accounts;
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    public /* synthetic */ Object _ebean_getFieldIntercept(int index) {
        switch (index) {
            case 0: {
                return this._ebean_get_id();
            }
            case 1: {
                return this._ebean_get_bank();
            }
            case 2: {
                return this._ebean_get_pmtType();
            }
            case 3: {
                return this._ebean_get_fileType();
            }
            case 4: {
                return this._ebean_get_orderId();
            }
            case 5: {
                return this._ebean_get_filename();
            }
            case 6: {
                return this._ebean_get_submissionDate();
            }
            case 7: {
                return this._ebean_get_customerId();
            }
            case 8: {
                return this._ebean_get_userId();
            }
            case 9: {
                return this._ebean_get_userName();
            }
            case 10: {
                return this._ebean_get_numSigDone();
            }
            case 11: {
                return this._ebean_get_numSigRequired();
            }
            case 12: {
                return this._ebean_get_signingInfos();
            }
            case 13: {
                return this._ebean_get_amount();
            }
            case 14: {
                return this._ebean_get_amountCurrency();
            }
            case 15: {
                return this._ebean_get_datasize();
            }
            case 16: {
                return this._ebean_get_ticket();
            }
            case 17: {
                return this._ebean_get_dataFile();
            }
            case 18: {
                return this._ebean_get_state();
            }
            case 19: {
                return this._ebean_get_errorCode();
            }
            case 20: {
                return this._ebean_get_additionalOrderInfo();
            }
            case 21: {
                return this._ebean_get_type();
            }
            case 22: {
                return this._ebean_get_accounts();
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    public /* synthetic */ void _ebean_setField(int index, Object o) {
        switch (index) {
            case 0: {
                this._ebean_setni_id((Integer)o);
                return;
            }
            case 1: {
                this._ebean_setni_bank((BankSettings)o);
                return;
            }
            case 2: {
                this._ebean_setni_pmtType((PaymentTransferType.PmtType)((Object)o));
                return;
            }
            case 3: {
                this._ebean_setni_fileType((String)o);
                return;
            }
            case 4: {
                this._ebean_setni_orderId((String)o);
                return;
            }
            case 5: {
                this._ebean_setni_filename((String)o);
                return;
            }
            case 6: {
                this._ebean_setni_submissionDate((Timestamp)o);
                return;
            }
            case 7: {
                this._ebean_setni_customerId((String)o);
                return;
            }
            case 8: {
                this._ebean_setni_userId((String)o);
                return;
            }
            case 9: {
                this._ebean_setni_userName((String)o);
                return;
            }
            case 10: {
                this._ebean_setni_numSigDone((Integer)o);
                return;
            }
            case 11: {
                this._ebean_setni_numSigRequired((Integer)o);
                return;
            }
            case 12: {
                this._ebean_setni_signingInfos((List)o);
                return;
            }
            case 13: {
                this._ebean_setni_amount((BigDecimal)o);
                return;
            }
            case 14: {
                this._ebean_setni_amountCurrency((String)o);
                return;
            }
            case 15: {
                this._ebean_setni_datasize((Long)o);
                return;
            }
            case 16: {
                this._ebean_setni_ticket((byte[])o);
                return;
            }
            case 17: {
                this._ebean_setni_dataFile((WorkspaceFile)o);
                return;
            }
            case 18: {
                this._ebean_setni_state((State)((Object)o));
                return;
            }
            case 19: {
                this._ebean_setni_errorCode((String)o);
                return;
            }
            case 20: {
                this._ebean_setni_additionalOrderInfo((String)o);
                return;
            }
            case 21: {
                this._ebean_setni_type((Type)((Object)o));
                return;
            }
            case 22: {
                this._ebean_setni_accounts((List)o);
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    public /* synthetic */ void _ebean_setFieldIntercept(int index, Object o) {
        switch (index) {
            case 0: {
                this._ebean_set_id((Integer)o);
                return;
            }
            case 1: {
                this._ebean_set_bank((BankSettings)o);
                return;
            }
            case 2: {
                this._ebean_set_pmtType((PaymentTransferType.PmtType)((Object)o));
                return;
            }
            case 3: {
                this._ebean_set_fileType((String)o);
                return;
            }
            case 4: {
                this._ebean_set_orderId((String)o);
                return;
            }
            case 5: {
                this._ebean_set_filename((String)o);
                return;
            }
            case 6: {
                this._ebean_set_submissionDate((Timestamp)o);
                return;
            }
            case 7: {
                this._ebean_set_customerId((String)o);
                return;
            }
            case 8: {
                this._ebean_set_userId((String)o);
                return;
            }
            case 9: {
                this._ebean_set_userName((String)o);
                return;
            }
            case 10: {
                this._ebean_set_numSigDone((Integer)o);
                return;
            }
            case 11: {
                this._ebean_set_numSigRequired((Integer)o);
                return;
            }
            case 12: {
                this._ebean_set_signingInfos((List)o);
                return;
            }
            case 13: {
                this._ebean_set_amount((BigDecimal)o);
                return;
            }
            case 14: {
                this._ebean_set_amountCurrency((String)o);
                return;
            }
            case 15: {
                this._ebean_set_datasize((Long)o);
                return;
            }
            case 16: {
                this._ebean_set_ticket((byte[])o);
                return;
            }
            case 17: {
                this._ebean_set_dataFile((WorkspaceFile)o);
                return;
            }
            case 18: {
                this._ebean_set_state((State)((Object)o));
                return;
            }
            case 19: {
                this._ebean_set_errorCode((String)o);
                return;
            }
            case 20: {
                this._ebean_set_additionalOrderInfo((String)o);
                return;
            }
            case 21: {
                this._ebean_set_type((Type)((Object)o));
                return;
            }
            case 22: {
                this._ebean_set_accounts((List)o);
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private /* synthetic */ Object _ebean_getIdentity() {
        DsOrderDetails dsOrderDetails = this;
        synchronized (dsOrderDetails) {
            if (this._ebean_identity != null) {
                return this._ebean_identity;
            }
            Object tmpId = this._ebean_getField(0);
            this._ebean_identity = tmpId != null ? tmpId : new Object();
            return this._ebean_identity;
        }
    }

    public /* synthetic */ boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        return this._ebean_getIdentity().equals(((DsOrderDetails)obj)._ebean_getIdentity());
    }

    public /* synthetic */ int hashCode() {
        return this._ebean_getIdentity().hashCode();
    }

    public /* synthetic */ void _ebean_setEmbeddedLoaded() {
    }

    public /* synthetic */ boolean _ebean_isEmbeddedNewOrDirty() {
        return false;
    }

    public /* synthetic */ Object _ebean_newInstance() {
        return new DsOrderDetails();
    }

    public static enum State {
        WAITING,
        FINISHED,
        CANCELLED,
        FINISHED_ERROR,
        CONFIRMED,
        FINISHED_FINAL;

    }

    public static enum Type {
        SIGNED,
        REJECTED;

    }
}

