/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.database.vo;

import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.BankUser;
import de.businesslogics.banking.database.vo.DsOpenOrderSigner;
import de.businesslogics.banking.database.vo.EbeanHelper;
import de.businesslogics.banking.database.vo.PaymentTransferType;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.banking.database.vo.WorkspaceFile;
import io.ebean.Query;
import io.ebean.bean.EntityBean;
import io.ebean.bean.EntityBeanIntercept;
import io.ebean.common.BeanList;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.StandardCharsets;
import java.sql.Timestamp;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;

@Entity
public class DsOpenOrder
implements EntityBean {
    @Id
    private Integer id;
    @ManyToOne
    private BankUser bankUser;
    @Column(nullable=false, length=50)
    private String fileType;
    private PaymentTransferType.PmtType pmtType;
    @Column(nullable=false, length=4)
    private String orderId;
    @Column(nullable=false)
    private Timestamp submissionDate;
    @Column(length=35, nullable=false)
    private String customerId;
    @Column(length=35)
    private String userId;
    @Column(length=80)
    private String userName;
    @Column(precision=38, scale=3)
    private BigDecimal amount;
    @Column(length=3)
    private String amountCurrency;
    private Long datasize;
    @Column(length=140)
    private String originator;
    @Column(length=80)
    private String digestHex;
    @Column(name="is_signable")
    private boolean signable;
    @Column(name="is_order_data_available")
    private boolean orderDataAvailable;
    @Column(name="is_payment_data_available")
    private boolean paymentDataAvailable;
    @Column(nullable=false)
    private int numSigDone;
    @Column(nullable=false)
    private int numSigRequired;
    @OneToMany(cascade={CascadeType.ALL})
    private List<DsOpenOrderSigner> signers;
    @Lob
    private byte[] ticket;
    @ManyToOne
    private WorkspaceFile orderData;
    @ManyToOne
    private WorkspaceFile paymentData;
    @Column
    private String additionalOrderInfo;
    public static /* synthetic */ String[] _ebean_props;
    protected /* synthetic */ EntityBeanIntercept _ebean_intercept;
    protected transient /* synthetic */ Object _ebean_identity;

    public DsOpenOrder() {
        this._ebean_intercept = new EntityBeanIntercept((Object)this);
    }

    public static Query<DsOpenOrder> queryForBankUser(BankUser bankUser) {
        return DB.find(DsOpenOrder.class).where().eq("bankUser", (Object)bankUser).query();
    }

    public static Query<DsOpenOrder> queryForBankUsers(List<BankUser> bankUsers) {
        return DB.find(DsOpenOrder.class).where().in("bankUser", bankUsers).query();
    }

    public static Query<DsOpenOrder> queryForUser(User user) {
        return DB.find(DsOpenOrder.class).where().eq("bankUser.user", (Object)user).query();
    }

    public static void deleteDsOpenOrders(List<Integer> idsToDelete) {
        if (idsToDelete == null || idsToDelete.isEmpty()) {
            return;
        }
        EbeanHelper.deleteById(DsOpenOrder.class, idsToDelete);
    }

    public static int deleteByBank(BankSettings bank) {
        Object delete = DB.createUpdate(DsOpenOrderSigner.class, "DELETE FROM DsOpenOrderSigner WHERE dsOpenOrder IN (SELECT id FROM ds_open_order WHERE bank_user_id IN (SELECT id FROM bankuser WHERE bank_id = :bankId))");
        delete.setParameter("bankId", (Object)bank.getBankId());
        delete.execute();
        delete = DB.createUpdate(DsOpenOrder.class, "DELETE FROM DsOpenOrder WHERE bankUser IN (SELECT id FROM bankuser WHERE bank_id = :bankId)");
        delete.setParameter("bankId", (Object)bank.getBankId());
        return delete.execute();
    }

    public static int deleteByBankUser(BankUser user) {
        Object delete = DB.createUpdate(DsOpenOrderSigner.class, "DELETE FROM DsOpenOrderSigner WHERE dsOpenOrder IN (SELECT id FROM ds_open_order WHERE bank_user_id=:userId)");
        delete.setParameter("userId", (Object)user.getId());
        delete.execute();
        delete = DB.createUpdate(DsOpenOrder.class, "DELETE FROM DsOpenOrder WHERE bankUser=:user");
        delete.setParameter("user", (Object)user.getId());
        return delete.execute();
    }

    public static int deleteByUser(User user) {
        Object delete = DB.createUpdate(DsOpenOrderSigner.class, "DELETE FROM DsOpenOrderSigner WHERE dsOpenOrder IN (SELECT id FROM ds_open_order WHERE bank_user_id IN (SELECT id FROM bankuser WHERE user_id = :userId))");
        delete.setParameter("userId", (Object)user.getId());
        delete.execute();
        delete = DB.createUpdate(DsOpenOrder.class, "DELETE FROM DsOpenOrder WHERE bankUser IN (SELECT id FROM bankuser WHERE user_id=:user)");
        delete.setParameter("user", (Object)user.getId());
        return delete.execute();
    }

    public Integer getId() {
        return this._ebean_get_id();
    }

    public void setId(Integer id) {
        this._ebean_set_id(id);
    }

    public BankUser getBankUser() {
        return this._ebean_get_bankUser();
    }

    public void setBankUser(BankUser bankUser) {
        this._ebean_set_bankUser(bankUser);
    }

    public String getFileType() {
        return this._ebean_get_fileType();
    }

    public void setFileType(String fileType) {
        this._ebean_set_fileType(fileType);
    }

    public PaymentTransferType.PmtType getPmtType() {
        return this._ebean_get_pmtType();
    }

    public void setPmtType(PaymentTransferType.PmtType pmtType) {
        this._ebean_set_pmtType(pmtType);
    }

    public String getOrderId() {
        return this._ebean_get_orderId();
    }

    public void setOrderId(String orderId) {
        this._ebean_set_orderId(orderId);
    }

    public Timestamp getSubmissionDate() {
        return this._ebean_get_submissionDate();
    }

    public void setSubmissionDate(Timestamp submissionDate) {
        this._ebean_set_submissionDate(submissionDate);
    }

    public String getCustomerId() {
        return this._ebean_get_customerId();
    }

    public void setCustomerId(String customerId) {
        this._ebean_set_customerId(customerId);
    }

    public String getUserId() {
        return this._ebean_get_userId();
    }

    public void setUserId(String userId) {
        this._ebean_set_userId(userId);
    }

    public String getUserName() {
        return this._ebean_get_userName();
    }

    public void setUserName(String userName) {
        this._ebean_set_userName(this.shorten(userName, 40));
    }

    public BigDecimal getAmount() {
        return this._ebean_get_amount();
    }

    public void setAmount(BigDecimal amount) {
        this._ebean_set_amount(amount);
    }

    public String getAmountCurrency() {
        return this._ebean_get_amountCurrency();
    }

    public void setAmountCurrency(String amountCurrency) {
        this._ebean_set_amountCurrency(amountCurrency);
    }

    public Long getDatasize() {
        return this._ebean_get_datasize();
    }

    public void setDatasize(Long datasize) {
        this._ebean_set_datasize(datasize);
    }

    public String getOriginator() {
        return this._ebean_get_originator();
    }

    public void setOriginator(String originator) {
        this._ebean_set_originator(this.shorten(originator, 140));
    }

    public String getDigestHex() {
        return this._ebean_get_digestHex();
    }

    public void setDigestHex(String digestHex) {
        this._ebean_set_digestHex(digestHex);
    }

    public List<DsOpenOrderSigner> getSigners() {
        return this._ebean_get_signers();
    }

    public void setSigners(List<DsOpenOrderSigner> signers) {
        this._ebean_set_signers(signers);
    }

    public byte[] getTicket() {
        return this._ebean_get_ticket();
    }

    public void setTicket(byte[] ticket) {
        this._ebean_set_ticket(ticket);
    }

    public boolean isSignable() {
        return this._ebean_get_signable();
    }

    public void setSignable(boolean isSignable) {
        this._ebean_set_signable(isSignable);
    }

    public boolean isOrderDataAvailable() {
        return this._ebean_get_orderDataAvailable();
    }

    public void setOrderDataAvailable(boolean isOrderDataAvailable) {
        this._ebean_set_orderDataAvailable(isOrderDataAvailable);
    }

    public boolean isPaymentDataAvailable() {
        return this._ebean_get_paymentDataAvailable();
    }

    public void setPaymentDataAvailable(boolean isPaymentDataAvailable) {
        this._ebean_set_paymentDataAvailable(isPaymentDataAvailable);
    }

    public int getNumSigDone() {
        return this._ebean_get_numSigDone();
    }

    public void setNumSigDone(int numSigDone) {
        this._ebean_set_numSigDone(numSigDone);
    }

    public int getNumSigRequired() {
        return this._ebean_get_numSigRequired();
    }

    public void setNumSigRequired(int numSigRequired) {
        this._ebean_set_numSigRequired(numSigRequired);
    }

    public WorkspaceFile getOrderData() {
        return this._ebean_get_orderData();
    }

    public void setOrderData(WorkspaceFile orderData) {
        this._ebean_set_orderData(orderData);
    }

    public WorkspaceFile getPaymentData() {
        return this._ebean_get_paymentData();
    }

    public void setPaymentData(WorkspaceFile paymentData) {
        this._ebean_set_paymentData(paymentData);
    }

    public String getAdditionalOrderInfo() {
        return this._ebean_get_additionalOrderInfo();
    }

    public void setAdditionalOrderInfo(String additionalOrderInfo) {
        this._ebean_set_additionalOrderInfo(additionalOrderInfo);
    }

    public String getTicketAsString() {
        return DsOpenOrder.getTicket(this.getTicket());
    }

    public static String getTicket(byte[] in) {
        if (in == null) {
            return null;
        }
        CharsetDecoder utfDecoder = StandardCharsets.UTF_8.newDecoder();
        try {
            return utfDecoder.decode(ByteBuffer.wrap(in)).toString();
        }
        catch (CharacterCodingException e) {
            CharsetDecoder isoDecoder = StandardCharsets.ISO_8859_1.newDecoder();
            try {
                return isoDecoder.decode(ByteBuffer.wrap(in)).toString();
            }
            catch (CharacterCodingException ex) {
                return new String(in, StandardCharsets.UTF_8);
            }
        }
    }

    private String shorten(String in, int length) {
        if (in != null && in.length() > length) {
            return in.substring(0, length);
        }
        return in;
    }

    public void save() {
        if (this._ebean_get_id() == null) {
            DB.save(this);
        } else {
            DB.update(this);
        }
    }

    static {
        _ebean_props = new String[]{"id", "bankUser", "fileType", "pmtType", "orderId", "submissionDate", "customerId", "userId", "userName", "amount", "amountCurrency", "datasize", "originator", "digestHex", "signable", "orderDataAvailable", "paymentDataAvailable", "numSigDone", "numSigRequired", "signers", "ticket", "orderData", "paymentData", "additionalOrderInfo"};
    }

    public /* synthetic */ String[] _ebean_getPropertyNames() {
        return _ebean_props;
    }

    public /* synthetic */ String _ebean_getPropertyName(int pos) {
        return _ebean_props[pos];
    }

    public /* synthetic */ EntityBeanIntercept _ebean_getIntercept() {
        return this._ebean_intercept;
    }

    public /* synthetic */ EntityBeanIntercept _ebean_intercept() {
        if (this._ebean_intercept == null) {
            this._ebean_intercept = new EntityBeanIntercept((Object)this);
        }
        return this._ebean_intercept;
    }

    protected /* synthetic */ Integer _ebean_get_id() {
        this._ebean_intercept.preGetId();
        return this.id;
    }

    protected /* synthetic */ void _ebean_set_id(Integer newValue) {
        this._ebean_intercept.preSetter(false, 0, (Object)this.id, (Object)newValue);
        this.id = newValue;
    }

    protected /* synthetic */ Integer _ebean_getni_id() {
        return this.id;
    }

    protected /* synthetic */ void _ebean_setni_id(Integer _newValue) {
        this.id = _newValue;
        this._ebean_intercept.setLoadedProperty(0);
    }

    protected /* synthetic */ BankUser _ebean_get_bankUser() {
        this._ebean_intercept.preGetter(1);
        return this.bankUser;
    }

    protected /* synthetic */ void _ebean_set_bankUser(BankUser newValue) {
        this._ebean_intercept.preSetter(true, 1, (Object)this._ebean_get_bankUser(), (Object)newValue);
        this.bankUser = newValue;
    }

    protected /* synthetic */ BankUser _ebean_getni_bankUser() {
        return this.bankUser;
    }

    protected /* synthetic */ void _ebean_setni_bankUser(BankUser _newValue) {
        this.bankUser = _newValue;
        this._ebean_intercept.setLoadedProperty(1);
    }

    protected /* synthetic */ String _ebean_get_fileType() {
        this._ebean_intercept.preGetter(2);
        return this.fileType;
    }

    protected /* synthetic */ void _ebean_set_fileType(String newValue) {
        this._ebean_intercept.preSetter(true, 2, (Object)this._ebean_get_fileType(), (Object)newValue);
        this.fileType = newValue;
    }

    protected /* synthetic */ String _ebean_getni_fileType() {
        return this.fileType;
    }

    protected /* synthetic */ void _ebean_setni_fileType(String _newValue) {
        this.fileType = _newValue;
        this._ebean_intercept.setLoadedProperty(2);
    }

    protected /* synthetic */ PaymentTransferType.PmtType _ebean_get_pmtType() {
        this._ebean_intercept.preGetter(3);
        return this.pmtType;
    }

    protected /* synthetic */ void _ebean_set_pmtType(PaymentTransferType.PmtType newValue) {
        this._ebean_intercept.preSetter(true, 3, (Object)this._ebean_get_pmtType(), (Object)newValue);
        this.pmtType = newValue;
    }

    protected /* synthetic */ PaymentTransferType.PmtType _ebean_getni_pmtType() {
        return this.pmtType;
    }

    protected /* synthetic */ void _ebean_setni_pmtType(PaymentTransferType.PmtType _newValue) {
        this.pmtType = _newValue;
        this._ebean_intercept.setLoadedProperty(3);
    }

    protected /* synthetic */ String _ebean_get_orderId() {
        this._ebean_intercept.preGetter(4);
        return this.orderId;
    }

    protected /* synthetic */ void _ebean_set_orderId(String newValue) {
        this._ebean_intercept.preSetter(true, 4, (Object)this._ebean_get_orderId(), (Object)newValue);
        this.orderId = newValue;
    }

    protected /* synthetic */ String _ebean_getni_orderId() {
        return this.orderId;
    }

    protected /* synthetic */ void _ebean_setni_orderId(String _newValue) {
        this.orderId = _newValue;
        this._ebean_intercept.setLoadedProperty(4);
    }

    protected /* synthetic */ Timestamp _ebean_get_submissionDate() {
        this._ebean_intercept.preGetter(5);
        return this.submissionDate;
    }

    protected /* synthetic */ void _ebean_set_submissionDate(Timestamp newValue) {
        this._ebean_intercept.preSetter(true, 5, (Object)this._ebean_get_submissionDate(), (Object)newValue);
        this.submissionDate = newValue;
    }

    protected /* synthetic */ Timestamp _ebean_getni_submissionDate() {
        return this.submissionDate;
    }

    protected /* synthetic */ void _ebean_setni_submissionDate(Timestamp _newValue) {
        this.submissionDate = _newValue;
        this._ebean_intercept.setLoadedProperty(5);
    }

    protected /* synthetic */ String _ebean_get_customerId() {
        this._ebean_intercept.preGetter(6);
        return this.customerId;
    }

    protected /* synthetic */ void _ebean_set_customerId(String newValue) {
        this._ebean_intercept.preSetter(true, 6, (Object)this._ebean_get_customerId(), (Object)newValue);
        this.customerId = newValue;
    }

    protected /* synthetic */ String _ebean_getni_customerId() {
        return this.customerId;
    }

    protected /* synthetic */ void _ebean_setni_customerId(String _newValue) {
        this.customerId = _newValue;
        this._ebean_intercept.setLoadedProperty(6);
    }

    protected /* synthetic */ String _ebean_get_userId() {
        this._ebean_intercept.preGetter(7);
        return this.userId;
    }

    protected /* synthetic */ void _ebean_set_userId(String newValue) {
        this._ebean_intercept.preSetter(true, 7, (Object)this._ebean_get_userId(), (Object)newValue);
        this.userId = newValue;
    }

    protected /* synthetic */ String _ebean_getni_userId() {
        return this.userId;
    }

    protected /* synthetic */ void _ebean_setni_userId(String _newValue) {
        this.userId = _newValue;
        this._ebean_intercept.setLoadedProperty(7);
    }

    protected /* synthetic */ String _ebean_get_userName() {
        this._ebean_intercept.preGetter(8);
        return this.userName;
    }

    protected /* synthetic */ void _ebean_set_userName(String newValue) {
        this._ebean_intercept.preSetter(true, 8, (Object)this._ebean_get_userName(), (Object)newValue);
        this.userName = newValue;
    }

    protected /* synthetic */ String _ebean_getni_userName() {
        return this.userName;
    }

    protected /* synthetic */ void _ebean_setni_userName(String _newValue) {
        this.userName = _newValue;
        this._ebean_intercept.setLoadedProperty(8);
    }

    protected /* synthetic */ BigDecimal _ebean_get_amount() {
        this._ebean_intercept.preGetter(9);
        return this.amount;
    }

    protected /* synthetic */ void _ebean_set_amount(BigDecimal newValue) {
        this._ebean_intercept.preSetter(true, 9, (Object)this._ebean_get_amount(), (Object)newValue);
        this.amount = newValue;
    }

    protected /* synthetic */ BigDecimal _ebean_getni_amount() {
        return this.amount;
    }

    protected /* synthetic */ void _ebean_setni_amount(BigDecimal _newValue) {
        this.amount = _newValue;
        this._ebean_intercept.setLoadedProperty(9);
    }

    protected /* synthetic */ String _ebean_get_amountCurrency() {
        this._ebean_intercept.preGetter(10);
        return this.amountCurrency;
    }

    protected /* synthetic */ void _ebean_set_amountCurrency(String newValue) {
        this._ebean_intercept.preSetter(true, 10, (Object)this._ebean_get_amountCurrency(), (Object)newValue);
        this.amountCurrency = newValue;
    }

    protected /* synthetic */ String _ebean_getni_amountCurrency() {
        return this.amountCurrency;
    }

    protected /* synthetic */ void _ebean_setni_amountCurrency(String _newValue) {
        this.amountCurrency = _newValue;
        this._ebean_intercept.setLoadedProperty(10);
    }

    protected /* synthetic */ Long _ebean_get_datasize() {
        this._ebean_intercept.preGetter(11);
        return this.datasize;
    }

    protected /* synthetic */ void _ebean_set_datasize(Long newValue) {
        this._ebean_intercept.preSetter(true, 11, (Object)this._ebean_get_datasize(), (Object)newValue);
        this.datasize = newValue;
    }

    protected /* synthetic */ Long _ebean_getni_datasize() {
        return this.datasize;
    }

    protected /* synthetic */ void _ebean_setni_datasize(Long _newValue) {
        this.datasize = _newValue;
        this._ebean_intercept.setLoadedProperty(11);
    }

    protected /* synthetic */ String _ebean_get_originator() {
        this._ebean_intercept.preGetter(12);
        return this.originator;
    }

    protected /* synthetic */ void _ebean_set_originator(String newValue) {
        this._ebean_intercept.preSetter(true, 12, (Object)this._ebean_get_originator(), (Object)newValue);
        this.originator = newValue;
    }

    protected /* synthetic */ String _ebean_getni_originator() {
        return this.originator;
    }

    protected /* synthetic */ void _ebean_setni_originator(String _newValue) {
        this.originator = _newValue;
        this._ebean_intercept.setLoadedProperty(12);
    }

    protected /* synthetic */ String _ebean_get_digestHex() {
        this._ebean_intercept.preGetter(13);
        return this.digestHex;
    }

    protected /* synthetic */ void _ebean_set_digestHex(String newValue) {
        this._ebean_intercept.preSetter(true, 13, (Object)this._ebean_get_digestHex(), (Object)newValue);
        this.digestHex = newValue;
    }

    protected /* synthetic */ String _ebean_getni_digestHex() {
        return this.digestHex;
    }

    protected /* synthetic */ void _ebean_setni_digestHex(String _newValue) {
        this.digestHex = _newValue;
        this._ebean_intercept.setLoadedProperty(13);
    }

    protected /* synthetic */ boolean _ebean_get_signable() {
        this._ebean_intercept.preGetter(14);
        return this.signable;
    }

    protected /* synthetic */ void _ebean_set_signable(boolean newValue) {
        this._ebean_intercept.preSetter(true, 14, this._ebean_get_signable(), newValue);
        this.signable = newValue;
    }

    protected /* synthetic */ boolean _ebean_getni_signable() {
        return this.signable;
    }

    protected /* synthetic */ void _ebean_setni_signable(boolean _newValue) {
        this.signable = _newValue;
        this._ebean_intercept.setLoadedProperty(14);
    }

    protected /* synthetic */ boolean _ebean_get_orderDataAvailable() {
        this._ebean_intercept.preGetter(15);
        return this.orderDataAvailable;
    }

    protected /* synthetic */ void _ebean_set_orderDataAvailable(boolean newValue) {
        this._ebean_intercept.preSetter(true, 15, this._ebean_get_orderDataAvailable(), newValue);
        this.orderDataAvailable = newValue;
    }

    protected /* synthetic */ boolean _ebean_getni_orderDataAvailable() {
        return this.orderDataAvailable;
    }

    protected /* synthetic */ void _ebean_setni_orderDataAvailable(boolean _newValue) {
        this.orderDataAvailable = _newValue;
        this._ebean_intercept.setLoadedProperty(15);
    }

    protected /* synthetic */ boolean _ebean_get_paymentDataAvailable() {
        this._ebean_intercept.preGetter(16);
        return this.paymentDataAvailable;
    }

    protected /* synthetic */ void _ebean_set_paymentDataAvailable(boolean newValue) {
        this._ebean_intercept.preSetter(true, 16, this._ebean_get_paymentDataAvailable(), newValue);
        this.paymentDataAvailable = newValue;
    }

    protected /* synthetic */ boolean _ebean_getni_paymentDataAvailable() {
        return this.paymentDataAvailable;
    }

    protected /* synthetic */ void _ebean_setni_paymentDataAvailable(boolean _newValue) {
        this.paymentDataAvailable = _newValue;
        this._ebean_intercept.setLoadedProperty(16);
    }

    protected /* synthetic */ int _ebean_get_numSigDone() {
        this._ebean_intercept.preGetter(17);
        return this.numSigDone;
    }

    protected /* synthetic */ void _ebean_set_numSigDone(int newValue) {
        this._ebean_intercept.preSetter(true, 17, this._ebean_get_numSigDone(), newValue);
        this.numSigDone = newValue;
    }

    protected /* synthetic */ int _ebean_getni_numSigDone() {
        return this.numSigDone;
    }

    protected /* synthetic */ void _ebean_setni_numSigDone(int _newValue) {
        this.numSigDone = _newValue;
        this._ebean_intercept.setLoadedProperty(17);
    }

    protected /* synthetic */ int _ebean_get_numSigRequired() {
        this._ebean_intercept.preGetter(18);
        return this.numSigRequired;
    }

    protected /* synthetic */ void _ebean_set_numSigRequired(int newValue) {
        this._ebean_intercept.preSetter(true, 18, this._ebean_get_numSigRequired(), newValue);
        this.numSigRequired = newValue;
    }

    protected /* synthetic */ int _ebean_getni_numSigRequired() {
        return this.numSigRequired;
    }

    protected /* synthetic */ void _ebean_setni_numSigRequired(int _newValue) {
        this.numSigRequired = _newValue;
        this._ebean_intercept.setLoadedProperty(18);
    }

    protected /* synthetic */ List _ebean_get_signers() {
        this._ebean_intercept.preGetter(19);
        if (this.signers == null) {
            this.signers = new BeanList();
            this._ebean_intercept.initialisedMany(19);
        }
        return this.signers;
    }

    protected /* synthetic */ void _ebean_set_signers(List newValue) {
        this._ebean_intercept.preSetterMany(false, 19, this.signers, (Object)newValue);
        this.signers = newValue;
    }

    protected /* synthetic */ List _ebean_getni_signers() {
        return this.signers;
    }

    protected /* synthetic */ void _ebean_setni_signers(List _newValue) {
        this.signers = _newValue;
        this._ebean_intercept.setLoadedProperty(19);
    }

    protected /* synthetic */ byte[] _ebean_get_ticket() {
        this._ebean_intercept.preGetter(20);
        return this.ticket;
    }

    protected /* synthetic */ void _ebean_set_ticket(byte[] newValue) {
        this._ebean_intercept.preSetter(true, 20, this._ebean_get_ticket(), newValue);
        this.ticket = newValue;
    }

    protected /* synthetic */ byte[] _ebean_getni_ticket() {
        return this.ticket;
    }

    protected /* synthetic */ void _ebean_setni_ticket(byte[] _newValue) {
        this.ticket = _newValue;
        this._ebean_intercept.setLoadedProperty(20);
    }

    protected /* synthetic */ WorkspaceFile _ebean_get_orderData() {
        this._ebean_intercept.preGetter(21);
        return this.orderData;
    }

    protected /* synthetic */ void _ebean_set_orderData(WorkspaceFile newValue) {
        this._ebean_intercept.preSetter(true, 21, (Object)this._ebean_get_orderData(), (Object)newValue);
        this.orderData = newValue;
    }

    protected /* synthetic */ WorkspaceFile _ebean_getni_orderData() {
        return this.orderData;
    }

    protected /* synthetic */ void _ebean_setni_orderData(WorkspaceFile _newValue) {
        this.orderData = _newValue;
        this._ebean_intercept.setLoadedProperty(21);
    }

    protected /* synthetic */ WorkspaceFile _ebean_get_paymentData() {
        this._ebean_intercept.preGetter(22);
        return this.paymentData;
    }

    protected /* synthetic */ void _ebean_set_paymentData(WorkspaceFile newValue) {
        this._ebean_intercept.preSetter(true, 22, (Object)this._ebean_get_paymentData(), (Object)newValue);
        this.paymentData = newValue;
    }

    protected /* synthetic */ WorkspaceFile _ebean_getni_paymentData() {
        return this.paymentData;
    }

    protected /* synthetic */ void _ebean_setni_paymentData(WorkspaceFile _newValue) {
        this.paymentData = _newValue;
        this._ebean_intercept.setLoadedProperty(22);
    }

    protected /* synthetic */ String _ebean_get_additionalOrderInfo() {
        this._ebean_intercept.preGetter(23);
        return this.additionalOrderInfo;
    }

    protected /* synthetic */ void _ebean_set_additionalOrderInfo(String newValue) {
        this._ebean_intercept.preSetter(true, 23, (Object)this._ebean_get_additionalOrderInfo(), (Object)newValue);
        this.additionalOrderInfo = newValue;
    }

    protected /* synthetic */ String _ebean_getni_additionalOrderInfo() {
        return this.additionalOrderInfo;
    }

    protected /* synthetic */ void _ebean_setni_additionalOrderInfo(String _newValue) {
        this.additionalOrderInfo = _newValue;
        this._ebean_intercept.setLoadedProperty(23);
    }

    public /* synthetic */ Object _ebean_getField(int index) {
        switch (index) {
            case 0: {
                return this.id;
            }
            case 1: {
                return this.bankUser;
            }
            case 2: {
                return this.fileType;
            }
            case 3: {
                return this.pmtType;
            }
            case 4: {
                return this.orderId;
            }
            case 5: {
                return this.submissionDate;
            }
            case 6: {
                return this.customerId;
            }
            case 7: {
                return this.userId;
            }
            case 8: {
                return this.userName;
            }
            case 9: {
                return this.amount;
            }
            case 10: {
                return this.amountCurrency;
            }
            case 11: {
                return this.datasize;
            }
            case 12: {
                return this.originator;
            }
            case 13: {
                return this.digestHex;
            }
            case 14: {
                return this.signable;
            }
            case 15: {
                return this.orderDataAvailable;
            }
            case 16: {
                return this.paymentDataAvailable;
            }
            case 17: {
                return this.numSigDone;
            }
            case 18: {
                return this.numSigRequired;
            }
            case 19: {
                return this.signers;
            }
            case 20: {
                return this.ticket;
            }
            case 21: {
                return this.orderData;
            }
            case 22: {
                return this.paymentData;
            }
            case 23: {
                return this.additionalOrderInfo;
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    public /* synthetic */ Object _ebean_getFieldIntercept(int index) {
        switch (index) {
            case 0: {
                return this._ebean_get_id();
            }
            case 1: {
                return this._ebean_get_bankUser();
            }
            case 2: {
                return this._ebean_get_fileType();
            }
            case 3: {
                return this._ebean_get_pmtType();
            }
            case 4: {
                return this._ebean_get_orderId();
            }
            case 5: {
                return this._ebean_get_submissionDate();
            }
            case 6: {
                return this._ebean_get_customerId();
            }
            case 7: {
                return this._ebean_get_userId();
            }
            case 8: {
                return this._ebean_get_userName();
            }
            case 9: {
                return this._ebean_get_amount();
            }
            case 10: {
                return this._ebean_get_amountCurrency();
            }
            case 11: {
                return this._ebean_get_datasize();
            }
            case 12: {
                return this._ebean_get_originator();
            }
            case 13: {
                return this._ebean_get_digestHex();
            }
            case 14: {
                return this._ebean_get_signable();
            }
            case 15: {
                return this._ebean_get_orderDataAvailable();
            }
            case 16: {
                return this._ebean_get_paymentDataAvailable();
            }
            case 17: {
                return this._ebean_get_numSigDone();
            }
            case 18: {
                return this._ebean_get_numSigRequired();
            }
            case 19: {
                return this._ebean_get_signers();
            }
            case 20: {
                return this._ebean_get_ticket();
            }
            case 21: {
                return this._ebean_get_orderData();
            }
            case 22: {
                return this._ebean_get_paymentData();
            }
            case 23: {
                return this._ebean_get_additionalOrderInfo();
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    public /* synthetic */ void _ebean_setField(int index, Object o) {
        switch (index) {
            case 0: {
                this._ebean_setni_id((Integer)o);
                return;
            }
            case 1: {
                this._ebean_setni_bankUser((BankUser)o);
                return;
            }
            case 2: {
                this._ebean_setni_fileType((String)o);
                return;
            }
            case 3: {
                this._ebean_setni_pmtType((PaymentTransferType.PmtType)((Object)o));
                return;
            }
            case 4: {
                this._ebean_setni_orderId((String)o);
                return;
            }
            case 5: {
                this._ebean_setni_submissionDate((Timestamp)o);
                return;
            }
            case 6: {
                this._ebean_setni_customerId((String)o);
                return;
            }
            case 7: {
                this._ebean_setni_userId((String)o);
                return;
            }
            case 8: {
                this._ebean_setni_userName((String)o);
                return;
            }
            case 9: {
                this._ebean_setni_amount((BigDecimal)o);
                return;
            }
            case 10: {
                this._ebean_setni_amountCurrency((String)o);
                return;
            }
            case 11: {
                this._ebean_setni_datasize((Long)o);
                return;
            }
            case 12: {
                this._ebean_setni_originator((String)o);
                return;
            }
            case 13: {
                this._ebean_setni_digestHex((String)o);
                return;
            }
            case 14: {
                this._ebean_setni_signable((Boolean)o);
                return;
            }
            case 15: {
                this._ebean_setni_orderDataAvailable((Boolean)o);
                return;
            }
            case 16: {
                this._ebean_setni_paymentDataAvailable((Boolean)o);
                return;
            }
            case 17: {
                this._ebean_setni_numSigDone((Integer)o);
                return;
            }
            case 18: {
                this._ebean_setni_numSigRequired((Integer)o);
                return;
            }
            case 19: {
                this._ebean_setni_signers((List)o);
                return;
            }
            case 20: {
                this._ebean_setni_ticket((byte[])o);
                return;
            }
            case 21: {
                this._ebean_setni_orderData((WorkspaceFile)o);
                return;
            }
            case 22: {
                this._ebean_setni_paymentData((WorkspaceFile)o);
                return;
            }
            case 23: {
                this._ebean_setni_additionalOrderInfo((String)o);
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    public /* synthetic */ void _ebean_setFieldIntercept(int index, Object o) {
        switch (index) {
            case 0: {
                this._ebean_set_id((Integer)o);
                return;
            }
            case 1: {
                this._ebean_set_bankUser((BankUser)o);
                return;
            }
            case 2: {
                this._ebean_set_fileType((String)o);
                return;
            }
            case 3: {
                this._ebean_set_pmtType((PaymentTransferType.PmtType)((Object)o));
                return;
            }
            case 4: {
                this._ebean_set_orderId((String)o);
                return;
            }
            case 5: {
                this._ebean_set_submissionDate((Timestamp)o);
                return;
            }
            case 6: {
                this._ebean_set_customerId((String)o);
                return;
            }
            case 7: {
                this._ebean_set_userId((String)o);
                return;
            }
            case 8: {
                this._ebean_set_userName((String)o);
                return;
            }
            case 9: {
                this._ebean_set_amount((BigDecimal)o);
                return;
            }
            case 10: {
                this._ebean_set_amountCurrency((String)o);
                return;
            }
            case 11: {
                this._ebean_set_datasize((Long)o);
                return;
            }
            case 12: {
                this._ebean_set_originator((String)o);
                return;
            }
            case 13: {
                this._ebean_set_digestHex((String)o);
                return;
            }
            case 14: {
                this._ebean_set_signable((Boolean)o);
                return;
            }
            case 15: {
                this._ebean_set_orderDataAvailable((Boolean)o);
                return;
            }
            case 16: {
                this._ebean_set_paymentDataAvailable((Boolean)o);
                return;
            }
            case 17: {
                this._ebean_set_numSigDone((Integer)o);
                return;
            }
            case 18: {
                this._ebean_set_numSigRequired((Integer)o);
                return;
            }
            case 19: {
                this._ebean_set_signers((List)o);
                return;
            }
            case 20: {
                this._ebean_set_ticket((byte[])o);
                return;
            }
            case 21: {
                this._ebean_set_orderData((WorkspaceFile)o);
                return;
            }
            case 22: {
                this._ebean_set_paymentData((WorkspaceFile)o);
                return;
            }
            case 23: {
                this._ebean_set_additionalOrderInfo((String)o);
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private /* synthetic */ Object _ebean_getIdentity() {
        DsOpenOrder dsOpenOrder = this;
        synchronized (dsOpenOrder) {
            if (this._ebean_identity != null) {
                return this._ebean_identity;
            }
            Object tmpId = this._ebean_getField(0);
            this._ebean_identity = tmpId != null ? tmpId : new Object();
            return this._ebean_identity;
        }
    }

    public /* synthetic */ boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        return this._ebean_getIdentity().equals(((DsOpenOrder)obj)._ebean_getIdentity());
    }

    public /* synthetic */ int hashCode() {
        return this._ebean_getIdentity().hashCode();
    }

    public /* synthetic */ void _ebean_setEmbeddedLoaded() {
    }

    public /* synthetic */ boolean _ebean_isEmbeddedNewOrDirty() {
        return false;
    }

    public /* synthetic */ Object _ebean_newInstance() {
        return new DsOpenOrder();
    }
}

