/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.database.vo;

import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.AutomaticExport;
import de.businesslogics.banking.database.vo.Tenant;
import de.businesslogics.banking.database.vo.User;
import io.ebean.Query;
import io.ebean.bean.EntityBean;
import io.ebean.bean.EntityBeanIntercept;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.Transient;

@Entity
public class Conversion
implements EntityBean {
    @Id
    private Integer id;
    private String name;
    private Type type;
    private boolean includeHeader;
    private String fieldSeparator;
    private String textSeparator;
    private String dateFormat;
    private String numberFormat;
    @Column(length=500)
    private String fields;
    @ManyToOne(optional=false)
    private Tenant tenant;
    @Transient
    private List<Field> tmpList = null;
    public static /* synthetic */ String[] _ebean_props;
    protected /* synthetic */ EntityBeanIntercept _ebean_intercept;
    protected transient /* synthetic */ Object _ebean_identity;

    public static boolean exists(Collection<String> names, Tenant tenant) {
        int found = DB.find(Conversion.class).where().eq("tenant", (Object)tenant).in("name", names).findCount();
        return found == names.size();
    }

    public static boolean exists(String name, Tenant tenant) {
        int found = DB.find(Conversion.class).where().eq("tenant", (Object)tenant).eq("name", (Object)name).findCount();
        return found == 1;
    }

    public static Conversion byName(String name, Tenant tenant) {
        return (Conversion)Conversion.findQuery(Collections.singletonList(tenant)).where().eq("name", (Object)name).findOne();
    }

    public static List<Conversion> findAllBooking(List<Tenant> tenants) {
        return Conversion.findQuery(tenants).where().in("type", new Object[]{Type.BookingType, Type.BookingTypeCFONB120}).findList();
    }

    public static List<Conversion> findAll(Tenant tenant) {
        return Conversion.findQuery(Collections.singletonList(tenant)).findList();
    }

    public static List<Conversion> findAll(List<Tenant> tenants) {
        return Conversion.findQuery(tenants).findList();
    }

    public static Conversion findById(int id, User user) {
        return (Conversion)Conversion.findQuery(user.getVisibleTenants()).where().eq("id", (Object)id).findOne();
    }

    public static List<Conversion> findByIds(Collection<Integer> ids, User user) {
        return Conversion.findQuery(user.getVisibleTenants()).where().in("id", ids).findList();
    }

    public static Query<Conversion> findQuery(List<Tenant> tenants) {
        return DB.find(Conversion.class).where().in("tenant", tenants).order("name ASC, tenant.name ASC").query();
    }

    public static NameError nameIsValid(Conversion c, String name, Tenant tenant) {
        if (name == null || name.trim().length() == 0) {
            return NameError.EMPTY;
        }
        Conversion exist = (Conversion)DB.find(Conversion.class).where().eq("tenant", (Object)tenant).eq("name", (Object)name).setMaxRows(0).findOne();
        if (exist != null && !((Object)exist).equals(c)) {
            return NameError.EXISTS;
        }
        return NameError.NONE;
    }

    public static String getUniqueName(String name, Tenant tenant) {
        Conversion conversion;
        Object newName = name;
        int nextId = 1;
        do {
            if ((conversion = Conversion.byName((String)newName, tenant)) == null) {
                return newName;
            }
            newName = name + "." + nextId++;
        } while (conversion != null);
        return null;
    }

    public static void delete(Collection<Conversion> conversions) {
        List<AutomaticExport> exports = AutomaticExport.findByConversion(conversions);
        for (AutomaticExport automaticExport : exports) {
            automaticExport.setConversion(null);
            automaticExport.setActivated(false);
            automaticExport.save();
        }
        DB.deleteAll(conversions);
    }

    public static List<Type> getGermanTypes() {
        return Arrays.asList(Type.StatementType, Type.BookingType);
    }

    private static Field fieldById(Integer i) {
        return Field.MAP.get(i);
    }

    public Integer getId() {
        return this._ebean_get_id();
    }

    public void setId(Integer id) {
        this._ebean_set_id(id);
    }

    public String getName() {
        return this._ebean_get_name();
    }

    public void setName(String name) {
        this._ebean_set_name(name);
    }

    public Type getType() {
        return this._ebean_get_type();
    }

    public void setType(Type type) {
        this._ebean_set_type(type);
    }

    public boolean isIncludeHeader() {
        return this._ebean_get_includeHeader();
    }

    public void setIncludeHeader(boolean includeHeader) {
        this._ebean_set_includeHeader(includeHeader);
    }

    public String getFieldSeparator() {
        return this._ebean_get_fieldSeparator();
    }

    public void setFieldSeparator(String fieldSeparator) {
        this._ebean_set_fieldSeparator(fieldSeparator);
    }

    public String getTextSeparator() {
        return this._ebean_get_textSeparator();
    }

    public void setTextSeparator(String textSeparator) {
        this._ebean_set_textSeparator(textSeparator);
    }

    public String getDateFormat() {
        return this._ebean_get_dateFormat();
    }

    public void setDateFormat(String dateFormat) {
        this._ebean_set_dateFormat(dateFormat);
    }

    public String getNumberFormat() {
        return this._ebean_get_numberFormat();
    }

    public void setNumberFormat(String numberFormat) {
        this._ebean_set_numberFormat(numberFormat);
    }

    public String getFields() {
        return this._ebean_get_fields();
    }

    public void setFields(String fields) {
        this._ebean_set_fields(fields);
    }

    public List<Field> getFieldsAsList() {
        if (this.tmpList == null) {
            ArrayList<Field> toReturn = new ArrayList<Field>();
            String fieldstring = this.getFields();
            if (fieldstring != null && fieldstring.trim().length() > 0) {
                String[] fields;
                for (String string : fields = this.getFields().split(",")) {
                    toReturn.add(Conversion.fieldById(Integer.valueOf(string)));
                }
            }
            this.tmpList = toReturn;
        }
        return this.tmpList;
    }

    public void setFieldsAsList(List<Integer> fields) {
        StringBuilder b = new StringBuilder();
        Iterator<Integer> iterator = fields.iterator();
        while (iterator.hasNext()) {
            Integer integer = iterator.next();
            b.append(integer);
            if (!iterator.hasNext()) continue;
            b.append(',');
        }
        this.setFields(b.toString());
    }

    public Tenant getTenant() {
        return this._ebean_get_tenant();
    }

    public void setTenant(Tenant tenant) {
        this._ebean_set_tenant(tenant);
    }

    public void save() {
        if (this.getId() == null) {
            DB.save(this);
        } else {
            DB.update(this);
        }
    }

    public Conversion() {
        this._ebean_intercept = new EntityBeanIntercept((Object)this);
    }

    static {
        _ebean_props = new String[]{"id", "name", "type", "includeHeader", "fieldSeparator", "textSeparator", "dateFormat", "numberFormat", "fields", "tenant", "tmpList"};
    }

    public /* synthetic */ String[] _ebean_getPropertyNames() {
        return _ebean_props;
    }

    public /* synthetic */ String _ebean_getPropertyName(int pos) {
        return _ebean_props[pos];
    }

    public /* synthetic */ EntityBeanIntercept _ebean_getIntercept() {
        return this._ebean_intercept;
    }

    public /* synthetic */ EntityBeanIntercept _ebean_intercept() {
        if (this._ebean_intercept == null) {
            this._ebean_intercept = new EntityBeanIntercept((Object)this);
        }
        return this._ebean_intercept;
    }

    protected /* synthetic */ Integer _ebean_get_id() {
        this._ebean_intercept.preGetId();
        return this.id;
    }

    protected /* synthetic */ void _ebean_set_id(Integer newValue) {
        this._ebean_intercept.preSetter(false, 0, (Object)this.id, (Object)newValue);
        this.id = newValue;
    }

    protected /* synthetic */ Integer _ebean_getni_id() {
        return this.id;
    }

    protected /* synthetic */ void _ebean_setni_id(Integer _newValue) {
        this.id = _newValue;
        this._ebean_intercept.setLoadedProperty(0);
    }

    protected /* synthetic */ String _ebean_get_name() {
        this._ebean_intercept.preGetter(1);
        return this.name;
    }

    protected /* synthetic */ void _ebean_set_name(String newValue) {
        this._ebean_intercept.preSetter(true, 1, (Object)this._ebean_get_name(), (Object)newValue);
        this.name = newValue;
    }

    protected /* synthetic */ String _ebean_getni_name() {
        return this.name;
    }

    protected /* synthetic */ void _ebean_setni_name(String _newValue) {
        this.name = _newValue;
        this._ebean_intercept.setLoadedProperty(1);
    }

    protected /* synthetic */ Type _ebean_get_type() {
        this._ebean_intercept.preGetter(2);
        return this.type;
    }

    protected /* synthetic */ void _ebean_set_type(Type newValue) {
        this._ebean_intercept.preSetter(true, 2, (Object)this._ebean_get_type(), (Object)newValue);
        this.type = newValue;
    }

    protected /* synthetic */ Type _ebean_getni_type() {
        return this.type;
    }

    protected /* synthetic */ void _ebean_setni_type(Type _newValue) {
        this.type = _newValue;
        this._ebean_intercept.setLoadedProperty(2);
    }

    protected /* synthetic */ boolean _ebean_get_includeHeader() {
        this._ebean_intercept.preGetter(3);
        return this.includeHeader;
    }

    protected /* synthetic */ void _ebean_set_includeHeader(boolean newValue) {
        this._ebean_intercept.preSetter(true, 3, this._ebean_get_includeHeader(), newValue);
        this.includeHeader = newValue;
    }

    protected /* synthetic */ boolean _ebean_getni_includeHeader() {
        return this.includeHeader;
    }

    protected /* synthetic */ void _ebean_setni_includeHeader(boolean _newValue) {
        this.includeHeader = _newValue;
        this._ebean_intercept.setLoadedProperty(3);
    }

    protected /* synthetic */ String _ebean_get_fieldSeparator() {
        this._ebean_intercept.preGetter(4);
        return this.fieldSeparator;
    }

    protected /* synthetic */ void _ebean_set_fieldSeparator(String newValue) {
        this._ebean_intercept.preSetter(true, 4, (Object)this._ebean_get_fieldSeparator(), (Object)newValue);
        this.fieldSeparator = newValue;
    }

    protected /* synthetic */ String _ebean_getni_fieldSeparator() {
        return this.fieldSeparator;
    }

    protected /* synthetic */ void _ebean_setni_fieldSeparator(String _newValue) {
        this.fieldSeparator = _newValue;
        this._ebean_intercept.setLoadedProperty(4);
    }

    protected /* synthetic */ String _ebean_get_textSeparator() {
        this._ebean_intercept.preGetter(5);
        return this.textSeparator;
    }

    protected /* synthetic */ void _ebean_set_textSeparator(String newValue) {
        this._ebean_intercept.preSetter(true, 5, (Object)this._ebean_get_textSeparator(), (Object)newValue);
        this.textSeparator = newValue;
    }

    protected /* synthetic */ String _ebean_getni_textSeparator() {
        return this.textSeparator;
    }

    protected /* synthetic */ void _ebean_setni_textSeparator(String _newValue) {
        this.textSeparator = _newValue;
        this._ebean_intercept.setLoadedProperty(5);
    }

    protected /* synthetic */ String _ebean_get_dateFormat() {
        this._ebean_intercept.preGetter(6);
        return this.dateFormat;
    }

    protected /* synthetic */ void _ebean_set_dateFormat(String newValue) {
        this._ebean_intercept.preSetter(true, 6, (Object)this._ebean_get_dateFormat(), (Object)newValue);
        this.dateFormat = newValue;
    }

    protected /* synthetic */ String _ebean_getni_dateFormat() {
        return this.dateFormat;
    }

    protected /* synthetic */ void _ebean_setni_dateFormat(String _newValue) {
        this.dateFormat = _newValue;
        this._ebean_intercept.setLoadedProperty(6);
    }

    protected /* synthetic */ String _ebean_get_numberFormat() {
        this._ebean_intercept.preGetter(7);
        return this.numberFormat;
    }

    protected /* synthetic */ void _ebean_set_numberFormat(String newValue) {
        this._ebean_intercept.preSetter(true, 7, (Object)this._ebean_get_numberFormat(), (Object)newValue);
        this.numberFormat = newValue;
    }

    protected /* synthetic */ String _ebean_getni_numberFormat() {
        return this.numberFormat;
    }

    protected /* synthetic */ void _ebean_setni_numberFormat(String _newValue) {
        this.numberFormat = _newValue;
        this._ebean_intercept.setLoadedProperty(7);
    }

    protected /* synthetic */ String _ebean_get_fields() {
        this._ebean_intercept.preGetter(8);
        return this.fields;
    }

    protected /* synthetic */ void _ebean_set_fields(String newValue) {
        this._ebean_intercept.preSetter(true, 8, (Object)this._ebean_get_fields(), (Object)newValue);
        this.fields = newValue;
    }

    protected /* synthetic */ String _ebean_getni_fields() {
        return this.fields;
    }

    protected /* synthetic */ void _ebean_setni_fields(String _newValue) {
        this.fields = _newValue;
        this._ebean_intercept.setLoadedProperty(8);
    }

    protected /* synthetic */ Tenant _ebean_get_tenant() {
        this._ebean_intercept.preGetter(9);
        return this.tenant;
    }

    protected /* synthetic */ void _ebean_set_tenant(Tenant newValue) {
        this._ebean_intercept.preSetter(true, 9, (Object)this._ebean_get_tenant(), (Object)newValue);
        this.tenant = newValue;
    }

    protected /* synthetic */ Tenant _ebean_getni_tenant() {
        return this.tenant;
    }

    protected /* synthetic */ void _ebean_setni_tenant(Tenant _newValue) {
        this.tenant = _newValue;
        this._ebean_intercept.setLoadedProperty(9);
    }

    protected /* synthetic */ List _ebean_get_tmpList() {
        return this.tmpList;
    }

    protected /* synthetic */ void _ebean_set_tmpList(List newValue) {
        this._ebean_intercept.preSetter(false, 10, (Object)this._ebean_get_tmpList(), (Object)newValue);
        this.tmpList = newValue;
    }

    protected /* synthetic */ List _ebean_getni_tmpList() {
        return this.tmpList;
    }

    protected /* synthetic */ void _ebean_setni_tmpList(List _newValue) {
        this.tmpList = _newValue;
        this._ebean_intercept.setLoadedProperty(10);
    }

    public /* synthetic */ Object _ebean_getField(int index) {
        switch (index) {
            case 0: {
                return this.id;
            }
            case 1: {
                return this.name;
            }
            case 2: {
                return this.type;
            }
            case 3: {
                return this.includeHeader;
            }
            case 4: {
                return this.fieldSeparator;
            }
            case 5: {
                return this.textSeparator;
            }
            case 6: {
                return this.dateFormat;
            }
            case 7: {
                return this.numberFormat;
            }
            case 8: {
                return this.fields;
            }
            case 9: {
                return this.tenant;
            }
            case 10: {
                return this.tmpList;
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    public /* synthetic */ Object _ebean_getFieldIntercept(int index) {
        switch (index) {
            case 0: {
                return this._ebean_get_id();
            }
            case 1: {
                return this._ebean_get_name();
            }
            case 2: {
                return this._ebean_get_type();
            }
            case 3: {
                return this._ebean_get_includeHeader();
            }
            case 4: {
                return this._ebean_get_fieldSeparator();
            }
            case 5: {
                return this._ebean_get_textSeparator();
            }
            case 6: {
                return this._ebean_get_dateFormat();
            }
            case 7: {
                return this._ebean_get_numberFormat();
            }
            case 8: {
                return this._ebean_get_fields();
            }
            case 9: {
                return this._ebean_get_tenant();
            }
            case 10: {
                return this._ebean_get_tmpList();
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    public /* synthetic */ void _ebean_setField(int index, Object o) {
        switch (index) {
            case 0: {
                this._ebean_setni_id((Integer)o);
                return;
            }
            case 1: {
                this._ebean_setni_name((String)o);
                return;
            }
            case 2: {
                this._ebean_setni_type((Type)((Object)o));
                return;
            }
            case 3: {
                this._ebean_setni_includeHeader((Boolean)o);
                return;
            }
            case 4: {
                this._ebean_setni_fieldSeparator((String)o);
                return;
            }
            case 5: {
                this._ebean_setni_textSeparator((String)o);
                return;
            }
            case 6: {
                this._ebean_setni_dateFormat((String)o);
                return;
            }
            case 7: {
                this._ebean_setni_numberFormat((String)o);
                return;
            }
            case 8: {
                this._ebean_setni_fields((String)o);
                return;
            }
            case 9: {
                this._ebean_setni_tenant((Tenant)o);
                return;
            }
            case 10: {
                this._ebean_setni_tmpList((List)o);
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    public /* synthetic */ void _ebean_setFieldIntercept(int index, Object o) {
        switch (index) {
            case 0: {
                this._ebean_set_id((Integer)o);
                return;
            }
            case 1: {
                this._ebean_set_name((String)o);
                return;
            }
            case 2: {
                this._ebean_set_type((Type)((Object)o));
                return;
            }
            case 3: {
                this._ebean_set_includeHeader((Boolean)o);
                return;
            }
            case 4: {
                this._ebean_set_fieldSeparator((String)o);
                return;
            }
            case 5: {
                this._ebean_set_textSeparator((String)o);
                return;
            }
            case 6: {
                this._ebean_set_dateFormat((String)o);
                return;
            }
            case 7: {
                this._ebean_set_numberFormat((String)o);
                return;
            }
            case 8: {
                this._ebean_set_fields((String)o);
                return;
            }
            case 9: {
                this._ebean_set_tenant((Tenant)o);
                return;
            }
            case 10: {
                this._ebean_set_tmpList((List)o);
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private /* synthetic */ Object _ebean_getIdentity() {
        Conversion conversion = this;
        synchronized (conversion) {
            if (this._ebean_identity != null) {
                return this._ebean_identity;
            }
            Object tmpId = this._ebean_getField(0);
            this._ebean_identity = tmpId != null ? tmpId : new Object();
            return this._ebean_identity;
        }
    }

    public /* synthetic */ boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        return this._ebean_getIdentity().equals(((Conversion)obj)._ebean_getIdentity());
    }

    public /* synthetic */ int hashCode() {
        return this._ebean_getIdentity().hashCode();
    }

    public /* synthetic */ void _ebean_setEmbeddedLoaded() {
    }

    public /* synthetic */ boolean _ebean_isEmbeddedNewOrDirty() {
        return false;
    }

    public /* synthetic */ Object _ebean_newInstance() {
        return new Conversion();
    }

    public static enum Type {
        StatementType(1),
        BookingType(2),
        StatementTypeCFONB120(11),
        BookingTypeCFONB120(12);

        private final int id;

        private Type(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }
    }

    public static enum NameError {
        EXISTS,
        EMPTY,
        NONE;

    }

    public static enum Field {
        EMPTY(0),
        STATEMENT_FORMAT(1),
        STATEMENT_BANK_NAME(2),
        STATEMENT_ACCOUNT_NAME(3),
        STATEMENT_ACCOUNT_IDENTIFIER(4),
        STATEMENT_BANK_CODE(5),
        STATEMENT_ACCOUNT_NUMBER(6),
        STATEMENT_CURRENCY(7),
        STATEMENT_DATE(8),
        STATEMENT_BALANCE(9),
        STATEMENT_OPENING_DATE(10),
        STATEMENT_OPENING_BALANCE(11),
        STATEMENT_NUMBER(12),
        STATEMENT_SUB_NUMBER(13),
        STATEMENT_NUMBER_WITH_SUB_NUMBER(14),
        STATEMENT_COUNT_BOOKINGS(15),
        STATEMENT_SUM_CREDITS(16),
        STATEMENT_SUM_DEBITS(17),
        STATEMENT_COUNT_CREDITS(18),
        STATEMENT_COUNT_DEBITS(19),
        STATEMENT_HIGHEST_CREDIT(20),
        STATEMENT_SMALLEST_CREDIT(21),
        STATEMENT_HIGHEST_DEBIT(22),
        STATEMENT_SMALLEST_DEBIT(23),
        STATEMENT_REFERENCE_1(24),
        STATEMENT_REFERENCE_2(25),
        STATEMENT_ACCOUNT_HOLDER(26),
        STATEMENT_LEGAL_NUMBER(27),
        STATEMENT_BRANCH_CODE(31),
        STATEMENT_RIB(32),
        STATEMENT_IBAN(33),
        STATEMENT_BIC(34),
        BOOKING_AMOUNT(101),
        BOOKING_VALUE_DATE(103),
        BOOKING_BOOKING_DATE(104),
        BOOKING_PURPOSE(105),
        BOOKING_TOTAL_PURPOSE(106),
        BOOKING_REVERSAL(107),
        BOOKING_ABSOLUTE_AMOUNT(108),
        BOOKING_AMOUNT_SIGN_FLAG(109),
        BOOKING_COUNTERPARTY(111),
        BOOKING_COUNTERPARTY_BANK_CODE(112),
        BOOKING_COUNTERPARTY_ACCOUNT_NUMBER(113),
        BOOKING_COUNTERPARTY_BRANCH_CODE(114),
        BOOKING_COUNTERPARTY_RIB(115),
        BOOKING_LOCALPARTY(116),
        BOOKING_LOCALPARTY_BANK_CODE(117),
        BOOKING_LOCALPARTY_ACCOUNT_NUMBER(118),
        BOOKING_LOCALPARTY_BRANCH_CODE(119),
        BOOKING_LOCALPARTY_RIB(120),
        BOOKING_ORIGINAL_AMOUNT(121),
        BOOKING_ORIGINAL_CURRENCY(122),
        BOOKING_CHARGES_AMOUNT(123),
        BOOKING_CHARGES_CURRENCY(124),
        BOOKING_TRANSACTION_CODE(150),
        MT94X_BOOKING_BOOKING_KEY(151),
        MT94X_BOOKING_CUSTOMER_REFERENCE(152),
        MT94X_BOOKING_BANK_REFERENCE(153),
        MT94X_BOOKING_ADDITIONAL_INFO(154),
        MT94X_BOOKING_FIELD_END_TO_END_ID(155),
        MT94X_BOOKING_FIELD_MANDATE_REFERENCE(156),
        MT94X_BOOKING_FIELD_CREDITOR_ID(157),
        MT94X_BOOKING_GVC(161),
        MT94X_BOOKING_BOOKING_TEXT(162),
        MT94X_BOOKING_PRIMANOTA(163),
        MT94X_BOOKING_TEXT_KEY_APPENDIX(164),
        BOOKING_ORIG_RECIP_1(165),
        BOOKING_ORIG_RECIP_2(166),
        BOOKING_PURPOSE_2(171),
        BOOKING_PURPOSE_3(172),
        BOOKING_PURPOSE_4(173),
        BOOKING_PURPOSE_5(174),
        BOOKING_PURPOSE_6(175),
        BOOKING_PURPOSE_7(176),
        BOOKING_PURPOSE_8(177),
        BOOKING_PURPOSE_9(178),
        BOOKING_PURPOSE_10(179),
        BOOKING_PURPOSE_11(180),
        BOOKING_PURPOSE_12(181),
        BOOKING_PURPOSE_13(182),
        BOOKING_PURPOSE_14(183),
        BOOKING_UNIQUE_ID(190),
        BOOKING_FEE_TYPE(191),
        BOOKING_TRX_ID(192),
        BOOKING_CURRENT_BALANCE(193),
        BOOKING_PURPOSE_CODE(194),
        CFONB_BOOKING_BNP_PARIBAS_TRANSACTION_CODE(301),
        CFONB_BOOKING_INTERBANK_TRANSACTION_CODE(302),
        CFONB_BOOKING_REJECTION_CAUSE_CODE(303),
        CFONB_BOOKING_ENTRY_NUMBER(304),
        CFONB_BOOKING_EXEMPTION(305),
        CFONB_BOOKING_UNAVAILABILITY_RATING(306);

        private static final HashMap<Integer, Field> MAP;
        private final int id;

        private Field(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }

        static {
            MAP = new HashMap();
            for (Field f : Field.values()) {
                MAP.put(f.id, f);
            }
        }
    }
}

