/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.database.vo;

import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.Account;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.CmBalance;
import de.businesslogics.banking.database.vo.CmBank;
import de.businesslogics.banking.database.vo.CmBooking;
import de.businesslogics.banking.database.vo.WorkspaceFile;
import de.businesslogics.util.Currency;
import io.ebean.Expr;
import io.ebean.Expression;
import io.ebean.ExpressionList;
import io.ebean.PagedList;
import io.ebean.Query;
import io.ebean.SqlQuery;
import io.ebean.SqlRow;
import io.ebean.bean.EntityBean;
import io.ebean.bean.EntityBeanIntercept;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.UniqueConstraint;

@Entity
@UniqueConstraint(columnNames={"account_id", "unique_id"})
public class CmStatement
implements EntityBean {
    private static final long ONE_DAY = 86400000L;
    public static final Set<Type> StatementTypes;
    public static final Set<Type> AdviceTypes;
    public static final Set<Type> AdviceTypesWithoutCreditAdvices;
    public static final Set<Type> StatementAndAdviceTypes;
    public static final Set<Type> DtiTypes;
    public static final Set<Type> DtiTypesWithVirtual;
    public static final Set<Type> BbkTypes;
    @Id
    private Integer id;
    @ManyToOne
    private Account account;
    private Timestamp creationDate;
    private String reference1;
    private String reference2;
    private Date openingDate;
    @Column(precision=38, scale=3)
    private BigDecimal openingBalance;
    private boolean openingFinal;
    private Date closingDate;
    @Column(precision=38, scale=3)
    private BigDecimal closingBalance;
    private boolean closingFinal;
    @Column(length=3)
    private String currencyCode;
    private Integer statementNumber;
    private Integer pageNumber;
    private Integer legalNumber;
    private String uniqueId;
    private Integer countCredit;
    private Integer countDebit;
    @Column(precision=38, scale=3)
    private BigDecimal sumCredit;
    @Column(precision=38, scale=3)
    private BigDecimal sumDebit;
    @Column(precision=38, scale=3)
    private BigDecimal maxCredit;
    @Column(precision=38, scale=3)
    private BigDecimal minCredit;
    @Column(precision=38, scale=3)
    private BigDecimal maxDebit;
    @Column(precision=38, scale=3)
    private BigDecimal minDebit;
    @Column(nullable=false)
    private Type type;
    private String originalFilename;
    @Column(length=500)
    private String additionalInformation;
    @ManyToOne
    private WorkspaceFile file;
    public static /* synthetic */ String[] _ebean_props;
    protected /* synthetic */ EntityBeanIntercept _ebean_intercept;
    protected transient /* synthetic */ Object _ebean_identity;

    public CmStatement() {
        this._ebean_intercept = new EntityBeanIntercept((Object)this);
        this._ebean_set_openingFinal(true);
        this._ebean_set_closingFinal(true);
    }

    public boolean isStatement() {
        return StatementTypes.contains((Object)this._ebean_get_type());
    }

    public boolean isAdvice() {
        return AdviceTypes.contains((Object)this._ebean_get_type());
    }

    public boolean isCreditAdvice() {
        return Type.CAMT054Advice.equals((Object)this._ebean_get_type());
    }

    public boolean isDtiFile() {
        return DtiTypesWithVirtual.contains((Object)this._ebean_get_type());
    }

    public boolean isBbkFile() {
        return BbkTypes.contains((Object)this._ebean_get_type());
    }

    public boolean isMT94xFormat() {
        return this._ebean_get_type() != null && (this._ebean_get_type().equals((Object)Type.MT940) || this._ebean_get_type().equals((Object)Type.MT942));
    }

    public boolean isCamtFormat() {
        return this._ebean_get_type() != null && (this._ebean_get_type().equals((Object)Type.CAMT053) || this._ebean_get_type().equals((Object)Type.CAMT052) || this._ebean_get_type().equals((Object)Type.CAMT054));
    }

    public boolean isCFONB120Format() {
        return this._ebean_get_type() != null && this._ebean_get_type().equals((Object)Type.CFONB120);
    }

    public static boolean isCamtFormat(Type t) {
        return t != null && (t.equals((Object)Type.CAMT053) || t.equals((Object)Type.CAMT052) || t.equals((Object)Type.CAMT054));
    }

    public static boolean isMT94xFormat(Type t) {
        return t != null && (t.equals((Object)Type.MT940) || t.equals((Object)Type.MT942));
    }

    public static boolean isStatementFormat(Type t) {
        return StatementTypes.contains((Object)t);
    }

    public static boolean isAdviceFormat(Type t) {
        return AdviceTypes.contains((Object)t);
    }

    public static boolean isBatchedTransactionFileFormat(Type t) {
        return !CmStatement.isStatementFormat(t) && !CmStatement.isAdviceFormat(t);
    }

    public static boolean isVirtualStatement(Object o) {
        if (o instanceof CmStatement) {
            return CmStatement.isVirtualStatement(((CmStatement)o).getType());
        }
        return false;
    }

    public static boolean isVirtualStatement(Type t) {
        return Type.LOGICAL_PAYMENT_FILE.equals((Object)t);
    }

    public String getFormatName() {
        if (this._ebean_get_type() != null) {
            return this._ebean_get_type().toString();
        }
        return null;
    }

    public static Set<Integer> findOldStatementIds(CleanupDateType cleanupDateType, Date older, Set<Type> statementTypes) {
        HashSet<Integer> ids = new HashSet<Integer>();
        if (CleanupDateType.BOOKING_DATE.equals((Object)cleanupDateType)) {
            String sb = "SELECT cm_statement.id AS id, max(cm_booking.booking_date) AS maxdate FROM cm_statement LEFT JOIN cm_booking ON cm_statement.id = cm_booking.statement_id WHERE cm_statement.type in (" + CmStatement.getRawTypes(statementTypes) + ") AND cm_statement.creation_date < :statementDate GROUP BY cm_statement.id HAVING max(cm_booking.booking_date) < :date OR max(cm_booking.booking_date) is null";
            SqlQuery query = DB.sqlQuery(sb);
            query.setParameter("date", (Object)older);
            query.setParameter("statementDate", (Object)older);
            List list = query.findList();
            for (SqlRow row : list) {
                ids.add(row.getInteger("id"));
            }
        } else if (CleanupDateType.VALUE_DATE.equals((Object)cleanupDateType)) {
            String sb = "SELECT cm_statement.id AS id, max(cm_booking.value_date) AS maxdate FROM cm_statement LEFT JOIN cm_booking ON cm_statement.id = cm_booking.statement_id WHERE cm_statement.type in (" + CmStatement.getRawTypes(statementTypes) + ") AND cm_statement.creation_date < :statementDate GROUP BY cm_statement.id HAVING max(cm_booking.value_date) < :date or max(cm_booking.booking_date) is null";
            SqlQuery query = DB.sqlQuery(sb);
            query.setParameter("date", (Object)older);
            query.setParameter("statementDate", (Object)older);
            List list = query.findList();
            for (SqlRow row : list) {
                ids.add(row.getInteger("id"));
            }
        } else {
            Query query = DB.find(CmStatement.class).where().lt("creationDate", (Object)older).in("type", statementTypes).query();
            query.findEach(bean -> ids.add(bean.id));
        }
        return ids;
    }

    public static String getRawTypes(Set<Type> types) {
        StringBuilder b = new StringBuilder();
        boolean first = true;
        for (Type t : types) {
            if (!first) {
                b.append(",");
            } else {
                first = false;
            }
            b.append(t.ordinal());
        }
        return b.toString();
    }

    public static CmStatement findNewestStatement(Account account, Type type) {
        return (CmStatement)DB.find(CmStatement.class).where().eq("account", (Object)account).eq("type", (Object)type).orderBy("closingDate DESC, statementNumber DESC").setMaxRows(1).findOne();
    }

    public static CmStatement findOldestStatement(Account account, Type type) {
        return (CmStatement)DB.find(CmStatement.class).where().eq("account", (Object)account).eq("type", (Object)type).orderBy("closingDate ASC, statementNumber ASC").setMaxRows(1).findOne();
    }

    public static Query<CmStatement> findByBank(BankSettings bank) {
        return DB.find(CmStatement.class).where().eq("account.bank", (Object)bank).query();
    }

    public static CmStatement findAccountStatementForDtiFile(CmStatement dtiFile) {
        CmBooking withParent = (CmBooking)DB.find(CmBooking.class).where().eq("statement", (Object)dtiFile).isNotNull("parentBooking").setMaxRows(1).findOne();
        if (withParent != null) {
            return withParent.getParentBooking().getStatement();
        }
        return null;
    }

    public static PagedList<CmStatement> findByAccount(Account account, Type statementType, Type adviceType, int pageIndex, int pageSize, boolean descending, Date fromDate, Date toDate) {
        HashSet<Type> types = new HashSet<Type>();
        if (statementType != null) {
            types.add(statementType);
        }
        if (adviceType != null) {
            types.add(adviceType);
        }
        Query<CmStatement> query = CmStatement.findQueryForAccount(account, types, fromDate, toDate);
        if (descending) {
            query.orderBy("creationDate DESC, statementNumber DESC");
        } else {
            query.orderBy("creationDate ASC, statementNumber ASC");
        }
        return query.setMaxRows(pageSize).findPagedList();
    }

    public static CmStatement findNewestAdvice(Account account, Date periodEndDate) {
        return (CmStatement)CmStatement.findQueryForAccount(account, AdviceTypes, null, periodEndDate).orderBy("creationDate DESC, statementNumber DESC").setMaxRows(1).findOne();
    }

    public static CmStatement findNewestNonCreditAdvice(Account account, Date periodEndDate) {
        return (CmStatement)CmStatement.findQueryForAccount(account, AdviceTypesWithoutCreditAdvices, null, periodEndDate).orderBy("creationDate DESC, statementNumber DESC").setMaxRows(1).findOne();
    }

    public static CmStatement findNewestStatement(Account account, Date periodEndDate) {
        return (CmStatement)CmStatement.findQueryForAccount(account, StatementTypes, null, periodEndDate).orderBy("closingDate DESC, statementNumber DESC").setMaxRows(1).findOne();
    }

    public static List<Integer> findStatementAndAdvicesYears(Account account) {
        TreeSet<Integer> tmp = new TreeSet<Integer>();
        SqlQuery query = DB.sqlQuery("select distinct closing_date as YEAROFSTMT from cm_statement where closing_date is not null and account_id=:accountId AND type in (:types) ORDER BY YEAROFSTMT DESC");
        query.setParameter("accountId", (Object)account.getId());
        query.setParameter("types", StatementAndAdviceTypes);
        List list = query.findList();
        Calendar calendar = Calendar.getInstance();
        for (SqlRow row : list) {
            Date date = row.getDate("YEAROFSTMT");
            if (date == null) continue;
            tmp.add(date.toLocalDate().getYear());
        }
        return new ArrayList<Integer>(tmp.descendingSet());
    }

    public static PagedList<CmStatement> findStatementsAndAdvices(Account account, int pageIndex, int pageSize, boolean descending, Date fromDate, Date toDate) {
        Query<CmStatement> query = CmStatement.findQueryForAccount(account, StatementAndAdviceTypes, fromDate, toDate);
        if (descending) {
            query.orderBy("creationDate DESC, statementNumber DESC");
        } else {
            query.orderBy("creationDate ASC, statementNumber ASC");
        }
        return query.setMaxRows(pageSize).setFirstRow(pageIndex * pageSize).findPagedList();
    }

    public static PagedList<CmStatement> findStatements(Account account, int pageIndex, int pageSize, boolean descending, Date fromDate, Date toDate) {
        Query<CmStatement> query = CmStatement.findQueryForAccount(account, StatementTypes, fromDate, toDate);
        if (descending) {
            query.orderBy("creationDate DESC, statementNumber DESC");
        } else {
            query.orderBy("creationDate ASC, statementNumber ASC");
        }
        return query.setMaxRows(pageSize).setFirstRow(pageIndex * pageSize).findPagedList();
    }

    public static List<CmStatement> findByAccount(Account account, Set<Type> types, boolean descending, Date fromDate, Date toDate) {
        Query<CmStatement> query = CmStatement.findQueryForAccount(account, types, fromDate, toDate);
        if (descending) {
            query.orderBy("creationDate DESC, statementNumber DESC");
        } else {
            query.orderBy("creationDate ASC, statementNumber ASC");
        }
        return query.findList();
    }

    public static int findTotalCountForAccount(Account account) {
        return DB.find(CmStatement.class).where(Expr.eq((String)"account", (Object)account)).findCount();
    }

    public static int findTotalCount() {
        return DB.find(CmStatement.class).findCount();
    }

    public static int findCountForAccount(Account account, Type statementType, Type adviceType, Date fromDate, Date toDate) {
        HashSet<Type> types = new HashSet<Type>();
        if (statementType != null) {
            types.add(statementType);
        }
        if (adviceType != null) {
            types.add(adviceType);
        }
        return CmStatement.findQueryForAccount(account, types, fromDate, toDate).findCount();
    }

    public static int findCountStatements(Account account, Date fromDate, Date toDate) {
        return CmStatement.findQueryForAccount(account, StatementTypes, fromDate, toDate).findCount();
    }

    public static int findCountStatementsAndAdvices(Account account, Date fromDate, Date toDate) {
        return CmStatement.findQueryForAccount(account, StatementAndAdviceTypes, fromDate, toDate).findCount();
    }

    public static int findCountDtiFiles(Account account, Date fromDate, Date toDate) {
        return CmStatement.findCountDtiFiles(account, fromDate, toDate, false);
    }

    public static int findCountDtiFiles(Account account, Date fromDate, Date toDate, boolean withVirtual) {
        return CmStatement.findQueryForAccount(account, withVirtual ? DtiTypesWithVirtual : DtiTypes, fromDate, toDate).findCount();
    }

    public static PagedList<CmStatement> findDtiFiles(Account account, int pageIndex, int pageSize, boolean descending, Date fromDate, Date toDate) {
        return CmStatement.findDtiFiles(account, pageIndex, pageSize, descending, fromDate, toDate, false);
    }

    public static PagedList<CmStatement> findDtiFiles(Account account, int pageIndex, int pageSize, boolean descending, Date fromDate, Date toDate, boolean withVirtual) {
        Query<CmStatement> query = CmStatement.findQueryForAccount(account, withVirtual ? DtiTypesWithVirtual : DtiTypes, fromDate, toDate);
        if (descending) {
            query.orderBy("creationDate DESC, reference1 DESC");
        } else {
            query.orderBy("creationDate ASC, reference1 ASC");
        }
        return query.setMaxRows(pageSize).setFirstRow(pageIndex * pageSize).findPagedList();
    }

    public static Query<CmStatement> findDtiFiles(Account account, String reference, Timestamp from, Timestamp to) {
        if (reference == null || reference.trim().length() == 0) {
            return null;
        }
        Query<CmStatement> query = CmStatement.findQueryForAccount(account, DtiTypes, null, null);
        return query.where().like("reference1", "%" + reference.trim()).between("creationDate", (Object)from, (Object)to).query();
    }

    public static int findStatementCountForAccount(Account account, Type type) {
        HashSet<Type> types = new HashSet<Type>();
        types.add(type);
        return CmStatement.findQueryForAccount(account, types, null, null).findCount();
    }

    public static Map<Date, BigDecimal> findBookingBalanceValueDateMap(Account a) {
        Date openingDate;
        HashSet<Date> valueDates = new HashSet<Date>();
        List balances = DB.find(CmBalance.class).where().eq("account", (Object)a).orderBy("valueDate ASC").findList();
        for (CmBalance balance : balances) {
            valueDates.add(balance.getVauleDate());
        }
        HashMap<Date, BigDecimal> bookingBalanceMap = new HashMap<Date, BigDecimal>();
        List statements = DB.find(CmStatement.class).where().eq("account", (Object)a).in("type", StatementTypes).orderBy("closingDate ASC").findList();
        for (CmStatement statement : statements) {
            Date closingDate = statement.getClosingDate();
            if (!valueDates.contains(closingDate)) continue;
            bookingBalanceMap.put(closingDate, statement.getClosingBalance());
        }
        CmStatement oldestStatement = CmStatement.findOldestStatement(a);
        if (oldestStatement != null && (openingDate = oldestStatement.getOpeningDate()) != null && !openingDate.equals(oldestStatement.getClosingDate()) && valueDates.contains(openingDate)) {
            bookingBalanceMap.put(openingDate, oldestStatement.getOpeningBalance());
        }
        return bookingBalanceMap;
    }

    public static BigDecimal findBookingBalance(Account account, Date date) {
        Date openingDate;
        CmStatement s = CmStatement.findNewestStatement(account, date);
        if (s != null) {
            return s.getClosingBalance();
        }
        s = CmStatement.findOldestStatement(account);
        if (s != null && !date.before(openingDate = s.getOpeningDate())) {
            return s.getOpeningBalance();
        }
        return null;
    }

    private static CmStatement findOldestStatement(Account account) {
        return (CmStatement)DB.find(CmStatement.class).where().eq("account", (Object)account).in("type", StatementTypes).orderBy("closingDate ASC, statementNumber ASC").setMaxRows(1).findOne();
    }

    public static CmStatement findByAccountAndUniqueId(Account account, String uniqueId) {
        Expression expr = Expr.eq((String)"account", (Object)account);
        expr = Expr.and((Expression)expr, (Expression)Expr.eq((String)"uniqueId", (Object)uniqueId));
        return (CmStatement)DB.find(CmStatement.class).where(expr).findOne();
    }

    public static CmStatement findById(int id) {
        return (CmStatement)DB.find(CmStatement.class).where().eq("id", (Object)id).findOne();
    }

    private static Query<CmStatement> findQueryForAccount(Account account, Set<Type> types, Date fromDate, Date toDate) {
        ExpressionList result = DB.find(CmStatement.class).where().eq("account", (Object)account);
        if (types != null && types.size() == 1) {
            result.eq("type", types.toArray()[0]);
        } else if (types != null && types.size() > 1) {
            result.in("type", types);
        }
        if (fromDate != null) {
            result.add(Expr.or((Expression)Expr.ge((String)"closingDate", (Object)fromDate), (Expression)Expr.and((Expression)Expr.isNull((String)"closingDate"), (Expression)Expr.ge((String)"creationDate", (Object)fromDate))));
        }
        if (toDate != null) {
            Date nextDay = new Date(toDate.getTime() + 86400000L);
            result.add(Expr.or((Expression)Expr.le((String)"closingDate", (Object)toDate), (Expression)Expr.and((Expression)Expr.isNull((String)"closingDate"), (Expression)Expr.lt((String)"creationDate", (Object)nextDay))));
        }
        return result.query();
    }

    public static List<CmStatement> findObsoleteMT940Statements() {
        ArrayList<CmStatement> allObsoleteMT940Statements = new ArrayList<CmStatement>();
        Map<Integer, List<Date>> map = CmStatement.findAccountsWithMultipleStatementsWithSameDate();
        for (Integer accountId : map.keySet()) {
            List<Date> dates = map.get(accountId);
            for (Date date : dates) {
                List<CmStatement> obsoleteMt940Statements = CmStatement.findObsoleteMT940Statements(accountId, date);
                if (obsoleteMt940Statements == null) continue;
                allObsoleteMT940Statements.addAll(obsoleteMt940Statements);
            }
        }
        return allObsoleteMT940Statements;
    }

    private static Map<Integer, List<Date>> findAccountsWithMultipleStatementsWithSameDate() {
        HashMap<Integer, List<Date>> accountDatesWithMultipleStatementsMap = new HashMap<Integer, List<Date>>();
        HashSet<Type> types = new HashSet<Type>();
        types.add(Type.MT940);
        types.add(Type.CAMT053);
        String sb = "select account_id, closing_date, count(*) from cm_statement where type in (" + CmStatement.getRawTypes(types) + ") group by account_id, closing_date having count(*) >=2";
        SqlQuery query = DB.sqlQuery(sb);
        List list = query.findList();
        for (SqlRow row : list) {
            Integer accountId = row.getInteger("account_id");
            Date dateWithMultipleStatements = row.getDate("closing_date");
            if (!accountDatesWithMultipleStatementsMap.containsKey(accountId)) {
                accountDatesWithMultipleStatementsMap.put(accountId, new ArrayList());
            }
            ((List)accountDatesWithMultipleStatementsMap.get(accountId)).add(dateWithMultipleStatements);
        }
        return accountDatesWithMultipleStatementsMap;
    }

    private static List<CmStatement> findObsoleteMT940Statements(Integer accountId, Date closingDate) {
        boolean hasCamt053 = false;
        ArrayList<CmStatement> mt940statements = new ArrayList<CmStatement>();
        Set<BankSettings> camt053Banks = CmBank.findBanksWithStatementFormat("CAMT053");
        Account a = Account.findById(accountId);
        if (a != null && camt053Banks.contains(a.getBank())) {
            HashSet<Type> types = new HashSet<Type>();
            types.add(Type.MT940);
            types.add(Type.CAMT053);
            List statements = DB.find(CmStatement.class).where().eq("account", (Object)a).eq("closingDate", (Object)closingDate).in("type", types).findList();
            for (CmStatement statement : statements) {
                if (Type.CAMT053.equals((Object)statement.getType())) {
                    hasCamt053 = true;
                    continue;
                }
                if (!Type.MT940.equals((Object)statement.getType())) continue;
                mt940statements.add(statement);
            }
        }
        if (hasCamt053) {
            return mt940statements;
        }
        return null;
    }

    public static CmStatement createStatement(String uniqueId, Type type, Account account) {
        CmStatement statement = new CmStatement();
        statement.setUniqueId(uniqueId);
        statement.setType(type);
        statement.setAccount(account);
        return statement;
    }

    public Integer getId() {
        return this._ebean_get_id();
    }

    public void setId(Integer id) {
        this._ebean_set_id(id);
    }

    public Account getAccount() {
        return this._ebean_get_account();
    }

    public void setAccount(Account account) {
        this._ebean_set_account(account);
    }

    public Date getClosingDate() {
        return this._ebean_get_closingDate();
    }

    public void setClosingDate(Date closingDate) {
        this._ebean_set_closingDate(closingDate);
    }

    public BigDecimal getClosingBalance() {
        return this._ebean_get_closingBalance();
    }

    public void setClosingBalance(BigDecimal closingBalance) {
        this._ebean_set_closingBalance(closingBalance);
    }

    public Integer getStatementNumber() {
        return this._ebean_get_statementNumber();
    }

    public void setStatementNumber(Integer statementNumber) {
        this._ebean_set_statementNumber(statementNumber);
    }

    public Integer getLegalNumber() {
        return this._ebean_get_legalNumber();
    }

    public Integer getStatementNumberToDisplay() {
        return this._ebean_get_legalNumber() != null ? this._ebean_get_legalNumber() : this._ebean_get_statementNumber();
    }

    public void setLegalNumber(Integer legalNumber) {
        this._ebean_set_legalNumber(legalNumber);
    }

    public boolean isHasPages() {
        if (Type.LOGICAL_PAYMENT_FILE.equals((Object)this._ebean_get_type())) {
            return false;
        }
        return this._ebean_get_file() == null;
    }

    public Currency getCurrency() {
        try {
            if (this.getCurrencyCode() == null) {
                return null;
            }
            return Currency.getInstance(this.getCurrencyCode());
        }
        catch (IllegalArgumentException unknown) {
            return null;
        }
    }

    public void setCurrency(Currency currency) {
        this.setCurrencyCode(currency.getCurrencyCode());
    }

    public String getCurrencyCode() {
        return this._ebean_get_currencyCode();
    }

    public void setCurrencyCode(String currencyCode) {
        this._ebean_set_currencyCode(currencyCode);
    }

    public Type getType() {
        return this._ebean_get_type();
    }

    public void setType(Type type) {
        this._ebean_set_type(type);
    }

    public Date getOpeningDate() {
        return this._ebean_get_openingDate();
    }

    public void setOpeningDate(Date openingDate) {
        this._ebean_set_openingDate(openingDate);
    }

    public BigDecimal getOpeningBalance() {
        return this._ebean_get_openingBalance();
    }

    public void setOpeningBalance(BigDecimal openingBalance) {
        this._ebean_set_openingBalance(openingBalance);
    }

    public String getUniqueId() {
        return this._ebean_get_uniqueId();
    }

    public void setUniqueId(String uniqueId) {
        this._ebean_set_uniqueId(uniqueId);
    }

    public int getCountCredit() {
        if (this._ebean_get_countCredit() == null) {
            return 0;
        }
        return this._ebean_get_countCredit();
    }

    public void setCountCredit(int countCredit) {
        this._ebean_set_countCredit(countCredit);
    }

    public int getCountDebit() {
        if (this._ebean_get_countDebit() == null) {
            return 0;
        }
        return this._ebean_get_countDebit();
    }

    public void setCountDebit(int countDebit) {
        this._ebean_set_countDebit(countDebit);
    }

    public BigDecimal getSumCredit() {
        return this._ebean_get_sumCredit();
    }

    public void setSumCredit(BigDecimal sumCredit) {
        this._ebean_set_sumCredit(sumCredit);
    }

    public BigDecimal getSumDebit() {
        return this._ebean_get_sumDebit();
    }

    public void setSumDebit(BigDecimal sumDebit) {
        this._ebean_set_sumDebit(sumDebit);
    }

    public int getCountBookings() {
        return this.getCountCredit() + this.getCountDebit();
    }

    public BigDecimal getTotalSum() {
        BigDecimal totalSum;
        BigDecimal bigDecimal = totalSum = this._ebean_get_sumCredit() != null ? this._ebean_get_sumCredit() : BigDecimal.ZERO;
        if (this._ebean_get_sumDebit() != null) {
            totalSum = totalSum.add(this._ebean_get_sumDebit());
        }
        return totalSum;
    }

    public BigDecimal getMaxCredit() {
        return this._ebean_get_maxCredit();
    }

    public void setMaxCredit(BigDecimal maxCredit) {
        this._ebean_set_maxCredit(maxCredit);
    }

    public BigDecimal getMinCredit() {
        return this._ebean_get_minCredit();
    }

    public void setMinCredit(BigDecimal minCredit) {
        this._ebean_set_minCredit(minCredit);
    }

    public BigDecimal getMaxDebit() {
        return this._ebean_get_maxDebit();
    }

    public void setMaxDebit(BigDecimal maxDebit) {
        this._ebean_set_maxDebit(maxDebit);
    }

    public BigDecimal getMinDebit() {
        return this._ebean_get_minDebit();
    }

    public void setMinDebit(BigDecimal minDebit) {
        this._ebean_set_minDebit(minDebit);
    }

    public Timestamp getCreationDate() {
        return this._ebean_get_creationDate();
    }

    public void setCreationDate(Timestamp creationDate) {
        this._ebean_set_creationDate(creationDate);
    }

    public String getReference1() {
        return this._ebean_get_reference1();
    }

    public void setReference1(String reference1) {
        this._ebean_set_reference1(reference1);
    }

    public String getReference2() {
        return this._ebean_get_reference2();
    }

    public void setReference2(String reference2) {
        this._ebean_set_reference2(reference2);
    }

    public boolean isOpeningFinal() {
        return this._ebean_get_openingFinal();
    }

    public void setOpeningFinal(boolean openingFinal) {
        this._ebean_set_openingFinal(openingFinal);
    }

    public boolean isClosingFinal() {
        return this._ebean_get_closingFinal();
    }

    public void setClosingFinal(boolean closingFinal) {
        this._ebean_set_closingFinal(closingFinal);
    }

    public Integer getPageNumber() {
        return this._ebean_get_pageNumber();
    }

    public void setPageNumber(Integer pageNumber) {
        this._ebean_set_pageNumber(pageNumber);
    }

    public int getPageNumberAsInt() {
        return this._ebean_get_pageNumber() == null ? 0 : this._ebean_get_pageNumber();
    }

    public void setPageNumberAsInt(int pageNumber) {
        this._ebean_set_pageNumber(pageNumber == 0 ? null : Integer.valueOf(pageNumber));
    }

    public String getOriginalFilename() {
        return this._ebean_get_originalFilename();
    }

    public void setOriginalFilename(String originalFilename) {
        this._ebean_set_originalFilename(originalFilename);
    }

    public String getAdditionalInformation() {
        return this._ebean_get_additionalInformation();
    }

    public void setAdditionalInformation(String additionalInformation) {
        this._ebean_set_additionalInformation(additionalInformation);
    }

    public WorkspaceFile getFile() {
        return this._ebean_get_file();
    }

    public long getSize() {
        if (this.getFile() == null) {
            return 0L;
        }
        return this.getFile().getSize();
    }

    public void setFile(WorkspaceFile file) {
        this._ebean_set_file(file);
    }

    public String getMd5Hash() {
        return this._ebean_get_file().getMd5Hash();
    }

    static {
        _ebean_props = new String[]{"id", "account", "creationDate", "reference1", "reference2", "openingDate", "openingBalance", "openingFinal", "closingDate", "closingBalance", "closingFinal", "currencyCode", "statementNumber", "pageNumber", "legalNumber", "uniqueId", "countCredit", "countDebit", "sumCredit", "sumDebit", "maxCredit", "minCredit", "maxDebit", "minDebit", "type", "originalFilename", "additionalInformation", "file"};
        StatementTypes = new HashSet<Type>();
        StatementTypes.add(Type.MT940);
        StatementTypes.add(Type.CAMT053);
        StatementTypes.add(Type.CFONB120);
        AdviceTypesWithoutCreditAdvices = new HashSet<Type>();
        AdviceTypesWithoutCreditAdvices.add(Type.MT942);
        AdviceTypesWithoutCreditAdvices.add(Type.CAMT052);
        AdviceTypes = new HashSet<Type>();
        AdviceTypes.add(Type.MT942);
        AdviceTypes.add(Type.CAMT052);
        AdviceTypes.add(Type.CAMT054Advice);
        StatementAndAdviceTypes = new HashSet<Type>();
        StatementAndAdviceTypes.addAll(StatementTypes);
        StatementAndAdviceTypes.addAll(AdviceTypes);
        DtiTypes = new HashSet<Type>();
        DtiTypes.add(Type.DTI);
        DtiTypes.add(Type.CAMT054);
        BbkTypes = new HashSet<Type>();
        BbkTypes.add(Type.YG1);
        BbkTypes.add(Type.YG2);
        BbkTypes.add(Type.YWA);
        BbkTypes.add(Type.YGB);
        BbkTypes.add(Type.YLB);
        BbkTypes.add(Type.YGD);
        BbkTypes.add(Type.YGS);
        BbkTypes.add(Type.YCG);
        BbkTypes.add(Type.YCL);
        BbkTypes.add(Type.YCD);
        BbkTypes.add(Type.YCS);
        BbkTypes.add(Type.QG3);
        BbkTypes.add(Type.QG4);
        BbkTypes.add(Type.QWA);
        BbkTypes.add(Type.QE2);
        BbkTypes.add(Type.QE4);
        BbkTypes.add(Type.QE6);
        BbkTypes.add(Type.QEB);
        BbkTypes.add(Type.QE1);
        BbkTypes.add(Type.QE3);
        BbkTypes.add(Type.QE5);
        BbkTypes.add(Type.QE7);
        DtiTypes.addAll(BbkTypes);
        DtiTypesWithVirtual = new HashSet<Type>();
        DtiTypesWithVirtual.addAll(DtiTypes);
        DtiTypesWithVirtual.add(Type.LOGICAL_PAYMENT_FILE);
    }

    public /* synthetic */ String[] _ebean_getPropertyNames() {
        return _ebean_props;
    }

    public /* synthetic */ String _ebean_getPropertyName(int pos) {
        return _ebean_props[pos];
    }

    public /* synthetic */ EntityBeanIntercept _ebean_getIntercept() {
        return this._ebean_intercept;
    }

    public /* synthetic */ EntityBeanIntercept _ebean_intercept() {
        if (this._ebean_intercept == null) {
            this._ebean_intercept = new EntityBeanIntercept((Object)this);
        }
        return this._ebean_intercept;
    }

    protected /* synthetic */ Integer _ebean_get_id() {
        this._ebean_intercept.preGetId();
        return this.id;
    }

    protected /* synthetic */ void _ebean_set_id(Integer newValue) {
        this._ebean_intercept.preSetter(false, 0, (Object)this.id, (Object)newValue);
        this.id = newValue;
    }

    protected /* synthetic */ Integer _ebean_getni_id() {
        return this.id;
    }

    protected /* synthetic */ void _ebean_setni_id(Integer _newValue) {
        this.id = _newValue;
        this._ebean_intercept.setLoadedProperty(0);
    }

    protected /* synthetic */ Account _ebean_get_account() {
        this._ebean_intercept.preGetter(1);
        return this.account;
    }

    protected /* synthetic */ void _ebean_set_account(Account newValue) {
        this._ebean_intercept.preSetter(true, 1, (Object)this._ebean_get_account(), (Object)newValue);
        this.account = newValue;
    }

    protected /* synthetic */ Account _ebean_getni_account() {
        return this.account;
    }

    protected /* synthetic */ void _ebean_setni_account(Account _newValue) {
        this.account = _newValue;
        this._ebean_intercept.setLoadedProperty(1);
    }

    protected /* synthetic */ Timestamp _ebean_get_creationDate() {
        this._ebean_intercept.preGetter(2);
        return this.creationDate;
    }

    protected /* synthetic */ void _ebean_set_creationDate(Timestamp newValue) {
        this._ebean_intercept.preSetter(true, 2, (Object)this._ebean_get_creationDate(), (Object)newValue);
        this.creationDate = newValue;
    }

    protected /* synthetic */ Timestamp _ebean_getni_creationDate() {
        return this.creationDate;
    }

    protected /* synthetic */ void _ebean_setni_creationDate(Timestamp _newValue) {
        this.creationDate = _newValue;
        this._ebean_intercept.setLoadedProperty(2);
    }

    protected /* synthetic */ String _ebean_get_reference1() {
        this._ebean_intercept.preGetter(3);
        return this.reference1;
    }

    protected /* synthetic */ void _ebean_set_reference1(String newValue) {
        this._ebean_intercept.preSetter(true, 3, (Object)this._ebean_get_reference1(), (Object)newValue);
        this.reference1 = newValue;
    }

    protected /* synthetic */ String _ebean_getni_reference1() {
        return this.reference1;
    }

    protected /* synthetic */ void _ebean_setni_reference1(String _newValue) {
        this.reference1 = _newValue;
        this._ebean_intercept.setLoadedProperty(3);
    }

    protected /* synthetic */ String _ebean_get_reference2() {
        this._ebean_intercept.preGetter(4);
        return this.reference2;
    }

    protected /* synthetic */ void _ebean_set_reference2(String newValue) {
        this._ebean_intercept.preSetter(true, 4, (Object)this._ebean_get_reference2(), (Object)newValue);
        this.reference2 = newValue;
    }

    protected /* synthetic */ String _ebean_getni_reference2() {
        return this.reference2;
    }

    protected /* synthetic */ void _ebean_setni_reference2(String _newValue) {
        this.reference2 = _newValue;
        this._ebean_intercept.setLoadedProperty(4);
    }

    protected /* synthetic */ Date _ebean_get_openingDate() {
        this._ebean_intercept.preGetter(5);
        return this.openingDate;
    }

    protected /* synthetic */ void _ebean_set_openingDate(Date newValue) {
        this._ebean_intercept.preSetter(true, 5, (Object)this._ebean_get_openingDate(), (Object)newValue);
        this.openingDate = newValue;
    }

    protected /* synthetic */ Date _ebean_getni_openingDate() {
        return this.openingDate;
    }

    protected /* synthetic */ void _ebean_setni_openingDate(Date _newValue) {
        this.openingDate = _newValue;
        this._ebean_intercept.setLoadedProperty(5);
    }

    protected /* synthetic */ BigDecimal _ebean_get_openingBalance() {
        this._ebean_intercept.preGetter(6);
        return this.openingBalance;
    }

    protected /* synthetic */ void _ebean_set_openingBalance(BigDecimal newValue) {
        this._ebean_intercept.preSetter(true, 6, (Object)this._ebean_get_openingBalance(), (Object)newValue);
        this.openingBalance = newValue;
    }

    protected /* synthetic */ BigDecimal _ebean_getni_openingBalance() {
        return this.openingBalance;
    }

    protected /* synthetic */ void _ebean_setni_openingBalance(BigDecimal _newValue) {
        this.openingBalance = _newValue;
        this._ebean_intercept.setLoadedProperty(6);
    }

    protected /* synthetic */ boolean _ebean_get_openingFinal() {
        this._ebean_intercept.preGetter(7);
        return this.openingFinal;
    }

    protected /* synthetic */ void _ebean_set_openingFinal(boolean newValue) {
        this._ebean_intercept.preSetter(true, 7, this._ebean_get_openingFinal(), newValue);
        this.openingFinal = newValue;
    }

    protected /* synthetic */ boolean _ebean_getni_openingFinal() {
        return this.openingFinal;
    }

    protected /* synthetic */ void _ebean_setni_openingFinal(boolean _newValue) {
        this.openingFinal = _newValue;
        this._ebean_intercept.setLoadedProperty(7);
    }

    protected /* synthetic */ Date _ebean_get_closingDate() {
        this._ebean_intercept.preGetter(8);
        return this.closingDate;
    }

    protected /* synthetic */ void _ebean_set_closingDate(Date newValue) {
        this._ebean_intercept.preSetter(true, 8, (Object)this._ebean_get_closingDate(), (Object)newValue);
        this.closingDate = newValue;
    }

    protected /* synthetic */ Date _ebean_getni_closingDate() {
        return this.closingDate;
    }

    protected /* synthetic */ void _ebean_setni_closingDate(Date _newValue) {
        this.closingDate = _newValue;
        this._ebean_intercept.setLoadedProperty(8);
    }

    protected /* synthetic */ BigDecimal _ebean_get_closingBalance() {
        this._ebean_intercept.preGetter(9);
        return this.closingBalance;
    }

    protected /* synthetic */ void _ebean_set_closingBalance(BigDecimal newValue) {
        this._ebean_intercept.preSetter(true, 9, (Object)this._ebean_get_closingBalance(), (Object)newValue);
        this.closingBalance = newValue;
    }

    protected /* synthetic */ BigDecimal _ebean_getni_closingBalance() {
        return this.closingBalance;
    }

    protected /* synthetic */ void _ebean_setni_closingBalance(BigDecimal _newValue) {
        this.closingBalance = _newValue;
        this._ebean_intercept.setLoadedProperty(9);
    }

    protected /* synthetic */ boolean _ebean_get_closingFinal() {
        this._ebean_intercept.preGetter(10);
        return this.closingFinal;
    }

    protected /* synthetic */ void _ebean_set_closingFinal(boolean newValue) {
        this._ebean_intercept.preSetter(true, 10, this._ebean_get_closingFinal(), newValue);
        this.closingFinal = newValue;
    }

    protected /* synthetic */ boolean _ebean_getni_closingFinal() {
        return this.closingFinal;
    }

    protected /* synthetic */ void _ebean_setni_closingFinal(boolean _newValue) {
        this.closingFinal = _newValue;
        this._ebean_intercept.setLoadedProperty(10);
    }

    protected /* synthetic */ String _ebean_get_currencyCode() {
        this._ebean_intercept.preGetter(11);
        return this.currencyCode;
    }

    protected /* synthetic */ void _ebean_set_currencyCode(String newValue) {
        this._ebean_intercept.preSetter(true, 11, (Object)this._ebean_get_currencyCode(), (Object)newValue);
        this.currencyCode = newValue;
    }

    protected /* synthetic */ String _ebean_getni_currencyCode() {
        return this.currencyCode;
    }

    protected /* synthetic */ void _ebean_setni_currencyCode(String _newValue) {
        this.currencyCode = _newValue;
        this._ebean_intercept.setLoadedProperty(11);
    }

    protected /* synthetic */ Integer _ebean_get_statementNumber() {
        this._ebean_intercept.preGetter(12);
        return this.statementNumber;
    }

    protected /* synthetic */ void _ebean_set_statementNumber(Integer newValue) {
        this._ebean_intercept.preSetter(true, 12, (Object)this._ebean_get_statementNumber(), (Object)newValue);
        this.statementNumber = newValue;
    }

    protected /* synthetic */ Integer _ebean_getni_statementNumber() {
        return this.statementNumber;
    }

    protected /* synthetic */ void _ebean_setni_statementNumber(Integer _newValue) {
        this.statementNumber = _newValue;
        this._ebean_intercept.setLoadedProperty(12);
    }

    protected /* synthetic */ Integer _ebean_get_pageNumber() {
        this._ebean_intercept.preGetter(13);
        return this.pageNumber;
    }

    protected /* synthetic */ void _ebean_set_pageNumber(Integer newValue) {
        this._ebean_intercept.preSetter(true, 13, (Object)this._ebean_get_pageNumber(), (Object)newValue);
        this.pageNumber = newValue;
    }

    protected /* synthetic */ Integer _ebean_getni_pageNumber() {
        return this.pageNumber;
    }

    protected /* synthetic */ void _ebean_setni_pageNumber(Integer _newValue) {
        this.pageNumber = _newValue;
        this._ebean_intercept.setLoadedProperty(13);
    }

    protected /* synthetic */ Integer _ebean_get_legalNumber() {
        this._ebean_intercept.preGetter(14);
        return this.legalNumber;
    }

    protected /* synthetic */ void _ebean_set_legalNumber(Integer newValue) {
        this._ebean_intercept.preSetter(true, 14, (Object)this._ebean_get_legalNumber(), (Object)newValue);
        this.legalNumber = newValue;
    }

    protected /* synthetic */ Integer _ebean_getni_legalNumber() {
        return this.legalNumber;
    }

    protected /* synthetic */ void _ebean_setni_legalNumber(Integer _newValue) {
        this.legalNumber = _newValue;
        this._ebean_intercept.setLoadedProperty(14);
    }

    protected /* synthetic */ String _ebean_get_uniqueId() {
        this._ebean_intercept.preGetter(15);
        return this.uniqueId;
    }

    protected /* synthetic */ void _ebean_set_uniqueId(String newValue) {
        this._ebean_intercept.preSetter(true, 15, (Object)this._ebean_get_uniqueId(), (Object)newValue);
        this.uniqueId = newValue;
    }

    protected /* synthetic */ String _ebean_getni_uniqueId() {
        return this.uniqueId;
    }

    protected /* synthetic */ void _ebean_setni_uniqueId(String _newValue) {
        this.uniqueId = _newValue;
        this._ebean_intercept.setLoadedProperty(15);
    }

    protected /* synthetic */ Integer _ebean_get_countCredit() {
        this._ebean_intercept.preGetter(16);
        return this.countCredit;
    }

    protected /* synthetic */ void _ebean_set_countCredit(Integer newValue) {
        this._ebean_intercept.preSetter(true, 16, (Object)this._ebean_get_countCredit(), (Object)newValue);
        this.countCredit = newValue;
    }

    protected /* synthetic */ Integer _ebean_getni_countCredit() {
        return this.countCredit;
    }

    protected /* synthetic */ void _ebean_setni_countCredit(Integer _newValue) {
        this.countCredit = _newValue;
        this._ebean_intercept.setLoadedProperty(16);
    }

    protected /* synthetic */ Integer _ebean_get_countDebit() {
        this._ebean_intercept.preGetter(17);
        return this.countDebit;
    }

    protected /* synthetic */ void _ebean_set_countDebit(Integer newValue) {
        this._ebean_intercept.preSetter(true, 17, (Object)this._ebean_get_countDebit(), (Object)newValue);
        this.countDebit = newValue;
    }

    protected /* synthetic */ Integer _ebean_getni_countDebit() {
        return this.countDebit;
    }

    protected /* synthetic */ void _ebean_setni_countDebit(Integer _newValue) {
        this.countDebit = _newValue;
        this._ebean_intercept.setLoadedProperty(17);
    }

    protected /* synthetic */ BigDecimal _ebean_get_sumCredit() {
        this._ebean_intercept.preGetter(18);
        return this.sumCredit;
    }

    protected /* synthetic */ void _ebean_set_sumCredit(BigDecimal newValue) {
        this._ebean_intercept.preSetter(true, 18, (Object)this._ebean_get_sumCredit(), (Object)newValue);
        this.sumCredit = newValue;
    }

    protected /* synthetic */ BigDecimal _ebean_getni_sumCredit() {
        return this.sumCredit;
    }

    protected /* synthetic */ void _ebean_setni_sumCredit(BigDecimal _newValue) {
        this.sumCredit = _newValue;
        this._ebean_intercept.setLoadedProperty(18);
    }

    protected /* synthetic */ BigDecimal _ebean_get_sumDebit() {
        this._ebean_intercept.preGetter(19);
        return this.sumDebit;
    }

    protected /* synthetic */ void _ebean_set_sumDebit(BigDecimal newValue) {
        this._ebean_intercept.preSetter(true, 19, (Object)this._ebean_get_sumDebit(), (Object)newValue);
        this.sumDebit = newValue;
    }

    protected /* synthetic */ BigDecimal _ebean_getni_sumDebit() {
        return this.sumDebit;
    }

    protected /* synthetic */ void _ebean_setni_sumDebit(BigDecimal _newValue) {
        this.sumDebit = _newValue;
        this._ebean_intercept.setLoadedProperty(19);
    }

    protected /* synthetic */ BigDecimal _ebean_get_maxCredit() {
        this._ebean_intercept.preGetter(20);
        return this.maxCredit;
    }

    protected /* synthetic */ void _ebean_set_maxCredit(BigDecimal newValue) {
        this._ebean_intercept.preSetter(true, 20, (Object)this._ebean_get_maxCredit(), (Object)newValue);
        this.maxCredit = newValue;
    }

    protected /* synthetic */ BigDecimal _ebean_getni_maxCredit() {
        return this.maxCredit;
    }

    protected /* synthetic */ void _ebean_setni_maxCredit(BigDecimal _newValue) {
        this.maxCredit = _newValue;
        this._ebean_intercept.setLoadedProperty(20);
    }

    protected /* synthetic */ BigDecimal _ebean_get_minCredit() {
        this._ebean_intercept.preGetter(21);
        return this.minCredit;
    }

    protected /* synthetic */ void _ebean_set_minCredit(BigDecimal newValue) {
        this._ebean_intercept.preSetter(true, 21, (Object)this._ebean_get_minCredit(), (Object)newValue);
        this.minCredit = newValue;
    }

    protected /* synthetic */ BigDecimal _ebean_getni_minCredit() {
        return this.minCredit;
    }

    protected /* synthetic */ void _ebean_setni_minCredit(BigDecimal _newValue) {
        this.minCredit = _newValue;
        this._ebean_intercept.setLoadedProperty(21);
    }

    protected /* synthetic */ BigDecimal _ebean_get_maxDebit() {
        this._ebean_intercept.preGetter(22);
        return this.maxDebit;
    }

    protected /* synthetic */ void _ebean_set_maxDebit(BigDecimal newValue) {
        this._ebean_intercept.preSetter(true, 22, (Object)this._ebean_get_maxDebit(), (Object)newValue);
        this.maxDebit = newValue;
    }

    protected /* synthetic */ BigDecimal _ebean_getni_maxDebit() {
        return this.maxDebit;
    }

    protected /* synthetic */ void _ebean_setni_maxDebit(BigDecimal _newValue) {
        this.maxDebit = _newValue;
        this._ebean_intercept.setLoadedProperty(22);
    }

    protected /* synthetic */ BigDecimal _ebean_get_minDebit() {
        this._ebean_intercept.preGetter(23);
        return this.minDebit;
    }

    protected /* synthetic */ void _ebean_set_minDebit(BigDecimal newValue) {
        this._ebean_intercept.preSetter(true, 23, (Object)this._ebean_get_minDebit(), (Object)newValue);
        this.minDebit = newValue;
    }

    protected /* synthetic */ BigDecimal _ebean_getni_minDebit() {
        return this.minDebit;
    }

    protected /* synthetic */ void _ebean_setni_minDebit(BigDecimal _newValue) {
        this.minDebit = _newValue;
        this._ebean_intercept.setLoadedProperty(23);
    }

    protected /* synthetic */ Type _ebean_get_type() {
        this._ebean_intercept.preGetter(24);
        return this.type;
    }

    protected /* synthetic */ void _ebean_set_type(Type newValue) {
        this._ebean_intercept.preSetter(true, 24, (Object)this._ebean_get_type(), (Object)newValue);
        this.type = newValue;
    }

    protected /* synthetic */ Type _ebean_getni_type() {
        return this.type;
    }

    protected /* synthetic */ void _ebean_setni_type(Type _newValue) {
        this.type = _newValue;
        this._ebean_intercept.setLoadedProperty(24);
    }

    protected /* synthetic */ String _ebean_get_originalFilename() {
        this._ebean_intercept.preGetter(25);
        return this.originalFilename;
    }

    protected /* synthetic */ void _ebean_set_originalFilename(String newValue) {
        this._ebean_intercept.preSetter(true, 25, (Object)this._ebean_get_originalFilename(), (Object)newValue);
        this.originalFilename = newValue;
    }

    protected /* synthetic */ String _ebean_getni_originalFilename() {
        return this.originalFilename;
    }

    protected /* synthetic */ void _ebean_setni_originalFilename(String _newValue) {
        this.originalFilename = _newValue;
        this._ebean_intercept.setLoadedProperty(25);
    }

    protected /* synthetic */ String _ebean_get_additionalInformation() {
        this._ebean_intercept.preGetter(26);
        return this.additionalInformation;
    }

    protected /* synthetic */ void _ebean_set_additionalInformation(String newValue) {
        this._ebean_intercept.preSetter(true, 26, (Object)this._ebean_get_additionalInformation(), (Object)newValue);
        this.additionalInformation = newValue;
    }

    protected /* synthetic */ String _ebean_getni_additionalInformation() {
        return this.additionalInformation;
    }

    protected /* synthetic */ void _ebean_setni_additionalInformation(String _newValue) {
        this.additionalInformation = _newValue;
        this._ebean_intercept.setLoadedProperty(26);
    }

    protected /* synthetic */ WorkspaceFile _ebean_get_file() {
        this._ebean_intercept.preGetter(27);
        return this.file;
    }

    protected /* synthetic */ void _ebean_set_file(WorkspaceFile newValue) {
        this._ebean_intercept.preSetter(true, 27, (Object)this._ebean_get_file(), (Object)newValue);
        this.file = newValue;
    }

    protected /* synthetic */ WorkspaceFile _ebean_getni_file() {
        return this.file;
    }

    protected /* synthetic */ void _ebean_setni_file(WorkspaceFile _newValue) {
        this.file = _newValue;
        this._ebean_intercept.setLoadedProperty(27);
    }

    public /* synthetic */ Object _ebean_getField(int index) {
        switch (index) {
            case 0: {
                return this.id;
            }
            case 1: {
                return this.account;
            }
            case 2: {
                return this.creationDate;
            }
            case 3: {
                return this.reference1;
            }
            case 4: {
                return this.reference2;
            }
            case 5: {
                return this.openingDate;
            }
            case 6: {
                return this.openingBalance;
            }
            case 7: {
                return this.openingFinal;
            }
            case 8: {
                return this.closingDate;
            }
            case 9: {
                return this.closingBalance;
            }
            case 10: {
                return this.closingFinal;
            }
            case 11: {
                return this.currencyCode;
            }
            case 12: {
                return this.statementNumber;
            }
            case 13: {
                return this.pageNumber;
            }
            case 14: {
                return this.legalNumber;
            }
            case 15: {
                return this.uniqueId;
            }
            case 16: {
                return this.countCredit;
            }
            case 17: {
                return this.countDebit;
            }
            case 18: {
                return this.sumCredit;
            }
            case 19: {
                return this.sumDebit;
            }
            case 20: {
                return this.maxCredit;
            }
            case 21: {
                return this.minCredit;
            }
            case 22: {
                return this.maxDebit;
            }
            case 23: {
                return this.minDebit;
            }
            case 24: {
                return this.type;
            }
            case 25: {
                return this.originalFilename;
            }
            case 26: {
                return this.additionalInformation;
            }
            case 27: {
                return this.file;
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    public /* synthetic */ Object _ebean_getFieldIntercept(int index) {
        switch (index) {
            case 0: {
                return this._ebean_get_id();
            }
            case 1: {
                return this._ebean_get_account();
            }
            case 2: {
                return this._ebean_get_creationDate();
            }
            case 3: {
                return this._ebean_get_reference1();
            }
            case 4: {
                return this._ebean_get_reference2();
            }
            case 5: {
                return this._ebean_get_openingDate();
            }
            case 6: {
                return this._ebean_get_openingBalance();
            }
            case 7: {
                return this._ebean_get_openingFinal();
            }
            case 8: {
                return this._ebean_get_closingDate();
            }
            case 9: {
                return this._ebean_get_closingBalance();
            }
            case 10: {
                return this._ebean_get_closingFinal();
            }
            case 11: {
                return this._ebean_get_currencyCode();
            }
            case 12: {
                return this._ebean_get_statementNumber();
            }
            case 13: {
                return this._ebean_get_pageNumber();
            }
            case 14: {
                return this._ebean_get_legalNumber();
            }
            case 15: {
                return this._ebean_get_uniqueId();
            }
            case 16: {
                return this._ebean_get_countCredit();
            }
            case 17: {
                return this._ebean_get_countDebit();
            }
            case 18: {
                return this._ebean_get_sumCredit();
            }
            case 19: {
                return this._ebean_get_sumDebit();
            }
            case 20: {
                return this._ebean_get_maxCredit();
            }
            case 21: {
                return this._ebean_get_minCredit();
            }
            case 22: {
                return this._ebean_get_maxDebit();
            }
            case 23: {
                return this._ebean_get_minDebit();
            }
            case 24: {
                return this._ebean_get_type();
            }
            case 25: {
                return this._ebean_get_originalFilename();
            }
            case 26: {
                return this._ebean_get_additionalInformation();
            }
            case 27: {
                return this._ebean_get_file();
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    public /* synthetic */ void _ebean_setField(int index, Object o) {
        switch (index) {
            case 0: {
                this._ebean_setni_id((Integer)o);
                return;
            }
            case 1: {
                this._ebean_setni_account((Account)o);
                return;
            }
            case 2: {
                this._ebean_setni_creationDate((Timestamp)o);
                return;
            }
            case 3: {
                this._ebean_setni_reference1((String)o);
                return;
            }
            case 4: {
                this._ebean_setni_reference2((String)o);
                return;
            }
            case 5: {
                this._ebean_setni_openingDate((Date)o);
                return;
            }
            case 6: {
                this._ebean_setni_openingBalance((BigDecimal)o);
                return;
            }
            case 7: {
                this._ebean_setni_openingFinal((Boolean)o);
                return;
            }
            case 8: {
                this._ebean_setni_closingDate((Date)o);
                return;
            }
            case 9: {
                this._ebean_setni_closingBalance((BigDecimal)o);
                return;
            }
            case 10: {
                this._ebean_setni_closingFinal((Boolean)o);
                return;
            }
            case 11: {
                this._ebean_setni_currencyCode((String)o);
                return;
            }
            case 12: {
                this._ebean_setni_statementNumber((Integer)o);
                return;
            }
            case 13: {
                this._ebean_setni_pageNumber((Integer)o);
                return;
            }
            case 14: {
                this._ebean_setni_legalNumber((Integer)o);
                return;
            }
            case 15: {
                this._ebean_setni_uniqueId((String)o);
                return;
            }
            case 16: {
                this._ebean_setni_countCredit((Integer)o);
                return;
            }
            case 17: {
                this._ebean_setni_countDebit((Integer)o);
                return;
            }
            case 18: {
                this._ebean_setni_sumCredit((BigDecimal)o);
                return;
            }
            case 19: {
                this._ebean_setni_sumDebit((BigDecimal)o);
                return;
            }
            case 20: {
                this._ebean_setni_maxCredit((BigDecimal)o);
                return;
            }
            case 21: {
                this._ebean_setni_minCredit((BigDecimal)o);
                return;
            }
            case 22: {
                this._ebean_setni_maxDebit((BigDecimal)o);
                return;
            }
            case 23: {
                this._ebean_setni_minDebit((BigDecimal)o);
                return;
            }
            case 24: {
                this._ebean_setni_type((Type)((Object)o));
                return;
            }
            case 25: {
                this._ebean_setni_originalFilename((String)o);
                return;
            }
            case 26: {
                this._ebean_setni_additionalInformation((String)o);
                return;
            }
            case 27: {
                this._ebean_setni_file((WorkspaceFile)o);
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    public /* synthetic */ void _ebean_setFieldIntercept(int index, Object o) {
        switch (index) {
            case 0: {
                this._ebean_set_id((Integer)o);
                return;
            }
            case 1: {
                this._ebean_set_account((Account)o);
                return;
            }
            case 2: {
                this._ebean_set_creationDate((Timestamp)o);
                return;
            }
            case 3: {
                this._ebean_set_reference1((String)o);
                return;
            }
            case 4: {
                this._ebean_set_reference2((String)o);
                return;
            }
            case 5: {
                this._ebean_set_openingDate((Date)o);
                return;
            }
            case 6: {
                this._ebean_set_openingBalance((BigDecimal)o);
                return;
            }
            case 7: {
                this._ebean_set_openingFinal((Boolean)o);
                return;
            }
            case 8: {
                this._ebean_set_closingDate((Date)o);
                return;
            }
            case 9: {
                this._ebean_set_closingBalance((BigDecimal)o);
                return;
            }
            case 10: {
                this._ebean_set_closingFinal((Boolean)o);
                return;
            }
            case 11: {
                this._ebean_set_currencyCode((String)o);
                return;
            }
            case 12: {
                this._ebean_set_statementNumber((Integer)o);
                return;
            }
            case 13: {
                this._ebean_set_pageNumber((Integer)o);
                return;
            }
            case 14: {
                this._ebean_set_legalNumber((Integer)o);
                return;
            }
            case 15: {
                this._ebean_set_uniqueId((String)o);
                return;
            }
            case 16: {
                this._ebean_set_countCredit((Integer)o);
                return;
            }
            case 17: {
                this._ebean_set_countDebit((Integer)o);
                return;
            }
            case 18: {
                this._ebean_set_sumCredit((BigDecimal)o);
                return;
            }
            case 19: {
                this._ebean_set_sumDebit((BigDecimal)o);
                return;
            }
            case 20: {
                this._ebean_set_maxCredit((BigDecimal)o);
                return;
            }
            case 21: {
                this._ebean_set_minCredit((BigDecimal)o);
                return;
            }
            case 22: {
                this._ebean_set_maxDebit((BigDecimal)o);
                return;
            }
            case 23: {
                this._ebean_set_minDebit((BigDecimal)o);
                return;
            }
            case 24: {
                this._ebean_set_type((Type)((Object)o));
                return;
            }
            case 25: {
                this._ebean_set_originalFilename((String)o);
                return;
            }
            case 26: {
                this._ebean_set_additionalInformation((String)o);
                return;
            }
            case 27: {
                this._ebean_set_file((WorkspaceFile)o);
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private /* synthetic */ Object _ebean_getIdentity() {
        CmStatement cmStatement = this;
        synchronized (cmStatement) {
            if (this._ebean_identity != null) {
                return this._ebean_identity;
            }
            Object tmpId = this._ebean_getField(0);
            this._ebean_identity = tmpId != null ? tmpId : new Object();
            return this._ebean_identity;
        }
    }

    public /* synthetic */ boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        return this._ebean_getIdentity().equals(((CmStatement)obj)._ebean_getIdentity());
    }

    public /* synthetic */ int hashCode() {
        return this._ebean_getIdentity().hashCode();
    }

    public /* synthetic */ void _ebean_setEmbeddedLoaded() {
    }

    public /* synthetic */ boolean _ebean_isEmbeddedNewOrDirty() {
        return false;
    }

    public /* synthetic */ Object _ebean_newInstance() {
        return new CmStatement();
    }

    public static enum Type {
        MT940,
        MT942,
        DTI,
        CAMT053,
        CAMT052,
        CAMT054,
        CFONB120,
        YG1,
        YG2,
        YWA,
        YGB,
        YLB,
        YGD,
        YGS,
        YCG,
        YCL,
        YCD,
        YCS,
        QG3,
        QG4,
        QWA,
        QE2,
        QE4,
        QE6,
        QEB,
        QE1,
        QE3,
        QE5,
        QE7,
        CAMT054Advice,
        LOGICAL_PAYMENT_FILE;

    }

    public static enum CleanupDateType {
        STATEMENT_DATE,
        VALUE_DATE,
        BOOKING_DATE;

    }
}

