/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.database.vo;

import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.Account;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.banking.database.vo.WorkspaceFile;
import io.ebean.Expr;
import io.ebean.Expression;
import io.ebean.ExpressionList;
import io.ebean.Query;
import io.ebean.bean.EntityBean;
import io.ebean.bean.EntityBeanIntercept;
import java.sql.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.ManyToOne;

@Entity
public class CmPdfStatement
implements EntityBean {
    @Id
    private Integer id;
    @Column(nullable=false)
    private Type type;
    @ManyToOne
    private BankSettings bank;
    @ManyToOne
    private Account account;
    private Date statementDate;
    private Integer statementNumber;
    private String zipFileName;
    @ManyToOne
    private WorkspaceFile localFile;
    public static /* synthetic */ String[] _ebean_props;
    protected /* synthetic */ EntityBeanIntercept _ebean_intercept;
    protected transient /* synthetic */ Object _ebean_identity;

    public CmPdfStatement() {
        this._ebean_intercept = new EntityBeanIntercept((Object)this);
        this._ebean_set_type(Type.ACCOUNT_STATEMENT);
    }

    public static CmPdfStatement findByIdAndUser(int id, User user) {
        return (CmPdfStatement)DB.find(CmPdfStatement.class).where().eq("id", (Object)id).eq("bank.users.user", (Object)user).findOne();
    }

    public static Query<CmPdfStatement> queryByUser(User user, boolean checkAccountPemission) {
        ExpressionList expr = DB.find(CmPdfStatement.class).where();
        expr.eq("type", (Object)Type.ACCOUNT_STATEMENT);
        expr.eq("bank.users.user", (Object)user);
        if (checkAccountPemission) {
            expr.eq("account.permissions.bankUser.user", (Object)user);
        }
        return expr.query();
    }

    public static Query<CmPdfStatement> queryAllTypesByUser(User user, boolean checkAccountPemission) {
        ExpressionList expr = DB.find(CmPdfStatement.class).where();
        expr.eq("bank.users.user", (Object)user);
        if (checkAccountPemission) {
            expr.add(Expr.or((Expression)Expr.isNull((String)"account"), (Expression)Expr.eq((String)"account.permissions.bankUser.user", (Object)user)));
        }
        return expr.query();
    }

    public static Query<CmPdfStatement> queryBkiByUser(User user, boolean checkAccountPemission) {
        ExpressionList expr = DB.find(CmPdfStatement.class).where();
        expr.ne("type", (Object)Type.ACCOUNT_STATEMENT);
        expr.eq("bank.users.user", (Object)user);
        if (checkAccountPemission) {
            expr.disjunction().add(Expr.isNull((String)"account")).add(Expr.eq((String)"account.permissions.bankUser.user", (Object)user));
        }
        return expr.query();
    }

    public static CmPdfStatement findByBankAndName(BankSettings bank, String fileName) {
        return (CmPdfStatement)DB.find(CmPdfStatement.class).where().eq("bank", (Object)bank).eq("zipFileName", (Object)fileName).findOne();
    }

    public static Query<CmPdfStatement> findOldStatements(Date older) {
        return DB.find(CmPdfStatement.class).where().lt("statementDate", (Object)older).query();
    }

    public static int findCountByAccount(Account a) {
        return DB.find(CmPdfStatement.class).where().eq("account", (Object)a).findCount();
    }

    public Integer getId() {
        return this._ebean_get_id();
    }

    public void setId(Integer id) {
        this._ebean_set_id(id);
    }

    public Type getType() {
        return this._ebean_get_type();
    }

    public void setType(Type type) {
        this._ebean_set_type(type);
    }

    public BankSettings getBank() {
        return this._ebean_get_bank();
    }

    public void setBank(BankSettings bank) {
        this._ebean_set_bank(bank);
    }

    public Account getAccount() {
        return this._ebean_get_account();
    }

    public void setAccount(Account account) {
        this._ebean_set_account(account);
    }

    public Date getStatementDate() {
        return this._ebean_get_statementDate();
    }

    public void setStatementDate(Date statementDate) {
        this._ebean_set_statementDate(statementDate);
    }

    public Integer getStatementNumber() {
        return this._ebean_get_statementNumber();
    }

    public void setStatementNumber(Integer statementNumber) {
        this._ebean_set_statementNumber(statementNumber);
    }

    public String getZipFileName() {
        return this._ebean_get_zipFileName();
    }

    public void setZipFileName(String zipFileName) {
        this._ebean_set_zipFileName(zipFileName);
    }

    public WorkspaceFile getLocalFile() {
        return this._ebean_get_localFile();
    }

    public void setLocalFile(WorkspaceFile localFile) {
        this._ebean_set_localFile(localFile);
    }

    static {
        _ebean_props = new String[]{"id", "type", "bank", "account", "statementDate", "statementNumber", "zipFileName", "localFile"};
    }

    public /* synthetic */ String[] _ebean_getPropertyNames() {
        return _ebean_props;
    }

    public /* synthetic */ String _ebean_getPropertyName(int pos) {
        return _ebean_props[pos];
    }

    public /* synthetic */ EntityBeanIntercept _ebean_getIntercept() {
        return this._ebean_intercept;
    }

    public /* synthetic */ EntityBeanIntercept _ebean_intercept() {
        if (this._ebean_intercept == null) {
            this._ebean_intercept = new EntityBeanIntercept((Object)this);
        }
        return this._ebean_intercept;
    }

    protected /* synthetic */ Integer _ebean_get_id() {
        this._ebean_intercept.preGetId();
        return this.id;
    }

    protected /* synthetic */ void _ebean_set_id(Integer newValue) {
        this._ebean_intercept.preSetter(false, 0, (Object)this.id, (Object)newValue);
        this.id = newValue;
    }

    protected /* synthetic */ Integer _ebean_getni_id() {
        return this.id;
    }

    protected /* synthetic */ void _ebean_setni_id(Integer _newValue) {
        this.id = _newValue;
        this._ebean_intercept.setLoadedProperty(0);
    }

    protected /* synthetic */ Type _ebean_get_type() {
        this._ebean_intercept.preGetter(1);
        return this.type;
    }

    protected /* synthetic */ void _ebean_set_type(Type newValue) {
        this._ebean_intercept.preSetter(true, 1, (Object)this._ebean_get_type(), (Object)newValue);
        this.type = newValue;
    }

    protected /* synthetic */ Type _ebean_getni_type() {
        return this.type;
    }

    protected /* synthetic */ void _ebean_setni_type(Type _newValue) {
        this.type = _newValue;
        this._ebean_intercept.setLoadedProperty(1);
    }

    protected /* synthetic */ BankSettings _ebean_get_bank() {
        this._ebean_intercept.preGetter(2);
        return this.bank;
    }

    protected /* synthetic */ void _ebean_set_bank(BankSettings newValue) {
        this._ebean_intercept.preSetter(true, 2, (Object)this._ebean_get_bank(), (Object)newValue);
        this.bank = newValue;
    }

    protected /* synthetic */ BankSettings _ebean_getni_bank() {
        return this.bank;
    }

    protected /* synthetic */ void _ebean_setni_bank(BankSettings _newValue) {
        this.bank = _newValue;
        this._ebean_intercept.setLoadedProperty(2);
    }

    protected /* synthetic */ Account _ebean_get_account() {
        this._ebean_intercept.preGetter(3);
        return this.account;
    }

    protected /* synthetic */ void _ebean_set_account(Account newValue) {
        this._ebean_intercept.preSetter(true, 3, (Object)this._ebean_get_account(), (Object)newValue);
        this.account = newValue;
    }

    protected /* synthetic */ Account _ebean_getni_account() {
        return this.account;
    }

    protected /* synthetic */ void _ebean_setni_account(Account _newValue) {
        this.account = _newValue;
        this._ebean_intercept.setLoadedProperty(3);
    }

    protected /* synthetic */ Date _ebean_get_statementDate() {
        this._ebean_intercept.preGetter(4);
        return this.statementDate;
    }

    protected /* synthetic */ void _ebean_set_statementDate(Date newValue) {
        this._ebean_intercept.preSetter(true, 4, (Object)this._ebean_get_statementDate(), (Object)newValue);
        this.statementDate = newValue;
    }

    protected /* synthetic */ Date _ebean_getni_statementDate() {
        return this.statementDate;
    }

    protected /* synthetic */ void _ebean_setni_statementDate(Date _newValue) {
        this.statementDate = _newValue;
        this._ebean_intercept.setLoadedProperty(4);
    }

    protected /* synthetic */ Integer _ebean_get_statementNumber() {
        this._ebean_intercept.preGetter(5);
        return this.statementNumber;
    }

    protected /* synthetic */ void _ebean_set_statementNumber(Integer newValue) {
        this._ebean_intercept.preSetter(true, 5, (Object)this._ebean_get_statementNumber(), (Object)newValue);
        this.statementNumber = newValue;
    }

    protected /* synthetic */ Integer _ebean_getni_statementNumber() {
        return this.statementNumber;
    }

    protected /* synthetic */ void _ebean_setni_statementNumber(Integer _newValue) {
        this.statementNumber = _newValue;
        this._ebean_intercept.setLoadedProperty(5);
    }

    protected /* synthetic */ String _ebean_get_zipFileName() {
        this._ebean_intercept.preGetter(6);
        return this.zipFileName;
    }

    protected /* synthetic */ void _ebean_set_zipFileName(String newValue) {
        this._ebean_intercept.preSetter(true, 6, (Object)this._ebean_get_zipFileName(), (Object)newValue);
        this.zipFileName = newValue;
    }

    protected /* synthetic */ String _ebean_getni_zipFileName() {
        return this.zipFileName;
    }

    protected /* synthetic */ void _ebean_setni_zipFileName(String _newValue) {
        this.zipFileName = _newValue;
        this._ebean_intercept.setLoadedProperty(6);
    }

    protected /* synthetic */ WorkspaceFile _ebean_get_localFile() {
        this._ebean_intercept.preGetter(7);
        return this.localFile;
    }

    protected /* synthetic */ void _ebean_set_localFile(WorkspaceFile newValue) {
        this._ebean_intercept.preSetter(true, 7, (Object)this._ebean_get_localFile(), (Object)newValue);
        this.localFile = newValue;
    }

    protected /* synthetic */ WorkspaceFile _ebean_getni_localFile() {
        return this.localFile;
    }

    protected /* synthetic */ void _ebean_setni_localFile(WorkspaceFile _newValue) {
        this.localFile = _newValue;
        this._ebean_intercept.setLoadedProperty(7);
    }

    public /* synthetic */ Object _ebean_getField(int index) {
        switch (index) {
            case 0: {
                return this.id;
            }
            case 1: {
                return this.type;
            }
            case 2: {
                return this.bank;
            }
            case 3: {
                return this.account;
            }
            case 4: {
                return this.statementDate;
            }
            case 5: {
                return this.statementNumber;
            }
            case 6: {
                return this.zipFileName;
            }
            case 7: {
                return this.localFile;
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    public /* synthetic */ Object _ebean_getFieldIntercept(int index) {
        switch (index) {
            case 0: {
                return this._ebean_get_id();
            }
            case 1: {
                return this._ebean_get_type();
            }
            case 2: {
                return this._ebean_get_bank();
            }
            case 3: {
                return this._ebean_get_account();
            }
            case 4: {
                return this._ebean_get_statementDate();
            }
            case 5: {
                return this._ebean_get_statementNumber();
            }
            case 6: {
                return this._ebean_get_zipFileName();
            }
            case 7: {
                return this._ebean_get_localFile();
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    public /* synthetic */ void _ebean_setField(int index, Object o) {
        switch (index) {
            case 0: {
                this._ebean_setni_id((Integer)o);
                return;
            }
            case 1: {
                this._ebean_setni_type((Type)((Object)o));
                return;
            }
            case 2: {
                this._ebean_setni_bank((BankSettings)o);
                return;
            }
            case 3: {
                this._ebean_setni_account((Account)o);
                return;
            }
            case 4: {
                this._ebean_setni_statementDate((Date)o);
                return;
            }
            case 5: {
                this._ebean_setni_statementNumber((Integer)o);
                return;
            }
            case 6: {
                this._ebean_setni_zipFileName((String)o);
                return;
            }
            case 7: {
                this._ebean_setni_localFile((WorkspaceFile)o);
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    public /* synthetic */ void _ebean_setFieldIntercept(int index, Object o) {
        switch (index) {
            case 0: {
                this._ebean_set_id((Integer)o);
                return;
            }
            case 1: {
                this._ebean_set_type((Type)((Object)o));
                return;
            }
            case 2: {
                this._ebean_set_bank((BankSettings)o);
                return;
            }
            case 3: {
                this._ebean_set_account((Account)o);
                return;
            }
            case 4: {
                this._ebean_set_statementDate((Date)o);
                return;
            }
            case 5: {
                this._ebean_set_statementNumber((Integer)o);
                return;
            }
            case 6: {
                this._ebean_set_zipFileName((String)o);
                return;
            }
            case 7: {
                this._ebean_set_localFile((WorkspaceFile)o);
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private /* synthetic */ Object _ebean_getIdentity() {
        CmPdfStatement cmPdfStatement = this;
        synchronized (cmPdfStatement) {
            if (this._ebean_identity != null) {
                return this._ebean_identity;
            }
            Object tmpId = this._ebean_getField(0);
            this._ebean_identity = tmpId != null ? tmpId : new Object();
            return this._ebean_identity;
        }
    }

    public /* synthetic */ boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        return this._ebean_getIdentity().equals(((CmPdfStatement)obj)._ebean_getIdentity());
    }

    public /* synthetic */ int hashCode() {
        return this._ebean_getIdentity().hashCode();
    }

    public /* synthetic */ void _ebean_setEmbeddedLoaded() {
    }

    public /* synthetic */ boolean _ebean_isEmbeddedNewOrDirty() {
        return false;
    }

    public /* synthetic */ Object _ebean_newInstance() {
        return new CmPdfStatement();
    }

    public static enum Type {
        ACCOUNT_STATEMENT,
        RNG,
        KAB,
        SAB,
        ZAV,
        DPA,
        WPA,
        TRA,
        ZAB,
        INF,
        DEV,
        DEP,
        LOA,
        ZAC,
        ZAD,
        SAC,
        MIS;

    }
}

