/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.database.vo;

import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.Account;
import de.businesslogics.banking.database.vo.CmStatement;
import de.businesslogics.banking.database.vo.WorkspaceFile;
import de.businesslogics.util.Currency;
import io.ebean.bean.EntityBean;
import io.ebean.bean.EntityBeanIntercept;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.ManyToOne;

@Entity
public class CmPage
implements EntityBean {
    @Id
    private Integer id;
    @ManyToOne
    private CmStatement statement;
    private Timestamp creationDate;
    private String reference1;
    private String reference2;
    private Date closingDate;
    @Column(precision=38, scale=3)
    private BigDecimal closingBalance;
    private boolean closingFinal;
    private Date openingDate;
    @Column(precision=38, scale=3)
    private BigDecimal openingBalance;
    private boolean openingFinal;
    @Column(length=3)
    private String currencyCode;
    private Integer pageNumber;
    private Integer countCredit;
    private Integer countDebit;
    @Column(precision=38, scale=3)
    private BigDecimal sumCredit;
    @Column(precision=38, scale=3)
    private BigDecimal sumDebit;
    @Column(precision=38, scale=3)
    private BigDecimal maxCredit;
    @Column(precision=38, scale=3)
    private BigDecimal minCredit;
    @Column(precision=38, scale=3)
    private BigDecimal maxDebit;
    @Column(precision=38, scale=3)
    private BigDecimal minDebit;
    private boolean old;
    @ManyToOne
    private WorkspaceFile file;
    public static /* synthetic */ String[] _ebean_props;
    protected /* synthetic */ EntityBeanIntercept _ebean_intercept;
    protected transient /* synthetic */ Object _ebean_identity;

    public CmPage() {
        this._ebean_intercept = new EntityBeanIntercept((Object)this);
        this._ebean_set_closingFinal(true);
        this._ebean_set_openingFinal(true);
        this._ebean_set_old(false);
    }

    public static void markOtherAsOld(CmStatement advice) {
        int countPages;
        List<CmPage> pages = CmPage.findByStatement(advice, true);
        int n = countPages = pages != null ? pages.size() : 0;
        if (countPages > 1) {
            for (int i = 1; i < countPages; ++i) {
                CmPage pageFromDb = pages.get(i);
                if (pageFromDb.isOld()) continue;
                pageFromDb.setOld(true);
                DB.update(pageFromDb);
            }
        }
    }

    public static CmPage findByPageNumber(CmStatement stmt, int pageNumber) {
        if (pageNumber == 0) {
            return (CmPage)DB.find(CmPage.class).where().eq("statement", (Object)stmt).eq("pageNumber", null).findOne();
        }
        return (CmPage)DB.find(CmPage.class).where().eq("statement", (Object)stmt).eq("pageNumber", (Object)pageNumber).findOne();
    }

    public static CmPage findByPageNumberAndCreationDate(CmStatement stmt, int pageNumber, Timestamp creationTimestamp) {
        if (pageNumber == 0) {
            return (CmPage)DB.find(CmPage.class).where().eq("statement", (Object)stmt).eq("pageNumber", null).eq("creationDate", (Object)creationTimestamp).setMaxRows(1).findOne();
        }
        return (CmPage)DB.find(CmPage.class).where().eq("statement", (Object)stmt).eq("pageNumber", (Object)pageNumber).eq("creationDate", (Object)creationTimestamp).setMaxRows(1).findOne();
    }

    public static List<CmPage> findByStatement(CmStatement stmt, boolean descending) {
        if (descending) {
            return DB.find(CmPage.class).where().eq("statement", (Object)stmt).order("pageNumber DESC, creationDate DESC").findList();
        }
        return DB.find(CmPage.class).where().eq("statement", (Object)stmt).order("pageNumber ASC, creationDate ASC").findList();
    }

    public static CmPage findNewestPage(CmStatement stmt) {
        return (CmPage)DB.find(CmPage.class).where().eq("statement", (Object)stmt).orderBy("pageNumber DESC, creationDate DESC").setMaxRows(1).findOne();
    }

    public static int findCountForStatement(CmStatement s) {
        return DB.find(CmPage.class).where().eq("statement", (Object)s).findCount();
    }

    public static CmPage findByHash(Account a, String md5Hash) {
        return (CmPage)DB.find(CmPage.class).where().eq("statement.account", (Object)a).eq("file.md5Hash", (Object)md5Hash).findOne();
    }

    public Integer getId() {
        return this._ebean_get_id();
    }

    public void setId(Integer id) {
        this._ebean_set_id(id);
    }

    public CmStatement getStatement() {
        return this._ebean_get_statement();
    }

    public void setStatement(CmStatement statement) {
        this._ebean_set_statement(statement);
    }

    public Integer getPageNumber() {
        return this._ebean_get_pageNumber();
    }

    public void setPageNumber(Integer pageNumber) {
        this._ebean_set_pageNumber(pageNumber);
    }

    public int getPageNumberAsInt() {
        return this._ebean_get_pageNumber() == null ? 0 : this._ebean_get_pageNumber();
    }

    public void setPageNumberAsInt(int pageNumber) {
        this._ebean_set_pageNumber(pageNumber == 0 ? null : Integer.valueOf(pageNumber));
    }

    public Date getClosingDate() {
        return this._ebean_get_closingDate();
    }

    public void setClosingDate(Date closingDate) {
        this._ebean_set_closingDate(closingDate);
    }

    public BigDecimal getClosingBalance() {
        return this._ebean_get_closingBalance();
    }

    public void setClosingBalance(BigDecimal closingBalance) {
        this._ebean_set_closingBalance(closingBalance);
    }

    public String getCurrencyCode() {
        return this._ebean_get_currencyCode();
    }

    public void setCurrencyCode(String currencyCode) {
        this._ebean_set_currencyCode(currencyCode);
    }

    public Currency getCurrency() {
        try {
            if (this.getCurrencyCode() == null) {
                return null;
            }
            return Currency.getInstance(this.getCurrencyCode());
        }
        catch (IllegalArgumentException unknown) {
            return null;
        }
    }

    public void setCurrency(Currency currency) {
        this.setCurrencyCode(currency.getCurrencyCode());
    }

    public Date getOpeningDate() {
        return this._ebean_get_openingDate();
    }

    public void setOpeningDate(Date openingDate) {
        this._ebean_set_openingDate(openingDate);
    }

    public BigDecimal getOpeningBalance() {
        return this._ebean_get_openingBalance();
    }

    public void setOpeningBalance(BigDecimal openingBalance) {
        this._ebean_set_openingBalance(openingBalance);
    }

    public int getCountCredit() {
        if (this._ebean_get_countCredit() == null) {
            return 0;
        }
        return this._ebean_get_countCredit();
    }

    public void setCountCredit(int countCredit) {
        this._ebean_set_countCredit(countCredit);
    }

    public int getCountDebit() {
        if (this._ebean_get_countDebit() == null) {
            return 0;
        }
        return this._ebean_get_countDebit();
    }

    public void setCountDebit(int countDebit) {
        this._ebean_set_countDebit(countDebit);
    }

    public BigDecimal getSumCredit() {
        return this._ebean_get_sumCredit();
    }

    public void setSumCredit(BigDecimal sumCredit) {
        this._ebean_set_sumCredit(sumCredit);
    }

    public BigDecimal getSumDebit() {
        return this._ebean_get_sumDebit();
    }

    public void setSumDebit(BigDecimal sumDebit) {
        this._ebean_set_sumDebit(sumDebit);
    }

    public BigDecimal getMaxCredit() {
        return this._ebean_get_maxCredit();
    }

    public void setMaxCredit(BigDecimal maxCredit) {
        this._ebean_set_maxCredit(maxCredit);
    }

    public BigDecimal getMinCredit() {
        return this._ebean_get_minCredit();
    }

    public void setMinCredit(BigDecimal minCredit) {
        this._ebean_set_minCredit(minCredit);
    }

    public BigDecimal getMaxDebit() {
        return this._ebean_get_maxDebit();
    }

    public void setMaxDebit(BigDecimal maxDebit) {
        this._ebean_set_maxDebit(maxDebit);
    }

    public BigDecimal getMinDebit() {
        return this._ebean_get_minDebit();
    }

    public void setMinDebit(BigDecimal minDebit) {
        this._ebean_set_minDebit(minDebit);
    }

    public String getReference1() {
        return this._ebean_get_reference1();
    }

    public void setReference1(String reference1) {
        this._ebean_set_reference1(reference1);
    }

    public String getReference2() {
        return this._ebean_get_reference2();
    }

    public void setReference2(String reference2) {
        this._ebean_set_reference2(reference2);
    }

    public Timestamp getCreationDate() {
        return this._ebean_get_creationDate();
    }

    public void setCreationDate(Timestamp creationDate) {
        this._ebean_set_creationDate(creationDate);
    }

    public boolean isClosingFinal() {
        return this._ebean_get_closingFinal();
    }

    public void setClosingFinal(boolean closingFinal) {
        this._ebean_set_closingFinal(closingFinal);
    }

    public boolean isOpeningFinal() {
        return this._ebean_get_openingFinal();
    }

    public void setOpeningFinal(boolean openingFinal) {
        this._ebean_set_openingFinal(openingFinal);
    }

    public boolean isOld() {
        return this._ebean_get_old();
    }

    public void setOld(boolean old) {
        this._ebean_set_old(old);
    }

    public WorkspaceFile getFile() {
        return this._ebean_get_file();
    }

    public void setFile(WorkspaceFile file) {
        this._ebean_set_file(file);
    }

    public String getMd5Hash() {
        if (this.getFile() != null) {
            return this.getFile().getMd5Hash();
        }
        return null;
    }

    public BigDecimal getTotalSum() {
        BigDecimal totalSum;
        BigDecimal bigDecimal = totalSum = this._ebean_get_sumCredit() != null ? this._ebean_get_sumCredit() : BigDecimal.ZERO;
        if (this._ebean_get_sumDebit() != null) {
            totalSum = totalSum.add(this._ebean_get_sumDebit());
        }
        return totalSum;
    }

    public long getSize() {
        if (this.getFile() == null) {
            return 0L;
        }
        return this.getFile().getSize();
    }

    static {
        _ebean_props = new String[]{"id", "statement", "creationDate", "reference1", "reference2", "closingDate", "closingBalance", "closingFinal", "openingDate", "openingBalance", "openingFinal", "currencyCode", "pageNumber", "countCredit", "countDebit", "sumCredit", "sumDebit", "maxCredit", "minCredit", "maxDebit", "minDebit", "old", "file"};
    }

    public /* synthetic */ String[] _ebean_getPropertyNames() {
        return _ebean_props;
    }

    public /* synthetic */ String _ebean_getPropertyName(int pos) {
        return _ebean_props[pos];
    }

    public /* synthetic */ EntityBeanIntercept _ebean_getIntercept() {
        return this._ebean_intercept;
    }

    public /* synthetic */ EntityBeanIntercept _ebean_intercept() {
        if (this._ebean_intercept == null) {
            this._ebean_intercept = new EntityBeanIntercept((Object)this);
        }
        return this._ebean_intercept;
    }

    protected /* synthetic */ Integer _ebean_get_id() {
        this._ebean_intercept.preGetId();
        return this.id;
    }

    protected /* synthetic */ void _ebean_set_id(Integer newValue) {
        this._ebean_intercept.preSetter(false, 0, (Object)this.id, (Object)newValue);
        this.id = newValue;
    }

    protected /* synthetic */ Integer _ebean_getni_id() {
        return this.id;
    }

    protected /* synthetic */ void _ebean_setni_id(Integer _newValue) {
        this.id = _newValue;
        this._ebean_intercept.setLoadedProperty(0);
    }

    protected /* synthetic */ CmStatement _ebean_get_statement() {
        this._ebean_intercept.preGetter(1);
        return this.statement;
    }

    protected /* synthetic */ void _ebean_set_statement(CmStatement newValue) {
        this._ebean_intercept.preSetter(true, 1, (Object)this._ebean_get_statement(), (Object)newValue);
        this.statement = newValue;
    }

    protected /* synthetic */ CmStatement _ebean_getni_statement() {
        return this.statement;
    }

    protected /* synthetic */ void _ebean_setni_statement(CmStatement _newValue) {
        this.statement = _newValue;
        this._ebean_intercept.setLoadedProperty(1);
    }

    protected /* synthetic */ Timestamp _ebean_get_creationDate() {
        this._ebean_intercept.preGetter(2);
        return this.creationDate;
    }

    protected /* synthetic */ void _ebean_set_creationDate(Timestamp newValue) {
        this._ebean_intercept.preSetter(true, 2, (Object)this._ebean_get_creationDate(), (Object)newValue);
        this.creationDate = newValue;
    }

    protected /* synthetic */ Timestamp _ebean_getni_creationDate() {
        return this.creationDate;
    }

    protected /* synthetic */ void _ebean_setni_creationDate(Timestamp _newValue) {
        this.creationDate = _newValue;
        this._ebean_intercept.setLoadedProperty(2);
    }

    protected /* synthetic */ String _ebean_get_reference1() {
        this._ebean_intercept.preGetter(3);
        return this.reference1;
    }

    protected /* synthetic */ void _ebean_set_reference1(String newValue) {
        this._ebean_intercept.preSetter(true, 3, (Object)this._ebean_get_reference1(), (Object)newValue);
        this.reference1 = newValue;
    }

    protected /* synthetic */ String _ebean_getni_reference1() {
        return this.reference1;
    }

    protected /* synthetic */ void _ebean_setni_reference1(String _newValue) {
        this.reference1 = _newValue;
        this._ebean_intercept.setLoadedProperty(3);
    }

    protected /* synthetic */ String _ebean_get_reference2() {
        this._ebean_intercept.preGetter(4);
        return this.reference2;
    }

    protected /* synthetic */ void _ebean_set_reference2(String newValue) {
        this._ebean_intercept.preSetter(true, 4, (Object)this._ebean_get_reference2(), (Object)newValue);
        this.reference2 = newValue;
    }

    protected /* synthetic */ String _ebean_getni_reference2() {
        return this.reference2;
    }

    protected /* synthetic */ void _ebean_setni_reference2(String _newValue) {
        this.reference2 = _newValue;
        this._ebean_intercept.setLoadedProperty(4);
    }

    protected /* synthetic */ Date _ebean_get_closingDate() {
        this._ebean_intercept.preGetter(5);
        return this.closingDate;
    }

    protected /* synthetic */ void _ebean_set_closingDate(Date newValue) {
        this._ebean_intercept.preSetter(true, 5, (Object)this._ebean_get_closingDate(), (Object)newValue);
        this.closingDate = newValue;
    }

    protected /* synthetic */ Date _ebean_getni_closingDate() {
        return this.closingDate;
    }

    protected /* synthetic */ void _ebean_setni_closingDate(Date _newValue) {
        this.closingDate = _newValue;
        this._ebean_intercept.setLoadedProperty(5);
    }

    protected /* synthetic */ BigDecimal _ebean_get_closingBalance() {
        this._ebean_intercept.preGetter(6);
        return this.closingBalance;
    }

    protected /* synthetic */ void _ebean_set_closingBalance(BigDecimal newValue) {
        this._ebean_intercept.preSetter(true, 6, (Object)this._ebean_get_closingBalance(), (Object)newValue);
        this.closingBalance = newValue;
    }

    protected /* synthetic */ BigDecimal _ebean_getni_closingBalance() {
        return this.closingBalance;
    }

    protected /* synthetic */ void _ebean_setni_closingBalance(BigDecimal _newValue) {
        this.closingBalance = _newValue;
        this._ebean_intercept.setLoadedProperty(6);
    }

    protected /* synthetic */ boolean _ebean_get_closingFinal() {
        this._ebean_intercept.preGetter(7);
        return this.closingFinal;
    }

    protected /* synthetic */ void _ebean_set_closingFinal(boolean newValue) {
        this._ebean_intercept.preSetter(true, 7, this._ebean_get_closingFinal(), newValue);
        this.closingFinal = newValue;
    }

    protected /* synthetic */ boolean _ebean_getni_closingFinal() {
        return this.closingFinal;
    }

    protected /* synthetic */ void _ebean_setni_closingFinal(boolean _newValue) {
        this.closingFinal = _newValue;
        this._ebean_intercept.setLoadedProperty(7);
    }

    protected /* synthetic */ Date _ebean_get_openingDate() {
        this._ebean_intercept.preGetter(8);
        return this.openingDate;
    }

    protected /* synthetic */ void _ebean_set_openingDate(Date newValue) {
        this._ebean_intercept.preSetter(true, 8, (Object)this._ebean_get_openingDate(), (Object)newValue);
        this.openingDate = newValue;
    }

    protected /* synthetic */ Date _ebean_getni_openingDate() {
        return this.openingDate;
    }

    protected /* synthetic */ void _ebean_setni_openingDate(Date _newValue) {
        this.openingDate = _newValue;
        this._ebean_intercept.setLoadedProperty(8);
    }

    protected /* synthetic */ BigDecimal _ebean_get_openingBalance() {
        this._ebean_intercept.preGetter(9);
        return this.openingBalance;
    }

    protected /* synthetic */ void _ebean_set_openingBalance(BigDecimal newValue) {
        this._ebean_intercept.preSetter(true, 9, (Object)this._ebean_get_openingBalance(), (Object)newValue);
        this.openingBalance = newValue;
    }

    protected /* synthetic */ BigDecimal _ebean_getni_openingBalance() {
        return this.openingBalance;
    }

    protected /* synthetic */ void _ebean_setni_openingBalance(BigDecimal _newValue) {
        this.openingBalance = _newValue;
        this._ebean_intercept.setLoadedProperty(9);
    }

    protected /* synthetic */ boolean _ebean_get_openingFinal() {
        this._ebean_intercept.preGetter(10);
        return this.openingFinal;
    }

    protected /* synthetic */ void _ebean_set_openingFinal(boolean newValue) {
        this._ebean_intercept.preSetter(true, 10, this._ebean_get_openingFinal(), newValue);
        this.openingFinal = newValue;
    }

    protected /* synthetic */ boolean _ebean_getni_openingFinal() {
        return this.openingFinal;
    }

    protected /* synthetic */ void _ebean_setni_openingFinal(boolean _newValue) {
        this.openingFinal = _newValue;
        this._ebean_intercept.setLoadedProperty(10);
    }

    protected /* synthetic */ String _ebean_get_currencyCode() {
        this._ebean_intercept.preGetter(11);
        return this.currencyCode;
    }

    protected /* synthetic */ void _ebean_set_currencyCode(String newValue) {
        this._ebean_intercept.preSetter(true, 11, (Object)this._ebean_get_currencyCode(), (Object)newValue);
        this.currencyCode = newValue;
    }

    protected /* synthetic */ String _ebean_getni_currencyCode() {
        return this.currencyCode;
    }

    protected /* synthetic */ void _ebean_setni_currencyCode(String _newValue) {
        this.currencyCode = _newValue;
        this._ebean_intercept.setLoadedProperty(11);
    }

    protected /* synthetic */ Integer _ebean_get_pageNumber() {
        this._ebean_intercept.preGetter(12);
        return this.pageNumber;
    }

    protected /* synthetic */ void _ebean_set_pageNumber(Integer newValue) {
        this._ebean_intercept.preSetter(true, 12, (Object)this._ebean_get_pageNumber(), (Object)newValue);
        this.pageNumber = newValue;
    }

    protected /* synthetic */ Integer _ebean_getni_pageNumber() {
        return this.pageNumber;
    }

    protected /* synthetic */ void _ebean_setni_pageNumber(Integer _newValue) {
        this.pageNumber = _newValue;
        this._ebean_intercept.setLoadedProperty(12);
    }

    protected /* synthetic */ Integer _ebean_get_countCredit() {
        this._ebean_intercept.preGetter(13);
        return this.countCredit;
    }

    protected /* synthetic */ void _ebean_set_countCredit(Integer newValue) {
        this._ebean_intercept.preSetter(true, 13, (Object)this._ebean_get_countCredit(), (Object)newValue);
        this.countCredit = newValue;
    }

    protected /* synthetic */ Integer _ebean_getni_countCredit() {
        return this.countCredit;
    }

    protected /* synthetic */ void _ebean_setni_countCredit(Integer _newValue) {
        this.countCredit = _newValue;
        this._ebean_intercept.setLoadedProperty(13);
    }

    protected /* synthetic */ Integer _ebean_get_countDebit() {
        this._ebean_intercept.preGetter(14);
        return this.countDebit;
    }

    protected /* synthetic */ void _ebean_set_countDebit(Integer newValue) {
        this._ebean_intercept.preSetter(true, 14, (Object)this._ebean_get_countDebit(), (Object)newValue);
        this.countDebit = newValue;
    }

    protected /* synthetic */ Integer _ebean_getni_countDebit() {
        return this.countDebit;
    }

    protected /* synthetic */ void _ebean_setni_countDebit(Integer _newValue) {
        this.countDebit = _newValue;
        this._ebean_intercept.setLoadedProperty(14);
    }

    protected /* synthetic */ BigDecimal _ebean_get_sumCredit() {
        this._ebean_intercept.preGetter(15);
        return this.sumCredit;
    }

    protected /* synthetic */ void _ebean_set_sumCredit(BigDecimal newValue) {
        this._ebean_intercept.preSetter(true, 15, (Object)this._ebean_get_sumCredit(), (Object)newValue);
        this.sumCredit = newValue;
    }

    protected /* synthetic */ BigDecimal _ebean_getni_sumCredit() {
        return this.sumCredit;
    }

    protected /* synthetic */ void _ebean_setni_sumCredit(BigDecimal _newValue) {
        this.sumCredit = _newValue;
        this._ebean_intercept.setLoadedProperty(15);
    }

    protected /* synthetic */ BigDecimal _ebean_get_sumDebit() {
        this._ebean_intercept.preGetter(16);
        return this.sumDebit;
    }

    protected /* synthetic */ void _ebean_set_sumDebit(BigDecimal newValue) {
        this._ebean_intercept.preSetter(true, 16, (Object)this._ebean_get_sumDebit(), (Object)newValue);
        this.sumDebit = newValue;
    }

    protected /* synthetic */ BigDecimal _ebean_getni_sumDebit() {
        return this.sumDebit;
    }

    protected /* synthetic */ void _ebean_setni_sumDebit(BigDecimal _newValue) {
        this.sumDebit = _newValue;
        this._ebean_intercept.setLoadedProperty(16);
    }

    protected /* synthetic */ BigDecimal _ebean_get_maxCredit() {
        this._ebean_intercept.preGetter(17);
        return this.maxCredit;
    }

    protected /* synthetic */ void _ebean_set_maxCredit(BigDecimal newValue) {
        this._ebean_intercept.preSetter(true, 17, (Object)this._ebean_get_maxCredit(), (Object)newValue);
        this.maxCredit = newValue;
    }

    protected /* synthetic */ BigDecimal _ebean_getni_maxCredit() {
        return this.maxCredit;
    }

    protected /* synthetic */ void _ebean_setni_maxCredit(BigDecimal _newValue) {
        this.maxCredit = _newValue;
        this._ebean_intercept.setLoadedProperty(17);
    }

    protected /* synthetic */ BigDecimal _ebean_get_minCredit() {
        this._ebean_intercept.preGetter(18);
        return this.minCredit;
    }

    protected /* synthetic */ void _ebean_set_minCredit(BigDecimal newValue) {
        this._ebean_intercept.preSetter(true, 18, (Object)this._ebean_get_minCredit(), (Object)newValue);
        this.minCredit = newValue;
    }

    protected /* synthetic */ BigDecimal _ebean_getni_minCredit() {
        return this.minCredit;
    }

    protected /* synthetic */ void _ebean_setni_minCredit(BigDecimal _newValue) {
        this.minCredit = _newValue;
        this._ebean_intercept.setLoadedProperty(18);
    }

    protected /* synthetic */ BigDecimal _ebean_get_maxDebit() {
        this._ebean_intercept.preGetter(19);
        return this.maxDebit;
    }

    protected /* synthetic */ void _ebean_set_maxDebit(BigDecimal newValue) {
        this._ebean_intercept.preSetter(true, 19, (Object)this._ebean_get_maxDebit(), (Object)newValue);
        this.maxDebit = newValue;
    }

    protected /* synthetic */ BigDecimal _ebean_getni_maxDebit() {
        return this.maxDebit;
    }

    protected /* synthetic */ void _ebean_setni_maxDebit(BigDecimal _newValue) {
        this.maxDebit = _newValue;
        this._ebean_intercept.setLoadedProperty(19);
    }

    protected /* synthetic */ BigDecimal _ebean_get_minDebit() {
        this._ebean_intercept.preGetter(20);
        return this.minDebit;
    }

    protected /* synthetic */ void _ebean_set_minDebit(BigDecimal newValue) {
        this._ebean_intercept.preSetter(true, 20, (Object)this._ebean_get_minDebit(), (Object)newValue);
        this.minDebit = newValue;
    }

    protected /* synthetic */ BigDecimal _ebean_getni_minDebit() {
        return this.minDebit;
    }

    protected /* synthetic */ void _ebean_setni_minDebit(BigDecimal _newValue) {
        this.minDebit = _newValue;
        this._ebean_intercept.setLoadedProperty(20);
    }

    protected /* synthetic */ boolean _ebean_get_old() {
        this._ebean_intercept.preGetter(21);
        return this.old;
    }

    protected /* synthetic */ void _ebean_set_old(boolean newValue) {
        this._ebean_intercept.preSetter(true, 21, this._ebean_get_old(), newValue);
        this.old = newValue;
    }

    protected /* synthetic */ boolean _ebean_getni_old() {
        return this.old;
    }

    protected /* synthetic */ void _ebean_setni_old(boolean _newValue) {
        this.old = _newValue;
        this._ebean_intercept.setLoadedProperty(21);
    }

    protected /* synthetic */ WorkspaceFile _ebean_get_file() {
        this._ebean_intercept.preGetter(22);
        return this.file;
    }

    protected /* synthetic */ void _ebean_set_file(WorkspaceFile newValue) {
        this._ebean_intercept.preSetter(true, 22, (Object)this._ebean_get_file(), (Object)newValue);
        this.file = newValue;
    }

    protected /* synthetic */ WorkspaceFile _ebean_getni_file() {
        return this.file;
    }

    protected /* synthetic */ void _ebean_setni_file(WorkspaceFile _newValue) {
        this.file = _newValue;
        this._ebean_intercept.setLoadedProperty(22);
    }

    public /* synthetic */ Object _ebean_getField(int index) {
        switch (index) {
            case 0: {
                return this.id;
            }
            case 1: {
                return this.statement;
            }
            case 2: {
                return this.creationDate;
            }
            case 3: {
                return this.reference1;
            }
            case 4: {
                return this.reference2;
            }
            case 5: {
                return this.closingDate;
            }
            case 6: {
                return this.closingBalance;
            }
            case 7: {
                return this.closingFinal;
            }
            case 8: {
                return this.openingDate;
            }
            case 9: {
                return this.openingBalance;
            }
            case 10: {
                return this.openingFinal;
            }
            case 11: {
                return this.currencyCode;
            }
            case 12: {
                return this.pageNumber;
            }
            case 13: {
                return this.countCredit;
            }
            case 14: {
                return this.countDebit;
            }
            case 15: {
                return this.sumCredit;
            }
            case 16: {
                return this.sumDebit;
            }
            case 17: {
                return this.maxCredit;
            }
            case 18: {
                return this.minCredit;
            }
            case 19: {
                return this.maxDebit;
            }
            case 20: {
                return this.minDebit;
            }
            case 21: {
                return this.old;
            }
            case 22: {
                return this.file;
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    public /* synthetic */ Object _ebean_getFieldIntercept(int index) {
        switch (index) {
            case 0: {
                return this._ebean_get_id();
            }
            case 1: {
                return this._ebean_get_statement();
            }
            case 2: {
                return this._ebean_get_creationDate();
            }
            case 3: {
                return this._ebean_get_reference1();
            }
            case 4: {
                return this._ebean_get_reference2();
            }
            case 5: {
                return this._ebean_get_closingDate();
            }
            case 6: {
                return this._ebean_get_closingBalance();
            }
            case 7: {
                return this._ebean_get_closingFinal();
            }
            case 8: {
                return this._ebean_get_openingDate();
            }
            case 9: {
                return this._ebean_get_openingBalance();
            }
            case 10: {
                return this._ebean_get_openingFinal();
            }
            case 11: {
                return this._ebean_get_currencyCode();
            }
            case 12: {
                return this._ebean_get_pageNumber();
            }
            case 13: {
                return this._ebean_get_countCredit();
            }
            case 14: {
                return this._ebean_get_countDebit();
            }
            case 15: {
                return this._ebean_get_sumCredit();
            }
            case 16: {
                return this._ebean_get_sumDebit();
            }
            case 17: {
                return this._ebean_get_maxCredit();
            }
            case 18: {
                return this._ebean_get_minCredit();
            }
            case 19: {
                return this._ebean_get_maxDebit();
            }
            case 20: {
                return this._ebean_get_minDebit();
            }
            case 21: {
                return this._ebean_get_old();
            }
            case 22: {
                return this._ebean_get_file();
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    public /* synthetic */ void _ebean_setField(int index, Object o) {
        switch (index) {
            case 0: {
                this._ebean_setni_id((Integer)o);
                return;
            }
            case 1: {
                this._ebean_setni_statement((CmStatement)o);
                return;
            }
            case 2: {
                this._ebean_setni_creationDate((Timestamp)o);
                return;
            }
            case 3: {
                this._ebean_setni_reference1((String)o);
                return;
            }
            case 4: {
                this._ebean_setni_reference2((String)o);
                return;
            }
            case 5: {
                this._ebean_setni_closingDate((Date)o);
                return;
            }
            case 6: {
                this._ebean_setni_closingBalance((BigDecimal)o);
                return;
            }
            case 7: {
                this._ebean_setni_closingFinal((Boolean)o);
                return;
            }
            case 8: {
                this._ebean_setni_openingDate((Date)o);
                return;
            }
            case 9: {
                this._ebean_setni_openingBalance((BigDecimal)o);
                return;
            }
            case 10: {
                this._ebean_setni_openingFinal((Boolean)o);
                return;
            }
            case 11: {
                this._ebean_setni_currencyCode((String)o);
                return;
            }
            case 12: {
                this._ebean_setni_pageNumber((Integer)o);
                return;
            }
            case 13: {
                this._ebean_setni_countCredit((Integer)o);
                return;
            }
            case 14: {
                this._ebean_setni_countDebit((Integer)o);
                return;
            }
            case 15: {
                this._ebean_setni_sumCredit((BigDecimal)o);
                return;
            }
            case 16: {
                this._ebean_setni_sumDebit((BigDecimal)o);
                return;
            }
            case 17: {
                this._ebean_setni_maxCredit((BigDecimal)o);
                return;
            }
            case 18: {
                this._ebean_setni_minCredit((BigDecimal)o);
                return;
            }
            case 19: {
                this._ebean_setni_maxDebit((BigDecimal)o);
                return;
            }
            case 20: {
                this._ebean_setni_minDebit((BigDecimal)o);
                return;
            }
            case 21: {
                this._ebean_setni_old((Boolean)o);
                return;
            }
            case 22: {
                this._ebean_setni_file((WorkspaceFile)o);
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    public /* synthetic */ void _ebean_setFieldIntercept(int index, Object o) {
        switch (index) {
            case 0: {
                this._ebean_set_id((Integer)o);
                return;
            }
            case 1: {
                this._ebean_set_statement((CmStatement)o);
                return;
            }
            case 2: {
                this._ebean_set_creationDate((Timestamp)o);
                return;
            }
            case 3: {
                this._ebean_set_reference1((String)o);
                return;
            }
            case 4: {
                this._ebean_set_reference2((String)o);
                return;
            }
            case 5: {
                this._ebean_set_closingDate((Date)o);
                return;
            }
            case 6: {
                this._ebean_set_closingBalance((BigDecimal)o);
                return;
            }
            case 7: {
                this._ebean_set_closingFinal((Boolean)o);
                return;
            }
            case 8: {
                this._ebean_set_openingDate((Date)o);
                return;
            }
            case 9: {
                this._ebean_set_openingBalance((BigDecimal)o);
                return;
            }
            case 10: {
                this._ebean_set_openingFinal((Boolean)o);
                return;
            }
            case 11: {
                this._ebean_set_currencyCode((String)o);
                return;
            }
            case 12: {
                this._ebean_set_pageNumber((Integer)o);
                return;
            }
            case 13: {
                this._ebean_set_countCredit((Integer)o);
                return;
            }
            case 14: {
                this._ebean_set_countDebit((Integer)o);
                return;
            }
            case 15: {
                this._ebean_set_sumCredit((BigDecimal)o);
                return;
            }
            case 16: {
                this._ebean_set_sumDebit((BigDecimal)o);
                return;
            }
            case 17: {
                this._ebean_set_maxCredit((BigDecimal)o);
                return;
            }
            case 18: {
                this._ebean_set_minCredit((BigDecimal)o);
                return;
            }
            case 19: {
                this._ebean_set_maxDebit((BigDecimal)o);
                return;
            }
            case 20: {
                this._ebean_set_minDebit((BigDecimal)o);
                return;
            }
            case 21: {
                this._ebean_set_old((Boolean)o);
                return;
            }
            case 22: {
                this._ebean_set_file((WorkspaceFile)o);
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private /* synthetic */ Object _ebean_getIdentity() {
        CmPage cmPage = this;
        synchronized (cmPage) {
            if (this._ebean_identity != null) {
                return this._ebean_identity;
            }
            Object tmpId = this._ebean_getField(0);
            this._ebean_identity = tmpId != null ? tmpId : new Object();
            return this._ebean_identity;
        }
    }

    public /* synthetic */ boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        return this._ebean_getIdentity().equals(((CmPage)obj)._ebean_getIdentity());
    }

    public /* synthetic */ int hashCode() {
        return this._ebean_getIdentity().hashCode();
    }

    public /* synthetic */ void _ebean_setEmbeddedLoaded() {
    }

    public /* synthetic */ boolean _ebean_isEmbeddedNewOrDirty() {
        return false;
    }

    public /* synthetic */ Object _ebean_newInstance() {
        return new CmPage();
    }
}

