/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.database.vo;

import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.Account;
import de.businesslogics.banking.database.vo.AutomaticExport;
import de.businesslogics.banking.database.vo.CmValueGroup;
import de.businesslogics.banking.database.vo.Tenant;
import de.businesslogics.banking.database.vo.User;
import io.ebean.Expr;
import io.ebean.Expression;
import io.ebean.Query;
import io.ebean.bean.BeanCollection;
import io.ebean.bean.EntityBean;
import io.ebean.bean.EntityBeanIntercept;
import io.ebean.common.BeanList;
import java.util.List;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.UniqueConstraint;

@Entity
@UniqueConstraint(columnNames={"name", "tenant_id"})
public class CmFolder
implements EntityBean {
    public static final CmFolder NULL_FOLDER;
    @Id
    private Integer id;
    private String name;
    @ManyToMany(mappedBy="folders", fetch=FetchType.LAZY)
    private List<CmValueGroup> valueGroups;
    @OneToMany(mappedBy="folder", fetch=FetchType.LAZY)
    private List<Account> accounts;
    @ManyToOne(optional=false)
    private Tenant tenant;
    public static /* synthetic */ String[] _ebean_props;
    protected /* synthetic */ EntityBeanIntercept _ebean_intercept;
    protected transient /* synthetic */ Object _ebean_identity;

    public CmFolder() {
        this._ebean_intercept = new EntityBeanIntercept((Object)this);
    }

    public static List<CmFolder> findAll(User user) {
        return CmFolder.findAllQuery(user).findList();
    }

    public static CmFolder findById(Integer id, User user) {
        if (id == null) {
            return null;
        }
        return (CmFolder)CmFolder.findAllQuery(user).where().eq("id", (Object)id).findOne();
    }

    private static Query<CmFolder> findAllQuery(User user) {
        Expression filter1 = Expr.in((String)"tenant", user.getVisibleTenants());
        Expression filter2 = Expr.in((String)"accounts.bank.tenant", user.getVisibleTenants());
        return DB.find(CmFolder.class).where().disjunction().add(filter1).add(filter2).order("name").query();
    }

    public static CmFolder findByName(String name, Tenant tenant) {
        return (CmFolder)DB.find(CmFolder.class).where().eq("tenant", (Object)tenant).eq("name", (Object)name).findOne();
    }

    public static boolean hasFolders(User user) {
        return CmFolder.findAllQuery(user).setMaxRows(1).findOne() != null;
    }

    public static void delete(CmFolder f) {
        AutomaticExport.removeFolder(f);
        Account.removeFolder(f);
        DB.delete(f);
    }

    public static NameError nameIsValid(CmFolder f, String name, Tenant tenant) {
        if (name != null && name.trim().length() > 0) {
            CmFolder exist = CmFolder.findByName(name.trim(), tenant);
            if (exist != null && !((Object)exist).equals(f)) {
                return NameError.EXISTS;
            }
            return NameError.NONE;
        }
        return NameError.EMPTY;
    }

    public Integer getId() {
        return this._ebean_get_id();
    }

    public void setId(Integer id) {
        this._ebean_set_id(id);
    }

    public String getName() {
        return this._ebean_get_name();
    }

    public void setName(String name) {
        this._ebean_set_name(name);
    }

    public Tenant getTenant() {
        return this._ebean_get_tenant();
    }

    public void setTenant(Tenant tenant) {
        this._ebean_set_tenant(tenant);
    }

    static {
        _ebean_props = new String[]{"id", "name", "valueGroups", "accounts", "tenant"};
        NULL_FOLDER = new CmFolder();
    }

    public /* synthetic */ String[] _ebean_getPropertyNames() {
        return _ebean_props;
    }

    public /* synthetic */ String _ebean_getPropertyName(int pos) {
        return _ebean_props[pos];
    }

    public /* synthetic */ EntityBeanIntercept _ebean_getIntercept() {
        return this._ebean_intercept;
    }

    public /* synthetic */ EntityBeanIntercept _ebean_intercept() {
        if (this._ebean_intercept == null) {
            this._ebean_intercept = new EntityBeanIntercept((Object)this);
        }
        return this._ebean_intercept;
    }

    protected /* synthetic */ Integer _ebean_get_id() {
        this._ebean_intercept.preGetId();
        return this.id;
    }

    protected /* synthetic */ void _ebean_set_id(Integer newValue) {
        this._ebean_intercept.preSetter(false, 0, (Object)this.id, (Object)newValue);
        this.id = newValue;
    }

    protected /* synthetic */ Integer _ebean_getni_id() {
        return this.id;
    }

    protected /* synthetic */ void _ebean_setni_id(Integer _newValue) {
        this.id = _newValue;
        this._ebean_intercept.setLoadedProperty(0);
    }

    protected /* synthetic */ String _ebean_get_name() {
        this._ebean_intercept.preGetter(1);
        return this.name;
    }

    protected /* synthetic */ void _ebean_set_name(String newValue) {
        this._ebean_intercept.preSetter(true, 1, (Object)this._ebean_get_name(), (Object)newValue);
        this.name = newValue;
    }

    protected /* synthetic */ String _ebean_getni_name() {
        return this.name;
    }

    protected /* synthetic */ void _ebean_setni_name(String _newValue) {
        this.name = _newValue;
        this._ebean_intercept.setLoadedProperty(1);
    }

    protected /* synthetic */ List _ebean_get_valueGroups() {
        this._ebean_intercept.preGetter(2);
        if (this.valueGroups == null) {
            this.valueGroups = new BeanList();
            this._ebean_intercept.initialisedMany(2);
            ((BeanCollection)this.valueGroups).setModifyListening(BeanCollection.ModifyListenMode.ALL);
        }
        return this.valueGroups;
    }

    protected /* synthetic */ void _ebean_set_valueGroups(List newValue) {
        this._ebean_intercept.preSetterMany(false, 2, this.valueGroups, (Object)newValue);
        this.valueGroups = newValue;
    }

    protected /* synthetic */ List _ebean_getni_valueGroups() {
        return this.valueGroups;
    }

    protected /* synthetic */ void _ebean_setni_valueGroups(List _newValue) {
        this.valueGroups = _newValue;
        this._ebean_intercept.setLoadedProperty(2);
    }

    protected /* synthetic */ List _ebean_get_accounts() {
        this._ebean_intercept.preGetter(3);
        if (this.accounts == null) {
            this.accounts = new BeanList();
            this._ebean_intercept.initialisedMany(3);
        }
        return this.accounts;
    }

    protected /* synthetic */ void _ebean_set_accounts(List newValue) {
        this._ebean_intercept.preSetterMany(false, 3, this.accounts, (Object)newValue);
        this.accounts = newValue;
    }

    protected /* synthetic */ List _ebean_getni_accounts() {
        return this.accounts;
    }

    protected /* synthetic */ void _ebean_setni_accounts(List _newValue) {
        this.accounts = _newValue;
        this._ebean_intercept.setLoadedProperty(3);
    }

    protected /* synthetic */ Tenant _ebean_get_tenant() {
        this._ebean_intercept.preGetter(4);
        return this.tenant;
    }

    protected /* synthetic */ void _ebean_set_tenant(Tenant newValue) {
        this._ebean_intercept.preSetter(true, 4, (Object)this._ebean_get_tenant(), (Object)newValue);
        this.tenant = newValue;
    }

    protected /* synthetic */ Tenant _ebean_getni_tenant() {
        return this.tenant;
    }

    protected /* synthetic */ void _ebean_setni_tenant(Tenant _newValue) {
        this.tenant = _newValue;
        this._ebean_intercept.setLoadedProperty(4);
    }

    public /* synthetic */ Object _ebean_getField(int index) {
        switch (index) {
            case 0: {
                return this.id;
            }
            case 1: {
                return this.name;
            }
            case 2: {
                return this.valueGroups;
            }
            case 3: {
                return this.accounts;
            }
            case 4: {
                return this.tenant;
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    public /* synthetic */ Object _ebean_getFieldIntercept(int index) {
        switch (index) {
            case 0: {
                return this._ebean_get_id();
            }
            case 1: {
                return this._ebean_get_name();
            }
            case 2: {
                return this._ebean_get_valueGroups();
            }
            case 3: {
                return this._ebean_get_accounts();
            }
            case 4: {
                return this._ebean_get_tenant();
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    public /* synthetic */ void _ebean_setField(int index, Object o) {
        switch (index) {
            case 0: {
                this._ebean_setni_id((Integer)o);
                return;
            }
            case 1: {
                this._ebean_setni_name((String)o);
                return;
            }
            case 2: {
                this._ebean_setni_valueGroups((List)o);
                return;
            }
            case 3: {
                this._ebean_setni_accounts((List)o);
                return;
            }
            case 4: {
                this._ebean_setni_tenant((Tenant)o);
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    public /* synthetic */ void _ebean_setFieldIntercept(int index, Object o) {
        switch (index) {
            case 0: {
                this._ebean_set_id((Integer)o);
                return;
            }
            case 1: {
                this._ebean_set_name((String)o);
                return;
            }
            case 2: {
                this._ebean_set_valueGroups((List)o);
                return;
            }
            case 3: {
                this._ebean_set_accounts((List)o);
                return;
            }
            case 4: {
                this._ebean_set_tenant((Tenant)o);
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private /* synthetic */ Object _ebean_getIdentity() {
        CmFolder cmFolder = this;
        synchronized (cmFolder) {
            if (this._ebean_identity != null) {
                return this._ebean_identity;
            }
            Object tmpId = this._ebean_getField(0);
            this._ebean_identity = tmpId != null ? tmpId : new Object();
            return this._ebean_identity;
        }
    }

    public /* synthetic */ boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        return this._ebean_getIdentity().equals(((CmFolder)obj)._ebean_getIdentity());
    }

    public /* synthetic */ int hashCode() {
        return this._ebean_getIdentity().hashCode();
    }

    public /* synthetic */ void _ebean_setEmbeddedLoaded() {
    }

    public /* synthetic */ boolean _ebean_isEmbeddedNewOrDirty() {
        return false;
    }

    public /* synthetic */ Object _ebean_newInstance() {
        return new CmFolder();
    }

    public static enum NameError {
        EXISTS,
        EMPTY,
        NONE;

    }
}

