/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.database.vo;

import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.Account;
import de.businesslogics.banking.database.vo.CmPage;
import de.businesslogics.banking.database.vo.CmStatement;
import de.businesslogics.banking.database.vo.User;
import io.ebean.Expr;
import io.ebean.Expression;
import io.ebean.SqlQuery;
import io.ebean.SqlUpdate;
import io.ebean.Update;
import io.ebean.bean.EntityBean;
import io.ebean.bean.EntityBeanIntercept;
import java.util.Collection;
import java.util.Set;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.ManyToOne;

@Entity
public class CmCheck
implements EntityBean {
    @Id
    private Integer id;
    @ManyToOne
    private User login;
    @ManyToOne
    private CmStatement statement;
    @ManyToOne
    private CmPage page;
    private Boolean checked;
    public static /* synthetic */ String[] _ebean_props;
    protected /* synthetic */ EntityBeanIntercept _ebean_intercept;
    protected transient /* synthetic */ Object _ebean_identity;

    public CmCheck() {
        this._ebean_intercept = new EntityBeanIntercept((Object)this);
    }

    public static void deleteByStatement(int statementId) {
        Update<CmCheck> delete = DB.createUpdate(CmCheck.class, "DELETE FROM CmCheck WHERE statement=:statement");
        delete.setParameter("statement", (Object)statementId);
        delete.execute();
    }

    public static void deleteByUser(User user) {
        Update<CmCheck> delete = DB.createUpdate(CmCheck.class, "DELETE FROM CmCheck WHERE login=:login");
        delete.setParameter("login", (Object)user.getId());
        delete.execute();
    }

    public static void deleteForUserAndStatement(User user, CmStatement statement) {
        Update<CmCheck> delete = DB.createUpdate(CmCheck.class, "DELETE FROM CmCheck WHERE login=:login AND statement=:statement");
        delete.setParameter("login", (Object)user.getId());
        delete.setParameter("statement", (Object)statement.getId());
        delete.execute();
    }

    public static void deleteForUserAndStatement(User user, Set<Integer> statementIds) {
        Update<CmCheck> delete = DB.createUpdate(CmCheck.class, "DELETE FROM CmCheck WHERE login=:login AND statement in (:statements)");
        delete.setParameter("login", (Object)user.getId());
        delete.setParameter("statements", statementIds);
        delete.execute();
    }

    public static void deleteForUserAndPage(User user, Set<Integer> pageIds) {
        Update<CmCheck> delete = DB.createUpdate(CmCheck.class, "DELETE FROM CmCheck WHERE login=:login AND page in (:pages)");
        delete.setParameter("login", (Object)user.getId());
        delete.setParameter("pages", pageIds);
        delete.execute();
    }

    public static void deleteForUserAndPage(User user, CmPage page) {
        Update<CmCheck> delete = DB.createUpdate(CmCheck.class, "DELETE FROM CmCheck WHERE login=:login AND page=:page");
        delete.setParameter("login", (Object)user.getId());
        delete.setParameter("page", (Object)page.getId());
        delete.execute();
        CmStatement statement = page.getStatement();
        CmCheck cs = (CmCheck)DB.find(CmCheck.class).where().eq("login", (Object)user).eq("statement", (Object)statement).isNull("page").findOne();
        if (cs != null) {
            int uncheckedPages;
            int checkedPages = DB.find(CmCheck.class).where().eq("login", (Object)user).eq("statement", (Object)statement).isNotNull("page").eq("checked", (Object)true).findCount();
            if (checkedPages + (uncheckedPages = DB.find(CmCheck.class).where().eq("login", (Object)user).eq("statement", (Object)statement).isNotNull("page").eq("checked", (Object)false).findCount()) == 0) {
                CmCheck.deleteForUserAndStatement(user, statement);
            } else {
                Boolean csChecked = checkedPages == 0 ? Boolean.valueOf(false) : null;
                cs.setChecked(csChecked);
                DB.update(cs);
            }
        }
    }

    public static boolean isChecked(User login, CmStatement statement) {
        CmCheck c = (CmCheck)DB.find(CmCheck.class).where().eq("login", (Object)login).eq("statement", (Object)statement).isNull("page").findOne();
        if (c == null || !c.isChecked()) {
            return false;
        }
        return c.isChecked();
    }

    public static boolean isGrayed(User login, CmStatement stmt) {
        CmCheck c = (CmCheck)DB.find(CmCheck.class).where().eq("login", (Object)login).eq("statement", (Object)stmt).isNull("page").findOne();
        if (c == null) {
            return false;
        }
        return c.isGrayed();
    }

    public static boolean isChecked(User login, CmPage page) {
        CmCheck c = (CmCheck)DB.find(CmCheck.class).where().eq("login", (Object)login).eq("page", (Object)page).findOne();
        if (c == null) {
            return false;
        }
        return c.isChecked();
    }

    public static boolean isChecked(User login, Account a, Collection<CmStatement.Type> types) {
        Expression expr = Expr.in((String)"statement.type", types);
        expr = Expr.and((Expression)Expr.eq((String)"statement.account", (Object)a), (Expression)expr);
        return DB.find(CmCheck.class).where().eq("login", (Object)login).or(Expr.eq((String)"checked", (Object)true), Expr.isNull((String)"checked")).add(expr).setMaxRows(1).findOne() != null;
    }

    public static boolean isGrayed(User login, Account account, Collection<CmStatement.Type> types) {
        Expression expr = Expr.in((String)"statement.type", types);
        expr = Expr.and((Expression)Expr.eq((String)"statement.account", (Object)account), (Expression)expr);
        int countChecked = DB.find(CmCheck.class).where().eq("login", (Object)login).eq("checked", (Object)true).isNull("page").add(expr).findCount();
        expr = Expr.in((String)"type", types);
        expr = Expr.and((Expression)Expr.eq((String)"account", (Object)account), (Expression)expr);
        int total = DB.find(CmStatement.class).where(expr).findCount();
        return total != countChecked;
    }

    public static void setChecked(User login, CmStatement statement, boolean checked) {
        CmCheck c = (CmCheck)DB.find(CmCheck.class).where().eq("login", (Object)login).eq("statement", (Object)statement).isNull("page").findOne();
        if (c == null) {
            c = new CmCheck();
            c.setLogin(login);
            c.setStatement(statement);
        }
        c.setChecked(checked);
        if (c.getId() == null) {
            DB.save(c);
        } else {
            DB.update(c);
        }
        for (CmPage p : CmPage.findByStatement(statement, true)) {
            CmCheck cp = (CmCheck)DB.find(CmCheck.class).where().eq("login", (Object)login).eq("page", (Object)p).findOne();
            if (cp == null) {
                cp = new CmCheck();
                cp.setChecked(checked);
                cp.setLogin(login);
                cp.setStatement(statement);
                cp.setPage(p);
                DB.save(cp);
                continue;
            }
            cp.setChecked(checked);
            DB.update(cp);
        }
    }

    public static void setChecked(User login, CmPage page, boolean checked) {
        CmCheck c = (CmCheck)DB.find(CmCheck.class).where().eq("login", (Object)login).eq("page", (Object)page).findOne();
        if (c == null) {
            c = new CmCheck();
            c.setLogin(login);
            c.setStatement(page.getStatement());
            c.setPage(page);
        }
        c.setChecked(checked);
        if (c.getId() == null) {
            DB.save(c);
        } else {
            DB.update(c);
        }
        Boolean csChecked = null;
        int pagesCount = CmPage.findCountForStatement(page.getStatement());
        if (checked) {
            int set = DB.find(CmCheck.class).where().eq("login", (Object)login).eq("statement", (Object)page.getStatement()).isNotNull("page").eq("checked", (Object)true).findCount();
            if (set == pagesCount) {
                csChecked = Boolean.TRUE;
            }
        } else {
            int unset = DB.find(CmCheck.class).where().eq("login", (Object)login).eq("statement", (Object)page.getStatement()).isNotNull("page").eq("checked", (Object)false).findCount();
            if (unset == pagesCount) {
                csChecked = Boolean.FALSE;
            }
        }
        CmCheck cs = (CmCheck)DB.find(CmCheck.class).where().eq("login", (Object)login).eq("statement", (Object)page.getStatement()).isNull("page").findOne();
        if (cs == null) {
            cs = new CmCheck();
            cs.setChecked(csChecked);
            cs.setLogin(login);
            cs.setStatement(page.getStatement());
            DB.save(cs);
        } else {
            cs.setChecked(csChecked);
            DB.update(cs);
        }
    }

    public static void deleteForUserAndAccountId(User user, Integer accountId) {
        SqlUpdate sqlUpdate = DB.sqlUpdate("DELETE FROM cm_check WHERE login_id=:user AND statement_id in (select id from cm_statement where account_id=:accountId)");
        sqlUpdate.setParameter("user", (Object)user.getId());
        sqlUpdate.setParameter("accountId", (Object)accountId);
        sqlUpdate.execute();
    }

    public static int getAccountCountByUser(User user) {
        SqlQuery query = DB.sqlQuery("select count(*) as anzahl from account where id in (select account_id from cm_statement where id in (select statement_id from cm_check where login_id=:user))");
        query.setParameter("user", (Object)user.getId());
        return query.findOne().getInteger("anzahl");
    }

    public void setPage(CmPage page) {
        this._ebean_set_page(page);
    }

    public Integer getId() {
        return this._ebean_get_id();
    }

    public void setId(Integer id) {
        this._ebean_set_id(id);
    }

    public User getLogin() {
        return this._ebean_get_login();
    }

    public void setLogin(User login) {
        this._ebean_set_login(login);
    }

    public void setStatement(CmStatement statement) {
        this._ebean_set_statement(statement);
    }

    public boolean isChecked() {
        if (this._ebean_get_checked() == null) {
            return true;
        }
        return this._ebean_get_checked();
    }

    public boolean isGrayed() {
        return this._ebean_get_checked() == null;
    }

    public void setChecked(Boolean checked) {
        this._ebean_set_checked(checked);
    }

    static {
        _ebean_props = new String[]{"id", "login", "statement", "page", "checked"};
    }

    public /* synthetic */ String[] _ebean_getPropertyNames() {
        return _ebean_props;
    }

    public /* synthetic */ String _ebean_getPropertyName(int pos) {
        return _ebean_props[pos];
    }

    public /* synthetic */ EntityBeanIntercept _ebean_getIntercept() {
        return this._ebean_intercept;
    }

    public /* synthetic */ EntityBeanIntercept _ebean_intercept() {
        if (this._ebean_intercept == null) {
            this._ebean_intercept = new EntityBeanIntercept((Object)this);
        }
        return this._ebean_intercept;
    }

    protected /* synthetic */ Integer _ebean_get_id() {
        this._ebean_intercept.preGetId();
        return this.id;
    }

    protected /* synthetic */ void _ebean_set_id(Integer newValue) {
        this._ebean_intercept.preSetter(false, 0, (Object)this.id, (Object)newValue);
        this.id = newValue;
    }

    protected /* synthetic */ Integer _ebean_getni_id() {
        return this.id;
    }

    protected /* synthetic */ void _ebean_setni_id(Integer _newValue) {
        this.id = _newValue;
        this._ebean_intercept.setLoadedProperty(0);
    }

    protected /* synthetic */ User _ebean_get_login() {
        this._ebean_intercept.preGetter(1);
        return this.login;
    }

    protected /* synthetic */ void _ebean_set_login(User newValue) {
        this._ebean_intercept.preSetter(true, 1, (Object)this._ebean_get_login(), (Object)newValue);
        this.login = newValue;
    }

    protected /* synthetic */ User _ebean_getni_login() {
        return this.login;
    }

    protected /* synthetic */ void _ebean_setni_login(User _newValue) {
        this.login = _newValue;
        this._ebean_intercept.setLoadedProperty(1);
    }

    protected /* synthetic */ CmStatement _ebean_get_statement() {
        this._ebean_intercept.preGetter(2);
        return this.statement;
    }

    protected /* synthetic */ void _ebean_set_statement(CmStatement newValue) {
        this._ebean_intercept.preSetter(true, 2, (Object)this._ebean_get_statement(), (Object)newValue);
        this.statement = newValue;
    }

    protected /* synthetic */ CmStatement _ebean_getni_statement() {
        return this.statement;
    }

    protected /* synthetic */ void _ebean_setni_statement(CmStatement _newValue) {
        this.statement = _newValue;
        this._ebean_intercept.setLoadedProperty(2);
    }

    protected /* synthetic */ CmPage _ebean_get_page() {
        this._ebean_intercept.preGetter(3);
        return this.page;
    }

    protected /* synthetic */ void _ebean_set_page(CmPage newValue) {
        this._ebean_intercept.preSetter(true, 3, (Object)this._ebean_get_page(), (Object)newValue);
        this.page = newValue;
    }

    protected /* synthetic */ CmPage _ebean_getni_page() {
        return this.page;
    }

    protected /* synthetic */ void _ebean_setni_page(CmPage _newValue) {
        this.page = _newValue;
        this._ebean_intercept.setLoadedProperty(3);
    }

    protected /* synthetic */ Boolean _ebean_get_checked() {
        this._ebean_intercept.preGetter(4);
        return this.checked;
    }

    protected /* synthetic */ void _ebean_set_checked(Boolean newValue) {
        this._ebean_intercept.preSetter(true, 4, (Object)this._ebean_get_checked(), (Object)newValue);
        this.checked = newValue;
    }

    protected /* synthetic */ Boolean _ebean_getni_checked() {
        return this.checked;
    }

    protected /* synthetic */ void _ebean_setni_checked(Boolean _newValue) {
        this.checked = _newValue;
        this._ebean_intercept.setLoadedProperty(4);
    }

    public /* synthetic */ Object _ebean_getField(int index) {
        switch (index) {
            case 0: {
                return this.id;
            }
            case 1: {
                return this.login;
            }
            case 2: {
                return this.statement;
            }
            case 3: {
                return this.page;
            }
            case 4: {
                return this.checked;
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    public /* synthetic */ Object _ebean_getFieldIntercept(int index) {
        switch (index) {
            case 0: {
                return this._ebean_get_id();
            }
            case 1: {
                return this._ebean_get_login();
            }
            case 2: {
                return this._ebean_get_statement();
            }
            case 3: {
                return this._ebean_get_page();
            }
            case 4: {
                return this._ebean_get_checked();
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    public /* synthetic */ void _ebean_setField(int index, Object o) {
        switch (index) {
            case 0: {
                this._ebean_setni_id((Integer)o);
                return;
            }
            case 1: {
                this._ebean_setni_login((User)o);
                return;
            }
            case 2: {
                this._ebean_setni_statement((CmStatement)o);
                return;
            }
            case 3: {
                this._ebean_setni_page((CmPage)o);
                return;
            }
            case 4: {
                this._ebean_setni_checked((Boolean)o);
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    public /* synthetic */ void _ebean_setFieldIntercept(int index, Object o) {
        switch (index) {
            case 0: {
                this._ebean_set_id((Integer)o);
                return;
            }
            case 1: {
                this._ebean_set_login((User)o);
                return;
            }
            case 2: {
                this._ebean_set_statement((CmStatement)o);
                return;
            }
            case 3: {
                this._ebean_set_page((CmPage)o);
                return;
            }
            case 4: {
                this._ebean_set_checked((Boolean)o);
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private /* synthetic */ Object _ebean_getIdentity() {
        CmCheck cmCheck = this;
        synchronized (cmCheck) {
            if (this._ebean_identity != null) {
                return this._ebean_identity;
            }
            Object tmpId = this._ebean_getField(0);
            this._ebean_identity = tmpId != null ? tmpId : new Object();
            return this._ebean_identity;
        }
    }

    public /* synthetic */ boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        return this._ebean_getIdentity().equals(((CmCheck)obj)._ebean_getIdentity());
    }

    public /* synthetic */ int hashCode() {
        return this._ebean_getIdentity().hashCode();
    }

    public /* synthetic */ void _ebean_setEmbeddedLoaded() {
    }

    public /* synthetic */ boolean _ebean_isEmbeddedNewOrDirty() {
        return false;
    }

    public /* synthetic */ Object _ebean_newInstance() {
        return new CmCheck();
    }
}

