/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.database.vo;

import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.FilterComparator;
import de.businesslogics.banking.database.vo.User;
import io.ebean.Expr;
import io.ebean.Expression;
import io.ebean.bean.EntityBean;
import io.ebean.bean.EntityBeanIntercept;
import java.math.BigDecimal;
import java.sql.Date;
import java.util.Calendar;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.OneToOne;
import javax.persistence.Table;

@Entity
@Table(name="cm_b_filter")
public class CmBookingFilter
implements EntityBean {
    @Id
    private Integer id;
    @OneToOne(optional=false)
    private User user;
    private Boolean filterActive;
    private Date bookingDateFrom;
    private Date bookingDateTo;
    @Column(name="bd_comp")
    private FilterComparator.Date bookingDateComparator;
    private Date valueDateFrom;
    private Date valueDateTo;
    @Column(name="vd_comp")
    private FilterComparator.Date valueDateComparator;
    private String text;
    @Column(name="text_comp")
    private FilterComparator.Text textComparator;
    @Column(precision=38, scale=3)
    private BigDecimal amountFrom;
    @Column(precision=38, scale=3)
    private BigDecimal amountTo;
    @Column(name="amount_comp")
    private FilterComparator.Amount amountComparator;
    @Column(name="booking_dir", nullable=false)
    private BookingDirection bookingDirection;
    private BookingType bookingType;
    @Column(length=3)
    private String bookingTypeText;
    public static /* synthetic */ String[] _ebean_props;
    protected /* synthetic */ EntityBeanIntercept _ebean_intercept;
    protected transient /* synthetic */ Object _ebean_identity;

    public CmBookingFilter(User user) {
        this._ebean_intercept = new EntityBeanIntercept((Object)this);
        this._ebean_set_user(user);
        this._ebean_set_bookingDirection(BookingDirection.ALL);
    }

    public static CmBookingFilter getFilter(User user) {
        CmBookingFilter f = (CmBookingFilter)DB.find(CmBookingFilter.class).where().eq("user", (Object)user).findOne();
        if (f == null) {
            f = new CmBookingFilter(user);
        }
        return f;
    }

    public static void deleteByUser(User user) {
        CmBookingFilter toDelete = CmBookingFilter.getFilter(user);
        if (toDelete.id != null) {
            DB.delete(toDelete);
        }
    }

    public static boolean isBookingTypeWithTextField(BookingType bookingType) {
        return BookingType.BOOKING_KEY.equals((Object)bookingType) || BookingType.GVC.equals((Object)bookingType);
    }

    public User getUser() {
        return this._ebean_get_user();
    }

    public boolean isFilterActive() {
        return this._ebean_get_filterActive() == null ? false : this._ebean_get_filterActive();
    }

    public void setFilterActive(Boolean filterActive) {
        this._ebean_set_filterActive(filterActive);
    }

    public Date getBookingDateFrom() {
        return this._ebean_get_bookingDateFrom();
    }

    public void setBookingDateFrom(Date bookingDateFrom) {
        if (bookingDateFrom == null) {
            this._ebean_set_bookingDateFrom(null);
        } else {
            this._ebean_set_bookingDateFrom(this.getDateAtTimeZero(bookingDateFrom));
        }
    }

    private Date getDateAtTimeZero(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(14, 0);
        cal.set(13, 0);
        cal.set(12, 0);
        cal.set(11, 0);
        return new Date(cal.getTimeInMillis());
    }

    public Date getBookingDateTo() {
        return this._ebean_get_bookingDateTo();
    }

    public void setBookingDateTo(Date bookingDateTo) {
        if (bookingDateTo == null) {
            this._ebean_set_bookingDateTo(null);
        } else {
            this._ebean_set_bookingDateTo(this.getDateAtTimeZero(bookingDateTo));
        }
    }

    public FilterComparator.Date getBookingDateComparator() {
        return this._ebean_get_bookingDateComparator();
    }

    public void setBookingDateComparator(FilterComparator.Date bookingDateComparator) {
        this._ebean_set_bookingDateComparator(bookingDateComparator);
    }

    public Date getValueDateFrom() {
        return this._ebean_get_valueDateFrom();
    }

    public void setValueDateFrom(Date valueDateFrom) {
        if (valueDateFrom == null) {
            this._ebean_set_valueDateFrom(null);
        } else {
            this._ebean_set_valueDateFrom(this.getDateAtTimeZero(valueDateFrom));
        }
    }

    public Date getValueDateTo() {
        return this._ebean_get_valueDateTo();
    }

    public void setValueDateTo(Date valueDateTo) {
        if (valueDateTo == null) {
            this._ebean_set_valueDateTo(null);
        } else {
            this._ebean_set_valueDateTo(this.getDateAtTimeZero(valueDateTo));
        }
    }

    public FilterComparator.Date getValueDateComparator() {
        return this._ebean_get_valueDateComparator();
    }

    public void setValueDateComparator(FilterComparator.Date valueDateComparator) {
        this._ebean_set_valueDateComparator(valueDateComparator);
    }

    public String getText() {
        return this._ebean_get_text();
    }

    public void setText(String text) {
        if (text != null && text.trim().length() > 0) {
            this._ebean_set_text(text.trim());
        } else {
            this._ebean_set_text(null);
        }
    }

    public FilterComparator.Text getTextComparator() {
        return this._ebean_get_textComparator();
    }

    public void setTextComparator(FilterComparator.Text textComparator) {
        this._ebean_set_textComparator(textComparator);
    }

    public BigDecimal getAmountFrom() {
        return this._ebean_get_amountFrom();
    }

    public void setAmountFrom(BigDecimal amountFrom) {
        if (amountFrom != null) {
            this._ebean_set_amountFrom(amountFrom.abs());
        } else {
            this._ebean_set_amountFrom(null);
        }
    }

    public BigDecimal getAmountTo() {
        return this._ebean_get_amountTo();
    }

    public void setAmountTo(BigDecimal amountTo) {
        if (amountTo != null) {
            this._ebean_set_amountTo(amountTo.abs());
        } else {
            this._ebean_set_amountTo(null);
        }
    }

    public FilterComparator.Amount getAmountComparator() {
        return this._ebean_get_amountComparator();
    }

    public void setAmountComparator(FilterComparator.Amount amountComparator) {
        this._ebean_set_amountComparator(amountComparator);
    }

    public BookingDirection getBookingDirection() {
        return this._ebean_get_bookingDirection();
    }

    public void setBookingDirection(BookingDirection bookingDirection) {
        this._ebean_set_bookingDirection(bookingDirection);
    }

    public BookingType getBookingType() {
        return this._ebean_get_bookingType();
    }

    public void setBookingType(BookingType bookingType) {
        this._ebean_set_bookingType(bookingType);
    }

    public String getBookingTypeText() {
        return this._ebean_get_bookingTypeText();
    }

    public void setBookingTypeText(String bookingTypeText) {
        if (bookingTypeText != null && bookingTypeText.trim().length() > 0) {
            this._ebean_set_bookingTypeText(bookingTypeText.trim());
        } else {
            this._ebean_set_bookingTypeText(null);
        }
    }

    public void save() {
        if (this._ebean_get_id() == null) {
            DB.save(this);
        } else {
            DB.update(this);
        }
    }

    public void reset() {
        this._ebean_set_filterActive(null);
        this._ebean_set_bookingDateFrom(null);
        this._ebean_set_bookingDateTo(null);
        this._ebean_set_bookingDateComparator(null);
        this._ebean_set_valueDateFrom(null);
        this._ebean_set_valueDateTo(null);
        this._ebean_set_valueDateComparator(null);
        this._ebean_set_text(null);
        this._ebean_set_textComparator(null);
        this._ebean_set_amountFrom(null);
        this._ebean_set_amountTo(null);
        this._ebean_set_amountComparator(null);
        this._ebean_set_bookingDirection(BookingDirection.ALL);
        this._ebean_set_bookingTypeText(null);
        this._ebean_set_bookingType(null);
        this.save();
    }

    public int getBookingDateComparatorId() {
        if (this._ebean_get_bookingDateComparator() != null) {
            return this._ebean_get_bookingDateComparator().ordinal();
        }
        return -1;
    }

    public void setBookingDateComparator(int bookingDateComparatorId) {
        if (bookingDateComparatorId >= 0 && bookingDateComparatorId < FilterComparator.Date.values().length) {
            this._ebean_set_bookingDateComparator(FilterComparator.Date.values()[bookingDateComparatorId]);
        } else {
            this._ebean_set_bookingDateComparator(null);
        }
    }

    public int getValueDateComparatorId() {
        if (this._ebean_get_valueDateComparator() != null) {
            return this._ebean_get_valueDateComparator().ordinal();
        }
        return -1;
    }

    public void setValueDateComparator(int valueDateComparatorId) {
        if (valueDateComparatorId >= 0 && valueDateComparatorId < FilterComparator.Date.values().length) {
            this._ebean_set_valueDateComparator(FilterComparator.Date.values()[valueDateComparatorId]);
        } else {
            this._ebean_set_valueDateComparator(null);
        }
    }

    public int getTextComparatorId() {
        if (this._ebean_get_textComparator() != null) {
            return this._ebean_get_textComparator().ordinal();
        }
        return 0;
    }

    public void setTextComparator(int textComparatorId) {
        if (textComparatorId >= 0 && textComparatorId < FilterComparator.Text.values().length) {
            this._ebean_set_textComparator(FilterComparator.Text.values()[textComparatorId]);
        } else {
            this._ebean_set_textComparator(null);
        }
    }

    public int getAmountComparatorId() {
        if (this._ebean_get_amountComparator() != null) {
            return this._ebean_get_amountComparator().ordinal();
        }
        return 0;
    }

    public void setAmountComparator(int amountComparatorId) {
        if (amountComparatorId >= 0 && amountComparatorId < FilterComparator.Amount.values().length) {
            this._ebean_set_amountComparator(FilterComparator.Amount.values()[amountComparatorId]);
        } else {
            this._ebean_set_amountComparator(null);
        }
    }

    public void setBookingDirection(int bookingDirectionId) {
        if (bookingDirectionId >= 0 && bookingDirectionId < BookingDirection.values().length) {
            this._ebean_set_bookingDirection(BookingDirection.values()[bookingDirectionId]);
        } else {
            this._ebean_set_bookingDirection(BookingDirection.ALL);
        }
    }

    public int getBookingTypeId() {
        if (this._ebean_get_bookingType() != null) {
            return this._ebean_get_bookingType().ordinal();
        }
        return 0;
    }

    public void setBookingType(int bookingTypeId) {
        if (bookingTypeId >= 0 && bookingTypeId < BookingType.values().length) {
            this._ebean_set_bookingType(BookingType.values()[bookingTypeId]);
        } else {
            this._ebean_set_bookingType(BookingType.ALL);
        }
    }

    public Expression getExpression() {
        Expression booking = null;
        if (this._ebean_get_bookingDateComparator() != null && (this._ebean_get_bookingDateFrom() != null || this._ebean_get_bookingDateComparator() == FilterComparator.Date.BETWEEN && this._ebean_get_bookingDateTo() != null)) {
            switch (this._ebean_get_bookingDateComparator()) {
                case EQUAL: {
                    booking = Expr.eq((String)"bookingDate", (Object)this._ebean_get_bookingDateFrom());
                    break;
                }
                case GREATER: {
                    booking = Expr.gt((String)"bookingDate", (Object)this._ebean_get_bookingDateFrom());
                    break;
                }
                case LESS: {
                    booking = Expr.lt((String)"bookingDate", (Object)this._ebean_get_bookingDateFrom());
                    break;
                }
                case BETWEEN: {
                    if (this._ebean_get_bookingDateFrom() != null && this._ebean_get_bookingDateTo() != null) {
                        if (this._ebean_get_bookingDateFrom().before(this._ebean_get_bookingDateTo())) {
                            booking = Expr.between((String)"bookingDate", (Object)this._ebean_get_bookingDateFrom(), (Object)this._ebean_get_bookingDateTo());
                            break;
                        }
                        booking = Expr.between((String)"bookingDate", (Object)this._ebean_get_bookingDateTo(), (Object)this._ebean_get_bookingDateFrom());
                        break;
                    }
                    if (this._ebean_get_bookingDateFrom() != null) {
                        booking = Expr.ge((String)"bookingDate", (Object)this._ebean_get_bookingDateFrom());
                        break;
                    }
                    booking = Expr.le((String)"bookingDate", (Object)this._ebean_get_bookingDateTo());
                    break;
                }
            }
        }
        Expression value = null;
        if (this._ebean_get_valueDateComparator() != null && (this._ebean_get_valueDateFrom() != null || this._ebean_get_valueDateComparator() == FilterComparator.Date.BETWEEN && this._ebean_get_valueDateTo() != null)) {
            switch (this._ebean_get_valueDateComparator()) {
                case EQUAL: {
                    value = Expr.eq((String)"valueDate", (Object)this._ebean_get_valueDateFrom());
                    break;
                }
                case GREATER: {
                    value = Expr.gt((String)"valueDate", (Object)this._ebean_get_valueDateFrom());
                    break;
                }
                case LESS: {
                    value = Expr.lt((String)"valueDate", (Object)this._ebean_get_valueDateFrom());
                    break;
                }
                case BETWEEN: {
                    if (this._ebean_get_valueDateFrom() != null && this._ebean_get_valueDateTo() != null) {
                        if (this._ebean_get_valueDateFrom().before(this._ebean_get_valueDateTo())) {
                            value = Expr.between((String)"valueDate", (Object)this._ebean_get_valueDateFrom(), (Object)this._ebean_get_valueDateTo());
                            break;
                        }
                        value = Expr.between((String)"valueDate", (Object)this._ebean_get_valueDateTo(), (Object)this._ebean_get_valueDateFrom());
                        break;
                    }
                    if (this._ebean_get_valueDateFrom() != null) {
                        value = Expr.ge((String)"valueDate", (Object)this._ebean_get_valueDateFrom());
                        break;
                    }
                    value = Expr.le((String)"valueDate", (Object)this._ebean_get_valueDateTo());
                    break;
                }
            }
        }
        Expression amount = null;
        if (this._ebean_get_amountComparator() != null && (this._ebean_get_amountFrom() != null || this._ebean_get_amountComparator() == FilterComparator.Amount.BETWEEN && this._ebean_get_amountTo() != null)) {
            switch (this._ebean_get_amountComparator()) {
                case EQUAL: {
                    amount = Expr.eq((String)"abs(amount)", (Object)this._ebean_get_amountFrom());
                    break;
                }
                case GREATER: {
                    amount = Expr.gt((String)"abs(amount)", (Object)this._ebean_get_amountFrom());
                    break;
                }
                case LESS: {
                    amount = Expr.lt((String)"abs(amount)", (Object)this._ebean_get_amountFrom());
                    break;
                }
                case BETWEEN: {
                    if (this._ebean_get_amountFrom() != null && this._ebean_get_amountTo() != null) {
                        if (this._ebean_get_amountFrom().compareTo(this._ebean_get_amountTo()) < 0) {
                            amount = Expr.between((String)"abs(amount)", (Object)this._ebean_get_amountFrom(), (Object)this._ebean_get_amountTo());
                            break;
                        }
                        amount = Expr.between((String)"abs(amount)", (Object)this._ebean_get_amountTo(), (Object)this._ebean_get_amountFrom());
                        break;
                    }
                    if (this._ebean_get_amountFrom() != null) {
                        amount = Expr.ge((String)"abs(amount)", (Object)this._ebean_get_amountFrom());
                        break;
                    }
                    amount = Expr.le((String)"abs(amount)", (Object)this._ebean_get_amountTo());
                    break;
                }
            }
        }
        Expression amountDirection = null;
        if (this._ebean_get_bookingDirection() != null) {
            switch (this._ebean_get_bookingDirection().ordinal()) {
                case 1: {
                    amountDirection = Expr.ge((String)"amount", (Object)0);
                    break;
                }
                case 2: {
                    amountDirection = Expr.le((String)"amount", (Object)0);
                    break;
                }
            }
            if (amountDirection != null) {
                amount = amount != null ? Expr.and((Expression)amountDirection, (Expression)amount) : amountDirection;
            }
        }
        Expression text = null;
        if (this._ebean_get_text() != null) {
            text = this.buildFilterExpression("purpose", "purposeOverview", "localParty", "localPartyBankCode", "localPartyAccountNumber", "localPartyMandateReference", "counterParty", "counterPartyBankCode", "counterPartyAccountNumber", "counterPartyCreditorId", "bookingKey", "bookingText", "gvc", "primanota", "additionalInformation", "bankReference", "customerReference", "purposeCode");
        }
        Expression type = null;
        if (this._ebean_get_bookingType() != null) {
            switch (this._ebean_get_bookingType().ordinal()) {
                case 0: {
                    break;
                }
                case 1: {
                    type = Expr.and((Expression)Expr.eq((String)"debit", (Object)false), (Expression)Expr.eq((String)"reversal", (Object)false));
                    break;
                }
                case 2: {
                    type = Expr.and((Expression)Expr.eq((String)"debit", (Object)true), (Expression)Expr.eq((String)"reversal", (Object)false));
                    break;
                }
                case 3: {
                    type = Expr.and((Expression)Expr.eq((String)"debit", (Object)false), (Expression)Expr.eq((String)"reversal", (Object)true));
                    break;
                }
                case 4: {
                    type = Expr.and((Expression)Expr.eq((String)"debit", (Object)true), (Expression)Expr.eq((String)"reversal", (Object)true));
                    break;
                }
                case 5: {
                    if (this._ebean_get_bookingTypeText() == null || this._ebean_get_bookingTypeText().length() <= 0) break;
                    String filter = "%" + this._ebean_get_bookingTypeText() + "%";
                    type = Expr.ilike((String)"bookingKey", (String)filter);
                    break;
                }
                case 6: {
                    if (this._ebean_get_bookingTypeText() == null || this._ebean_get_bookingTypeText().length() <= 0) break;
                    String filter = "%" + this._ebean_get_bookingTypeText() + "%";
                    type = Expr.ilike((String)"gvc", (String)filter);
                    break;
                }
            }
        }
        Expression toReturn = booking;
        if (value != null) {
            toReturn = toReturn == null ? value : Expr.and((Expression)toReturn, (Expression)value);
        }
        if (amount != null) {
            toReturn = toReturn == null ? amount : Expr.and((Expression)toReturn, (Expression)amount);
        }
        if (text != null) {
            toReturn = toReturn == null ? text : Expr.and((Expression)toReturn, text);
        }
        if (type != null) {
            toReturn = toReturn == null ? type : Expr.and((Expression)toReturn, (Expression)type);
        }
        return toReturn;
    }

    private Expression buildFilterExpression(String ... columns) {
        Object filter = this._ebean_get_textComparator() == FilterComparator.Text.STARTS_WITH || this._ebean_get_textComparator() == FilterComparator.Text.ENDS_WITH ? this._ebean_get_text() : "%" + this._ebean_get_text() + "%";
        Expression result = null;
        if (columns != null && columns.length > 0) {
            for (String column : columns) {
                Expression part;
                if (this._ebean_get_textComparator() == FilterComparator.Text.STARTS_WITH) {
                    part = Expr.istartsWith((String)column, (String)filter);
                } else if (this._ebean_get_textComparator() == FilterComparator.Text.ENDS_WITH) {
                    part = Expr.iendsWith((String)column, (String)filter);
                } else {
                    part = Expr.ilike((String)column, (String)filter);
                    if (this._ebean_get_textComparator() == FilterComparator.Text.CONTAINS_NOT) {
                        part = Expr.and((Expression)Expr.isNotNull((String)column), (Expression)part);
                    }
                }
                result = result == null ? part : Expr.or((Expression)result, (Expression)part);
            }
            if (this._ebean_get_textComparator() == FilterComparator.Text.CONTAINS_NOT) {
                result = Expr.not(result);
            }
        }
        return result;
    }

    static {
        _ebean_props = new String[]{"id", "user", "filterActive", "bookingDateFrom", "bookingDateTo", "bookingDateComparator", "valueDateFrom", "valueDateTo", "valueDateComparator", "text", "textComparator", "amountFrom", "amountTo", "amountComparator", "bookingDirection", "bookingType", "bookingTypeText"};
    }

    public /* synthetic */ CmBookingFilter() {
        this._ebean_intercept = new EntityBeanIntercept((Object)this);
    }

    public /* synthetic */ String[] _ebean_getPropertyNames() {
        return _ebean_props;
    }

    public /* synthetic */ String _ebean_getPropertyName(int pos) {
        return _ebean_props[pos];
    }

    public /* synthetic */ EntityBeanIntercept _ebean_getIntercept() {
        return this._ebean_intercept;
    }

    public /* synthetic */ EntityBeanIntercept _ebean_intercept() {
        if (this._ebean_intercept == null) {
            this._ebean_intercept = new EntityBeanIntercept((Object)this);
        }
        return this._ebean_intercept;
    }

    protected /* synthetic */ Integer _ebean_get_id() {
        this._ebean_intercept.preGetId();
        return this.id;
    }

    protected /* synthetic */ void _ebean_set_id(Integer newValue) {
        this._ebean_intercept.preSetter(false, 0, (Object)this.id, (Object)newValue);
        this.id = newValue;
    }

    protected /* synthetic */ Integer _ebean_getni_id() {
        return this.id;
    }

    protected /* synthetic */ void _ebean_setni_id(Integer _newValue) {
        this.id = _newValue;
        this._ebean_intercept.setLoadedProperty(0);
    }

    protected /* synthetic */ User _ebean_get_user() {
        this._ebean_intercept.preGetter(1);
        return this.user;
    }

    protected /* synthetic */ void _ebean_set_user(User newValue) {
        this._ebean_intercept.preSetter(true, 1, (Object)this._ebean_get_user(), (Object)newValue);
        this.user = newValue;
    }

    protected /* synthetic */ User _ebean_getni_user() {
        return this.user;
    }

    protected /* synthetic */ void _ebean_setni_user(User _newValue) {
        this.user = _newValue;
        this._ebean_intercept.setLoadedProperty(1);
    }

    protected /* synthetic */ Boolean _ebean_get_filterActive() {
        this._ebean_intercept.preGetter(2);
        return this.filterActive;
    }

    protected /* synthetic */ void _ebean_set_filterActive(Boolean newValue) {
        this._ebean_intercept.preSetter(true, 2, (Object)this._ebean_get_filterActive(), (Object)newValue);
        this.filterActive = newValue;
    }

    protected /* synthetic */ Boolean _ebean_getni_filterActive() {
        return this.filterActive;
    }

    protected /* synthetic */ void _ebean_setni_filterActive(Boolean _newValue) {
        this.filterActive = _newValue;
        this._ebean_intercept.setLoadedProperty(2);
    }

    protected /* synthetic */ Date _ebean_get_bookingDateFrom() {
        this._ebean_intercept.preGetter(3);
        return this.bookingDateFrom;
    }

    protected /* synthetic */ void _ebean_set_bookingDateFrom(Date newValue) {
        this._ebean_intercept.preSetter(true, 3, (Object)this._ebean_get_bookingDateFrom(), (Object)newValue);
        this.bookingDateFrom = newValue;
    }

    protected /* synthetic */ Date _ebean_getni_bookingDateFrom() {
        return this.bookingDateFrom;
    }

    protected /* synthetic */ void _ebean_setni_bookingDateFrom(Date _newValue) {
        this.bookingDateFrom = _newValue;
        this._ebean_intercept.setLoadedProperty(3);
    }

    protected /* synthetic */ Date _ebean_get_bookingDateTo() {
        this._ebean_intercept.preGetter(4);
        return this.bookingDateTo;
    }

    protected /* synthetic */ void _ebean_set_bookingDateTo(Date newValue) {
        this._ebean_intercept.preSetter(true, 4, (Object)this._ebean_get_bookingDateTo(), (Object)newValue);
        this.bookingDateTo = newValue;
    }

    protected /* synthetic */ Date _ebean_getni_bookingDateTo() {
        return this.bookingDateTo;
    }

    protected /* synthetic */ void _ebean_setni_bookingDateTo(Date _newValue) {
        this.bookingDateTo = _newValue;
        this._ebean_intercept.setLoadedProperty(4);
    }

    protected /* synthetic */ FilterComparator.Date _ebean_get_bookingDateComparator() {
        this._ebean_intercept.preGetter(5);
        return this.bookingDateComparator;
    }

    protected /* synthetic */ void _ebean_set_bookingDateComparator(FilterComparator.Date newValue) {
        this._ebean_intercept.preSetter(true, 5, (Object)this._ebean_get_bookingDateComparator(), (Object)newValue);
        this.bookingDateComparator = newValue;
    }

    protected /* synthetic */ FilterComparator.Date _ebean_getni_bookingDateComparator() {
        return this.bookingDateComparator;
    }

    protected /* synthetic */ void _ebean_setni_bookingDateComparator(FilterComparator.Date _newValue) {
        this.bookingDateComparator = _newValue;
        this._ebean_intercept.setLoadedProperty(5);
    }

    protected /* synthetic */ Date _ebean_get_valueDateFrom() {
        this._ebean_intercept.preGetter(6);
        return this.valueDateFrom;
    }

    protected /* synthetic */ void _ebean_set_valueDateFrom(Date newValue) {
        this._ebean_intercept.preSetter(true, 6, (Object)this._ebean_get_valueDateFrom(), (Object)newValue);
        this.valueDateFrom = newValue;
    }

    protected /* synthetic */ Date _ebean_getni_valueDateFrom() {
        return this.valueDateFrom;
    }

    protected /* synthetic */ void _ebean_setni_valueDateFrom(Date _newValue) {
        this.valueDateFrom = _newValue;
        this._ebean_intercept.setLoadedProperty(6);
    }

    protected /* synthetic */ Date _ebean_get_valueDateTo() {
        this._ebean_intercept.preGetter(7);
        return this.valueDateTo;
    }

    protected /* synthetic */ void _ebean_set_valueDateTo(Date newValue) {
        this._ebean_intercept.preSetter(true, 7, (Object)this._ebean_get_valueDateTo(), (Object)newValue);
        this.valueDateTo = newValue;
    }

    protected /* synthetic */ Date _ebean_getni_valueDateTo() {
        return this.valueDateTo;
    }

    protected /* synthetic */ void _ebean_setni_valueDateTo(Date _newValue) {
        this.valueDateTo = _newValue;
        this._ebean_intercept.setLoadedProperty(7);
    }

    protected /* synthetic */ FilterComparator.Date _ebean_get_valueDateComparator() {
        this._ebean_intercept.preGetter(8);
        return this.valueDateComparator;
    }

    protected /* synthetic */ void _ebean_set_valueDateComparator(FilterComparator.Date newValue) {
        this._ebean_intercept.preSetter(true, 8, (Object)this._ebean_get_valueDateComparator(), (Object)newValue);
        this.valueDateComparator = newValue;
    }

    protected /* synthetic */ FilterComparator.Date _ebean_getni_valueDateComparator() {
        return this.valueDateComparator;
    }

    protected /* synthetic */ void _ebean_setni_valueDateComparator(FilterComparator.Date _newValue) {
        this.valueDateComparator = _newValue;
        this._ebean_intercept.setLoadedProperty(8);
    }

    protected /* synthetic */ String _ebean_get_text() {
        this._ebean_intercept.preGetter(9);
        return this.text;
    }

    protected /* synthetic */ void _ebean_set_text(String newValue) {
        this._ebean_intercept.preSetter(true, 9, (Object)this._ebean_get_text(), (Object)newValue);
        this.text = newValue;
    }

    protected /* synthetic */ String _ebean_getni_text() {
        return this.text;
    }

    protected /* synthetic */ void _ebean_setni_text(String _newValue) {
        this.text = _newValue;
        this._ebean_intercept.setLoadedProperty(9);
    }

    protected /* synthetic */ FilterComparator.Text _ebean_get_textComparator() {
        this._ebean_intercept.preGetter(10);
        return this.textComparator;
    }

    protected /* synthetic */ void _ebean_set_textComparator(FilterComparator.Text newValue) {
        this._ebean_intercept.preSetter(true, 10, (Object)this._ebean_get_textComparator(), (Object)newValue);
        this.textComparator = newValue;
    }

    protected /* synthetic */ FilterComparator.Text _ebean_getni_textComparator() {
        return this.textComparator;
    }

    protected /* synthetic */ void _ebean_setni_textComparator(FilterComparator.Text _newValue) {
        this.textComparator = _newValue;
        this._ebean_intercept.setLoadedProperty(10);
    }

    protected /* synthetic */ BigDecimal _ebean_get_amountFrom() {
        this._ebean_intercept.preGetter(11);
        return this.amountFrom;
    }

    protected /* synthetic */ void _ebean_set_amountFrom(BigDecimal newValue) {
        this._ebean_intercept.preSetter(true, 11, (Object)this._ebean_get_amountFrom(), (Object)newValue);
        this.amountFrom = newValue;
    }

    protected /* synthetic */ BigDecimal _ebean_getni_amountFrom() {
        return this.amountFrom;
    }

    protected /* synthetic */ void _ebean_setni_amountFrom(BigDecimal _newValue) {
        this.amountFrom = _newValue;
        this._ebean_intercept.setLoadedProperty(11);
    }

    protected /* synthetic */ BigDecimal _ebean_get_amountTo() {
        this._ebean_intercept.preGetter(12);
        return this.amountTo;
    }

    protected /* synthetic */ void _ebean_set_amountTo(BigDecimal newValue) {
        this._ebean_intercept.preSetter(true, 12, (Object)this._ebean_get_amountTo(), (Object)newValue);
        this.amountTo = newValue;
    }

    protected /* synthetic */ BigDecimal _ebean_getni_amountTo() {
        return this.amountTo;
    }

    protected /* synthetic */ void _ebean_setni_amountTo(BigDecimal _newValue) {
        this.amountTo = _newValue;
        this._ebean_intercept.setLoadedProperty(12);
    }

    protected /* synthetic */ FilterComparator.Amount _ebean_get_amountComparator() {
        this._ebean_intercept.preGetter(13);
        return this.amountComparator;
    }

    protected /* synthetic */ void _ebean_set_amountComparator(FilterComparator.Amount newValue) {
        this._ebean_intercept.preSetter(true, 13, (Object)this._ebean_get_amountComparator(), (Object)newValue);
        this.amountComparator = newValue;
    }

    protected /* synthetic */ FilterComparator.Amount _ebean_getni_amountComparator() {
        return this.amountComparator;
    }

    protected /* synthetic */ void _ebean_setni_amountComparator(FilterComparator.Amount _newValue) {
        this.amountComparator = _newValue;
        this._ebean_intercept.setLoadedProperty(13);
    }

    protected /* synthetic */ BookingDirection _ebean_get_bookingDirection() {
        this._ebean_intercept.preGetter(14);
        return this.bookingDirection;
    }

    protected /* synthetic */ void _ebean_set_bookingDirection(BookingDirection newValue) {
        this._ebean_intercept.preSetter(true, 14, (Object)this._ebean_get_bookingDirection(), (Object)newValue);
        this.bookingDirection = newValue;
    }

    protected /* synthetic */ BookingDirection _ebean_getni_bookingDirection() {
        return this.bookingDirection;
    }

    protected /* synthetic */ void _ebean_setni_bookingDirection(BookingDirection _newValue) {
        this.bookingDirection = _newValue;
        this._ebean_intercept.setLoadedProperty(14);
    }

    protected /* synthetic */ BookingType _ebean_get_bookingType() {
        this._ebean_intercept.preGetter(15);
        return this.bookingType;
    }

    protected /* synthetic */ void _ebean_set_bookingType(BookingType newValue) {
        this._ebean_intercept.preSetter(true, 15, (Object)this._ebean_get_bookingType(), (Object)newValue);
        this.bookingType = newValue;
    }

    protected /* synthetic */ BookingType _ebean_getni_bookingType() {
        return this.bookingType;
    }

    protected /* synthetic */ void _ebean_setni_bookingType(BookingType _newValue) {
        this.bookingType = _newValue;
        this._ebean_intercept.setLoadedProperty(15);
    }

    protected /* synthetic */ String _ebean_get_bookingTypeText() {
        this._ebean_intercept.preGetter(16);
        return this.bookingTypeText;
    }

    protected /* synthetic */ void _ebean_set_bookingTypeText(String newValue) {
        this._ebean_intercept.preSetter(true, 16, (Object)this._ebean_get_bookingTypeText(), (Object)newValue);
        this.bookingTypeText = newValue;
    }

    protected /* synthetic */ String _ebean_getni_bookingTypeText() {
        return this.bookingTypeText;
    }

    protected /* synthetic */ void _ebean_setni_bookingTypeText(String _newValue) {
        this.bookingTypeText = _newValue;
        this._ebean_intercept.setLoadedProperty(16);
    }

    public /* synthetic */ Object _ebean_getField(int index) {
        switch (index) {
            case 0: {
                return this.id;
            }
            case 1: {
                return this.user;
            }
            case 2: {
                return this.filterActive;
            }
            case 3: {
                return this.bookingDateFrom;
            }
            case 4: {
                return this.bookingDateTo;
            }
            case 5: {
                return this.bookingDateComparator;
            }
            case 6: {
                return this.valueDateFrom;
            }
            case 7: {
                return this.valueDateTo;
            }
            case 8: {
                return this.valueDateComparator;
            }
            case 9: {
                return this.text;
            }
            case 10: {
                return this.textComparator;
            }
            case 11: {
                return this.amountFrom;
            }
            case 12: {
                return this.amountTo;
            }
            case 13: {
                return this.amountComparator;
            }
            case 14: {
                return this.bookingDirection;
            }
            case 15: {
                return this.bookingType;
            }
            case 16: {
                return this.bookingTypeText;
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    public /* synthetic */ Object _ebean_getFieldIntercept(int index) {
        switch (index) {
            case 0: {
                return this._ebean_get_id();
            }
            case 1: {
                return this._ebean_get_user();
            }
            case 2: {
                return this._ebean_get_filterActive();
            }
            case 3: {
                return this._ebean_get_bookingDateFrom();
            }
            case 4: {
                return this._ebean_get_bookingDateTo();
            }
            case 5: {
                return this._ebean_get_bookingDateComparator();
            }
            case 6: {
                return this._ebean_get_valueDateFrom();
            }
            case 7: {
                return this._ebean_get_valueDateTo();
            }
            case 8: {
                return this._ebean_get_valueDateComparator();
            }
            case 9: {
                return this._ebean_get_text();
            }
            case 10: {
                return this._ebean_get_textComparator();
            }
            case 11: {
                return this._ebean_get_amountFrom();
            }
            case 12: {
                return this._ebean_get_amountTo();
            }
            case 13: {
                return this._ebean_get_amountComparator();
            }
            case 14: {
                return this._ebean_get_bookingDirection();
            }
            case 15: {
                return this._ebean_get_bookingType();
            }
            case 16: {
                return this._ebean_get_bookingTypeText();
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    public /* synthetic */ void _ebean_setField(int index, Object o) {
        switch (index) {
            case 0: {
                this._ebean_setni_id((Integer)o);
                return;
            }
            case 1: {
                this._ebean_setni_user((User)o);
                return;
            }
            case 2: {
                this._ebean_setni_filterActive((Boolean)o);
                return;
            }
            case 3: {
                this._ebean_setni_bookingDateFrom((Date)o);
                return;
            }
            case 4: {
                this._ebean_setni_bookingDateTo((Date)o);
                return;
            }
            case 5: {
                this._ebean_setni_bookingDateComparator((FilterComparator.Date)((Object)o));
                return;
            }
            case 6: {
                this._ebean_setni_valueDateFrom((Date)o);
                return;
            }
            case 7: {
                this._ebean_setni_valueDateTo((Date)o);
                return;
            }
            case 8: {
                this._ebean_setni_valueDateComparator((FilterComparator.Date)((Object)o));
                return;
            }
            case 9: {
                this._ebean_setni_text((String)o);
                return;
            }
            case 10: {
                this._ebean_setni_textComparator((FilterComparator.Text)((Object)o));
                return;
            }
            case 11: {
                this._ebean_setni_amountFrom((BigDecimal)o);
                return;
            }
            case 12: {
                this._ebean_setni_amountTo((BigDecimal)o);
                return;
            }
            case 13: {
                this._ebean_setni_amountComparator((FilterComparator.Amount)((Object)o));
                return;
            }
            case 14: {
                this._ebean_setni_bookingDirection((BookingDirection)((Object)o));
                return;
            }
            case 15: {
                this._ebean_setni_bookingType((BookingType)((Object)o));
                return;
            }
            case 16: {
                this._ebean_setni_bookingTypeText((String)o);
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    public /* synthetic */ void _ebean_setFieldIntercept(int index, Object o) {
        switch (index) {
            case 0: {
                this._ebean_set_id((Integer)o);
                return;
            }
            case 1: {
                this._ebean_set_user((User)o);
                return;
            }
            case 2: {
                this._ebean_set_filterActive((Boolean)o);
                return;
            }
            case 3: {
                this._ebean_set_bookingDateFrom((Date)o);
                return;
            }
            case 4: {
                this._ebean_set_bookingDateTo((Date)o);
                return;
            }
            case 5: {
                this._ebean_set_bookingDateComparator((FilterComparator.Date)((Object)o));
                return;
            }
            case 6: {
                this._ebean_set_valueDateFrom((Date)o);
                return;
            }
            case 7: {
                this._ebean_set_valueDateTo((Date)o);
                return;
            }
            case 8: {
                this._ebean_set_valueDateComparator((FilterComparator.Date)((Object)o));
                return;
            }
            case 9: {
                this._ebean_set_text((String)o);
                return;
            }
            case 10: {
                this._ebean_set_textComparator((FilterComparator.Text)((Object)o));
                return;
            }
            case 11: {
                this._ebean_set_amountFrom((BigDecimal)o);
                return;
            }
            case 12: {
                this._ebean_set_amountTo((BigDecimal)o);
                return;
            }
            case 13: {
                this._ebean_set_amountComparator((FilterComparator.Amount)((Object)o));
                return;
            }
            case 14: {
                this._ebean_set_bookingDirection((BookingDirection)((Object)o));
                return;
            }
            case 15: {
                this._ebean_set_bookingType((BookingType)((Object)o));
                return;
            }
            case 16: {
                this._ebean_set_bookingTypeText((String)o);
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private /* synthetic */ Object _ebean_getIdentity() {
        CmBookingFilter cmBookingFilter = this;
        synchronized (cmBookingFilter) {
            if (this._ebean_identity != null) {
                return this._ebean_identity;
            }
            Object tmpId = this._ebean_getField(0);
            this._ebean_identity = tmpId != null ? tmpId : new Object();
            return this._ebean_identity;
        }
    }

    public /* synthetic */ boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        return this._ebean_getIdentity().equals(((CmBookingFilter)obj)._ebean_getIdentity());
    }

    public /* synthetic */ int hashCode() {
        return this._ebean_getIdentity().hashCode();
    }

    public /* synthetic */ void _ebean_setEmbeddedLoaded() {
    }

    public /* synthetic */ boolean _ebean_isEmbeddedNewOrDirty() {
        return false;
    }

    public /* synthetic */ Object _ebean_newInstance() {
        return new CmBookingFilter();
    }

    public static enum BookingDirection {
        ALL,
        INCOMING,
        OUTGOING;

    }

    public static enum BookingType {
        ALL,
        TRANSFER,
        DEBIT,
        RETURN_TRANSFER,
        RETURN_DEBIT,
        BOOKING_KEY,
        GVC;

    }
}

