/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.database.vo;

import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.Account;
import de.businesslogics.banking.database.vo.CmCharge;
import de.businesslogics.banking.database.vo.CmPage;
import de.businesslogics.banking.database.vo.CmStatement;
import de.businesslogics.util.Currency;
import io.ebean.Expr;
import io.ebean.Expression;
import io.ebean.Query;
import io.ebean.SqlQuery;
import io.ebean.SqlRow;
import io.ebean.SqlUpdate;
import io.ebean.annotation.Index;
import io.ebean.annotation.Indices;
import io.ebean.bean.EntityBean;
import io.ebean.bean.EntityBeanIntercept;
import io.ebean.common.BeanList;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;

@Entity
@Indices(value={@Index(name="ix_cm_booking_statement_pos", columnNames={"statement_id", "pos"}), @Index(name="ix_cm_booking_account_msg_id", columnNames={"account_id", "msg_id"})})
public class CmBooking
implements EntityBean {
    private static Logger LOGGER;
    @Id
    private Integer id;
    @ManyToOne(optional=false)
    private CmStatement statement;
    @ManyToOne
    private CmPage page;
    @ManyToOne(optional=false)
    private Account account;
    @ManyToOne
    private CmBooking parentBooking;
    private Integer pos;
    private Date bookingDate;
    private Date valueDate;
    @Column(length=140)
    private String localParty;
    @Column(length=30)
    private String localPartyBankCode;
    @Column(length=40)
    private String localPartyAccountNumber;
    @Column(length=35)
    private String localPartyCreditorId;
    @Column(length=35)
    private String localPartyMandateReference;
    @Column(length=140)
    private String ultimateLocalParty;
    @Column(length=140)
    private String counterParty;
    @Column(length=30)
    private String counterPartyBankCode;
    @Column(length=40)
    private String counterPartyAccountNumber;
    @Column(length=35)
    private String counterPartyCreditorId;
    @Column(name="counter_party_mandate_ref", length=35)
    private String counterPartyMandateReference;
    @Column(length=140)
    private String ultimateCounterParty;
    @Column(length=400)
    private String purpose;
    @Column(length=35)
    private String purposeCode;
    @Column(length=140)
    private String purposeOverview;
    @Column(length=4)
    private String sts;
    @Column(precision=38, scale=3)
    private BigDecimal amount;
    @Column(length=3)
    private String currencyCode;
    @Column(precision=38, scale=3)
    private BigDecimal originalAmount;
    @Column(length=3)
    private String originalCurrency;
    @Column(precision=38, scale=3)
    private BigDecimal settlementAmount;
    @Column(length=3)
    private String settlementCurrency;
    @Column(precision=38, scale=3)
    private BigDecimal chargesAmount;
    @Column(length=3)
    private String chargesCurrency;
    @Column(length=3)
    private String feeType;
    @Column(precision=38, scale=3)
    private BigDecimal convertedAmount;
    @Column(length=3)
    private String convertedCurrency;
    @Column(precision=38, scale=3)
    private BigDecimal exchangeRate;
    private Date exchangeRateDate;
    @Column(length=3)
    private String bookingKey;
    @Column(length=27)
    private String bookingText;
    @Column(length=3)
    private String gvc;
    @Column(length=10)
    private String primanota;
    @Column(length=3)
    private String textKeyAppendix;
    @Column(length=500)
    private String additionalInformation;
    @Column(length=35)
    private String bankReference;
    @Column(length=35)
    private String customerReference;
    private Date customerReferenceDate;
    @Column(length=35)
    private String endToEndId;
    @Column(length=35)
    private String instrId;
    @Column(length=35)
    private String pmtInfId;
    @Column(length=35)
    private String msgId;
    @Column(length=4)
    private String transactionCode;
    @Column(length=4)
    private String domainCode;
    @Column(length=4)
    private String familyCode;
    @Column(length=4)
    private String subFamilyCode;
    @Column(length=2)
    private String interbankTransactionCode;
    @Column(length=4)
    private String rejectionCauseCode;
    @Column(length=7)
    private String entryNumber;
    private Boolean exemption;
    private Boolean unavailabiltyRating;
    @Column(precision=38, scale=3)
    private BigDecimal balance;
    private Boolean collective;
    private Boolean debit;
    private Boolean reversal;
    private Boolean signedPayments;
    @Column(length=35)
    private String transactionId;
    @Column(length=35)
    private String ntryRef;
    private Integer countTransactions;
    @OneToMany
    private List<CmCharge> charges;
    public static /* synthetic */ String[] _ebean_props;
    protected /* synthetic */ EntityBeanIntercept _ebean_intercept;
    protected transient /* synthetic */ Object _ebean_identity;

    public CmBooking() {
        this._ebean_intercept = new EntityBeanIntercept((Object)this);
    }

    public static int setParentBooking(CmStatement stmt, CmBooking parent) {
        if (parent == null || stmt == null) {
            return 0;
        }
        SqlUpdate update = DB.sqlUpdate("UPDATE cm_booking SET parent_booking_id=? where statement_id=?");
        update.setParameter(1, (Object)parent.getId());
        update.setParameter(2, (Object)stmt.getId());
        return update.execute();
    }

    public static void setParentBooking(CmBooking child, CmBooking parent) {
        SqlUpdate update = DB.sqlUpdate("UPDATE cm_booking SET parent_booking_id=? where id=?");
        update.setParameter(1, (Object)parent.getId());
        update.setParameter(2, (Object)child.getId());
        update.execute();
    }

    public static CmBooking findFirstByReferenceTimeAndAmount(Set<CmStatement.Type> types, Account account, String reference, Timestamp from, Timestamp to, BigDecimal amt) {
        return (CmBooking)DB.find(CmBooking.class).where().eq("account", (Object)account).eq("amount", (Object)amt).in("statement.type", types).like("statement.reference1", "%" + reference.trim()).between("statement.creationDate", (Object)from, (Object)to).setMaxRows(1).findOne();
    }

    public static Query<CmBooking> findByStatement(CmStatement stmt, BookingSorting bookingSorting, boolean sortByPages) {
        String sorting = "page.pageNumber ASC, pos ASC";
        if (BookingSorting.CREDIT_DEBIT_VALUEDATE_AMOUNT.equals((Object)bookingSorting)) {
            sorting = sortByPages ? "page.pageNumber ASC, SIGN(amount) ASC, valueDate ASC, amount ASC, id ASC" : "SIGN(amount) ASC, valueDate ASC, amount ASC, id ASC";
        }
        if (BookingSorting.DEBIT_CREDIT_VALUEDATE_AMOUNT.equals((Object)bookingSorting)) {
            sorting = sortByPages ? "page.pageNumber ASC, SIGN(amount) DESC, valueDate ASC, amount DESC, id ASC" : "SIGN(amount) DESC, valueDate ASC, amount DESC, id ASC";
        }
        if (BookingSorting.CREDIT_DEBIT_AMOUNT.equals((Object)bookingSorting)) {
            sorting = sortByPages ? "page.pageNumber ASC, SIGN(amount) ASC, amount ASC, id ASC" : "SIGN(amount) ASC, amount ASC, id ASC";
        }
        if (BookingSorting.DEBIT_CREDIT_AMOUNT.equals((Object)bookingSorting)) {
            sorting = sortByPages ? "page.pageNumber ASC, SIGN(amount) DESC, amount DESC, id ASC" : "SIGN(amount) DESC, amount DESC, id ASC";
        }
        return DB.find(CmBooking.class).where().eq("statement", (Object)stmt).order(sorting).query();
    }

    public static int findTotalCount() {
        return DB.find(CmBooking.class).findCount();
    }

    public static int findCountByStatement(CmStatement stmt) {
        return DB.find(CmBooking.class).where().eq("statement", (Object)stmt).findCount();
    }

    public static int findCountByPage(CmPage page) {
        return DB.find(CmBooking.class).where().eq("page", (Object)page).findCount();
    }

    public static List<CmBooking> findSingleBookings(CmBooking b, boolean asc) {
        return CmBooking.findSingleBookingsQuery(b).order(asc ? "pos ASC" : "pos DESC").findList();
    }

    public static Query<CmBooking> findSingleBookingsQuery(CmBooking b) {
        return DB.find(CmBooking.class).where().eq("parentBooking", (Object)b).query();
    }

    public static List<CmBooking> findSingleBookings(CmBooking b, boolean asc, CmStatement.Type statementType) {
        return CmBooking.findSingleBookingsQuery(b, statementType).order(asc ? "pos ASC" : "pos DESC").findList();
    }

    public static Query<CmBooking> findSingleBookingsQuery(CmBooking b, CmStatement.Type statementType) {
        return DB.find(CmBooking.class).where().eq("parentBooking", (Object)b).eq("statement.type", (Object)statementType).query();
    }

    public static List<CmBooking> findSingleBookingsInSameStatement(CmBooking b, boolean asc) {
        return CmBooking.findSingleBookingsInSameStatementQuery(b).order(asc ? "pos ASC" : "pos DESC").findList();
    }

    public static Query<CmBooking> findSingleBookingsInSameStatementQuery(CmBooking b) {
        return DB.find(CmBooking.class).where().eq("parentBooking", (Object)b).eq("statement", (Object)b.getStatement()).query();
    }

    public static Query<CmBooking> findByPage(CmPage page, BookingSorting bookingSorting) {
        String sorting = "id ASC";
        if (BookingSorting.CREDIT_DEBIT_VALUEDATE_AMOUNT.equals((Object)bookingSorting)) {
            sorting = "debit ASC, valueDate ASC, amount ASC, id ASC";
        }
        if (BookingSorting.DEBIT_CREDIT_VALUEDATE_AMOUNT.equals((Object)bookingSorting)) {
            sorting = "debit DESC, valueDate ASC, amount DESC, id ASC";
        }
        return DB.find(CmBooking.class).where().eq("page", (Object)page).order(sorting).query();
    }

    public static List<CmBooking> findParentBookings(Account account, String reference, Date exactDate, Date fromDate, Date toDate) {
        if (reference != null && reference.trim().length() > 0) {
            Expression expr = Expr.like((String)"customerReference", (String)("%" + reference.trim()));
            expr = Expr.and((Expression)expr, (Expression)Expr.eq((String)"account", (Object)account));
            expr = Expr.and((Expression)expr, (Expression)Expr.in((String)"statement.type", CmStatement.StatementAndAdviceTypes));
            Expression custRefDate = Expr.and((Expression)Expr.isNotNull((String)"customerReferenceDate"), (Expression)Expr.eq((String)"customerReferenceDate", (Object)exactDate));
            Expression bookingDate = fromDate != null && toDate != null ? Expr.and((Expression)Expr.isNull((String)"customerReferenceDate"), (Expression)Expr.and((Expression)Expr.ge((String)"bookingDate", (Object)fromDate), (Expression)Expr.le((String)"bookingDate", (Object)toDate))) : Expr.and((Expression)Expr.isNull((String)"customerReferenceDate"), (Expression)Expr.eq((String)"bookingDate", (Object)exactDate));
            Expression dateExpr = Expr.or((Expression)custRefDate, (Expression)bookingDate);
            expr = Expr.and((Expression)expr, (Expression)dateExpr);
            return DB.find(CmBooking.class).where(expr).findList();
        }
        return null;
    }

    public static List<CmBooking> findByMsgId(String msgId, Account account) {
        return DB.find(CmBooking.class).where().eq("msgId", (Object)msgId).eq("account", (Object)account).findList();
    }

    public static List<CmBooking> findByMsgId(String msgId, Account account, Date oldestStatementDate, Date newestStatementDate) {
        return DB.find(CmBooking.class).where().eq("msgId", (Object)msgId).eq("account", (Object)account).ge("statement.closingDate", (Object)oldestStatementDate).le("statement.closingDate", (Object)newestStatementDate).findList();
    }

    public static List<CmStatement.Type> findChildStatementTypes(CmBooking parent) {
        SqlQuery typeQuery = DB.sqlQuery("select distinct(cm_statement.type) as statement_type from cm_statement join cm_booking on cm_statement.id = cm_booking.statement_id where cm_booking.parent_booking_id = :parent order by cm_statement.type");
        typeQuery.setParameter("parent", (Object)parent.getId());
        List list = typeQuery.findList();
        ArrayList<CmStatement.Type> types = new ArrayList<CmStatement.Type>();
        for (SqlRow row : list) {
            int statementType = row.getInteger("statement_type");
            types.add(CmStatement.Type.values()[statementType]);
        }
        return types;
    }

    public static CmStatement.Type getPreferredChildStatementType(List<CmStatement.Type> statementTypes, CmBooking parent) {
        if (statementTypes != null && statementTypes.size() > 0) {
            if (statementTypes.contains((Object)parent.getStatement().getType())) {
                return parent.getStatement().getType();
            }
            if (statementTypes.contains((Object)CmStatement.Type.CAMT054)) {
                return CmStatement.Type.CAMT054;
            }
            if (statementTypes.contains((Object)CmStatement.Type.LOGICAL_PAYMENT_FILE)) {
                return CmStatement.Type.LOGICAL_PAYMENT_FILE;
            }
            return statementTypes.get(0);
        }
        return null;
    }

    public static CmBooking findById(int id) {
        return (CmBooking)DB.find(CmBooking.class).where().eq("id", (Object)id).findOne();
    }

    public Integer getId() {
        return this._ebean_get_id();
    }

    public void setId(Integer id) {
        this._ebean_set_id(id);
    }

    public CmStatement getStatement() {
        return this._ebean_get_statement();
    }

    public void setStatement(CmStatement statement) {
        this._ebean_set_statement(statement);
    }

    public CmPage getPage() {
        return this._ebean_get_page();
    }

    public void setPage(CmPage page) {
        this._ebean_set_page(page);
    }

    public Date getBookingDate() {
        return this._ebean_get_bookingDate();
    }

    public void setBookingDate(Date bookingDate) {
        this._ebean_set_bookingDate(bookingDate);
    }

    public Date getValueDate() {
        return this._ebean_get_valueDate();
    }

    public void setValueDate(Date valueDate) {
        this._ebean_set_valueDate(valueDate);
    }

    public String getPurposeOverview() {
        return this._ebean_get_purposeOverview();
    }

    public void setPurposeOverview(String purposeOverview) {
        this._ebean_set_purposeOverview(this.shorten(purposeOverview, 140));
    }

    public String getPurpose() {
        return this._ebean_get_purpose();
    }

    public void setPurpose(String purpose) {
        this._ebean_set_purpose(this.shorten(purpose, 400));
    }

    public String getPurposeCode() {
        return this._ebean_get_purposeCode();
    }

    public void setPurposeCode(String purposeCode) {
        this._ebean_set_purposeCode(this.shorten(purposeCode, 35));
    }

    public String getSts() {
        return this._ebean_get_sts();
    }

    public void setSts(String sts) {
        this._ebean_set_sts(this.shorten(sts, 4));
    }

    public BigDecimal getAmount() {
        return this._ebean_get_amount();
    }

    public void setAmount(BigDecimal amount) {
        this._ebean_set_amount(amount);
    }

    public String getCurrencyCode() {
        return this._ebean_get_currencyCode();
    }

    public void setCurrencyCode(String currencyCode) {
        this._ebean_set_currencyCode(this.shorten(currencyCode, 3));
    }

    public Currency getCurrency() {
        return this.getCurrency(this._ebean_get_currencyCode());
    }

    public void setCurrency(Currency currency) {
        this.setCurrencyCode(currency.getCurrencyCode());
    }

    public BigDecimal getBalance() {
        return this._ebean_get_balance();
    }

    public void setBalance(BigDecimal balance) {
        this._ebean_set_balance(balance);
    }

    public Account getAccount() {
        return this._ebean_get_account();
    }

    public void setAccount(Account account) {
        this._ebean_set_account(account);
    }

    public String getLocalParty() {
        return this._ebean_get_localParty();
    }

    public String getLocalPartyFistLine() {
        return this.getFirstLine(this._ebean_get_localParty());
    }

    public void setLocalParty(String localParty) {
        this._ebean_set_localParty(this.shorten(localParty, 140));
    }

    public String getLocalPartyBankCode() {
        return this._ebean_get_localPartyBankCode();
    }

    public void setLocalPartyBankCode(String localPartyBankCode) {
        this._ebean_set_localPartyBankCode(this.shorten(localPartyBankCode, 30));
    }

    public String getLocalPartyAccountNumber() {
        return this._ebean_get_localPartyAccountNumber();
    }

    public void setLocalPartyAccountNumber(String localPartyAccountNumber) {
        this._ebean_set_localPartyAccountNumber(this.shorten(localPartyAccountNumber, 40));
    }

    public String getLocalPartyCreditorId() {
        return this._ebean_get_localPartyCreditorId();
    }

    public void setLocalPartyCreditorId(String localPartyCreditorId) {
        this._ebean_set_localPartyCreditorId(this.shorten(localPartyCreditorId, 35));
    }

    public String getLocalPartyMandateReference() {
        return this._ebean_get_localPartyMandateReference();
    }

    public void setLocalPartyMandateReference(String localPartyMandateReference) {
        this._ebean_set_localPartyMandateReference(this.shorten(localPartyMandateReference, 35));
    }

    public String getUltimateLocalParty() {
        return this._ebean_get_ultimateLocalParty();
    }

    public void setUltimateLocalParty(String ultimateLocalParty) {
        this._ebean_set_ultimateLocalParty(this.shorten(ultimateLocalParty, 140));
    }

    public String getCounterParty() {
        return this._ebean_get_counterParty();
    }

    public String getCounterPartyFirstLine() {
        return this.getFirstLine(this._ebean_get_counterParty());
    }

    public void setCounterParty(String counterParty) {
        this._ebean_set_counterParty(this.shorten(counterParty, 140));
    }

    public String getCounterPartyBankCode() {
        return this._ebean_get_counterPartyBankCode();
    }

    public void setCounterPartyBankCode(String counterPartyBankCode) {
        this._ebean_set_counterPartyBankCode(this.shorten(counterPartyBankCode, 30));
    }

    public String getCounterPartyAccountNumber() {
        return this._ebean_get_counterPartyAccountNumber();
    }

    public void setCounterPartyAccountNumber(String counterPartyAccountNumber) {
        this._ebean_set_counterPartyAccountNumber(this.shorten(counterPartyAccountNumber, 40));
    }

    public String getCounterPartyCreditorId() {
        return this._ebean_get_counterPartyCreditorId();
    }

    public void setCounterPartyCreditorId(String counterPartyCreditorId) {
        this._ebean_set_counterPartyCreditorId(this.shorten(counterPartyCreditorId, 35));
    }

    public String getCounterPartyMandateReference() {
        return this._ebean_get_counterPartyMandateReference();
    }

    public void setCounterPartyMandateReference(String counterPartyMandateReference) {
        this._ebean_set_counterPartyMandateReference(this.shorten(counterPartyMandateReference, 35));
    }

    public String getUltimateCounterParty() {
        return this._ebean_get_ultimateCounterParty();
    }

    public void setUltimateCounterParty(String ultimateCounterParty) {
        this._ebean_set_ultimateCounterParty(this.shorten(ultimateCounterParty, 140));
    }

    public BigDecimal getOriginalAmount() {
        return this._ebean_get_originalAmount();
    }

    public void setOriginalAmount(BigDecimal originalAmount) {
        this._ebean_set_originalAmount(originalAmount);
    }

    public String getOriginalCurrencyCode() {
        return this._ebean_get_originalCurrency();
    }

    public Currency getOriginalCurrency() {
        return this.getCurrency(this._ebean_get_originalCurrency());
    }

    public void setOriginalCurrency(String originalCurrency) {
        this._ebean_set_originalCurrency(this.shorten(originalCurrency, 3));
    }

    public BigDecimal getChargesAmount() {
        return this._ebean_get_chargesAmount();
    }

    public void setChargesAmount(BigDecimal chargesAmount) {
        this._ebean_set_chargesAmount(chargesAmount);
    }

    public String getChargesCurrencyCode() {
        return this._ebean_get_chargesCurrency();
    }

    public Currency getChargesCurrency() {
        return this.getCurrency(this._ebean_get_chargesCurrency());
    }

    public void setChargesCurrency(String chargesCurrency) {
        this._ebean_set_chargesCurrency(this.shorten(chargesCurrency, 3));
    }

    public String getFeeType() {
        return this._ebean_get_feeType();
    }

    public void setFeeType(String feeType) {
        this._ebean_set_feeType(this.shorten(feeType, 3));
    }

    public BigDecimal getConvertedAmount() {
        return this._ebean_get_convertedAmount();
    }

    public void setConvertedAmount(BigDecimal convertedAmount) {
        this._ebean_set_convertedAmount(convertedAmount);
    }

    public String getConvertedCurrencyCode() {
        return this._ebean_get_convertedCurrency();
    }

    public Currency getConvertedCurrency() {
        return this.getCurrency(this._ebean_get_convertedCurrency());
    }

    public void setConvertedCurrency(String convertedCurrency) {
        this._ebean_set_convertedCurrency(this.shorten(convertedCurrency, 3));
    }

    public BigDecimal getExchangeRate() {
        return this._ebean_get_exchangeRate();
    }

    public void setExchangeRate(BigDecimal exchangeRate) {
        this._ebean_set_exchangeRate(exchangeRate);
    }

    public Date getExchangeRateDate() {
        return this._ebean_get_exchangeRateDate();
    }

    public void setExchangeRateDate(Date exchangeRateDate) {
        this._ebean_set_exchangeRateDate(exchangeRateDate);
    }

    public String getBookingKey() {
        return this._ebean_get_bookingKey();
    }

    public void setBookingKey(String bookingKey) {
        this._ebean_set_bookingKey(this.shorten(bookingKey, 3));
    }

    public String getBookingText() {
        return this._ebean_get_bookingText();
    }

    public void setBookingText(String bookingText) {
        this._ebean_set_bookingText(this.shorten(bookingText, 27));
    }

    public String getGvc() {
        return this._ebean_get_gvc();
    }

    public void setGvc(String gvc) {
        this._ebean_set_gvc(this.shorten(gvc, 3));
    }

    public String getPrimanota() {
        return this._ebean_get_primanota();
    }

    public void setPrimanota(String primanota) {
        this._ebean_set_primanota(this.shorten(primanota, 10));
    }

    public String getTextKeyAppendix() {
        return this._ebean_get_textKeyAppendix();
    }

    public void setTextKeyAppendix(String textKeyAppendix) {
        this._ebean_set_textKeyAppendix(this.shorten(textKeyAppendix, 3));
    }

    public String getAdditionalInformation() {
        return this._ebean_get_additionalInformation();
    }

    public void setAdditionalInformation(String additionalInformation) {
        this._ebean_set_additionalInformation(this.shorten(additionalInformation, 500));
    }

    public String getBankReference() {
        return this._ebean_get_bankReference();
    }

    public void setBankReference(String bankReference) {
        this._ebean_set_bankReference(this.shorten(bankReference, 35));
    }

    public String getCustomerReferenceOrPmtInfId() {
        if (this._ebean_get_customerReference() != null && !this._ebean_get_customerReference().isEmpty()) {
            return this._ebean_get_customerReference();
        }
        return this._ebean_get_pmtInfId();
    }

    public String getCustomerReference() {
        return this._ebean_get_customerReference();
    }

    public void setCustomerReference(String customerReference) {
        this._ebean_set_customerReference(this.shorten(customerReference, 35));
    }

    public String getEndToEndId() {
        return this._ebean_get_endToEndId();
    }

    public void setEndToEndId(String endToEndId) {
        this._ebean_set_endToEndId(this.shorten(endToEndId, 35));
    }

    public String getInstrId() {
        return this._ebean_get_instrId();
    }

    public void setInstrId(String instrId) {
        this._ebean_set_instrId(this.shorten(instrId, 35));
    }

    public String getPmtInfId() {
        return this._ebean_get_pmtInfId();
    }

    public void setPmtInfId(String pmtInfId) {
        this._ebean_set_pmtInfId(this.shorten(pmtInfId, 35));
    }

    public String getMsgId() {
        return this._ebean_get_msgId();
    }

    public void setMsgId(String msgId) {
        this._ebean_set_msgId(this.shorten(msgId, 35));
    }

    public String getTransactionCode() {
        return this._ebean_get_transactionCode();
    }

    public void setTransactionCode(String transactionCode) {
        this._ebean_set_transactionCode(this.shorten(transactionCode, 4));
    }

    public String getDomainCode() {
        return this._ebean_get_domainCode();
    }

    public void setDomainCode(String domainCode) {
        this._ebean_set_domainCode(this.shorten(domainCode, 4));
    }

    public String getFamilyCode() {
        return this._ebean_get_familyCode();
    }

    public void setFamilyCode(String familyCode) {
        this._ebean_set_familyCode(this.shorten(familyCode, 4));
    }

    public String getSubFamilyCode() {
        return this._ebean_get_subFamilyCode();
    }

    public void setSubFamilyCode(String subFamilyCode) {
        this._ebean_set_subFamilyCode(this.shorten(subFamilyCode, 4));
    }

    public String getInterbankTransactionCode() {
        return this._ebean_get_interbankTransactionCode();
    }

    public void setInterbankTransactionCode(String interbankTransactionCode) {
        this._ebean_set_interbankTransactionCode(this.shorten(interbankTransactionCode, 2));
    }

    public String getRejectionCauseCode() {
        return this._ebean_get_rejectionCauseCode();
    }

    public void setRejectionCauseCode(String rejectionCauseCode) {
        this._ebean_set_rejectionCauseCode(this.shorten(rejectionCauseCode, 4));
    }

    public String getEntryNumber() {
        return this._ebean_get_entryNumber();
    }

    public void setEntryNumber(String entryNumber) {
        this._ebean_set_entryNumber(this.shorten(entryNumber, 7));
    }

    public Boolean getExemption() {
        return this._ebean_get_exemption();
    }

    public void setExemption(Boolean exemption) {
        this._ebean_set_exemption(exemption);
    }

    public Boolean getUnavailabiltyRating() {
        return this._ebean_get_unavailabiltyRating();
    }

    public void setUnavailabiltyRating(Boolean unavailabiltyRating) {
        this._ebean_set_unavailabiltyRating(unavailabiltyRating);
    }

    public boolean isCollective() {
        if (this._ebean_get_collective() == null) {
            return false;
        }
        return this._ebean_get_collective();
    }

    public void setCollective(boolean collective) {
        this._ebean_set_collective(collective);
    }

    public boolean isDebit() {
        if (this._ebean_get_debit() == null) {
            return false;
        }
        return this._ebean_get_debit();
    }

    public void setDebit(boolean debit) {
        this._ebean_set_debit(debit);
    }

    public boolean isReversal() {
        if (this._ebean_get_reversal() == null) {
            return false;
        }
        return this._ebean_get_reversal();
    }

    public void setReversal(boolean reversal) {
        this._ebean_set_reversal(reversal);
    }

    public boolean hasSignedPayments() {
        if (this._ebean_get_signedPayments() == null) {
            return false;
        }
        return this._ebean_get_signedPayments();
    }

    public void setSignedPayments(Boolean signedPayments) {
        this._ebean_set_signedPayments(signedPayments);
    }

    public CmBooking getParentBooking() {
        return this._ebean_get_parentBooking();
    }

    public void setParentBooking(CmBooking parentBooking) {
        this._ebean_set_parentBooking(parentBooking);
    }

    public String getCounterOrLocalParty() {
        String s = this.getCounterPartyFirstLine();
        if (s == null || s.trim().length() == 0) {
            s = this.getLocalPartyFistLine();
        }
        return s;
    }

    public String getFirstLine(String s) {
        if (s != null) {
            int i = s.indexOf(10);
            if (i < 0) {
                return s;
            }
            return s.substring(0, i);
        }
        return null;
    }

    private Currency getCurrency(String s) {
        if (s != null) {
            try {
                return Currency.getInstance(s);
            }
            catch (IllegalArgumentException illegal) {
                return null;
            }
        }
        return null;
    }

    public int getPos() {
        if (this._ebean_get_pos() == null) {
            return 0;
        }
        return this._ebean_get_pos();
    }

    public void setPos(int pos) {
        this._ebean_set_pos(pos);
    }

    public Date getCustomerReferenceDate() {
        return this._ebean_get_customerReferenceDate();
    }

    public void setCustomerReferenceDate(Date customerReferenceDate) {
        this._ebean_set_customerReferenceDate(customerReferenceDate);
    }

    public BigDecimal getSettlementAmount() {
        return this._ebean_get_settlementAmount();
    }

    public void setSettlementAmount(BigDecimal settlementAmount) {
        this._ebean_set_settlementAmount(settlementAmount);
    }

    public String getSettlementCurrencyCode() {
        return this._ebean_get_settlementCurrency();
    }

    public Currency getSettlementCurrency() {
        return this.getCurrency(this._ebean_get_settlementCurrency());
    }

    public void setSettlementCurrency(String settlementCurrency) {
        this._ebean_set_settlementCurrency(this.shorten(settlementCurrency, 3));
    }

    public String getTransactionId() {
        return this._ebean_get_transactionId();
    }

    public void setTransactionId(String transactionId) {
        this._ebean_set_transactionId(this.shorten(transactionId, 35));
    }

    public String getNtryRef() {
        return this._ebean_get_ntryRef();
    }

    public void setNtryRef(String ntryRef) {
        this._ebean_set_ntryRef(this.shorten(ntryRef, 35));
    }

    public Integer getCountTransactions() {
        return this._ebean_get_countTransactions();
    }

    public void setCountTransactions(Integer countTransactions) {
        this._ebean_set_countTransactions(countTransactions);
    }

    public List<CmCharge> getCharges() {
        return this._ebean_get_charges();
    }

    private String shorten(String in, int length) {
        if (in != null && in.length() > length) {
            StackTraceElement[] stack = new Throwable().getStackTrace();
            LOGGER.log(Level.WARNING, "Shorting the string ''{0}'' to {1,number} characters (from {2}).", new Object[]{in, length, stack[1].toString()});
            return in.substring(0, length);
        }
        return in;
    }

    static {
        _ebean_props = new String[]{"id", "statement", "page", "account", "parentBooking", "pos", "bookingDate", "valueDate", "localParty", "localPartyBankCode", "localPartyAccountNumber", "localPartyCreditorId", "localPartyMandateReference", "ultimateLocalParty", "counterParty", "counterPartyBankCode", "counterPartyAccountNumber", "counterPartyCreditorId", "counterPartyMandateReference", "ultimateCounterParty", "purpose", "purposeCode", "purposeOverview", "sts", "amount", "currencyCode", "originalAmount", "originalCurrency", "settlementAmount", "settlementCurrency", "chargesAmount", "chargesCurrency", "feeType", "convertedAmount", "convertedCurrency", "exchangeRate", "exchangeRateDate", "bookingKey", "bookingText", "gvc", "primanota", "textKeyAppendix", "additionalInformation", "bankReference", "customerReference", "customerReferenceDate", "endToEndId", "instrId", "pmtInfId", "msgId", "transactionCode", "domainCode", "familyCode", "subFamilyCode", "interbankTransactionCode", "rejectionCauseCode", "entryNumber", "exemption", "unavailabiltyRating", "balance", "collective", "debit", "reversal", "signedPayments", "transactionId", "ntryRef", "countTransactions", "charges"};
        LOGGER = Logger.getLogger(CmBooking.class.getName());
    }

    public /* synthetic */ String[] _ebean_getPropertyNames() {
        return _ebean_props;
    }

    public /* synthetic */ String _ebean_getPropertyName(int pos) {
        return _ebean_props[pos];
    }

    public /* synthetic */ EntityBeanIntercept _ebean_getIntercept() {
        return this._ebean_intercept;
    }

    public /* synthetic */ EntityBeanIntercept _ebean_intercept() {
        if (this._ebean_intercept == null) {
            this._ebean_intercept = new EntityBeanIntercept((Object)this);
        }
        return this._ebean_intercept;
    }

    protected /* synthetic */ Integer _ebean_get_id() {
        this._ebean_intercept.preGetId();
        return this.id;
    }

    protected /* synthetic */ void _ebean_set_id(Integer newValue) {
        this._ebean_intercept.preSetter(false, 0, (Object)this.id, (Object)newValue);
        this.id = newValue;
    }

    protected /* synthetic */ Integer _ebean_getni_id() {
        return this.id;
    }

    protected /* synthetic */ void _ebean_setni_id(Integer _newValue) {
        this.id = _newValue;
        this._ebean_intercept.setLoadedProperty(0);
    }

    protected /* synthetic */ CmStatement _ebean_get_statement() {
        this._ebean_intercept.preGetter(1);
        return this.statement;
    }

    protected /* synthetic */ void _ebean_set_statement(CmStatement newValue) {
        this._ebean_intercept.preSetter(true, 1, (Object)this._ebean_get_statement(), (Object)newValue);
        this.statement = newValue;
    }

    protected /* synthetic */ CmStatement _ebean_getni_statement() {
        return this.statement;
    }

    protected /* synthetic */ void _ebean_setni_statement(CmStatement _newValue) {
        this.statement = _newValue;
        this._ebean_intercept.setLoadedProperty(1);
    }

    protected /* synthetic */ CmPage _ebean_get_page() {
        this._ebean_intercept.preGetter(2);
        return this.page;
    }

    protected /* synthetic */ void _ebean_set_page(CmPage newValue) {
        this._ebean_intercept.preSetter(true, 2, (Object)this._ebean_get_page(), (Object)newValue);
        this.page = newValue;
    }

    protected /* synthetic */ CmPage _ebean_getni_page() {
        return this.page;
    }

    protected /* synthetic */ void _ebean_setni_page(CmPage _newValue) {
        this.page = _newValue;
        this._ebean_intercept.setLoadedProperty(2);
    }

    protected /* synthetic */ Account _ebean_get_account() {
        this._ebean_intercept.preGetter(3);
        return this.account;
    }

    protected /* synthetic */ void _ebean_set_account(Account newValue) {
        this._ebean_intercept.preSetter(true, 3, (Object)this._ebean_get_account(), (Object)newValue);
        this.account = newValue;
    }

    protected /* synthetic */ Account _ebean_getni_account() {
        return this.account;
    }

    protected /* synthetic */ void _ebean_setni_account(Account _newValue) {
        this.account = _newValue;
        this._ebean_intercept.setLoadedProperty(3);
    }

    protected /* synthetic */ CmBooking _ebean_get_parentBooking() {
        this._ebean_intercept.preGetter(4);
        return this.parentBooking;
    }

    protected /* synthetic */ void _ebean_set_parentBooking(CmBooking newValue) {
        this._ebean_intercept.preSetter(true, 4, (Object)this._ebean_get_parentBooking(), (Object)newValue);
        this.parentBooking = newValue;
    }

    protected /* synthetic */ CmBooking _ebean_getni_parentBooking() {
        return this.parentBooking;
    }

    protected /* synthetic */ void _ebean_setni_parentBooking(CmBooking _newValue) {
        this.parentBooking = _newValue;
        this._ebean_intercept.setLoadedProperty(4);
    }

    protected /* synthetic */ Integer _ebean_get_pos() {
        this._ebean_intercept.preGetter(5);
        return this.pos;
    }

    protected /* synthetic */ void _ebean_set_pos(Integer newValue) {
        this._ebean_intercept.preSetter(true, 5, (Object)this._ebean_get_pos(), (Object)newValue);
        this.pos = newValue;
    }

    protected /* synthetic */ Integer _ebean_getni_pos() {
        return this.pos;
    }

    protected /* synthetic */ void _ebean_setni_pos(Integer _newValue) {
        this.pos = _newValue;
        this._ebean_intercept.setLoadedProperty(5);
    }

    protected /* synthetic */ Date _ebean_get_bookingDate() {
        this._ebean_intercept.preGetter(6);
        return this.bookingDate;
    }

    protected /* synthetic */ void _ebean_set_bookingDate(Date newValue) {
        this._ebean_intercept.preSetter(true, 6, (Object)this._ebean_get_bookingDate(), (Object)newValue);
        this.bookingDate = newValue;
    }

    protected /* synthetic */ Date _ebean_getni_bookingDate() {
        return this.bookingDate;
    }

    protected /* synthetic */ void _ebean_setni_bookingDate(Date _newValue) {
        this.bookingDate = _newValue;
        this._ebean_intercept.setLoadedProperty(6);
    }

    protected /* synthetic */ Date _ebean_get_valueDate() {
        this._ebean_intercept.preGetter(7);
        return this.valueDate;
    }

    protected /* synthetic */ void _ebean_set_valueDate(Date newValue) {
        this._ebean_intercept.preSetter(true, 7, (Object)this._ebean_get_valueDate(), (Object)newValue);
        this.valueDate = newValue;
    }

    protected /* synthetic */ Date _ebean_getni_valueDate() {
        return this.valueDate;
    }

    protected /* synthetic */ void _ebean_setni_valueDate(Date _newValue) {
        this.valueDate = _newValue;
        this._ebean_intercept.setLoadedProperty(7);
    }

    protected /* synthetic */ String _ebean_get_localParty() {
        this._ebean_intercept.preGetter(8);
        return this.localParty;
    }

    protected /* synthetic */ void _ebean_set_localParty(String newValue) {
        this._ebean_intercept.preSetter(true, 8, (Object)this._ebean_get_localParty(), (Object)newValue);
        this.localParty = newValue;
    }

    protected /* synthetic */ String _ebean_getni_localParty() {
        return this.localParty;
    }

    protected /* synthetic */ void _ebean_setni_localParty(String _newValue) {
        this.localParty = _newValue;
        this._ebean_intercept.setLoadedProperty(8);
    }

    protected /* synthetic */ String _ebean_get_localPartyBankCode() {
        this._ebean_intercept.preGetter(9);
        return this.localPartyBankCode;
    }

    protected /* synthetic */ void _ebean_set_localPartyBankCode(String newValue) {
        this._ebean_intercept.preSetter(true, 9, (Object)this._ebean_get_localPartyBankCode(), (Object)newValue);
        this.localPartyBankCode = newValue;
    }

    protected /* synthetic */ String _ebean_getni_localPartyBankCode() {
        return this.localPartyBankCode;
    }

    protected /* synthetic */ void _ebean_setni_localPartyBankCode(String _newValue) {
        this.localPartyBankCode = _newValue;
        this._ebean_intercept.setLoadedProperty(9);
    }

    protected /* synthetic */ String _ebean_get_localPartyAccountNumber() {
        this._ebean_intercept.preGetter(10);
        return this.localPartyAccountNumber;
    }

    protected /* synthetic */ void _ebean_set_localPartyAccountNumber(String newValue) {
        this._ebean_intercept.preSetter(true, 10, (Object)this._ebean_get_localPartyAccountNumber(), (Object)newValue);
        this.localPartyAccountNumber = newValue;
    }

    protected /* synthetic */ String _ebean_getni_localPartyAccountNumber() {
        return this.localPartyAccountNumber;
    }

    protected /* synthetic */ void _ebean_setni_localPartyAccountNumber(String _newValue) {
        this.localPartyAccountNumber = _newValue;
        this._ebean_intercept.setLoadedProperty(10);
    }

    protected /* synthetic */ String _ebean_get_localPartyCreditorId() {
        this._ebean_intercept.preGetter(11);
        return this.localPartyCreditorId;
    }

    protected /* synthetic */ void _ebean_set_localPartyCreditorId(String newValue) {
        this._ebean_intercept.preSetter(true, 11, (Object)this._ebean_get_localPartyCreditorId(), (Object)newValue);
        this.localPartyCreditorId = newValue;
    }

    protected /* synthetic */ String _ebean_getni_localPartyCreditorId() {
        return this.localPartyCreditorId;
    }

    protected /* synthetic */ void _ebean_setni_localPartyCreditorId(String _newValue) {
        this.localPartyCreditorId = _newValue;
        this._ebean_intercept.setLoadedProperty(11);
    }

    protected /* synthetic */ String _ebean_get_localPartyMandateReference() {
        this._ebean_intercept.preGetter(12);
        return this.localPartyMandateReference;
    }

    protected /* synthetic */ void _ebean_set_localPartyMandateReference(String newValue) {
        this._ebean_intercept.preSetter(true, 12, (Object)this._ebean_get_localPartyMandateReference(), (Object)newValue);
        this.localPartyMandateReference = newValue;
    }

    protected /* synthetic */ String _ebean_getni_localPartyMandateReference() {
        return this.localPartyMandateReference;
    }

    protected /* synthetic */ void _ebean_setni_localPartyMandateReference(String _newValue) {
        this.localPartyMandateReference = _newValue;
        this._ebean_intercept.setLoadedProperty(12);
    }

    protected /* synthetic */ String _ebean_get_ultimateLocalParty() {
        this._ebean_intercept.preGetter(13);
        return this.ultimateLocalParty;
    }

    protected /* synthetic */ void _ebean_set_ultimateLocalParty(String newValue) {
        this._ebean_intercept.preSetter(true, 13, (Object)this._ebean_get_ultimateLocalParty(), (Object)newValue);
        this.ultimateLocalParty = newValue;
    }

    protected /* synthetic */ String _ebean_getni_ultimateLocalParty() {
        return this.ultimateLocalParty;
    }

    protected /* synthetic */ void _ebean_setni_ultimateLocalParty(String _newValue) {
        this.ultimateLocalParty = _newValue;
        this._ebean_intercept.setLoadedProperty(13);
    }

    protected /* synthetic */ String _ebean_get_counterParty() {
        this._ebean_intercept.preGetter(14);
        return this.counterParty;
    }

    protected /* synthetic */ void _ebean_set_counterParty(String newValue) {
        this._ebean_intercept.preSetter(true, 14, (Object)this._ebean_get_counterParty(), (Object)newValue);
        this.counterParty = newValue;
    }

    protected /* synthetic */ String _ebean_getni_counterParty() {
        return this.counterParty;
    }

    protected /* synthetic */ void _ebean_setni_counterParty(String _newValue) {
        this.counterParty = _newValue;
        this._ebean_intercept.setLoadedProperty(14);
    }

    protected /* synthetic */ String _ebean_get_counterPartyBankCode() {
        this._ebean_intercept.preGetter(15);
        return this.counterPartyBankCode;
    }

    protected /* synthetic */ void _ebean_set_counterPartyBankCode(String newValue) {
        this._ebean_intercept.preSetter(true, 15, (Object)this._ebean_get_counterPartyBankCode(), (Object)newValue);
        this.counterPartyBankCode = newValue;
    }

    protected /* synthetic */ String _ebean_getni_counterPartyBankCode() {
        return this.counterPartyBankCode;
    }

    protected /* synthetic */ void _ebean_setni_counterPartyBankCode(String _newValue) {
        this.counterPartyBankCode = _newValue;
        this._ebean_intercept.setLoadedProperty(15);
    }

    protected /* synthetic */ String _ebean_get_counterPartyAccountNumber() {
        this._ebean_intercept.preGetter(16);
        return this.counterPartyAccountNumber;
    }

    protected /* synthetic */ void _ebean_set_counterPartyAccountNumber(String newValue) {
        this._ebean_intercept.preSetter(true, 16, (Object)this._ebean_get_counterPartyAccountNumber(), (Object)newValue);
        this.counterPartyAccountNumber = newValue;
    }

    protected /* synthetic */ String _ebean_getni_counterPartyAccountNumber() {
        return this.counterPartyAccountNumber;
    }

    protected /* synthetic */ void _ebean_setni_counterPartyAccountNumber(String _newValue) {
        this.counterPartyAccountNumber = _newValue;
        this._ebean_intercept.setLoadedProperty(16);
    }

    protected /* synthetic */ String _ebean_get_counterPartyCreditorId() {
        this._ebean_intercept.preGetter(17);
        return this.counterPartyCreditorId;
    }

    protected /* synthetic */ void _ebean_set_counterPartyCreditorId(String newValue) {
        this._ebean_intercept.preSetter(true, 17, (Object)this._ebean_get_counterPartyCreditorId(), (Object)newValue);
        this.counterPartyCreditorId = newValue;
    }

    protected /* synthetic */ String _ebean_getni_counterPartyCreditorId() {
        return this.counterPartyCreditorId;
    }

    protected /* synthetic */ void _ebean_setni_counterPartyCreditorId(String _newValue) {
        this.counterPartyCreditorId = _newValue;
        this._ebean_intercept.setLoadedProperty(17);
    }

    protected /* synthetic */ String _ebean_get_counterPartyMandateReference() {
        this._ebean_intercept.preGetter(18);
        return this.counterPartyMandateReference;
    }

    protected /* synthetic */ void _ebean_set_counterPartyMandateReference(String newValue) {
        this._ebean_intercept.preSetter(true, 18, (Object)this._ebean_get_counterPartyMandateReference(), (Object)newValue);
        this.counterPartyMandateReference = newValue;
    }

    protected /* synthetic */ String _ebean_getni_counterPartyMandateReference() {
        return this.counterPartyMandateReference;
    }

    protected /* synthetic */ void _ebean_setni_counterPartyMandateReference(String _newValue) {
        this.counterPartyMandateReference = _newValue;
        this._ebean_intercept.setLoadedProperty(18);
    }

    protected /* synthetic */ String _ebean_get_ultimateCounterParty() {
        this._ebean_intercept.preGetter(19);
        return this.ultimateCounterParty;
    }

    protected /* synthetic */ void _ebean_set_ultimateCounterParty(String newValue) {
        this._ebean_intercept.preSetter(true, 19, (Object)this._ebean_get_ultimateCounterParty(), (Object)newValue);
        this.ultimateCounterParty = newValue;
    }

    protected /* synthetic */ String _ebean_getni_ultimateCounterParty() {
        return this.ultimateCounterParty;
    }

    protected /* synthetic */ void _ebean_setni_ultimateCounterParty(String _newValue) {
        this.ultimateCounterParty = _newValue;
        this._ebean_intercept.setLoadedProperty(19);
    }

    protected /* synthetic */ String _ebean_get_purpose() {
        this._ebean_intercept.preGetter(20);
        return this.purpose;
    }

    protected /* synthetic */ void _ebean_set_purpose(String newValue) {
        this._ebean_intercept.preSetter(true, 20, (Object)this._ebean_get_purpose(), (Object)newValue);
        this.purpose = newValue;
    }

    protected /* synthetic */ String _ebean_getni_purpose() {
        return this.purpose;
    }

    protected /* synthetic */ void _ebean_setni_purpose(String _newValue) {
        this.purpose = _newValue;
        this._ebean_intercept.setLoadedProperty(20);
    }

    protected /* synthetic */ String _ebean_get_purposeCode() {
        this._ebean_intercept.preGetter(21);
        return this.purposeCode;
    }

    protected /* synthetic */ void _ebean_set_purposeCode(String newValue) {
        this._ebean_intercept.preSetter(true, 21, (Object)this._ebean_get_purposeCode(), (Object)newValue);
        this.purposeCode = newValue;
    }

    protected /* synthetic */ String _ebean_getni_purposeCode() {
        return this.purposeCode;
    }

    protected /* synthetic */ void _ebean_setni_purposeCode(String _newValue) {
        this.purposeCode = _newValue;
        this._ebean_intercept.setLoadedProperty(21);
    }

    protected /* synthetic */ String _ebean_get_purposeOverview() {
        this._ebean_intercept.preGetter(22);
        return this.purposeOverview;
    }

    protected /* synthetic */ void _ebean_set_purposeOverview(String newValue) {
        this._ebean_intercept.preSetter(true, 22, (Object)this._ebean_get_purposeOverview(), (Object)newValue);
        this.purposeOverview = newValue;
    }

    protected /* synthetic */ String _ebean_getni_purposeOverview() {
        return this.purposeOverview;
    }

    protected /* synthetic */ void _ebean_setni_purposeOverview(String _newValue) {
        this.purposeOverview = _newValue;
        this._ebean_intercept.setLoadedProperty(22);
    }

    protected /* synthetic */ String _ebean_get_sts() {
        this._ebean_intercept.preGetter(23);
        return this.sts;
    }

    protected /* synthetic */ void _ebean_set_sts(String newValue) {
        this._ebean_intercept.preSetter(true, 23, (Object)this._ebean_get_sts(), (Object)newValue);
        this.sts = newValue;
    }

    protected /* synthetic */ String _ebean_getni_sts() {
        return this.sts;
    }

    protected /* synthetic */ void _ebean_setni_sts(String _newValue) {
        this.sts = _newValue;
        this._ebean_intercept.setLoadedProperty(23);
    }

    protected /* synthetic */ BigDecimal _ebean_get_amount() {
        this._ebean_intercept.preGetter(24);
        return this.amount;
    }

    protected /* synthetic */ void _ebean_set_amount(BigDecimal newValue) {
        this._ebean_intercept.preSetter(true, 24, (Object)this._ebean_get_amount(), (Object)newValue);
        this.amount = newValue;
    }

    protected /* synthetic */ BigDecimal _ebean_getni_amount() {
        return this.amount;
    }

    protected /* synthetic */ void _ebean_setni_amount(BigDecimal _newValue) {
        this.amount = _newValue;
        this._ebean_intercept.setLoadedProperty(24);
    }

    protected /* synthetic */ String _ebean_get_currencyCode() {
        this._ebean_intercept.preGetter(25);
        return this.currencyCode;
    }

    protected /* synthetic */ void _ebean_set_currencyCode(String newValue) {
        this._ebean_intercept.preSetter(true, 25, (Object)this._ebean_get_currencyCode(), (Object)newValue);
        this.currencyCode = newValue;
    }

    protected /* synthetic */ String _ebean_getni_currencyCode() {
        return this.currencyCode;
    }

    protected /* synthetic */ void _ebean_setni_currencyCode(String _newValue) {
        this.currencyCode = _newValue;
        this._ebean_intercept.setLoadedProperty(25);
    }

    protected /* synthetic */ BigDecimal _ebean_get_originalAmount() {
        this._ebean_intercept.preGetter(26);
        return this.originalAmount;
    }

    protected /* synthetic */ void _ebean_set_originalAmount(BigDecimal newValue) {
        this._ebean_intercept.preSetter(true, 26, (Object)this._ebean_get_originalAmount(), (Object)newValue);
        this.originalAmount = newValue;
    }

    protected /* synthetic */ BigDecimal _ebean_getni_originalAmount() {
        return this.originalAmount;
    }

    protected /* synthetic */ void _ebean_setni_originalAmount(BigDecimal _newValue) {
        this.originalAmount = _newValue;
        this._ebean_intercept.setLoadedProperty(26);
    }

    protected /* synthetic */ String _ebean_get_originalCurrency() {
        this._ebean_intercept.preGetter(27);
        return this.originalCurrency;
    }

    protected /* synthetic */ void _ebean_set_originalCurrency(String newValue) {
        this._ebean_intercept.preSetter(true, 27, (Object)this._ebean_get_originalCurrency(), (Object)newValue);
        this.originalCurrency = newValue;
    }

    protected /* synthetic */ String _ebean_getni_originalCurrency() {
        return this.originalCurrency;
    }

    protected /* synthetic */ void _ebean_setni_originalCurrency(String _newValue) {
        this.originalCurrency = _newValue;
        this._ebean_intercept.setLoadedProperty(27);
    }

    protected /* synthetic */ BigDecimal _ebean_get_settlementAmount() {
        this._ebean_intercept.preGetter(28);
        return this.settlementAmount;
    }

    protected /* synthetic */ void _ebean_set_settlementAmount(BigDecimal newValue) {
        this._ebean_intercept.preSetter(true, 28, (Object)this._ebean_get_settlementAmount(), (Object)newValue);
        this.settlementAmount = newValue;
    }

    protected /* synthetic */ BigDecimal _ebean_getni_settlementAmount() {
        return this.settlementAmount;
    }

    protected /* synthetic */ void _ebean_setni_settlementAmount(BigDecimal _newValue) {
        this.settlementAmount = _newValue;
        this._ebean_intercept.setLoadedProperty(28);
    }

    protected /* synthetic */ String _ebean_get_settlementCurrency() {
        this._ebean_intercept.preGetter(29);
        return this.settlementCurrency;
    }

    protected /* synthetic */ void _ebean_set_settlementCurrency(String newValue) {
        this._ebean_intercept.preSetter(true, 29, (Object)this._ebean_get_settlementCurrency(), (Object)newValue);
        this.settlementCurrency = newValue;
    }

    protected /* synthetic */ String _ebean_getni_settlementCurrency() {
        return this.settlementCurrency;
    }

    protected /* synthetic */ void _ebean_setni_settlementCurrency(String _newValue) {
        this.settlementCurrency = _newValue;
        this._ebean_intercept.setLoadedProperty(29);
    }

    protected /* synthetic */ BigDecimal _ebean_get_chargesAmount() {
        this._ebean_intercept.preGetter(30);
        return this.chargesAmount;
    }

    protected /* synthetic */ void _ebean_set_chargesAmount(BigDecimal newValue) {
        this._ebean_intercept.preSetter(true, 30, (Object)this._ebean_get_chargesAmount(), (Object)newValue);
        this.chargesAmount = newValue;
    }

    protected /* synthetic */ BigDecimal _ebean_getni_chargesAmount() {
        return this.chargesAmount;
    }

    protected /* synthetic */ void _ebean_setni_chargesAmount(BigDecimal _newValue) {
        this.chargesAmount = _newValue;
        this._ebean_intercept.setLoadedProperty(30);
    }

    protected /* synthetic */ String _ebean_get_chargesCurrency() {
        this._ebean_intercept.preGetter(31);
        return this.chargesCurrency;
    }

    protected /* synthetic */ void _ebean_set_chargesCurrency(String newValue) {
        this._ebean_intercept.preSetter(true, 31, (Object)this._ebean_get_chargesCurrency(), (Object)newValue);
        this.chargesCurrency = newValue;
    }

    protected /* synthetic */ String _ebean_getni_chargesCurrency() {
        return this.chargesCurrency;
    }

    protected /* synthetic */ void _ebean_setni_chargesCurrency(String _newValue) {
        this.chargesCurrency = _newValue;
        this._ebean_intercept.setLoadedProperty(31);
    }

    protected /* synthetic */ String _ebean_get_feeType() {
        this._ebean_intercept.preGetter(32);
        return this.feeType;
    }

    protected /* synthetic */ void _ebean_set_feeType(String newValue) {
        this._ebean_intercept.preSetter(true, 32, (Object)this._ebean_get_feeType(), (Object)newValue);
        this.feeType = newValue;
    }

    protected /* synthetic */ String _ebean_getni_feeType() {
        return this.feeType;
    }

    protected /* synthetic */ void _ebean_setni_feeType(String _newValue) {
        this.feeType = _newValue;
        this._ebean_intercept.setLoadedProperty(32);
    }

    protected /* synthetic */ BigDecimal _ebean_get_convertedAmount() {
        this._ebean_intercept.preGetter(33);
        return this.convertedAmount;
    }

    protected /* synthetic */ void _ebean_set_convertedAmount(BigDecimal newValue) {
        this._ebean_intercept.preSetter(true, 33, (Object)this._ebean_get_convertedAmount(), (Object)newValue);
        this.convertedAmount = newValue;
    }

    protected /* synthetic */ BigDecimal _ebean_getni_convertedAmount() {
        return this.convertedAmount;
    }

    protected /* synthetic */ void _ebean_setni_convertedAmount(BigDecimal _newValue) {
        this.convertedAmount = _newValue;
        this._ebean_intercept.setLoadedProperty(33);
    }

    protected /* synthetic */ String _ebean_get_convertedCurrency() {
        this._ebean_intercept.preGetter(34);
        return this.convertedCurrency;
    }

    protected /* synthetic */ void _ebean_set_convertedCurrency(String newValue) {
        this._ebean_intercept.preSetter(true, 34, (Object)this._ebean_get_convertedCurrency(), (Object)newValue);
        this.convertedCurrency = newValue;
    }

    protected /* synthetic */ String _ebean_getni_convertedCurrency() {
        return this.convertedCurrency;
    }

    protected /* synthetic */ void _ebean_setni_convertedCurrency(String _newValue) {
        this.convertedCurrency = _newValue;
        this._ebean_intercept.setLoadedProperty(34);
    }

    protected /* synthetic */ BigDecimal _ebean_get_exchangeRate() {
        this._ebean_intercept.preGetter(35);
        return this.exchangeRate;
    }

    protected /* synthetic */ void _ebean_set_exchangeRate(BigDecimal newValue) {
        this._ebean_intercept.preSetter(true, 35, (Object)this._ebean_get_exchangeRate(), (Object)newValue);
        this.exchangeRate = newValue;
    }

    protected /* synthetic */ BigDecimal _ebean_getni_exchangeRate() {
        return this.exchangeRate;
    }

    protected /* synthetic */ void _ebean_setni_exchangeRate(BigDecimal _newValue) {
        this.exchangeRate = _newValue;
        this._ebean_intercept.setLoadedProperty(35);
    }

    protected /* synthetic */ Date _ebean_get_exchangeRateDate() {
        this._ebean_intercept.preGetter(36);
        return this.exchangeRateDate;
    }

    protected /* synthetic */ void _ebean_set_exchangeRateDate(Date newValue) {
        this._ebean_intercept.preSetter(true, 36, (Object)this._ebean_get_exchangeRateDate(), (Object)newValue);
        this.exchangeRateDate = newValue;
    }

    protected /* synthetic */ Date _ebean_getni_exchangeRateDate() {
        return this.exchangeRateDate;
    }

    protected /* synthetic */ void _ebean_setni_exchangeRateDate(Date _newValue) {
        this.exchangeRateDate = _newValue;
        this._ebean_intercept.setLoadedProperty(36);
    }

    protected /* synthetic */ String _ebean_get_bookingKey() {
        this._ebean_intercept.preGetter(37);
        return this.bookingKey;
    }

    protected /* synthetic */ void _ebean_set_bookingKey(String newValue) {
        this._ebean_intercept.preSetter(true, 37, (Object)this._ebean_get_bookingKey(), (Object)newValue);
        this.bookingKey = newValue;
    }

    protected /* synthetic */ String _ebean_getni_bookingKey() {
        return this.bookingKey;
    }

    protected /* synthetic */ void _ebean_setni_bookingKey(String _newValue) {
        this.bookingKey = _newValue;
        this._ebean_intercept.setLoadedProperty(37);
    }

    protected /* synthetic */ String _ebean_get_bookingText() {
        this._ebean_intercept.preGetter(38);
        return this.bookingText;
    }

    protected /* synthetic */ void _ebean_set_bookingText(String newValue) {
        this._ebean_intercept.preSetter(true, 38, (Object)this._ebean_get_bookingText(), (Object)newValue);
        this.bookingText = newValue;
    }

    protected /* synthetic */ String _ebean_getni_bookingText() {
        return this.bookingText;
    }

    protected /* synthetic */ void _ebean_setni_bookingText(String _newValue) {
        this.bookingText = _newValue;
        this._ebean_intercept.setLoadedProperty(38);
    }

    protected /* synthetic */ String _ebean_get_gvc() {
        this._ebean_intercept.preGetter(39);
        return this.gvc;
    }

    protected /* synthetic */ void _ebean_set_gvc(String newValue) {
        this._ebean_intercept.preSetter(true, 39, (Object)this._ebean_get_gvc(), (Object)newValue);
        this.gvc = newValue;
    }

    protected /* synthetic */ String _ebean_getni_gvc() {
        return this.gvc;
    }

    protected /* synthetic */ void _ebean_setni_gvc(String _newValue) {
        this.gvc = _newValue;
        this._ebean_intercept.setLoadedProperty(39);
    }

    protected /* synthetic */ String _ebean_get_primanota() {
        this._ebean_intercept.preGetter(40);
        return this.primanota;
    }

    protected /* synthetic */ void _ebean_set_primanota(String newValue) {
        this._ebean_intercept.preSetter(true, 40, (Object)this._ebean_get_primanota(), (Object)newValue);
        this.primanota = newValue;
    }

    protected /* synthetic */ String _ebean_getni_primanota() {
        return this.primanota;
    }

    protected /* synthetic */ void _ebean_setni_primanota(String _newValue) {
        this.primanota = _newValue;
        this._ebean_intercept.setLoadedProperty(40);
    }

    protected /* synthetic */ String _ebean_get_textKeyAppendix() {
        this._ebean_intercept.preGetter(41);
        return this.textKeyAppendix;
    }

    protected /* synthetic */ void _ebean_set_textKeyAppendix(String newValue) {
        this._ebean_intercept.preSetter(true, 41, (Object)this._ebean_get_textKeyAppendix(), (Object)newValue);
        this.textKeyAppendix = newValue;
    }

    protected /* synthetic */ String _ebean_getni_textKeyAppendix() {
        return this.textKeyAppendix;
    }

    protected /* synthetic */ void _ebean_setni_textKeyAppendix(String _newValue) {
        this.textKeyAppendix = _newValue;
        this._ebean_intercept.setLoadedProperty(41);
    }

    protected /* synthetic */ String _ebean_get_additionalInformation() {
        this._ebean_intercept.preGetter(42);
        return this.additionalInformation;
    }

    protected /* synthetic */ void _ebean_set_additionalInformation(String newValue) {
        this._ebean_intercept.preSetter(true, 42, (Object)this._ebean_get_additionalInformation(), (Object)newValue);
        this.additionalInformation = newValue;
    }

    protected /* synthetic */ String _ebean_getni_additionalInformation() {
        return this.additionalInformation;
    }

    protected /* synthetic */ void _ebean_setni_additionalInformation(String _newValue) {
        this.additionalInformation = _newValue;
        this._ebean_intercept.setLoadedProperty(42);
    }

    protected /* synthetic */ String _ebean_get_bankReference() {
        this._ebean_intercept.preGetter(43);
        return this.bankReference;
    }

    protected /* synthetic */ void _ebean_set_bankReference(String newValue) {
        this._ebean_intercept.preSetter(true, 43, (Object)this._ebean_get_bankReference(), (Object)newValue);
        this.bankReference = newValue;
    }

    protected /* synthetic */ String _ebean_getni_bankReference() {
        return this.bankReference;
    }

    protected /* synthetic */ void _ebean_setni_bankReference(String _newValue) {
        this.bankReference = _newValue;
        this._ebean_intercept.setLoadedProperty(43);
    }

    protected /* synthetic */ String _ebean_get_customerReference() {
        this._ebean_intercept.preGetter(44);
        return this.customerReference;
    }

    protected /* synthetic */ void _ebean_set_customerReference(String newValue) {
        this._ebean_intercept.preSetter(true, 44, (Object)this._ebean_get_customerReference(), (Object)newValue);
        this.customerReference = newValue;
    }

    protected /* synthetic */ String _ebean_getni_customerReference() {
        return this.customerReference;
    }

    protected /* synthetic */ void _ebean_setni_customerReference(String _newValue) {
        this.customerReference = _newValue;
        this._ebean_intercept.setLoadedProperty(44);
    }

    protected /* synthetic */ Date _ebean_get_customerReferenceDate() {
        this._ebean_intercept.preGetter(45);
        return this.customerReferenceDate;
    }

    protected /* synthetic */ void _ebean_set_customerReferenceDate(Date newValue) {
        this._ebean_intercept.preSetter(true, 45, (Object)this._ebean_get_customerReferenceDate(), (Object)newValue);
        this.customerReferenceDate = newValue;
    }

    protected /* synthetic */ Date _ebean_getni_customerReferenceDate() {
        return this.customerReferenceDate;
    }

    protected /* synthetic */ void _ebean_setni_customerReferenceDate(Date _newValue) {
        this.customerReferenceDate = _newValue;
        this._ebean_intercept.setLoadedProperty(45);
    }

    protected /* synthetic */ String _ebean_get_endToEndId() {
        this._ebean_intercept.preGetter(46);
        return this.endToEndId;
    }

    protected /* synthetic */ void _ebean_set_endToEndId(String newValue) {
        this._ebean_intercept.preSetter(true, 46, (Object)this._ebean_get_endToEndId(), (Object)newValue);
        this.endToEndId = newValue;
    }

    protected /* synthetic */ String _ebean_getni_endToEndId() {
        return this.endToEndId;
    }

    protected /* synthetic */ void _ebean_setni_endToEndId(String _newValue) {
        this.endToEndId = _newValue;
        this._ebean_intercept.setLoadedProperty(46);
    }

    protected /* synthetic */ String _ebean_get_instrId() {
        this._ebean_intercept.preGetter(47);
        return this.instrId;
    }

    protected /* synthetic */ void _ebean_set_instrId(String newValue) {
        this._ebean_intercept.preSetter(true, 47, (Object)this._ebean_get_instrId(), (Object)newValue);
        this.instrId = newValue;
    }

    protected /* synthetic */ String _ebean_getni_instrId() {
        return this.instrId;
    }

    protected /* synthetic */ void _ebean_setni_instrId(String _newValue) {
        this.instrId = _newValue;
        this._ebean_intercept.setLoadedProperty(47);
    }

    protected /* synthetic */ String _ebean_get_pmtInfId() {
        this._ebean_intercept.preGetter(48);
        return this.pmtInfId;
    }

    protected /* synthetic */ void _ebean_set_pmtInfId(String newValue) {
        this._ebean_intercept.preSetter(true, 48, (Object)this._ebean_get_pmtInfId(), (Object)newValue);
        this.pmtInfId = newValue;
    }

    protected /* synthetic */ String _ebean_getni_pmtInfId() {
        return this.pmtInfId;
    }

    protected /* synthetic */ void _ebean_setni_pmtInfId(String _newValue) {
        this.pmtInfId = _newValue;
        this._ebean_intercept.setLoadedProperty(48);
    }

    protected /* synthetic */ String _ebean_get_msgId() {
        this._ebean_intercept.preGetter(49);
        return this.msgId;
    }

    protected /* synthetic */ void _ebean_set_msgId(String newValue) {
        this._ebean_intercept.preSetter(true, 49, (Object)this._ebean_get_msgId(), (Object)newValue);
        this.msgId = newValue;
    }

    protected /* synthetic */ String _ebean_getni_msgId() {
        return this.msgId;
    }

    protected /* synthetic */ void _ebean_setni_msgId(String _newValue) {
        this.msgId = _newValue;
        this._ebean_intercept.setLoadedProperty(49);
    }

    protected /* synthetic */ String _ebean_get_transactionCode() {
        this._ebean_intercept.preGetter(50);
        return this.transactionCode;
    }

    protected /* synthetic */ void _ebean_set_transactionCode(String newValue) {
        this._ebean_intercept.preSetter(true, 50, (Object)this._ebean_get_transactionCode(), (Object)newValue);
        this.transactionCode = newValue;
    }

    protected /* synthetic */ String _ebean_getni_transactionCode() {
        return this.transactionCode;
    }

    protected /* synthetic */ void _ebean_setni_transactionCode(String _newValue) {
        this.transactionCode = _newValue;
        this._ebean_intercept.setLoadedProperty(50);
    }

    protected /* synthetic */ String _ebean_get_domainCode() {
        this._ebean_intercept.preGetter(51);
        return this.domainCode;
    }

    protected /* synthetic */ void _ebean_set_domainCode(String newValue) {
        this._ebean_intercept.preSetter(true, 51, (Object)this._ebean_get_domainCode(), (Object)newValue);
        this.domainCode = newValue;
    }

    protected /* synthetic */ String _ebean_getni_domainCode() {
        return this.domainCode;
    }

    protected /* synthetic */ void _ebean_setni_domainCode(String _newValue) {
        this.domainCode = _newValue;
        this._ebean_intercept.setLoadedProperty(51);
    }

    protected /* synthetic */ String _ebean_get_familyCode() {
        this._ebean_intercept.preGetter(52);
        return this.familyCode;
    }

    protected /* synthetic */ void _ebean_set_familyCode(String newValue) {
        this._ebean_intercept.preSetter(true, 52, (Object)this._ebean_get_familyCode(), (Object)newValue);
        this.familyCode = newValue;
    }

    protected /* synthetic */ String _ebean_getni_familyCode() {
        return this.familyCode;
    }

    protected /* synthetic */ void _ebean_setni_familyCode(String _newValue) {
        this.familyCode = _newValue;
        this._ebean_intercept.setLoadedProperty(52);
    }

    protected /* synthetic */ String _ebean_get_subFamilyCode() {
        this._ebean_intercept.preGetter(53);
        return this.subFamilyCode;
    }

    protected /* synthetic */ void _ebean_set_subFamilyCode(String newValue) {
        this._ebean_intercept.preSetter(true, 53, (Object)this._ebean_get_subFamilyCode(), (Object)newValue);
        this.subFamilyCode = newValue;
    }

    protected /* synthetic */ String _ebean_getni_subFamilyCode() {
        return this.subFamilyCode;
    }

    protected /* synthetic */ void _ebean_setni_subFamilyCode(String _newValue) {
        this.subFamilyCode = _newValue;
        this._ebean_intercept.setLoadedProperty(53);
    }

    protected /* synthetic */ String _ebean_get_interbankTransactionCode() {
        this._ebean_intercept.preGetter(54);
        return this.interbankTransactionCode;
    }

    protected /* synthetic */ void _ebean_set_interbankTransactionCode(String newValue) {
        this._ebean_intercept.preSetter(true, 54, (Object)this._ebean_get_interbankTransactionCode(), (Object)newValue);
        this.interbankTransactionCode = newValue;
    }

    protected /* synthetic */ String _ebean_getni_interbankTransactionCode() {
        return this.interbankTransactionCode;
    }

    protected /* synthetic */ void _ebean_setni_interbankTransactionCode(String _newValue) {
        this.interbankTransactionCode = _newValue;
        this._ebean_intercept.setLoadedProperty(54);
    }

    protected /* synthetic */ String _ebean_get_rejectionCauseCode() {
        this._ebean_intercept.preGetter(55);
        return this.rejectionCauseCode;
    }

    protected /* synthetic */ void _ebean_set_rejectionCauseCode(String newValue) {
        this._ebean_intercept.preSetter(true, 55, (Object)this._ebean_get_rejectionCauseCode(), (Object)newValue);
        this.rejectionCauseCode = newValue;
    }

    protected /* synthetic */ String _ebean_getni_rejectionCauseCode() {
        return this.rejectionCauseCode;
    }

    protected /* synthetic */ void _ebean_setni_rejectionCauseCode(String _newValue) {
        this.rejectionCauseCode = _newValue;
        this._ebean_intercept.setLoadedProperty(55);
    }

    protected /* synthetic */ String _ebean_get_entryNumber() {
        this._ebean_intercept.preGetter(56);
        return this.entryNumber;
    }

    protected /* synthetic */ void _ebean_set_entryNumber(String newValue) {
        this._ebean_intercept.preSetter(true, 56, (Object)this._ebean_get_entryNumber(), (Object)newValue);
        this.entryNumber = newValue;
    }

    protected /* synthetic */ String _ebean_getni_entryNumber() {
        return this.entryNumber;
    }

    protected /* synthetic */ void _ebean_setni_entryNumber(String _newValue) {
        this.entryNumber = _newValue;
        this._ebean_intercept.setLoadedProperty(56);
    }

    protected /* synthetic */ Boolean _ebean_get_exemption() {
        this._ebean_intercept.preGetter(57);
        return this.exemption;
    }

    protected /* synthetic */ void _ebean_set_exemption(Boolean newValue) {
        this._ebean_intercept.preSetter(true, 57, (Object)this._ebean_get_exemption(), (Object)newValue);
        this.exemption = newValue;
    }

    protected /* synthetic */ Boolean _ebean_getni_exemption() {
        return this.exemption;
    }

    protected /* synthetic */ void _ebean_setni_exemption(Boolean _newValue) {
        this.exemption = _newValue;
        this._ebean_intercept.setLoadedProperty(57);
    }

    protected /* synthetic */ Boolean _ebean_get_unavailabiltyRating() {
        this._ebean_intercept.preGetter(58);
        return this.unavailabiltyRating;
    }

    protected /* synthetic */ void _ebean_set_unavailabiltyRating(Boolean newValue) {
        this._ebean_intercept.preSetter(true, 58, (Object)this._ebean_get_unavailabiltyRating(), (Object)newValue);
        this.unavailabiltyRating = newValue;
    }

    protected /* synthetic */ Boolean _ebean_getni_unavailabiltyRating() {
        return this.unavailabiltyRating;
    }

    protected /* synthetic */ void _ebean_setni_unavailabiltyRating(Boolean _newValue) {
        this.unavailabiltyRating = _newValue;
        this._ebean_intercept.setLoadedProperty(58);
    }

    protected /* synthetic */ BigDecimal _ebean_get_balance() {
        this._ebean_intercept.preGetter(59);
        return this.balance;
    }

    protected /* synthetic */ void _ebean_set_balance(BigDecimal newValue) {
        this._ebean_intercept.preSetter(true, 59, (Object)this._ebean_get_balance(), (Object)newValue);
        this.balance = newValue;
    }

    protected /* synthetic */ BigDecimal _ebean_getni_balance() {
        return this.balance;
    }

    protected /* synthetic */ void _ebean_setni_balance(BigDecimal _newValue) {
        this.balance = _newValue;
        this._ebean_intercept.setLoadedProperty(59);
    }

    protected /* synthetic */ Boolean _ebean_get_collective() {
        this._ebean_intercept.preGetter(60);
        return this.collective;
    }

    protected /* synthetic */ void _ebean_set_collective(Boolean newValue) {
        this._ebean_intercept.preSetter(true, 60, (Object)this._ebean_get_collective(), (Object)newValue);
        this.collective = newValue;
    }

    protected /* synthetic */ Boolean _ebean_getni_collective() {
        return this.collective;
    }

    protected /* synthetic */ void _ebean_setni_collective(Boolean _newValue) {
        this.collective = _newValue;
        this._ebean_intercept.setLoadedProperty(60);
    }

    protected /* synthetic */ Boolean _ebean_get_debit() {
        this._ebean_intercept.preGetter(61);
        return this.debit;
    }

    protected /* synthetic */ void _ebean_set_debit(Boolean newValue) {
        this._ebean_intercept.preSetter(true, 61, (Object)this._ebean_get_debit(), (Object)newValue);
        this.debit = newValue;
    }

    protected /* synthetic */ Boolean _ebean_getni_debit() {
        return this.debit;
    }

    protected /* synthetic */ void _ebean_setni_debit(Boolean _newValue) {
        this.debit = _newValue;
        this._ebean_intercept.setLoadedProperty(61);
    }

    protected /* synthetic */ Boolean _ebean_get_reversal() {
        this._ebean_intercept.preGetter(62);
        return this.reversal;
    }

    protected /* synthetic */ void _ebean_set_reversal(Boolean newValue) {
        this._ebean_intercept.preSetter(true, 62, (Object)this._ebean_get_reversal(), (Object)newValue);
        this.reversal = newValue;
    }

    protected /* synthetic */ Boolean _ebean_getni_reversal() {
        return this.reversal;
    }

    protected /* synthetic */ void _ebean_setni_reversal(Boolean _newValue) {
        this.reversal = _newValue;
        this._ebean_intercept.setLoadedProperty(62);
    }

    protected /* synthetic */ Boolean _ebean_get_signedPayments() {
        this._ebean_intercept.preGetter(63);
        return this.signedPayments;
    }

    protected /* synthetic */ void _ebean_set_signedPayments(Boolean newValue) {
        this._ebean_intercept.preSetter(true, 63, (Object)this._ebean_get_signedPayments(), (Object)newValue);
        this.signedPayments = newValue;
    }

    protected /* synthetic */ Boolean _ebean_getni_signedPayments() {
        return this.signedPayments;
    }

    protected /* synthetic */ void _ebean_setni_signedPayments(Boolean _newValue) {
        this.signedPayments = _newValue;
        this._ebean_intercept.setLoadedProperty(63);
    }

    protected /* synthetic */ String _ebean_get_transactionId() {
        this._ebean_intercept.preGetter(64);
        return this.transactionId;
    }

    protected /* synthetic */ void _ebean_set_transactionId(String newValue) {
        this._ebean_intercept.preSetter(true, 64, (Object)this._ebean_get_transactionId(), (Object)newValue);
        this.transactionId = newValue;
    }

    protected /* synthetic */ String _ebean_getni_transactionId() {
        return this.transactionId;
    }

    protected /* synthetic */ void _ebean_setni_transactionId(String _newValue) {
        this.transactionId = _newValue;
        this._ebean_intercept.setLoadedProperty(64);
    }

    protected /* synthetic */ String _ebean_get_ntryRef() {
        this._ebean_intercept.preGetter(65);
        return this.ntryRef;
    }

    protected /* synthetic */ void _ebean_set_ntryRef(String newValue) {
        this._ebean_intercept.preSetter(true, 65, (Object)this._ebean_get_ntryRef(), (Object)newValue);
        this.ntryRef = newValue;
    }

    protected /* synthetic */ String _ebean_getni_ntryRef() {
        return this.ntryRef;
    }

    protected /* synthetic */ void _ebean_setni_ntryRef(String _newValue) {
        this.ntryRef = _newValue;
        this._ebean_intercept.setLoadedProperty(65);
    }

    protected /* synthetic */ Integer _ebean_get_countTransactions() {
        this._ebean_intercept.preGetter(66);
        return this.countTransactions;
    }

    protected /* synthetic */ void _ebean_set_countTransactions(Integer newValue) {
        this._ebean_intercept.preSetter(true, 66, (Object)this._ebean_get_countTransactions(), (Object)newValue);
        this.countTransactions = newValue;
    }

    protected /* synthetic */ Integer _ebean_getni_countTransactions() {
        return this.countTransactions;
    }

    protected /* synthetic */ void _ebean_setni_countTransactions(Integer _newValue) {
        this.countTransactions = _newValue;
        this._ebean_intercept.setLoadedProperty(66);
    }

    protected /* synthetic */ List _ebean_get_charges() {
        this._ebean_intercept.preGetter(67);
        if (this.charges == null) {
            this.charges = new BeanList();
            this._ebean_intercept.initialisedMany(67);
        }
        return this.charges;
    }

    protected /* synthetic */ void _ebean_set_charges(List newValue) {
        this._ebean_intercept.preSetterMany(false, 67, this.charges, (Object)newValue);
        this.charges = newValue;
    }

    protected /* synthetic */ List _ebean_getni_charges() {
        return this.charges;
    }

    protected /* synthetic */ void _ebean_setni_charges(List _newValue) {
        this.charges = _newValue;
        this._ebean_intercept.setLoadedProperty(67);
    }

    public /* synthetic */ Object _ebean_getField(int index) {
        switch (index) {
            case 0: {
                return this.id;
            }
            case 1: {
                return this.statement;
            }
            case 2: {
                return this.page;
            }
            case 3: {
                return this.account;
            }
            case 4: {
                return this.parentBooking;
            }
            case 5: {
                return this.pos;
            }
            case 6: {
                return this.bookingDate;
            }
            case 7: {
                return this.valueDate;
            }
            case 8: {
                return this.localParty;
            }
            case 9: {
                return this.localPartyBankCode;
            }
            case 10: {
                return this.localPartyAccountNumber;
            }
            case 11: {
                return this.localPartyCreditorId;
            }
            case 12: {
                return this.localPartyMandateReference;
            }
            case 13: {
                return this.ultimateLocalParty;
            }
            case 14: {
                return this.counterParty;
            }
            case 15: {
                return this.counterPartyBankCode;
            }
            case 16: {
                return this.counterPartyAccountNumber;
            }
            case 17: {
                return this.counterPartyCreditorId;
            }
            case 18: {
                return this.counterPartyMandateReference;
            }
            case 19: {
                return this.ultimateCounterParty;
            }
            case 20: {
                return this.purpose;
            }
            case 21: {
                return this.purposeCode;
            }
            case 22: {
                return this.purposeOverview;
            }
            case 23: {
                return this.sts;
            }
            case 24: {
                return this.amount;
            }
            case 25: {
                return this.currencyCode;
            }
            case 26: {
                return this.originalAmount;
            }
            case 27: {
                return this.originalCurrency;
            }
            case 28: {
                return this.settlementAmount;
            }
            case 29: {
                return this.settlementCurrency;
            }
            case 30: {
                return this.chargesAmount;
            }
            case 31: {
                return this.chargesCurrency;
            }
            case 32: {
                return this.feeType;
            }
            case 33: {
                return this.convertedAmount;
            }
            case 34: {
                return this.convertedCurrency;
            }
            case 35: {
                return this.exchangeRate;
            }
            case 36: {
                return this.exchangeRateDate;
            }
            case 37: {
                return this.bookingKey;
            }
            case 38: {
                return this.bookingText;
            }
            case 39: {
                return this.gvc;
            }
            case 40: {
                return this.primanota;
            }
            case 41: {
                return this.textKeyAppendix;
            }
            case 42: {
                return this.additionalInformation;
            }
            case 43: {
                return this.bankReference;
            }
            case 44: {
                return this.customerReference;
            }
            case 45: {
                return this.customerReferenceDate;
            }
            case 46: {
                return this.endToEndId;
            }
            case 47: {
                return this.instrId;
            }
            case 48: {
                return this.pmtInfId;
            }
            case 49: {
                return this.msgId;
            }
            case 50: {
                return this.transactionCode;
            }
            case 51: {
                return this.domainCode;
            }
            case 52: {
                return this.familyCode;
            }
            case 53: {
                return this.subFamilyCode;
            }
            case 54: {
                return this.interbankTransactionCode;
            }
            case 55: {
                return this.rejectionCauseCode;
            }
            case 56: {
                return this.entryNumber;
            }
            case 57: {
                return this.exemption;
            }
            case 58: {
                return this.unavailabiltyRating;
            }
            case 59: {
                return this.balance;
            }
            case 60: {
                return this.collective;
            }
            case 61: {
                return this.debit;
            }
            case 62: {
                return this.reversal;
            }
            case 63: {
                return this.signedPayments;
            }
            case 64: {
                return this.transactionId;
            }
            case 65: {
                return this.ntryRef;
            }
            case 66: {
                return this.countTransactions;
            }
            case 67: {
                return this.charges;
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    public /* synthetic */ Object _ebean_getFieldIntercept(int index) {
        switch (index) {
            case 0: {
                return this._ebean_get_id();
            }
            case 1: {
                return this._ebean_get_statement();
            }
            case 2: {
                return this._ebean_get_page();
            }
            case 3: {
                return this._ebean_get_account();
            }
            case 4: {
                return this._ebean_get_parentBooking();
            }
            case 5: {
                return this._ebean_get_pos();
            }
            case 6: {
                return this._ebean_get_bookingDate();
            }
            case 7: {
                return this._ebean_get_valueDate();
            }
            case 8: {
                return this._ebean_get_localParty();
            }
            case 9: {
                return this._ebean_get_localPartyBankCode();
            }
            case 10: {
                return this._ebean_get_localPartyAccountNumber();
            }
            case 11: {
                return this._ebean_get_localPartyCreditorId();
            }
            case 12: {
                return this._ebean_get_localPartyMandateReference();
            }
            case 13: {
                return this._ebean_get_ultimateLocalParty();
            }
            case 14: {
                return this._ebean_get_counterParty();
            }
            case 15: {
                return this._ebean_get_counterPartyBankCode();
            }
            case 16: {
                return this._ebean_get_counterPartyAccountNumber();
            }
            case 17: {
                return this._ebean_get_counterPartyCreditorId();
            }
            case 18: {
                return this._ebean_get_counterPartyMandateReference();
            }
            case 19: {
                return this._ebean_get_ultimateCounterParty();
            }
            case 20: {
                return this._ebean_get_purpose();
            }
            case 21: {
                return this._ebean_get_purposeCode();
            }
            case 22: {
                return this._ebean_get_purposeOverview();
            }
            case 23: {
                return this._ebean_get_sts();
            }
            case 24: {
                return this._ebean_get_amount();
            }
            case 25: {
                return this._ebean_get_currencyCode();
            }
            case 26: {
                return this._ebean_get_originalAmount();
            }
            case 27: {
                return this._ebean_get_originalCurrency();
            }
            case 28: {
                return this._ebean_get_settlementAmount();
            }
            case 29: {
                return this._ebean_get_settlementCurrency();
            }
            case 30: {
                return this._ebean_get_chargesAmount();
            }
            case 31: {
                return this._ebean_get_chargesCurrency();
            }
            case 32: {
                return this._ebean_get_feeType();
            }
            case 33: {
                return this._ebean_get_convertedAmount();
            }
            case 34: {
                return this._ebean_get_convertedCurrency();
            }
            case 35: {
                return this._ebean_get_exchangeRate();
            }
            case 36: {
                return this._ebean_get_exchangeRateDate();
            }
            case 37: {
                return this._ebean_get_bookingKey();
            }
            case 38: {
                return this._ebean_get_bookingText();
            }
            case 39: {
                return this._ebean_get_gvc();
            }
            case 40: {
                return this._ebean_get_primanota();
            }
            case 41: {
                return this._ebean_get_textKeyAppendix();
            }
            case 42: {
                return this._ebean_get_additionalInformation();
            }
            case 43: {
                return this._ebean_get_bankReference();
            }
            case 44: {
                return this._ebean_get_customerReference();
            }
            case 45: {
                return this._ebean_get_customerReferenceDate();
            }
            case 46: {
                return this._ebean_get_endToEndId();
            }
            case 47: {
                return this._ebean_get_instrId();
            }
            case 48: {
                return this._ebean_get_pmtInfId();
            }
            case 49: {
                return this._ebean_get_msgId();
            }
            case 50: {
                return this._ebean_get_transactionCode();
            }
            case 51: {
                return this._ebean_get_domainCode();
            }
            case 52: {
                return this._ebean_get_familyCode();
            }
            case 53: {
                return this._ebean_get_subFamilyCode();
            }
            case 54: {
                return this._ebean_get_interbankTransactionCode();
            }
            case 55: {
                return this._ebean_get_rejectionCauseCode();
            }
            case 56: {
                return this._ebean_get_entryNumber();
            }
            case 57: {
                return this._ebean_get_exemption();
            }
            case 58: {
                return this._ebean_get_unavailabiltyRating();
            }
            case 59: {
                return this._ebean_get_balance();
            }
            case 60: {
                return this._ebean_get_collective();
            }
            case 61: {
                return this._ebean_get_debit();
            }
            case 62: {
                return this._ebean_get_reversal();
            }
            case 63: {
                return this._ebean_get_signedPayments();
            }
            case 64: {
                return this._ebean_get_transactionId();
            }
            case 65: {
                return this._ebean_get_ntryRef();
            }
            case 66: {
                return this._ebean_get_countTransactions();
            }
            case 67: {
                return this._ebean_get_charges();
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    public /* synthetic */ void _ebean_setField(int index, Object o) {
        switch (index) {
            case 0: {
                this._ebean_setni_id((Integer)o);
                return;
            }
            case 1: {
                this._ebean_setni_statement((CmStatement)o);
                return;
            }
            case 2: {
                this._ebean_setni_page((CmPage)o);
                return;
            }
            case 3: {
                this._ebean_setni_account((Account)o);
                return;
            }
            case 4: {
                this._ebean_setni_parentBooking((CmBooking)o);
                return;
            }
            case 5: {
                this._ebean_setni_pos((Integer)o);
                return;
            }
            case 6: {
                this._ebean_setni_bookingDate((Date)o);
                return;
            }
            case 7: {
                this._ebean_setni_valueDate((Date)o);
                return;
            }
            case 8: {
                this._ebean_setni_localParty((String)o);
                return;
            }
            case 9: {
                this._ebean_setni_localPartyBankCode((String)o);
                return;
            }
            case 10: {
                this._ebean_setni_localPartyAccountNumber((String)o);
                return;
            }
            case 11: {
                this._ebean_setni_localPartyCreditorId((String)o);
                return;
            }
            case 12: {
                this._ebean_setni_localPartyMandateReference((String)o);
                return;
            }
            case 13: {
                this._ebean_setni_ultimateLocalParty((String)o);
                return;
            }
            case 14: {
                this._ebean_setni_counterParty((String)o);
                return;
            }
            case 15: {
                this._ebean_setni_counterPartyBankCode((String)o);
                return;
            }
            case 16: {
                this._ebean_setni_counterPartyAccountNumber((String)o);
                return;
            }
            case 17: {
                this._ebean_setni_counterPartyCreditorId((String)o);
                return;
            }
            case 18: {
                this._ebean_setni_counterPartyMandateReference((String)o);
                return;
            }
            case 19: {
                this._ebean_setni_ultimateCounterParty((String)o);
                return;
            }
            case 20: {
                this._ebean_setni_purpose((String)o);
                return;
            }
            case 21: {
                this._ebean_setni_purposeCode((String)o);
                return;
            }
            case 22: {
                this._ebean_setni_purposeOverview((String)o);
                return;
            }
            case 23: {
                this._ebean_setni_sts((String)o);
                return;
            }
            case 24: {
                this._ebean_setni_amount((BigDecimal)o);
                return;
            }
            case 25: {
                this._ebean_setni_currencyCode((String)o);
                return;
            }
            case 26: {
                this._ebean_setni_originalAmount((BigDecimal)o);
                return;
            }
            case 27: {
                this._ebean_setni_originalCurrency((String)o);
                return;
            }
            case 28: {
                this._ebean_setni_settlementAmount((BigDecimal)o);
                return;
            }
            case 29: {
                this._ebean_setni_settlementCurrency((String)o);
                return;
            }
            case 30: {
                this._ebean_setni_chargesAmount((BigDecimal)o);
                return;
            }
            case 31: {
                this._ebean_setni_chargesCurrency((String)o);
                return;
            }
            case 32: {
                this._ebean_setni_feeType((String)o);
                return;
            }
            case 33: {
                this._ebean_setni_convertedAmount((BigDecimal)o);
                return;
            }
            case 34: {
                this._ebean_setni_convertedCurrency((String)o);
                return;
            }
            case 35: {
                this._ebean_setni_exchangeRate((BigDecimal)o);
                return;
            }
            case 36: {
                this._ebean_setni_exchangeRateDate((Date)o);
                return;
            }
            case 37: {
                this._ebean_setni_bookingKey((String)o);
                return;
            }
            case 38: {
                this._ebean_setni_bookingText((String)o);
                return;
            }
            case 39: {
                this._ebean_setni_gvc((String)o);
                return;
            }
            case 40: {
                this._ebean_setni_primanota((String)o);
                return;
            }
            case 41: {
                this._ebean_setni_textKeyAppendix((String)o);
                return;
            }
            case 42: {
                this._ebean_setni_additionalInformation((String)o);
                return;
            }
            case 43: {
                this._ebean_setni_bankReference((String)o);
                return;
            }
            case 44: {
                this._ebean_setni_customerReference((String)o);
                return;
            }
            case 45: {
                this._ebean_setni_customerReferenceDate((Date)o);
                return;
            }
            case 46: {
                this._ebean_setni_endToEndId((String)o);
                return;
            }
            case 47: {
                this._ebean_setni_instrId((String)o);
                return;
            }
            case 48: {
                this._ebean_setni_pmtInfId((String)o);
                return;
            }
            case 49: {
                this._ebean_setni_msgId((String)o);
                return;
            }
            case 50: {
                this._ebean_setni_transactionCode((String)o);
                return;
            }
            case 51: {
                this._ebean_setni_domainCode((String)o);
                return;
            }
            case 52: {
                this._ebean_setni_familyCode((String)o);
                return;
            }
            case 53: {
                this._ebean_setni_subFamilyCode((String)o);
                return;
            }
            case 54: {
                this._ebean_setni_interbankTransactionCode((String)o);
                return;
            }
            case 55: {
                this._ebean_setni_rejectionCauseCode((String)o);
                return;
            }
            case 56: {
                this._ebean_setni_entryNumber((String)o);
                return;
            }
            case 57: {
                this._ebean_setni_exemption((Boolean)o);
                return;
            }
            case 58: {
                this._ebean_setni_unavailabiltyRating((Boolean)o);
                return;
            }
            case 59: {
                this._ebean_setni_balance((BigDecimal)o);
                return;
            }
            case 60: {
                this._ebean_setni_collective((Boolean)o);
                return;
            }
            case 61: {
                this._ebean_setni_debit((Boolean)o);
                return;
            }
            case 62: {
                this._ebean_setni_reversal((Boolean)o);
                return;
            }
            case 63: {
                this._ebean_setni_signedPayments((Boolean)o);
                return;
            }
            case 64: {
                this._ebean_setni_transactionId((String)o);
                return;
            }
            case 65: {
                this._ebean_setni_ntryRef((String)o);
                return;
            }
            case 66: {
                this._ebean_setni_countTransactions((Integer)o);
                return;
            }
            case 67: {
                this._ebean_setni_charges((List)o);
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    public /* synthetic */ void _ebean_setFieldIntercept(int index, Object o) {
        switch (index) {
            case 0: {
                this._ebean_set_id((Integer)o);
                return;
            }
            case 1: {
                this._ebean_set_statement((CmStatement)o);
                return;
            }
            case 2: {
                this._ebean_set_page((CmPage)o);
                return;
            }
            case 3: {
                this._ebean_set_account((Account)o);
                return;
            }
            case 4: {
                this._ebean_set_parentBooking((CmBooking)o);
                return;
            }
            case 5: {
                this._ebean_set_pos((Integer)o);
                return;
            }
            case 6: {
                this._ebean_set_bookingDate((Date)o);
                return;
            }
            case 7: {
                this._ebean_set_valueDate((Date)o);
                return;
            }
            case 8: {
                this._ebean_set_localParty((String)o);
                return;
            }
            case 9: {
                this._ebean_set_localPartyBankCode((String)o);
                return;
            }
            case 10: {
                this._ebean_set_localPartyAccountNumber((String)o);
                return;
            }
            case 11: {
                this._ebean_set_localPartyCreditorId((String)o);
                return;
            }
            case 12: {
                this._ebean_set_localPartyMandateReference((String)o);
                return;
            }
            case 13: {
                this._ebean_set_ultimateLocalParty((String)o);
                return;
            }
            case 14: {
                this._ebean_set_counterParty((String)o);
                return;
            }
            case 15: {
                this._ebean_set_counterPartyBankCode((String)o);
                return;
            }
            case 16: {
                this._ebean_set_counterPartyAccountNumber((String)o);
                return;
            }
            case 17: {
                this._ebean_set_counterPartyCreditorId((String)o);
                return;
            }
            case 18: {
                this._ebean_set_counterPartyMandateReference((String)o);
                return;
            }
            case 19: {
                this._ebean_set_ultimateCounterParty((String)o);
                return;
            }
            case 20: {
                this._ebean_set_purpose((String)o);
                return;
            }
            case 21: {
                this._ebean_set_purposeCode((String)o);
                return;
            }
            case 22: {
                this._ebean_set_purposeOverview((String)o);
                return;
            }
            case 23: {
                this._ebean_set_sts((String)o);
                return;
            }
            case 24: {
                this._ebean_set_amount((BigDecimal)o);
                return;
            }
            case 25: {
                this._ebean_set_currencyCode((String)o);
                return;
            }
            case 26: {
                this._ebean_set_originalAmount((BigDecimal)o);
                return;
            }
            case 27: {
                this._ebean_set_originalCurrency((String)o);
                return;
            }
            case 28: {
                this._ebean_set_settlementAmount((BigDecimal)o);
                return;
            }
            case 29: {
                this._ebean_set_settlementCurrency((String)o);
                return;
            }
            case 30: {
                this._ebean_set_chargesAmount((BigDecimal)o);
                return;
            }
            case 31: {
                this._ebean_set_chargesCurrency((String)o);
                return;
            }
            case 32: {
                this._ebean_set_feeType((String)o);
                return;
            }
            case 33: {
                this._ebean_set_convertedAmount((BigDecimal)o);
                return;
            }
            case 34: {
                this._ebean_set_convertedCurrency((String)o);
                return;
            }
            case 35: {
                this._ebean_set_exchangeRate((BigDecimal)o);
                return;
            }
            case 36: {
                this._ebean_set_exchangeRateDate((Date)o);
                return;
            }
            case 37: {
                this._ebean_set_bookingKey((String)o);
                return;
            }
            case 38: {
                this._ebean_set_bookingText((String)o);
                return;
            }
            case 39: {
                this._ebean_set_gvc((String)o);
                return;
            }
            case 40: {
                this._ebean_set_primanota((String)o);
                return;
            }
            case 41: {
                this._ebean_set_textKeyAppendix((String)o);
                return;
            }
            case 42: {
                this._ebean_set_additionalInformation((String)o);
                return;
            }
            case 43: {
                this._ebean_set_bankReference((String)o);
                return;
            }
            case 44: {
                this._ebean_set_customerReference((String)o);
                return;
            }
            case 45: {
                this._ebean_set_customerReferenceDate((Date)o);
                return;
            }
            case 46: {
                this._ebean_set_endToEndId((String)o);
                return;
            }
            case 47: {
                this._ebean_set_instrId((String)o);
                return;
            }
            case 48: {
                this._ebean_set_pmtInfId((String)o);
                return;
            }
            case 49: {
                this._ebean_set_msgId((String)o);
                return;
            }
            case 50: {
                this._ebean_set_transactionCode((String)o);
                return;
            }
            case 51: {
                this._ebean_set_domainCode((String)o);
                return;
            }
            case 52: {
                this._ebean_set_familyCode((String)o);
                return;
            }
            case 53: {
                this._ebean_set_subFamilyCode((String)o);
                return;
            }
            case 54: {
                this._ebean_set_interbankTransactionCode((String)o);
                return;
            }
            case 55: {
                this._ebean_set_rejectionCauseCode((String)o);
                return;
            }
            case 56: {
                this._ebean_set_entryNumber((String)o);
                return;
            }
            case 57: {
                this._ebean_set_exemption((Boolean)o);
                return;
            }
            case 58: {
                this._ebean_set_unavailabiltyRating((Boolean)o);
                return;
            }
            case 59: {
                this._ebean_set_balance((BigDecimal)o);
                return;
            }
            case 60: {
                this._ebean_set_collective((Boolean)o);
                return;
            }
            case 61: {
                this._ebean_set_debit((Boolean)o);
                return;
            }
            case 62: {
                this._ebean_set_reversal((Boolean)o);
                return;
            }
            case 63: {
                this._ebean_set_signedPayments((Boolean)o);
                return;
            }
            case 64: {
                this._ebean_set_transactionId((String)o);
                return;
            }
            case 65: {
                this._ebean_set_ntryRef((String)o);
                return;
            }
            case 66: {
                this._ebean_set_countTransactions((Integer)o);
                return;
            }
            case 67: {
                this._ebean_set_charges((List)o);
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private /* synthetic */ Object _ebean_getIdentity() {
        CmBooking cmBooking = this;
        synchronized (cmBooking) {
            if (this._ebean_identity != null) {
                return this._ebean_identity;
            }
            Object tmpId = this._ebean_getField(0);
            this._ebean_identity = tmpId != null ? tmpId : new Object();
            return this._ebean_identity;
        }
    }

    public /* synthetic */ boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        return this._ebean_getIdentity().equals(((CmBooking)obj)._ebean_getIdentity());
    }

    public /* synthetic */ int hashCode() {
        return this._ebean_getIdentity().hashCode();
    }

    public /* synthetic */ void _ebean_setEmbeddedLoaded() {
    }

    public /* synthetic */ boolean _ebean_isEmbeddedNewOrDirty() {
        return false;
    }

    public /* synthetic */ Object _ebean_newInstance() {
        return new CmBooking();
    }

    public static enum BookingSorting {
        UNMODIFIED,
        CREDIT_DEBIT_VALUEDATE_AMOUNT,
        DEBIT_CREDIT_VALUEDATE_AMOUNT,
        CREDIT_DEBIT_AMOUNT,
        DEBIT_CREDIT_AMOUNT;

    }
}

