/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.database.vo;

import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.BankSettings;
import io.ebean.Update;
import io.ebean.bean.EntityBean;
import io.ebean.bean.EntityBeanIntercept;
import java.sql.Date;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.OneToOne;

@Entity
public class CmBank
implements EntityBean {
    @Id
    private Integer id;
    @OneToOne
    private BankSettings bank;
    private boolean statementsActivated;
    private boolean adviceActivated;
    private boolean creditAdviceActivated;
    private boolean bkaActivated;
    private boolean bkiActivated;
    @Column(name="c54_activated")
    private boolean c54Activated;
    private boolean cumulativeAdviceProvision;
    private boolean multidaysAdviceRepeated;
    private String statementFormat;
    private String adviceFormat;
    private String statementFetchType;
    private String adviceFetchType;
    private String creditAdviceFetchType;
    private String bkaFetchType;
    private String bkiFetchType;
    @Column(name="c54_fetch_type")
    private String c54FetchType;
    private Date lastStaFetch;
    private Date lastVmkFetch;
    private Date lastCreditAdviceFetch;
    private Date lastBkaFetch;
    private Date lastBkiFetch;
    @Column(name="last_c54_fetch")
    private Date lastC54Fetch;
    private FetchMode staFetchMode;
    private FetchMode vmkFetchMode;
    private FetchMode cavFetchMode;
    private FetchMode bkaFetchMode;
    private FetchMode bkiFetchMode;
    @Column(name="c54_fetch_mode")
    private FetchMode c54FetchMode;
    private boolean vbCalculationWithCav;
    private boolean vbCalculationWithPav;
    public static /* synthetic */ String[] _ebean_props;
    protected /* synthetic */ EntityBeanIntercept _ebean_intercept;
    protected transient /* synthetic */ Object _ebean_identity;

    public CmBank() {
        this._ebean_intercept = new EntityBeanIntercept((Object)this);
        this._ebean_set_statementsActivated(true);
        this._ebean_set_adviceActivated(true);
        this._ebean_set_creditAdviceActivated(true);
        this._ebean_set_bkaActivated(true);
        this._ebean_set_bkiActivated(true);
        this._ebean_set_c54Activated(true);
        this._ebean_set_cumulativeAdviceProvision(false);
        this._ebean_set_multidaysAdviceRepeated(false);
        this._ebean_set_vbCalculationWithCav(true);
        this._ebean_set_vbCalculationWithPav(true);
    }

    public static CmBank get(BankSettings bank) {
        return (CmBank)DB.find(CmBank.class).where().eq("bank", (Object)bank).findOne();
    }

    public static int deleteAll(BankSettings bank) {
        Update<CmBank> deleteCmBank = DB.createUpdate(CmBank.class, "DELETE FROM CmBank WHERE bank=:bank");
        deleteCmBank.setParameter("bank", (Object)bank.getBankId());
        return deleteCmBank.execute();
    }

    public Integer getId() {
        return this._ebean_get_id();
    }

    public void setId(Integer id) {
        this._ebean_set_id(id);
    }

    public boolean isStatementsActivated() {
        return this._ebean_get_statementsActivated();
    }

    public void setStatementsActivated(boolean statementsActivated) {
        this._ebean_set_statementsActivated(statementsActivated);
    }

    public boolean isAdviceActivated() {
        return this._ebean_get_adviceActivated();
    }

    public void setAdviceActivated(boolean adviceActivated) {
        this._ebean_set_adviceActivated(adviceActivated);
    }

    public boolean isCreditAdviceActivated() {
        return this._ebean_get_creditAdviceActivated();
    }

    public void setCreditAdviceActivated(boolean creditAdviceActivated) {
        this._ebean_set_creditAdviceActivated(creditAdviceActivated);
    }

    public boolean isBkaActivated() {
        return this._ebean_get_bkaActivated();
    }

    public void setBkaActivated(boolean bkaActivated) {
        this._ebean_set_bkaActivated(bkaActivated);
    }

    public boolean isBkiActivated() {
        return this._ebean_get_bkiActivated();
    }

    public void setBkiActivated(boolean bkiActivated) {
        this._ebean_set_bkiActivated(bkiActivated);
    }

    public boolean isC54Activated() {
        return this._ebean_get_c54Activated();
    }

    public void setC54Activated(boolean c54Activated) {
        this._ebean_set_c54Activated(c54Activated);
    }

    public boolean isCumulativeAdviceProvision() {
        return this._ebean_get_cumulativeAdviceProvision();
    }

    public void setCumulativeAdviceProvision(boolean cumulativeAdviceProvision) {
        this._ebean_set_cumulativeAdviceProvision(cumulativeAdviceProvision);
    }

    public boolean vbCalculationWithCreditAdvices() {
        return this._ebean_get_vbCalculationWithCav();
    }

    public void setVbCalculationWithCreditAdvices(boolean vbCalculationWithCreditAdvices) {
        this._ebean_set_vbCalculationWithCav(vbCalculationWithCreditAdvices);
    }

    public boolean vbCalculationWithPendingAdvices() {
        return this._ebean_get_vbCalculationWithPav();
    }

    public void setVbCalculationWithPendingAdvices(boolean vbCalculationWithPendingAdvices) {
        this._ebean_set_vbCalculationWithPav(vbCalculationWithPendingAdvices);
    }

    public String getStatementFormat() {
        return this._ebean_get_statementFormat();
    }

    public void setStatementFormat(String statementFormat) {
        this._ebean_set_statementFormat(statementFormat);
    }

    public String getAdviceFormat() {
        return this._ebean_get_adviceFormat();
    }

    public void setAdviceFormat(String adviceFormat) {
        this._ebean_set_adviceFormat(adviceFormat);
    }

    public String getStatementFetchType() {
        return this._ebean_get_statementFetchType();
    }

    public void setStatementFetchType(String statementFetchType) {
        this._ebean_set_statementFetchType(statementFetchType);
    }

    public String getAdviceFetchType() {
        return this._ebean_get_adviceFetchType();
    }

    public void setAdviceFetchType(String adviceFetchType) {
        this._ebean_set_adviceFetchType(adviceFetchType);
    }

    public String getCreditAdviceFetchType() {
        return this._ebean_get_creditAdviceFetchType();
    }

    public void setCreditAdviceFetchType(String creditAdviceFetchType) {
        this._ebean_set_creditAdviceFetchType(creditAdviceFetchType);
    }

    public String getBkaFetchType() {
        return this._ebean_get_bkaFetchType();
    }

    public void setBkaFetchType(String bkaFetchType) {
        this._ebean_set_bkaFetchType(bkaFetchType);
    }

    public String getBkiFetchType() {
        return this._ebean_get_bkiFetchType();
    }

    public void setBkiFetchType(String bkiFetchType) {
        this._ebean_set_bkiFetchType(bkiFetchType);
    }

    public String getC54FetchType() {
        return this._ebean_get_c54FetchType();
    }

    public void setC54FetchType(String c54FetchType) {
        this._ebean_set_c54FetchType(c54FetchType);
    }

    public BankSettings getBank() {
        return this._ebean_get_bank();
    }

    public void setBank(BankSettings bank) {
        this._ebean_set_bank(bank);
    }

    public Date getLastStaFetch() {
        return this._ebean_get_lastStaFetch();
    }

    public void setLastStaFetch(Date lastStaFetch) {
        this._ebean_set_lastStaFetch(lastStaFetch);
    }

    public Date getLastVmkFetch() {
        return this._ebean_get_lastVmkFetch();
    }

    public void setLastVmkFetch(Date lastVmkFetch) {
        this._ebean_set_lastVmkFetch(lastVmkFetch);
    }

    public Date getLastCreditAdviceFetch() {
        return this._ebean_get_lastCreditAdviceFetch();
    }

    public void setLastCreditAdviceFetch(Date lastCreditAdviceFetch) {
        this._ebean_set_lastCreditAdviceFetch(lastCreditAdviceFetch);
    }

    public Date getLastBkaFetch() {
        return this._ebean_get_lastBkaFetch();
    }

    public void setLastBkaFetch(Date lastBkaFetch) {
        this._ebean_set_lastBkaFetch(lastBkaFetch);
    }

    public Date getLastBkiFetch() {
        return this._ebean_get_lastBkiFetch();
    }

    public void setLastBkiFetch(Date lastBkiFetch) {
        this._ebean_set_lastBkiFetch(lastBkiFetch);
    }

    public Date getLastC54Fetch() {
        return this._ebean_get_lastC54Fetch();
    }

    public void setLastC54Fetch(Date lastC54Fetch) {
        this._ebean_set_lastC54Fetch(lastC54Fetch);
    }

    public FetchMode getStaFetchMode() {
        return this._ebean_get_staFetchMode();
    }

    public void setStaFetchMode(FetchMode staFetchMode) {
        this._ebean_set_staFetchMode(staFetchMode);
    }

    public FetchMode getVmkFetchMode() {
        return this._ebean_get_vmkFetchMode();
    }

    public void setVmkFetchMode(FetchMode vmkFetchMode) {
        this._ebean_set_vmkFetchMode(vmkFetchMode);
    }

    public FetchMode getCreditAdviceFetchMode() {
        return this._ebean_get_cavFetchMode();
    }

    public void setCreditAdviceFetchMode(FetchMode creditAdviceFetchMode) {
        this._ebean_set_cavFetchMode(creditAdviceFetchMode);
    }

    public FetchMode getBkaFetchMode() {
        return this._ebean_get_bkaFetchMode();
    }

    public void setBkaFetchMode(FetchMode bkaFetchMode) {
        this._ebean_set_bkaFetchMode(bkaFetchMode);
    }

    public FetchMode getBkiFetchMode() {
        return this._ebean_get_bkiFetchMode();
    }

    public void setBkiFetchMode(FetchMode bkiFetchMode) {
        this._ebean_set_bkiFetchMode(bkiFetchMode);
    }

    public FetchMode getC54FetchMode() {
        return this._ebean_get_c54FetchMode();
    }

    public void setC54FetchMode(FetchMode c54FetchMode) {
        this._ebean_set_c54FetchMode(c54FetchMode);
    }

    public boolean isMultidaysAdviceRepeated() {
        return this._ebean_get_multidaysAdviceRepeated();
    }

    public void setMultidaysAdviceRepeated(boolean multidaysAdviceRepeated) {
        this._ebean_set_multidaysAdviceRepeated(multidaysAdviceRepeated);
    }

    public static Set<BankSettings> findBanksWithStatementFormat(String statementFormat) {
        HashSet<BankSettings> banks = new HashSet<BankSettings>();
        for (CmBank cmBank : DB.find(CmBank.class).where().eq("statementFormat", (Object)statementFormat).findList()) {
            banks.add(cmBank.getBank());
        }
        return banks;
    }

    static {
        _ebean_props = new String[]{"id", "bank", "statementsActivated", "adviceActivated", "creditAdviceActivated", "bkaActivated", "bkiActivated", "c54Activated", "cumulativeAdviceProvision", "multidaysAdviceRepeated", "statementFormat", "adviceFormat", "statementFetchType", "adviceFetchType", "creditAdviceFetchType", "bkaFetchType", "bkiFetchType", "c54FetchType", "lastStaFetch", "lastVmkFetch", "lastCreditAdviceFetch", "lastBkaFetch", "lastBkiFetch", "lastC54Fetch", "staFetchMode", "vmkFetchMode", "cavFetchMode", "bkaFetchMode", "bkiFetchMode", "c54FetchMode", "vbCalculationWithCav", "vbCalculationWithPav"};
    }

    public /* synthetic */ String[] _ebean_getPropertyNames() {
        return _ebean_props;
    }

    public /* synthetic */ String _ebean_getPropertyName(int pos) {
        return _ebean_props[pos];
    }

    public /* synthetic */ EntityBeanIntercept _ebean_getIntercept() {
        return this._ebean_intercept;
    }

    public /* synthetic */ EntityBeanIntercept _ebean_intercept() {
        if (this._ebean_intercept == null) {
            this._ebean_intercept = new EntityBeanIntercept((Object)this);
        }
        return this._ebean_intercept;
    }

    protected /* synthetic */ Integer _ebean_get_id() {
        this._ebean_intercept.preGetId();
        return this.id;
    }

    protected /* synthetic */ void _ebean_set_id(Integer newValue) {
        this._ebean_intercept.preSetter(false, 0, (Object)this.id, (Object)newValue);
        this.id = newValue;
    }

    protected /* synthetic */ Integer _ebean_getni_id() {
        return this.id;
    }

    protected /* synthetic */ void _ebean_setni_id(Integer _newValue) {
        this.id = _newValue;
        this._ebean_intercept.setLoadedProperty(0);
    }

    protected /* synthetic */ BankSettings _ebean_get_bank() {
        this._ebean_intercept.preGetter(1);
        return this.bank;
    }

    protected /* synthetic */ void _ebean_set_bank(BankSettings newValue) {
        this._ebean_intercept.preSetter(true, 1, (Object)this._ebean_get_bank(), (Object)newValue);
        this.bank = newValue;
    }

    protected /* synthetic */ BankSettings _ebean_getni_bank() {
        return this.bank;
    }

    protected /* synthetic */ void _ebean_setni_bank(BankSettings _newValue) {
        this.bank = _newValue;
        this._ebean_intercept.setLoadedProperty(1);
    }

    protected /* synthetic */ boolean _ebean_get_statementsActivated() {
        this._ebean_intercept.preGetter(2);
        return this.statementsActivated;
    }

    protected /* synthetic */ void _ebean_set_statementsActivated(boolean newValue) {
        this._ebean_intercept.preSetter(true, 2, this._ebean_get_statementsActivated(), newValue);
        this.statementsActivated = newValue;
    }

    protected /* synthetic */ boolean _ebean_getni_statementsActivated() {
        return this.statementsActivated;
    }

    protected /* synthetic */ void _ebean_setni_statementsActivated(boolean _newValue) {
        this.statementsActivated = _newValue;
        this._ebean_intercept.setLoadedProperty(2);
    }

    protected /* synthetic */ boolean _ebean_get_adviceActivated() {
        this._ebean_intercept.preGetter(3);
        return this.adviceActivated;
    }

    protected /* synthetic */ void _ebean_set_adviceActivated(boolean newValue) {
        this._ebean_intercept.preSetter(true, 3, this._ebean_get_adviceActivated(), newValue);
        this.adviceActivated = newValue;
    }

    protected /* synthetic */ boolean _ebean_getni_adviceActivated() {
        return this.adviceActivated;
    }

    protected /* synthetic */ void _ebean_setni_adviceActivated(boolean _newValue) {
        this.adviceActivated = _newValue;
        this._ebean_intercept.setLoadedProperty(3);
    }

    protected /* synthetic */ boolean _ebean_get_creditAdviceActivated() {
        this._ebean_intercept.preGetter(4);
        return this.creditAdviceActivated;
    }

    protected /* synthetic */ void _ebean_set_creditAdviceActivated(boolean newValue) {
        this._ebean_intercept.preSetter(true, 4, this._ebean_get_creditAdviceActivated(), newValue);
        this.creditAdviceActivated = newValue;
    }

    protected /* synthetic */ boolean _ebean_getni_creditAdviceActivated() {
        return this.creditAdviceActivated;
    }

    protected /* synthetic */ void _ebean_setni_creditAdviceActivated(boolean _newValue) {
        this.creditAdviceActivated = _newValue;
        this._ebean_intercept.setLoadedProperty(4);
    }

    protected /* synthetic */ boolean _ebean_get_bkaActivated() {
        this._ebean_intercept.preGetter(5);
        return this.bkaActivated;
    }

    protected /* synthetic */ void _ebean_set_bkaActivated(boolean newValue) {
        this._ebean_intercept.preSetter(true, 5, this._ebean_get_bkaActivated(), newValue);
        this.bkaActivated = newValue;
    }

    protected /* synthetic */ boolean _ebean_getni_bkaActivated() {
        return this.bkaActivated;
    }

    protected /* synthetic */ void _ebean_setni_bkaActivated(boolean _newValue) {
        this.bkaActivated = _newValue;
        this._ebean_intercept.setLoadedProperty(5);
    }

    protected /* synthetic */ boolean _ebean_get_bkiActivated() {
        this._ebean_intercept.preGetter(6);
        return this.bkiActivated;
    }

    protected /* synthetic */ void _ebean_set_bkiActivated(boolean newValue) {
        this._ebean_intercept.preSetter(true, 6, this._ebean_get_bkiActivated(), newValue);
        this.bkiActivated = newValue;
    }

    protected /* synthetic */ boolean _ebean_getni_bkiActivated() {
        return this.bkiActivated;
    }

    protected /* synthetic */ void _ebean_setni_bkiActivated(boolean _newValue) {
        this.bkiActivated = _newValue;
        this._ebean_intercept.setLoadedProperty(6);
    }

    protected /* synthetic */ boolean _ebean_get_c54Activated() {
        this._ebean_intercept.preGetter(7);
        return this.c54Activated;
    }

    protected /* synthetic */ void _ebean_set_c54Activated(boolean newValue) {
        this._ebean_intercept.preSetter(true, 7, this._ebean_get_c54Activated(), newValue);
        this.c54Activated = newValue;
    }

    protected /* synthetic */ boolean _ebean_getni_c54Activated() {
        return this.c54Activated;
    }

    protected /* synthetic */ void _ebean_setni_c54Activated(boolean _newValue) {
        this.c54Activated = _newValue;
        this._ebean_intercept.setLoadedProperty(7);
    }

    protected /* synthetic */ boolean _ebean_get_cumulativeAdviceProvision() {
        this._ebean_intercept.preGetter(8);
        return this.cumulativeAdviceProvision;
    }

    protected /* synthetic */ void _ebean_set_cumulativeAdviceProvision(boolean newValue) {
        this._ebean_intercept.preSetter(true, 8, this._ebean_get_cumulativeAdviceProvision(), newValue);
        this.cumulativeAdviceProvision = newValue;
    }

    protected /* synthetic */ boolean _ebean_getni_cumulativeAdviceProvision() {
        return this.cumulativeAdviceProvision;
    }

    protected /* synthetic */ void _ebean_setni_cumulativeAdviceProvision(boolean _newValue) {
        this.cumulativeAdviceProvision = _newValue;
        this._ebean_intercept.setLoadedProperty(8);
    }

    protected /* synthetic */ boolean _ebean_get_multidaysAdviceRepeated() {
        this._ebean_intercept.preGetter(9);
        return this.multidaysAdviceRepeated;
    }

    protected /* synthetic */ void _ebean_set_multidaysAdviceRepeated(boolean newValue) {
        this._ebean_intercept.preSetter(true, 9, this._ebean_get_multidaysAdviceRepeated(), newValue);
        this.multidaysAdviceRepeated = newValue;
    }

    protected /* synthetic */ boolean _ebean_getni_multidaysAdviceRepeated() {
        return this.multidaysAdviceRepeated;
    }

    protected /* synthetic */ void _ebean_setni_multidaysAdviceRepeated(boolean _newValue) {
        this.multidaysAdviceRepeated = _newValue;
        this._ebean_intercept.setLoadedProperty(9);
    }

    protected /* synthetic */ String _ebean_get_statementFormat() {
        this._ebean_intercept.preGetter(10);
        return this.statementFormat;
    }

    protected /* synthetic */ void _ebean_set_statementFormat(String newValue) {
        this._ebean_intercept.preSetter(true, 10, (Object)this._ebean_get_statementFormat(), (Object)newValue);
        this.statementFormat = newValue;
    }

    protected /* synthetic */ String _ebean_getni_statementFormat() {
        return this.statementFormat;
    }

    protected /* synthetic */ void _ebean_setni_statementFormat(String _newValue) {
        this.statementFormat = _newValue;
        this._ebean_intercept.setLoadedProperty(10);
    }

    protected /* synthetic */ String _ebean_get_adviceFormat() {
        this._ebean_intercept.preGetter(11);
        return this.adviceFormat;
    }

    protected /* synthetic */ void _ebean_set_adviceFormat(String newValue) {
        this._ebean_intercept.preSetter(true, 11, (Object)this._ebean_get_adviceFormat(), (Object)newValue);
        this.adviceFormat = newValue;
    }

    protected /* synthetic */ String _ebean_getni_adviceFormat() {
        return this.adviceFormat;
    }

    protected /* synthetic */ void _ebean_setni_adviceFormat(String _newValue) {
        this.adviceFormat = _newValue;
        this._ebean_intercept.setLoadedProperty(11);
    }

    protected /* synthetic */ String _ebean_get_statementFetchType() {
        this._ebean_intercept.preGetter(12);
        return this.statementFetchType;
    }

    protected /* synthetic */ void _ebean_set_statementFetchType(String newValue) {
        this._ebean_intercept.preSetter(true, 12, (Object)this._ebean_get_statementFetchType(), (Object)newValue);
        this.statementFetchType = newValue;
    }

    protected /* synthetic */ String _ebean_getni_statementFetchType() {
        return this.statementFetchType;
    }

    protected /* synthetic */ void _ebean_setni_statementFetchType(String _newValue) {
        this.statementFetchType = _newValue;
        this._ebean_intercept.setLoadedProperty(12);
    }

    protected /* synthetic */ String _ebean_get_adviceFetchType() {
        this._ebean_intercept.preGetter(13);
        return this.adviceFetchType;
    }

    protected /* synthetic */ void _ebean_set_adviceFetchType(String newValue) {
        this._ebean_intercept.preSetter(true, 13, (Object)this._ebean_get_adviceFetchType(), (Object)newValue);
        this.adviceFetchType = newValue;
    }

    protected /* synthetic */ String _ebean_getni_adviceFetchType() {
        return this.adviceFetchType;
    }

    protected /* synthetic */ void _ebean_setni_adviceFetchType(String _newValue) {
        this.adviceFetchType = _newValue;
        this._ebean_intercept.setLoadedProperty(13);
    }

    protected /* synthetic */ String _ebean_get_creditAdviceFetchType() {
        this._ebean_intercept.preGetter(14);
        return this.creditAdviceFetchType;
    }

    protected /* synthetic */ void _ebean_set_creditAdviceFetchType(String newValue) {
        this._ebean_intercept.preSetter(true, 14, (Object)this._ebean_get_creditAdviceFetchType(), (Object)newValue);
        this.creditAdviceFetchType = newValue;
    }

    protected /* synthetic */ String _ebean_getni_creditAdviceFetchType() {
        return this.creditAdviceFetchType;
    }

    protected /* synthetic */ void _ebean_setni_creditAdviceFetchType(String _newValue) {
        this.creditAdviceFetchType = _newValue;
        this._ebean_intercept.setLoadedProperty(14);
    }

    protected /* synthetic */ String _ebean_get_bkaFetchType() {
        this._ebean_intercept.preGetter(15);
        return this.bkaFetchType;
    }

    protected /* synthetic */ void _ebean_set_bkaFetchType(String newValue) {
        this._ebean_intercept.preSetter(true, 15, (Object)this._ebean_get_bkaFetchType(), (Object)newValue);
        this.bkaFetchType = newValue;
    }

    protected /* synthetic */ String _ebean_getni_bkaFetchType() {
        return this.bkaFetchType;
    }

    protected /* synthetic */ void _ebean_setni_bkaFetchType(String _newValue) {
        this.bkaFetchType = _newValue;
        this._ebean_intercept.setLoadedProperty(15);
    }

    protected /* synthetic */ String _ebean_get_bkiFetchType() {
        this._ebean_intercept.preGetter(16);
        return this.bkiFetchType;
    }

    protected /* synthetic */ void _ebean_set_bkiFetchType(String newValue) {
        this._ebean_intercept.preSetter(true, 16, (Object)this._ebean_get_bkiFetchType(), (Object)newValue);
        this.bkiFetchType = newValue;
    }

    protected /* synthetic */ String _ebean_getni_bkiFetchType() {
        return this.bkiFetchType;
    }

    protected /* synthetic */ void _ebean_setni_bkiFetchType(String _newValue) {
        this.bkiFetchType = _newValue;
        this._ebean_intercept.setLoadedProperty(16);
    }

    protected /* synthetic */ String _ebean_get_c54FetchType() {
        this._ebean_intercept.preGetter(17);
        return this.c54FetchType;
    }

    protected /* synthetic */ void _ebean_set_c54FetchType(String newValue) {
        this._ebean_intercept.preSetter(true, 17, (Object)this._ebean_get_c54FetchType(), (Object)newValue);
        this.c54FetchType = newValue;
    }

    protected /* synthetic */ String _ebean_getni_c54FetchType() {
        return this.c54FetchType;
    }

    protected /* synthetic */ void _ebean_setni_c54FetchType(String _newValue) {
        this.c54FetchType = _newValue;
        this._ebean_intercept.setLoadedProperty(17);
    }

    protected /* synthetic */ Date _ebean_get_lastStaFetch() {
        this._ebean_intercept.preGetter(18);
        return this.lastStaFetch;
    }

    protected /* synthetic */ void _ebean_set_lastStaFetch(Date newValue) {
        this._ebean_intercept.preSetter(true, 18, (Object)this._ebean_get_lastStaFetch(), (Object)newValue);
        this.lastStaFetch = newValue;
    }

    protected /* synthetic */ Date _ebean_getni_lastStaFetch() {
        return this.lastStaFetch;
    }

    protected /* synthetic */ void _ebean_setni_lastStaFetch(Date _newValue) {
        this.lastStaFetch = _newValue;
        this._ebean_intercept.setLoadedProperty(18);
    }

    protected /* synthetic */ Date _ebean_get_lastVmkFetch() {
        this._ebean_intercept.preGetter(19);
        return this.lastVmkFetch;
    }

    protected /* synthetic */ void _ebean_set_lastVmkFetch(Date newValue) {
        this._ebean_intercept.preSetter(true, 19, (Object)this._ebean_get_lastVmkFetch(), (Object)newValue);
        this.lastVmkFetch = newValue;
    }

    protected /* synthetic */ Date _ebean_getni_lastVmkFetch() {
        return this.lastVmkFetch;
    }

    protected /* synthetic */ void _ebean_setni_lastVmkFetch(Date _newValue) {
        this.lastVmkFetch = _newValue;
        this._ebean_intercept.setLoadedProperty(19);
    }

    protected /* synthetic */ Date _ebean_get_lastCreditAdviceFetch() {
        this._ebean_intercept.preGetter(20);
        return this.lastCreditAdviceFetch;
    }

    protected /* synthetic */ void _ebean_set_lastCreditAdviceFetch(Date newValue) {
        this._ebean_intercept.preSetter(true, 20, (Object)this._ebean_get_lastCreditAdviceFetch(), (Object)newValue);
        this.lastCreditAdviceFetch = newValue;
    }

    protected /* synthetic */ Date _ebean_getni_lastCreditAdviceFetch() {
        return this.lastCreditAdviceFetch;
    }

    protected /* synthetic */ void _ebean_setni_lastCreditAdviceFetch(Date _newValue) {
        this.lastCreditAdviceFetch = _newValue;
        this._ebean_intercept.setLoadedProperty(20);
    }

    protected /* synthetic */ Date _ebean_get_lastBkaFetch() {
        this._ebean_intercept.preGetter(21);
        return this.lastBkaFetch;
    }

    protected /* synthetic */ void _ebean_set_lastBkaFetch(Date newValue) {
        this._ebean_intercept.preSetter(true, 21, (Object)this._ebean_get_lastBkaFetch(), (Object)newValue);
        this.lastBkaFetch = newValue;
    }

    protected /* synthetic */ Date _ebean_getni_lastBkaFetch() {
        return this.lastBkaFetch;
    }

    protected /* synthetic */ void _ebean_setni_lastBkaFetch(Date _newValue) {
        this.lastBkaFetch = _newValue;
        this._ebean_intercept.setLoadedProperty(21);
    }

    protected /* synthetic */ Date _ebean_get_lastBkiFetch() {
        this._ebean_intercept.preGetter(22);
        return this.lastBkiFetch;
    }

    protected /* synthetic */ void _ebean_set_lastBkiFetch(Date newValue) {
        this._ebean_intercept.preSetter(true, 22, (Object)this._ebean_get_lastBkiFetch(), (Object)newValue);
        this.lastBkiFetch = newValue;
    }

    protected /* synthetic */ Date _ebean_getni_lastBkiFetch() {
        return this.lastBkiFetch;
    }

    protected /* synthetic */ void _ebean_setni_lastBkiFetch(Date _newValue) {
        this.lastBkiFetch = _newValue;
        this._ebean_intercept.setLoadedProperty(22);
    }

    protected /* synthetic */ Date _ebean_get_lastC54Fetch() {
        this._ebean_intercept.preGetter(23);
        return this.lastC54Fetch;
    }

    protected /* synthetic */ void _ebean_set_lastC54Fetch(Date newValue) {
        this._ebean_intercept.preSetter(true, 23, (Object)this._ebean_get_lastC54Fetch(), (Object)newValue);
        this.lastC54Fetch = newValue;
    }

    protected /* synthetic */ Date _ebean_getni_lastC54Fetch() {
        return this.lastC54Fetch;
    }

    protected /* synthetic */ void _ebean_setni_lastC54Fetch(Date _newValue) {
        this.lastC54Fetch = _newValue;
        this._ebean_intercept.setLoadedProperty(23);
    }

    protected /* synthetic */ FetchMode _ebean_get_staFetchMode() {
        this._ebean_intercept.preGetter(24);
        return this.staFetchMode;
    }

    protected /* synthetic */ void _ebean_set_staFetchMode(FetchMode newValue) {
        this._ebean_intercept.preSetter(true, 24, (Object)this._ebean_get_staFetchMode(), (Object)newValue);
        this.staFetchMode = newValue;
    }

    protected /* synthetic */ FetchMode _ebean_getni_staFetchMode() {
        return this.staFetchMode;
    }

    protected /* synthetic */ void _ebean_setni_staFetchMode(FetchMode _newValue) {
        this.staFetchMode = _newValue;
        this._ebean_intercept.setLoadedProperty(24);
    }

    protected /* synthetic */ FetchMode _ebean_get_vmkFetchMode() {
        this._ebean_intercept.preGetter(25);
        return this.vmkFetchMode;
    }

    protected /* synthetic */ void _ebean_set_vmkFetchMode(FetchMode newValue) {
        this._ebean_intercept.preSetter(true, 25, (Object)this._ebean_get_vmkFetchMode(), (Object)newValue);
        this.vmkFetchMode = newValue;
    }

    protected /* synthetic */ FetchMode _ebean_getni_vmkFetchMode() {
        return this.vmkFetchMode;
    }

    protected /* synthetic */ void _ebean_setni_vmkFetchMode(FetchMode _newValue) {
        this.vmkFetchMode = _newValue;
        this._ebean_intercept.setLoadedProperty(25);
    }

    protected /* synthetic */ FetchMode _ebean_get_cavFetchMode() {
        this._ebean_intercept.preGetter(26);
        return this.cavFetchMode;
    }

    protected /* synthetic */ void _ebean_set_cavFetchMode(FetchMode newValue) {
        this._ebean_intercept.preSetter(true, 26, (Object)this._ebean_get_cavFetchMode(), (Object)newValue);
        this.cavFetchMode = newValue;
    }

    protected /* synthetic */ FetchMode _ebean_getni_cavFetchMode() {
        return this.cavFetchMode;
    }

    protected /* synthetic */ void _ebean_setni_cavFetchMode(FetchMode _newValue) {
        this.cavFetchMode = _newValue;
        this._ebean_intercept.setLoadedProperty(26);
    }

    protected /* synthetic */ FetchMode _ebean_get_bkaFetchMode() {
        this._ebean_intercept.preGetter(27);
        return this.bkaFetchMode;
    }

    protected /* synthetic */ void _ebean_set_bkaFetchMode(FetchMode newValue) {
        this._ebean_intercept.preSetter(true, 27, (Object)this._ebean_get_bkaFetchMode(), (Object)newValue);
        this.bkaFetchMode = newValue;
    }

    protected /* synthetic */ FetchMode _ebean_getni_bkaFetchMode() {
        return this.bkaFetchMode;
    }

    protected /* synthetic */ void _ebean_setni_bkaFetchMode(FetchMode _newValue) {
        this.bkaFetchMode = _newValue;
        this._ebean_intercept.setLoadedProperty(27);
    }

    protected /* synthetic */ FetchMode _ebean_get_bkiFetchMode() {
        this._ebean_intercept.preGetter(28);
        return this.bkiFetchMode;
    }

    protected /* synthetic */ void _ebean_set_bkiFetchMode(FetchMode newValue) {
        this._ebean_intercept.preSetter(true, 28, (Object)this._ebean_get_bkiFetchMode(), (Object)newValue);
        this.bkiFetchMode = newValue;
    }

    protected /* synthetic */ FetchMode _ebean_getni_bkiFetchMode() {
        return this.bkiFetchMode;
    }

    protected /* synthetic */ void _ebean_setni_bkiFetchMode(FetchMode _newValue) {
        this.bkiFetchMode = _newValue;
        this._ebean_intercept.setLoadedProperty(28);
    }

    protected /* synthetic */ FetchMode _ebean_get_c54FetchMode() {
        this._ebean_intercept.preGetter(29);
        return this.c54FetchMode;
    }

    protected /* synthetic */ void _ebean_set_c54FetchMode(FetchMode newValue) {
        this._ebean_intercept.preSetter(true, 29, (Object)this._ebean_get_c54FetchMode(), (Object)newValue);
        this.c54FetchMode = newValue;
    }

    protected /* synthetic */ FetchMode _ebean_getni_c54FetchMode() {
        return this.c54FetchMode;
    }

    protected /* synthetic */ void _ebean_setni_c54FetchMode(FetchMode _newValue) {
        this.c54FetchMode = _newValue;
        this._ebean_intercept.setLoadedProperty(29);
    }

    protected /* synthetic */ boolean _ebean_get_vbCalculationWithCav() {
        this._ebean_intercept.preGetter(30);
        return this.vbCalculationWithCav;
    }

    protected /* synthetic */ void _ebean_set_vbCalculationWithCav(boolean newValue) {
        this._ebean_intercept.preSetter(true, 30, this._ebean_get_vbCalculationWithCav(), newValue);
        this.vbCalculationWithCav = newValue;
    }

    protected /* synthetic */ boolean _ebean_getni_vbCalculationWithCav() {
        return this.vbCalculationWithCav;
    }

    protected /* synthetic */ void _ebean_setni_vbCalculationWithCav(boolean _newValue) {
        this.vbCalculationWithCav = _newValue;
        this._ebean_intercept.setLoadedProperty(30);
    }

    protected /* synthetic */ boolean _ebean_get_vbCalculationWithPav() {
        this._ebean_intercept.preGetter(31);
        return this.vbCalculationWithPav;
    }

    protected /* synthetic */ void _ebean_set_vbCalculationWithPav(boolean newValue) {
        this._ebean_intercept.preSetter(true, 31, this._ebean_get_vbCalculationWithPav(), newValue);
        this.vbCalculationWithPav = newValue;
    }

    protected /* synthetic */ boolean _ebean_getni_vbCalculationWithPav() {
        return this.vbCalculationWithPav;
    }

    protected /* synthetic */ void _ebean_setni_vbCalculationWithPav(boolean _newValue) {
        this.vbCalculationWithPav = _newValue;
        this._ebean_intercept.setLoadedProperty(31);
    }

    public /* synthetic */ Object _ebean_getField(int index) {
        switch (index) {
            case 0: {
                return this.id;
            }
            case 1: {
                return this.bank;
            }
            case 2: {
                return this.statementsActivated;
            }
            case 3: {
                return this.adviceActivated;
            }
            case 4: {
                return this.creditAdviceActivated;
            }
            case 5: {
                return this.bkaActivated;
            }
            case 6: {
                return this.bkiActivated;
            }
            case 7: {
                return this.c54Activated;
            }
            case 8: {
                return this.cumulativeAdviceProvision;
            }
            case 9: {
                return this.multidaysAdviceRepeated;
            }
            case 10: {
                return this.statementFormat;
            }
            case 11: {
                return this.adviceFormat;
            }
            case 12: {
                return this.statementFetchType;
            }
            case 13: {
                return this.adviceFetchType;
            }
            case 14: {
                return this.creditAdviceFetchType;
            }
            case 15: {
                return this.bkaFetchType;
            }
            case 16: {
                return this.bkiFetchType;
            }
            case 17: {
                return this.c54FetchType;
            }
            case 18: {
                return this.lastStaFetch;
            }
            case 19: {
                return this.lastVmkFetch;
            }
            case 20: {
                return this.lastCreditAdviceFetch;
            }
            case 21: {
                return this.lastBkaFetch;
            }
            case 22: {
                return this.lastBkiFetch;
            }
            case 23: {
                return this.lastC54Fetch;
            }
            case 24: {
                return this.staFetchMode;
            }
            case 25: {
                return this.vmkFetchMode;
            }
            case 26: {
                return this.cavFetchMode;
            }
            case 27: {
                return this.bkaFetchMode;
            }
            case 28: {
                return this.bkiFetchMode;
            }
            case 29: {
                return this.c54FetchMode;
            }
            case 30: {
                return this.vbCalculationWithCav;
            }
            case 31: {
                return this.vbCalculationWithPav;
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    public /* synthetic */ Object _ebean_getFieldIntercept(int index) {
        switch (index) {
            case 0: {
                return this._ebean_get_id();
            }
            case 1: {
                return this._ebean_get_bank();
            }
            case 2: {
                return this._ebean_get_statementsActivated();
            }
            case 3: {
                return this._ebean_get_adviceActivated();
            }
            case 4: {
                return this._ebean_get_creditAdviceActivated();
            }
            case 5: {
                return this._ebean_get_bkaActivated();
            }
            case 6: {
                return this._ebean_get_bkiActivated();
            }
            case 7: {
                return this._ebean_get_c54Activated();
            }
            case 8: {
                return this._ebean_get_cumulativeAdviceProvision();
            }
            case 9: {
                return this._ebean_get_multidaysAdviceRepeated();
            }
            case 10: {
                return this._ebean_get_statementFormat();
            }
            case 11: {
                return this._ebean_get_adviceFormat();
            }
            case 12: {
                return this._ebean_get_statementFetchType();
            }
            case 13: {
                return this._ebean_get_adviceFetchType();
            }
            case 14: {
                return this._ebean_get_creditAdviceFetchType();
            }
            case 15: {
                return this._ebean_get_bkaFetchType();
            }
            case 16: {
                return this._ebean_get_bkiFetchType();
            }
            case 17: {
                return this._ebean_get_c54FetchType();
            }
            case 18: {
                return this._ebean_get_lastStaFetch();
            }
            case 19: {
                return this._ebean_get_lastVmkFetch();
            }
            case 20: {
                return this._ebean_get_lastCreditAdviceFetch();
            }
            case 21: {
                return this._ebean_get_lastBkaFetch();
            }
            case 22: {
                return this._ebean_get_lastBkiFetch();
            }
            case 23: {
                return this._ebean_get_lastC54Fetch();
            }
            case 24: {
                return this._ebean_get_staFetchMode();
            }
            case 25: {
                return this._ebean_get_vmkFetchMode();
            }
            case 26: {
                return this._ebean_get_cavFetchMode();
            }
            case 27: {
                return this._ebean_get_bkaFetchMode();
            }
            case 28: {
                return this._ebean_get_bkiFetchMode();
            }
            case 29: {
                return this._ebean_get_c54FetchMode();
            }
            case 30: {
                return this._ebean_get_vbCalculationWithCav();
            }
            case 31: {
                return this._ebean_get_vbCalculationWithPav();
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    public /* synthetic */ void _ebean_setField(int index, Object o) {
        switch (index) {
            case 0: {
                this._ebean_setni_id((Integer)o);
                return;
            }
            case 1: {
                this._ebean_setni_bank((BankSettings)o);
                return;
            }
            case 2: {
                this._ebean_setni_statementsActivated((Boolean)o);
                return;
            }
            case 3: {
                this._ebean_setni_adviceActivated((Boolean)o);
                return;
            }
            case 4: {
                this._ebean_setni_creditAdviceActivated((Boolean)o);
                return;
            }
            case 5: {
                this._ebean_setni_bkaActivated((Boolean)o);
                return;
            }
            case 6: {
                this._ebean_setni_bkiActivated((Boolean)o);
                return;
            }
            case 7: {
                this._ebean_setni_c54Activated((Boolean)o);
                return;
            }
            case 8: {
                this._ebean_setni_cumulativeAdviceProvision((Boolean)o);
                return;
            }
            case 9: {
                this._ebean_setni_multidaysAdviceRepeated((Boolean)o);
                return;
            }
            case 10: {
                this._ebean_setni_statementFormat((String)o);
                return;
            }
            case 11: {
                this._ebean_setni_adviceFormat((String)o);
                return;
            }
            case 12: {
                this._ebean_setni_statementFetchType((String)o);
                return;
            }
            case 13: {
                this._ebean_setni_adviceFetchType((String)o);
                return;
            }
            case 14: {
                this._ebean_setni_creditAdviceFetchType((String)o);
                return;
            }
            case 15: {
                this._ebean_setni_bkaFetchType((String)o);
                return;
            }
            case 16: {
                this._ebean_setni_bkiFetchType((String)o);
                return;
            }
            case 17: {
                this._ebean_setni_c54FetchType((String)o);
                return;
            }
            case 18: {
                this._ebean_setni_lastStaFetch((Date)o);
                return;
            }
            case 19: {
                this._ebean_setni_lastVmkFetch((Date)o);
                return;
            }
            case 20: {
                this._ebean_setni_lastCreditAdviceFetch((Date)o);
                return;
            }
            case 21: {
                this._ebean_setni_lastBkaFetch((Date)o);
                return;
            }
            case 22: {
                this._ebean_setni_lastBkiFetch((Date)o);
                return;
            }
            case 23: {
                this._ebean_setni_lastC54Fetch((Date)o);
                return;
            }
            case 24: {
                this._ebean_setni_staFetchMode((FetchMode)((Object)o));
                return;
            }
            case 25: {
                this._ebean_setni_vmkFetchMode((FetchMode)((Object)o));
                return;
            }
            case 26: {
                this._ebean_setni_cavFetchMode((FetchMode)((Object)o));
                return;
            }
            case 27: {
                this._ebean_setni_bkaFetchMode((FetchMode)((Object)o));
                return;
            }
            case 28: {
                this._ebean_setni_bkiFetchMode((FetchMode)((Object)o));
                return;
            }
            case 29: {
                this._ebean_setni_c54FetchMode((FetchMode)((Object)o));
                return;
            }
            case 30: {
                this._ebean_setni_vbCalculationWithCav((Boolean)o);
                return;
            }
            case 31: {
                this._ebean_setni_vbCalculationWithPav((Boolean)o);
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    public /* synthetic */ void _ebean_setFieldIntercept(int index, Object o) {
        switch (index) {
            case 0: {
                this._ebean_set_id((Integer)o);
                return;
            }
            case 1: {
                this._ebean_set_bank((BankSettings)o);
                return;
            }
            case 2: {
                this._ebean_set_statementsActivated((Boolean)o);
                return;
            }
            case 3: {
                this._ebean_set_adviceActivated((Boolean)o);
                return;
            }
            case 4: {
                this._ebean_set_creditAdviceActivated((Boolean)o);
                return;
            }
            case 5: {
                this._ebean_set_bkaActivated((Boolean)o);
                return;
            }
            case 6: {
                this._ebean_set_bkiActivated((Boolean)o);
                return;
            }
            case 7: {
                this._ebean_set_c54Activated((Boolean)o);
                return;
            }
            case 8: {
                this._ebean_set_cumulativeAdviceProvision((Boolean)o);
                return;
            }
            case 9: {
                this._ebean_set_multidaysAdviceRepeated((Boolean)o);
                return;
            }
            case 10: {
                this._ebean_set_statementFormat((String)o);
                return;
            }
            case 11: {
                this._ebean_set_adviceFormat((String)o);
                return;
            }
            case 12: {
                this._ebean_set_statementFetchType((String)o);
                return;
            }
            case 13: {
                this._ebean_set_adviceFetchType((String)o);
                return;
            }
            case 14: {
                this._ebean_set_creditAdviceFetchType((String)o);
                return;
            }
            case 15: {
                this._ebean_set_bkaFetchType((String)o);
                return;
            }
            case 16: {
                this._ebean_set_bkiFetchType((String)o);
                return;
            }
            case 17: {
                this._ebean_set_c54FetchType((String)o);
                return;
            }
            case 18: {
                this._ebean_set_lastStaFetch((Date)o);
                return;
            }
            case 19: {
                this._ebean_set_lastVmkFetch((Date)o);
                return;
            }
            case 20: {
                this._ebean_set_lastCreditAdviceFetch((Date)o);
                return;
            }
            case 21: {
                this._ebean_set_lastBkaFetch((Date)o);
                return;
            }
            case 22: {
                this._ebean_set_lastBkiFetch((Date)o);
                return;
            }
            case 23: {
                this._ebean_set_lastC54Fetch((Date)o);
                return;
            }
            case 24: {
                this._ebean_set_staFetchMode((FetchMode)((Object)o));
                return;
            }
            case 25: {
                this._ebean_set_vmkFetchMode((FetchMode)((Object)o));
                return;
            }
            case 26: {
                this._ebean_set_cavFetchMode((FetchMode)((Object)o));
                return;
            }
            case 27: {
                this._ebean_set_bkaFetchMode((FetchMode)((Object)o));
                return;
            }
            case 28: {
                this._ebean_set_bkiFetchMode((FetchMode)((Object)o));
                return;
            }
            case 29: {
                this._ebean_set_c54FetchMode((FetchMode)((Object)o));
                return;
            }
            case 30: {
                this._ebean_set_vbCalculationWithCav((Boolean)o);
                return;
            }
            case 31: {
                this._ebean_set_vbCalculationWithPav((Boolean)o);
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private /* synthetic */ Object _ebean_getIdentity() {
        CmBank cmBank = this;
        synchronized (cmBank) {
            if (this._ebean_identity != null) {
                return this._ebean_identity;
            }
            Object tmpId = this._ebean_getField(0);
            this._ebean_identity = tmpId != null ? tmpId : new Object();
            return this._ebean_identity;
        }
    }

    public /* synthetic */ boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        return this._ebean_getIdentity().equals(((CmBank)obj)._ebean_getIdentity());
    }

    public /* synthetic */ int hashCode() {
        return this._ebean_getIdentity().hashCode();
    }

    public /* synthetic */ void _ebean_setEmbeddedLoaded() {
    }

    public /* synthetic */ boolean _ebean_isEmbeddedNewOrDirty() {
        return false;
    }

    public /* synthetic */ Object _ebean_newInstance() {
        return new CmBank();
    }

    public static enum FetchMode {
        NEW,
        DATE;

    }
}

