/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.database.vo;

import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.Account;
import de.businesslogics.banking.database.vo.CmStatement;
import io.ebean.bean.EntityBean;
import io.ebean.bean.EntityBeanIntercept;
import java.math.BigDecimal;
import java.sql.Date;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.Transient;

@Entity
public class CmBalance
implements EntityBean {
    @Id
    private Integer id;
    @ManyToOne
    private Account account;
    private Date valueDate;
    @Column(precision=38, scale=3)
    private BigDecimal valueBalance;
    @Transient
    private BigDecimal bookingBalance;
    @Column(precision=38, scale=3)
    private BigDecimal valueBalanceWithAdvice;
    public static /* synthetic */ String[] _ebean_props;
    protected /* synthetic */ EntityBeanIntercept _ebean_intercept;
    protected transient /* synthetic */ Object _ebean_identity;

    public static int findTotalCountForAccount(Account a) {
        return DB.find(CmBalance.class).where().eq("account", (Object)a).findCount();
    }

    public static int findCountForAccountBeforeDate(Account a, Date date) {
        return DB.find(CmBalance.class).where().eq("account", (Object)a).lt("valueDate", (Object)date).findCount();
    }

    public static List<CmBalance> findByDateRange(Account a, Date start, Date end, boolean displayValueBalances) {
        if (displayValueBalances) {
            return DB.find(CmBalance.class).where().eq("account", (Object)a).between("valueDate", (Object)start, (Object)end).orderBy("valueDate ASC").findList();
        }
        List statements = DB.find(CmStatement.class).where().eq("account", (Object)a).in("type", CmStatement.StatementTypes).between("closingDate", (Object)start, (Object)end).orderBy("closingDate ASC").findList();
        ArrayList<CmBalance> balances = new ArrayList<CmBalance>();
        for (CmStatement statement : statements) {
            balances.add(new CmBalance(a, statement.getClosingDate(), statement.getClosingBalance()));
        }
        return balances;
    }

    public static CmBalance findByDate(Account a, Date date) {
        return (CmBalance)DB.find(CmBalance.class).where().eq("account", (Object)a).eq("valueDate", (Object)date).findOne();
    }

    public static CmBalance getForDate(Account a, Date date) {
        if (date == null) {
            date = new Date(System.currentTimeMillis());
        }
        return (CmBalance)DB.find(CmBalance.class).where().eq("account", (Object)a).le("valueDate", (Object)date).order("valueDate DESC").setMaxRows(1).findOne();
    }

    public static CmBalance getForDate(Account a, Date date, boolean displayValueBalances) {
        BigDecimal bookingBalance;
        if (displayValueBalances) {
            return CmBalance.getForDate(a, date);
        }
        if (date == null) {
            date = new Date(System.currentTimeMillis());
        }
        if ((bookingBalance = CmStatement.findBookingBalance(a, date)) != null) {
            return new CmBalance(a, date, bookingBalance);
        }
        return null;
    }

    public static CmBalance getAfterDate(Account a, Date date) {
        return (CmBalance)DB.find(CmBalance.class).where().eq("account", (Object)a).gt("valueDate", (Object)date).order("valueDate ASC").setMaxRows(1).findOne();
    }

    public Integer getId() {
        return this._ebean_get_id();
    }

    public void setId(Integer id) {
        this._ebean_set_id(id);
    }

    public Account getAccount() {
        return this._ebean_get_account();
    }

    public void setAccount(Account account) {
        this._ebean_set_account(account);
    }

    public Date getVauleDate() {
        return this._ebean_get_valueDate();
    }

    public void setVauleDate(Date date) {
        this._ebean_set_valueDate(date);
    }

    public BigDecimal getValueBalance() {
        return this._ebean_get_valueBalance();
    }

    public void setValueBalance(BigDecimal valueBalance) {
        this._ebean_set_valueBalance(valueBalance);
    }

    public BigDecimal getValueBalanceWithAdvice() {
        return this._ebean_get_valueBalanceWithAdvice();
    }

    public void setValueBalanceWithAdvice(BigDecimal valueBalanceWithAdvice) {
        this._ebean_set_valueBalanceWithAdvice(valueBalanceWithAdvice);
    }

    public CmBalance() {
        this._ebean_intercept = new EntityBeanIntercept((Object)this);
    }

    private CmBalance(Account account, Date date, BigDecimal bookingBalance) {
        this._ebean_intercept = new EntityBeanIntercept((Object)this);
        this._ebean_set_account(account);
        this._ebean_set_valueDate(date);
        this.bookingBalance = bookingBalance;
    }

    public void setBookingBalance(BigDecimal bookingBalance) {
        this.bookingBalance = bookingBalance;
    }

    public BigDecimal getBookingBalance() {
        return this.bookingBalance;
    }

    public void save() {
        if (this.getId() == null) {
            DB.save(this);
        } else {
            DB.update(this);
        }
    }

    static {
        _ebean_props = new String[]{"id", "account", "valueDate", "valueBalance", "bookingBalance", "valueBalanceWithAdvice"};
    }

    public /* synthetic */ String[] _ebean_getPropertyNames() {
        return _ebean_props;
    }

    public /* synthetic */ String _ebean_getPropertyName(int pos) {
        return _ebean_props[pos];
    }

    public /* synthetic */ EntityBeanIntercept _ebean_getIntercept() {
        return this._ebean_intercept;
    }

    public /* synthetic */ EntityBeanIntercept _ebean_intercept() {
        if (this._ebean_intercept == null) {
            this._ebean_intercept = new EntityBeanIntercept((Object)this);
        }
        return this._ebean_intercept;
    }

    protected /* synthetic */ Integer _ebean_get_id() {
        this._ebean_intercept.preGetId();
        return this.id;
    }

    protected /* synthetic */ void _ebean_set_id(Integer newValue) {
        this._ebean_intercept.preSetter(false, 0, (Object)this.id, (Object)newValue);
        this.id = newValue;
    }

    protected /* synthetic */ Integer _ebean_getni_id() {
        return this.id;
    }

    protected /* synthetic */ void _ebean_setni_id(Integer _newValue) {
        this.id = _newValue;
        this._ebean_intercept.setLoadedProperty(0);
    }

    protected /* synthetic */ Account _ebean_get_account() {
        this._ebean_intercept.preGetter(1);
        return this.account;
    }

    protected /* synthetic */ void _ebean_set_account(Account newValue) {
        this._ebean_intercept.preSetter(true, 1, (Object)this._ebean_get_account(), (Object)newValue);
        this.account = newValue;
    }

    protected /* synthetic */ Account _ebean_getni_account() {
        return this.account;
    }

    protected /* synthetic */ void _ebean_setni_account(Account _newValue) {
        this.account = _newValue;
        this._ebean_intercept.setLoadedProperty(1);
    }

    protected /* synthetic */ Date _ebean_get_valueDate() {
        this._ebean_intercept.preGetter(2);
        return this.valueDate;
    }

    protected /* synthetic */ void _ebean_set_valueDate(Date newValue) {
        this._ebean_intercept.preSetter(true, 2, (Object)this._ebean_get_valueDate(), (Object)newValue);
        this.valueDate = newValue;
    }

    protected /* synthetic */ Date _ebean_getni_valueDate() {
        return this.valueDate;
    }

    protected /* synthetic */ void _ebean_setni_valueDate(Date _newValue) {
        this.valueDate = _newValue;
        this._ebean_intercept.setLoadedProperty(2);
    }

    protected /* synthetic */ BigDecimal _ebean_get_valueBalance() {
        this._ebean_intercept.preGetter(3);
        return this.valueBalance;
    }

    protected /* synthetic */ void _ebean_set_valueBalance(BigDecimal newValue) {
        this._ebean_intercept.preSetter(true, 3, (Object)this._ebean_get_valueBalance(), (Object)newValue);
        this.valueBalance = newValue;
    }

    protected /* synthetic */ BigDecimal _ebean_getni_valueBalance() {
        return this.valueBalance;
    }

    protected /* synthetic */ void _ebean_setni_valueBalance(BigDecimal _newValue) {
        this.valueBalance = _newValue;
        this._ebean_intercept.setLoadedProperty(3);
    }

    protected /* synthetic */ BigDecimal _ebean_get_bookingBalance() {
        return this.bookingBalance;
    }

    protected /* synthetic */ void _ebean_set_bookingBalance(BigDecimal newValue) {
        this._ebean_intercept.preSetter(false, 4, (Object)this._ebean_get_bookingBalance(), (Object)newValue);
        this.bookingBalance = newValue;
    }

    protected /* synthetic */ BigDecimal _ebean_getni_bookingBalance() {
        return this.bookingBalance;
    }

    protected /* synthetic */ void _ebean_setni_bookingBalance(BigDecimal _newValue) {
        this.bookingBalance = _newValue;
        this._ebean_intercept.setLoadedProperty(4);
    }

    protected /* synthetic */ BigDecimal _ebean_get_valueBalanceWithAdvice() {
        this._ebean_intercept.preGetter(5);
        return this.valueBalanceWithAdvice;
    }

    protected /* synthetic */ void _ebean_set_valueBalanceWithAdvice(BigDecimal newValue) {
        this._ebean_intercept.preSetter(true, 5, (Object)this._ebean_get_valueBalanceWithAdvice(), (Object)newValue);
        this.valueBalanceWithAdvice = newValue;
    }

    protected /* synthetic */ BigDecimal _ebean_getni_valueBalanceWithAdvice() {
        return this.valueBalanceWithAdvice;
    }

    protected /* synthetic */ void _ebean_setni_valueBalanceWithAdvice(BigDecimal _newValue) {
        this.valueBalanceWithAdvice = _newValue;
        this._ebean_intercept.setLoadedProperty(5);
    }

    public /* synthetic */ Object _ebean_getField(int index) {
        switch (index) {
            case 0: {
                return this.id;
            }
            case 1: {
                return this.account;
            }
            case 2: {
                return this.valueDate;
            }
            case 3: {
                return this.valueBalance;
            }
            case 4: {
                return this.bookingBalance;
            }
            case 5: {
                return this.valueBalanceWithAdvice;
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    public /* synthetic */ Object _ebean_getFieldIntercept(int index) {
        switch (index) {
            case 0: {
                return this._ebean_get_id();
            }
            case 1: {
                return this._ebean_get_account();
            }
            case 2: {
                return this._ebean_get_valueDate();
            }
            case 3: {
                return this._ebean_get_valueBalance();
            }
            case 4: {
                return this._ebean_get_bookingBalance();
            }
            case 5: {
                return this._ebean_get_valueBalanceWithAdvice();
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    public /* synthetic */ void _ebean_setField(int index, Object o) {
        switch (index) {
            case 0: {
                this._ebean_setni_id((Integer)o);
                return;
            }
            case 1: {
                this._ebean_setni_account((Account)o);
                return;
            }
            case 2: {
                this._ebean_setni_valueDate((Date)o);
                return;
            }
            case 3: {
                this._ebean_setni_valueBalance((BigDecimal)o);
                return;
            }
            case 4: {
                this._ebean_setni_bookingBalance((BigDecimal)o);
                return;
            }
            case 5: {
                this._ebean_setni_valueBalanceWithAdvice((BigDecimal)o);
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    public /* synthetic */ void _ebean_setFieldIntercept(int index, Object o) {
        switch (index) {
            case 0: {
                this._ebean_set_id((Integer)o);
                return;
            }
            case 1: {
                this._ebean_set_account((Account)o);
                return;
            }
            case 2: {
                this._ebean_set_valueDate((Date)o);
                return;
            }
            case 3: {
                this._ebean_set_valueBalance((BigDecimal)o);
                return;
            }
            case 4: {
                this._ebean_set_bookingBalance((BigDecimal)o);
                return;
            }
            case 5: {
                this._ebean_set_valueBalanceWithAdvice((BigDecimal)o);
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private /* synthetic */ Object _ebean_getIdentity() {
        CmBalance cmBalance = this;
        synchronized (cmBalance) {
            if (this._ebean_identity != null) {
                return this._ebean_identity;
            }
            Object tmpId = this._ebean_getField(0);
            this._ebean_identity = tmpId != null ? tmpId : new Object();
            return this._ebean_identity;
        }
    }

    public /* synthetic */ boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        return this._ebean_getIdentity().equals(((CmBalance)obj)._ebean_getIdentity());
    }

    public /* synthetic */ int hashCode() {
        return this._ebean_getIdentity().hashCode();
    }

    public /* synthetic */ void _ebean_setEmbeddedLoaded() {
    }

    public /* synthetic */ boolean _ebean_isEmbeddedNewOrDirty() {
        return false;
    }

    public /* synthetic */ Object _ebean_newInstance() {
        return new CmBalance();
    }
}

