/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.database.vo;

import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.FilterComparator;
import de.businesslogics.banking.database.vo.User;
import io.ebean.Expr;
import io.ebean.Expression;
import io.ebean.bean.EntityBean;
import io.ebean.bean.EntityBeanIntercept;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.Calendar;
import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.MappedSuperclass;

@MappedSuperclass
public abstract class BaseFilter
implements EntityBean {
    protected static final long serialVersionUID = 1L;
    @Id
    private Integer id;
    @ManyToOne(optional=false)
    private User user;
    private Date fromDate;
    private Date toDate;
    @Column(name="date_comp")
    private FilterComparator.Date dateComparator;
    public static /* synthetic */ String[] _ebean_props;
    protected /* synthetic */ EntityBeanIntercept _ebean_intercept;
    protected transient /* synthetic */ Object _ebean_identity;

    protected BaseFilter(User user) {
        this._ebean_intercept = new EntityBeanIntercept((Object)this);
        this._ebean_set_user(user);
    }

    public Integer getId() {
        return this._ebean_get_id();
    }

    public void setId(Integer id) {
        this._ebean_set_id(id);
    }

    public User getUser() {
        return this._ebean_get_user();
    }

    public Date getFromDate() {
        return this._ebean_get_fromDate();
    }

    public void setFromDate(Date fromDate) {
        this._ebean_set_fromDate(fromDate);
    }

    public Date getToDate() {
        return this._ebean_get_toDate();
    }

    public void setToDate(Date toDate) {
        this._ebean_set_toDate(toDate);
    }

    public FilterComparator.Date getDateComparator() {
        return this._ebean_get_dateComparator();
    }

    public void setDateComparator(FilterComparator.Date dateComparator) {
        this._ebean_set_dateComparator(dateComparator);
    }

    public final void setDateComparatorIndex(int i) {
        if (i >= 0 && i < FilterComparator.Date.values().length) {
            this._ebean_set_dateComparator(FilterComparator.Date.values()[i]);
        } else {
            this._ebean_set_dateComparator(null);
        }
    }

    public final int getDateComparatorIndex() {
        if (this._ebean_get_dateComparator() != null) {
            for (int i = 0; i < FilterComparator.Date.values().length; ++i) {
                if (this._ebean_get_dateComparator() != FilterComparator.Date.values()[i]) continue;
                return i;
            }
        }
        return -1;
    }

    protected Expression getDateExpression(String columnName) {
        Expression toReturn = null;
        if (this._ebean_get_dateComparator() != null && (this._ebean_get_fromDate() != null || this._ebean_get_dateComparator() == FilterComparator.Date.BETWEEN && this._ebean_get_toDate() != null)) {
            switch (this._ebean_get_dateComparator()) {
                case EQUAL: {
                    toReturn = Expr.between((String)columnName, (Object)this._ebean_get_fromDate(), (Object)this.getMaximumTimestamp(this._ebean_get_fromDate()));
                    break;
                }
                case GREATER: {
                    toReturn = Expr.gt((String)columnName, (Object)this._ebean_get_fromDate());
                    break;
                }
                case LESS: {
                    toReturn = Expr.lt((String)columnName, (Object)this._ebean_get_fromDate());
                    break;
                }
                case BETWEEN: {
                    if (this._ebean_get_fromDate() != null && this._ebean_get_toDate() != null) {
                        if (this._ebean_get_fromDate().before(this._ebean_get_toDate())) {
                            toReturn = Expr.between((String)columnName, (Object)this._ebean_get_fromDate(), (Object)this.getMaximumTimestamp(this._ebean_get_toDate()));
                            break;
                        }
                        toReturn = Expr.between((String)columnName, (Object)this._ebean_get_toDate(), (Object)this.getMaximumTimestamp(this._ebean_get_fromDate()));
                        break;
                    }
                    if (this._ebean_get_fromDate() != null) {
                        toReturn = Expr.ge((String)columnName, (Object)this._ebean_get_fromDate());
                        break;
                    }
                    toReturn = Expr.le((String)columnName, (Object)this.getMaximumTimestamp(this._ebean_get_toDate()));
                    break;
                }
            }
        }
        return toReturn;
    }

    private Timestamp getMaximumTimestamp(Date date) {
        Calendar c = Calendar.getInstance();
        c.clear();
        c.setTime(date);
        c.set(11, c.getMaximum(11));
        c.set(12, c.getMaximum(12));
        c.set(13, c.getMaximum(13));
        return new Timestamp(c.getTimeInMillis());
    }

    protected final boolean isDateFilterEmpty() {
        return this._ebean_get_dateComparator() == null || this._ebean_get_fromDate() == null && this._ebean_get_toDate() == null;
    }

    protected Expression addFilter(Expression main, Expression add) {
        if (main == null) {
            return add;
        }
        return Expr.and((Expression)main, (Expression)add);
    }

    public final void save() {
        if (this._ebean_get_id() == null) {
            DB.save(this);
        } else {
            DB.update(this);
        }
    }

    static {
        _ebean_props = new String[]{"id", "user", "fromDate", "toDate", "dateComparator"};
    }

    public /* synthetic */ BaseFilter() {
        this._ebean_intercept = new EntityBeanIntercept((Object)this);
    }

    public /* synthetic */ String[] _ebean_getPropertyNames() {
        return _ebean_props;
    }

    public /* synthetic */ String _ebean_getPropertyName(int pos) {
        return _ebean_props[pos];
    }

    public /* synthetic */ EntityBeanIntercept _ebean_getIntercept() {
        return this._ebean_intercept;
    }

    public /* synthetic */ EntityBeanIntercept _ebean_intercept() {
        if (this._ebean_intercept == null) {
            this._ebean_intercept = new EntityBeanIntercept((Object)this);
        }
        return this._ebean_intercept;
    }

    protected /* synthetic */ Integer _ebean_get_id() {
        this._ebean_intercept.preGetId();
        return this.id;
    }

    protected /* synthetic */ void _ebean_set_id(Integer newValue) {
        this._ebean_intercept.preSetter(false, 0, (Object)this.id, (Object)newValue);
        this.id = newValue;
    }

    protected /* synthetic */ Integer _ebean_getni_id() {
        return this.id;
    }

    protected /* synthetic */ void _ebean_setni_id(Integer _newValue) {
        this.id = _newValue;
        this._ebean_intercept.setLoadedProperty(0);
    }

    protected /* synthetic */ User _ebean_get_user() {
        this._ebean_intercept.preGetter(1);
        return this.user;
    }

    protected /* synthetic */ void _ebean_set_user(User newValue) {
        this._ebean_intercept.preSetter(true, 1, (Object)this._ebean_get_user(), (Object)newValue);
        this.user = newValue;
    }

    protected /* synthetic */ User _ebean_getni_user() {
        return this.user;
    }

    protected /* synthetic */ void _ebean_setni_user(User _newValue) {
        this.user = _newValue;
        this._ebean_intercept.setLoadedProperty(1);
    }

    protected /* synthetic */ Date _ebean_get_fromDate() {
        this._ebean_intercept.preGetter(2);
        return this.fromDate;
    }

    protected /* synthetic */ void _ebean_set_fromDate(Date newValue) {
        this._ebean_intercept.preSetter(true, 2, (Object)this._ebean_get_fromDate(), (Object)newValue);
        this.fromDate = newValue;
    }

    protected /* synthetic */ Date _ebean_getni_fromDate() {
        return this.fromDate;
    }

    protected /* synthetic */ void _ebean_setni_fromDate(Date _newValue) {
        this.fromDate = _newValue;
        this._ebean_intercept.setLoadedProperty(2);
    }

    protected /* synthetic */ Date _ebean_get_toDate() {
        this._ebean_intercept.preGetter(3);
        return this.toDate;
    }

    protected /* synthetic */ void _ebean_set_toDate(Date newValue) {
        this._ebean_intercept.preSetter(true, 3, (Object)this._ebean_get_toDate(), (Object)newValue);
        this.toDate = newValue;
    }

    protected /* synthetic */ Date _ebean_getni_toDate() {
        return this.toDate;
    }

    protected /* synthetic */ void _ebean_setni_toDate(Date _newValue) {
        this.toDate = _newValue;
        this._ebean_intercept.setLoadedProperty(3);
    }

    protected /* synthetic */ FilterComparator.Date _ebean_get_dateComparator() {
        this._ebean_intercept.preGetter(4);
        return this.dateComparator;
    }

    protected /* synthetic */ void _ebean_set_dateComparator(FilterComparator.Date newValue) {
        this._ebean_intercept.preSetter(true, 4, (Object)this._ebean_get_dateComparator(), (Object)newValue);
        this.dateComparator = newValue;
    }

    protected /* synthetic */ FilterComparator.Date _ebean_getni_dateComparator() {
        return this.dateComparator;
    }

    protected /* synthetic */ void _ebean_setni_dateComparator(FilterComparator.Date _newValue) {
        this.dateComparator = _newValue;
        this._ebean_intercept.setLoadedProperty(4);
    }

    public /* synthetic */ Object _ebean_getField(int index) {
        switch (index) {
            case 0: {
                return this.id;
            }
            case 1: {
                return this.user;
            }
            case 2: {
                return this.fromDate;
            }
            case 3: {
                return this.toDate;
            }
            case 4: {
                return this.dateComparator;
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    public /* synthetic */ Object _ebean_getFieldIntercept(int index) {
        switch (index) {
            case 0: {
                return this._ebean_get_id();
            }
            case 1: {
                return this._ebean_get_user();
            }
            case 2: {
                return this._ebean_get_fromDate();
            }
            case 3: {
                return this._ebean_get_toDate();
            }
            case 4: {
                return this._ebean_get_dateComparator();
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    public /* synthetic */ void _ebean_setField(int index, Object o) {
        switch (index) {
            case 0: {
                this._ebean_setni_id((Integer)o);
                return;
            }
            case 1: {
                this._ebean_setni_user((User)o);
                return;
            }
            case 2: {
                this._ebean_setni_fromDate((Date)o);
                return;
            }
            case 3: {
                this._ebean_setni_toDate((Date)o);
                return;
            }
            case 4: {
                this._ebean_setni_dateComparator((FilterComparator.Date)((Object)o));
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    public /* synthetic */ void _ebean_setFieldIntercept(int index, Object o) {
        switch (index) {
            case 0: {
                this._ebean_set_id((Integer)o);
                return;
            }
            case 1: {
                this._ebean_set_user((User)o);
                return;
            }
            case 2: {
                this._ebean_set_fromDate((Date)o);
                return;
            }
            case 3: {
                this._ebean_set_toDate((Date)o);
                return;
            }
            case 4: {
                this._ebean_set_dateComparator((FilterComparator.Date)((Object)o));
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private /* synthetic */ Object _ebean_getIdentity() {
        BaseFilter baseFilter = this;
        synchronized (baseFilter) {
            if (this._ebean_identity != null) {
                return this._ebean_identity;
            }
            Object tmpId = this._ebean_getField(0);
            this._ebean_identity = tmpId != null ? tmpId : new Object();
            return this._ebean_identity;
        }
    }

    public /* synthetic */ boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        return this._ebean_getIdentity().equals(((BaseFilter)obj)._ebean_getIdentity());
    }

    public /* synthetic */ int hashCode() {
        return this._ebean_getIdentity().hashCode();
    }

    public /* synthetic */ void _ebean_setEmbeddedLoaded() {
    }

    public /* synthetic */ boolean _ebean_isEmbeddedNewOrDirty() {
        return false;
    }

    public /* synthetic */ Object _ebean_newInstance() {
        return new BaseFilter();
    }
}

