/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.database.vo;

import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.AccountPermission;
import de.businesslogics.banking.database.vo.ApOverwrite;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.BankUserHtdInfo;
import de.businesslogics.banking.database.vo.DsOpenOrder;
import de.businesslogics.banking.database.vo.OrderType;
import de.businesslogics.banking.database.vo.Scheduler;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.banking.database.vo.UserEffectivePermission;
import de.businesslogics.banking.database.vo.UserPermission;
import io.ebean.Expr;
import io.ebean.Expression;
import io.ebean.Update;
import io.ebean.bean.EntityBean;
import io.ebean.bean.EntityBeanIntercept;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;

@Entity
@Table(name="bankuser")
@UniqueConstraint(columnNames={"bank_id", "user_id"})
public class BankUser
implements EntityBean {
    @Id
    private Integer id;
    @ManyToOne(optional=false)
    private BankSettings bank;
    @ManyToOne(optional=false)
    private User user;
    @Column(length=35)
    private String defaultUser;
    @Column(length=4)
    private String orderNumber;
    @Column(nullable=false)
    private boolean withCerts;
    @Column(nullable=false)
    private UserState state;
    private boolean deactivated;
    private boolean wssActivated;
    @Column(length=4)
    private String signatureVersion;
    private Integer sigKeyLength;
    private Integer authKeyLength;
    private Integer encrKeyLength;
    private Integer dtausReferenceNumber;
    private Integer bundesbankFileNumber;
    private Integer sepaMessageId;
    @Column(name="mt101_sender_reference")
    private Integer mt101SenderReference;
    @Lob
    private byte[] encrKey;
    @Lob
    private byte[] encrCert;
    @Lob
    private byte[] authKey;
    @Lob
    private byte[] authCert;
    @Lob
    private byte[] sigKey;
    @Lob
    private byte[] sigCert;
    @Lob
    private byte[] lockUserSignature;
    @Lob
    private byte[] iniLetter;
    public static /* synthetic */ String[] _ebean_props;
    protected /* synthetic */ EntityBeanIntercept _ebean_intercept;
    protected transient /* synthetic */ Object _ebean_identity;

    public BankUser() {
        this._ebean_intercept = new EntityBeanIntercept((Object)this);
        this._ebean_set_orderNumber("A000");
        this._ebean_set_state(UserState.CREATED);
        this._ebean_set_deactivated(false);
        this._ebean_set_wssActivated(true);
    }

    public static boolean hasAnySignature(User user) {
        return DB.find(BankUser.class).where().eq("user", (Object)user).eq("state", (Object)UserState.READY).isNotNull("lockUserSignature").findCount() > 0;
    }

    public static boolean isBankAccessReset(User user) {
        return DB.find(BankUser.class).where().ne("user", (Object)user).eq("state", (Object)UserState.NOT_USED).findCount() > 0;
    }

    public static List<BankUser> findActiveBanksConnection(User user) {
        return DB.find(BankUser.class).where().eq("user", (Object)user).ne("state", (Object)UserState.NOT_USED).findList();
    }

    public static void resetAllBanks(User user) {
        for (BankUser bu : BankUser.findBanksForUser(user)) {
            bu.setSigKey(null);
            bu.setSigCert(null);
            bu.setAuthCert(null);
            bu.setAuthKey(null);
            bu.setAuthKeyLength(0);
            bu.setEncrCert(null);
            bu.setEncrKey(null);
            bu.setEncrKeyLength(0);
            bu.setState(UserState.NOT_USED);
            bu.setLockUserSignature(null);
            bu.save();
        }
    }

    public static List<BankUser> findNonLocalBankUsersWithUserId(BankSettings bank) {
        return DB.find(BankUser.class).where().eq("bank", (Object)bank).isNotNull("defaultUser").ne("state", (Object)UserState.USED_NO_INI).findList();
    }

    public static List<BankUser> findBankUsersWithoutUserId(BankSettings bank) {
        return DB.find(BankUser.class).where().eq("bank", (Object)bank).isNull("defaultUser").findList();
    }

    public static List<BankUser> findAllBankUsersForUser(User user) {
        return DB.find(BankUser.class).where().eq("user", (Object)user).findList();
    }

    public static List<BankUser> findActiveBankUsersForBank(BankSettings bank) {
        return DB.find(BankUser.class).where().eq("bank", (Object)bank).ne("state", (Object)UserState.NOT_USED).findList();
    }

    public static List<BankUser> findActiveBankUsersForUser(User user) {
        return DB.find(BankUser.class).where().eq("user", (Object)user).ne("state", (Object)UserState.NOT_USED).findList();
    }

    public static List<BankUser> findAllBankUsersForBank(BankSettings bank) {
        return DB.find(BankUser.class).where().eq("bank", (Object)bank).findList();
    }

    public static List<BankUser> findActiveNonLocalBankUsersForBank(BankSettings bank) {
        if (bank.getBankId() == null) {
            return Collections.emptyList();
        }
        UserState[] unusedStates = new UserState[]{UserState.NOT_USED, UserState.USED_NO_INI};
        Expression expr1 = Expr.not((Expression)Expr.in((String)"state", (Object[])unusedStates));
        return DB.find(BankUser.class).where().eq("bank", (Object)bank).add(expr1).findList();
    }

    public static List<BankUser> findForBankAndStates(BankSettings bank, UserState[] states) {
        return DB.find(BankUser.class).where().eq("bank", (Object)bank).in("state", (Object[])states).findList();
    }

    public static BankUser createBankUser(BankSettings bank, User user) {
        BankUser bankUser = new BankUser();
        bankUser.setUser(user);
        bankUser.setBank(bank);
        if (user.isLocalUser()) {
            bankUser.setState(UserState.USED_NO_INI);
        } else {
            bankUser.setState(UserState.NOT_USED);
        }
        bankUser.setOrderNumber("A000");
        bankUser.save();
        return bankUser;
    }

    public static int deleteAll(BankSettings bank) {
        Update<BankUser> delete = DB.createUpdate(BankUser.class, "DELETE FROM BankUser WHERE bank=:bank");
        delete.setParameter("bank", (Object)bank.getBankId());
        return delete.execute();
    }

    public static int deleteByUser(User user) {
        UserPermission.deleteByUser(user);
        UserEffectivePermission.deleteAll(user);
        AccountPermission.deleteByUser(user);
        ApOverwrite.deleteByUser(user);
        BankUserHtdInfo.deleteByUser(user);
        DsOpenOrder.deleteByUser(user);
        Scheduler.deleteByUser(user);
        Update<BankUser> delete = DB.createUpdate(BankUser.class, "DELETE FROM BankUser WHERE user=:user");
        delete.setParameter("user", (Object)user.getId());
        return delete.execute();
    }

    public static BankUser findById(Integer id) {
        return DB.find(BankUser.class, id);
    }

    public static String findLoginUserNameByUserIdAndCustomerId(String userId, String customerId) {
        User user = BankUser.findLoginUserByUserIdAndCustomerId(userId, customerId);
        if (user != null) {
            return user.getName();
        }
        return null;
    }

    public static User findLoginUserByUserIdAndCustomerId(String userId, String customerId) {
        List list = DB.find(BankUser.class).fetch("user").where().eq("bank.customerId", (Object)customerId).eq("defaultUser", (Object)userId).ne("defaultUser", null).findList();
        if (!list.isEmpty()) {
            return ((BankUser)list.getFirst()).getUser();
        }
        return null;
    }

    public static String findUniqueLoginUserNameByUserIdAndCustomerId(String userId, String customerId) {
        User user = BankUser.findUniqueLoginUserByUserIdAndCustomerId(userId, customerId);
        if (user != null) {
            return user.getName();
        }
        return null;
    }

    public static User findUniqueLoginUserByUserIdAndCustomerId(String userId, String customerId) {
        List list = DB.find(BankUser.class).fetch("user").where().eq("bank.customerId", (Object)customerId).eq("defaultUser", (Object)userId).ne("defaultUser", null).findList();
        if (list.size() == 1) {
            return ((BankUser)list.getFirst()).getUser();
        }
        return null;
    }

    public static String findLoginUserNameByUserIdAndCustomerId(BankSettings bank, String userId, String customerId) {
        User user = BankUser.findLoginUserByUserIdAndCustomerId(bank, userId, customerId);
        if (user != null) {
            return user.getName();
        }
        return null;
    }

    public static User findLoginUserByUserIdAndCustomerId(BankSettings bank, String userId, String customerId) {
        List list = DB.find(BankUser.class).fetch("user").where().eq("bank", (Object)bank).eq("bank.customerId", (Object)customerId).eq("defaultUser", (Object)userId).ne("defaultUser", null).findList();
        if (!list.isEmpty()) {
            return ((BankUser)list.getFirst()).getUser();
        }
        return null;
    }

    public static void setPermissionsForLocalUser(OrderType orderType) {
        List list = DB.find(BankUser.class).where().eq("bank", (Object)orderType.getBank()).eq("state", (Object)UserState.USED_NO_INI).findList();
        List withPermission = DB.find(UserPermission.class).where().in("bankUser", (Collection)list).eq("orderType", (Object)orderType).findList();
        for (UserPermission p : withPermission) {
            list.remove(p.getBankUser());
        }
        for (BankUser b : list) {
            UserPermission p = new UserPermission();
            p.setBankUser(b);
            p.setOrderType(orderType);
            p.save();
        }
    }

    public static void setPermissionsForNotInitializedUser(OrderType orderType) {
        List list = DB.find(BankUser.class).where().eq("bank", (Object)orderType.getBank()).eq("state", (Object)UserState.NOT_USED).findList();
        List withPermission = DB.find(UserPermission.class).where().in("bankUser", (Collection)list).eq("orderType", (Object)orderType).findList();
        for (UserPermission p : withPermission) {
            list.remove(p.getBankUser());
        }
        for (BankUser b : list) {
            UserPermission p = new UserPermission();
            p.setBankUser(b);
            p.setOrderType(orderType);
            p.save();
        }
    }

    public static List<BankUser> findBanksForUser(User user) {
        return DB.find(BankUser.class).where().eq("user", (Object)user).findList();
    }

    public static int findBankCount(User user) {
        return DB.find(BankUser.class).where().eq("user", (Object)user).findCount();
    }

    public static List<BankUser> findActiveBanksForUser(User user) {
        return DB.find(BankUser.class).where().eq("user", (Object)user).eq("deactivated", (Object)false).findList();
    }

    public static List<BankUser> findBanksForPaymentImport(User user) {
        UserState[] noImportStates = new UserState[]{UserState.NOT_USED, UserState.CREATED};
        Expression expr1 = Expr.not((Expression)Expr.in((String)"state", (Object[])noImportStates));
        Expression expr2 = Expr.eq((String)"deactivated", (Object)false);
        return DB.find(BankUser.class).where().eq("user", (Object)user).and(expr1, expr2).findList();
    }

    public static BankUser findBankForPaymentImport(User user, Integer bankId) {
        UserState[] noImportStates = new UserState[]{UserState.NOT_USED, UserState.CREATED};
        Expression expr1 = Expr.not((Expression)Expr.in((String)"state", (Object[])noImportStates));
        Expression expr2 = Expr.eq((String)"deactivated", (Object)false);
        return (BankUser)DB.find(BankUser.class).where().eq("user", (Object)user).eq("bank_id", (Object)bankId).and(expr1, expr2).findOne();
    }

    public static boolean hasUserInitializedBanks(User user) {
        return DB.find(BankUser.class).where().eq("user", (Object)user).ne("state", (Object)UserState.NOT_USED).findCount() > 0;
    }

    public static List<BankUser> findAllWithUserID() {
        return DB.find(BankUser.class).where().isNotNull("defaultUser").findList();
    }

    public static BankUser findBankUser(BankSettings bank, User user) {
        return (BankUser)DB.find(BankUser.class).where().eq("bank", (Object)bank).eq("user", (Object)user).findOne();
    }

    public static BankUser findBankUser(BankSettings bank, String userId) {
        return (BankUser)DB.find(BankUser.class).where().eq("bank", (Object)bank).eq("defaultUser", (Object)userId).findOne();
    }

    public Integer getId() {
        return this._ebean_get_id();
    }

    public void setId(Integer id) {
        this._ebean_set_id(id);
    }

    public BankSettings getBank() {
        return this._ebean_get_bank();
    }

    public void setBank(BankSettings bank) {
        this._ebean_set_bank(bank);
    }

    public User getUser() {
        return this._ebean_get_user();
    }

    public void setUser(User user) {
        this._ebean_set_user(user);
    }

    public String getDefaultUser() {
        return this._ebean_get_defaultUser();
    }

    public void setDefaultUser(String defaultUser) {
        this._ebean_set_defaultUser(defaultUser);
    }

    public String getOrderNumber() {
        return this._ebean_get_orderNumber();
    }

    public void setOrderNumber(String orderNumber) {
        if (orderNumber == null || orderNumber.isEmpty()) {
            this._ebean_set_orderNumber("A000");
        } else {
            this._ebean_set_orderNumber(orderNumber);
        }
    }

    public boolean isWithCerts() {
        return this._ebean_get_withCerts();
    }

    public void setWithCerts(boolean withCerts) {
        this._ebean_set_withCerts(withCerts);
    }

    public UserState getState() {
        return this._ebean_get_state();
    }

    public void setState(UserState userState) {
        this._ebean_set_state(userState);
    }

    public boolean isDeactivated() {
        return this._ebean_get_deactivated();
    }

    public void setDeactivated(boolean deactivated) {
        this._ebean_set_deactivated(deactivated);
    }

    public boolean isWssActivated() {
        return this._ebean_get_wssActivated();
    }

    public void setWssActivated(boolean wssActivated) {
        this._ebean_set_wssActivated(wssActivated);
    }

    public boolean hasActiveEBICSKeys() {
        if (this.getDefaultUser() == null) {
            return false;
        }
        return switch (this.getState().ordinal()) {
            default -> throw new MatchException(null, null);
            case 2, 3, 4 -> false;
            case 0, 1, 5 -> true;
        };
    }

    public String getSignatureVersion() {
        return this._ebean_get_signatureVersion();
    }

    public void setSignatureVersion(String signatureVersion) {
        this._ebean_set_signatureVersion(signatureVersion);
    }

    public int getSigKeyLength() {
        return Objects.requireNonNullElse(this._ebean_get_sigKeyLength(), 0);
    }

    public void setSigKeyLength(int sigKeyLength) {
        this._ebean_set_sigKeyLength(sigKeyLength);
    }

    public int getAuthKeyLength() {
        return Objects.requireNonNullElse(this._ebean_get_authKeyLength(), 0);
    }

    public void setAuthKeyLength(int authKeyLength) {
        this._ebean_set_authKeyLength(authKeyLength);
    }

    public int getEncrKeyLength() {
        return Objects.requireNonNullElse(this._ebean_get_encrKeyLength(), 0);
    }

    public void setEncrKeyLength(int encrKeyLength) {
        this._ebean_set_encrKeyLength(encrKeyLength);
    }

    public Integer getDtausReferenceNumber() {
        return this._ebean_get_dtausReferenceNumber();
    }

    public void setDtausReferenceNumber(Integer dtausReferenceNumber) {
        this._ebean_set_dtausReferenceNumber(dtausReferenceNumber);
    }

    public Integer getBundesbankFileNumber() {
        return this._ebean_get_bundesbankFileNumber();
    }

    public void setBundesbankFileNumber(Integer bundesbankFileNumber) {
        this._ebean_set_bundesbankFileNumber(bundesbankFileNumber);
    }

    public Integer getSepaMessageId() {
        return this._ebean_get_sepaMessageId();
    }

    public void setSepaMessageId(Integer sepaMessageId) {
        this._ebean_set_sepaMessageId(sepaMessageId);
    }

    public Integer getMt101SenderReference() {
        return this._ebean_get_mt101SenderReference();
    }

    public void setMt101SenderReference(Integer mt101SenderReference) {
        this._ebean_set_mt101SenderReference(mt101SenderReference);
    }

    public byte[] getEncrKey() {
        return this._ebean_get_encrKey();
    }

    public void setEncrKey(byte[] encrKey) {
        this._ebean_set_encrKey(encrKey);
    }

    public byte[] getEncrCert() {
        return this._ebean_get_encrCert();
    }

    public void setEncrCert(byte[] encrCert) {
        this._ebean_set_encrCert(encrCert);
    }

    public byte[] getAuthKey() {
        return this._ebean_get_authKey();
    }

    public void setAuthKey(byte[] authKey) {
        this._ebean_set_authKey(authKey);
    }

    public byte[] getAuthCert() {
        return this._ebean_get_authCert();
    }

    public void setAuthCert(byte[] authCert) {
        this._ebean_set_authCert(authCert);
    }

    public byte[] getSigKey() {
        return this._ebean_get_sigKey();
    }

    public void setSigKey(byte[] sigKey) {
        this._ebean_set_sigKey(sigKey);
    }

    public byte[] getSigCert() {
        return this._ebean_get_sigCert();
    }

    public void setSigCert(byte[] sigCert) {
        this._ebean_set_sigCert(sigCert);
    }

    public byte[] getLockUserSignature() {
        return this._ebean_get_lockUserSignature();
    }

    public void setLockUserSignature(byte[] lockUserSignature) {
        this._ebean_set_lockUserSignature(lockUserSignature);
    }

    public byte[] getIniLetter() {
        return this._ebean_get_iniLetter();
    }

    public void setIniLetter(byte[] iniLetter) {
        this._ebean_set_iniLetter(iniLetter);
    }

    public void setIniLetter(File iniLetterFile) throws IOException {
        byte[] iniLetterBytes;
        try (FileInputStream fileInputStream = new FileInputStream(iniLetterFile);){
            iniLetterBytes = new byte[(int)iniLetterFile.length()];
            int readBytes = fileInputStream.read(iniLetterBytes);
            if (-1 == readBytes) {
                throw new IOException("Could not read complete INI letter from file! " + iniLetterFile.getAbsolutePath());
            }
        }
        this.setIniLetter(iniLetterBytes);
    }

    public void save() {
        if (this.getId() == null) {
            DB.save(this);
        } else {
            DB.update(this);
        }
    }

    public void delete() {
        UserPermission.deleteByBankUser(this);
        AccountPermission.deleteByBankUser(this);
        UserEffectivePermission.deleteAll(this);
        BankUserHtdInfo.deleteByBankUser(this);
        ApOverwrite.deleteByBankUser(this);
        DsOpenOrder.deleteByBankUser(this);
        Scheduler.deleteByBankUser(this);
        DB.delete(this);
    }

    public static Expression getFilterExpression(String searchString) {
        if (searchString == null || searchString.isEmpty()) {
            return null;
        }
        String like = "%" + searchString + "%";
        Expression expression = Expr.ilike((String)"defaultUser", (String)like);
        expression = Expr.or((Expression)expression, (Expression)Expr.ilike((String)"user.name", (String)like));
        expression = Expr.or((Expression)expression, (Expression)Expr.ilike((String)"bank.tenant.name", (String)like));
        expression = Expr.or((Expression)expression, (Expression)Expr.ilike((String)"bank.customerId", (String)like));
        return expression;
    }

    static {
        _ebean_props = new String[]{"id", "bank", "user", "defaultUser", "orderNumber", "withCerts", "state", "deactivated", "wssActivated", "signatureVersion", "sigKeyLength", "authKeyLength", "encrKeyLength", "dtausReferenceNumber", "bundesbankFileNumber", "sepaMessageId", "mt101SenderReference", "encrKey", "encrCert", "authKey", "authCert", "sigKey", "sigCert", "lockUserSignature", "iniLetter"};
    }

    public /* synthetic */ String[] _ebean_getPropertyNames() {
        return _ebean_props;
    }

    public /* synthetic */ String _ebean_getPropertyName(int pos) {
        return _ebean_props[pos];
    }

    public /* synthetic */ EntityBeanIntercept _ebean_getIntercept() {
        return this._ebean_intercept;
    }

    public /* synthetic */ EntityBeanIntercept _ebean_intercept() {
        if (this._ebean_intercept == null) {
            this._ebean_intercept = new EntityBeanIntercept((Object)this);
        }
        return this._ebean_intercept;
    }

    protected /* synthetic */ Integer _ebean_get_id() {
        this._ebean_intercept.preGetId();
        return this.id;
    }

    protected /* synthetic */ void _ebean_set_id(Integer newValue) {
        this._ebean_intercept.preSetter(false, 0, (Object)this.id, (Object)newValue);
        this.id = newValue;
    }

    protected /* synthetic */ Integer _ebean_getni_id() {
        return this.id;
    }

    protected /* synthetic */ void _ebean_setni_id(Integer _newValue) {
        this.id = _newValue;
        this._ebean_intercept.setLoadedProperty(0);
    }

    protected /* synthetic */ BankSettings _ebean_get_bank() {
        this._ebean_intercept.preGetter(1);
        return this.bank;
    }

    protected /* synthetic */ void _ebean_set_bank(BankSettings newValue) {
        this._ebean_intercept.preSetter(true, 1, (Object)this._ebean_get_bank(), (Object)newValue);
        this.bank = newValue;
    }

    protected /* synthetic */ BankSettings _ebean_getni_bank() {
        return this.bank;
    }

    protected /* synthetic */ void _ebean_setni_bank(BankSettings _newValue) {
        this.bank = _newValue;
        this._ebean_intercept.setLoadedProperty(1);
    }

    protected /* synthetic */ User _ebean_get_user() {
        this._ebean_intercept.preGetter(2);
        return this.user;
    }

    protected /* synthetic */ void _ebean_set_user(User newValue) {
        this._ebean_intercept.preSetter(true, 2, (Object)this._ebean_get_user(), (Object)newValue);
        this.user = newValue;
    }

    protected /* synthetic */ User _ebean_getni_user() {
        return this.user;
    }

    protected /* synthetic */ void _ebean_setni_user(User _newValue) {
        this.user = _newValue;
        this._ebean_intercept.setLoadedProperty(2);
    }

    protected /* synthetic */ String _ebean_get_defaultUser() {
        this._ebean_intercept.preGetter(3);
        return this.defaultUser;
    }

    protected /* synthetic */ void _ebean_set_defaultUser(String newValue) {
        this._ebean_intercept.preSetter(true, 3, (Object)this._ebean_get_defaultUser(), (Object)newValue);
        this.defaultUser = newValue;
    }

    protected /* synthetic */ String _ebean_getni_defaultUser() {
        return this.defaultUser;
    }

    protected /* synthetic */ void _ebean_setni_defaultUser(String _newValue) {
        this.defaultUser = _newValue;
        this._ebean_intercept.setLoadedProperty(3);
    }

    protected /* synthetic */ String _ebean_get_orderNumber() {
        this._ebean_intercept.preGetter(4);
        return this.orderNumber;
    }

    protected /* synthetic */ void _ebean_set_orderNumber(String newValue) {
        this._ebean_intercept.preSetter(true, 4, (Object)this._ebean_get_orderNumber(), (Object)newValue);
        this.orderNumber = newValue;
    }

    protected /* synthetic */ String _ebean_getni_orderNumber() {
        return this.orderNumber;
    }

    protected /* synthetic */ void _ebean_setni_orderNumber(String _newValue) {
        this.orderNumber = _newValue;
        this._ebean_intercept.setLoadedProperty(4);
    }

    protected /* synthetic */ boolean _ebean_get_withCerts() {
        this._ebean_intercept.preGetter(5);
        return this.withCerts;
    }

    protected /* synthetic */ void _ebean_set_withCerts(boolean newValue) {
        this._ebean_intercept.preSetter(true, 5, this._ebean_get_withCerts(), newValue);
        this.withCerts = newValue;
    }

    protected /* synthetic */ boolean _ebean_getni_withCerts() {
        return this.withCerts;
    }

    protected /* synthetic */ void _ebean_setni_withCerts(boolean _newValue) {
        this.withCerts = _newValue;
        this._ebean_intercept.setLoadedProperty(5);
    }

    protected /* synthetic */ UserState _ebean_get_state() {
        this._ebean_intercept.preGetter(6);
        return this.state;
    }

    protected /* synthetic */ void _ebean_set_state(UserState newValue) {
        this._ebean_intercept.preSetter(true, 6, (Object)this._ebean_get_state(), (Object)newValue);
        this.state = newValue;
    }

    protected /* synthetic */ UserState _ebean_getni_state() {
        return this.state;
    }

    protected /* synthetic */ void _ebean_setni_state(UserState _newValue) {
        this.state = _newValue;
        this._ebean_intercept.setLoadedProperty(6);
    }

    protected /* synthetic */ boolean _ebean_get_deactivated() {
        this._ebean_intercept.preGetter(7);
        return this.deactivated;
    }

    protected /* synthetic */ void _ebean_set_deactivated(boolean newValue) {
        this._ebean_intercept.preSetter(true, 7, this._ebean_get_deactivated(), newValue);
        this.deactivated = newValue;
    }

    protected /* synthetic */ boolean _ebean_getni_deactivated() {
        return this.deactivated;
    }

    protected /* synthetic */ void _ebean_setni_deactivated(boolean _newValue) {
        this.deactivated = _newValue;
        this._ebean_intercept.setLoadedProperty(7);
    }

    protected /* synthetic */ boolean _ebean_get_wssActivated() {
        this._ebean_intercept.preGetter(8);
        return this.wssActivated;
    }

    protected /* synthetic */ void _ebean_set_wssActivated(boolean newValue) {
        this._ebean_intercept.preSetter(true, 8, this._ebean_get_wssActivated(), newValue);
        this.wssActivated = newValue;
    }

    protected /* synthetic */ boolean _ebean_getni_wssActivated() {
        return this.wssActivated;
    }

    protected /* synthetic */ void _ebean_setni_wssActivated(boolean _newValue) {
        this.wssActivated = _newValue;
        this._ebean_intercept.setLoadedProperty(8);
    }

    protected /* synthetic */ String _ebean_get_signatureVersion() {
        this._ebean_intercept.preGetter(9);
        return this.signatureVersion;
    }

    protected /* synthetic */ void _ebean_set_signatureVersion(String newValue) {
        this._ebean_intercept.preSetter(true, 9, (Object)this._ebean_get_signatureVersion(), (Object)newValue);
        this.signatureVersion = newValue;
    }

    protected /* synthetic */ String _ebean_getni_signatureVersion() {
        return this.signatureVersion;
    }

    protected /* synthetic */ void _ebean_setni_signatureVersion(String _newValue) {
        this.signatureVersion = _newValue;
        this._ebean_intercept.setLoadedProperty(9);
    }

    protected /* synthetic */ Integer _ebean_get_sigKeyLength() {
        this._ebean_intercept.preGetter(10);
        return this.sigKeyLength;
    }

    protected /* synthetic */ void _ebean_set_sigKeyLength(Integer newValue) {
        this._ebean_intercept.preSetter(true, 10, (Object)this._ebean_get_sigKeyLength(), (Object)newValue);
        this.sigKeyLength = newValue;
    }

    protected /* synthetic */ Integer _ebean_getni_sigKeyLength() {
        return this.sigKeyLength;
    }

    protected /* synthetic */ void _ebean_setni_sigKeyLength(Integer _newValue) {
        this.sigKeyLength = _newValue;
        this._ebean_intercept.setLoadedProperty(10);
    }

    protected /* synthetic */ Integer _ebean_get_authKeyLength() {
        this._ebean_intercept.preGetter(11);
        return this.authKeyLength;
    }

    protected /* synthetic */ void _ebean_set_authKeyLength(Integer newValue) {
        this._ebean_intercept.preSetter(true, 11, (Object)this._ebean_get_authKeyLength(), (Object)newValue);
        this.authKeyLength = newValue;
    }

    protected /* synthetic */ Integer _ebean_getni_authKeyLength() {
        return this.authKeyLength;
    }

    protected /* synthetic */ void _ebean_setni_authKeyLength(Integer _newValue) {
        this.authKeyLength = _newValue;
        this._ebean_intercept.setLoadedProperty(11);
    }

    protected /* synthetic */ Integer _ebean_get_encrKeyLength() {
        this._ebean_intercept.preGetter(12);
        return this.encrKeyLength;
    }

    protected /* synthetic */ void _ebean_set_encrKeyLength(Integer newValue) {
        this._ebean_intercept.preSetter(true, 12, (Object)this._ebean_get_encrKeyLength(), (Object)newValue);
        this.encrKeyLength = newValue;
    }

    protected /* synthetic */ Integer _ebean_getni_encrKeyLength() {
        return this.encrKeyLength;
    }

    protected /* synthetic */ void _ebean_setni_encrKeyLength(Integer _newValue) {
        this.encrKeyLength = _newValue;
        this._ebean_intercept.setLoadedProperty(12);
    }

    protected /* synthetic */ Integer _ebean_get_dtausReferenceNumber() {
        this._ebean_intercept.preGetter(13);
        return this.dtausReferenceNumber;
    }

    protected /* synthetic */ void _ebean_set_dtausReferenceNumber(Integer newValue) {
        this._ebean_intercept.preSetter(true, 13, (Object)this._ebean_get_dtausReferenceNumber(), (Object)newValue);
        this.dtausReferenceNumber = newValue;
    }

    protected /* synthetic */ Integer _ebean_getni_dtausReferenceNumber() {
        return this.dtausReferenceNumber;
    }

    protected /* synthetic */ void _ebean_setni_dtausReferenceNumber(Integer _newValue) {
        this.dtausReferenceNumber = _newValue;
        this._ebean_intercept.setLoadedProperty(13);
    }

    protected /* synthetic */ Integer _ebean_get_bundesbankFileNumber() {
        this._ebean_intercept.preGetter(14);
        return this.bundesbankFileNumber;
    }

    protected /* synthetic */ void _ebean_set_bundesbankFileNumber(Integer newValue) {
        this._ebean_intercept.preSetter(true, 14, (Object)this._ebean_get_bundesbankFileNumber(), (Object)newValue);
        this.bundesbankFileNumber = newValue;
    }

    protected /* synthetic */ Integer _ebean_getni_bundesbankFileNumber() {
        return this.bundesbankFileNumber;
    }

    protected /* synthetic */ void _ebean_setni_bundesbankFileNumber(Integer _newValue) {
        this.bundesbankFileNumber = _newValue;
        this._ebean_intercept.setLoadedProperty(14);
    }

    protected /* synthetic */ Integer _ebean_get_sepaMessageId() {
        this._ebean_intercept.preGetter(15);
        return this.sepaMessageId;
    }

    protected /* synthetic */ void _ebean_set_sepaMessageId(Integer newValue) {
        this._ebean_intercept.preSetter(true, 15, (Object)this._ebean_get_sepaMessageId(), (Object)newValue);
        this.sepaMessageId = newValue;
    }

    protected /* synthetic */ Integer _ebean_getni_sepaMessageId() {
        return this.sepaMessageId;
    }

    protected /* synthetic */ void _ebean_setni_sepaMessageId(Integer _newValue) {
        this.sepaMessageId = _newValue;
        this._ebean_intercept.setLoadedProperty(15);
    }

    protected /* synthetic */ Integer _ebean_get_mt101SenderReference() {
        this._ebean_intercept.preGetter(16);
        return this.mt101SenderReference;
    }

    protected /* synthetic */ void _ebean_set_mt101SenderReference(Integer newValue) {
        this._ebean_intercept.preSetter(true, 16, (Object)this._ebean_get_mt101SenderReference(), (Object)newValue);
        this.mt101SenderReference = newValue;
    }

    protected /* synthetic */ Integer _ebean_getni_mt101SenderReference() {
        return this.mt101SenderReference;
    }

    protected /* synthetic */ void _ebean_setni_mt101SenderReference(Integer _newValue) {
        this.mt101SenderReference = _newValue;
        this._ebean_intercept.setLoadedProperty(16);
    }

    protected /* synthetic */ byte[] _ebean_get_encrKey() {
        this._ebean_intercept.preGetter(17);
        return this.encrKey;
    }

    protected /* synthetic */ void _ebean_set_encrKey(byte[] newValue) {
        this._ebean_intercept.preSetter(true, 17, this._ebean_get_encrKey(), newValue);
        this.encrKey = newValue;
    }

    protected /* synthetic */ byte[] _ebean_getni_encrKey() {
        return this.encrKey;
    }

    protected /* synthetic */ void _ebean_setni_encrKey(byte[] _newValue) {
        this.encrKey = _newValue;
        this._ebean_intercept.setLoadedProperty(17);
    }

    protected /* synthetic */ byte[] _ebean_get_encrCert() {
        this._ebean_intercept.preGetter(18);
        return this.encrCert;
    }

    protected /* synthetic */ void _ebean_set_encrCert(byte[] newValue) {
        this._ebean_intercept.preSetter(true, 18, this._ebean_get_encrCert(), newValue);
        this.encrCert = newValue;
    }

    protected /* synthetic */ byte[] _ebean_getni_encrCert() {
        return this.encrCert;
    }

    protected /* synthetic */ void _ebean_setni_encrCert(byte[] _newValue) {
        this.encrCert = _newValue;
        this._ebean_intercept.setLoadedProperty(18);
    }

    protected /* synthetic */ byte[] _ebean_get_authKey() {
        this._ebean_intercept.preGetter(19);
        return this.authKey;
    }

    protected /* synthetic */ void _ebean_set_authKey(byte[] newValue) {
        this._ebean_intercept.preSetter(true, 19, this._ebean_get_authKey(), newValue);
        this.authKey = newValue;
    }

    protected /* synthetic */ byte[] _ebean_getni_authKey() {
        return this.authKey;
    }

    protected /* synthetic */ void _ebean_setni_authKey(byte[] _newValue) {
        this.authKey = _newValue;
        this._ebean_intercept.setLoadedProperty(19);
    }

    protected /* synthetic */ byte[] _ebean_get_authCert() {
        this._ebean_intercept.preGetter(20);
        return this.authCert;
    }

    protected /* synthetic */ void _ebean_set_authCert(byte[] newValue) {
        this._ebean_intercept.preSetter(true, 20, this._ebean_get_authCert(), newValue);
        this.authCert = newValue;
    }

    protected /* synthetic */ byte[] _ebean_getni_authCert() {
        return this.authCert;
    }

    protected /* synthetic */ void _ebean_setni_authCert(byte[] _newValue) {
        this.authCert = _newValue;
        this._ebean_intercept.setLoadedProperty(20);
    }

    protected /* synthetic */ byte[] _ebean_get_sigKey() {
        this._ebean_intercept.preGetter(21);
        return this.sigKey;
    }

    protected /* synthetic */ void _ebean_set_sigKey(byte[] newValue) {
        this._ebean_intercept.preSetter(true, 21, this._ebean_get_sigKey(), newValue);
        this.sigKey = newValue;
    }

    protected /* synthetic */ byte[] _ebean_getni_sigKey() {
        return this.sigKey;
    }

    protected /* synthetic */ void _ebean_setni_sigKey(byte[] _newValue) {
        this.sigKey = _newValue;
        this._ebean_intercept.setLoadedProperty(21);
    }

    protected /* synthetic */ byte[] _ebean_get_sigCert() {
        this._ebean_intercept.preGetter(22);
        return this.sigCert;
    }

    protected /* synthetic */ void _ebean_set_sigCert(byte[] newValue) {
        this._ebean_intercept.preSetter(true, 22, this._ebean_get_sigCert(), newValue);
        this.sigCert = newValue;
    }

    protected /* synthetic */ byte[] _ebean_getni_sigCert() {
        return this.sigCert;
    }

    protected /* synthetic */ void _ebean_setni_sigCert(byte[] _newValue) {
        this.sigCert = _newValue;
        this._ebean_intercept.setLoadedProperty(22);
    }

    protected /* synthetic */ byte[] _ebean_get_lockUserSignature() {
        this._ebean_intercept.preGetter(23);
        return this.lockUserSignature;
    }

    protected /* synthetic */ void _ebean_set_lockUserSignature(byte[] newValue) {
        this._ebean_intercept.preSetter(true, 23, this._ebean_get_lockUserSignature(), newValue);
        this.lockUserSignature = newValue;
    }

    protected /* synthetic */ byte[] _ebean_getni_lockUserSignature() {
        return this.lockUserSignature;
    }

    protected /* synthetic */ void _ebean_setni_lockUserSignature(byte[] _newValue) {
        this.lockUserSignature = _newValue;
        this._ebean_intercept.setLoadedProperty(23);
    }

    protected /* synthetic */ byte[] _ebean_get_iniLetter() {
        this._ebean_intercept.preGetter(24);
        return this.iniLetter;
    }

    protected /* synthetic */ void _ebean_set_iniLetter(byte[] newValue) {
        this._ebean_intercept.preSetter(true, 24, this._ebean_get_iniLetter(), newValue);
        this.iniLetter = newValue;
    }

    protected /* synthetic */ byte[] _ebean_getni_iniLetter() {
        return this.iniLetter;
    }

    protected /* synthetic */ void _ebean_setni_iniLetter(byte[] _newValue) {
        this.iniLetter = _newValue;
        this._ebean_intercept.setLoadedProperty(24);
    }

    public /* synthetic */ Object _ebean_getField(int index) {
        switch (index) {
            case 0: {
                return this.id;
            }
            case 1: {
                return this.bank;
            }
            case 2: {
                return this.user;
            }
            case 3: {
                return this.defaultUser;
            }
            case 4: {
                return this.orderNumber;
            }
            case 5: {
                return this.withCerts;
            }
            case 6: {
                return this.state;
            }
            case 7: {
                return this.deactivated;
            }
            case 8: {
                return this.wssActivated;
            }
            case 9: {
                return this.signatureVersion;
            }
            case 10: {
                return this.sigKeyLength;
            }
            case 11: {
                return this.authKeyLength;
            }
            case 12: {
                return this.encrKeyLength;
            }
            case 13: {
                return this.dtausReferenceNumber;
            }
            case 14: {
                return this.bundesbankFileNumber;
            }
            case 15: {
                return this.sepaMessageId;
            }
            case 16: {
                return this.mt101SenderReference;
            }
            case 17: {
                return this.encrKey;
            }
            case 18: {
                return this.encrCert;
            }
            case 19: {
                return this.authKey;
            }
            case 20: {
                return this.authCert;
            }
            case 21: {
                return this.sigKey;
            }
            case 22: {
                return this.sigCert;
            }
            case 23: {
                return this.lockUserSignature;
            }
            case 24: {
                return this.iniLetter;
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    public /* synthetic */ Object _ebean_getFieldIntercept(int index) {
        switch (index) {
            case 0: {
                return this._ebean_get_id();
            }
            case 1: {
                return this._ebean_get_bank();
            }
            case 2: {
                return this._ebean_get_user();
            }
            case 3: {
                return this._ebean_get_defaultUser();
            }
            case 4: {
                return this._ebean_get_orderNumber();
            }
            case 5: {
                return this._ebean_get_withCerts();
            }
            case 6: {
                return this._ebean_get_state();
            }
            case 7: {
                return this._ebean_get_deactivated();
            }
            case 8: {
                return this._ebean_get_wssActivated();
            }
            case 9: {
                return this._ebean_get_signatureVersion();
            }
            case 10: {
                return this._ebean_get_sigKeyLength();
            }
            case 11: {
                return this._ebean_get_authKeyLength();
            }
            case 12: {
                return this._ebean_get_encrKeyLength();
            }
            case 13: {
                return this._ebean_get_dtausReferenceNumber();
            }
            case 14: {
                return this._ebean_get_bundesbankFileNumber();
            }
            case 15: {
                return this._ebean_get_sepaMessageId();
            }
            case 16: {
                return this._ebean_get_mt101SenderReference();
            }
            case 17: {
                return this._ebean_get_encrKey();
            }
            case 18: {
                return this._ebean_get_encrCert();
            }
            case 19: {
                return this._ebean_get_authKey();
            }
            case 20: {
                return this._ebean_get_authCert();
            }
            case 21: {
                return this._ebean_get_sigKey();
            }
            case 22: {
                return this._ebean_get_sigCert();
            }
            case 23: {
                return this._ebean_get_lockUserSignature();
            }
            case 24: {
                return this._ebean_get_iniLetter();
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    public /* synthetic */ void _ebean_setField(int index, Object o) {
        switch (index) {
            case 0: {
                this._ebean_setni_id((Integer)o);
                return;
            }
            case 1: {
                this._ebean_setni_bank((BankSettings)o);
                return;
            }
            case 2: {
                this._ebean_setni_user((User)o);
                return;
            }
            case 3: {
                this._ebean_setni_defaultUser((String)o);
                return;
            }
            case 4: {
                this._ebean_setni_orderNumber((String)o);
                return;
            }
            case 5: {
                this._ebean_setni_withCerts((Boolean)o);
                return;
            }
            case 6: {
                this._ebean_setni_state((UserState)((Object)o));
                return;
            }
            case 7: {
                this._ebean_setni_deactivated((Boolean)o);
                return;
            }
            case 8: {
                this._ebean_setni_wssActivated((Boolean)o);
                return;
            }
            case 9: {
                this._ebean_setni_signatureVersion((String)o);
                return;
            }
            case 10: {
                this._ebean_setni_sigKeyLength((Integer)o);
                return;
            }
            case 11: {
                this._ebean_setni_authKeyLength((Integer)o);
                return;
            }
            case 12: {
                this._ebean_setni_encrKeyLength((Integer)o);
                return;
            }
            case 13: {
                this._ebean_setni_dtausReferenceNumber((Integer)o);
                return;
            }
            case 14: {
                this._ebean_setni_bundesbankFileNumber((Integer)o);
                return;
            }
            case 15: {
                this._ebean_setni_sepaMessageId((Integer)o);
                return;
            }
            case 16: {
                this._ebean_setni_mt101SenderReference((Integer)o);
                return;
            }
            case 17: {
                this._ebean_setni_encrKey((byte[])o);
                return;
            }
            case 18: {
                this._ebean_setni_encrCert((byte[])o);
                return;
            }
            case 19: {
                this._ebean_setni_authKey((byte[])o);
                return;
            }
            case 20: {
                this._ebean_setni_authCert((byte[])o);
                return;
            }
            case 21: {
                this._ebean_setni_sigKey((byte[])o);
                return;
            }
            case 22: {
                this._ebean_setni_sigCert((byte[])o);
                return;
            }
            case 23: {
                this._ebean_setni_lockUserSignature((byte[])o);
                return;
            }
            case 24: {
                this._ebean_setni_iniLetter((byte[])o);
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    public /* synthetic */ void _ebean_setFieldIntercept(int index, Object o) {
        switch (index) {
            case 0: {
                this._ebean_set_id((Integer)o);
                return;
            }
            case 1: {
                this._ebean_set_bank((BankSettings)o);
                return;
            }
            case 2: {
                this._ebean_set_user((User)o);
                return;
            }
            case 3: {
                this._ebean_set_defaultUser((String)o);
                return;
            }
            case 4: {
                this._ebean_set_orderNumber((String)o);
                return;
            }
            case 5: {
                this._ebean_set_withCerts((Boolean)o);
                return;
            }
            case 6: {
                this._ebean_set_state((UserState)((Object)o));
                return;
            }
            case 7: {
                this._ebean_set_deactivated((Boolean)o);
                return;
            }
            case 8: {
                this._ebean_set_wssActivated((Boolean)o);
                return;
            }
            case 9: {
                this._ebean_set_signatureVersion((String)o);
                return;
            }
            case 10: {
                this._ebean_set_sigKeyLength((Integer)o);
                return;
            }
            case 11: {
                this._ebean_set_authKeyLength((Integer)o);
                return;
            }
            case 12: {
                this._ebean_set_encrKeyLength((Integer)o);
                return;
            }
            case 13: {
                this._ebean_set_dtausReferenceNumber((Integer)o);
                return;
            }
            case 14: {
                this._ebean_set_bundesbankFileNumber((Integer)o);
                return;
            }
            case 15: {
                this._ebean_set_sepaMessageId((Integer)o);
                return;
            }
            case 16: {
                this._ebean_set_mt101SenderReference((Integer)o);
                return;
            }
            case 17: {
                this._ebean_set_encrKey((byte[])o);
                return;
            }
            case 18: {
                this._ebean_set_encrCert((byte[])o);
                return;
            }
            case 19: {
                this._ebean_set_authKey((byte[])o);
                return;
            }
            case 20: {
                this._ebean_set_authCert((byte[])o);
                return;
            }
            case 21: {
                this._ebean_set_sigKey((byte[])o);
                return;
            }
            case 22: {
                this._ebean_set_sigCert((byte[])o);
                return;
            }
            case 23: {
                this._ebean_set_lockUserSignature((byte[])o);
                return;
            }
            case 24: {
                this._ebean_set_iniLetter((byte[])o);
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private /* synthetic */ Object _ebean_getIdentity() {
        BankUser bankUser = this;
        synchronized (bankUser) {
            if (this._ebean_identity != null) {
                return this._ebean_identity;
            }
            Object tmpId = this._ebean_getField(0);
            this._ebean_identity = tmpId != null ? tmpId : new Object();
            return this._ebean_identity;
        }
    }

    public /* synthetic */ boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        return this._ebean_getIdentity().equals(((BankUser)obj)._ebean_getIdentity());
    }

    public /* synthetic */ int hashCode() {
        return this._ebean_getIdentity().hashCode();
    }

    public /* synthetic */ void _ebean_setEmbeddedLoaded() {
    }

    public /* synthetic */ boolean _ebean_isEmbeddedNewOrDirty() {
        return false;
    }

    public /* synthetic */ Object _ebean_newInstance() {
        return new BankUser();
    }

    public static enum UserState {
        CREATED,
        READY,
        LOCKED,
        NOT_USED,
        USED_NO_INI,
        KEY_CHANGE_REQUIRED;

    }
}

