/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.database.vo;

import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.BankUser;
import de.businesslogics.banking.database.vo.RSAPublicKey;
import de.businesslogics.banking.database.vo.Tenant;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.persistence.DBType;
import io.ebean.Expr;
import io.ebean.ExpressionList;
import io.ebean.Junction;
import io.ebean.Query;
import io.ebean.bean.EntityBean;
import io.ebean.bean.EntityBeanIntercept;
import io.ebean.common.BeanList;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;

@Entity
@Table(name="bank")
public class BankSettings
implements EntityBean {
    public static DBType DATABASE_TYPE;
    @Column(name="id", nullable=false)
    @Id
    private Integer bankId;
    @Column(name="display_name", nullable=false, length=64)
    private String displayName;
    @Column(name="icon", length=128)
    private String icon;
    @Column(name="country", length=2)
    private String countryCode;
    @Column(name="url", nullable=false, length=256)
    private String url;
    @Column(name="prot_version", nullable=false, length=4)
    private String protocolVersion;
    @Column(name="host_id", nullable=false, length=35)
    private String hostId;
    @Column(name="customer_id", nullable=false, length=35)
    private String customerId;
    @Column(name="hpd_time")
    private Timestamp bankParametersTime;
    @Column(name="hpd")
    @Lob
    private byte[] bankParameters;
    @ManyToOne
    @JoinColumn(name="e001key_id")
    private RSAPublicKey e001Key;
    @ManyToOne
    @JoinColumn(name="e002key_id")
    private RSAPublicKey e002Key;
    @ManyToOne
    @JoinColumn(name="x001key_id")
    private RSAPublicKey x001Key;
    @ManyToOne
    @JoinColumn(name="x002key_id")
    private RSAPublicKey x002Key;
    @Column(length=40)
    private String expectedDigestE001;
    @Column(length=40)
    private String expectedDigestX001;
    @Column(length=64)
    private String expectedDigestE002;
    @Column(length=64)
    private String expectedDigestX002;
    private Integer dtazvNumber;
    private Boolean transferSystem;
    private Boolean transportOnly;
    private Boolean useHCA_PUB;
    private String wssFetchType;
    private boolean vopActivated;
    private boolean vopMandatory;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="bank")
    private List<BankUser> users;
    @ManyToOne(optional=false)
    private Tenant tenant;
    public static /* synthetic */ String[] _ebean_props;
    protected /* synthetic */ EntityBeanIntercept _ebean_intercept;
    protected transient /* synthetic */ Object _ebean_identity;

    public BankSettings() {
        this._ebean_intercept = new EntityBeanIntercept((Object)this);
        this._ebean_set_dtazvNumber(1);
        this._ebean_set_vopActivated(true);
        this._ebean_set_vopMandatory(true);
    }

    public static void updateSequence(Integer maxId) {
        if (DBType.H2.equals((Object)DATABASE_TYPE) || DBType.ORACLE.equals((Object)DATABASE_TYPE)) {
            DB.sqlUpdate("DROP SEQUENCE bank_seq").execute();
            DB.sqlUpdate("CREATE SEQUENCE bank_seq START WITH " + (maxId + 1)).execute();
        }
    }

    public static List<BankSettings> findByCustomer(String url, String hostId, String customerId, Tenant tenant) {
        return DB.find(BankSettings.class).where().eq("tenant", (Object)tenant).or(Expr.eq((String)"url", (Object)BankSettings.getUrlWithTrailingSlash(url)), Expr.eq((String)"url", (Object)BankSettings.getUrlWithoutTrailingSlash(url))).eq("hostId", (Object)hostId).eq("customerId", (Object)customerId).findList();
    }

    public static List<BankSettings> findByCustomerPrefixes(String url, String hostId, String[] customerPrefixes, List<Tenant> tenants) {
        ExpressionList exprList = DB.find(BankSettings.class).where().or(Expr.eq((String)"url", (Object)BankSettings.getUrlWithTrailingSlash(url)), Expr.eq((String)"url", (Object)BankSettings.getUrlWithoutTrailingSlash(url))).eq("hostId", (Object)hostId);
        if (tenants != null) {
            exprList.in("tenant", tenants);
        }
        if (customerPrefixes != null) {
            if (customerPrefixes.length == 1) {
                exprList.startsWith("customerId", customerPrefixes[0]);
            } else if (customerPrefixes.length > 1) {
                Junction j = exprList.disjunction();
                for (String customerPrefix : customerPrefixes) {
                    j.add(Expr.startsWith((String)"customerId", (String)customerPrefix));
                }
            }
        }
        return exprList.findList();
    }

    public static BankSettings getById(Integer id) {
        return DB.find(BankSettings.class, id);
    }

    public static BankSettings getByIdAndUser(Integer id, User user) {
        return (BankSettings)DB.find(BankSettings.class).where().eq("bankId", (Object)id).eq("users.user", (Object)user).findOne();
    }

    public static List<BankSettings> findByIdAndUser(Collection<Integer> ids, User user) {
        return DB.find(BankSettings.class).where().in("bankId", ids).eq("users.user", (Object)user).findList();
    }

    public static BankSettings getByIdForManagedTenants(Integer id, User user) {
        return (BankSettings)DB.find(BankSettings.class).where().eq("bankId", (Object)id).in("tenant", user.getManagedTenants()).findOne();
    }

    public static List<BankSettings> findBanksForUser(User user) {
        return DB.find(BankSettings.class).where().eq("users.user", (Object)user).order("displayName ASC").findList();
    }

    public static List<BankSettings> findBanksForPaymentImport(User user) {
        ArrayList<BankSettings> banks = new ArrayList<BankSettings>();
        for (BankUser bankUser : BankUser.findBanksForPaymentImport(user)) {
            banks.add(bankUser.getBank());
        }
        return banks;
    }

    public static List<BankSettings> findBanksForTenants(List<Tenant> tenants) {
        Query<BankSettings> query = DB.find(BankSettings.class);
        if (tenants != null) {
            query.where().in("tenant", tenants);
        }
        return query.order("displayName ASC").findList();
    }

    public static int findBankCount() {
        return DB.find(BankSettings.class).findCount();
    }

    public static boolean isInitialized(User user, BankSettings bank) {
        if (user.isLocalUser()) {
            return false;
        }
        BankUser bankUser = BankUser.findBankUser(bank, user);
        return bankUser != null && !BankUser.UserState.NOT_USED.equals((Object)bankUser.getState());
    }

    public static String getUrlWithTrailingSlash(String url) {
        boolean hasTrailingSlash = url.endsWith("/");
        if (hasTrailingSlash) {
            return url;
        }
        return url + "/";
    }

    public static String getUrlWithoutTrailingSlash(String url) {
        boolean hasTrailingSlash = url.endsWith("/");
        if (hasTrailingSlash) {
            return url.substring(0, url.length() - 1);
        }
        return url;
    }

    public Integer getBankId() {
        return this._ebean_get_bankId();
    }

    public String getUniqueKey() {
        return String.valueOf(this.getBankId() - 1);
    }

    public void setBankId(Integer bankId) {
        this._ebean_set_bankId(bankId);
    }

    public String getDisplayName() {
        return this._ebean_get_displayName();
    }

    public void setDisplayName(String displayName) {
        this._ebean_set_displayName(this.checkLength(displayName, 64));
    }

    public String getIcon() {
        return this._ebean_get_icon();
    }

    public void setIcon(String icon) {
        this._ebean_set_icon(this.checkLength(icon, 128));
    }

    public String getCountryCode() {
        return this._ebean_get_countryCode();
    }

    public void setCountryCode(String countryCode) {
        this._ebean_set_countryCode(countryCode);
    }

    public String getUrl() {
        return this._ebean_get_url();
    }

    public void setUrl(String url) {
        this._ebean_set_url(this.checkLength(url, 256));
    }

    public String getProtocolVersion() {
        return this._ebean_get_protocolVersion();
    }

    public void setProtocolVersion(String protocolVersion) {
        this._ebean_set_protocolVersion(this.checkLength(protocolVersion, 4));
    }

    public String getHostId() {
        return this._ebean_get_hostId();
    }

    public void setHostId(String hostId) {
        this._ebean_set_hostId(this.checkLength(hostId, 35));
    }

    public String getCustomerId() {
        return this._ebean_get_customerId();
    }

    public void setCustomerId(String customerId) {
        this._ebean_set_customerId(this.checkLength(customerId, 35));
    }

    public Timestamp getBankParametersTime() {
        return this._ebean_get_bankParametersTime();
    }

    public void setBankParametersTime(Timestamp bankParametersTime) {
        this._ebean_set_bankParametersTime(bankParametersTime);
    }

    public byte[] getBankParameters() {
        return this._ebean_get_bankParameters();
    }

    public void setBankParameters(byte[] bankParameters) {
        this._ebean_set_bankParameters(bankParameters);
    }

    public RSAPublicKey getE001Key() {
        return this._ebean_get_e001Key();
    }

    public void setE001Key(RSAPublicKey e001Key) {
        this._ebean_set_e001Key(e001Key);
    }

    public RSAPublicKey getE002Key() {
        return this._ebean_get_e002Key();
    }

    public void setE002Key(RSAPublicKey e002Key) {
        this._ebean_set_e002Key(e002Key);
    }

    public RSAPublicKey getX001Key() {
        return this._ebean_get_x001Key();
    }

    public void setX001Key(RSAPublicKey x001Key) {
        this._ebean_set_x001Key(x001Key);
    }

    public RSAPublicKey getX002Key() {
        return this._ebean_get_x002Key();
    }

    public void setX002Key(RSAPublicKey x002Key) {
        this._ebean_set_x002Key(x002Key);
    }

    public String getExpectedDigestE001() {
        return this._ebean_get_expectedDigestE001();
    }

    public void setExpectedDigestE001(String expectedDigestE001) {
        this._ebean_set_expectedDigestE001(this.checkLength(expectedDigestE001, 40));
    }

    public String getExpectedDigestX001() {
        return this._ebean_get_expectedDigestX001();
    }

    public void setExpectedDigestX001(String expectedDigestX001) {
        this._ebean_set_expectedDigestX001(this.checkLength(expectedDigestX001, 40));
    }

    public String getExpectedDigestE002() {
        return this._ebean_get_expectedDigestE002();
    }

    public void setExpectedDigestE002(String expectedDigestE002) {
        this._ebean_set_expectedDigestE002(this.checkLength(expectedDigestE002, 64));
    }

    public String getExpectedDigestX002() {
        return this._ebean_get_expectedDigestX002();
    }

    public void setExpectedDigestX002(String expectedDigestX002) {
        this._ebean_set_expectedDigestX002(this.checkLength(expectedDigestX002, 64));
    }

    public Tenant getTenant() {
        return this._ebean_get_tenant();
    }

    public void setTenant(Tenant tenant) {
        this._ebean_set_tenant(tenant);
    }

    private String checkLength(String in, int length) {
        if (in != null && in.length() > length) {
            return in.substring(0, length);
        }
        return in;
    }

    public Integer getDtazvNumber() {
        return this._ebean_get_dtazvNumber();
    }

    public void setDtazvNumber(Integer dtazvNumber) {
        this._ebean_set_dtazvNumber(dtazvNumber);
    }

    public boolean isTransferSystem() {
        if (this._ebean_get_transferSystem() == null) {
            return false;
        }
        return this._ebean_get_transferSystem();
    }

    public Boolean getTransferSystem() {
        return this._ebean_get_transferSystem();
    }

    public void setTransferSystem(boolean transferSystem) {
        this._ebean_set_transferSystem(transferSystem);
    }

    public Boolean getTransportOnly() {
        return this._ebean_get_transportOnly();
    }

    public void setTransportOnly(boolean transportOnly) {
        this._ebean_set_transportOnly(transportOnly);
    }

    public boolean useHCA_PUB() {
        if (this._ebean_get_useHCA_PUB() == null) {
            return false;
        }
        return this._ebean_get_useHCA_PUB();
    }

    public void useHCA_PUB(boolean useHCA_PUB) {
        this._ebean_set_useHCA_PUB(useHCA_PUB);
    }

    public String getWssFetchType() {
        return this._ebean_get_wssFetchType();
    }

    public void setWssFetchType(String wssFetchType) {
        this._ebean_set_wssFetchType(wssFetchType);
    }

    public boolean isVopActivated() {
        return this._ebean_get_vopActivated();
    }

    public void setVopActivated(boolean vopActivated) {
        this._ebean_set_vopActivated(vopActivated);
    }

    public boolean isVopMandatory() {
        return this._ebean_get_vopMandatory();
    }

    public void setVopMandatory(boolean vopMandatory) {
        this._ebean_set_vopMandatory(vopMandatory);
    }

    public void save() {
        this.save(false);
    }

    public void save(boolean forceSave) {
        if (forceSave || this.getBankId() == null) {
            DB.save(this);
        } else {
            DB.update(this);
        }
    }

    public void delete() {
        DB.delete(this);
    }

    public boolean useCertsWithoutExpirationDate() {
        return !this.isFrenchBank();
    }

    public boolean isGermanBank() {
        return "DE".equalsIgnoreCase(this.getCountryCode());
    }

    public boolean isAustrianBank() {
        return "AT".equalsIgnoreCase(this.getCountryCode());
    }

    public boolean isSwissBank() {
        return "CH".equalsIgnoreCase(this.getCountryCode());
    }

    public boolean isFrenchBank() {
        return "FR".equalsIgnoreCase(this.getCountryCode());
    }

    static {
        _ebean_props = new String[]{"bankId", "displayName", "icon", "countryCode", "url", "protocolVersion", "hostId", "customerId", "bankParametersTime", "bankParameters", "e001Key", "e002Key", "x001Key", "x002Key", "expectedDigestE001", "expectedDigestX001", "expectedDigestE002", "expectedDigestX002", "dtazvNumber", "transferSystem", "transportOnly", "useHCA_PUB", "wssFetchType", "vopActivated", "vopMandatory", "users", "tenant"};
        DATABASE_TYPE = null;
    }

    public /* synthetic */ String[] _ebean_getPropertyNames() {
        return _ebean_props;
    }

    public /* synthetic */ String _ebean_getPropertyName(int pos) {
        return _ebean_props[pos];
    }

    public /* synthetic */ EntityBeanIntercept _ebean_getIntercept() {
        return this._ebean_intercept;
    }

    public /* synthetic */ EntityBeanIntercept _ebean_intercept() {
        if (this._ebean_intercept == null) {
            this._ebean_intercept = new EntityBeanIntercept((Object)this);
        }
        return this._ebean_intercept;
    }

    protected /* synthetic */ Integer _ebean_get_bankId() {
        this._ebean_intercept.preGetId();
        return this.bankId;
    }

    protected /* synthetic */ void _ebean_set_bankId(Integer newValue) {
        this._ebean_intercept.preSetter(false, 0, (Object)this.bankId, (Object)newValue);
        this.bankId = newValue;
    }

    protected /* synthetic */ Integer _ebean_getni_bankId() {
        return this.bankId;
    }

    protected /* synthetic */ void _ebean_setni_bankId(Integer _newValue) {
        this.bankId = _newValue;
        this._ebean_intercept.setLoadedProperty(0);
    }

    protected /* synthetic */ String _ebean_get_displayName() {
        this._ebean_intercept.preGetter(1);
        return this.displayName;
    }

    protected /* synthetic */ void _ebean_set_displayName(String newValue) {
        this._ebean_intercept.preSetter(true, 1, (Object)this._ebean_get_displayName(), (Object)newValue);
        this.displayName = newValue;
    }

    protected /* synthetic */ String _ebean_getni_displayName() {
        return this.displayName;
    }

    protected /* synthetic */ void _ebean_setni_displayName(String _newValue) {
        this.displayName = _newValue;
        this._ebean_intercept.setLoadedProperty(1);
    }

    protected /* synthetic */ String _ebean_get_icon() {
        this._ebean_intercept.preGetter(2);
        return this.icon;
    }

    protected /* synthetic */ void _ebean_set_icon(String newValue) {
        this._ebean_intercept.preSetter(true, 2, (Object)this._ebean_get_icon(), (Object)newValue);
        this.icon = newValue;
    }

    protected /* synthetic */ String _ebean_getni_icon() {
        return this.icon;
    }

    protected /* synthetic */ void _ebean_setni_icon(String _newValue) {
        this.icon = _newValue;
        this._ebean_intercept.setLoadedProperty(2);
    }

    protected /* synthetic */ String _ebean_get_countryCode() {
        this._ebean_intercept.preGetter(3);
        return this.countryCode;
    }

    protected /* synthetic */ void _ebean_set_countryCode(String newValue) {
        this._ebean_intercept.preSetter(true, 3, (Object)this._ebean_get_countryCode(), (Object)newValue);
        this.countryCode = newValue;
    }

    protected /* synthetic */ String _ebean_getni_countryCode() {
        return this.countryCode;
    }

    protected /* synthetic */ void _ebean_setni_countryCode(String _newValue) {
        this.countryCode = _newValue;
        this._ebean_intercept.setLoadedProperty(3);
    }

    protected /* synthetic */ String _ebean_get_url() {
        this._ebean_intercept.preGetter(4);
        return this.url;
    }

    protected /* synthetic */ void _ebean_set_url(String newValue) {
        this._ebean_intercept.preSetter(true, 4, (Object)this._ebean_get_url(), (Object)newValue);
        this.url = newValue;
    }

    protected /* synthetic */ String _ebean_getni_url() {
        return this.url;
    }

    protected /* synthetic */ void _ebean_setni_url(String _newValue) {
        this.url = _newValue;
        this._ebean_intercept.setLoadedProperty(4);
    }

    protected /* synthetic */ String _ebean_get_protocolVersion() {
        this._ebean_intercept.preGetter(5);
        return this.protocolVersion;
    }

    protected /* synthetic */ void _ebean_set_protocolVersion(String newValue) {
        this._ebean_intercept.preSetter(true, 5, (Object)this._ebean_get_protocolVersion(), (Object)newValue);
        this.protocolVersion = newValue;
    }

    protected /* synthetic */ String _ebean_getni_protocolVersion() {
        return this.protocolVersion;
    }

    protected /* synthetic */ void _ebean_setni_protocolVersion(String _newValue) {
        this.protocolVersion = _newValue;
        this._ebean_intercept.setLoadedProperty(5);
    }

    protected /* synthetic */ String _ebean_get_hostId() {
        this._ebean_intercept.preGetter(6);
        return this.hostId;
    }

    protected /* synthetic */ void _ebean_set_hostId(String newValue) {
        this._ebean_intercept.preSetter(true, 6, (Object)this._ebean_get_hostId(), (Object)newValue);
        this.hostId = newValue;
    }

    protected /* synthetic */ String _ebean_getni_hostId() {
        return this.hostId;
    }

    protected /* synthetic */ void _ebean_setni_hostId(String _newValue) {
        this.hostId = _newValue;
        this._ebean_intercept.setLoadedProperty(6);
    }

    protected /* synthetic */ String _ebean_get_customerId() {
        this._ebean_intercept.preGetter(7);
        return this.customerId;
    }

    protected /* synthetic */ void _ebean_set_customerId(String newValue) {
        this._ebean_intercept.preSetter(true, 7, (Object)this._ebean_get_customerId(), (Object)newValue);
        this.customerId = newValue;
    }

    protected /* synthetic */ String _ebean_getni_customerId() {
        return this.customerId;
    }

    protected /* synthetic */ void _ebean_setni_customerId(String _newValue) {
        this.customerId = _newValue;
        this._ebean_intercept.setLoadedProperty(7);
    }

    protected /* synthetic */ Timestamp _ebean_get_bankParametersTime() {
        this._ebean_intercept.preGetter(8);
        return this.bankParametersTime;
    }

    protected /* synthetic */ void _ebean_set_bankParametersTime(Timestamp newValue) {
        this._ebean_intercept.preSetter(true, 8, (Object)this._ebean_get_bankParametersTime(), (Object)newValue);
        this.bankParametersTime = newValue;
    }

    protected /* synthetic */ Timestamp _ebean_getni_bankParametersTime() {
        return this.bankParametersTime;
    }

    protected /* synthetic */ void _ebean_setni_bankParametersTime(Timestamp _newValue) {
        this.bankParametersTime = _newValue;
        this._ebean_intercept.setLoadedProperty(8);
    }

    protected /* synthetic */ byte[] _ebean_get_bankParameters() {
        this._ebean_intercept.preGetter(9);
        return this.bankParameters;
    }

    protected /* synthetic */ void _ebean_set_bankParameters(byte[] newValue) {
        this._ebean_intercept.preSetter(true, 9, this._ebean_get_bankParameters(), newValue);
        this.bankParameters = newValue;
    }

    protected /* synthetic */ byte[] _ebean_getni_bankParameters() {
        return this.bankParameters;
    }

    protected /* synthetic */ void _ebean_setni_bankParameters(byte[] _newValue) {
        this.bankParameters = _newValue;
        this._ebean_intercept.setLoadedProperty(9);
    }

    protected /* synthetic */ RSAPublicKey _ebean_get_e001Key() {
        this._ebean_intercept.preGetter(10);
        return this.e001Key;
    }

    protected /* synthetic */ void _ebean_set_e001Key(RSAPublicKey newValue) {
        this._ebean_intercept.preSetter(true, 10, (Object)this._ebean_get_e001Key(), (Object)newValue);
        this.e001Key = newValue;
    }

    protected /* synthetic */ RSAPublicKey _ebean_getni_e001Key() {
        return this.e001Key;
    }

    protected /* synthetic */ void _ebean_setni_e001Key(RSAPublicKey _newValue) {
        this.e001Key = _newValue;
        this._ebean_intercept.setLoadedProperty(10);
    }

    protected /* synthetic */ RSAPublicKey _ebean_get_e002Key() {
        this._ebean_intercept.preGetter(11);
        return this.e002Key;
    }

    protected /* synthetic */ void _ebean_set_e002Key(RSAPublicKey newValue) {
        this._ebean_intercept.preSetter(true, 11, (Object)this._ebean_get_e002Key(), (Object)newValue);
        this.e002Key = newValue;
    }

    protected /* synthetic */ RSAPublicKey _ebean_getni_e002Key() {
        return this.e002Key;
    }

    protected /* synthetic */ void _ebean_setni_e002Key(RSAPublicKey _newValue) {
        this.e002Key = _newValue;
        this._ebean_intercept.setLoadedProperty(11);
    }

    protected /* synthetic */ RSAPublicKey _ebean_get_x001Key() {
        this._ebean_intercept.preGetter(12);
        return this.x001Key;
    }

    protected /* synthetic */ void _ebean_set_x001Key(RSAPublicKey newValue) {
        this._ebean_intercept.preSetter(true, 12, (Object)this._ebean_get_x001Key(), (Object)newValue);
        this.x001Key = newValue;
    }

    protected /* synthetic */ RSAPublicKey _ebean_getni_x001Key() {
        return this.x001Key;
    }

    protected /* synthetic */ void _ebean_setni_x001Key(RSAPublicKey _newValue) {
        this.x001Key = _newValue;
        this._ebean_intercept.setLoadedProperty(12);
    }

    protected /* synthetic */ RSAPublicKey _ebean_get_x002Key() {
        this._ebean_intercept.preGetter(13);
        return this.x002Key;
    }

    protected /* synthetic */ void _ebean_set_x002Key(RSAPublicKey newValue) {
        this._ebean_intercept.preSetter(true, 13, (Object)this._ebean_get_x002Key(), (Object)newValue);
        this.x002Key = newValue;
    }

    protected /* synthetic */ RSAPublicKey _ebean_getni_x002Key() {
        return this.x002Key;
    }

    protected /* synthetic */ void _ebean_setni_x002Key(RSAPublicKey _newValue) {
        this.x002Key = _newValue;
        this._ebean_intercept.setLoadedProperty(13);
    }

    protected /* synthetic */ String _ebean_get_expectedDigestE001() {
        this._ebean_intercept.preGetter(14);
        return this.expectedDigestE001;
    }

    protected /* synthetic */ void _ebean_set_expectedDigestE001(String newValue) {
        this._ebean_intercept.preSetter(true, 14, (Object)this._ebean_get_expectedDigestE001(), (Object)newValue);
        this.expectedDigestE001 = newValue;
    }

    protected /* synthetic */ String _ebean_getni_expectedDigestE001() {
        return this.expectedDigestE001;
    }

    protected /* synthetic */ void _ebean_setni_expectedDigestE001(String _newValue) {
        this.expectedDigestE001 = _newValue;
        this._ebean_intercept.setLoadedProperty(14);
    }

    protected /* synthetic */ String _ebean_get_expectedDigestX001() {
        this._ebean_intercept.preGetter(15);
        return this.expectedDigestX001;
    }

    protected /* synthetic */ void _ebean_set_expectedDigestX001(String newValue) {
        this._ebean_intercept.preSetter(true, 15, (Object)this._ebean_get_expectedDigestX001(), (Object)newValue);
        this.expectedDigestX001 = newValue;
    }

    protected /* synthetic */ String _ebean_getni_expectedDigestX001() {
        return this.expectedDigestX001;
    }

    protected /* synthetic */ void _ebean_setni_expectedDigestX001(String _newValue) {
        this.expectedDigestX001 = _newValue;
        this._ebean_intercept.setLoadedProperty(15);
    }

    protected /* synthetic */ String _ebean_get_expectedDigestE002() {
        this._ebean_intercept.preGetter(16);
        return this.expectedDigestE002;
    }

    protected /* synthetic */ void _ebean_set_expectedDigestE002(String newValue) {
        this._ebean_intercept.preSetter(true, 16, (Object)this._ebean_get_expectedDigestE002(), (Object)newValue);
        this.expectedDigestE002 = newValue;
    }

    protected /* synthetic */ String _ebean_getni_expectedDigestE002() {
        return this.expectedDigestE002;
    }

    protected /* synthetic */ void _ebean_setni_expectedDigestE002(String _newValue) {
        this.expectedDigestE002 = _newValue;
        this._ebean_intercept.setLoadedProperty(16);
    }

    protected /* synthetic */ String _ebean_get_expectedDigestX002() {
        this._ebean_intercept.preGetter(17);
        return this.expectedDigestX002;
    }

    protected /* synthetic */ void _ebean_set_expectedDigestX002(String newValue) {
        this._ebean_intercept.preSetter(true, 17, (Object)this._ebean_get_expectedDigestX002(), (Object)newValue);
        this.expectedDigestX002 = newValue;
    }

    protected /* synthetic */ String _ebean_getni_expectedDigestX002() {
        return this.expectedDigestX002;
    }

    protected /* synthetic */ void _ebean_setni_expectedDigestX002(String _newValue) {
        this.expectedDigestX002 = _newValue;
        this._ebean_intercept.setLoadedProperty(17);
    }

    protected /* synthetic */ Integer _ebean_get_dtazvNumber() {
        this._ebean_intercept.preGetter(18);
        return this.dtazvNumber;
    }

    protected /* synthetic */ void _ebean_set_dtazvNumber(Integer newValue) {
        this._ebean_intercept.preSetter(true, 18, (Object)this._ebean_get_dtazvNumber(), (Object)newValue);
        this.dtazvNumber = newValue;
    }

    protected /* synthetic */ Integer _ebean_getni_dtazvNumber() {
        return this.dtazvNumber;
    }

    protected /* synthetic */ void _ebean_setni_dtazvNumber(Integer _newValue) {
        this.dtazvNumber = _newValue;
        this._ebean_intercept.setLoadedProperty(18);
    }

    protected /* synthetic */ Boolean _ebean_get_transferSystem() {
        this._ebean_intercept.preGetter(19);
        return this.transferSystem;
    }

    protected /* synthetic */ void _ebean_set_transferSystem(Boolean newValue) {
        this._ebean_intercept.preSetter(true, 19, (Object)this._ebean_get_transferSystem(), (Object)newValue);
        this.transferSystem = newValue;
    }

    protected /* synthetic */ Boolean _ebean_getni_transferSystem() {
        return this.transferSystem;
    }

    protected /* synthetic */ void _ebean_setni_transferSystem(Boolean _newValue) {
        this.transferSystem = _newValue;
        this._ebean_intercept.setLoadedProperty(19);
    }

    protected /* synthetic */ Boolean _ebean_get_transportOnly() {
        this._ebean_intercept.preGetter(20);
        return this.transportOnly;
    }

    protected /* synthetic */ void _ebean_set_transportOnly(Boolean newValue) {
        this._ebean_intercept.preSetter(true, 20, (Object)this._ebean_get_transportOnly(), (Object)newValue);
        this.transportOnly = newValue;
    }

    protected /* synthetic */ Boolean _ebean_getni_transportOnly() {
        return this.transportOnly;
    }

    protected /* synthetic */ void _ebean_setni_transportOnly(Boolean _newValue) {
        this.transportOnly = _newValue;
        this._ebean_intercept.setLoadedProperty(20);
    }

    protected /* synthetic */ Boolean _ebean_get_useHCA_PUB() {
        this._ebean_intercept.preGetter(21);
        return this.useHCA_PUB;
    }

    protected /* synthetic */ void _ebean_set_useHCA_PUB(Boolean newValue) {
        this._ebean_intercept.preSetter(true, 21, (Object)this._ebean_get_useHCA_PUB(), (Object)newValue);
        this.useHCA_PUB = newValue;
    }

    protected /* synthetic */ Boolean _ebean_getni_useHCA_PUB() {
        return this.useHCA_PUB;
    }

    protected /* synthetic */ void _ebean_setni_useHCA_PUB(Boolean _newValue) {
        this.useHCA_PUB = _newValue;
        this._ebean_intercept.setLoadedProperty(21);
    }

    protected /* synthetic */ String _ebean_get_wssFetchType() {
        this._ebean_intercept.preGetter(22);
        return this.wssFetchType;
    }

    protected /* synthetic */ void _ebean_set_wssFetchType(String newValue) {
        this._ebean_intercept.preSetter(true, 22, (Object)this._ebean_get_wssFetchType(), (Object)newValue);
        this.wssFetchType = newValue;
    }

    protected /* synthetic */ String _ebean_getni_wssFetchType() {
        return this.wssFetchType;
    }

    protected /* synthetic */ void _ebean_setni_wssFetchType(String _newValue) {
        this.wssFetchType = _newValue;
        this._ebean_intercept.setLoadedProperty(22);
    }

    protected /* synthetic */ boolean _ebean_get_vopActivated() {
        this._ebean_intercept.preGetter(23);
        return this.vopActivated;
    }

    protected /* synthetic */ void _ebean_set_vopActivated(boolean newValue) {
        this._ebean_intercept.preSetter(true, 23, this._ebean_get_vopActivated(), newValue);
        this.vopActivated = newValue;
    }

    protected /* synthetic */ boolean _ebean_getni_vopActivated() {
        return this.vopActivated;
    }

    protected /* synthetic */ void _ebean_setni_vopActivated(boolean _newValue) {
        this.vopActivated = _newValue;
        this._ebean_intercept.setLoadedProperty(23);
    }

    protected /* synthetic */ boolean _ebean_get_vopMandatory() {
        this._ebean_intercept.preGetter(24);
        return this.vopMandatory;
    }

    protected /* synthetic */ void _ebean_set_vopMandatory(boolean newValue) {
        this._ebean_intercept.preSetter(true, 24, this._ebean_get_vopMandatory(), newValue);
        this.vopMandatory = newValue;
    }

    protected /* synthetic */ boolean _ebean_getni_vopMandatory() {
        return this.vopMandatory;
    }

    protected /* synthetic */ void _ebean_setni_vopMandatory(boolean _newValue) {
        this.vopMandatory = _newValue;
        this._ebean_intercept.setLoadedProperty(24);
    }

    protected /* synthetic */ List _ebean_get_users() {
        this._ebean_intercept.preGetter(25);
        if (this.users == null) {
            this.users = new BeanList();
            this._ebean_intercept.initialisedMany(25);
        }
        return this.users;
    }

    protected /* synthetic */ void _ebean_set_users(List newValue) {
        this._ebean_intercept.preSetterMany(false, 25, this.users, (Object)newValue);
        this.users = newValue;
    }

    protected /* synthetic */ List _ebean_getni_users() {
        return this.users;
    }

    protected /* synthetic */ void _ebean_setni_users(List _newValue) {
        this.users = _newValue;
        this._ebean_intercept.setLoadedProperty(25);
    }

    protected /* synthetic */ Tenant _ebean_get_tenant() {
        this._ebean_intercept.preGetter(26);
        return this.tenant;
    }

    protected /* synthetic */ void _ebean_set_tenant(Tenant newValue) {
        this._ebean_intercept.preSetter(true, 26, (Object)this._ebean_get_tenant(), (Object)newValue);
        this.tenant = newValue;
    }

    protected /* synthetic */ Tenant _ebean_getni_tenant() {
        return this.tenant;
    }

    protected /* synthetic */ void _ebean_setni_tenant(Tenant _newValue) {
        this.tenant = _newValue;
        this._ebean_intercept.setLoadedProperty(26);
    }

    public /* synthetic */ Object _ebean_getField(int index) {
        switch (index) {
            case 0: {
                return this.bankId;
            }
            case 1: {
                return this.displayName;
            }
            case 2: {
                return this.icon;
            }
            case 3: {
                return this.countryCode;
            }
            case 4: {
                return this.url;
            }
            case 5: {
                return this.protocolVersion;
            }
            case 6: {
                return this.hostId;
            }
            case 7: {
                return this.customerId;
            }
            case 8: {
                return this.bankParametersTime;
            }
            case 9: {
                return this.bankParameters;
            }
            case 10: {
                return this.e001Key;
            }
            case 11: {
                return this.e002Key;
            }
            case 12: {
                return this.x001Key;
            }
            case 13: {
                return this.x002Key;
            }
            case 14: {
                return this.expectedDigestE001;
            }
            case 15: {
                return this.expectedDigestX001;
            }
            case 16: {
                return this.expectedDigestE002;
            }
            case 17: {
                return this.expectedDigestX002;
            }
            case 18: {
                return this.dtazvNumber;
            }
            case 19: {
                return this.transferSystem;
            }
            case 20: {
                return this.transportOnly;
            }
            case 21: {
                return this.useHCA_PUB;
            }
            case 22: {
                return this.wssFetchType;
            }
            case 23: {
                return this.vopActivated;
            }
            case 24: {
                return this.vopMandatory;
            }
            case 25: {
                return this.users;
            }
            case 26: {
                return this.tenant;
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    public /* synthetic */ Object _ebean_getFieldIntercept(int index) {
        switch (index) {
            case 0: {
                return this._ebean_get_bankId();
            }
            case 1: {
                return this._ebean_get_displayName();
            }
            case 2: {
                return this._ebean_get_icon();
            }
            case 3: {
                return this._ebean_get_countryCode();
            }
            case 4: {
                return this._ebean_get_url();
            }
            case 5: {
                return this._ebean_get_protocolVersion();
            }
            case 6: {
                return this._ebean_get_hostId();
            }
            case 7: {
                return this._ebean_get_customerId();
            }
            case 8: {
                return this._ebean_get_bankParametersTime();
            }
            case 9: {
                return this._ebean_get_bankParameters();
            }
            case 10: {
                return this._ebean_get_e001Key();
            }
            case 11: {
                return this._ebean_get_e002Key();
            }
            case 12: {
                return this._ebean_get_x001Key();
            }
            case 13: {
                return this._ebean_get_x002Key();
            }
            case 14: {
                return this._ebean_get_expectedDigestE001();
            }
            case 15: {
                return this._ebean_get_expectedDigestX001();
            }
            case 16: {
                return this._ebean_get_expectedDigestE002();
            }
            case 17: {
                return this._ebean_get_expectedDigestX002();
            }
            case 18: {
                return this._ebean_get_dtazvNumber();
            }
            case 19: {
                return this._ebean_get_transferSystem();
            }
            case 20: {
                return this._ebean_get_transportOnly();
            }
            case 21: {
                return this._ebean_get_useHCA_PUB();
            }
            case 22: {
                return this._ebean_get_wssFetchType();
            }
            case 23: {
                return this._ebean_get_vopActivated();
            }
            case 24: {
                return this._ebean_get_vopMandatory();
            }
            case 25: {
                return this._ebean_get_users();
            }
            case 26: {
                return this._ebean_get_tenant();
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    public /* synthetic */ void _ebean_setField(int index, Object o) {
        switch (index) {
            case 0: {
                this._ebean_setni_bankId((Integer)o);
                return;
            }
            case 1: {
                this._ebean_setni_displayName((String)o);
                return;
            }
            case 2: {
                this._ebean_setni_icon((String)o);
                return;
            }
            case 3: {
                this._ebean_setni_countryCode((String)o);
                return;
            }
            case 4: {
                this._ebean_setni_url((String)o);
                return;
            }
            case 5: {
                this._ebean_setni_protocolVersion((String)o);
                return;
            }
            case 6: {
                this._ebean_setni_hostId((String)o);
                return;
            }
            case 7: {
                this._ebean_setni_customerId((String)o);
                return;
            }
            case 8: {
                this._ebean_setni_bankParametersTime((Timestamp)o);
                return;
            }
            case 9: {
                this._ebean_setni_bankParameters((byte[])o);
                return;
            }
            case 10: {
                this._ebean_setni_e001Key((RSAPublicKey)o);
                return;
            }
            case 11: {
                this._ebean_setni_e002Key((RSAPublicKey)o);
                return;
            }
            case 12: {
                this._ebean_setni_x001Key((RSAPublicKey)o);
                return;
            }
            case 13: {
                this._ebean_setni_x002Key((RSAPublicKey)o);
                return;
            }
            case 14: {
                this._ebean_setni_expectedDigestE001((String)o);
                return;
            }
            case 15: {
                this._ebean_setni_expectedDigestX001((String)o);
                return;
            }
            case 16: {
                this._ebean_setni_expectedDigestE002((String)o);
                return;
            }
            case 17: {
                this._ebean_setni_expectedDigestX002((String)o);
                return;
            }
            case 18: {
                this._ebean_setni_dtazvNumber((Integer)o);
                return;
            }
            case 19: {
                this._ebean_setni_transferSystem((Boolean)o);
                return;
            }
            case 20: {
                this._ebean_setni_transportOnly((Boolean)o);
                return;
            }
            case 21: {
                this._ebean_setni_useHCA_PUB((Boolean)o);
                return;
            }
            case 22: {
                this._ebean_setni_wssFetchType((String)o);
                return;
            }
            case 23: {
                this._ebean_setni_vopActivated((Boolean)o);
                return;
            }
            case 24: {
                this._ebean_setni_vopMandatory((Boolean)o);
                return;
            }
            case 25: {
                this._ebean_setni_users((List)o);
                return;
            }
            case 26: {
                this._ebean_setni_tenant((Tenant)o);
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    public /* synthetic */ void _ebean_setFieldIntercept(int index, Object o) {
        switch (index) {
            case 0: {
                this._ebean_set_bankId((Integer)o);
                return;
            }
            case 1: {
                this._ebean_set_displayName((String)o);
                return;
            }
            case 2: {
                this._ebean_set_icon((String)o);
                return;
            }
            case 3: {
                this._ebean_set_countryCode((String)o);
                return;
            }
            case 4: {
                this._ebean_set_url((String)o);
                return;
            }
            case 5: {
                this._ebean_set_protocolVersion((String)o);
                return;
            }
            case 6: {
                this._ebean_set_hostId((String)o);
                return;
            }
            case 7: {
                this._ebean_set_customerId((String)o);
                return;
            }
            case 8: {
                this._ebean_set_bankParametersTime((Timestamp)o);
                return;
            }
            case 9: {
                this._ebean_set_bankParameters((byte[])o);
                return;
            }
            case 10: {
                this._ebean_set_e001Key((RSAPublicKey)o);
                return;
            }
            case 11: {
                this._ebean_set_e002Key((RSAPublicKey)o);
                return;
            }
            case 12: {
                this._ebean_set_x001Key((RSAPublicKey)o);
                return;
            }
            case 13: {
                this._ebean_set_x002Key((RSAPublicKey)o);
                return;
            }
            case 14: {
                this._ebean_set_expectedDigestE001((String)o);
                return;
            }
            case 15: {
                this._ebean_set_expectedDigestX001((String)o);
                return;
            }
            case 16: {
                this._ebean_set_expectedDigestE002((String)o);
                return;
            }
            case 17: {
                this._ebean_set_expectedDigestX002((String)o);
                return;
            }
            case 18: {
                this._ebean_set_dtazvNumber((Integer)o);
                return;
            }
            case 19: {
                this._ebean_set_transferSystem((Boolean)o);
                return;
            }
            case 20: {
                this._ebean_set_transportOnly((Boolean)o);
                return;
            }
            case 21: {
                this._ebean_set_useHCA_PUB((Boolean)o);
                return;
            }
            case 22: {
                this._ebean_set_wssFetchType((String)o);
                return;
            }
            case 23: {
                this._ebean_set_vopActivated((Boolean)o);
                return;
            }
            case 24: {
                this._ebean_set_vopMandatory((Boolean)o);
                return;
            }
            case 25: {
                this._ebean_set_users((List)o);
                return;
            }
            case 26: {
                this._ebean_set_tenant((Tenant)o);
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private /* synthetic */ Object _ebean_getIdentity() {
        BankSettings bankSettings = this;
        synchronized (bankSettings) {
            if (this._ebean_identity != null) {
                return this._ebean_identity;
            }
            Object tmpId = this._ebean_getField(0);
            this._ebean_identity = tmpId != null ? tmpId : new Object();
            return this._ebean_identity;
        }
    }

    public /* synthetic */ boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        return this._ebean_getIdentity().equals(((BankSettings)obj)._ebean_getIdentity());
    }

    public /* synthetic */ int hashCode() {
        return this._ebean_getIdentity().hashCode();
    }

    public /* synthetic */ void _ebean_setEmbeddedLoaded() {
    }

    public /* synthetic */ boolean _ebean_isEmbeddedNewOrDirty() {
        return false;
    }

    public /* synthetic */ Object _ebean_newInstance() {
        return new BankSettings();
    }
}

