/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.database.vo;

import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.AwzelDikaEntry;
import de.businesslogics.banking.database.vo.AwzelDirInvEntry;
import de.businesslogics.banking.database.vo.AwzelParticipantContactPerson;
import de.businesslogics.banking.database.vo.AwzelTransitEntry;
import de.businesslogics.banking.database.vo.CmBooking;
import de.businesslogics.banking.database.vo.SignedPayment;
import de.businesslogics.banking.database.vo.Tenant;
import de.businesslogics.banking.database.vo.User;
import io.ebean.ExpressionList;
import io.ebean.Query;
import io.ebean.SqlUpdate;
import io.ebean.annotation.Index;
import io.ebean.bean.EntityBean;
import io.ebean.bean.EntityBeanIntercept;
import io.ebean.common.BeanList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;

@Entity
@Table(name="awv_entry")
public class AwzelEntry
implements EntityBean {
    @Id
    private Integer id;
    @Column(name="type", nullable=false)
    private EntryType type;
    @Column(name="month", length=6, nullable=false)
    @Index(name="ix_awv_entry_report_month")
    private String reportMonth;
    @JoinColumn(name="reporter", table="awv_contact", referencedColumnName="id")
    @ManyToOne
    private AwzelParticipantContactPerson entryReporter;
    @Column(name="category")
    private Integer category;
    @Column(name="svc_code", length=3)
    private String serviceCode;
    @Column(name="reference", length=35)
    private String reportReference;
    @Column(name="cancel", nullable=false)
    private Boolean cancellation;
    @Column(name="cmnt", length=80)
    private String comment;
    @Column(name="exported", nullable=false)
    private Boolean exported;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true)
    @JoinColumn(table="awv_dika", name="abstract_entry_id")
    private List<AwzelDikaEntry> dikaEntries;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true)
    @JoinColumn(table="awv_transit", name="abstract_entry_id")
    private List<AwzelTransitEntry> transitEntries;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true)
    @JoinColumn(table="awv_dirinv", name="abstract_entry_id")
    private List<AwzelDirInvEntry> dirInvEntries;
    @Column(length=50)
    private String endToEndId;
    @ManyToOne(optional=false)
    private Tenant tenant;
    @Column(nullable=false)
    private Origin origin;
    @ManyToOne
    private SignedPayment signedPayment;
    @ManyToOne
    private CmBooking cmBooking;
    public static /* synthetic */ String[] _ebean_props;
    protected /* synthetic */ EntityBeanIntercept _ebean_intercept;
    protected transient /* synthetic */ Object _ebean_identity;

    public AwzelEntry() {
        this._ebean_intercept = new EntityBeanIntercept((Object)this);
        this._ebean_set_cancellation(Boolean.FALSE);
        this._ebean_set_exported(Boolean.FALSE);
        this._ebean_set_origin(Origin.UNKNOWN);
    }

    public static Query<AwzelEntry> getQueryForUser(User user) {
        return AwzelEntry.createQuery(user.getTenants(), null, null, null, null);
    }

    public static AwzelEntry findForId(int id, User user) {
        return (AwzelEntry)AwzelEntry.createQuery(user.getTenants(), null, null, null, null).where().eq("id", (Object)id).findOne();
    }

    public static List<AwzelEntry> findForIds(List<Integer> ids, User user) {
        return AwzelEntry.createQuery(user.getTenants(), null, null, null, null).where().in("id", ids).findList();
    }

    public static boolean hasEntryForEndToEndId(String endToEndId, Tenant tenant) {
        return AwzelEntry.createQuery(Collections.singletonList(tenant), null, null, null, null).where().eq("endToEndId", (Object)endToEndId).findCount() > 0;
    }

    public static List<String> getMonthsList(User user) {
        List entries = AwzelEntry.createQuery(user.getTenants(), null, null, null, null).setDistinct(true).select("reportMonth").orderBy("reportMonth desc").findList();
        ArrayList<String> result = new ArrayList<String>();
        for (AwzelEntry entry : entries) {
            result.add(entry.getReportMonth());
        }
        return result;
    }

    public static void markEntriesAsExported(List<Integer> awzelEntryIds) {
        String statementTemplate = "UPDATE awv_entry SET exported = '1' WHERE id IN (";
        for (int i = 0; i < awzelEntryIds.size(); i += 900) {
            StringBuilder statementBuilder = new StringBuilder("UPDATE awv_entry SET exported = '1' WHERE id IN (");
            for (Integer id : awzelEntryIds.subList(i, i + Math.min(awzelEntryIds.size() - i, 900))) {
                statementBuilder.append(id).append(", ");
            }
            if (statementBuilder.length() <= "UPDATE awv_entry SET exported = '1' WHERE id IN (".length()) continue;
            statementBuilder.setLength(statementBuilder.length() - 2);
            SqlUpdate update = DB.createSqlUpdate(statementBuilder.append(")").toString());
            update.execute();
        }
    }

    public static boolean hasEntries(User user) {
        return AwzelEntry.createQuery(user.getTenants(), null, null, null, null).findCount() > 0;
    }

    public static void removeBookingReferences(List<Object> bookingIds) {
        String statementTemplate = "UPDATE awv_entry SET cm_booking_id = null, origin=0 WHERE cm_booking_id IN (";
        for (int i = 0; i < bookingIds.size(); i += 900) {
            StringBuilder statementBuilder = new StringBuilder("UPDATE awv_entry SET cm_booking_id = null, origin=0 WHERE cm_booking_id IN (");
            for (Object id : bookingIds.subList(i, i + Math.min(bookingIds.size() - i, 900))) {
                if (!(id instanceof Integer)) continue;
                statementBuilder.append(id).append(", ");
            }
            if (statementBuilder.length() <= "UPDATE awv_entry SET cm_booking_id = null, origin=0 WHERE cm_booking_id IN (".length()) continue;
            statementBuilder.setLength(statementBuilder.length() - 2);
            SqlUpdate update = DB.createSqlUpdate(statementBuilder.append(")").toString());
            update.execute();
        }
    }

    public static void removePaymentReferences(List<Object> paymentIds) {
        String statementTemplate = "UPDATE awv_entry SET signed_payment_id = null, origin=0 WHERE signed_payment_id IN (";
        for (int i = 0; i < paymentIds.size(); i += 900) {
            StringBuilder statementBuilder = new StringBuilder("UPDATE awv_entry SET signed_payment_id = null, origin=0 WHERE signed_payment_id IN (");
            for (Object id : paymentIds.subList(i, i + Math.min(paymentIds.size() - i, 900))) {
                if (!(id instanceof Integer)) continue;
                statementBuilder.append(id).append(", ");
            }
            if (statementBuilder.length() <= "UPDATE awv_entry SET signed_payment_id = null, origin=0 WHERE signed_payment_id IN (".length()) continue;
            statementBuilder.setLength(statementBuilder.length() - 2);
            SqlUpdate update = DB.createSqlUpdate(statementBuilder.append(")").toString());
            update.execute();
        }
    }

    public static int countEntriesForMonth(String month, User user) {
        return AwzelEntry.createQuery(user.getTenants(), month, null, null, null).findCount();
    }

    public static Query<AwzelEntry> getEntriesForMonth(int month, int year, User user) {
        return AwzelEntry.createQuery(user.getTenants(), String.format("%4d%02d", year, month), null, null, null);
    }

    public static Query<AwzelEntry> getEntriesForMonthAndReporter(int month, int year, User user, AwzelParticipantContactPerson reporter) {
        return AwzelEntry.createQuery(user.getTenants(), String.format("%4d%02d", year, month), null, null, reporter);
    }

    public static Query<AwzelEntry> getServicesEntriesForMonth(int month, int year, User user) {
        return AwzelEntry.createQuery(user.getTenants(), String.format("%4d%02d", year, month), EntryType.DIKA, Arrays.asList(1, 2), null);
    }

    public static Query<AwzelEntry> getCapitalEntriesForMonth(int month, int year, User user) {
        return AwzelEntry.createQuery(user.getTenants(), String.format("%4d%02d", year, month), EntryType.DIKA, Arrays.asList(3, 4), null);
    }

    public static Query<AwzelEntry> getTransitEntriesForMonth(int month, int year, User user) {
        return AwzelEntry.createQuery(user.getTenants(), String.format("%4d%02d", year, month), EntryType.TRANSIT, null, null);
    }

    public static Query<AwzelEntry> getDirInvEntriesForMonth(int month, int year, User user) {
        return AwzelEntry.createQuery(user.getTenants(), String.format("%4d%02d", year, month), EntryType.DIRINV, null, null);
    }

    private static Query<AwzelEntry> createQuery(List<Tenant> tenants, String month, EntryType type, List<Integer> categories, AwzelParticipantContactPerson reporter) {
        ExpressionList result = DB.find(AwzelEntry.class).where().in("tenant", tenants);
        if (month != null) {
            result = result.eq("month", (Object)month);
        }
        if (type != null) {
            result = result.eq("type", (Object)type);
        }
        if (categories != null) {
            result = result.in("category", categories);
        }
        if (reporter != null) {
            result = result.eq("reporter", (Object)reporter.getPersonId());
        }
        return result.orderBy("type asc, category asc, serviceCode asc, id desc").query();
    }

    public Integer getId() {
        return this._ebean_get_id();
    }

    public void setId(Integer id) {
        this._ebean_set_id(id);
    }

    public String getReportMonth() {
        return this._ebean_get_reportMonth();
    }

    public void setReportMonth(String reportMonth) {
        this._ebean_set_reportMonth(reportMonth);
    }

    public EntryType getType() {
        return this._ebean_get_type();
    }

    public void setType(EntryType type) {
        this._ebean_set_type(type);
    }

    public AwzelParticipantContactPerson getEntryReporter() {
        return this._ebean_get_entryReporter();
    }

    public void setEntryReporter(AwzelParticipantContactPerson entryReporter) {
        this._ebean_set_entryReporter(entryReporter);
    }

    public Integer getCategory() {
        return this._ebean_get_category();
    }

    public void setCategory(Integer category) {
        this._ebean_set_category(category);
    }

    public String getServiceCode() {
        return this._ebean_get_serviceCode();
    }

    public void setServiceCode(String serviceCode) {
        this._ebean_set_serviceCode(serviceCode);
    }

    public String getReportReference() {
        return this._ebean_get_reportReference();
    }

    public void setReportReference(String reportReference) {
        this._ebean_set_reportReference(reportReference);
    }

    public Boolean isCancellation() {
        return this._ebean_get_cancellation();
    }

    public void setCancellation(Boolean cancellation) {
        this._ebean_set_cancellation(cancellation);
    }

    public String getComment() {
        return this._ebean_get_comment();
    }

    public void setComment(String comment) {
        this._ebean_set_comment(comment);
    }

    public Boolean isExported() {
        return this._ebean_get_exported();
    }

    public void setExported(Boolean exported) {
        this._ebean_set_exported(exported);
    }

    public List<AwzelDikaEntry> getDikaEntries() {
        return this._ebean_get_dikaEntries();
    }

    public void setDikaEntries(List<AwzelDikaEntry> dikaEntries) {
        this._ebean_set_dikaEntries(dikaEntries);
    }

    public AwzelDikaEntry getDikaEntry() {
        if (this.getType() == EntryType.DIKA && this.getDikaEntries() != null && this.getDikaEntries().size() > 0) {
            return this.getDikaEntries().get(0);
        }
        return null;
    }

    public void setDikaEntry(AwzelDikaEntry dikaEntry) {
        if (this.getType() != EntryType.DIKA) {
            return;
        }
        ArrayList<AwzelDikaEntry> dikaEntries = new ArrayList<AwzelDikaEntry>();
        dikaEntries.add(dikaEntry);
        this.setDikaEntries(dikaEntries);
    }

    public List<AwzelTransitEntry> getTransitEntries() {
        return this._ebean_get_transitEntries();
    }

    public void setTransitEntries(List<AwzelTransitEntry> transitEntries) {
        this._ebean_set_transitEntries(transitEntries);
    }

    public void addTransitEntry(AwzelTransitEntry transitEntry) {
        if (this.getType() != EntryType.TRANSIT) {
            return;
        }
        if (this._ebean_get_transitEntries() == null) {
            this._ebean_set_transitEntries(new ArrayList());
        }
        this._ebean_get_transitEntries().add(transitEntry);
    }

    public void deleteTransitEntry(AwzelTransitEntry transitEntry) {
        if (this._ebean_get_transitEntries() != null && this._ebean_get_transitEntries().size() > 0) {
            this._ebean_get_transitEntries().remove(transitEntry);
        }
    }

    public List<AwzelDirInvEntry> getDirInvEntries() {
        return this._ebean_get_dirInvEntries();
    }

    public void setDirInvEntries(List<AwzelDirInvEntry> dirInvEntries) {
        this._ebean_set_dirInvEntries(dirInvEntries);
    }

    public void addDirInvEntry(AwzelDirInvEntry dirInvEntry) {
        if (this.getType() != EntryType.DIRINV) {
            return;
        }
        if (this._ebean_get_dirInvEntries() == null) {
            this._ebean_set_dirInvEntries(new ArrayList());
        }
        this._ebean_get_dirInvEntries().add(dirInvEntry);
    }

    public void deleteDirInvEntry(AwzelDirInvEntry dirInvEntry) {
        if (this._ebean_get_dirInvEntries() != null && this._ebean_get_dirInvEntries().size() > 0) {
            this._ebean_get_dirInvEntries().remove(dirInvEntry);
        }
    }

    public String getEndToEndId() {
        return this._ebean_get_endToEndId();
    }

    public void setEndToEndId(String endToEndId) {
        this._ebean_set_endToEndId(endToEndId);
    }

    public String getCountryCode() {
        String countryCode;
        block5: {
            block6: {
                block4: {
                    countryCode = null;
                    if (this._ebean_get_type() != EntryType.DIKA || this._ebean_get_dikaEntries() == null || this._ebean_get_dikaEntries().size() != 1) break block4;
                    countryCode = ((AwzelDikaEntry)this._ebean_get_dikaEntries().get(0)).getCountryCode();
                    break block5;
                }
                if (this._ebean_get_type() != EntryType.TRANSIT || this._ebean_get_transitEntries() == null || this._ebean_get_transitEntries().size() <= 0) break block6;
                for (AwzelTransitEntry transitEntry : this._ebean_get_transitEntries()) {
                    if (countryCode == null) {
                        countryCode = transitEntry.getCountryCode();
                        continue;
                    }
                    if (countryCode.equals(transitEntry.getCountryCode())) continue;
                    return null;
                }
                break block5;
            }
            if (this._ebean_get_type() != EntryType.DIRINV || this._ebean_get_dirInvEntries() == null || this._ebean_get_dirInvEntries().size() <= 0) break block5;
            for (AwzelDirInvEntry dirInvEntry : this._ebean_get_dirInvEntries()) {
                if (countryCode == null) {
                    countryCode = dirInvEntry.getCountryCode();
                    continue;
                }
                if (countryCode.equals(dirInvEntry.getCountryCode())) continue;
                return null;
            }
        }
        return countryCode;
    }

    public Double getTotalAmount() {
        if (this._ebean_get_type() == EntryType.DIKA && this._ebean_get_dikaEntries() != null && this._ebean_get_dikaEntries().size() == 1) {
            return ((AwzelDikaEntry)this._ebean_get_dikaEntries().get(0)).getAmountInEurDouble();
        }
        if (this._ebean_get_type() == EntryType.TRANSIT && this._ebean_get_transitEntries() != null && this._ebean_get_transitEntries().size() > 0) {
            Double result = null;
            for (AwzelTransitEntry transitEntry : this._ebean_get_transitEntries()) {
                if (result == null) {
                    result = transitEntry.getAmountInEurDouble();
                    continue;
                }
                if (transitEntry.getAmountInEurDouble() == null) continue;
                result = result + transitEntry.getAmountInEurDouble();
            }
            return result;
        }
        if (this._ebean_get_type() == EntryType.DIRINV && this._ebean_get_dirInvEntries() != null && this._ebean_get_dirInvEntries().size() > 0) {
            Double result = null;
            for (AwzelDirInvEntry dirInvEntry : this._ebean_get_dirInvEntries()) {
                if (result == null) {
                    result = dirInvEntry.getAmountInEurDouble();
                    continue;
                }
                if (dirInvEntry.getAmountInEurDouble() == null) continue;
                result = result + dirInvEntry.getAmountInEurDouble();
            }
            return result;
        }
        return null;
    }

    public Tenant getTenant() {
        return this._ebean_get_tenant();
    }

    public void setTenant(Tenant tenant) {
        this._ebean_set_tenant(tenant);
    }

    public Origin getOrigin() {
        return this._ebean_get_origin();
    }

    public void setOrigin(Origin origin) {
        this._ebean_set_origin(origin);
    }

    public SignedPayment getSignedPayment() {
        return this._ebean_get_signedPayment();
    }

    public void setSignedPayment(SignedPayment signedPayment) {
        this._ebean_set_signedPayment(signedPayment);
    }

    public CmBooking getCmBooking() {
        return this._ebean_get_cmBooking();
    }

    public void setCmBooking(CmBooking cmBooking) {
        this._ebean_set_cmBooking(cmBooking);
    }

    public void save() {
        if (this._ebean_get_id() == null) {
            DB.save(this);
        } else {
            DB.update(this);
        }
    }

    public void delete() {
        if (this._ebean_get_id() == null) {
            return;
        }
        DB.delete(this);
    }

    public static void delete(Collection<AwzelEntry> entries) {
        if (entries != null && entries.size() > 0) {
            DB.deleteAll(entries);
        }
    }

    static {
        _ebean_props = new String[]{"id", "type", "reportMonth", "entryReporter", "category", "serviceCode", "reportReference", "cancellation", "comment", "exported", "dikaEntries", "transitEntries", "dirInvEntries", "endToEndId", "tenant", "origin", "signedPayment", "cmBooking"};
    }

    public /* synthetic */ String[] _ebean_getPropertyNames() {
        return _ebean_props;
    }

    public /* synthetic */ String _ebean_getPropertyName(int pos) {
        return _ebean_props[pos];
    }

    public /* synthetic */ EntityBeanIntercept _ebean_getIntercept() {
        return this._ebean_intercept;
    }

    public /* synthetic */ EntityBeanIntercept _ebean_intercept() {
        if (this._ebean_intercept == null) {
            this._ebean_intercept = new EntityBeanIntercept((Object)this);
        }
        return this._ebean_intercept;
    }

    protected /* synthetic */ Integer _ebean_get_id() {
        this._ebean_intercept.preGetId();
        return this.id;
    }

    protected /* synthetic */ void _ebean_set_id(Integer newValue) {
        this._ebean_intercept.preSetter(false, 0, (Object)this.id, (Object)newValue);
        this.id = newValue;
    }

    protected /* synthetic */ Integer _ebean_getni_id() {
        return this.id;
    }

    protected /* synthetic */ void _ebean_setni_id(Integer _newValue) {
        this.id = _newValue;
        this._ebean_intercept.setLoadedProperty(0);
    }

    protected /* synthetic */ EntryType _ebean_get_type() {
        this._ebean_intercept.preGetter(1);
        return this.type;
    }

    protected /* synthetic */ void _ebean_set_type(EntryType newValue) {
        this._ebean_intercept.preSetter(true, 1, (Object)this._ebean_get_type(), (Object)newValue);
        this.type = newValue;
    }

    protected /* synthetic */ EntryType _ebean_getni_type() {
        return this.type;
    }

    protected /* synthetic */ void _ebean_setni_type(EntryType _newValue) {
        this.type = _newValue;
        this._ebean_intercept.setLoadedProperty(1);
    }

    protected /* synthetic */ String _ebean_get_reportMonth() {
        this._ebean_intercept.preGetter(2);
        return this.reportMonth;
    }

    protected /* synthetic */ void _ebean_set_reportMonth(String newValue) {
        this._ebean_intercept.preSetter(true, 2, (Object)this._ebean_get_reportMonth(), (Object)newValue);
        this.reportMonth = newValue;
    }

    protected /* synthetic */ String _ebean_getni_reportMonth() {
        return this.reportMonth;
    }

    protected /* synthetic */ void _ebean_setni_reportMonth(String _newValue) {
        this.reportMonth = _newValue;
        this._ebean_intercept.setLoadedProperty(2);
    }

    protected /* synthetic */ AwzelParticipantContactPerson _ebean_get_entryReporter() {
        this._ebean_intercept.preGetter(3);
        return this.entryReporter;
    }

    protected /* synthetic */ void _ebean_set_entryReporter(AwzelParticipantContactPerson newValue) {
        this._ebean_intercept.preSetter(true, 3, (Object)this._ebean_get_entryReporter(), (Object)newValue);
        this.entryReporter = newValue;
    }

    protected /* synthetic */ AwzelParticipantContactPerson _ebean_getni_entryReporter() {
        return this.entryReporter;
    }

    protected /* synthetic */ void _ebean_setni_entryReporter(AwzelParticipantContactPerson _newValue) {
        this.entryReporter = _newValue;
        this._ebean_intercept.setLoadedProperty(3);
    }

    protected /* synthetic */ Integer _ebean_get_category() {
        this._ebean_intercept.preGetter(4);
        return this.category;
    }

    protected /* synthetic */ void _ebean_set_category(Integer newValue) {
        this._ebean_intercept.preSetter(true, 4, (Object)this._ebean_get_category(), (Object)newValue);
        this.category = newValue;
    }

    protected /* synthetic */ Integer _ebean_getni_category() {
        return this.category;
    }

    protected /* synthetic */ void _ebean_setni_category(Integer _newValue) {
        this.category = _newValue;
        this._ebean_intercept.setLoadedProperty(4);
    }

    protected /* synthetic */ String _ebean_get_serviceCode() {
        this._ebean_intercept.preGetter(5);
        return this.serviceCode;
    }

    protected /* synthetic */ void _ebean_set_serviceCode(String newValue) {
        this._ebean_intercept.preSetter(true, 5, (Object)this._ebean_get_serviceCode(), (Object)newValue);
        this.serviceCode = newValue;
    }

    protected /* synthetic */ String _ebean_getni_serviceCode() {
        return this.serviceCode;
    }

    protected /* synthetic */ void _ebean_setni_serviceCode(String _newValue) {
        this.serviceCode = _newValue;
        this._ebean_intercept.setLoadedProperty(5);
    }

    protected /* synthetic */ String _ebean_get_reportReference() {
        this._ebean_intercept.preGetter(6);
        return this.reportReference;
    }

    protected /* synthetic */ void _ebean_set_reportReference(String newValue) {
        this._ebean_intercept.preSetter(true, 6, (Object)this._ebean_get_reportReference(), (Object)newValue);
        this.reportReference = newValue;
    }

    protected /* synthetic */ String _ebean_getni_reportReference() {
        return this.reportReference;
    }

    protected /* synthetic */ void _ebean_setni_reportReference(String _newValue) {
        this.reportReference = _newValue;
        this._ebean_intercept.setLoadedProperty(6);
    }

    protected /* synthetic */ Boolean _ebean_get_cancellation() {
        this._ebean_intercept.preGetter(7);
        return this.cancellation;
    }

    protected /* synthetic */ void _ebean_set_cancellation(Boolean newValue) {
        this._ebean_intercept.preSetter(true, 7, (Object)this._ebean_get_cancellation(), (Object)newValue);
        this.cancellation = newValue;
    }

    protected /* synthetic */ Boolean _ebean_getni_cancellation() {
        return this.cancellation;
    }

    protected /* synthetic */ void _ebean_setni_cancellation(Boolean _newValue) {
        this.cancellation = _newValue;
        this._ebean_intercept.setLoadedProperty(7);
    }

    protected /* synthetic */ String _ebean_get_comment() {
        this._ebean_intercept.preGetter(8);
        return this.comment;
    }

    protected /* synthetic */ void _ebean_set_comment(String newValue) {
        this._ebean_intercept.preSetter(true, 8, (Object)this._ebean_get_comment(), (Object)newValue);
        this.comment = newValue;
    }

    protected /* synthetic */ String _ebean_getni_comment() {
        return this.comment;
    }

    protected /* synthetic */ void _ebean_setni_comment(String _newValue) {
        this.comment = _newValue;
        this._ebean_intercept.setLoadedProperty(8);
    }

    protected /* synthetic */ Boolean _ebean_get_exported() {
        this._ebean_intercept.preGetter(9);
        return this.exported;
    }

    protected /* synthetic */ void _ebean_set_exported(Boolean newValue) {
        this._ebean_intercept.preSetter(true, 9, (Object)this._ebean_get_exported(), (Object)newValue);
        this.exported = newValue;
    }

    protected /* synthetic */ Boolean _ebean_getni_exported() {
        return this.exported;
    }

    protected /* synthetic */ void _ebean_setni_exported(Boolean _newValue) {
        this.exported = _newValue;
        this._ebean_intercept.setLoadedProperty(9);
    }

    protected /* synthetic */ List _ebean_get_dikaEntries() {
        this._ebean_intercept.preGetter(10);
        if (this.dikaEntries == null) {
            this.dikaEntries = new BeanList();
            this._ebean_intercept.initialisedMany(10);
        }
        return this.dikaEntries;
    }

    protected /* synthetic */ void _ebean_set_dikaEntries(List newValue) {
        this._ebean_intercept.preSetterMany(false, 10, this.dikaEntries, (Object)newValue);
        this.dikaEntries = newValue;
    }

    protected /* synthetic */ List _ebean_getni_dikaEntries() {
        return this.dikaEntries;
    }

    protected /* synthetic */ void _ebean_setni_dikaEntries(List _newValue) {
        this.dikaEntries = _newValue;
        this._ebean_intercept.setLoadedProperty(10);
    }

    protected /* synthetic */ List _ebean_get_transitEntries() {
        this._ebean_intercept.preGetter(11);
        if (this.transitEntries == null) {
            this.transitEntries = new BeanList();
            this._ebean_intercept.initialisedMany(11);
        }
        return this.transitEntries;
    }

    protected /* synthetic */ void _ebean_set_transitEntries(List newValue) {
        this._ebean_intercept.preSetterMany(false, 11, this.transitEntries, (Object)newValue);
        this.transitEntries = newValue;
    }

    protected /* synthetic */ List _ebean_getni_transitEntries() {
        return this.transitEntries;
    }

    protected /* synthetic */ void _ebean_setni_transitEntries(List _newValue) {
        this.transitEntries = _newValue;
        this._ebean_intercept.setLoadedProperty(11);
    }

    protected /* synthetic */ List _ebean_get_dirInvEntries() {
        this._ebean_intercept.preGetter(12);
        if (this.dirInvEntries == null) {
            this.dirInvEntries = new BeanList();
            this._ebean_intercept.initialisedMany(12);
        }
        return this.dirInvEntries;
    }

    protected /* synthetic */ void _ebean_set_dirInvEntries(List newValue) {
        this._ebean_intercept.preSetterMany(false, 12, this.dirInvEntries, (Object)newValue);
        this.dirInvEntries = newValue;
    }

    protected /* synthetic */ List _ebean_getni_dirInvEntries() {
        return this.dirInvEntries;
    }

    protected /* synthetic */ void _ebean_setni_dirInvEntries(List _newValue) {
        this.dirInvEntries = _newValue;
        this._ebean_intercept.setLoadedProperty(12);
    }

    protected /* synthetic */ String _ebean_get_endToEndId() {
        this._ebean_intercept.preGetter(13);
        return this.endToEndId;
    }

    protected /* synthetic */ void _ebean_set_endToEndId(String newValue) {
        this._ebean_intercept.preSetter(true, 13, (Object)this._ebean_get_endToEndId(), (Object)newValue);
        this.endToEndId = newValue;
    }

    protected /* synthetic */ String _ebean_getni_endToEndId() {
        return this.endToEndId;
    }

    protected /* synthetic */ void _ebean_setni_endToEndId(String _newValue) {
        this.endToEndId = _newValue;
        this._ebean_intercept.setLoadedProperty(13);
    }

    protected /* synthetic */ Tenant _ebean_get_tenant() {
        this._ebean_intercept.preGetter(14);
        return this.tenant;
    }

    protected /* synthetic */ void _ebean_set_tenant(Tenant newValue) {
        this._ebean_intercept.preSetter(true, 14, (Object)this._ebean_get_tenant(), (Object)newValue);
        this.tenant = newValue;
    }

    protected /* synthetic */ Tenant _ebean_getni_tenant() {
        return this.tenant;
    }

    protected /* synthetic */ void _ebean_setni_tenant(Tenant _newValue) {
        this.tenant = _newValue;
        this._ebean_intercept.setLoadedProperty(14);
    }

    protected /* synthetic */ Origin _ebean_get_origin() {
        this._ebean_intercept.preGetter(15);
        return this.origin;
    }

    protected /* synthetic */ void _ebean_set_origin(Origin newValue) {
        this._ebean_intercept.preSetter(true, 15, (Object)this._ebean_get_origin(), (Object)newValue);
        this.origin = newValue;
    }

    protected /* synthetic */ Origin _ebean_getni_origin() {
        return this.origin;
    }

    protected /* synthetic */ void _ebean_setni_origin(Origin _newValue) {
        this.origin = _newValue;
        this._ebean_intercept.setLoadedProperty(15);
    }

    protected /* synthetic */ SignedPayment _ebean_get_signedPayment() {
        this._ebean_intercept.preGetter(16);
        return this.signedPayment;
    }

    protected /* synthetic */ void _ebean_set_signedPayment(SignedPayment newValue) {
        this._ebean_intercept.preSetter(true, 16, (Object)this._ebean_get_signedPayment(), (Object)newValue);
        this.signedPayment = newValue;
    }

    protected /* synthetic */ SignedPayment _ebean_getni_signedPayment() {
        return this.signedPayment;
    }

    protected /* synthetic */ void _ebean_setni_signedPayment(SignedPayment _newValue) {
        this.signedPayment = _newValue;
        this._ebean_intercept.setLoadedProperty(16);
    }

    protected /* synthetic */ CmBooking _ebean_get_cmBooking() {
        this._ebean_intercept.preGetter(17);
        return this.cmBooking;
    }

    protected /* synthetic */ void _ebean_set_cmBooking(CmBooking newValue) {
        this._ebean_intercept.preSetter(true, 17, (Object)this._ebean_get_cmBooking(), (Object)newValue);
        this.cmBooking = newValue;
    }

    protected /* synthetic */ CmBooking _ebean_getni_cmBooking() {
        return this.cmBooking;
    }

    protected /* synthetic */ void _ebean_setni_cmBooking(CmBooking _newValue) {
        this.cmBooking = _newValue;
        this._ebean_intercept.setLoadedProperty(17);
    }

    public /* synthetic */ Object _ebean_getField(int index) {
        switch (index) {
            case 0: {
                return this.id;
            }
            case 1: {
                return this.type;
            }
            case 2: {
                return this.reportMonth;
            }
            case 3: {
                return this.entryReporter;
            }
            case 4: {
                return this.category;
            }
            case 5: {
                return this.serviceCode;
            }
            case 6: {
                return this.reportReference;
            }
            case 7: {
                return this.cancellation;
            }
            case 8: {
                return this.comment;
            }
            case 9: {
                return this.exported;
            }
            case 10: {
                return this.dikaEntries;
            }
            case 11: {
                return this.transitEntries;
            }
            case 12: {
                return this.dirInvEntries;
            }
            case 13: {
                return this.endToEndId;
            }
            case 14: {
                return this.tenant;
            }
            case 15: {
                return this.origin;
            }
            case 16: {
                return this.signedPayment;
            }
            case 17: {
                return this.cmBooking;
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    public /* synthetic */ Object _ebean_getFieldIntercept(int index) {
        switch (index) {
            case 0: {
                return this._ebean_get_id();
            }
            case 1: {
                return this._ebean_get_type();
            }
            case 2: {
                return this._ebean_get_reportMonth();
            }
            case 3: {
                return this._ebean_get_entryReporter();
            }
            case 4: {
                return this._ebean_get_category();
            }
            case 5: {
                return this._ebean_get_serviceCode();
            }
            case 6: {
                return this._ebean_get_reportReference();
            }
            case 7: {
                return this._ebean_get_cancellation();
            }
            case 8: {
                return this._ebean_get_comment();
            }
            case 9: {
                return this._ebean_get_exported();
            }
            case 10: {
                return this._ebean_get_dikaEntries();
            }
            case 11: {
                return this._ebean_get_transitEntries();
            }
            case 12: {
                return this._ebean_get_dirInvEntries();
            }
            case 13: {
                return this._ebean_get_endToEndId();
            }
            case 14: {
                return this._ebean_get_tenant();
            }
            case 15: {
                return this._ebean_get_origin();
            }
            case 16: {
                return this._ebean_get_signedPayment();
            }
            case 17: {
                return this._ebean_get_cmBooking();
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    public /* synthetic */ void _ebean_setField(int index, Object o) {
        switch (index) {
            case 0: {
                this._ebean_setni_id((Integer)o);
                return;
            }
            case 1: {
                this._ebean_setni_type((EntryType)((Object)o));
                return;
            }
            case 2: {
                this._ebean_setni_reportMonth((String)o);
                return;
            }
            case 3: {
                this._ebean_setni_entryReporter((AwzelParticipantContactPerson)o);
                return;
            }
            case 4: {
                this._ebean_setni_category((Integer)o);
                return;
            }
            case 5: {
                this._ebean_setni_serviceCode((String)o);
                return;
            }
            case 6: {
                this._ebean_setni_reportReference((String)o);
                return;
            }
            case 7: {
                this._ebean_setni_cancellation((Boolean)o);
                return;
            }
            case 8: {
                this._ebean_setni_comment((String)o);
                return;
            }
            case 9: {
                this._ebean_setni_exported((Boolean)o);
                return;
            }
            case 10: {
                this._ebean_setni_dikaEntries((List)o);
                return;
            }
            case 11: {
                this._ebean_setni_transitEntries((List)o);
                return;
            }
            case 12: {
                this._ebean_setni_dirInvEntries((List)o);
                return;
            }
            case 13: {
                this._ebean_setni_endToEndId((String)o);
                return;
            }
            case 14: {
                this._ebean_setni_tenant((Tenant)o);
                return;
            }
            case 15: {
                this._ebean_setni_origin((Origin)((Object)o));
                return;
            }
            case 16: {
                this._ebean_setni_signedPayment((SignedPayment)o);
                return;
            }
            case 17: {
                this._ebean_setni_cmBooking((CmBooking)o);
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    public /* synthetic */ void _ebean_setFieldIntercept(int index, Object o) {
        switch (index) {
            case 0: {
                this._ebean_set_id((Integer)o);
                return;
            }
            case 1: {
                this._ebean_set_type((EntryType)((Object)o));
                return;
            }
            case 2: {
                this._ebean_set_reportMonth((String)o);
                return;
            }
            case 3: {
                this._ebean_set_entryReporter((AwzelParticipantContactPerson)o);
                return;
            }
            case 4: {
                this._ebean_set_category((Integer)o);
                return;
            }
            case 5: {
                this._ebean_set_serviceCode((String)o);
                return;
            }
            case 6: {
                this._ebean_set_reportReference((String)o);
                return;
            }
            case 7: {
                this._ebean_set_cancellation((Boolean)o);
                return;
            }
            case 8: {
                this._ebean_set_comment((String)o);
                return;
            }
            case 9: {
                this._ebean_set_exported((Boolean)o);
                return;
            }
            case 10: {
                this._ebean_set_dikaEntries((List)o);
                return;
            }
            case 11: {
                this._ebean_set_transitEntries((List)o);
                return;
            }
            case 12: {
                this._ebean_set_dirInvEntries((List)o);
                return;
            }
            case 13: {
                this._ebean_set_endToEndId((String)o);
                return;
            }
            case 14: {
                this._ebean_set_tenant((Tenant)o);
                return;
            }
            case 15: {
                this._ebean_set_origin((Origin)((Object)o));
                return;
            }
            case 16: {
                this._ebean_set_signedPayment((SignedPayment)o);
                return;
            }
            case 17: {
                this._ebean_set_cmBooking((CmBooking)o);
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private /* synthetic */ Object _ebean_getIdentity() {
        AwzelEntry awzelEntry = this;
        synchronized (awzelEntry) {
            if (this._ebean_identity != null) {
                return this._ebean_identity;
            }
            Object tmpId = this._ebean_getField(0);
            this._ebean_identity = tmpId != null ? tmpId : new Object();
            return this._ebean_identity;
        }
    }

    public /* synthetic */ boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        return this._ebean_getIdentity().equals(((AwzelEntry)obj)._ebean_getIdentity());
    }

    public /* synthetic */ int hashCode() {
        return this._ebean_getIdentity().hashCode();
    }

    public /* synthetic */ void _ebean_setEmbeddedLoaded() {
    }

    public /* synthetic */ boolean _ebean_isEmbeddedNewOrDirty() {
        return false;
    }

    public /* synthetic */ Object _ebean_newInstance() {
        return new AwzelEntry();
    }

    public static enum Origin {
        UNKNOWN,
        MANUAL,
        PAYMENT,
        ACCOUNT_STATEMENT;

    }

    public static enum EntryType {
        DIKA,
        TRANSIT,
        DIRINV;

    }
}

