/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.database.vo;

import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.Account;
import de.businesslogics.banking.database.vo.CmFolder;
import de.businesslogics.banking.database.vo.Conversion;
import de.businesslogics.banking.database.vo.ExportFile;
import de.businesslogics.banking.database.vo.Tenant;
import de.businesslogics.banking.database.vo.User;
import io.ebean.Query;
import io.ebean.Transaction;
import io.ebean.Update;
import io.ebean.bean.BeanCollection;
import io.ebean.bean.EntityBean;
import io.ebean.bean.EntityBeanIntercept;
import io.ebean.common.BeanList;
import java.util.Collection;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;

@Entity
public class AutomaticExport
implements EntityBean {
    @Id
    private Integer id;
    private String name;
    @ManyToOne
    private Conversion conversion;
    private Boolean convertToPdf;
    private String directory;
    private String pattern;
    private Boolean activated;
    @Column(name="type", nullable=false)
    private Type type;
    @ManyToMany
    private List<Account> accounts;
    @ManyToMany
    private List<CmFolder> folders;
    @ManyToMany(mappedBy="exports", fetch=FetchType.LAZY)
    private List<ExportFile> exportFiles;
    @ManyToOne(optional=false)
    private Tenant tenant;
    public static /* synthetic */ String[] _ebean_props;
    protected /* synthetic */ EntityBeanIntercept _ebean_intercept;
    protected transient /* synthetic */ Object _ebean_identity;

    public AutomaticExport() {
        this._ebean_intercept = new EntityBeanIntercept((Object)this);
        this._ebean_set_type(Type.STATEMENT);
    }

    public static void delete(Collection<AutomaticExport> toDelete) {
        try (Transaction t = DB.beginTransaction();){
            for (AutomaticExport a : toDelete) {
                a.accounts.clear();
                a.folders.clear();
                a.exportFiles.clear();
                a.save();
                DB.delete(a);
            }
            t.commit();
        }
    }

    public static int findCountByAccount(Account a) {
        return DB.find(AutomaticExport.class).where().eq("accounts", (Object)a).findCount();
    }

    public static int findCountForTenant(List<Tenant> tenants) {
        return DB.find(AutomaticExport.class).where().in("tenant", tenants).findCount();
    }

    public static AutomaticExport findByName(String name, Tenant tenant) {
        return (AutomaticExport)DB.find(AutomaticExport.class).where().eq("tenant", (Object)tenant).eq("name", (Object)name).findOne();
    }

    public static List<AutomaticExport> findActive(Tenant tenant) {
        return DB.find(AutomaticExport.class).where().eq("tenant", (Object)tenant).eq("activated", (Object)true).findList();
    }

    public static List<AutomaticExport> findByConversion(Collection<Conversion> conversions) {
        return DB.find(AutomaticExport.class).where().in("conversion", conversions).findList();
    }

    public static AutomaticExport findById(int id, User user) {
        return (AutomaticExport)DB.find(AutomaticExport.class).where().in("tenant", user.getVisibleTenants()).eq("id", (Object)id).findOne();
    }

    public static Query<AutomaticExport> findAllForTenants(List<Tenant> tenants) {
        return DB.find(AutomaticExport.class).where().in("tenant", tenants).query();
    }

    public Integer getId() {
        return this._ebean_get_id();
    }

    public void setId(Integer id) {
        this._ebean_set_id(id);
    }

    public Conversion getConversion() {
        return this._ebean_get_conversion();
    }

    public void setConversion(Conversion conversion) {
        this._ebean_set_conversion(conversion);
    }

    public String getDirectory() {
        return this._ebean_get_directory();
    }

    public void setDirectory(String directory) {
        this._ebean_set_directory(directory);
    }

    public String getPattern() {
        return this._ebean_get_pattern();
    }

    public void setPattern(String pattern) {
        this._ebean_set_pattern(pattern);
    }

    public boolean isActivated() {
        if (this._ebean_get_activated() == null) {
            return false;
        }
        return this._ebean_get_activated();
    }

    public void setActivated(boolean activated) {
        this._ebean_set_activated(activated);
    }

    public String getName() {
        return this._ebean_get_name();
    }

    public void setName(String name) {
        this._ebean_set_name(name);
    }

    public Type getType() {
        return this._ebean_get_type();
    }

    public void setType(Type type) {
        this._ebean_set_type(type);
    }

    public void save() {
        if (this.getId() == null) {
            DB.save(this);
        } else {
            DB.update(this);
        }
    }

    public static int removeFolder(CmFolder f) {
        Update<AutomaticExport> deleteAccount = DB.createUpdate(AutomaticExport.class, "DELETE FROM automatic_export_folder WHERE cm_folder_id=:folder");
        deleteAccount.setParameter("folder", (Object)f.getId());
        return deleteAccount.execute();
    }

    public List<Account> getAccounts() {
        return this._ebean_get_accounts();
    }

    public void setFolders(List<CmFolder> folders) {
        this._ebean_set_folders(folders);
    }

    public List<CmFolder> getFolders() {
        return this._ebean_get_folders();
    }

    public void setAccounts(List<Account> accounts) {
        this._ebean_set_accounts(accounts);
    }

    public boolean isConvertToPdf() {
        if (this._ebean_get_convertToPdf() == null) {
            return false;
        }
        return this._ebean_get_convertToPdf();
    }

    public void setConvertToPdf(boolean convertToPdf) {
        this._ebean_set_convertToPdf(convertToPdf);
    }

    public Tenant getTenant() {
        return this._ebean_get_tenant();
    }

    public void setTenant(Tenant tenant) {
        this._ebean_set_tenant(tenant);
    }

    static {
        _ebean_props = new String[]{"id", "name", "conversion", "convertToPdf", "directory", "pattern", "activated", "type", "accounts", "folders", "exportFiles", "tenant"};
    }

    public /* synthetic */ String[] _ebean_getPropertyNames() {
        return _ebean_props;
    }

    public /* synthetic */ String _ebean_getPropertyName(int pos) {
        return _ebean_props[pos];
    }

    public /* synthetic */ EntityBeanIntercept _ebean_getIntercept() {
        return this._ebean_intercept;
    }

    public /* synthetic */ EntityBeanIntercept _ebean_intercept() {
        if (this._ebean_intercept == null) {
            this._ebean_intercept = new EntityBeanIntercept((Object)this);
        }
        return this._ebean_intercept;
    }

    protected /* synthetic */ Integer _ebean_get_id() {
        this._ebean_intercept.preGetId();
        return this.id;
    }

    protected /* synthetic */ void _ebean_set_id(Integer newValue) {
        this._ebean_intercept.preSetter(false, 0, (Object)this.id, (Object)newValue);
        this.id = newValue;
    }

    protected /* synthetic */ Integer _ebean_getni_id() {
        return this.id;
    }

    protected /* synthetic */ void _ebean_setni_id(Integer _newValue) {
        this.id = _newValue;
        this._ebean_intercept.setLoadedProperty(0);
    }

    protected /* synthetic */ String _ebean_get_name() {
        this._ebean_intercept.preGetter(1);
        return this.name;
    }

    protected /* synthetic */ void _ebean_set_name(String newValue) {
        this._ebean_intercept.preSetter(true, 1, (Object)this._ebean_get_name(), (Object)newValue);
        this.name = newValue;
    }

    protected /* synthetic */ String _ebean_getni_name() {
        return this.name;
    }

    protected /* synthetic */ void _ebean_setni_name(String _newValue) {
        this.name = _newValue;
        this._ebean_intercept.setLoadedProperty(1);
    }

    protected /* synthetic */ Conversion _ebean_get_conversion() {
        this._ebean_intercept.preGetter(2);
        return this.conversion;
    }

    protected /* synthetic */ void _ebean_set_conversion(Conversion newValue) {
        this._ebean_intercept.preSetter(true, 2, (Object)this._ebean_get_conversion(), (Object)newValue);
        this.conversion = newValue;
    }

    protected /* synthetic */ Conversion _ebean_getni_conversion() {
        return this.conversion;
    }

    protected /* synthetic */ void _ebean_setni_conversion(Conversion _newValue) {
        this.conversion = _newValue;
        this._ebean_intercept.setLoadedProperty(2);
    }

    protected /* synthetic */ Boolean _ebean_get_convertToPdf() {
        this._ebean_intercept.preGetter(3);
        return this.convertToPdf;
    }

    protected /* synthetic */ void _ebean_set_convertToPdf(Boolean newValue) {
        this._ebean_intercept.preSetter(true, 3, (Object)this._ebean_get_convertToPdf(), (Object)newValue);
        this.convertToPdf = newValue;
    }

    protected /* synthetic */ Boolean _ebean_getni_convertToPdf() {
        return this.convertToPdf;
    }

    protected /* synthetic */ void _ebean_setni_convertToPdf(Boolean _newValue) {
        this.convertToPdf = _newValue;
        this._ebean_intercept.setLoadedProperty(3);
    }

    protected /* synthetic */ String _ebean_get_directory() {
        this._ebean_intercept.preGetter(4);
        return this.directory;
    }

    protected /* synthetic */ void _ebean_set_directory(String newValue) {
        this._ebean_intercept.preSetter(true, 4, (Object)this._ebean_get_directory(), (Object)newValue);
        this.directory = newValue;
    }

    protected /* synthetic */ String _ebean_getni_directory() {
        return this.directory;
    }

    protected /* synthetic */ void _ebean_setni_directory(String _newValue) {
        this.directory = _newValue;
        this._ebean_intercept.setLoadedProperty(4);
    }

    protected /* synthetic */ String _ebean_get_pattern() {
        this._ebean_intercept.preGetter(5);
        return this.pattern;
    }

    protected /* synthetic */ void _ebean_set_pattern(String newValue) {
        this._ebean_intercept.preSetter(true, 5, (Object)this._ebean_get_pattern(), (Object)newValue);
        this.pattern = newValue;
    }

    protected /* synthetic */ String _ebean_getni_pattern() {
        return this.pattern;
    }

    protected /* synthetic */ void _ebean_setni_pattern(String _newValue) {
        this.pattern = _newValue;
        this._ebean_intercept.setLoadedProperty(5);
    }

    protected /* synthetic */ Boolean _ebean_get_activated() {
        this._ebean_intercept.preGetter(6);
        return this.activated;
    }

    protected /* synthetic */ void _ebean_set_activated(Boolean newValue) {
        this._ebean_intercept.preSetter(true, 6, (Object)this._ebean_get_activated(), (Object)newValue);
        this.activated = newValue;
    }

    protected /* synthetic */ Boolean _ebean_getni_activated() {
        return this.activated;
    }

    protected /* synthetic */ void _ebean_setni_activated(Boolean _newValue) {
        this.activated = _newValue;
        this._ebean_intercept.setLoadedProperty(6);
    }

    protected /* synthetic */ Type _ebean_get_type() {
        this._ebean_intercept.preGetter(7);
        return this.type;
    }

    protected /* synthetic */ void _ebean_set_type(Type newValue) {
        this._ebean_intercept.preSetter(true, 7, (Object)this._ebean_get_type(), (Object)newValue);
        this.type = newValue;
    }

    protected /* synthetic */ Type _ebean_getni_type() {
        return this.type;
    }

    protected /* synthetic */ void _ebean_setni_type(Type _newValue) {
        this.type = _newValue;
        this._ebean_intercept.setLoadedProperty(7);
    }

    protected /* synthetic */ List _ebean_get_accounts() {
        this._ebean_intercept.preGetter(8);
        if (this.accounts == null) {
            this.accounts = new BeanList();
            this._ebean_intercept.initialisedMany(8);
            ((BeanCollection)this.accounts).setModifyListening(BeanCollection.ModifyListenMode.ALL);
        }
        return this.accounts;
    }

    protected /* synthetic */ void _ebean_set_accounts(List newValue) {
        this._ebean_intercept.preSetterMany(false, 8, this.accounts, (Object)newValue);
        this.accounts = newValue;
    }

    protected /* synthetic */ List _ebean_getni_accounts() {
        return this.accounts;
    }

    protected /* synthetic */ void _ebean_setni_accounts(List _newValue) {
        this.accounts = _newValue;
        this._ebean_intercept.setLoadedProperty(8);
    }

    protected /* synthetic */ List _ebean_get_folders() {
        this._ebean_intercept.preGetter(9);
        if (this.folders == null) {
            this.folders = new BeanList();
            this._ebean_intercept.initialisedMany(9);
            ((BeanCollection)this.folders).setModifyListening(BeanCollection.ModifyListenMode.ALL);
        }
        return this.folders;
    }

    protected /* synthetic */ void _ebean_set_folders(List newValue) {
        this._ebean_intercept.preSetterMany(false, 9, this.folders, (Object)newValue);
        this.folders = newValue;
    }

    protected /* synthetic */ List _ebean_getni_folders() {
        return this.folders;
    }

    protected /* synthetic */ void _ebean_setni_folders(List _newValue) {
        this.folders = _newValue;
        this._ebean_intercept.setLoadedProperty(9);
    }

    protected /* synthetic */ List _ebean_get_exportFiles() {
        this._ebean_intercept.preGetter(10);
        if (this.exportFiles == null) {
            this.exportFiles = new BeanList();
            this._ebean_intercept.initialisedMany(10);
            ((BeanCollection)this.exportFiles).setModifyListening(BeanCollection.ModifyListenMode.ALL);
        }
        return this.exportFiles;
    }

    protected /* synthetic */ void _ebean_set_exportFiles(List newValue) {
        this._ebean_intercept.preSetterMany(false, 10, this.exportFiles, (Object)newValue);
        this.exportFiles = newValue;
    }

    protected /* synthetic */ List _ebean_getni_exportFiles() {
        return this.exportFiles;
    }

    protected /* synthetic */ void _ebean_setni_exportFiles(List _newValue) {
        this.exportFiles = _newValue;
        this._ebean_intercept.setLoadedProperty(10);
    }

    protected /* synthetic */ Tenant _ebean_get_tenant() {
        this._ebean_intercept.preGetter(11);
        return this.tenant;
    }

    protected /* synthetic */ void _ebean_set_tenant(Tenant newValue) {
        this._ebean_intercept.preSetter(true, 11, (Object)this._ebean_get_tenant(), (Object)newValue);
        this.tenant = newValue;
    }

    protected /* synthetic */ Tenant _ebean_getni_tenant() {
        return this.tenant;
    }

    protected /* synthetic */ void _ebean_setni_tenant(Tenant _newValue) {
        this.tenant = _newValue;
        this._ebean_intercept.setLoadedProperty(11);
    }

    public /* synthetic */ Object _ebean_getField(int index) {
        switch (index) {
            case 0: {
                return this.id;
            }
            case 1: {
                return this.name;
            }
            case 2: {
                return this.conversion;
            }
            case 3: {
                return this.convertToPdf;
            }
            case 4: {
                return this.directory;
            }
            case 5: {
                return this.pattern;
            }
            case 6: {
                return this.activated;
            }
            case 7: {
                return this.type;
            }
            case 8: {
                return this.accounts;
            }
            case 9: {
                return this.folders;
            }
            case 10: {
                return this.exportFiles;
            }
            case 11: {
                return this.tenant;
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    public /* synthetic */ Object _ebean_getFieldIntercept(int index) {
        switch (index) {
            case 0: {
                return this._ebean_get_id();
            }
            case 1: {
                return this._ebean_get_name();
            }
            case 2: {
                return this._ebean_get_conversion();
            }
            case 3: {
                return this._ebean_get_convertToPdf();
            }
            case 4: {
                return this._ebean_get_directory();
            }
            case 5: {
                return this._ebean_get_pattern();
            }
            case 6: {
                return this._ebean_get_activated();
            }
            case 7: {
                return this._ebean_get_type();
            }
            case 8: {
                return this._ebean_get_accounts();
            }
            case 9: {
                return this._ebean_get_folders();
            }
            case 10: {
                return this._ebean_get_exportFiles();
            }
            case 11: {
                return this._ebean_get_tenant();
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    public /* synthetic */ void _ebean_setField(int index, Object o) {
        switch (index) {
            case 0: {
                this._ebean_setni_id((Integer)o);
                return;
            }
            case 1: {
                this._ebean_setni_name((String)o);
                return;
            }
            case 2: {
                this._ebean_setni_conversion((Conversion)o);
                return;
            }
            case 3: {
                this._ebean_setni_convertToPdf((Boolean)o);
                return;
            }
            case 4: {
                this._ebean_setni_directory((String)o);
                return;
            }
            case 5: {
                this._ebean_setni_pattern((String)o);
                return;
            }
            case 6: {
                this._ebean_setni_activated((Boolean)o);
                return;
            }
            case 7: {
                this._ebean_setni_type((Type)((Object)o));
                return;
            }
            case 8: {
                this._ebean_setni_accounts((List)o);
                return;
            }
            case 9: {
                this._ebean_setni_folders((List)o);
                return;
            }
            case 10: {
                this._ebean_setni_exportFiles((List)o);
                return;
            }
            case 11: {
                this._ebean_setni_tenant((Tenant)o);
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    public /* synthetic */ void _ebean_setFieldIntercept(int index, Object o) {
        switch (index) {
            case 0: {
                this._ebean_set_id((Integer)o);
                return;
            }
            case 1: {
                this._ebean_set_name((String)o);
                return;
            }
            case 2: {
                this._ebean_set_conversion((Conversion)o);
                return;
            }
            case 3: {
                this._ebean_set_convertToPdf((Boolean)o);
                return;
            }
            case 4: {
                this._ebean_set_directory((String)o);
                return;
            }
            case 5: {
                this._ebean_set_pattern((String)o);
                return;
            }
            case 6: {
                this._ebean_set_activated((Boolean)o);
                return;
            }
            case 7: {
                this._ebean_set_type((Type)((Object)o));
                return;
            }
            case 8: {
                this._ebean_set_accounts((List)o);
                return;
            }
            case 9: {
                this._ebean_set_folders((List)o);
                return;
            }
            case 10: {
                this._ebean_set_exportFiles((List)o);
                return;
            }
            case 11: {
                this._ebean_set_tenant((Tenant)o);
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private /* synthetic */ Object _ebean_getIdentity() {
        AutomaticExport automaticExport = this;
        synchronized (automaticExport) {
            if (this._ebean_identity != null) {
                return this._ebean_identity;
            }
            Object tmpId = this._ebean_getField(0);
            this._ebean_identity = tmpId != null ? tmpId : new Object();
            return this._ebean_identity;
        }
    }

    public /* synthetic */ boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        return this._ebean_getIdentity().equals(((AutomaticExport)obj)._ebean_getIdentity());
    }

    public /* synthetic */ int hashCode() {
        return this._ebean_getIdentity().hashCode();
    }

    public /* synthetic */ void _ebean_setEmbeddedLoaded() {
    }

    public /* synthetic */ boolean _ebean_isEmbeddedNewOrDirty() {
        return false;
    }

    public /* synthetic */ Object _ebean_newInstance() {
        return new AutomaticExport();
    }

    public static enum Type {
        STATEMENT,
        ADVICE,
        BATCHED_TRANSACTION_FILE;

    }
}

