/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.database.vo;

import de.businesslogics.banking.database.api.DB;
import io.ebean.bean.EntityBean;
import io.ebean.bean.EntityBeanIntercept;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;

@Entity
@Table(name="applicationinfo")
public class ApplicationInfo
implements EntityBean {
    private static final String IMPORTED_ENC_KEY_PREFIX = "IMPORTED_ENC_KEY_";
    @Column(name="prop_name", nullable=false, length=50, unique=true)
    @Id
    private String propName;
    @Column(name="prop_value", length=500)
    private String propValue;
    public static /* synthetic */ String[] _ebean_props;
    protected /* synthetic */ EntityBeanIntercept _ebean_intercept;
    protected transient /* synthetic */ Object _ebean_identity;

    public ApplicationInfo() {
        this._ebean_intercept = new EntityBeanIntercept((Object)this);
    }

    public static ApplicationInfo createInstance(PropKey key, String value) {
        ApplicationInfo i = new ApplicationInfo();
        i.setPropName(key.name());
        i.setPropValue(value);
        return i;
    }

    public static ApplicationInfo findByKey(PropKey key) {
        return DB.find(ApplicationInfo.class, key.name());
    }

    public String getPropName() {
        return this._ebean_get_propName();
    }

    public void setPropName(String propName) {
        this._ebean_set_propName(propName);
    }

    public String getPropValue() {
        return this._ebean_get_propValue();
    }

    public void setPropValue(String propValue) {
        this._ebean_set_propValue(propValue);
    }

    public static Set<String> findImportedEncKeys() {
        List vos = DB.find(ApplicationInfo.class).where().like("propName", "IMPORTED_ENC_KEY_%").findList();
        if (vos != null && vos.size() > 0) {
            HashSet<String> importedEncKeys = new HashSet<String>();
            for (ApplicationInfo vo : vos) {
                importedEncKeys.add(vo.getPropValue());
            }
            return importedEncKeys;
        }
        return null;
    }

    public static String getNextImportedEncKeyPropName() {
        int nextId = 1;
        List vos = DB.find(ApplicationInfo.class).where().like("propName", "IMPORTED_ENC_KEY_%").findList();
        if (vos != null && vos.size() > 0) {
            for (ApplicationInfo vo : vos) {
                String propName = vo.getPropName();
                try {
                    int id = Integer.parseInt(propName.substring(IMPORTED_ENC_KEY_PREFIX.length()));
                    nextId = Math.max(id, nextId);
                    ++nextId;
                }
                catch (Exception exception) {}
            }
        }
        return IMPORTED_ENC_KEY_PREFIX + nextId;
    }

    public static ApplicationInfo findByPropName(String name) {
        return DB.find(ApplicationInfo.class, name);
    }

    public void update() {
        DB.update(this);
    }

    public void save() {
        DB.save(this);
    }

    static {
        _ebean_props = new String[]{"propName", "propValue"};
    }

    public /* synthetic */ String[] _ebean_getPropertyNames() {
        return _ebean_props;
    }

    public /* synthetic */ String _ebean_getPropertyName(int pos) {
        return _ebean_props[pos];
    }

    public /* synthetic */ EntityBeanIntercept _ebean_getIntercept() {
        return this._ebean_intercept;
    }

    public /* synthetic */ EntityBeanIntercept _ebean_intercept() {
        if (this._ebean_intercept == null) {
            this._ebean_intercept = new EntityBeanIntercept((Object)this);
        }
        return this._ebean_intercept;
    }

    protected /* synthetic */ String _ebean_get_propName() {
        this._ebean_intercept.preGetId();
        return this.propName;
    }

    protected /* synthetic */ void _ebean_set_propName(String newValue) {
        this._ebean_intercept.preSetter(false, 0, (Object)this.propName, (Object)newValue);
        this.propName = newValue;
    }

    protected /* synthetic */ String _ebean_getni_propName() {
        return this.propName;
    }

    protected /* synthetic */ void _ebean_setni_propName(String _newValue) {
        this.propName = _newValue;
        this._ebean_intercept.setLoadedProperty(0);
    }

    protected /* synthetic */ String _ebean_get_propValue() {
        this._ebean_intercept.preGetter(1);
        return this.propValue;
    }

    protected /* synthetic */ void _ebean_set_propValue(String newValue) {
        this._ebean_intercept.preSetter(true, 1, (Object)this._ebean_get_propValue(), (Object)newValue);
        this.propValue = newValue;
    }

    protected /* synthetic */ String _ebean_getni_propValue() {
        return this.propValue;
    }

    protected /* synthetic */ void _ebean_setni_propValue(String _newValue) {
        this.propValue = _newValue;
        this._ebean_intercept.setLoadedProperty(1);
    }

    public /* synthetic */ Object _ebean_getField(int index) {
        switch (index) {
            case 0: {
                return this.propName;
            }
            case 1: {
                return this.propValue;
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    public /* synthetic */ Object _ebean_getFieldIntercept(int index) {
        switch (index) {
            case 0: {
                return this._ebean_get_propName();
            }
            case 1: {
                return this._ebean_get_propValue();
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    public /* synthetic */ void _ebean_setField(int index, Object o) {
        switch (index) {
            case 0: {
                this._ebean_setni_propName((String)o);
                return;
            }
            case 1: {
                this._ebean_setni_propValue((String)o);
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    public /* synthetic */ void _ebean_setFieldIntercept(int index, Object o) {
        switch (index) {
            case 0: {
                this._ebean_set_propName((String)o);
                return;
            }
            case 1: {
                this._ebean_set_propValue((String)o);
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private /* synthetic */ Object _ebean_getIdentity() {
        ApplicationInfo applicationInfo = this;
        synchronized (applicationInfo) {
            if (this._ebean_identity != null) {
                return this._ebean_identity;
            }
            Object tmpId = this._ebean_getField(0);
            this._ebean_identity = tmpId != null ? tmpId : new Object();
            return this._ebean_identity;
        }
    }

    public /* synthetic */ boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        return this._ebean_getIdentity().equals(((ApplicationInfo)obj)._ebean_getIdentity());
    }

    public /* synthetic */ int hashCode() {
        return this._ebean_getIdentity().hashCode();
    }

    public /* synthetic */ void _ebean_setEmbeddedLoaded() {
    }

    public /* synthetic */ boolean _ebean_isEmbeddedNewOrDirty() {
        return false;
    }

    public /* synthetic */ Object _ebean_newInstance() {
        return new ApplicationInfo();
    }

    public static enum PropKey {
        db_layout,
        DEFAULT_USER,
        PROXY_HOST,
        PROXY_PORT,
        PROXY_USER,
        PROXY_PASSWORD,
        DATA_ENC_KEY,
        END_TO_END_ID_NUMBER;


        public static PropKey getByName(String name) {
            for (PropKey propKey : PropKey.values()) {
                if (!propKey.name().equals(name)) continue;
                return propKey;
            }
            return null;
        }
    }
}

