/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.database.vo;

import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.Account;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.BankUser;
import de.businesslogics.banking.database.vo.User;
import io.ebean.Update;
import io.ebean.annotation.DbDefault;
import io.ebean.bean.EntityBean;
import io.ebean.bean.EntityBeanIntercept;
import java.math.BigDecimal;
import java.util.List;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.UniqueConstraint;

@Entity
@UniqueConstraint(columnNames={"bank_user_id", "account_id"})
public class ApOverwrite
implements EntityBean {
    @Id
    private Integer id;
    @ManyToOne(optional=false)
    private BankUser bankUser;
    @ManyToOne(optional=false)
    private Account account;
    @DbDefault(value="true")
    private boolean previousEnabled;
    private BigDecimal amountLimit;
    public static /* synthetic */ String[] _ebean_props;
    protected /* synthetic */ EntityBeanIntercept _ebean_intercept;
    protected transient /* synthetic */ Object _ebean_identity;

    public ApOverwrite() {
        this._ebean_intercept = new EntityBeanIntercept((Object)this);
        this._ebean_set_previousEnabled(true);
    }

    public static int deleteByUser(User user) {
        Update<ApOverwrite> delete = DB.createUpdate(ApOverwrite.class, "DELETE FROM ApOverwrite WHERE bankUser IN (SELECT id FROM bankuser WHERE user_id=:user)");
        delete.setParameter("user", (Object)user.getId());
        return delete.execute();
    }

    public static int deleteByBankUser(BankUser user) {
        Update<ApOverwrite> delete = DB.createUpdate(ApOverwrite.class, "DELETE FROM ApOverwrite WHERE bankUser=:user");
        delete.setParameter("user", (Object)user.getId());
        return delete.execute();
    }

    public static int deleteAll(BankSettings bank) {
        Update<ApOverwrite> delete = DB.createUpdate(ApOverwrite.class, "DELETE FROM ApOverwrite WHERE bankUser IN (SELECT id FROM bankuser WHERE bank_id=:bank)");
        delete.setParameter("bank", (Object)bank.getBankId());
        return delete.execute();
    }

    public static int deleteAll(Account a) {
        Update<ApOverwrite> delete = DB.createUpdate(ApOverwrite.class, "DELETE FROM ApOverwrite WHERE account=:account");
        delete.setParameter("account", (Object)a.getId());
        return delete.execute();
    }

    public static List<ApOverwrite> findByUser(User u) {
        return DB.find(ApOverwrite.class).where().eq("bankUser.user", (Object)u).findList();
    }

    public static ApOverwrite findByBankAndAccount(BankUser user, Account a) {
        return (ApOverwrite)DB.find(ApOverwrite.class).where().eq("bankUser", (Object)user).eq("account", (Object)a).findOne();
    }

    public Integer getId() {
        return this._ebean_get_id();
    }

    public void setId(Integer id) {
        this._ebean_set_id(id);
    }

    public BankUser getBankUser() {
        return this._ebean_get_bankUser();
    }

    public void setBankUser(BankUser bankUser) {
        this._ebean_set_bankUser(bankUser);
    }

    public Account getAccount() {
        return this._ebean_get_account();
    }

    public void setAccount(Account account) {
        this._ebean_set_account(account);
    }

    public void save() {
        DB.save(this);
    }

    public void delete() {
        DB.delete(this);
    }

    public boolean isPreviousEnabled() {
        return this._ebean_get_previousEnabled();
    }

    public void setPreviousEnabled(boolean previousEnabled) {
        this._ebean_set_previousEnabled(previousEnabled);
    }

    public BigDecimal getAmountLimit() {
        return this._ebean_get_amountLimit();
    }

    public void setAmountLimit(BigDecimal amountLimit) {
        this._ebean_set_amountLimit(amountLimit);
    }

    static {
        _ebean_props = new String[]{"id", "bankUser", "account", "previousEnabled", "amountLimit"};
    }

    public /* synthetic */ String[] _ebean_getPropertyNames() {
        return _ebean_props;
    }

    public /* synthetic */ String _ebean_getPropertyName(int pos) {
        return _ebean_props[pos];
    }

    public /* synthetic */ EntityBeanIntercept _ebean_getIntercept() {
        return this._ebean_intercept;
    }

    public /* synthetic */ EntityBeanIntercept _ebean_intercept() {
        if (this._ebean_intercept == null) {
            this._ebean_intercept = new EntityBeanIntercept((Object)this);
        }
        return this._ebean_intercept;
    }

    protected /* synthetic */ Integer _ebean_get_id() {
        this._ebean_intercept.preGetId();
        return this.id;
    }

    protected /* synthetic */ void _ebean_set_id(Integer newValue) {
        this._ebean_intercept.preSetter(false, 0, (Object)this.id, (Object)newValue);
        this.id = newValue;
    }

    protected /* synthetic */ Integer _ebean_getni_id() {
        return this.id;
    }

    protected /* synthetic */ void _ebean_setni_id(Integer _newValue) {
        this.id = _newValue;
        this._ebean_intercept.setLoadedProperty(0);
    }

    protected /* synthetic */ BankUser _ebean_get_bankUser() {
        this._ebean_intercept.preGetter(1);
        return this.bankUser;
    }

    protected /* synthetic */ void _ebean_set_bankUser(BankUser newValue) {
        this._ebean_intercept.preSetter(true, 1, (Object)this._ebean_get_bankUser(), (Object)newValue);
        this.bankUser = newValue;
    }

    protected /* synthetic */ BankUser _ebean_getni_bankUser() {
        return this.bankUser;
    }

    protected /* synthetic */ void _ebean_setni_bankUser(BankUser _newValue) {
        this.bankUser = _newValue;
        this._ebean_intercept.setLoadedProperty(1);
    }

    protected /* synthetic */ Account _ebean_get_account() {
        this._ebean_intercept.preGetter(2);
        return this.account;
    }

    protected /* synthetic */ void _ebean_set_account(Account newValue) {
        this._ebean_intercept.preSetter(true, 2, (Object)this._ebean_get_account(), (Object)newValue);
        this.account = newValue;
    }

    protected /* synthetic */ Account _ebean_getni_account() {
        return this.account;
    }

    protected /* synthetic */ void _ebean_setni_account(Account _newValue) {
        this.account = _newValue;
        this._ebean_intercept.setLoadedProperty(2);
    }

    protected /* synthetic */ boolean _ebean_get_previousEnabled() {
        this._ebean_intercept.preGetter(3);
        return this.previousEnabled;
    }

    protected /* synthetic */ void _ebean_set_previousEnabled(boolean newValue) {
        this._ebean_intercept.preSetter(true, 3, this._ebean_get_previousEnabled(), newValue);
        this.previousEnabled = newValue;
    }

    protected /* synthetic */ boolean _ebean_getni_previousEnabled() {
        return this.previousEnabled;
    }

    protected /* synthetic */ void _ebean_setni_previousEnabled(boolean _newValue) {
        this.previousEnabled = _newValue;
        this._ebean_intercept.setLoadedProperty(3);
    }

    protected /* synthetic */ BigDecimal _ebean_get_amountLimit() {
        this._ebean_intercept.preGetter(4);
        return this.amountLimit;
    }

    protected /* synthetic */ void _ebean_set_amountLimit(BigDecimal newValue) {
        this._ebean_intercept.preSetter(true, 4, (Object)this._ebean_get_amountLimit(), (Object)newValue);
        this.amountLimit = newValue;
    }

    protected /* synthetic */ BigDecimal _ebean_getni_amountLimit() {
        return this.amountLimit;
    }

    protected /* synthetic */ void _ebean_setni_amountLimit(BigDecimal _newValue) {
        this.amountLimit = _newValue;
        this._ebean_intercept.setLoadedProperty(4);
    }

    public /* synthetic */ Object _ebean_getField(int index) {
        switch (index) {
            case 0: {
                return this.id;
            }
            case 1: {
                return this.bankUser;
            }
            case 2: {
                return this.account;
            }
            case 3: {
                return this.previousEnabled;
            }
            case 4: {
                return this.amountLimit;
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    public /* synthetic */ Object _ebean_getFieldIntercept(int index) {
        switch (index) {
            case 0: {
                return this._ebean_get_id();
            }
            case 1: {
                return this._ebean_get_bankUser();
            }
            case 2: {
                return this._ebean_get_account();
            }
            case 3: {
                return this._ebean_get_previousEnabled();
            }
            case 4: {
                return this._ebean_get_amountLimit();
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    public /* synthetic */ void _ebean_setField(int index, Object o) {
        switch (index) {
            case 0: {
                this._ebean_setni_id((Integer)o);
                return;
            }
            case 1: {
                this._ebean_setni_bankUser((BankUser)o);
                return;
            }
            case 2: {
                this._ebean_setni_account((Account)o);
                return;
            }
            case 3: {
                this._ebean_setni_previousEnabled((Boolean)o);
                return;
            }
            case 4: {
                this._ebean_setni_amountLimit((BigDecimal)o);
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    public /* synthetic */ void _ebean_setFieldIntercept(int index, Object o) {
        switch (index) {
            case 0: {
                this._ebean_set_id((Integer)o);
                return;
            }
            case 1: {
                this._ebean_set_bankUser((BankUser)o);
                return;
            }
            case 2: {
                this._ebean_set_account((Account)o);
                return;
            }
            case 3: {
                this._ebean_set_previousEnabled((Boolean)o);
                return;
            }
            case 4: {
                this._ebean_set_amountLimit((BigDecimal)o);
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private /* synthetic */ Object _ebean_getIdentity() {
        ApOverwrite apOverwrite = this;
        synchronized (apOverwrite) {
            if (this._ebean_identity != null) {
                return this._ebean_identity;
            }
            Object tmpId = this._ebean_getField(0);
            this._ebean_identity = tmpId != null ? tmpId : new Object();
            return this._ebean_identity;
        }
    }

    public /* synthetic */ boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        return this._ebean_getIdentity().equals(((ApOverwrite)obj)._ebean_getIdentity());
    }

    public /* synthetic */ int hashCode() {
        return this._ebean_getIdentity().hashCode();
    }

    public /* synthetic */ void _ebean_setEmbeddedLoaded() {
    }

    public /* synthetic */ boolean _ebean_isEmbeddedNewOrDirty() {
        return false;
    }

    public /* synthetic */ Object _ebean_newInstance() {
        return new ApOverwrite();
    }
}

