/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.database.vo;

import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.Account;
import de.businesslogics.banking.database.vo.ApOverwrite;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.BankUser;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.banking.database.vo.UserPermission;
import io.ebean.Query;
import io.ebean.Update;
import io.ebean.bean.EntityBean;
import io.ebean.bean.EntityBeanIntercept;
import java.util.List;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.UniqueConstraint;

@Entity
@UniqueConstraint(columnNames={"bank_user_id", "account_id"})
public class AccountPermission
implements EntityBean {
    @Id
    private Integer id;
    @ManyToOne(optional=false)
    private BankUser bankUser;
    @ManyToOne(optional=false)
    private Account account;
    public static /* synthetic */ String[] _ebean_props;
    protected /* synthetic */ EntityBeanIntercept _ebean_intercept;
    protected transient /* synthetic */ Object _ebean_identity;

    public AccountPermission() {
        this._ebean_intercept = new EntityBeanIntercept((Object)this);
    }

    public static int deleteByUser(User user) {
        Update<AccountPermission> delete = DB.createUpdate(AccountPermission.class, "DELETE FROM AccountPermission WHERE bankUser IN (SELECT id FROM bankuser WHERE user_id=:user)");
        delete.setParameter("user", (Object)user.getId());
        return delete.execute();
    }

    public static int deleteByBankUser(BankUser user) {
        Update<AccountPermission> delete = DB.createUpdate(AccountPermission.class, "DELETE FROM AccountPermission WHERE bankUser=:user");
        delete.setParameter("user", (Object)user.getId());
        return delete.execute();
    }

    public static int deleteAll(BankSettings bank) {
        Update<AccountPermission> delete = DB.createUpdate(AccountPermission.class, "DELETE FROM AccountPermission WHERE bankUser IN (SELECT id FROM bankuser WHERE bank_id=:bank)");
        delete.setParameter("bank", (Object)bank.getBankId());
        return delete.execute();
    }

    public static int deleteAll(Account a) {
        Update<AccountPermission> delete = DB.createUpdate(AccountPermission.class, "DELETE FROM AccountPermission WHERE account=:account");
        delete.setParameter("account", (Object)a.getId());
        return delete.execute();
    }

    public static List<AccountPermission> findByUser(User u) {
        return DB.find(AccountPermission.class).where().eq("bankUser.user", (Object)u).findList();
    }

    public static void createPermissionForAllUsers(Account a) {
        for (BankUser user : BankUser.findActiveBankUsersForBank(a.getBank())) {
            AccountPermission p = AccountPermission.findAccountPermissionForBank(user, a);
            if (p != null) continue;
            p = new AccountPermission();
            p.setAccount(a);
            p.setBankUser(user);
            p.save();
        }
    }

    public static AccountPermission findAccountPermissionForBank(BankUser bankUser, Account account) {
        if (bankUser == null || account == null) {
            return null;
        }
        return (AccountPermission)DB.find(AccountPermission.class).where().eq("bankUser", (Object)bankUser).eq("account", (Object)account).findOne();
    }

    public static Query<AccountPermission> findByBankUser(BankUser bankUser) {
        return DB.find(AccountPermission.class).where().eq("bankUser", (Object)bankUser).order("account.bic,account.germanBankCode,account.frenchBankCode,account.frenchBranchCode,account.nationalBankCode,account.iban,account.germanAccountNumber,account.frenchAccountNumber,account.nationalAccountNumber").query();
    }

    public static void deleteForUser(BankUser user, List<Account> toDelete) {
        int start = 0;
        int end = 0;
        do {
            end = Math.min(start + 900, toDelete.size());
            List list = DB.find(AccountPermission.class).where().eq("bankUser", (Object)user).in("account", toDelete.subList(start, end)).findList();
            for (AccountPermission p : list) {
                ApOverwrite overwrite = ApOverwrite.findByBankAndAccount(p.getBankUser(), p.getAccount());
                if (overwrite != null) continue;
                UserPermission.deleteAll(p);
                p.delete();
            }
            start = end;
        } while (end < toDelete.size());
    }

    public Integer getId() {
        return this._ebean_get_id();
    }

    public void setId(Integer id) {
        this._ebean_set_id(id);
    }

    public BankUser getBankUser() {
        return this._ebean_get_bankUser();
    }

    public void setBankUser(BankUser bankUser) {
        this._ebean_set_bankUser(bankUser);
    }

    public Account getAccount() {
        return this._ebean_get_account();
    }

    public void setAccount(Account account) {
        this._ebean_set_account(account);
    }

    public void save() {
        DB.save(this);
    }

    public void delete() {
        UserPermission.deleteAll(this);
        DB.delete(this);
    }

    static {
        _ebean_props = new String[]{"id", "bankUser", "account"};
    }

    public /* synthetic */ String[] _ebean_getPropertyNames() {
        return _ebean_props;
    }

    public /* synthetic */ String _ebean_getPropertyName(int pos) {
        return _ebean_props[pos];
    }

    public /* synthetic */ EntityBeanIntercept _ebean_getIntercept() {
        return this._ebean_intercept;
    }

    public /* synthetic */ EntityBeanIntercept _ebean_intercept() {
        if (this._ebean_intercept == null) {
            this._ebean_intercept = new EntityBeanIntercept((Object)this);
        }
        return this._ebean_intercept;
    }

    protected /* synthetic */ Integer _ebean_get_id() {
        this._ebean_intercept.preGetId();
        return this.id;
    }

    protected /* synthetic */ void _ebean_set_id(Integer newValue) {
        this._ebean_intercept.preSetter(false, 0, (Object)this.id, (Object)newValue);
        this.id = newValue;
    }

    protected /* synthetic */ Integer _ebean_getni_id() {
        return this.id;
    }

    protected /* synthetic */ void _ebean_setni_id(Integer _newValue) {
        this.id = _newValue;
        this._ebean_intercept.setLoadedProperty(0);
    }

    protected /* synthetic */ BankUser _ebean_get_bankUser() {
        this._ebean_intercept.preGetter(1);
        return this.bankUser;
    }

    protected /* synthetic */ void _ebean_set_bankUser(BankUser newValue) {
        this._ebean_intercept.preSetter(true, 1, (Object)this._ebean_get_bankUser(), (Object)newValue);
        this.bankUser = newValue;
    }

    protected /* synthetic */ BankUser _ebean_getni_bankUser() {
        return this.bankUser;
    }

    protected /* synthetic */ void _ebean_setni_bankUser(BankUser _newValue) {
        this.bankUser = _newValue;
        this._ebean_intercept.setLoadedProperty(1);
    }

    protected /* synthetic */ Account _ebean_get_account() {
        this._ebean_intercept.preGetter(2);
        return this.account;
    }

    protected /* synthetic */ void _ebean_set_account(Account newValue) {
        this._ebean_intercept.preSetter(true, 2, (Object)this._ebean_get_account(), (Object)newValue);
        this.account = newValue;
    }

    protected /* synthetic */ Account _ebean_getni_account() {
        return this.account;
    }

    protected /* synthetic */ void _ebean_setni_account(Account _newValue) {
        this.account = _newValue;
        this._ebean_intercept.setLoadedProperty(2);
    }

    public /* synthetic */ Object _ebean_getField(int index) {
        switch (index) {
            case 0: {
                return this.id;
            }
            case 1: {
                return this.bankUser;
            }
            case 2: {
                return this.account;
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    public /* synthetic */ Object _ebean_getFieldIntercept(int index) {
        switch (index) {
            case 0: {
                return this._ebean_get_id();
            }
            case 1: {
                return this._ebean_get_bankUser();
            }
            case 2: {
                return this._ebean_get_account();
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    public /* synthetic */ void _ebean_setField(int index, Object o) {
        switch (index) {
            case 0: {
                this._ebean_setni_id((Integer)o);
                return;
            }
            case 1: {
                this._ebean_setni_bankUser((BankUser)o);
                return;
            }
            case 2: {
                this._ebean_setni_account((Account)o);
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    public /* synthetic */ void _ebean_setFieldIntercept(int index, Object o) {
        switch (index) {
            case 0: {
                this._ebean_set_id((Integer)o);
                return;
            }
            case 1: {
                this._ebean_set_bankUser((BankUser)o);
                return;
            }
            case 2: {
                this._ebean_set_account((Account)o);
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private /* synthetic */ Object _ebean_getIdentity() {
        AccountPermission accountPermission = this;
        synchronized (accountPermission) {
            if (this._ebean_identity != null) {
                return this._ebean_identity;
            }
            Object tmpId = this._ebean_getField(0);
            this._ebean_identity = tmpId != null ? tmpId : new Object();
            return this._ebean_identity;
        }
    }

    public /* synthetic */ boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        return this._ebean_getIdentity().equals(((AccountPermission)obj)._ebean_getIdentity());
    }

    public /* synthetic */ int hashCode() {
        return this._ebean_getIdentity().hashCode();
    }

    public /* synthetic */ void _ebean_setEmbeddedLoaded() {
    }

    public /* synthetic */ boolean _ebean_isEmbeddedNewOrDirty() {
        return false;
    }

    public /* synthetic */ Object _ebean_newInstance() {
        return new AccountPermission();
    }
}

