/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.database.vo;

import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.AccountPermission;
import de.businesslogics.banking.database.vo.ApOverwrite;
import de.businesslogics.banking.database.vo.AutomaticExport;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.BankUser;
import de.businesslogics.banking.database.vo.CmFolder;
import de.businesslogics.banking.database.vo.CmPdfStatement;
import de.businesslogics.banking.database.vo.CmStatement;
import de.businesslogics.banking.database.vo.CmValueGroup;
import de.businesslogics.banking.database.vo.DsOrderDetails;
import de.businesslogics.banking.database.vo.ExportFile;
import de.businesslogics.banking.database.vo.Log;
import de.businesslogics.banking.database.vo.OpenPayment;
import de.businesslogics.banking.database.vo.PaymentOriginator;
import de.businesslogics.banking.database.vo.PaymentTemplate;
import de.businesslogics.banking.database.vo.PeriodicPayment;
import de.businesslogics.banking.database.vo.Send;
import de.businesslogics.banking.database.vo.SendFilter;
import de.businesslogics.banking.database.vo.SignedPayment;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.banking.database.vo.UserEffectivePermission;
import de.businesslogics.iban.IbanUtil;
import de.businesslogics.util.PaymentUtils;
import de.businesslogics.util.StringUtils;
import io.ebean.Expr;
import io.ebean.Expression;
import io.ebean.ExpressionList;
import io.ebean.Query;
import io.ebean.SqlQuery;
import io.ebean.SqlRow;
import io.ebean.Update;
import io.ebean.annotation.Index;
import io.ebean.annotation.Indices;
import io.ebean.bean.BeanCollection;
import io.ebean.bean.EntityBean;
import io.ebean.bean.EntityBeanIntercept;
import io.ebean.common.BeanList;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;

@Entity
@Indices(value={@Index(name="ix_account_cm_identification", columnNames={"bank_id", "cm_identification"}), @Index(name="ix_account_iban", columnNames={"bank_id", "iban", "currency"}), @Index(name="ix_account_iban_bic", columnNames={"bank_id", "iban", "bic", "currency"}), @Index(name="ix_account_german", columnNames={"bank_id", "de_bank_code", "de_account_number", "currency"}), @Index(name="ix_account_french", columnNames={"bank_id", "fr_bank_code", "fr_branch_code", "fr_account_number", "currency"})})
public class Account
implements EntityBean {
    private static final String DISPLAY_NAME_SEPARATOR = " / ";
    private static final String EUR = "EUR";
    @Id
    private Integer id;
    @ManyToOne(optional=false)
    private BankSettings bank;
    @Column(length=50, nullable=false)
    private String name;
    @Column(length=256)
    private String description;
    @Column(length=256)
    private String accountHolder;
    @Column(length=256)
    private String accountHolderHTD;
    @Lob
    private String infoText;
    @ManyToOne
    private PaymentOriginator sepaOriginator;
    @ManyToOne
    private PaymentOriginator dtazvOriginator;
    @ManyToOne
    private PaymentOriginator mt101Originator;
    @Column(name="de_bank_code", length=8)
    private String germanBankCode;
    @Column(name="de_account_number", length=10)
    private String germanAccountNumber;
    @Column(name="fr_bank_code", length=5)
    private String frenchBankCode;
    @Column(name="fr_branch_code", length=5)
    private String frenchBranchCode;
    @Column(name="fr_account_number", length=11)
    private String frenchAccountNumber;
    @Column(name="fr_check_code", length=2)
    private String frenchCheckCode;
    @Column(length=34)
    private String iban;
    @Column(length=11)
    private String bic;
    @Column(length=30)
    private String nationalBankCode;
    @Column(length=40)
    private String nationalAccountNumber;
    @Column(length=3)
    private String currency;
    @Column(length=256)
    private String cmIdentification;
    @Column(precision=38, scale=3)
    private BigDecimal creditLimit;
    @Column(precision=38, scale=3)
    private BigDecimal ipLimit;
    private LimitType ipLimitType;
    private LimitState ipLimitState;
    private Timestamp ipLimitTime;
    @Column(length=35)
    private String ipLimitMsgId;
    @Column(precision=38, scale=3)
    private BigDecimal investmentAmount;
    private Type type;
    @ManyToOne
    private CmFolder folder;
    @OneToMany(fetch=FetchType.LAZY)
    private List<AccountPermission> permissions;
    @ManyToMany(mappedBy="accounts", fetch=FetchType.LAZY)
    private List<CmValueGroup> valueGroups;
    @ManyToMany(mappedBy="accounts", fetch=FetchType.LAZY)
    private List<AutomaticExport> automaticExports;
    private Boolean useVirtualBalances;
    @Column(precision=38, scale=3)
    private BigDecimal virtualStartBalance;
    private Date virtualStartDate;
    private Boolean ignoreAccountInformation;
    public static /* synthetic */ String[] _ebean_props;
    protected /* synthetic */ EntityBeanIntercept _ebean_intercept;
    protected transient /* synthetic */ Object _ebean_identity;

    public Account() {
        this._ebean_intercept = new EntityBeanIntercept((Object)this);
        this._ebean_set_ipLimitType(LimitType.DAY_LIMIT);
        this._ebean_set_ipLimitState(LimitState.CONFIRMED);
        this._ebean_set_type(Type.MANUAL);
        this._ebean_set_useVirtualBalances(Boolean.FALSE);
        this._ebean_set_ignoreAccountInformation(Boolean.FALSE);
    }

    public static int removeFolder(CmFolder f) {
        Update<Account> deleteAccount = DB.createUpdate(Account.class, "UPDATE Account SET folder_id=null WHERE folder_id=:folder");
        deleteAccount.setParameter("folder", (Object)f.getId());
        return deleteAccount.execute();
    }

    public static void deleteAll(BankSettings bank) {
        List<Account> accounts = Account.findAccountsForBank(bank);
        for (Account a : accounts) {
            a.valueGroups.clear();
            a.save();
            for (AutomaticExport ae : a.automaticExports) {
                if (ae.getAccounts() == null || ae.getAccounts().size() != 1) continue;
                ae.setActivated(false);
                ae.save();
            }
            a.automaticExports.clear();
            a.save();
            Log.deleteByAccount(a, true);
            ExportFile.deleteAssociationsWithAccount(a.getId());
            CmValueGroup.deleteGroupEntries(a.getId());
            SendFilter.removeAccount(a);
            PaymentOriginator.removeDefaultAccount(a);
            DB.delete(a);
        }
    }

    public static boolean canBeDeleted(Account account) {
        if (!Type.MANUAL.equals((Object)account.type) && !Type.CASH_MANAGEMENT.equals((Object)account.type)) {
            return false;
        }
        return CmStatement.findTotalCountForAccount(account) <= 0 && SignedPayment.findCountByAccount(account) <= 0 && Send.findCountByAccount(account) <= 0 && DsOrderDetails.findCountByAccount(account) <= 0 && CmPdfStatement.findCountByAccount(account) <= 0;
    }

    public static boolean delete(Account account) {
        if (!Type.MANUAL.equals((Object)account.type) && !Type.CASH_MANAGEMENT.equals((Object)account.type)) {
            return false;
        }
        OpenPayment.deleteAll(account);
        PeriodicPayment.deleteAll(account);
        PaymentTemplate.deleteAll(account);
        PaymentOriginator.removeDefaultAccount(account);
        if (CmStatement.findTotalCountForAccount(account) > 0 || SignedPayment.findCountByAccount(account) > 0 || Send.findCountByAccount(account) > 0 || DsOrderDetails.findCountByAccount(account) > 0) {
            account.setType(Type.CASH_MANAGEMENT);
            account.save();
            return false;
        }
        UserEffectivePermission.deleteAll(account);
        AccountPermission.deleteAll(account);
        ApOverwrite.deleteAll(account);
        Log.deleteByAccount(account, true);
        account.automaticExports.clear();
        account.save();
        ExportFile.deleteAssociationsWithAccount(account.getId());
        CmValueGroup.deleteGroupEntries(account.getId());
        SendFilter.removeAccount(account);
        DB.delete(account);
        return true;
    }

    private static void removeOriginator(String dbName, PaymentOriginator originator) {
        Update<Account> update = DB.createUpdate(Account.class, "UPDATE account SET " + dbName + "=null WHERE " + dbName + "=:originator");
        update.setParameter("originator", (Object)originator.getId());
        update.execute();
    }

    public static void removeDefaultSepaOriginator(PaymentOriginator originator) {
        Account.removeOriginator("sepaOriginator", originator);
    }

    public static void removeDefaultDtazvOriginator(PaymentOriginator originator) {
        Account.removeOriginator("dtazvOriginator", originator);
    }

    public static void removeDefaultMt101Originator(PaymentOriginator originator) {
        Account.removeOriginator("mt101Originator", originator);
    }

    public static Account findById(int id) {
        return (Account)DB.find(Account.class).where().eq("id", (Object)id).findOne();
    }

    public static Account findAccountByCmIdentification(BankSettings bank, String cmIdentification) {
        return (Account)DB.find(Account.class).where().eq("bank", (Object)bank).eq("cmIdentification", (Object)cmIdentification).findOne();
    }

    public static int countAccounts(User user, CmFolder folder, Expression where, boolean checkAccountPermission) {
        ExpressionList expr = DB.find(Account.class).where();
        expr.eq("bank.users.user", (Object)user);
        if (checkAccountPermission) {
            expr.disjunction().eq("permissions.bankUser.user", (Object)user).eq("type", (Object)Type.CASH_MANAGEMENT);
        }
        if (where != null) {
            expr.add(where);
        }
        if (((Object)CmFolder.NULL_FOLDER).equals(folder)) {
            expr.isNull("folder");
        } else if (folder != null) {
            expr.eq("folder", (Object)folder);
        }
        return expr.findCount();
    }

    public static List<Account> findAccounts(User user, Expression where, CmFolder folder, boolean checkAccountPermission) {
        ExpressionList expr = DB.find(Account.class).where();
        expr.eq("bank.users.user", (Object)user);
        if (checkAccountPermission) {
            expr.eq("permissions.bankUser.user", (Object)user);
        }
        if (where != null) {
            expr.add(where);
        }
        if (folder != null) {
            if (((Object)CmFolder.NULL_FOLDER).equals(folder)) {
                expr.isNull("folder");
            } else {
                expr.eq("folder", (Object)folder);
            }
        }
        return expr.order("name, iban, id").findList();
    }

    public static Account findAccountByIdAndUser(int id, User user, boolean checkAccountPermission) {
        return (Account)Account.findAccountsByIdsQuery(Collections.singletonList(id), user, checkAccountPermission).findOne();
    }

    public static List<Account> findAccountsforUser(User user, boolean checkAccountPermission) {
        return Account.findAccountsByIdsQuery(null, user, checkAccountPermission).findList();
    }

    public static Query<Account> findAccountsQuery(User user, boolean checkAccountPermission) {
        return Account.findAccountsByIdsQuery(null, user, checkAccountPermission);
    }

    private static Query<Account> findAccountsByIdsQuery(List<Integer> ids, User user, boolean checkAccountPermission) {
        ExpressionList expr = DB.find(Account.class).where();
        if (ids != null) {
            expr.in("id", ids);
        }
        expr.eq("bank.users.user", (Object)user);
        if (checkAccountPermission) {
            expr.eq("permissions.bankUser.user", (Object)user);
        }
        return expr.query();
    }

    public static List<Account> findAllowedAccounts(User user) {
        ExpressionList expr = DB.find(Account.class).where();
        expr.eq("bank.users.user", (Object)user);
        expr.eq("permissions.bankUser.user", (Object)user);
        return expr.findList();
    }

    public static boolean isAccountAllowed(Account account, User user, boolean checkPermission) {
        ExpressionList expr = DB.find(Account.class).where();
        expr.eq("id", (Object)account.getId());
        expr.eq("bank.users.user", (Object)user);
        if (checkPermission) {
            expr.disjunction().eq("permissions.bankUser.user", (Object)user).eq("type", (Object)Type.CASH_MANAGEMENT);
        }
        return expr.findOne() != null;
    }

    public static List<Account> findAllowedAccountsByIds(List<Integer> ids, User user, boolean checkPermission) {
        ExpressionList expr = DB.find(Account.class).where();
        expr.in("id", ids);
        expr.eq("bank.users.user", (Object)user);
        if (checkPermission) {
            expr.disjunction().eq("permissions.bankUser.user", (Object)user).eq("type", (Object)Type.CASH_MANAGEMENT);
        }
        return expr.findList();
    }

    public static Expression buildExpressionForAccountPermissions(User user, String accountField) {
        return Expr.eq((String)(accountField + ".permissions.bankUser.user"), (Object)user);
    }

    public static Expression buildExpressionForManualAccountPermissions(User user, String accountField) {
        return Expr.and((Expression)Expr.eq((String)(accountField + ".permissions.bankUser.user"), (Object)user), (Expression)Expr.eq((String)(accountField + ".type"), (Object)((Object)Type.MANUAL)));
    }

    public static String buildRawExpressionForAccountPermission(User user, String bankColumn, String accountColumn) {
        StringBuilder accountsExpression;
        ArrayList<Integer> accountIds = new ArrayList<Integer>();
        ArrayList<Integer> bankIdsList = new ArrayList<Integer>();
        for (BankUser bankUser : BankUser.findBanksForUser(user)) {
            bankIdsList.add(bankUser.getBank().getBankId());
            for (AccountPermission accountPermission : AccountPermission.findByBankUser(bankUser).findList()) {
                accountIds.add(accountPermission.getAccount().getId());
            }
        }
        if (accountIds.size() > 1000) {
            if (bankIdsList.isEmpty()) {
                return null;
            }
            if (bankIdsList.size() == 1) {
                return bankColumn + " = " + String.valueOf(bankIdsList.get(0));
            }
            StringBuilder resultBuilder = new StringBuilder(bankColumn).append(" in (");
            for (int i = 0; i < bankIdsList.size(); ++i) {
                if (i > 0) {
                    resultBuilder.append(", ");
                }
                resultBuilder.append(bankIdsList.get(i));
            }
            return resultBuilder.append(')').toString();
        }
        if (accountIds.isEmpty()) {
            accountsExpression = null;
        } else if (accountIds.size() == 1) {
            accountsExpression = new StringBuilder(accountColumn).append(" = ").append(accountIds.get(0));
        } else {
            accountsExpression = new StringBuilder(accountColumn).append(" in (");
            for (int i = 0; i < accountIds.size(); ++i) {
                if (i > 0) {
                    accountsExpression.append(", ");
                }
                accountsExpression.append(accountIds.get(i));
            }
            accountsExpression.append(')');
        }
        if (accountsExpression == null) {
            return null;
        }
        return accountsExpression.toString();
    }

    public static List<Account> findAccountsForBank(BankSettings bank) {
        return DB.find(Account.class).where().eq("bank", (Object)bank).order("name asc, iban asc, id asc").findList();
    }

    public static List<String> findBicsForBank(BankSettings bank) {
        SqlQuery query = DB.createSqlQuery("SELECT DISTINCT bic FROM account WHERE bank_id = :bankId AND bic is not null");
        query.setParameter("bankId", (Object)bank.getBankId());
        ArrayList<String> result = new ArrayList<String>();
        for (SqlRow row : query.findList()) {
            result.add(row.getString("bic"));
        }
        return result;
    }

    public static List<Account> findAccountsForBic(BankSettings bank, String bic) {
        return DB.find(Account.class).where().eq("bank", (Object)bank).eq("bic", (Object)bic).findList();
    }

    public static Account findSEPAAccount(BankSettings bank, String iban, String accountCurrency, String paymentCurrency) {
        if (accountCurrency != null) {
            return Account.findAccountByIban(bank, iban, accountCurrency);
        }
        Account account = Account.findAccountByIban(bank, iban, paymentCurrency);
        if (account != null) {
            return account;
        }
        return Account.findAccountByIban(bank, iban, null);
    }

    public static Account findAccountByIban(BankSettings bank, String iban, String currency) {
        if (currency == null) {
            List accounts = DB.find(Account.class).where().eq("bank", (Object)bank).eq("iban", (Object)iban).findList();
            if (accounts != null && !accounts.isEmpty()) {
                return (Account)accounts.get(0);
            }
            return null;
        }
        return (Account)DB.find(Account.class).where().eq("bank", (Object)bank).eq("iban", (Object)iban).eq("currency", (Object)currency).findOne();
    }

    public static Account findNonCMAccountByIban(BankSettings bank, String iban, String currency) {
        if (currency == null) {
            List accounts = DB.find(Account.class).where().eq("bank", (Object)bank).eq("iban", (Object)iban).ne("type", (Object)Type.CASH_MANAGEMENT).findList();
            if (accounts != null && !accounts.isEmpty()) {
                return (Account)accounts.get(0);
            }
            return null;
        }
        return (Account)DB.find(Account.class).where().eq("bank", (Object)bank).eq("iban", (Object)iban).eq("currency", (Object)currency).ne("type", (Object)Type.CASH_MANAGEMENT).findOne();
    }

    public static List<Account> findAccountsByIban(String iban, String currency) {
        if (currency == null) {
            return DB.find(Account.class).where().eq("iban", (Object)iban).findList();
        }
        return DB.find(Account.class).where().eq("iban", (Object)iban).eq("currency", (Object)currency).findList();
    }

    public static Account findAccountByIbanBic(BankSettings bank, String iban, String bic, String currency) {
        if (bic == null || bic.isEmpty() || "NOTPROVIDED".equals(bic)) {
            return Account.findAccountByIban(bank, iban, currency);
        }
        if (currency == null) {
            List accounts = DB.find(Account.class).where().eq("bank", (Object)bank).eq("iban", (Object)iban).eq("bic", (Object)bic).findList();
            if (accounts != null && !accounts.isEmpty()) {
                return (Account)accounts.get(0);
            }
            return null;
        }
        return (Account)DB.find(Account.class).where().eq("bank", (Object)bank).eq("iban", (Object)iban).eq("bic", (Object)bic).eq("currency", (Object)currency).findOne();
    }

    public static Account findAccountByIpLimitMsgIdBic(BankSettings bank, String msgId, String bic) {
        if (bic == null || bic.isEmpty() || "NOTPROVIDED".equals(bic)) {
            return (Account)DB.find(Account.class).where().eq("bank", (Object)bank).eq("ipLimitMsgId", (Object)msgId).eq("bic", (Object)bic).findOne();
        }
        return (Account)DB.find(Account.class).where().eq("bank", (Object)bank).eq("ipLimitMsgId", (Object)msgId).eq("bic", (Object)bic).findOne();
    }

    public static Account findAccountByGermanAccountNumberBic(BankSettings bank, String germanAccountNumber, String bic, String currency) {
        return (Account)DB.find(Account.class).where().eq("bank", (Object)bank).eq("germanAccountNumber", (Object)germanAccountNumber).eq("bic", (Object)bic).eq("currency", (Object)currency).setMaxRows(1).findOne();
    }

    public static Account findAccountByNationalAccountNumber(BankSettings bank, String nationalAccountNumber, String accountCurrency) {
        if (accountCurrency == null) {
            return (Account)DB.find(Account.class).where().eq("bank", (Object)bank).eq("nationalAccountNumber", (Object)nationalAccountNumber).setMaxRows(1).findOne();
        }
        return (Account)DB.find(Account.class).where().eq("bank", (Object)bank).eq("nationalAccountNumber", (Object)nationalAccountNumber).eq("currency", (Object)accountCurrency).setMaxRows(1).findOne();
    }

    public static Account findAccountByNationalAccountNumberBic(BankSettings bank, String bic, String nationalAccountNumber, String accountCurrency, String paymentCurrency) {
        if (accountCurrency != null) {
            return Account.findAccountByNationalAccountNumberBic(bank, bic, nationalAccountNumber, accountCurrency);
        }
        return Account.findAccountByNationalAccountNumberBic(bank, bic, nationalAccountNumber, paymentCurrency);
    }

    public static Account findAccountByNationalAccountNumberBic(BankSettings bank, String bic, String nationalAccountNumber, String currency) {
        if (currency == null) {
            List accounts = DB.find(Account.class).where().eq("bank", (Object)bank).eq("nationalAccountNumber", (Object)nationalAccountNumber).eq("bic", (Object)bic).findList();
            if (accounts != null && !accounts.isEmpty()) {
                return (Account)accounts.get(0);
            }
            return null;
        }
        return (Account)DB.find(Account.class).where().eq("bank", (Object)bank).eq("nationalAccountNumber", (Object)nationalAccountNumber).eq("bic", (Object)bic).eq("currency", (Object)currency).setMaxRows(1).findOne();
    }

    public static List<Account> findGermanAccounts(BankSettings bank) {
        return DB.find(Account.class).where().eq("bank", (Object)bank).isNotNull("germanAccountNumber").isNotNull("germanBankCode").findList();
    }

    public static Account findGermanAccount(BankSettings bank, String germanBankCode, String germanAccountNumber, String currency) {
        if (bank == null || germanBankCode == null || germanAccountNumber == null) {
            return null;
        }
        int trimmedAccountNumberStartPos = 0;
        while (germanAccountNumber.charAt(trimmedAccountNumberStartPos) == '0') {
            ++trimmedAccountNumberStartPos;
        }
        String trimmedAccountNumber = germanAccountNumber.substring(trimmedAccountNumberStartPos);
        Object normalizedAccountNumber = germanAccountNumber;
        while (((String)normalizedAccountNumber).length() < 10) {
            normalizedAccountNumber = "0" + (String)normalizedAccountNumber;
        }
        if (currency != null && currency.length() > 0) {
            return (Account)DB.find(Account.class).where().eq("bank", (Object)bank).eq("germanBankCode", (Object)germanBankCode).or(Expr.eq((String)"germanAccountNumber", (Object)trimmedAccountNumber), Expr.eq((String)"germanAccountNumber", (Object)normalizedAccountNumber)).eq("currency", (Object)currency).findOne();
        }
        List accounts = DB.find(Account.class).where().eq("bank", (Object)bank).eq("germanBankCode", (Object)germanBankCode).or(Expr.eq((String)"germanAccountNumber", (Object)trimmedAccountNumber), Expr.eq((String)"germanAccountNumber", (Object)normalizedAccountNumber)).findList();
        if (accounts != null && !accounts.isEmpty()) {
            return (Account)accounts.get(0);
        }
        return null;
    }

    public static List<Account> findFrenchAccounts(BankSettings bank) {
        return DB.find(Account.class).where().eq("bank", (Object)bank).isNotNull("frenchBankCode").isNotNull("frenchBranchCode").isNotNull("frenchAccountNumber").findList();
    }

    public static Account findFrenchAccount(BankSettings bank, String frenchBankCode, String frenchBranchCode, String frenchAccountNumber, String currency) {
        return (Account)DB.find(Account.class).where().eq("bank", (Object)bank).eq("frenchBankCode", (Object)frenchBankCode).eq("frenchBranchCode", (Object)frenchBranchCode).eq("frenchAccountNumber", (Object)frenchAccountNumber).eq("currency", (Object)currency).findOne();
    }

    public static List<Account> findInternationalAccounts(BankSettings bank) {
        return DB.find(Account.class).where().eq("bank", (Object)bank).isNotNull("bic").isNotNull("iban").findList();
    }

    public static List<Account> findAccountsWithIban() {
        return DB.find(Account.class).where().isNotNull("iban").findList();
    }

    public static Account findNationalAccount(BankSettings bank, String nationalBankCode, String nationalAccountNumber, String currency) {
        ExpressionList expressionList = DB.find(Account.class).where().eq("bank", (Object)bank).eq("nationalAccountNumber", (Object)nationalAccountNumber).eq("currency", (Object)currency);
        if (nationalBankCode != null) {
            return (Account)expressionList.eq("nationalBankCode", (Object)nationalBankCode).findOne();
        }
        return (Account)expressionList.isNull("nationalBankCode").findOne();
    }

    public static Query<Account> queryForPaymentAccounts(User user) {
        Expression whereExpression = null;
        if (user.isAdmin()) {
            whereExpression = Expr.ne((String)"type", (Object)((Object)Type.CASH_MANAGEMENT));
        } else {
            for (BankUser bankUser : BankUser.findBanksForUser(user)) {
                Expression part;
                if (user.isTenantAdmin() && user.getManagedTenants().contains(bankUser.getBank().getTenant())) {
                    part = Expr.and((Expression)Expr.eq((String)"bank", (Object)bankUser.getBank()), (Expression)Expr.ne((String)"type", (Object)((Object)Type.CASH_MANAGEMENT)));
                    whereExpression = whereExpression == null ? part : Expr.or((Expression)whereExpression, (Expression)part);
                    continue;
                }
                part = Expr.and((Expression)Expr.and((Expression)Expr.eq((String)"bank", (Object)bankUser.getBank()), (Expression)Expr.ne((String)"type", (Object)((Object)Type.CASH_MANAGEMENT))), (Expression)Expr.eq((String)"permissions.bankUser", (Object)bankUser));
                whereExpression = whereExpression == null ? part : Expr.or((Expression)whereExpression, (Expression)part);
            }
        }
        if (whereExpression == null) {
            return DB.find(Account.class).where().isNull("id").order("id").query();
        }
        return DB.find(Account.class).where(whereExpression).order("bank.displayName,name,bic,germanBankCode,frenchBankCode,frenchBranchCode,nationalBankCode,iban,germanAccountNumber,frenchAccountNumber,nationalAccountNumber");
    }

    public PaymentOriginator getSepaOriginator() {
        return this._ebean_get_sepaOriginator();
    }

    public void setSepaOriginator(PaymentOriginator sepaOriginator) {
        this._ebean_set_sepaOriginator(sepaOriginator);
    }

    public PaymentOriginator getDtazvOriginator() {
        return this._ebean_get_dtazvOriginator();
    }

    public PaymentOriginator getMt101Originator() {
        return this._ebean_get_mt101Originator();
    }

    public void setDtazvOriginator(PaymentOriginator dtazvOriginator) {
        this._ebean_set_dtazvOriginator(dtazvOriginator);
    }

    public void setMt101Originator(PaymentOriginator mt101Originator) {
        this._ebean_set_mt101Originator(mt101Originator);
    }

    public Integer getId() {
        return this._ebean_get_id();
    }

    public void setId(Integer id) {
        this._ebean_set_id(id);
    }

    public BankSettings getBank() {
        return this._ebean_get_bank();
    }

    public void setBank(BankSettings bank) {
        this._ebean_set_bank(bank);
    }

    public String getName() {
        return this._ebean_get_name();
    }

    public void setName(String name) {
        if (name != null && name.length() > 50) {
            this._ebean_set_name(name.substring(0, 50));
        } else {
            this._ebean_set_name(name);
        }
    }

    public String getDescription() {
        return this._ebean_get_description();
    }

    public void setDescription(String description) {
        this._ebean_set_description(description);
    }

    public String getAccountHolder() {
        return this._ebean_get_accountHolder();
    }

    public void setAccountHolder(String accountHolder) {
        this._ebean_set_accountHolder(accountHolder);
    }

    public String getAccountHolderHTD() {
        return this._ebean_get_accountHolderHTD();
    }

    public void setAccountHolderHTD(String accountHolder) {
        this._ebean_set_accountHolderHTD(accountHolder);
    }

    public String getGermanBankCode() {
        return this._ebean_get_germanBankCode();
    }

    public void setGermanBankCode(String germanBankCode) {
        this._ebean_set_germanBankCode(germanBankCode);
    }

    public String getGermanAccountNumber() {
        return this._ebean_get_germanAccountNumber();
    }

    public void setGermanAccountNumber(String germanAccountNumber) {
        this._ebean_set_germanAccountNumber(germanAccountNumber);
    }

    public String getFrenchBankCode() {
        return this._ebean_get_frenchBankCode();
    }

    public void setFrenchBankCode(String frenchBankCode) {
        this._ebean_set_frenchBankCode(frenchBankCode);
    }

    public String getFrenchBranchCode() {
        return this._ebean_get_frenchBranchCode();
    }

    public void setFrenchBranchCode(String frenchBranchCode) {
        this._ebean_set_frenchBranchCode(frenchBranchCode);
    }

    public String getFrenchAccountNumber() {
        return this._ebean_get_frenchAccountNumber();
    }

    public void setFrenchAccountNumber(String frenchAccountNumber) {
        this._ebean_set_frenchAccountNumber(frenchAccountNumber);
    }

    public String getFrenchCheckCode() {
        return this._ebean_get_frenchCheckCode();
    }

    public void setFrenchCheckCode(String frenchCheckCode) {
        this._ebean_set_frenchCheckCode(frenchCheckCode);
    }

    public String getIban() {
        return this._ebean_get_iban();
    }

    public void setIban(String iban) {
        this._ebean_set_iban(iban);
    }

    public String getBic() {
        return this._ebean_get_bic();
    }

    public void setBic(String bic) {
        this._ebean_set_bic(bic);
    }

    public String getNationalBankCode() {
        return this._ebean_get_nationalBankCode();
    }

    public void setNationalBankCode(String nationalBankCode) {
        this._ebean_set_nationalBankCode(nationalBankCode);
    }

    public String getNationalAccountNumber() {
        return this._ebean_get_nationalAccountNumber();
    }

    public void setNationalAccountNumber(String nationalAccountNumber) {
        this._ebean_set_nationalAccountNumber(nationalAccountNumber);
    }

    public String getCurrency() {
        return this._ebean_get_currency();
    }

    public void setCurrency(String currency) {
        this._ebean_set_currency(currency);
    }

    public String getCmIdentification() {
        return this._ebean_get_cmIdentification();
    }

    public void setCmIdentification(String cmIdentification) {
        this._ebean_set_cmIdentification(cmIdentification);
    }

    public BigDecimal getCreditLimit() {
        return this._ebean_get_creditLimit();
    }

    public void setCreditLimit(BigDecimal creditLimit) {
        this._ebean_set_creditLimit(creditLimit);
    }

    public BigDecimal getIpLimit() {
        return this._ebean_get_ipLimit();
    }

    public void setIpLimit(BigDecimal ipLimit) {
        this._ebean_set_ipLimit(ipLimit);
    }

    public LimitType getIpLimitType() {
        return this._ebean_get_ipLimitType();
    }

    public void setIpLimitType(LimitType ipLimitType) {
        this._ebean_set_ipLimitType(ipLimitType);
    }

    public LimitState getIpLimitState() {
        return this._ebean_get_ipLimitState();
    }

    public void setIpLimitState(LimitState ipLimitState) {
        this._ebean_set_ipLimitState(ipLimitState);
    }

    public Timestamp getIpLimitTime() {
        return this._ebean_get_ipLimitTime();
    }

    public void setIpLimitTime(Timestamp ipLimitTime) {
        this._ebean_set_ipLimitTime(ipLimitTime);
    }

    public String getIpLimitMsgId() {
        return this._ebean_get_ipLimitMsgId();
    }

    public void setIpLimitMsgId(String ipLimitMsgId) {
        this._ebean_set_ipLimitMsgId(ipLimitMsgId);
    }

    public BigDecimal getInvestmentAmount() {
        return this._ebean_get_investmentAmount();
    }

    public void setInvestmentAmount(BigDecimal investmentAmount) {
        this._ebean_set_investmentAmount(investmentAmount);
    }

    public void save() {
        if (this._ebean_get_name() == null) {
            this._ebean_set_name(Account.getDefaultDisplayName(this));
        }
        if (this.getId() == null) {
            DB.save(this);
        } else {
            DB.update(this);
        }
    }

    public String toString() {
        return Account.getDefaultDisplayName(this);
    }

    public String getGermanAccountIdentifier() {
        if (this._ebean_get_germanBankCode() != null && this._ebean_get_germanBankCode().length() > 0 && this._ebean_get_germanAccountNumber() != null && this._ebean_get_germanAccountNumber().length() > 0) {
            return this._ebean_get_germanBankCode() + DISPLAY_NAME_SEPARATOR + this._ebean_get_germanAccountNumber();
        }
        return null;
    }

    public String getFrenchAccountIdentifier() {
        if (this._ebean_get_frenchBankCode() != null && this._ebean_get_frenchBankCode().length() > 0 && this._ebean_get_frenchBranchCode() != null && this._ebean_get_frenchBranchCode().length() > 0 && this._ebean_get_frenchAccountNumber() != null && this._ebean_get_frenchAccountNumber().length() > 0) {
            return this._ebean_get_frenchBankCode() + DISPLAY_NAME_SEPARATOR + this._ebean_get_frenchBranchCode() + DISPLAY_NAME_SEPARATOR + this._ebean_get_frenchAccountNumber();
        }
        return null;
    }

    public static String getDefaultDisplayName(Account account) {
        StringBuilder builder = new StringBuilder();
        if (!Account.appendDisplayName(builder, account)) {
            Account.appendAccountInformation(builder, account);
        }
        return builder.toString();
    }

    public static String getCmDisplayName(Account account) {
        StringBuilder builder = new StringBuilder();
        return Account.appendAccountInformation(builder, account).toString();
    }

    public static boolean isNameStandardName(Account account) {
        String name = account.getName();
        String defaultName = Account.getCmDisplayName(account);
        return name.equals(defaultName);
    }

    private static StringBuilder appendAccountInformation(StringBuilder builder, Account account) {
        if (account == null) {
            return builder;
        }
        if (account.getIban() != null) {
            return Account.appendInternationalAccountRepresentation(builder, account, false, true);
        }
        if (account.getGermanBankCode() != null && account.getGermanAccountNumber() != null) {
            return Account.appendGermanAccountRepresentation(builder, account, true);
        }
        if (account.getFrenchBankCode() != null && account.getFrenchBranchCode() != null && account.getFrenchAccountNumber() != null) {
            return Account.appendFrenchAccountRepresentation(builder, account, true);
        }
        if (account.getNationalAccountNumber() != null) {
            return Account.appendNationalAccountRepresentation(builder, account, true);
        }
        if (account.getCmIdentification() != null) {
            return builder.append(account.getCmIdentification());
        }
        return builder.append("ID ").append(account.getId() != null ? account.getId() : "missing");
    }

    public static String getFrenchDisplayName(Account account, boolean withBank) {
        StringBuilder builder = new StringBuilder();
        if (!Account.appendDisplayName(builder, account)) {
            Account.appendFrenchAccountRepresentation(builder, account, true);
        }
        if (withBank) {
            Account.appendBankName(builder, account);
        }
        return builder.toString();
    }

    public static String getFrenchDisplayName(String bankCode, String branchCode, String accountNumber, String checkCode, String currency, BankSettings bank, boolean withBank) {
        Account account = Account.findFrenchAccount(bank, bankCode, branchCode, accountNumber, currency);
        if (account == null) {
            account = new Account();
            account.setBank(bank);
            account.setFrenchBankCode(bankCode);
            account.setFrenchBranchCode(branchCode);
            account.setFrenchAccountNumber(accountNumber);
            account.setFrenchCheckCode(checkCode);
            account.setCurrency(currency);
        }
        return Account.getFrenchDisplayName(account, withBank);
    }

    private static StringBuilder appendFrenchAccountRepresentation(StringBuilder builder, Account account, boolean withCheckCode) {
        Account.appendNormalizedNumber(account.getFrenchBankCode(), 5, builder).append(DISPLAY_NAME_SEPARATOR);
        Account.appendNormalizedNumber(account.getFrenchBranchCode(), 5, builder).append(DISPLAY_NAME_SEPARATOR);
        Account.appendNormalizedNumber(account.getFrenchAccountNumber(), 11, builder);
        if (withCheckCode) {
            builder.append(DISPLAY_NAME_SEPARATOR);
            if (account.getFrenchCheckCode() == null) {
                Account.appendNormalizedNumber(String.valueOf(PaymentUtils.calculateRibKey(account.getFrenchBankCode(), account.getFrenchBranchCode(), account.getFrenchAccountIdentifier())), 2, builder);
            } else {
                Account.appendNormalizedNumber(account.getFrenchCheckCode(), 2, builder);
            }
        }
        return builder;
    }

    public static String getGermanDisplayName(Account account, boolean withCurrency, boolean withBank) {
        StringBuilder builder = new StringBuilder();
        if (!Account.appendDisplayName(builder, account)) {
            Account.appendGermanAccountRepresentation(builder, account, withCurrency);
        }
        if (withBank) {
            Account.appendBankName(builder, account);
        }
        return builder.toString();
    }

    public static String getGermanDisplayName(String bankCode, String accountNumber, String currency, BankSettings bank, boolean withCurrency, boolean withBank) {
        Account account = Account.findGermanAccount(bank, bankCode, accountNumber, currency);
        if (account == null && (account = Account.findGermanAccount(bank, bankCode, accountNumber, null)) == null) {
            account = new Account();
            account.setBank(bank);
            account.setGermanBankCode(bankCode);
            account.setGermanAccountNumber(accountNumber);
            account.setCurrency(currency);
        }
        return Account.getGermanDisplayName(account, withCurrency, withBank);
    }

    private static StringBuilder appendNationalAccountRepresentation(StringBuilder builder, Account account, boolean withCurrency) {
        if (account.getNationalBankCode() != null) {
            builder.append(account.getNationalBankCode());
            builder.append(DISPLAY_NAME_SEPARATOR);
        } else if (account.getBic() != null) {
            builder.append(account.getBic());
            builder.append(DISPLAY_NAME_SEPARATOR);
        }
        builder.append(account.getNationalAccountNumber());
        if (withCurrency && account.getCurrency() != null && !EUR.equals(account.getCurrency())) {
            builder.append(DISPLAY_NAME_SEPARATOR).append(account.getCurrency());
        }
        return builder;
    }

    private static StringBuilder appendGermanAccountRepresentation(StringBuilder builder, Account account, boolean withCurrency) {
        if (account == null) {
            return builder;
        }
        Account.appendNormalizedNumber(account.getGermanBankCode(), 8, builder).append(DISPLAY_NAME_SEPARATOR);
        if (account.getGermanAccountNumber() == null) {
            builder.append('0');
        } else {
            int startPos;
            for (startPos = 0; startPos < account.getGermanAccountNumber().length() && account.getGermanAccountNumber().charAt(startPos) == '0'; ++startPos) {
            }
            if (startPos == account.getGermanAccountNumber().length()) {
                builder.append('0');
            } else {
                builder.append(account.getGermanAccountNumber());
            }
        }
        if (withCurrency && account.getCurrency() != null && !EUR.equals(account.getCurrency())) {
            builder.append(DISPLAY_NAME_SEPARATOR).append(account.getCurrency());
        }
        return builder;
    }

    public static String getInternationalDisplayName(Account account, boolean withBic, boolean withCurrency, boolean withBank) {
        StringBuilder builder = new StringBuilder();
        if (!Account.appendDisplayName(builder, account)) {
            Account.appendInternationalAccountRepresentation(builder, account, withBic, withCurrency);
        }
        if (withBank) {
            Account.appendBankName(builder, account);
        }
        return builder.toString();
    }

    public static String getMT101DisplayName(Account account, boolean longForm) {
        StringBuilder builder = new StringBuilder();
        boolean hasDisplayName = Account.appendDisplayName(builder, account);
        if (hasDisplayName) {
            if (longForm) {
                builder.append(" (").append(account.getBic()).append(DISPLAY_NAME_SEPARATOR);
                if (account.getIban() != null) {
                    Account.buildFormattedIban(builder, account.getIban());
                } else if (account.getNationalAccountNumber() != null) {
                    builder.append(account.getNationalAccountNumber());
                }
                builder.append(DISPLAY_NAME_SEPARATOR).append(account.getCurrency());
                builder.append(") ");
            }
        } else {
            builder.append(account.getBic()).append(DISPLAY_NAME_SEPARATOR);
            if (account.getIban() != null) {
                Account.buildFormattedIban(builder, account.getIban());
            } else if (account.getNationalAccountNumber() != null) {
                builder.append(account.getNationalAccountNumber());
            }
            if (longForm) {
                builder.append(DISPLAY_NAME_SEPARATOR).append(account.getCurrency());
            }
        }
        if (longForm) {
            Account.appendBankName(builder, account);
        }
        return builder.toString();
    }

    public static String getInternationalDisplayName(String bic, String iban, String currency, BankSettings bank, boolean withBic, boolean withCurrency, boolean withBank) {
        Account account = Account.findAccountByIban(bank, iban, currency);
        if (account == null && (account = Account.findAccountByIban(bank, iban, null)) == null) {
            account = new Account();
            account.setBank(bank);
            account.setBic(bic);
            account.setIban(iban);
            account.setCurrency(currency);
        }
        return Account.getInternationalDisplayName(account, withBic, withCurrency, withBank);
    }

    private static StringBuilder appendInternationalAccountRepresentation(StringBuilder builder, Account account, boolean withBic, boolean withCurrency) {
        String iban;
        if (withBic && account.getBic() != null) {
            builder.append(account.getBic()).append(DISPLAY_NAME_SEPARATOR);
        }
        if ((iban = StringUtils.checkNullAndTrim(account.getIban())).length() > 0) {
            if (IbanUtil.checkIban(iban)) {
                Account.buildFormattedIban(builder, iban);
            } else {
                builder.append(iban);
            }
        } else {
            String natAccNumber = StringUtils.checkNullAndTrim(account.getNationalAccountNumber());
            if (natAccNumber.length() > 0) {
                builder.append(natAccNumber);
            }
        }
        if (withCurrency && account.getCurrency() != null && !EUR.equals(account.getCurrency())) {
            builder.append(DISPLAY_NAME_SEPARATOR).append(account.getCurrency());
        }
        return builder;
    }

    private static StringBuilder appendNormalizedNumber(String number, int length, StringBuilder builder) {
        int numberOfLeadingZeros = number == null ? 0 : length - number.length();
        for (int i = 0; i < numberOfLeadingZeros; ++i) {
            builder.append('0');
        }
        if (number != null) {
            builder.append(number);
        }
        return builder;
    }

    private static boolean appendDisplayName(StringBuilder builder, Account account) {
        if (account != null && account.getName() != null) {
            builder.append(account.getName());
            return true;
        }
        return false;
    }

    private static StringBuilder appendBankName(StringBuilder builder, Account account) {
        if (account != null && account.getBank() != null) {
            return builder.append(" (").append(account.getBank().getDisplayName()).append(')');
        }
        return builder;
    }

    private static StringBuilder buildFormattedIban(StringBuilder builder, String iban) {
        for (int i = 0; iban != null && i < iban.length(); i += 4) {
            if (i + 4 < iban.length()) {
                builder.append(iban, i, i + 4);
                builder.append(' ');
                continue;
            }
            builder.append(iban.substring(i));
        }
        return builder;
    }

    public Type getType() {
        return this._ebean_get_type();
    }

    public void setType(Type type) {
        this._ebean_set_type(type);
    }

    public boolean isHTDAccount() {
        return Type.HTD.equals((Object)this._ebean_get_type());
    }

    public boolean isCMAccount() {
        return Type.CASH_MANAGEMENT.equals((Object)this._ebean_get_type());
    }

    public boolean isManualAccount() {
        return Type.MANUAL.equals((Object)this._ebean_get_type());
    }

    public CmFolder getFolder() {
        return this._ebean_get_folder();
    }

    public void setFolder(CmFolder folder) {
        this._ebean_set_folder(folder);
    }

    public List<CmValueGroup> getValueGroups() {
        return this._ebean_get_valueGroups();
    }

    public boolean getUseVirtualBalances() {
        return this._ebean_get_useVirtualBalances() != null ? this._ebean_get_useVirtualBalances() : false;
    }

    public void setUseVirtualBalances(Boolean useVirtualBalances) {
        this._ebean_set_useVirtualBalances(useVirtualBalances);
    }

    public BigDecimal getVirtualStartBalance() {
        return this._ebean_get_virtualStartBalance() != null ? this._ebean_get_virtualStartBalance() : BigDecimal.ZERO;
    }

    public void setVirtualStartBalance(BigDecimal virtualStartBalance) {
        this._ebean_set_virtualStartBalance(virtualStartBalance);
    }

    public Date getVirtualStartDate() {
        return this._ebean_get_virtualStartDate();
    }

    public void setVirtualStartDate(Date virtualStartDate) {
        this._ebean_set_virtualStartDate(virtualStartDate);
    }

    public boolean getIgnoreAccountInformation() {
        return this._ebean_get_ignoreAccountInformation() != null ? this._ebean_get_ignoreAccountInformation() : false;
    }

    public void setIgnoreAccountInformation(Boolean ignoreAccountInformation) {
        this._ebean_set_ignoreAccountInformation(ignoreAccountInformation);
    }

    public String getInfoText() {
        return this._ebean_get_infoText();
    }

    public void setInfoText(String infoText) {
        this._ebean_set_infoText(infoText);
    }

    public boolean setVirtualBalance(boolean useVirtualBalance, BigDecimal virtualBalance, Date virtualStartDate) {
        boolean doRecalculate = this.getUseVirtualBalances() != useVirtualBalance;
        this._ebean_set_useVirtualBalances(useVirtualBalance);
        if (useVirtualBalance) {
            if (!doRecalculate && virtualBalance.compareTo(this._ebean_get_virtualStartBalance()) != 0) {
                doRecalculate = true;
            }
            this._ebean_set_virtualStartBalance(virtualBalance);
            if (!(doRecalculate || this._ebean_get_virtualStartDate() != null && virtualStartDate.compareTo(this._ebean_get_virtualStartDate()) == 0)) {
                doRecalculate = true;
            }
            this._ebean_set_virtualStartDate(virtualStartDate);
        }
        return doRecalculate;
    }

    public static Expression getFilterExpression(String searchString, boolean checkCmIdentification) {
        if (searchString == null || searchString.length() == 0) {
            return null;
        }
        String like = "%" + searchString + "%";
        Expression expression = Expr.ilike((String)"name", (String)like);
        expression = Expr.or((Expression)expression, (Expression)Expr.ilike((String)"description", (String)like));
        expression = Expr.or((Expression)expression, (Expression)Expr.ilike((String)"accountHolder", (String)like));
        expression = Expr.or((Expression)expression, (Expression)Expr.like((String)"currency", (String)like));
        if (checkCmIdentification) {
            expression = Expr.or((Expression)expression, (Expression)Expr.like((String)"cmIdentification", (String)like));
        }
        expression = Expr.or((Expression)expression, (Expression)Expr.like((String)"iban", (String)like));
        expression = Expr.or((Expression)expression, (Expression)Expr.like((String)"germanAccountNumber", (String)like));
        expression = Expr.or((Expression)expression, (Expression)Expr.like((String)"frenchAccountNumber", (String)like));
        expression = Expr.or((Expression)expression, (Expression)Expr.like((String)"nationalAccountNumber", (String)like));
        expression = Expr.or((Expression)expression, (Expression)Expr.like((String)"bic", (String)like));
        expression = Expr.or((Expression)expression, (Expression)Expr.like((String)"germanBankCode", (String)like));
        expression = Expr.or((Expression)expression, (Expression)Expr.like((String)"frenchBankCode", (String)like));
        expression = Expr.or((Expression)expression, (Expression)Expr.like((String)"frenchBranchCode", (String)like));
        expression = Expr.or((Expression)expression, (Expression)Expr.like((String)"nationalAccountNumber", (String)like));
        return expression;
    }

    public static List<Account> findAccountByNameOrIbanLike(String nameOrIban, List<BankSettings> banks) {
        Expression e1 = Expr.ilike((String)"name", (String)("%" + nameOrIban + "%"));
        Expression e2 = Expr.ilike((String)"iban", (String)("%" + nameOrIban + "%"));
        return Account.findAccountQuery(null, banks).where().or(e1, e2).setMaxRows(50).findList();
    }

    private static Query<Account> findAccountQuery(Collection<Integer> ids, Collection<BankSettings> banks) {
        ExpressionList result = DB.find(Account.class).where().ne("type", (Object)Type.CASH_MANAGEMENT).in("bank", banks);
        return result.orderBy("name asc").query();
    }

    static {
        _ebean_props = new String[]{"id", "bank", "name", "description", "accountHolder", "accountHolderHTD", "infoText", "sepaOriginator", "dtazvOriginator", "mt101Originator", "germanBankCode", "germanAccountNumber", "frenchBankCode", "frenchBranchCode", "frenchAccountNumber", "frenchCheckCode", "iban", "bic", "nationalBankCode", "nationalAccountNumber", "currency", "cmIdentification", "creditLimit", "ipLimit", "ipLimitType", "ipLimitState", "ipLimitTime", "ipLimitMsgId", "investmentAmount", "type", "folder", "permissions", "valueGroups", "automaticExports", "useVirtualBalances", "virtualStartBalance", "virtualStartDate", "ignoreAccountInformation"};
    }

    public /* synthetic */ String[] _ebean_getPropertyNames() {
        return _ebean_props;
    }

    public /* synthetic */ String _ebean_getPropertyName(int pos) {
        return _ebean_props[pos];
    }

    public /* synthetic */ EntityBeanIntercept _ebean_getIntercept() {
        return this._ebean_intercept;
    }

    public /* synthetic */ EntityBeanIntercept _ebean_intercept() {
        if (this._ebean_intercept == null) {
            this._ebean_intercept = new EntityBeanIntercept((Object)this);
        }
        return this._ebean_intercept;
    }

    protected /* synthetic */ Integer _ebean_get_id() {
        this._ebean_intercept.preGetId();
        return this.id;
    }

    protected /* synthetic */ void _ebean_set_id(Integer newValue) {
        this._ebean_intercept.preSetter(false, 0, (Object)this.id, (Object)newValue);
        this.id = newValue;
    }

    protected /* synthetic */ Integer _ebean_getni_id() {
        return this.id;
    }

    protected /* synthetic */ void _ebean_setni_id(Integer _newValue) {
        this.id = _newValue;
        this._ebean_intercept.setLoadedProperty(0);
    }

    protected /* synthetic */ BankSettings _ebean_get_bank() {
        this._ebean_intercept.preGetter(1);
        return this.bank;
    }

    protected /* synthetic */ void _ebean_set_bank(BankSettings newValue) {
        this._ebean_intercept.preSetter(true, 1, (Object)this._ebean_get_bank(), (Object)newValue);
        this.bank = newValue;
    }

    protected /* synthetic */ BankSettings _ebean_getni_bank() {
        return this.bank;
    }

    protected /* synthetic */ void _ebean_setni_bank(BankSettings _newValue) {
        this.bank = _newValue;
        this._ebean_intercept.setLoadedProperty(1);
    }

    protected /* synthetic */ String _ebean_get_name() {
        this._ebean_intercept.preGetter(2);
        return this.name;
    }

    protected /* synthetic */ void _ebean_set_name(String newValue) {
        this._ebean_intercept.preSetter(true, 2, (Object)this._ebean_get_name(), (Object)newValue);
        this.name = newValue;
    }

    protected /* synthetic */ String _ebean_getni_name() {
        return this.name;
    }

    protected /* synthetic */ void _ebean_setni_name(String _newValue) {
        this.name = _newValue;
        this._ebean_intercept.setLoadedProperty(2);
    }

    protected /* synthetic */ String _ebean_get_description() {
        this._ebean_intercept.preGetter(3);
        return this.description;
    }

    protected /* synthetic */ void _ebean_set_description(String newValue) {
        this._ebean_intercept.preSetter(true, 3, (Object)this._ebean_get_description(), (Object)newValue);
        this.description = newValue;
    }

    protected /* synthetic */ String _ebean_getni_description() {
        return this.description;
    }

    protected /* synthetic */ void _ebean_setni_description(String _newValue) {
        this.description = _newValue;
        this._ebean_intercept.setLoadedProperty(3);
    }

    protected /* synthetic */ String _ebean_get_accountHolder() {
        this._ebean_intercept.preGetter(4);
        return this.accountHolder;
    }

    protected /* synthetic */ void _ebean_set_accountHolder(String newValue) {
        this._ebean_intercept.preSetter(true, 4, (Object)this._ebean_get_accountHolder(), (Object)newValue);
        this.accountHolder = newValue;
    }

    protected /* synthetic */ String _ebean_getni_accountHolder() {
        return this.accountHolder;
    }

    protected /* synthetic */ void _ebean_setni_accountHolder(String _newValue) {
        this.accountHolder = _newValue;
        this._ebean_intercept.setLoadedProperty(4);
    }

    protected /* synthetic */ String _ebean_get_accountHolderHTD() {
        this._ebean_intercept.preGetter(5);
        return this.accountHolderHTD;
    }

    protected /* synthetic */ void _ebean_set_accountHolderHTD(String newValue) {
        this._ebean_intercept.preSetter(true, 5, (Object)this._ebean_get_accountHolderHTD(), (Object)newValue);
        this.accountHolderHTD = newValue;
    }

    protected /* synthetic */ String _ebean_getni_accountHolderHTD() {
        return this.accountHolderHTD;
    }

    protected /* synthetic */ void _ebean_setni_accountHolderHTD(String _newValue) {
        this.accountHolderHTD = _newValue;
        this._ebean_intercept.setLoadedProperty(5);
    }

    protected /* synthetic */ String _ebean_get_infoText() {
        this._ebean_intercept.preGetter(6);
        return this.infoText;
    }

    protected /* synthetic */ void _ebean_set_infoText(String newValue) {
        this._ebean_intercept.preSetter(true, 6, (Object)this._ebean_get_infoText(), (Object)newValue);
        this.infoText = newValue;
    }

    protected /* synthetic */ String _ebean_getni_infoText() {
        return this.infoText;
    }

    protected /* synthetic */ void _ebean_setni_infoText(String _newValue) {
        this.infoText = _newValue;
        this._ebean_intercept.setLoadedProperty(6);
    }

    protected /* synthetic */ PaymentOriginator _ebean_get_sepaOriginator() {
        this._ebean_intercept.preGetter(7);
        return this.sepaOriginator;
    }

    protected /* synthetic */ void _ebean_set_sepaOriginator(PaymentOriginator newValue) {
        this._ebean_intercept.preSetter(true, 7, (Object)this._ebean_get_sepaOriginator(), (Object)newValue);
        this.sepaOriginator = newValue;
    }

    protected /* synthetic */ PaymentOriginator _ebean_getni_sepaOriginator() {
        return this.sepaOriginator;
    }

    protected /* synthetic */ void _ebean_setni_sepaOriginator(PaymentOriginator _newValue) {
        this.sepaOriginator = _newValue;
        this._ebean_intercept.setLoadedProperty(7);
    }

    protected /* synthetic */ PaymentOriginator _ebean_get_dtazvOriginator() {
        this._ebean_intercept.preGetter(8);
        return this.dtazvOriginator;
    }

    protected /* synthetic */ void _ebean_set_dtazvOriginator(PaymentOriginator newValue) {
        this._ebean_intercept.preSetter(true, 8, (Object)this._ebean_get_dtazvOriginator(), (Object)newValue);
        this.dtazvOriginator = newValue;
    }

    protected /* synthetic */ PaymentOriginator _ebean_getni_dtazvOriginator() {
        return this.dtazvOriginator;
    }

    protected /* synthetic */ void _ebean_setni_dtazvOriginator(PaymentOriginator _newValue) {
        this.dtazvOriginator = _newValue;
        this._ebean_intercept.setLoadedProperty(8);
    }

    protected /* synthetic */ PaymentOriginator _ebean_get_mt101Originator() {
        this._ebean_intercept.preGetter(9);
        return this.mt101Originator;
    }

    protected /* synthetic */ void _ebean_set_mt101Originator(PaymentOriginator newValue) {
        this._ebean_intercept.preSetter(true, 9, (Object)this._ebean_get_mt101Originator(), (Object)newValue);
        this.mt101Originator = newValue;
    }

    protected /* synthetic */ PaymentOriginator _ebean_getni_mt101Originator() {
        return this.mt101Originator;
    }

    protected /* synthetic */ void _ebean_setni_mt101Originator(PaymentOriginator _newValue) {
        this.mt101Originator = _newValue;
        this._ebean_intercept.setLoadedProperty(9);
    }

    protected /* synthetic */ String _ebean_get_germanBankCode() {
        this._ebean_intercept.preGetter(10);
        return this.germanBankCode;
    }

    protected /* synthetic */ void _ebean_set_germanBankCode(String newValue) {
        this._ebean_intercept.preSetter(true, 10, (Object)this._ebean_get_germanBankCode(), (Object)newValue);
        this.germanBankCode = newValue;
    }

    protected /* synthetic */ String _ebean_getni_germanBankCode() {
        return this.germanBankCode;
    }

    protected /* synthetic */ void _ebean_setni_germanBankCode(String _newValue) {
        this.germanBankCode = _newValue;
        this._ebean_intercept.setLoadedProperty(10);
    }

    protected /* synthetic */ String _ebean_get_germanAccountNumber() {
        this._ebean_intercept.preGetter(11);
        return this.germanAccountNumber;
    }

    protected /* synthetic */ void _ebean_set_germanAccountNumber(String newValue) {
        this._ebean_intercept.preSetter(true, 11, (Object)this._ebean_get_germanAccountNumber(), (Object)newValue);
        this.germanAccountNumber = newValue;
    }

    protected /* synthetic */ String _ebean_getni_germanAccountNumber() {
        return this.germanAccountNumber;
    }

    protected /* synthetic */ void _ebean_setni_germanAccountNumber(String _newValue) {
        this.germanAccountNumber = _newValue;
        this._ebean_intercept.setLoadedProperty(11);
    }

    protected /* synthetic */ String _ebean_get_frenchBankCode() {
        this._ebean_intercept.preGetter(12);
        return this.frenchBankCode;
    }

    protected /* synthetic */ void _ebean_set_frenchBankCode(String newValue) {
        this._ebean_intercept.preSetter(true, 12, (Object)this._ebean_get_frenchBankCode(), (Object)newValue);
        this.frenchBankCode = newValue;
    }

    protected /* synthetic */ String _ebean_getni_frenchBankCode() {
        return this.frenchBankCode;
    }

    protected /* synthetic */ void _ebean_setni_frenchBankCode(String _newValue) {
        this.frenchBankCode = _newValue;
        this._ebean_intercept.setLoadedProperty(12);
    }

    protected /* synthetic */ String _ebean_get_frenchBranchCode() {
        this._ebean_intercept.preGetter(13);
        return this.frenchBranchCode;
    }

    protected /* synthetic */ void _ebean_set_frenchBranchCode(String newValue) {
        this._ebean_intercept.preSetter(true, 13, (Object)this._ebean_get_frenchBranchCode(), (Object)newValue);
        this.frenchBranchCode = newValue;
    }

    protected /* synthetic */ String _ebean_getni_frenchBranchCode() {
        return this.frenchBranchCode;
    }

    protected /* synthetic */ void _ebean_setni_frenchBranchCode(String _newValue) {
        this.frenchBranchCode = _newValue;
        this._ebean_intercept.setLoadedProperty(13);
    }

    protected /* synthetic */ String _ebean_get_frenchAccountNumber() {
        this._ebean_intercept.preGetter(14);
        return this.frenchAccountNumber;
    }

    protected /* synthetic */ void _ebean_set_frenchAccountNumber(String newValue) {
        this._ebean_intercept.preSetter(true, 14, (Object)this._ebean_get_frenchAccountNumber(), (Object)newValue);
        this.frenchAccountNumber = newValue;
    }

    protected /* synthetic */ String _ebean_getni_frenchAccountNumber() {
        return this.frenchAccountNumber;
    }

    protected /* synthetic */ void _ebean_setni_frenchAccountNumber(String _newValue) {
        this.frenchAccountNumber = _newValue;
        this._ebean_intercept.setLoadedProperty(14);
    }

    protected /* synthetic */ String _ebean_get_frenchCheckCode() {
        this._ebean_intercept.preGetter(15);
        return this.frenchCheckCode;
    }

    protected /* synthetic */ void _ebean_set_frenchCheckCode(String newValue) {
        this._ebean_intercept.preSetter(true, 15, (Object)this._ebean_get_frenchCheckCode(), (Object)newValue);
        this.frenchCheckCode = newValue;
    }

    protected /* synthetic */ String _ebean_getni_frenchCheckCode() {
        return this.frenchCheckCode;
    }

    protected /* synthetic */ void _ebean_setni_frenchCheckCode(String _newValue) {
        this.frenchCheckCode = _newValue;
        this._ebean_intercept.setLoadedProperty(15);
    }

    protected /* synthetic */ String _ebean_get_iban() {
        this._ebean_intercept.preGetter(16);
        return this.iban;
    }

    protected /* synthetic */ void _ebean_set_iban(String newValue) {
        this._ebean_intercept.preSetter(true, 16, (Object)this._ebean_get_iban(), (Object)newValue);
        this.iban = newValue;
    }

    protected /* synthetic */ String _ebean_getni_iban() {
        return this.iban;
    }

    protected /* synthetic */ void _ebean_setni_iban(String _newValue) {
        this.iban = _newValue;
        this._ebean_intercept.setLoadedProperty(16);
    }

    protected /* synthetic */ String _ebean_get_bic() {
        this._ebean_intercept.preGetter(17);
        return this.bic;
    }

    protected /* synthetic */ void _ebean_set_bic(String newValue) {
        this._ebean_intercept.preSetter(true, 17, (Object)this._ebean_get_bic(), (Object)newValue);
        this.bic = newValue;
    }

    protected /* synthetic */ String _ebean_getni_bic() {
        return this.bic;
    }

    protected /* synthetic */ void _ebean_setni_bic(String _newValue) {
        this.bic = _newValue;
        this._ebean_intercept.setLoadedProperty(17);
    }

    protected /* synthetic */ String _ebean_get_nationalBankCode() {
        this._ebean_intercept.preGetter(18);
        return this.nationalBankCode;
    }

    protected /* synthetic */ void _ebean_set_nationalBankCode(String newValue) {
        this._ebean_intercept.preSetter(true, 18, (Object)this._ebean_get_nationalBankCode(), (Object)newValue);
        this.nationalBankCode = newValue;
    }

    protected /* synthetic */ String _ebean_getni_nationalBankCode() {
        return this.nationalBankCode;
    }

    protected /* synthetic */ void _ebean_setni_nationalBankCode(String _newValue) {
        this.nationalBankCode = _newValue;
        this._ebean_intercept.setLoadedProperty(18);
    }

    protected /* synthetic */ String _ebean_get_nationalAccountNumber() {
        this._ebean_intercept.preGetter(19);
        return this.nationalAccountNumber;
    }

    protected /* synthetic */ void _ebean_set_nationalAccountNumber(String newValue) {
        this._ebean_intercept.preSetter(true, 19, (Object)this._ebean_get_nationalAccountNumber(), (Object)newValue);
        this.nationalAccountNumber = newValue;
    }

    protected /* synthetic */ String _ebean_getni_nationalAccountNumber() {
        return this.nationalAccountNumber;
    }

    protected /* synthetic */ void _ebean_setni_nationalAccountNumber(String _newValue) {
        this.nationalAccountNumber = _newValue;
        this._ebean_intercept.setLoadedProperty(19);
    }

    protected /* synthetic */ String _ebean_get_currency() {
        this._ebean_intercept.preGetter(20);
        return this.currency;
    }

    protected /* synthetic */ void _ebean_set_currency(String newValue) {
        this._ebean_intercept.preSetter(true, 20, (Object)this._ebean_get_currency(), (Object)newValue);
        this.currency = newValue;
    }

    protected /* synthetic */ String _ebean_getni_currency() {
        return this.currency;
    }

    protected /* synthetic */ void _ebean_setni_currency(String _newValue) {
        this.currency = _newValue;
        this._ebean_intercept.setLoadedProperty(20);
    }

    protected /* synthetic */ String _ebean_get_cmIdentification() {
        this._ebean_intercept.preGetter(21);
        return this.cmIdentification;
    }

    protected /* synthetic */ void _ebean_set_cmIdentification(String newValue) {
        this._ebean_intercept.preSetter(true, 21, (Object)this._ebean_get_cmIdentification(), (Object)newValue);
        this.cmIdentification = newValue;
    }

    protected /* synthetic */ String _ebean_getni_cmIdentification() {
        return this.cmIdentification;
    }

    protected /* synthetic */ void _ebean_setni_cmIdentification(String _newValue) {
        this.cmIdentification = _newValue;
        this._ebean_intercept.setLoadedProperty(21);
    }

    protected /* synthetic */ BigDecimal _ebean_get_creditLimit() {
        this._ebean_intercept.preGetter(22);
        return this.creditLimit;
    }

    protected /* synthetic */ void _ebean_set_creditLimit(BigDecimal newValue) {
        this._ebean_intercept.preSetter(true, 22, (Object)this._ebean_get_creditLimit(), (Object)newValue);
        this.creditLimit = newValue;
    }

    protected /* synthetic */ BigDecimal _ebean_getni_creditLimit() {
        return this.creditLimit;
    }

    protected /* synthetic */ void _ebean_setni_creditLimit(BigDecimal _newValue) {
        this.creditLimit = _newValue;
        this._ebean_intercept.setLoadedProperty(22);
    }

    protected /* synthetic */ BigDecimal _ebean_get_ipLimit() {
        this._ebean_intercept.preGetter(23);
        return this.ipLimit;
    }

    protected /* synthetic */ void _ebean_set_ipLimit(BigDecimal newValue) {
        this._ebean_intercept.preSetter(true, 23, (Object)this._ebean_get_ipLimit(), (Object)newValue);
        this.ipLimit = newValue;
    }

    protected /* synthetic */ BigDecimal _ebean_getni_ipLimit() {
        return this.ipLimit;
    }

    protected /* synthetic */ void _ebean_setni_ipLimit(BigDecimal _newValue) {
        this.ipLimit = _newValue;
        this._ebean_intercept.setLoadedProperty(23);
    }

    protected /* synthetic */ LimitType _ebean_get_ipLimitType() {
        this._ebean_intercept.preGetter(24);
        return this.ipLimitType;
    }

    protected /* synthetic */ void _ebean_set_ipLimitType(LimitType newValue) {
        this._ebean_intercept.preSetter(true, 24, (Object)this._ebean_get_ipLimitType(), (Object)newValue);
        this.ipLimitType = newValue;
    }

    protected /* synthetic */ LimitType _ebean_getni_ipLimitType() {
        return this.ipLimitType;
    }

    protected /* synthetic */ void _ebean_setni_ipLimitType(LimitType _newValue) {
        this.ipLimitType = _newValue;
        this._ebean_intercept.setLoadedProperty(24);
    }

    protected /* synthetic */ LimitState _ebean_get_ipLimitState() {
        this._ebean_intercept.preGetter(25);
        return this.ipLimitState;
    }

    protected /* synthetic */ void _ebean_set_ipLimitState(LimitState newValue) {
        this._ebean_intercept.preSetter(true, 25, (Object)this._ebean_get_ipLimitState(), (Object)newValue);
        this.ipLimitState = newValue;
    }

    protected /* synthetic */ LimitState _ebean_getni_ipLimitState() {
        return this.ipLimitState;
    }

    protected /* synthetic */ void _ebean_setni_ipLimitState(LimitState _newValue) {
        this.ipLimitState = _newValue;
        this._ebean_intercept.setLoadedProperty(25);
    }

    protected /* synthetic */ Timestamp _ebean_get_ipLimitTime() {
        this._ebean_intercept.preGetter(26);
        return this.ipLimitTime;
    }

    protected /* synthetic */ void _ebean_set_ipLimitTime(Timestamp newValue) {
        this._ebean_intercept.preSetter(true, 26, (Object)this._ebean_get_ipLimitTime(), (Object)newValue);
        this.ipLimitTime = newValue;
    }

    protected /* synthetic */ Timestamp _ebean_getni_ipLimitTime() {
        return this.ipLimitTime;
    }

    protected /* synthetic */ void _ebean_setni_ipLimitTime(Timestamp _newValue) {
        this.ipLimitTime = _newValue;
        this._ebean_intercept.setLoadedProperty(26);
    }

    protected /* synthetic */ String _ebean_get_ipLimitMsgId() {
        this._ebean_intercept.preGetter(27);
        return this.ipLimitMsgId;
    }

    protected /* synthetic */ void _ebean_set_ipLimitMsgId(String newValue) {
        this._ebean_intercept.preSetter(true, 27, (Object)this._ebean_get_ipLimitMsgId(), (Object)newValue);
        this.ipLimitMsgId = newValue;
    }

    protected /* synthetic */ String _ebean_getni_ipLimitMsgId() {
        return this.ipLimitMsgId;
    }

    protected /* synthetic */ void _ebean_setni_ipLimitMsgId(String _newValue) {
        this.ipLimitMsgId = _newValue;
        this._ebean_intercept.setLoadedProperty(27);
    }

    protected /* synthetic */ BigDecimal _ebean_get_investmentAmount() {
        this._ebean_intercept.preGetter(28);
        return this.investmentAmount;
    }

    protected /* synthetic */ void _ebean_set_investmentAmount(BigDecimal newValue) {
        this._ebean_intercept.preSetter(true, 28, (Object)this._ebean_get_investmentAmount(), (Object)newValue);
        this.investmentAmount = newValue;
    }

    protected /* synthetic */ BigDecimal _ebean_getni_investmentAmount() {
        return this.investmentAmount;
    }

    protected /* synthetic */ void _ebean_setni_investmentAmount(BigDecimal _newValue) {
        this.investmentAmount = _newValue;
        this._ebean_intercept.setLoadedProperty(28);
    }

    protected /* synthetic */ Type _ebean_get_type() {
        this._ebean_intercept.preGetter(29);
        return this.type;
    }

    protected /* synthetic */ void _ebean_set_type(Type newValue) {
        this._ebean_intercept.preSetter(true, 29, (Object)this._ebean_get_type(), (Object)newValue);
        this.type = newValue;
    }

    protected /* synthetic */ Type _ebean_getni_type() {
        return this.type;
    }

    protected /* synthetic */ void _ebean_setni_type(Type _newValue) {
        this.type = _newValue;
        this._ebean_intercept.setLoadedProperty(29);
    }

    protected /* synthetic */ CmFolder _ebean_get_folder() {
        this._ebean_intercept.preGetter(30);
        return this.folder;
    }

    protected /* synthetic */ void _ebean_set_folder(CmFolder newValue) {
        this._ebean_intercept.preSetter(true, 30, (Object)this._ebean_get_folder(), (Object)newValue);
        this.folder = newValue;
    }

    protected /* synthetic */ CmFolder _ebean_getni_folder() {
        return this.folder;
    }

    protected /* synthetic */ void _ebean_setni_folder(CmFolder _newValue) {
        this.folder = _newValue;
        this._ebean_intercept.setLoadedProperty(30);
    }

    protected /* synthetic */ List _ebean_get_permissions() {
        this._ebean_intercept.preGetter(31);
        if (this.permissions == null) {
            this.permissions = new BeanList();
            this._ebean_intercept.initialisedMany(31);
        }
        return this.permissions;
    }

    protected /* synthetic */ void _ebean_set_permissions(List newValue) {
        this._ebean_intercept.preSetterMany(false, 31, this.permissions, (Object)newValue);
        this.permissions = newValue;
    }

    protected /* synthetic */ List _ebean_getni_permissions() {
        return this.permissions;
    }

    protected /* synthetic */ void _ebean_setni_permissions(List _newValue) {
        this.permissions = _newValue;
        this._ebean_intercept.setLoadedProperty(31);
    }

    protected /* synthetic */ List _ebean_get_valueGroups() {
        this._ebean_intercept.preGetter(32);
        if (this.valueGroups == null) {
            this.valueGroups = new BeanList();
            this._ebean_intercept.initialisedMany(32);
            ((BeanCollection)this.valueGroups).setModifyListening(BeanCollection.ModifyListenMode.ALL);
        }
        return this.valueGroups;
    }

    protected /* synthetic */ void _ebean_set_valueGroups(List newValue) {
        this._ebean_intercept.preSetterMany(false, 32, this.valueGroups, (Object)newValue);
        this.valueGroups = newValue;
    }

    protected /* synthetic */ List _ebean_getni_valueGroups() {
        return this.valueGroups;
    }

    protected /* synthetic */ void _ebean_setni_valueGroups(List _newValue) {
        this.valueGroups = _newValue;
        this._ebean_intercept.setLoadedProperty(32);
    }

    protected /* synthetic */ List _ebean_get_automaticExports() {
        this._ebean_intercept.preGetter(33);
        if (this.automaticExports == null) {
            this.automaticExports = new BeanList();
            this._ebean_intercept.initialisedMany(33);
            ((BeanCollection)this.automaticExports).setModifyListening(BeanCollection.ModifyListenMode.ALL);
        }
        return this.automaticExports;
    }

    protected /* synthetic */ void _ebean_set_automaticExports(List newValue) {
        this._ebean_intercept.preSetterMany(false, 33, this.automaticExports, (Object)newValue);
        this.automaticExports = newValue;
    }

    protected /* synthetic */ List _ebean_getni_automaticExports() {
        return this.automaticExports;
    }

    protected /* synthetic */ void _ebean_setni_automaticExports(List _newValue) {
        this.automaticExports = _newValue;
        this._ebean_intercept.setLoadedProperty(33);
    }

    protected /* synthetic */ Boolean _ebean_get_useVirtualBalances() {
        this._ebean_intercept.preGetter(34);
        return this.useVirtualBalances;
    }

    protected /* synthetic */ void _ebean_set_useVirtualBalances(Boolean newValue) {
        this._ebean_intercept.preSetter(true, 34, (Object)this._ebean_get_useVirtualBalances(), (Object)newValue);
        this.useVirtualBalances = newValue;
    }

    protected /* synthetic */ Boolean _ebean_getni_useVirtualBalances() {
        return this.useVirtualBalances;
    }

    protected /* synthetic */ void _ebean_setni_useVirtualBalances(Boolean _newValue) {
        this.useVirtualBalances = _newValue;
        this._ebean_intercept.setLoadedProperty(34);
    }

    protected /* synthetic */ BigDecimal _ebean_get_virtualStartBalance() {
        this._ebean_intercept.preGetter(35);
        return this.virtualStartBalance;
    }

    protected /* synthetic */ void _ebean_set_virtualStartBalance(BigDecimal newValue) {
        this._ebean_intercept.preSetter(true, 35, (Object)this._ebean_get_virtualStartBalance(), (Object)newValue);
        this.virtualStartBalance = newValue;
    }

    protected /* synthetic */ BigDecimal _ebean_getni_virtualStartBalance() {
        return this.virtualStartBalance;
    }

    protected /* synthetic */ void _ebean_setni_virtualStartBalance(BigDecimal _newValue) {
        this.virtualStartBalance = _newValue;
        this._ebean_intercept.setLoadedProperty(35);
    }

    protected /* synthetic */ Date _ebean_get_virtualStartDate() {
        this._ebean_intercept.preGetter(36);
        return this.virtualStartDate;
    }

    protected /* synthetic */ void _ebean_set_virtualStartDate(Date newValue) {
        this._ebean_intercept.preSetter(true, 36, (Object)this._ebean_get_virtualStartDate(), (Object)newValue);
        this.virtualStartDate = newValue;
    }

    protected /* synthetic */ Date _ebean_getni_virtualStartDate() {
        return this.virtualStartDate;
    }

    protected /* synthetic */ void _ebean_setni_virtualStartDate(Date _newValue) {
        this.virtualStartDate = _newValue;
        this._ebean_intercept.setLoadedProperty(36);
    }

    protected /* synthetic */ Boolean _ebean_get_ignoreAccountInformation() {
        this._ebean_intercept.preGetter(37);
        return this.ignoreAccountInformation;
    }

    protected /* synthetic */ void _ebean_set_ignoreAccountInformation(Boolean newValue) {
        this._ebean_intercept.preSetter(true, 37, (Object)this._ebean_get_ignoreAccountInformation(), (Object)newValue);
        this.ignoreAccountInformation = newValue;
    }

    protected /* synthetic */ Boolean _ebean_getni_ignoreAccountInformation() {
        return this.ignoreAccountInformation;
    }

    protected /* synthetic */ void _ebean_setni_ignoreAccountInformation(Boolean _newValue) {
        this.ignoreAccountInformation = _newValue;
        this._ebean_intercept.setLoadedProperty(37);
    }

    public /* synthetic */ Object _ebean_getField(int index) {
        switch (index) {
            case 0: {
                return this.id;
            }
            case 1: {
                return this.bank;
            }
            case 2: {
                return this.name;
            }
            case 3: {
                return this.description;
            }
            case 4: {
                return this.accountHolder;
            }
            case 5: {
                return this.accountHolderHTD;
            }
            case 6: {
                return this.infoText;
            }
            case 7: {
                return this.sepaOriginator;
            }
            case 8: {
                return this.dtazvOriginator;
            }
            case 9: {
                return this.mt101Originator;
            }
            case 10: {
                return this.germanBankCode;
            }
            case 11: {
                return this.germanAccountNumber;
            }
            case 12: {
                return this.frenchBankCode;
            }
            case 13: {
                return this.frenchBranchCode;
            }
            case 14: {
                return this.frenchAccountNumber;
            }
            case 15: {
                return this.frenchCheckCode;
            }
            case 16: {
                return this.iban;
            }
            case 17: {
                return this.bic;
            }
            case 18: {
                return this.nationalBankCode;
            }
            case 19: {
                return this.nationalAccountNumber;
            }
            case 20: {
                return this.currency;
            }
            case 21: {
                return this.cmIdentification;
            }
            case 22: {
                return this.creditLimit;
            }
            case 23: {
                return this.ipLimit;
            }
            case 24: {
                return this.ipLimitType;
            }
            case 25: {
                return this.ipLimitState;
            }
            case 26: {
                return this.ipLimitTime;
            }
            case 27: {
                return this.ipLimitMsgId;
            }
            case 28: {
                return this.investmentAmount;
            }
            case 29: {
                return this.type;
            }
            case 30: {
                return this.folder;
            }
            case 31: {
                return this.permissions;
            }
            case 32: {
                return this.valueGroups;
            }
            case 33: {
                return this.automaticExports;
            }
            case 34: {
                return this.useVirtualBalances;
            }
            case 35: {
                return this.virtualStartBalance;
            }
            case 36: {
                return this.virtualStartDate;
            }
            case 37: {
                return this.ignoreAccountInformation;
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    public /* synthetic */ Object _ebean_getFieldIntercept(int index) {
        switch (index) {
            case 0: {
                return this._ebean_get_id();
            }
            case 1: {
                return this._ebean_get_bank();
            }
            case 2: {
                return this._ebean_get_name();
            }
            case 3: {
                return this._ebean_get_description();
            }
            case 4: {
                return this._ebean_get_accountHolder();
            }
            case 5: {
                return this._ebean_get_accountHolderHTD();
            }
            case 6: {
                return this._ebean_get_infoText();
            }
            case 7: {
                return this._ebean_get_sepaOriginator();
            }
            case 8: {
                return this._ebean_get_dtazvOriginator();
            }
            case 9: {
                return this._ebean_get_mt101Originator();
            }
            case 10: {
                return this._ebean_get_germanBankCode();
            }
            case 11: {
                return this._ebean_get_germanAccountNumber();
            }
            case 12: {
                return this._ebean_get_frenchBankCode();
            }
            case 13: {
                return this._ebean_get_frenchBranchCode();
            }
            case 14: {
                return this._ebean_get_frenchAccountNumber();
            }
            case 15: {
                return this._ebean_get_frenchCheckCode();
            }
            case 16: {
                return this._ebean_get_iban();
            }
            case 17: {
                return this._ebean_get_bic();
            }
            case 18: {
                return this._ebean_get_nationalBankCode();
            }
            case 19: {
                return this._ebean_get_nationalAccountNumber();
            }
            case 20: {
                return this._ebean_get_currency();
            }
            case 21: {
                return this._ebean_get_cmIdentification();
            }
            case 22: {
                return this._ebean_get_creditLimit();
            }
            case 23: {
                return this._ebean_get_ipLimit();
            }
            case 24: {
                return this._ebean_get_ipLimitType();
            }
            case 25: {
                return this._ebean_get_ipLimitState();
            }
            case 26: {
                return this._ebean_get_ipLimitTime();
            }
            case 27: {
                return this._ebean_get_ipLimitMsgId();
            }
            case 28: {
                return this._ebean_get_investmentAmount();
            }
            case 29: {
                return this._ebean_get_type();
            }
            case 30: {
                return this._ebean_get_folder();
            }
            case 31: {
                return this._ebean_get_permissions();
            }
            case 32: {
                return this._ebean_get_valueGroups();
            }
            case 33: {
                return this._ebean_get_automaticExports();
            }
            case 34: {
                return this._ebean_get_useVirtualBalances();
            }
            case 35: {
                return this._ebean_get_virtualStartBalance();
            }
            case 36: {
                return this._ebean_get_virtualStartDate();
            }
            case 37: {
                return this._ebean_get_ignoreAccountInformation();
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    public /* synthetic */ void _ebean_setField(int index, Object o) {
        switch (index) {
            case 0: {
                this._ebean_setni_id((Integer)o);
                return;
            }
            case 1: {
                this._ebean_setni_bank((BankSettings)o);
                return;
            }
            case 2: {
                this._ebean_setni_name((String)o);
                return;
            }
            case 3: {
                this._ebean_setni_description((String)o);
                return;
            }
            case 4: {
                this._ebean_setni_accountHolder((String)o);
                return;
            }
            case 5: {
                this._ebean_setni_accountHolderHTD((String)o);
                return;
            }
            case 6: {
                this._ebean_setni_infoText((String)o);
                return;
            }
            case 7: {
                this._ebean_setni_sepaOriginator((PaymentOriginator)o);
                return;
            }
            case 8: {
                this._ebean_setni_dtazvOriginator((PaymentOriginator)o);
                return;
            }
            case 9: {
                this._ebean_setni_mt101Originator((PaymentOriginator)o);
                return;
            }
            case 10: {
                this._ebean_setni_germanBankCode((String)o);
                return;
            }
            case 11: {
                this._ebean_setni_germanAccountNumber((String)o);
                return;
            }
            case 12: {
                this._ebean_setni_frenchBankCode((String)o);
                return;
            }
            case 13: {
                this._ebean_setni_frenchBranchCode((String)o);
                return;
            }
            case 14: {
                this._ebean_setni_frenchAccountNumber((String)o);
                return;
            }
            case 15: {
                this._ebean_setni_frenchCheckCode((String)o);
                return;
            }
            case 16: {
                this._ebean_setni_iban((String)o);
                return;
            }
            case 17: {
                this._ebean_setni_bic((String)o);
                return;
            }
            case 18: {
                this._ebean_setni_nationalBankCode((String)o);
                return;
            }
            case 19: {
                this._ebean_setni_nationalAccountNumber((String)o);
                return;
            }
            case 20: {
                this._ebean_setni_currency((String)o);
                return;
            }
            case 21: {
                this._ebean_setni_cmIdentification((String)o);
                return;
            }
            case 22: {
                this._ebean_setni_creditLimit((BigDecimal)o);
                return;
            }
            case 23: {
                this._ebean_setni_ipLimit((BigDecimal)o);
                return;
            }
            case 24: {
                this._ebean_setni_ipLimitType((LimitType)((Object)o));
                return;
            }
            case 25: {
                this._ebean_setni_ipLimitState((LimitState)((Object)o));
                return;
            }
            case 26: {
                this._ebean_setni_ipLimitTime((Timestamp)o);
                return;
            }
            case 27: {
                this._ebean_setni_ipLimitMsgId((String)o);
                return;
            }
            case 28: {
                this._ebean_setni_investmentAmount((BigDecimal)o);
                return;
            }
            case 29: {
                this._ebean_setni_type((Type)((Object)o));
                return;
            }
            case 30: {
                this._ebean_setni_folder((CmFolder)o);
                return;
            }
            case 31: {
                this._ebean_setni_permissions((List)o);
                return;
            }
            case 32: {
                this._ebean_setni_valueGroups((List)o);
                return;
            }
            case 33: {
                this._ebean_setni_automaticExports((List)o);
                return;
            }
            case 34: {
                this._ebean_setni_useVirtualBalances((Boolean)o);
                return;
            }
            case 35: {
                this._ebean_setni_virtualStartBalance((BigDecimal)o);
                return;
            }
            case 36: {
                this._ebean_setni_virtualStartDate((Date)o);
                return;
            }
            case 37: {
                this._ebean_setni_ignoreAccountInformation((Boolean)o);
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    public /* synthetic */ void _ebean_setFieldIntercept(int index, Object o) {
        switch (index) {
            case 0: {
                this._ebean_set_id((Integer)o);
                return;
            }
            case 1: {
                this._ebean_set_bank((BankSettings)o);
                return;
            }
            case 2: {
                this._ebean_set_name((String)o);
                return;
            }
            case 3: {
                this._ebean_set_description((String)o);
                return;
            }
            case 4: {
                this._ebean_set_accountHolder((String)o);
                return;
            }
            case 5: {
                this._ebean_set_accountHolderHTD((String)o);
                return;
            }
            case 6: {
                this._ebean_set_infoText((String)o);
                return;
            }
            case 7: {
                this._ebean_set_sepaOriginator((PaymentOriginator)o);
                return;
            }
            case 8: {
                this._ebean_set_dtazvOriginator((PaymentOriginator)o);
                return;
            }
            case 9: {
                this._ebean_set_mt101Originator((PaymentOriginator)o);
                return;
            }
            case 10: {
                this._ebean_set_germanBankCode((String)o);
                return;
            }
            case 11: {
                this._ebean_set_germanAccountNumber((String)o);
                return;
            }
            case 12: {
                this._ebean_set_frenchBankCode((String)o);
                return;
            }
            case 13: {
                this._ebean_set_frenchBranchCode((String)o);
                return;
            }
            case 14: {
                this._ebean_set_frenchAccountNumber((String)o);
                return;
            }
            case 15: {
                this._ebean_set_frenchCheckCode((String)o);
                return;
            }
            case 16: {
                this._ebean_set_iban((String)o);
                return;
            }
            case 17: {
                this._ebean_set_bic((String)o);
                return;
            }
            case 18: {
                this._ebean_set_nationalBankCode((String)o);
                return;
            }
            case 19: {
                this._ebean_set_nationalAccountNumber((String)o);
                return;
            }
            case 20: {
                this._ebean_set_currency((String)o);
                return;
            }
            case 21: {
                this._ebean_set_cmIdentification((String)o);
                return;
            }
            case 22: {
                this._ebean_set_creditLimit((BigDecimal)o);
                return;
            }
            case 23: {
                this._ebean_set_ipLimit((BigDecimal)o);
                return;
            }
            case 24: {
                this._ebean_set_ipLimitType((LimitType)((Object)o));
                return;
            }
            case 25: {
                this._ebean_set_ipLimitState((LimitState)((Object)o));
                return;
            }
            case 26: {
                this._ebean_set_ipLimitTime((Timestamp)o);
                return;
            }
            case 27: {
                this._ebean_set_ipLimitMsgId((String)o);
                return;
            }
            case 28: {
                this._ebean_set_investmentAmount((BigDecimal)o);
                return;
            }
            case 29: {
                this._ebean_set_type((Type)((Object)o));
                return;
            }
            case 30: {
                this._ebean_set_folder((CmFolder)o);
                return;
            }
            case 31: {
                this._ebean_set_permissions((List)o);
                return;
            }
            case 32: {
                this._ebean_set_valueGroups((List)o);
                return;
            }
            case 33: {
                this._ebean_set_automaticExports((List)o);
                return;
            }
            case 34: {
                this._ebean_set_useVirtualBalances((Boolean)o);
                return;
            }
            case 35: {
                this._ebean_set_virtualStartBalance((BigDecimal)o);
                return;
            }
            case 36: {
                this._ebean_set_virtualStartDate((Date)o);
                return;
            }
            case 37: {
                this._ebean_set_ignoreAccountInformation((Boolean)o);
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private /* synthetic */ Object _ebean_getIdentity() {
        Account account = this;
        synchronized (account) {
            if (this._ebean_identity != null) {
                return this._ebean_identity;
            }
            Object tmpId = this._ebean_getField(0);
            this._ebean_identity = tmpId != null ? tmpId : new Object();
            return this._ebean_identity;
        }
    }

    public /* synthetic */ boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        return this._ebean_getIdentity().equals(((Account)obj)._ebean_getIdentity());
    }

    public /* synthetic */ int hashCode() {
        return this._ebean_getIdentity().hashCode();
    }

    public /* synthetic */ void _ebean_setEmbeddedLoaded() {
    }

    public /* synthetic */ boolean _ebean_isEmbeddedNewOrDirty() {
        return false;
    }

    public /* synthetic */ Object _ebean_newInstance() {
        return new Account();
    }

    public static enum LimitType {
        DAY_LIMIT,
        TRANSACTION_LIMIT,
        NO_LIMIT;

    }

    public static enum LimitState {
        SUBMITTED,
        CONFIRMED,
        REJECTED;

    }

    public static enum Type {
        HTD,
        CASH_MANAGEMENT,
        MANUAL;

    }
}

