/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.database.update;

import de.businesslogics.banking.database.update.DatabaseUpdateHandler;
import de.businesslogics.banking.database.update.DatabaseUpdateLogger;
import de.businesslogics.persistence.DBType;
import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;

public final class DatabaseUpdateHandler96
implements DatabaseUpdateHandler {
    @Override
    public void setWorkspace(File workspace) {
    }

    @Override
    public void setSchema(String schema) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void prepareForUpdate(Connection connection, DBType type) throws SQLException {
        boolean firstEntry;
        PreparedStatement stmt = connection.prepareStatement("SELECT account_id, bank_user_id FROM account_permission GROUP BY account_id, bank_user_id HAVING COUNT(*) >= 2");
        ResultSet resultSet = stmt.executeQuery();
        ArrayList<Key> results = new ArrayList<Key>();
        try {
            while (resultSet.next()) {
                results.add(new Key(this, resultSet.getInt(1), resultSet.getInt(2)));
            }
        }
        finally {
            resultSet.close();
            stmt.close();
        }
        stmt = connection.prepareStatement("select id from account_permission where account_id=? and bank_user_id=?");
        PreparedStatement delete = connection.prepareStatement("delete from account_permission where id=?");
        for (Key key : results) {
            DatabaseUpdateLogger.logWarning("Deleting account_permission entries with account_id = " + key.accountId + ", bank_user_id = " + key.bankUserId);
            firstEntry = true;
            stmt.setInt(1, key.accountId);
            stmt.setInt(2, key.bankUserId);
            resultSet = stmt.executeQuery();
            while (resultSet.next()) {
                if (firstEntry) {
                    firstEntry = false;
                    continue;
                }
                delete.setInt(1, resultSet.getInt(1));
                delete.execute();
            }
            resultSet.close();
        }
        stmt.close();
        delete.close();
        stmt = connection.prepareStatement("SELECT account_id, bank_user_id FROM ap_overwrite GROUP BY account_id, bank_user_id HAVING COUNT(*) >= 2");
        resultSet = stmt.executeQuery();
        results.clear();
        try {
            while (resultSet.next()) {
                results.add(new Key(this, resultSet.getInt(1), resultSet.getInt(2)));
            }
        }
        finally {
            resultSet.close();
        }
        stmt.close();
        stmt = connection.prepareStatement("select id from ap_overwrite where account_id=? and bank_user_id=?");
        delete = connection.prepareStatement("delete from ap_overwrite where id=?");
        for (Key key : results) {
            DatabaseUpdateLogger.logWarning("Deleting ap_overwrite entries with account_id = " + key.accountId + ", bank_user_id = " + key.bankUserId);
            firstEntry = true;
            stmt.setInt(1, key.accountId);
            stmt.setInt(2, key.bankUserId);
            resultSet = stmt.executeQuery();
            while (resultSet.next()) {
                if (firstEntry) {
                    firstEntry = false;
                    continue;
                }
                delete.setInt(1, resultSet.getInt(1));
                delete.execute();
            }
        }
    }

    @Override
    public void postProcessUpdate(Connection connection, DBType type) throws SQLException {
    }

    private final class Key {
        int accountId;
        int bankUserId;

        public Key(DatabaseUpdateHandler96 databaseUpdateHandler96, int accountId, int bankUserId) {
            this.accountId = accountId;
            this.bankUserId = bankUserId;
        }
    }
}

