/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.database.update;

import de.businesslogics.banking.database.update.DatabaseUpdateHandler;
import de.businesslogics.banking.database.update.DatabaseUpdateLogger;
import de.businesslogics.persistence.DBType;
import java.io.File;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public final class DatabaseUpdateHandler90
implements DatabaseUpdateHandler {
    private String schema;

    @Override
    public void setWorkspace(File workspace) {
    }

    @Override
    public void setSchema(String schema) {
        this.schema = schema;
    }

    @Override
    public void prepareForUpdate(Connection connection, DBType type) throws SQLException {
        this.checkPresentUniqueKey(connection, type);
        DatabaseUpdateHandler90.checkForMultipleEntries(connection);
    }

    @Override
    public void postProcessUpdate(Connection connection, DBType type) throws SQLException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkPresentUniqueKey(Connection connection, DBType dbType) throws SQLException {
        String tableName;
        String catalog;
        DatabaseMetaData metaData;
        block16: {
            ResultSet tableResultSet;
            metaData = connection.getMetaData();
            if (metaData.storesUpperCaseIdentifiers()) {
                if (this.schema != null) {
                    this.schema = this.schema.toUpperCase();
                }
                tableResultSet = metaData.getTables(connection.getCatalog(), this.schema, "CM_STATEMENT", new String[]{"TABLE"});
            } else {
                if (this.schema != null) {
                    this.schema = this.schema.toLowerCase();
                }
                tableResultSet = metaData.getTables(connection.getCatalog(), this.schema, "cm_statement", new String[]{"TABLE"});
            }
            try {
                if (tableResultSet.next()) {
                    catalog = tableResultSet.getString(1);
                    this.schema = tableResultSet.getString(2);
                    tableName = tableResultSet.getString(3);
                    break block16;
                }
                throw new RuntimeException("Table \"cm_statement\" not found!");
            }
            finally {
                tableResultSet.close();
            }
        }
        boolean foundUniqueKey = false;
        try (ResultSet uniqueResultSet = metaData.getIndexInfo(catalog, this.schema, tableName, true, true);){
            while (uniqueResultSet.next()) {
                if (uniqueResultSet.getString(6) == null || !uniqueResultSet.getString(6).toLowerCase().startsWith("uq_cm_statement_1")) continue;
                foundUniqueKey = true;
                break;
            }
        }
        if (foundUniqueKey) {
            try (PreparedStatement stmt = dbType == DBType.MYSQL ? connection.prepareStatement("ALTER TABLE cm_statement DROP INDEX uq_cm_statement_1") : connection.prepareStatement("ALTER TABLE cm_statement DROP CONSTRAINT uq_cm_statement_1");){
                stmt.execute();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkForMultipleEntries(Connection connection) throws SQLException {
        ArrayList<String> entries = new ArrayList<String>();
        PreparedStatement stmt = connection.prepareStatement("SELECT account_id, unique_id FROM cm_statement GROUP BY account_id, unique_id HAVING count(*) >=2");
        try (ResultSet resultSet = stmt.executeQuery();){
            while (resultSet.next()) {
                entries.add("" + resultSet.getInt(1) + ';' + resultSet.getString(2));
            }
        }
        for (String entry : entries) {
            String[] entryParts = entry.split(";");
            DatabaseUpdateHandler90.cleanupMultipleEntries(connection, Integer.parseInt(entryParts[0]), entryParts[1]);
        }
    }

    private static void cleanupMultipleEntries(Connection con, int accountId, String uniqueId) throws SQLException {
        DatabaseUpdateLogger.logWarning("Found multiple entries with account_id = " + accountId + ", unique_id = " + uniqueId);
        PreparedStatement stmt = con.prepareStatement("select id from cm_statement where account_id=? and unique_id=?");
        PreparedStatement stmt2 = con.prepareStatement("select count(*) from cm_booking where statement_id=?");
        stmt.setInt(1, accountId);
        stmt.setString(2, uniqueId);
        ResultSet result = stmt.executeQuery();
        HashMap<Integer, Integer> ids = new HashMap<Integer, Integer>();
        while (result.next()) {
            int statementId = result.getInt(1);
            stmt2.setInt(1, statementId);
            ResultSet result2 = stmt2.executeQuery();
            if (result2.next()) {
                ids.put(statementId, result2.getInt(1));
            }
            result2.close();
        }
        result.close();
        stmt.close();
        stmt2.close();
        int statementWithMostBookingsIndex = -1;
        int maxBookings = 0;
        for (Map.Entry e : ids.entrySet()) {
            if ((Integer)e.getValue() <= maxBookings) continue;
            maxBookings = (Integer)e.getValue();
            statementWithMostBookingsIndex = (Integer)e.getKey();
        }
        ArrayList<Integer> indexesToDelete = new ArrayList<Integer>();
        for (Map.Entry entry : ids.entrySet()) {
            if ((Integer)entry.getKey() == statementWithMostBookingsIndex) continue;
            DatabaseUpdateLogger.logWarning("Deleting cm_statement entry with ID " + String.valueOf(entry.getKey()));
            indexesToDelete.add((Integer)entry.getKey());
        }
        StringBuilder idString = new StringBuilder();
        boolean bl = true;
        for (Integer i : indexesToDelete) {
            boolean bl2;
            if (!bl2) {
                idString.append(",");
            }
            idString.append(i);
            bl2 = false;
        }
        stmt = con.prepareStatement("select id from cm_booking where statement_id in (" + idString.toString() + ")");
        result = stmt.executeQuery();
        stmt2 = con.prepareStatement("update cm_booking set parent_booking_id=null where parent_booking_id=?");
        while (result.next()) {
            stmt2.setInt(1, result.getInt(1));
            stmt2.execute();
        }
        result.close();
        stmt.close();
        stmt2.close();
        Statement s = con.createStatement();
        s.execute("delete from cm_booking where statement_id in(" + idString.toString() + ")");
        s.execute("delete from cm_page where statement_id in (" + idString.toString() + ")");
        s.execute("delete from cm_check where statement_id in (" + idString.toString() + ")");
        s.execute("delete from cm_statement where id in (" + idString.toString() + ")");
        stmt.close();
    }
}

