/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.database.update;

import de.businesslogics.banking.database.update.DatabaseUpdateHandler;
import de.businesslogics.banking.database.vo.PaymentTransferType;
import de.businesslogics.persistence.DBType;
import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;

public class DatabaseUpdateHandler240
implements DatabaseUpdateHandler {
    private final Map<String, String> btfMap = new HashMap<String, String>();
    private final Map<String, Integer> pmtTypeMap = new HashMap<String, Integer>();
    private final StringBuilder inBuilder = new StringBuilder();

    @Override
    public void setWorkspace(File workspace) {
    }

    @Override
    public void setSchema(String schema) {
    }

    @Override
    public void prepareForUpdate(Connection connection, DBType type) throws SQLException {
    }

    @Override
    public void postProcessUpdate(Connection connection, DBType type) throws SQLException {
        String[] tableNames;
        this.addToMaps("XDT", "XCT:BBK:URG_dtbbksw", PaymentTransferType.PmtType.BBK_HBV_FOREIGN_TRANSFER_EUR);
        this.addToMaps("XWT", "XCT:BBK:URG_wtbbksw", PaymentTransferType.PmtType.BBK_HBV_FOREIGN_TRANSFER_NON_EUR);
        this.addToMaps("XTG", "XCT:BBK:URG_tgbbksw", PaymentTransferType.PmtType.BBK_HBV_TARGET2_TRANSFER);
        this.addToMaps("XG2", "DCT:BBK:URG_gtbbksw", PaymentTransferType.PmtType.BBK_HBV_DOMESTIC_SWIFT_TRANSFER);
        this.addToMaps("XG1", "DCT:BBK:URG_gtdta", PaymentTransferType.PmtType.BBK_HBV_DOMESTIC_DTA_TRANSFER);
        this.addToMaps("XGK", "DCT:BBK_gkdta", PaymentTransferType.PmtType.BBK_EMZ_DTA_TRANSFER);
        this.addToMaps("XLK", "DDD:BBK_lkdta", PaymentTransferType.PmtType.BBK_EMZ_DTA_DIRECT_DEBIT);
        this.addToMaps("XGS", "DCT:BBK_gsbbksw", PaymentTransferType.PmtType.BBK_EMZ_STEP2_TRANSFER);
        this.addToMaps("XCG", "DCT:BBK_cgdta", PaymentTransferType.PmtType.BBK_EMZ_PACKED_DTA_TRANSFER);
        this.addToMaps("XCL", "DDD:BBK_cldta", PaymentTransferType.PmtType.BBK_EMZ_PACKED_DTA_DIRECT_DEBIT);
        this.addToMaps("XCS", "DCT:BBK_csbbksw", PaymentTransferType.PmtType.BBK_EMZ_PACKED_STEP2_TRANSFER);
        for (String tableName : tableNames = new String[]{"pmt_open", "pmt_periodic", "pmt_template"}) {
            String sqlPmt = "update " + tableName + " set pmt_type=?, file_type=? where order_type=?";
            PreparedStatement updatePmt = connection.prepareStatement(sqlPmt);
            for (String orderType : this.pmtTypeMap.keySet()) {
                int pmtType = this.pmtTypeMap.get(orderType);
                String btf = this.btfMap.get(orderType);
                updatePmt.setInt(1, pmtType);
                updatePmt.setString(2, btf);
                updatePmt.setString(3, orderType);
                updatePmt.execute();
            }
            updatePmt.close();
        }
        String sqlSendItem = "update send_item set pmt_type=? where order_type=?";
        PreparedStatement updateSendItem = connection.prepareStatement(sqlSendItem);
        for (String orderType : this.pmtTypeMap.keySet()) {
            int pmtType = this.pmtTypeMap.get(orderType);
            updateSendItem.setInt(1, pmtType);
            updateSendItem.setString(2, orderType);
            updateSendItem.execute();
        }
        updateSendItem.close();
        String inCondition = this.inBuilder.toString();
        inCondition = inCondition.substring(0, inCondition.length() - 1);
        Statement stmt = connection.createStatement();
        ResultSet result = stmt.executeQuery("select id, pmt_type from send_item where pmt_type in (" + inCondition + ")");
        PreparedStatement updatePmtSigned = connection.prepareStatement("update pmt_signed set pmt_type=? where send_id=?");
        while (result.next()) {
            updatePmtSigned.setInt(1, result.getInt(2));
            updatePmtSigned.setInt(2, result.getInt(1));
            updatePmtSigned.execute();
        }
        updatePmtSigned.close();
        result.close();
        stmt.close();
        String sql = "update ds_order_details set pmt_type=? where file_type=?";
        PreparedStatement update = connection.prepareStatement(sql);
        for (String orderType : this.pmtTypeMap.keySet()) {
            int pmtType = this.pmtTypeMap.get(orderType);
            update.setInt(1, pmtType);
            update.setString(2, orderType);
            update.execute();
        }
        update.close();
    }

    private void addToMaps(String orderType, String btf, PaymentTransferType.PmtType pmtType) {
        int pmtTypeAsInt = pmtType.ordinal();
        this.btfMap.put(orderType, btf);
        this.pmtTypeMap.put(orderType, pmtTypeAsInt);
        this.inBuilder.append(pmtTypeAsInt);
        this.inBuilder.append(",");
    }
}

