/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.database.update;

import de.businesslogics.banking.database.update.DatabaseUpdateHandler;
import de.businesslogics.banking.database.vo.PaymentTransferType;
import de.businesslogics.persistence.DBType;
import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashMap;

public class DatabaseUpdateHandler225
implements DatabaseUpdateHandler {
    @Override
    public void setWorkspace(File workspace) {
    }

    @Override
    public void setSchema(String schema) {
    }

    @Override
    public void prepareForUpdate(Connection connection, DBType type) throws SQLException {
    }

    @Override
    public void postProcessUpdate(Connection connection, DBType type) throws SQLException {
        String[] tableNames;
        HashMap<String, PaymentTransferType.PmtType> orderTypeMap = new HashMap<String, PaymentTransferType.PmtType>();
        HashMap<String, PaymentTransferType.PmtType> fileTypeMap = new HashMap<String, PaymentTransferType.PmtType>();
        orderTypeMap.put("CCT", PaymentTransferType.PmtType.SEPA_TRANSFER);
        fileTypeMap.put("pain.001.001.02.sct", PaymentTransferType.PmtType.SEPA_TRANSFER);
        fileTypeMap.put("pain.001.001.03.sct", PaymentTransferType.PmtType.SEPA_TRANSFER);
        fileTypeMap.put("SCT_pain.001", PaymentTransferType.PmtType.SEPA_TRANSFER);
        orderTypeMap.put("CCU", PaymentTransferType.PmtType.SEPA_URGENT_TRANSFER);
        fileTypeMap.put("XCT:DE:URG_pain.001", PaymentTransferType.PmtType.SEPA_URGENT_TRANSFER);
        orderTypeMap.put("CIP", PaymentTransferType.PmtType.SEPA_INSTANT_TRANSFER);
        fileTypeMap.put("pain.001.001.02.sct.inst", PaymentTransferType.PmtType.SEPA_INSTANT_TRANSFER);
        fileTypeMap.put("SCI:DE_pain.001", PaymentTransferType.PmtType.SEPA_INSTANT_TRANSFER);
        orderTypeMap.put("XCT", PaymentTransferType.PmtType.SEPA_FOREIGN_CURRENCY_TRANSFER);
        fileTypeMap.put("XCT_pain.001", PaymentTransferType.PmtType.SEPA_FOREIGN_CURRENCY_TRANSFER);
        orderTypeMap.put("XE2", PaymentTransferType.PmtType.SEPA_TRANSFER);
        orderTypeMap.put("CDD", PaymentTransferType.PmtType.SEPA_CORE_DIRECT_DEBIT);
        fileTypeMap.put("pain.008.001.02.sdd", PaymentTransferType.PmtType.SEPA_CORE_DIRECT_DEBIT);
        fileTypeMap.put("pain.008.001.01.sdd", PaymentTransferType.PmtType.SEPA_CORE_DIRECT_DEBIT);
        fileTypeMap.put("SDD::COR_pain.008", PaymentTransferType.PmtType.SEPA_CORE_DIRECT_DEBIT);
        orderTypeMap.put("CDB", PaymentTransferType.PmtType.SEPA_B2B_DIRECT_DEBIT);
        fileTypeMap.put("SDD::B2B_pain.008", PaymentTransferType.PmtType.SEPA_B2B_DIRECT_DEBIT);
        orderTypeMap.put("CD1", PaymentTransferType.PmtType.SEPA_COR1_DIRECT_DEBIT);
        fileTypeMap.put("SDD:BIL:0CD1_pain.008", PaymentTransferType.PmtType.SEPA_COR1_DIRECT_DEBIT);
        orderTypeMap.put("AZV", PaymentTransferType.PmtType.DTAZV_TRANSFER);
        fileTypeMap.put("XCT:DE_dtazv", PaymentTransferType.PmtType.DTAZV_TRANSFER);
        orderTypeMap.put("RFT", PaymentTransferType.PmtType.MT101_TRANSFER);
        fileTypeMap.put("RFT_mt101", PaymentTransferType.PmtType.MT101_TRANSFER);
        orderTypeMap.put("XXC", PaymentTransferType.PmtType.SEPA_VIRTUAL_ACCOUNT_TRANSFER);
        fileTypeMap.put("XXC_pain.001", PaymentTransferType.PmtType.SEPA_VIRTUAL_ACCOUNT_TRANSFER);
        orderTypeMap.put("pain.xxx.cfonb320.xct", PaymentTransferType.PmtType.CFONB320_TRANSFER);
        orderTypeMap.put("pain.xxx.cfonb160.dct", PaymentTransferType.PmtType.CFONB160_TRANSFER);
        fileTypeMap.put("DCT:FR_cfonb160", PaymentTransferType.PmtType.CFONB160_TRANSFER);
        orderTypeMap.put("pain.xxx.cfonb160.ict", PaymentTransferType.PmtType.CFONB160_URGENT_TRANSFER);
        fileTypeMap.put("ICT:FR_cfonb160", PaymentTransferType.PmtType.CFONB160_URGENT_TRANSFER);
        orderTypeMap.put("pain.xxx.cfonb160.ddd", PaymentTransferType.PmtType.CFONB160_DIRECT_DEBIT);
        fileTypeMap.put("DDD:FR_cfonb160", PaymentTransferType.PmtType.CFONB160_DIRECT_DEBIT);
        orderTypeMap.put("pain.xxx.cfonb160.dda", PaymentTransferType.PmtType.CFONB160_URGENT_DIRECT_DEBIT);
        fileTypeMap.put("DDA:FR_cfonb160", PaymentTransferType.PmtType.CFONB160_URGENT_DIRECT_DEBIT);
        orderTypeMap.put("pain.xxx.cfonb160.dco", PaymentTransferType.PmtType.CFONB160_BILL_OF_EXCHANGE);
        fileTypeMap.put("DCO:FR_cfonb160", PaymentTransferType.PmtType.CFONB160_BILL_OF_EXCHANGE);
        for (String tableName : tableNames = new String[]{"pmt_open", "pmt_periodic", "pmt_template", "send_item"}) {
            String sql = "update " + tableName + " set pmt_type=? where order_type=?";
            PreparedStatement update = connection.prepareStatement(sql);
            for (String orderType : orderTypeMap.keySet()) {
                int pmtType = ((PaymentTransferType.PmtType)((Object)orderTypeMap.get(orderType))).ordinal();
                update.setInt(1, pmtType);
                update.setString(2, orderType);
                update.execute();
            }
            update.close();
        }
        String sql = "update send_item set pmt_type=? where file_type=?";
        PreparedStatement update = connection.prepareStatement(sql);
        for (String fileType : fileTypeMap.keySet()) {
            int pmtType = ((PaymentTransferType.PmtType)((Object)fileTypeMap.get(fileType))).ordinal();
            update.setInt(1, pmtType);
            update.setString(2, fileType);
            update.execute();
        }
        update.close();
    }
}

