/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.database.update;

import de.businesslogics.banking.database.update.DatabaseUpdateHandler;
import de.businesslogics.banking.database.vo.Account;
import de.businesslogics.persistence.DBType;
import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public final class DatabaseUpdateHandler196
implements DatabaseUpdateHandler {
    @Override
    public void setWorkspace(File workspace) {
    }

    @Override
    public void setSchema(String schema) {
    }

    @Override
    public void prepareForUpdate(Connection connection, DBType type) throws SQLException {
        PreparedStatement pStmt = connection.prepareStatement("update account set name=? where id = ?");
        Statement stmt = connection.createStatement();
        ResultSet result = stmt.executeQuery("select id, iban, de_bank_code, de_account_number,fr_bank_code, fr_branch_code, fr_account_number, national_bank_code, national_account_number, cm_identification, currency from account where name is null");
        while (result.next()) {
            pStmt.setString(1, this.getDisplayName(result));
            pStmt.setInt(2, result.getInt(1));
            pStmt.execute();
        }
        result.close();
        pStmt.close();
        stmt.close();
    }

    private String getDisplayName(ResultSet result) throws SQLException {
        Account t = new Account();
        t.setId(result.getInt(1));
        t.setIban(result.getString(2));
        t.setGermanBankCode(result.getString(3));
        t.setGermanAccountNumber(result.getString(4));
        t.setFrenchBankCode(result.getString(5));
        t.setFrenchBranchCode(result.getString(6));
        t.setFrenchAccountNumber(result.getString(7));
        t.setNationalBankCode(result.getString(8));
        t.setNationalAccountNumber(result.getString(9));
        t.setCmIdentification(result.getString(10));
        t.setCurrency(result.getString(11));
        return Account.getDefaultDisplayName(t);
    }

    @Override
    public void postProcessUpdate(Connection connection, DBType type) throws SQLException {
    }
}

