/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.database.update;

import de.businesslogics.banking.database.update.DatabaseUpdateHandler100;
import de.businesslogics.banking.database.update.DatabaseUpdateHandler103;
import de.businesslogics.banking.database.update.DatabaseUpdateHandler171;
import de.businesslogics.banking.database.update.DatabaseUpdateHandler187;
import de.businesslogics.banking.database.update.DatabaseUpdateHandler196;
import de.businesslogics.banking.database.update.DatabaseUpdateHandler213;
import de.businesslogics.banking.database.update.DatabaseUpdateHandler215;
import de.businesslogics.banking.database.update.DatabaseUpdateHandler225;
import de.businesslogics.banking.database.update.DatabaseUpdateHandler226;
import de.businesslogics.banking.database.update.DatabaseUpdateHandler227;
import de.businesslogics.banking.database.update.DatabaseUpdateHandler228;
import de.businesslogics.banking.database.update.DatabaseUpdateHandler240;
import de.businesslogics.banking.database.update.DatabaseUpdateHandler77;
import de.businesslogics.banking.database.update.DatabaseUpdateHandler90;
import de.businesslogics.banking.database.update.DatabaseUpdateHandler91;
import de.businesslogics.banking.database.update.DatabaseUpdateHandler96;
import de.businesslogics.persistence.DBType;
import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

public interface DatabaseUpdateHandler {
    public void setWorkspace(File var1);

    public void setSchema(String var1);

    public void prepareForUpdate(Connection var1, DBType var2) throws SQLException;

    public void postProcessUpdate(Connection var1, DBType var2) throws SQLException;

    public static final class Finder {
        private static final Map<Integer, Class<? extends DatabaseUpdateHandler>> knownHandlers = new HashMap<Integer, Class<? extends DatabaseUpdateHandler>>();

        private Finder() {
        }

        public static DatabaseUpdateHandler findDatabaseUpdateHandler(int version) {
            Class<? extends DatabaseUpdateHandler> knownHandler = knownHandlers.get(version);
            if (knownHandler == null) {
                return null;
            }
            try {
                return knownHandler.newInstance();
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }

        static {
            knownHandlers.put(77, DatabaseUpdateHandler77.class);
            knownHandlers.put(90, DatabaseUpdateHandler90.class);
            knownHandlers.put(91, DatabaseUpdateHandler91.class);
            knownHandlers.put(96, DatabaseUpdateHandler96.class);
            knownHandlers.put(100, DatabaseUpdateHandler100.class);
            knownHandlers.put(103, DatabaseUpdateHandler103.class);
            knownHandlers.put(171, DatabaseUpdateHandler171.class);
            knownHandlers.put(187, DatabaseUpdateHandler187.class);
            knownHandlers.put(196, DatabaseUpdateHandler196.class);
            knownHandlers.put(213, DatabaseUpdateHandler213.class);
            knownHandlers.put(215, DatabaseUpdateHandler215.class);
            knownHandlers.put(225, DatabaseUpdateHandler225.class);
            knownHandlers.put(226, DatabaseUpdateHandler226.class);
            knownHandlers.put(227, DatabaseUpdateHandler227.class);
            knownHandlers.put(228, DatabaseUpdateHandler228.class);
            knownHandlers.put(240, DatabaseUpdateHandler240.class);
        }
    }
}

