/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.database.api;

import de.businesslogics.persistence.DBType;
import de.businesslogics.util.HexTool;
import de.businesslogics.zkasecurity.InvalidPasswordException;
import de.businesslogics.zkasecurity.KeyStore;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Properties;

public final class JdbcSettings {
    private static final String PROP_DRIVER = "jdbc.driver";
    private static final String PROP_URL = "jdbc.url";
    private static final String PROP_USER = "jdbc.user";
    private static final String PROP_PASSWORD = "jdbc.password";
    private static final String PROP_PASSWORD_ENC = "jdbc.password.enc";
    private static final String PROP_SCHEMA = "jdbc.schema";
    public static final String JDBC_PROPERTIES = "jdbc.properties";
    public static final String JDBC_READONLY_PROPERTIES = "jdbc.readonly.properties";
    private final File workspaceDir;
    private final File propertiesFile;
    private String jdbcDriver;
    private String jdbcUrl;
    private String dbUser;
    private String dbPassword;
    private String dbSchema;

    public JdbcSettings(File workspaceDir, DBType dbType, String jdbcUrl, String dbUser, String dbPassword) {
        this.workspaceDir = workspaceDir;
        this.propertiesFile = new File(workspaceDir, JDBC_PROPERTIES);
        if (dbType == DBType.H2) {
            this.jdbcDriver = "org.h2.Driver";
        } else if (dbType == DBType.HSQL) {
            this.jdbcDriver = "org.hsqldb.jdbc.JDBCDriver";
        } else if (dbType == DBType.MYSQL) {
            this.jdbcDriver = "com.mysql.cj.jdbc.Driver";
        } else if (dbType == DBType.MSSQL) {
            this.jdbcDriver = "com.microsoft.sqlserver.jdbc.SQLServerDriver";
        } else if (dbType == DBType.ORACLE) {
            this.jdbcDriver = "oracle.jdbc.driver.OracleDriver";
        } else if (dbType == DBType.PSQL) {
            this.jdbcDriver = "org.postgresql.Driver";
        } else if (dbType == DBType.MARIADB) {
            this.jdbcDriver = "org.mariadb.jdbc.Driver";
        } else {
            throw new RuntimeException("Invalid database type: " + String.valueOf((Object)dbType));
        }
        this.jdbcUrl = jdbcUrl;
        this.dbUser = dbUser;
        this.dbPassword = dbPassword;
    }

    public JdbcSettings(File workspaceDir) throws IOException {
        this(workspaceDir, new File(workspaceDir, JDBC_PROPERTIES));
    }

    public JdbcSettings(File workspaceDir, File propertiesFile) throws IOException {
        this.workspaceDir = workspaceDir;
        this.propertiesFile = propertiesFile;
        Properties jdbcProperties = new Properties();
        try (InputStream propertiesInputStream = Files.newInputStream(propertiesFile.toPath(), new OpenOption[0]);){
            jdbcProperties.load(propertiesInputStream);
        }
        this.jdbcDriver = jdbcProperties.getProperty(PROP_DRIVER);
        this.jdbcUrl = jdbcProperties.getProperty(PROP_URL);
        this.dbUser = jdbcProperties.getProperty(PROP_USER);
        this.dbPassword = this.getPasswordFromProperties(jdbcProperties, propertiesFile);
        this.dbSchema = jdbcProperties.getProperty(PROP_SCHEMA);
    }

    public String getJdbcDriver() {
        return this.jdbcDriver;
    }

    public void setJdbcDriver(String jdbcDriver) {
        this.jdbcDriver = jdbcDriver;
    }

    public String getJdbcUrl() {
        if (this.jdbcUrl != null) {
            if (this.workspaceDir != null) {
                return this.jdbcUrl.replace("${workspace_loc}", this.workspaceDir.getAbsolutePath());
            }
            return this.jdbcUrl;
        }
        return null;
    }

    public String getPlainJdbcUrl() {
        return this.jdbcUrl;
    }

    public void setJdbcUrl(String jdbcUrl) {
        this.jdbcUrl = jdbcUrl;
    }

    public String getDbUser() {
        return this.dbUser;
    }

    public void setDbUser(String dbUser) {
        this.dbUser = dbUser;
    }

    public String getDbPassword() {
        return this.dbPassword;
    }

    public void setDbPassword(String dbPassword) {
        this.dbPassword = dbPassword;
    }

    public String getSchema() {
        if (this.dbSchema == null && this.getDbType() == DBType.ORACLE && this.dbUser != null) {
            return this.dbUser.toUpperCase();
        }
        return this.dbSchema;
    }

    public void setSchema(String dbSchema) {
        this.dbSchema = dbSchema;
    }

    public DBType getDbType() {
        if (this.jdbcDriver == null) {
            return null;
        }
        if ("org.h2.Driver".equals(this.jdbcDriver)) {
            return DBType.H2;
        }
        if ("com.mysql.jdbc.Driver".equals(this.jdbcDriver) || "com.mysql.cj.jdbc.Driver".equals(this.jdbcDriver)) {
            return DBType.MYSQL;
        }
        if ("com.microsoft.sqlserver.jdbc.SQLServerDriver".equals(this.jdbcDriver)) {
            return DBType.MSSQL;
        }
        if ("oracle.jdbc.driver.OracleDriver".equals(this.jdbcDriver)) {
            return DBType.ORACLE;
        }
        if ("org.postgresql.Driver".equals(this.jdbcDriver)) {
            return DBType.PSQL;
        }
        return null;
    }

    public void storeSettings() throws IOException {
        Properties jdbcProperties = new Properties();
        jdbcProperties.setProperty(PROP_DRIVER, this.jdbcDriver);
        jdbcProperties.setProperty(PROP_URL, this.jdbcUrl);
        jdbcProperties.setProperty(PROP_USER, this.dbUser);
        jdbcProperties.setProperty(PROP_PASSWORD, this.dbPassword);
        if (this.dbSchema != null) {
            jdbcProperties.setProperty(PROP_SCHEMA, this.dbSchema);
        }
        this.getPasswordFromProperties(jdbcProperties, this.propertiesFile);
    }

    private String getPasswordFromProperties(Properties properties, File propertiesFile) throws IOException {
        String plainPassword = properties.getProperty(PROP_PASSWORD);
        char[] password = new char[]{'=', 'u', 'P', 'd', '(', 'B', '6', '6', '_', '\\', 't', 'b', 'w', 'M', '=', 'L', '(', 'g', 'o', 'n'};
        if (plainPassword != null) {
            try (OutputStream propFileOutputStream = null;){
                byte[] encPassword = KeyStore.encryptData(plainPassword.getBytes(StandardCharsets.UTF_8), password);
                properties.setProperty(PROP_PASSWORD_ENC, HexTool.toHex(encPassword));
                properties.remove(PROP_PASSWORD);
                if (propertiesFile != null) {
                    propertiesFile.getParentFile().mkdirs();
                    propFileOutputStream = Files.newOutputStream(propertiesFile.toPath(), new OpenOption[0]);
                    properties.store(propFileOutputStream, null);
                }
            }
            return plainPassword;
        }
        String encPasswordHex = properties.getProperty(PROP_PASSWORD_ENC);
        if (encPasswordHex != null && encPasswordHex.length() > 0) {
            try {
                return new String(KeyStore.decryptData(HexTool.fromHex(encPasswordHex), password), StandardCharsets.UTF_8);
            }
            catch (InvalidPasswordException pwd) {
                throw new IOException(pwd);
            }
        }
        return null;
    }

    public Properties getEbeanProperties() {
        Properties dsConfig = new Properties();
        dsConfig.put("driver", this.getJdbcDriver());
        dsConfig.put("url", this.getJdbcUrl());
        dsConfig.put("username", this.getDbUser());
        dsConfig.put("password", this.getDbPassword());
        return dsConfig;
    }
}

