/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.database.api;

import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.Account;
import de.businesslogics.banking.database.vo.CmFolder;
import io.ebean.SqlQuery;
import io.ebean.SqlRow;
import io.ebean.SqlUpdate;
import io.ebean.Transaction;
import java.math.BigDecimal;
import java.sql.Date;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public final class DatabaseReorganize {
    private DatabaseReorganize() {
    }

    public static String doIt() {
        return DatabaseReorganize.mergeAccounts();
    }

    private static String mergeAccounts() {
        StringBuffer b = new StringBuffer();
        HashMap<String, List<Account>> accounts = new HashMap<String, List<Account>>();
        for (Account a : DB.find(Account.class).findList()) {
            Integer id = a.getBank().getBankId();
            if (a.getIban() != null && a.getCurrency() != null) {
                DatabaseReorganize.addAccount("key1_" + id + "_" + a.getIban() + "_" + a.getCurrency(), a, accounts);
            }
            if (a.getGermanAccountNumber() != null && a.getGermanBankCode() != null && a.getCurrency() != null) {
                DatabaseReorganize.addAccount("key2_" + id + "_" + a.getGermanBankCode() + "_" + a.getGermanAccountNumber() + "_" + a.getCurrency(), a, accounts);
            }
            if (a.getFrenchBankCode() != null && a.getFrenchBranchCode() != null && a.getFrenchAccountNumber() != null && a.getFrenchCheckCode() != null && a.getCurrency() != null) {
                DatabaseReorganize.addAccount("key3_" + id + "_" + a.getFrenchBankCode() + "_" + a.getFrenchBranchCode() + "_" + a.getFrenchAccountNumber() + "_" + a.getFrenchCheckCode() + "_" + a.getCurrency(), a, accounts);
            }
            if (a.getNationalBankCode() == null || a.getNationalAccountNumber() == null || a.getCurrency() == null) continue;
            DatabaseReorganize.addAccount("key4_" + id + "_" + a.getNationalBankCode() + "_" + a.getNationalAccountNumber() + "_" + a.getCurrency(), a, accounts);
        }
        ArrayList<Account> removedAccounts = new ArrayList<Account>();
        for (List<Account> list : accounts.values()) {
            if (list.size() <= 1) continue;
            list.removeAll(removedAccounts);
            if (list.size() <= 1) continue;
            boolean first = true;
            for (Account a : list) {
                if (!first) {
                    b.append(", ");
                }
                b.append(Account.getDefaultDisplayName(a));
                first = false;
            }
            b.append("\n");
            list = DatabaseReorganize.mergeAccounts(list);
            removedAccounts.addAll(list);
        }
        return b.toString();
    }

    private static void addAccount(String key, Account a, HashMap<String, List<Account>> accounts) {
        List<Account> l = accounts.get(key);
        if (l == null) {
            l = new ArrayList<Account>();
            accounts.put(key, l);
        }
        l.add(a);
    }

    public static List<Account> mergeAccounts(List<Account> list) {
        try (Transaction t = DB.beginTransaction();){
            Account winner = list.remove(0);
            for (Account a : list) {
                List<Integer> accountPermissionIds;
                winner.setAccountHolder(DatabaseReorganize.get(winner.getAccountHolder(), a.getAccountHolder()));
                winner.setBic(DatabaseReorganize.get(winner.getBic(), a.getBic()));
                winner.setCmIdentification(DatabaseReorganize.get(winner.getCmIdentification(), a.getCmIdentification()));
                winner.setCreditLimit(DatabaseReorganize.get(winner.getCreditLimit(), a.getCreditLimit()));
                winner.setCurrency(DatabaseReorganize.get(winner.getCurrency(), a.getCurrency()));
                winner.setDescription(DatabaseReorganize.get(winner.getDescription(), a.getDescription()));
                winner.setFolder(DatabaseReorganize.get(winner.getFolder(), a.getFolder()));
                winner.setFrenchAccountNumber(DatabaseReorganize.get(winner.getFrenchAccountNumber(), a.getFrenchAccountNumber()));
                winner.setFrenchBankCode(DatabaseReorganize.get(winner.getFrenchBankCode(), a.getFrenchBankCode()));
                winner.setFrenchBranchCode(DatabaseReorganize.get(winner.getFrenchBranchCode(), a.getFrenchBranchCode()));
                winner.setFrenchCheckCode(DatabaseReorganize.get(winner.getFrenchCheckCode(), a.getFrenchCheckCode()));
                winner.setGermanAccountNumber(DatabaseReorganize.get(winner.getGermanAccountNumber(), a.getGermanAccountNumber()));
                winner.setGermanBankCode(DatabaseReorganize.get(winner.getGermanBankCode(), a.getGermanBankCode()));
                winner.setIban(DatabaseReorganize.get(winner.getIban(), a.getIban()));
                winner.setIgnoreAccountInformation(DatabaseReorganize.get(winner.getIgnoreAccountInformation(), a.getIgnoreAccountInformation()));
                winner.setName(DatabaseReorganize.get(winner.getName(), a.getName()));
                winner.setNationalAccountNumber(DatabaseReorganize.get(winner.getNationalAccountNumber(), a.getNationalAccountNumber()));
                winner.setNationalBankCode(DatabaseReorganize.get(winner.getNationalBankCode(), a.getNationalBankCode()));
                if (Account.Type.HTD.equals((Object)a.getType())) {
                    winner.setType(a.getType());
                }
                winner.setUseVirtualBalances(DatabaseReorganize.get(winner.getUseVirtualBalances(), a.getUseVirtualBalances()));
                winner.setVirtualStartBalance(DatabaseReorganize.get(winner.getVirtualStartBalance(), a.getVirtualStartBalance()));
                winner.setVirtualStartDate(DatabaseReorganize.get(winner.getVirtualStartDate(), a.getVirtualStartDate()));
                winner.save();
                SqlUpdate q = null;
                List<Integer> bankUserIds = DatabaseReorganize.getBankUserIds("account_permission", winner.getId());
                if (bankUserIds != null && !bankUserIds.isEmpty() && (accountPermissionIds = DatabaseReorganize.getAccountPermissionIds(a.getId(), bankUserIds)) != null && !accountPermissionIds.isEmpty()) {
                    q = DB.sqlUpdate("DELETE FROM user_permission WHERE account_permission_id IN (:apids)");
                    q.setParameter("apids", accountPermissionIds);
                    q.execute();
                    q = DB.sqlUpdate("DELETE FROM account_permission WHERE id IN (:apids)");
                    q.setParameter("apids", accountPermissionIds);
                    q.execute();
                }
                q = DB.sqlUpdate("UPDATE account_permission SET account_id=:newid WHERE account_id=:oldid");
                q.setParameter("oldid", (Object)a.getId());
                q.setParameter("newid", (Object)winner.getId());
                q.execute();
                q = DB.sqlUpdate("DELETE FROM user_effective_permission WHERE account_id=:oldid");
                q.setParameter("oldid", (Object)a.getId());
                q.execute();
                bankUserIds = DatabaseReorganize.getBankUserIds("ap_overwrite", winner.getId());
                if (bankUserIds != null && !bankUserIds.isEmpty()) {
                    q = DB.sqlUpdate("DELETE FROM ap_overwrite WHERE (account_id=:oldid AND bank_user_id IN (:bankuserids))");
                    q.setParameter("oldid", (Object)a.getId());
                    q.setParameter("bankuserids", bankUserIds);
                    q.execute();
                }
                DatabaseReorganize.updateTable("ap_overwrite", a.getId(), winner.getId());
                DatabaseReorganize.updateTable("cm_balance", a.getId(), winner.getId());
                DatabaseReorganize.updateTable("cm_balance2", a.getId(), winner.getId());
                DatabaseReorganize.updateTable("cm_booking", a.getId(), winner.getId());
                DatabaseReorganize.updateTable("cm_pdf_statement", a.getId(), winner.getId());
                DatabaseReorganize.updateTable("cm_statement", a.getId(), winner.getId());
                DatabaseReorganize.updateTable("pmt_open", a.getId(), winner.getId());
                DatabaseReorganize.updateTable("pmt_originator", "default_account_id", a.getId(), winner.getId());
                DatabaseReorganize.updateTable("pmt_template", a.getId(), winner.getId());
                DatabaseReorganize.updateTable("pmt_periodic", a.getId(), winner.getId());
                DatabaseReorganize.updateTable("pmt_signed", a.getId(), winner.getId());
                DatabaseReorganize.updateTable("send_filter", a.getId(), winner.getId());
                DatabaseReorganize.updateMappingTable("automatic_export_account", a.getId(), winner.getId(), "automatic_export_id");
                DatabaseReorganize.updateMappingTable("cm_value_group_account", a.getId(), winner.getId(), "cm_value_group_id");
                DatabaseReorganize.updateMappingTable("export_file_account", a.getId(), winner.getId(), "export_file_id");
                DatabaseReorganize.updateMappingTable("send_item_account", a.getId(), winner.getId(), "send_item_id");
                DatabaseReorganize.updateMappingTable("ds_order_details_account", a.getId(), winner.getId(), "ds_order_details_id");
                DB.delete(a);
            }
            t.commit();
        }
        return list;
    }

    private static void updateTable(String tableName, Integer old, Integer winner) {
        DatabaseReorganize.updateTable(tableName, "account_id", old, winner);
    }

    private static void updateTable(String tableName, String columnName, Integer old, Integer winner) {
        SqlUpdate q = DB.sqlUpdate("UPDATE " + tableName + " SET " + columnName + "=:newid WHERE " + columnName + "=:oldid");
        q.setParameter("oldid", (Object)old);
        q.setParameter("newid", (Object)winner);
        q.execute();
    }

    private static void updateMappingTable(String tableName, Integer old, Integer winner, String otherKey) {
        SqlQuery query = DB.sqlQuery("SELECT " + otherKey + " FROM " + tableName + " WHERE account_id=:newid");
        query.setParameter("newid", (Object)winner);
        List sqlRows = query.findList();
        if (!sqlRows.isEmpty()) {
            ArrayList<Integer> list = new ArrayList<Integer>();
            for (SqlRow row : sqlRows) {
                list.add(row.getInteger(otherKey));
            }
            SqlUpdate q = DB.sqlUpdate("DELETE FROM " + tableName + " WHERE account_id=:oldid and " + otherKey + " in (:otherId)");
            q.setParameter("oldid", (Object)old);
            q.setParameter("otherId", list);
            q.execute();
        }
        DatabaseReorganize.updateTable(tableName, old, winner);
    }

    private static Date get(Date winner, Date looser) {
        if (winner == null) {
            return looser;
        }
        return winner;
    }

    private static Boolean get(Boolean winner, Boolean looser) {
        if (winner == null) {
            return looser;
        }
        return winner;
    }

    private static CmFolder get(CmFolder winner, CmFolder looser) {
        if (winner == null) {
            return looser;
        }
        return winner;
    }

    private static BigDecimal get(BigDecimal winner, BigDecimal looser) {
        if (winner == null) {
            return looser;
        }
        return winner;
    }

    private static String get(String winner, String looser) {
        if (winner == null || winner.length() == 0) {
            return looser;
        }
        return winner;
    }

    private static List<Integer> getBankUserIds(String table, Integer newId) {
        SqlQuery q = DB.sqlQuery("SELECT bank_user_id FROM " + table + " WHERE account_id=:newid");
        q.setParameter("newid", (Object)newId);
        ArrayList<Integer> ids = new ArrayList<Integer>();
        for (SqlRow r : q.findList()) {
            ids.add(r.getInteger("bank_user_id"));
        }
        return ids;
    }

    private static List<Integer> getAccountPermissionIds(Integer oldId, List<Integer> bankUserIds) {
        SqlQuery q = DB.sqlQuery("SELECT id FROM account_permission WHERE (account_id=:oldid AND bank_user_id IN (:bankuserids))");
        q.setParameter("oldid", (Object)oldId);
        q.setParameter("bankuserids", bankUserIds);
        ArrayList<Integer> ids = new ArrayList<Integer>();
        for (SqlRow r : q.findList()) {
            ids.add(r.getInteger("id"));
        }
        return ids;
    }
}

