/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.database.api;

import de.businesslogics.banking.database.DatabaseUpdateRunner;
import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.api.JdbcSettings;
import de.businesslogics.banking.database.vo.ApplicationInfo;
import de.businesslogics.persistence.DBType;
import io.ebean.Database;
import io.ebean.DatabaseFactory;
import io.ebean.Transaction;
import io.ebean.config.DatabaseConfig;
import io.ebean.config.TableName;
import io.ebean.config.dbplatform.IdType;
import io.ebeaninternal.api.SpiEbeanServer;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedHashMap;

public abstract class DatabaseConnection {
    protected static DatabaseConnection connection;
    protected static DatabaseConnection readonlyConnection;
    protected DBType dbType;
    protected final JdbcSettings jdbcSettings;
    private final DatabaseConfig serverConfig;
    private final Database server;

    public static DatabaseConnection getInstance() {
        return connection;
    }

    public static String getDatabaseType() {
        return DatabaseConnection.connection.dbType.toString();
    }

    public static String getDatabaseSchema() {
        return DatabaseConnection.connection.jdbcSettings.getSchema();
    }

    public static void shutdown() {
        if (connection != null) {
            DatabaseConnection.connection.server.shutdown(true, false);
            connection = null;
        }
        if (readonlyConnection != null) {
            DatabaseConnection.readonlyConnection.server.shutdown(true, false);
            readonlyConnection = null;
        }
    }

    public static Database createNewEbeanServer(JdbcSettings jdbc) {
        DatabaseConfig serverConfig = DatabaseConnection.initEbeanServerConfig("blnew", jdbc, false);
        for (Class entityClass : DatabaseConnection.getInstance().getServerConfig().getClasses()) {
            serverConfig.addClass(entityClass);
        }
        return DatabaseFactory.create((DatabaseConfig)serverConfig);
    }

    protected DatabaseConnection(File workspaceDir) throws IOException {
        File propertiesFile = new File(workspaceDir, "jdbc.properties");
        if (propertiesFile.exists()) {
            this.jdbcSettings = new JdbcSettings(workspaceDir);
        } else {
            this.jdbcSettings = this.createDefaultSettings(workspaceDir);
            this.jdbcSettings.storeSettings();
        }
        this.serverConfig = DatabaseConnection.initEbeanServerConfig("bl", this.jdbcSettings, true);
        this.registerEntityClasses(this.serverConfig);
        this.server = DatabaseFactory.create((DatabaseConfig)this.serverConfig);
        File readonlyFile = new File(workspaceDir, "jdbc.readonly.properties");
        if (readonlyFile.isFile()) {
            JdbcSettings readonlySettings = new JdbcSettings(workspaceDir, readonlyFile);
            DatabaseConfig readonlyServerConfig = DatabaseConnection.initEbeanServerReadonlyConfig(readonlySettings);
            this.registerEntityClasses(readonlyServerConfig);
            DatabaseFactory.create((DatabaseConfig)readonlyServerConfig);
            DB.USE_READONLY_DB = true;
            System.out.println("Using a readonly-database connection to speed up.");
        } else {
            DB.USE_READONLY_DB = false;
            System.out.println("Not using a readonly-database connection.");
        }
    }

    public Database getServer() {
        return this.server;
    }

    public void setDbType(DBType dbType) {
        this.dbType = dbType;
    }

    public DBType getDbType() {
        return this.dbType;
    }

    protected abstract JdbcSettings createDefaultSettings(File var1) throws IOException;

    protected JdbcSettings getDefaultDataSourceConfig(File workspace, boolean useAutoServer) {
        StringBuilder urlBuilder = new StringBuilder("jdbc:h2:");
        urlBuilder.append("${workspace_loc}/bl");
        if (useAutoServer) {
            urlBuilder.append(";AUTO_SERVER=true;AUTO_SERVER_PORT=9090");
        }
        urlBuilder.append(";MVCC=true;IGNORECASE=true");
        return new JdbcSettings(workspace, DBType.H2, urlBuilder.toString(), "bl", "_bl_");
    }

    private static DatabaseConfig initEbeanServerConfig(String name, JdbcSettings jdbcSettings, boolean defaultServer) {
        DatabaseConfig serverConfig = new DatabaseConfig();
        serverConfig.loadFromProperties(jdbcSettings.getEbeanProperties());
        serverConfig.setName(name);
        serverConfig.setDdlGenerate(false);
        serverConfig.setDdlRun(false);
        serverConfig.setDefaultServer(defaultServer);
        serverConfig.setRegister(true);
        serverConfig.setResourceDirectory(".");
        if (jdbcSettings.getJdbcUrl().startsWith("jdbc:h2:") || jdbcSettings.getJdbcUrl().startsWith("jdbc:oracle")) {
            serverConfig.setIdType(IdType.SEQUENCE);
        } else if (jdbcSettings.getJdbcUrl().startsWith("jdbc:sqlserver:")) {
            serverConfig.setDatabasePlatformName("sqlserver16");
        }
        return serverConfig;
    }

    private static DatabaseConfig initEbeanServerReadonlyConfig(JdbcSettings jdbcSettings) {
        return DatabaseConnection.initEbeanServerConfig("readonly", jdbcSettings, false);
    }

    public DatabaseConfig getServerConfig() {
        return this.serverConfig;
    }

    public void switchIdentityInsert(Class<?> entityClass, boolean enable) throws SQLException {
        if (this.dbType != DBType.MSSQL || entityClass == ApplicationInfo.class) {
            return;
        }
        StringBuilder queryBuilder = new StringBuilder("SET IDENTITY_INSERT ").append(this.getTableName(entityClass));
        if (enable) {
            queryBuilder.append(" ON");
        } else {
            queryBuilder.append(" OFF");
        }
        try (Transaction t = DB.beginTransaction();){
            Statement stmt = t.connection().createStatement();
            stmt.execute(queryBuilder.toString());
            t.commit();
        }
    }

    public String getTableName(Class<?> entityClass) {
        return this.serverConfig.getNamingConvention().getTableName(entityClass).getQualifiedName();
    }

    public static String getM2MJoinTableName(Database server, Class<?> lhsClass, Class<?> rhsClass) {
        DatabaseConfig config = ((SpiEbeanServer)server).config();
        TableName lhsTable = config.getNamingConvention().getTableName(lhsClass);
        TableName rhsTable = config.getNamingConvention().getTableName(rhsClass);
        return config.getNamingConvention().getM2MJoinTableName(lhsTable, rhsTable).getQualifiedName();
    }

    public static String getTableName(Database server, Class<?> entityClass) {
        DatabaseConfig config = ((SpiEbeanServer)server).config();
        return config.getNamingConvention().getTableName(entityClass).getQualifiedName();
    }

    public void doUpdates(DatabaseUpdateRunner runner) throws SQLException {
        DBType dbType = runner.checkDatabaseConnection(this.getServer(), null, DatabaseConnection.connection.jdbcSettings.getSchema());
        DatabaseConnection.getInstance().setDbType(dbType);
        LinkedHashMap<Integer, String> updateMap = runner.findDatabaseUpdateScripts(this.getServer(), dbType);
        for (Integer version : updateMap.keySet()) {
            runner.executeUpdate(this.getServer(), dbType, DatabaseConnection.connection.jdbcSettings.getSchema(), (String)updateMap.get(version), version);
        }
    }

    protected abstract void registerEntityClasses(DatabaseConfig var1);
}

